/**
 * ministd provides the good old main function (with argv and argc) to programs.
 * Unfortunately, argc and argv are not passed along nicely at program startup, but they are just pushed to the stack.
 * So we need the stack pointer at startup in a reliable way.
 * (There are some C hacks we could do, but they all amount to undefined behavior, so I decided this is better.)
 */

.global _start
// defined in stdlib.c
.extern start

.text

_start:
    addi.d $a0, $sp, 0
    // no need to call or anything, we will never return anyways, a simple branch will do.
    b start
