/**
 * Syscall wrapper functions.
 * On riscv64 syscall arguments are passed in a0, ..., a5 (or maybe even a6, I don't know).
 * This is exactly the same as the first few function arguments!
 * And since we invoke these wrappers in a clever way, all that must be done is put the syscall number into x8.
 * The syscall number is passed as last argument to the __syscall_n functions, so the register it is in depends on the number of syscall arguments.
 * To invoke a syscall, linux loongarch64 expects the use of the syscall instruction with immediate 0.
 */

.global __syscall_1
.global __syscall_2
.global __syscall_3
.global __syscall_4
.global __syscall_5
.global __syscall_6

.text

__syscall_1:
    mov x8, x1
    svc #0
    ret

__syscall_2:
    mov x8, x2
    svc #0
    ret

__syscall_3:
    mov x8, x3
    svc #0
    ret

__syscall_4:
    mov x8, x4
    svc #0
    ret

__syscall_5:
    mov x8, x5
    svc #0
    ret

__syscall_6:
    mov x8, x6
    svc #0
    ret
