#ifndef AARCH64_SIGNAL_H
#define AARCH64_SIGNAL_H

/* #define _SYS_TIME_H 1 */
/* #define _SYS_PROCFS_H 1 */
/* #define __timeval_defined 1 */
/* #include <ucontext.h> */

// defined later in generic signal.h (or never).
// however, need to be declared here already!
struct sigstack;
struct sigset;
struct siginfo;

// TODO
struct sigaction {
    union {
        void (*sa_handler)(int);
        void (*sa_sigaction) (int, struct siginfo*, void *);
    }  __sigaction_handler;

    #define sa_handler __sigaction_handler.sa_handler
    #define sa_sigaction __sigaction_handler.sa_sigaction

    uint64_t sa_flags;
    struct sigset sa_mask;
    void (*sa_restorer) (void);
};

struct mcontext
  {
    unsigned long long int fault_address;
    unsigned long long int regs[31];
    unsigned long long int sp;
    unsigned long long int pc;
    unsigned long long int pstate;
  };

/* Userlevel context.  */
struct ucontext
  {
    unsigned long uc_flags;
    struct ucontext_t *uc_link;
    struct sigstack uc_stack;
    struct sigset uc_sigmask;
    struct mcontext uc_mcontext;
  };

/* struct mcontext { */
/*     uint64_t __pc; */
/*     uint64_t __gregs[31]; */
/*     uint64_t __flags; */
/*     uint64_t __extcontext[0] __attribute__((__aligned__(16))); */
/* }; */

/* struct ucontext { */
/*     uint64_t __uc_flags; */
/*     struct ucontext_t *uc_link; */
/*     struct sigstack uc_stack; */
/*     struct sigset uc_sigmask; */
/*     struct mcontext uc_mcontext; */
/* }; */

/* #define SIG_PC(x) (((struct ucontext*)x)->uc_mcontext.__pc) */
#define SIG_PC(x) (((struct ucontext*)x)->uc_mcontext.pc)
/* #define SIG_GPS(x) (((struct ucontext*)x)->uc_mcontext.__gregs) */
/* #define SIG_GPS_COUNT(x) 32 */
/* // TODO: this is not really the floating point flags! */
/* #define SIG_FLAGS(x) (((struct ucontext*)x)->uc_mcontext.__flags) */

#endif /* AARCH64_SIGNAL_H */
