#ifndef ALARM_H
#define ALARM_H

#include "arch_int_types.h"

struct timeval {
    int64_t tv_sec;
    int64_t tv_usec;
};

struct itimerval {
    struct timeval it_interval;
    struct timeval it_value;
};

// tells the kernel to send a SIGALRM in usecs microseconds.
// Can be "disarmed" by calling again with 0.
// Calling again will replace previous value (e.g., if SIGALRM would be sent in 10us. but ualarm is called with 500, it will now be delivered in 500us.)
int ualarm(uint64_t usecs);

#endif /* ALARM_H */
