#include "alarm.h"

#include "syscall.h"

#define ITIMER_REAL 0

int ualarm(uint64_t micros) {
    struct itimerval interval;
    interval.it_interval.tv_sec = 0;
    interval.it_interval.tv_usec = 0;
    interval.it_value.tv_sec = micros / 1000000lu;
    interval.it_value.tv_usec = micros % 1000000lu;
    return sys_setitimer(ITIMER_REAL, &interval, (void*)0);
}
