#ifndef ARCH_LOADER_H
#define ARCH_LOADER_H
#include <stdlib.h>
#include <signal.h>
#define PAGE_SIZE (4096)
struct __attribute__((packed)) register_state {
    // 8 "new" registers (r8 - r15) and 8 general purpose registers that exist since forever (rax, etc.)
    uint64_t gp_registers[16];
    // program counter is called "RIP" on x86_64
    uint64_t rip;
};
void arch_check_registers(struct register_state* registers_before);
void arch_setup_registers(struct register_state* registers_before);
void arch_store_registers(int signo, struct siginfo* info, void* ucontext, struct register_state* state);
uint64_t arch_get_crash_address(int signo, struct siginfo* info, void* ucontext);
void wrap_main(int argc, char** argv, void* stack);
#endif /* ARCH_LOADER_H */
