#include "arch_runner.h"
void arch_check_registers(struct register_state* registers_before){
    if(*(uint32_t*)registers_before->rip != 0x407f8b48 /* mov rdi, [rdi + 0x40] */) {
        writef(stderr, "x86_64 requires an additional instruction 0x407f8b48 (mov rdi, [rdi + 0x40])\n");
        exit(-1);
    }
}
void arch_store_registers(int signo, struct siginfo* info, void* ucontext, struct register_state* state) {
    memcpy(&state->gp_registers, SIG_GPS(ucontext), 16*sizeof(uint64_t));
    state->rip = SIG_PC(ucontext);
}
uint64_t arch_get_crash_address(int signo, struct siginfo* info, void* ucontext) {
    return (uint64_t) info->_sigfault.si_addr;
}
