#include "difffuzz_runner.S"

// void arch_setup_registers(struct register_state* registers_before);
.global arch_setup_registers

// void arch_store_vector_registers(struct register_state* state);
.global arch_store_vector_registers

//  void wrap_main(int argc, char** argv, void* stack);
.global wrap_main

.extern wrapped_main

arch_setup_registers:
    addi a5, a0, 8

#ifdef FLOATS
    // Reset fcsr to zero
    li t0, 0
    fscsr t0
#endif
#ifdef FLOATS
    LOAD_FP
#endif
#ifdef VECTOR
    LOAD_VEC
#endif
    LOAD_GP

    // address to jump to (pc)
    ld a0, -8(a5)

    // put an instruction barrier here just in case the architecture needs it
    fence.i

    // jump to target address
    // target address must start with
    // ld  a0,    72(a5)
    // ld  a5,   112(a5)
    jalr x0, a0

arch_store_vector_registers:
    mv t0, a5
    addi a5, a0, 8

#ifdef VECTOR
    STORE_VEC
#endif

    mv a5, t0
    ret

wrap_main:
    // set stack pointer to third argument
    mv sp, a2
    // other arguments are still in the correct registers, so we can just branch to main
    la x1, wrapped_main
    jalr x0, x1
