// NOTE: ld a5 needs to be commented out because this runner works a bit differently
// a5 needs to be preserved to load pc

#include "constants.h"

.macro STORE_GP
    sd  ra,     0(a5)
    sd  sp,     8(a5)
    sd  gp,    16(a5)
    sd  tp,    24(a5)
    sd  t0,    32(a5)
    sd  t1,    40(a5)
    sd  t2,    48(a5)
    sd  s0,    56(a5)
    sd  s1,    64(a5)
    sd  a0,    72(a5)
    sd  a1,    80(a5)
    sd  a2,    88(a5)
    sd  a3,    96(a5)
    sd  a4,   104(a5)
    sd  a5,   112(a5)
    sd  a6,   120(a5)
    sd  a7,   128(a5)
    sd  s2,   136(a5)
    sd  s3,   144(a5)
    sd  s4,   152(a5)
    sd  s5,   160(a5)
    sd  s6,   168(a5)
    sd  s7,   176(a5)
    sd  s8,   184(a5)
    sd  s9,   192(a5)
    sd s10,   200(a5)
    sd s11,   208(a5)
    sd  t3,   216(a5)
    sd  t4,   224(a5)
    sd  t5,   232(a5)
    sd  t6,   240(a5)
.endm

.macro STORE_FP
    fsd  f0,   256(a5)
    fsd  f1,   264(a5)
    fsd  f2,   272(a5)
    fsd  f3,   280(a5)
    fsd  f4,   288(a5)
    fsd  f5,   296(a5)
    fsd  f6,   304(a5)
    fsd  f7,   312(a5)
    fsd  f8,   320(a5)
    fsd  f9,   328(a5)
    fsd f10,   336(a5)
    fsd f11,   344(a5)
    fsd f12,   352(a5)
    fsd f13,   360(a5)
    fsd f14,   368(a5)
    fsd f15,   376(a5)
    fsd f16,   384(a5)
    fsd f17,   392(a5)
    fsd f18,   400(a5)
    fsd f19,   408(a5)
    fsd f20,   416(a5)
    fsd f21,   424(a5)
    fsd f22,   432(a5)
    fsd f23,   440(a5)
    fsd f24,   448(a5)
    fsd f25,   456(a5)
    fsd f26,   464(a5)
    fsd f27,   472(a5)
    fsd f28,   480(a5)
    fsd f29,   488(a5)
    fsd f30,   496(a5)
    fsd f31,   504(a5)
.endm

.macro STORE_VEC
    addi a5, a5, 512
    // NOTE: This tries to set the vector reg size but we still introduce diffs
    // if the physical vector reg size is not equal on machines (see comment in runner.c)
    li t0, VEC_REG_SIZE
    vsetvli x0, t0, e8, m1
    vse8.v  v0, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v1, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v2, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v3, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v4, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v5, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v6, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v7, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v8, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v9, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v10, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v11, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v12, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v13, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v14, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v15, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v16, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v17, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v18, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v19, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v20, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v21, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v22, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v23, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v24, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v25, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v26, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v27, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v28, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v29, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v30, 0(a5)
    addi    a5,   a5, 16
    vse8.v  v31, 0(a5)
    addi    a5,   a5, 16
    addi a5, a5, -512
    addi a5, a5, -512
.endm

.macro SAVE_STATE regs
save_state_\regs\()_\()__COUNTER__:
    la  a5, \regs
    STORE_GP
.endm

.macro SAVE_STATE_EXTENDED regs
save_state_extended_\regs\()_\()__COUNTER__:
    la  a5, \regs
    STORE_GP

#ifdef FLOATS
    STORE_FP

    frcsr t0
    sd t0, 248(a5)
#endif
#ifdef VECTOR
    STORE_VEC
#endif
.endm

.macro SAVE_STATE_VECTOR regs
save_state_vector_\regs\()_\()__COUNTER__:
    la  a5, \regs
    STORE_VEC
.endm

.macro LD_A0
    ld  a0,    72(a5)
.endm
.macro LD_A5
    ld  a5,   112(a5)
.endm
.macro LD_TP
    ld  tp,    24(a5)
.endm

.macro LOAD_GP
    ld  ra,     0(a5)
    ld  sp,     8(a5)
    ld  gp,    16(a5)
    LD_TP
    ld  t0,    32(a5)
    ld  t1,    40(a5)
    ld  t2,    48(a5)
    ld  s0,    56(a5)
    ld  s1,    64(a5)
    LD_A0
    ld  a1,    80(a5)
    ld  a2,    88(a5)
    ld  a3,    96(a5)
    ld  a4,   104(a5)
    ld  a6,   120(a5)
    ld  a7,   128(a5)
    ld  s2,   136(a5)
    ld  s3,   144(a5)
    ld  s4,   152(a5)
    ld  s5,   160(a5)
    ld  s6,   168(a5)
    ld  s7,   176(a5)
    ld  s8,   184(a5)
    ld  s9,   192(a5)
    ld s10,   200(a5)
    ld s11,   208(a5)
    ld  t3,   216(a5)
    ld  t4,   224(a5)
    ld  t5,   232(a5)
    ld  t6,   240(a5)
    // LD_A5
.endm

#ifdef FLOATS
.macro LOAD_FP
    fld  f0,   256(a5)
    fld  f1,   264(a5)
    fld  f2,   272(a5)
    fld  f3,   280(a5)
    fld  f4,   288(a5)
    fld  f5,   296(a5)
    fld  f6,   304(a5)
    fld  f7,   312(a5)
    fld  f8,   320(a5)
    fld  f9,   328(a5)
    fld f10,   336(a5)
    fld f11,   344(a5)
    fld f12,   352(a5)
    fld f13,   360(a5)
    fld f14,   368(a5)
    fld f15,   376(a5)
    fld f16,   384(a5)
    fld f17,   392(a5)
    fld f18,   400(a5)
    fld f19,   408(a5)
    fld f20,   416(a5)
    fld f21,   424(a5)
    fld f22,   432(a5)
    fld f23,   440(a5)
    fld f24,   448(a5)
    fld f25,   456(a5)
    fld f26,   464(a5)
    fld f27,   472(a5)
    fld f28,   480(a5)
    fld f29,   488(a5)
    fld f30,   496(a5)
    fld f31,   504(a5)
.endm
#endif

.macro LOAD_VEC regs
    addi a5, a5, 512
    // NOTE: This tries to set the vector reg size but we still introduce diffs
    // if the physical vector reg size is not equal on machines (see comment in runner.c)
    li t0, VEC_REG_SIZE
    vsetvli x0, t0, e8, m1
    vle8.v  v0, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v1, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v2, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v3, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v4, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v5, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v6, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v7, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v8, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v9, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v10, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v11, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v12, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v13, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v14, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v15, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v16, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v17, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v18, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v19, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v20, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v21, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v22, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v23, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v24, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v25, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v26, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v27, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v28, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v29, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v30, 0(a5)
    addi    a5,   a5, 16
    vle8.v  v31, 0(a5)
    addi    a5,   a5, 16
    addi a5, a5, -512
    addi a5, a5, -512
.endm

.macro RESTORE_STATE regs
restore_state_\regs\()_\()__COUNTER__:
    // TODO: do we want to reset vector too?
#ifdef FLOATS
    // Reset fcsr to zero
    li a5, 0
    fscsr a5
#endif
    la  a5, \regs
    LOAD_GP
.endm

.macro RESTORE_STATE_EXTENDED regs
restore_state_extended_\regs\()_\()__COUNTER__:
#ifdef FLOATS
    // Reset fcsr to zero
    li a5, 0
    fscsr a5
#endif
    la  a5, \regs
#ifdef FLOATS
    LOAD_FP
#endif
#ifdef VECTOR
    LOAD_VEC
#endif
LOAD_GP
.endm

.macro SAVE_META meta
    la a5, \meta
    rdinstret t0
    sd t0, 8(a5)
    rdcycle t0
    sd t0, 0(a5)
.endm

.macro FILL_BREAK
    // 0x100000/2=0x80000
    .rept 0x80000
    ebreak
    .endr
.endm

// TODO: delete stuff in old file but move comments
