#include "constants.h"

typedef uint64_t reg;

struct gp {
    union {
        reg   ra;
        reg   x1;
    };
    union {
        reg   sp;
        reg   x2;
    };
    union {
        reg   gp;
        reg   x3;
    };
    union {
        reg   tp;
        reg   x4;
    };
    union {
        reg   t0;
        reg   x5;
    };
    union {
        reg   t1;
        reg   x6;
    };
    union {
        reg   t2;
        reg   x7;
    };
    union {
        reg   s0;
        reg   fp;
        reg   x8;
    };
    union {
        reg   s1;
        reg   x9;
    };
    union {
        reg   a0;
        reg   x10;
    };
    union {
        reg   a1;
        reg   x11;
    };
    union {
        reg   a2;
        reg   x12;
    };
    union {
        reg   a3;
        reg   x13;
    };
    union {
        reg   a4;
        reg   x14;
    };
    union {
        reg   a5;
        reg   x15;
    };
    union {
        reg   a6;
        reg   x16;
    };
    union {
        reg   a7;
        reg   x17;
    };
    union {
        reg   s2;
        reg   x18;
    };
    union {
        reg   s3;
        reg   x19;
    };
    union {
        reg   s4;
        reg   x20;
    };
    union {
        reg   s5;
        reg   x21;
    };
    union {
        reg   s6;
        reg   x22;
    };
    union {
        reg   s7;
        reg   x23;
    };
    union {
        reg   s8;
        reg   x24;
    };
    union {
        reg   s9;
        reg   x25;
    };
    union {
        reg  s10;
        reg  x26;
    };
    union {
        reg  s11;
        reg  x27;
    };
    union {
        reg   t3;
        reg   x28;
    };
    union {
        reg   t4;
        reg   x29;
    };
    union {
        reg   t5;
        reg   x30;
    };
    union {
        reg   t6;
        reg   x31;
    };
};

union fpv {
    float  flt;
    double dbl;
    uint64_t u;
};

struct fp {
    union {
        union fpv  f0;
        union fpv  ft0;
    };
    union {
        union fpv  f1;
        union fpv  ft1;
    };
    union {
        union fpv  f2;
        union fpv  ft2;
    };
    union {
        union fpv  f3;
        union fpv  ft3;
    };
    union {
        union fpv  f4;
        union fpv  ft4;
    };
    union {
        union fpv  f5;
        union fpv  ft5;
    };
    union {
        union fpv  f6;
        union fpv  ft6;
    };
    union {
        union fpv  f7;
        union fpv  ft7;
    };
    union {
        union fpv  f8;
        union fpv  fs0;
    };
    union {
        union fpv  f9;
        union fpv  fs1;
    };
    union {
        union fpv  f10;
        union fpv  fa0;
    };
    union {
        union fpv  f11;
        union fpv  fa1;
    };
    union {
        union fpv  f12;
        union fpv  fa2;
    };
    union {
        union fpv  f13;
        union fpv  fa3;
    };
    union {
        union fpv  f14;
        union fpv  fa4;
    };
    union {
        union fpv  f15;
        union fpv  fa5;
    };
    union {
        union fpv  f16;
        union fpv  fa6;
    };
    union {
        union fpv  f17;
        union fpv  fa7;
    };
    union {
        union fpv  f18;
        union fpv  fs2;
    };
    union {
        union fpv  f19;
        union fpv  fs3;
    };
    union {
        union fpv  f20;
        union fpv  fs4;
    };
    union {
        union fpv  f21;
        union fpv  fs5;
    };
    union {
        union fpv  f22;
        union fpv  fs6;
    };
    union {
        union fpv  f23;
        union fpv  fs7;
    };
    union {
        union fpv  f24;
        union fpv  fs8;
    };
    union {
        union fpv  f25;
        union fpv  fs9;
    };
    union {
        union fpv  f26;
        union fpv  fs10;
    };
    union {
        union fpv  f27;
        union fpv  fs11;
    };
    union {
        union fpv  f28;
        union fpv  ft8;
    };
    union {
        union fpv  f29;
        union fpv  ft9;
    };
    union {
        union fpv  f30;
        union fpv  ft10;
    };
    union {
        union fpv  f31;
        union fpv  ft11;
    };
};
typedef struct vv {
    uint8_t v[VEC_REG_SIZE];
} vv;
struct vec {
    vv  v0;
    vv  v1;
    vv  v2;
    vv  v3;
    vv  v4;
    vv  v5;
    vv  v6;
    vv  v7;
    vv  v8;
    vv  v9;
    vv v10;
    vv v11;
    vv v12;
    vv v13;
    vv v14;
    vv v15;
    vv v16;
    vv v17;
    vv v18;
    vv v19;
    vv v20;
    vv v21;
    vv v22;
    vv v23;
    vv v24;
    vv v25;
    vv v26;
    vv v27;
    vv v28;
    vv v29;
    vv v30;
    vv v31;
};

struct regs {
    struct gp gp;
    #ifdef FLOATS
    /* https://five-embeddev.com/riscv-isa-manual/latest/f.html */
    reg fcsr;
    struct fp fp;
    #endif
    #ifdef VECTOR
    struct vec vec;
    #endif
};
