#include <stdlib.h>

#include "arch_runner.h"

#include <ucontext.h>

void arch_check_registers(struct register_state* registers_before){
    if(registers_before->pc & 0xffff800000000001ull) {
        writef(stderr, "pc register must be a user address aligned to 2 bytes (is 0x%x)\n", registers_before->pc);
        exit(-1);
    }
    
    // TODO: make sure mapping exists
    uint32_t* ip = (uint32_t*)registers_before->pc;   

    if(ip[0] != 0x7bbc67a8) {
        writef(stderr, "riscv64 requires two additional instructions at pc to restore state: 0x67a8 (ld a0, 72(a5)) and 0x7bbc (ld a5, 112(a5)).\n");
        writef(stderr, "was: 0x%x\n", ip[0]);
        exit(-1);
    }
}

// defined in loader_asm.S
extern void arch_setup_registers(struct register_state* registers_before);

// defined in loader_asm.S
extern void arch_store_vector_registers(struct register_state* state);

void arch_store_registers(int signo, struct siginfo* info, void* ucontext, struct register_state* state) {
    mcontext_t* mcontext = &((ucontext_t *)ucontext)->uc_mcontext;
    state->pc = mcontext->__gregs[0];
    memcpy(&state->regs.gp, &mcontext->__gregs[1], sizeof(state->regs.gp));
    // TODO: fp
    
    // vector registers should not be touched by kernel or our code, so it is fine if we save them here, long after the crash.
    arch_store_vector_registers(state);
}

uint64_t arch_get_crash_address(int signo, struct siginfo* info, void* ucontext) {
    return (uint64_t) info->_sigfault.si_addr;
}

// defined in loader_asm.S
extern  void wrap_main(int argc, char** argv, void* stack);
