#include <stdlib.h>

#include "arch_runner.h"

void arch_check_registers(struct register_state* registers_before){
    if(registers_before->gp_registers[0].x) {
        writef(stderr, "$zero register must be 0 (is 0x%x)!\n", registers_before->gp_registers[0].x);
        exit(-1);
    }
    
    if(registers_before->pc & 0xffff800000000003ull) {
        writef(stderr, "pc register must be a user address aligned to 4 bytes (is 0x%x)\n", registers_before->pc);
        exit(-1);
    }
    
    // TODO: make sure mapping exists
    uint32_t* ip = (uint32_t*)registers_before->pc;   
    
    if(ip[0] != 0x28c0a085 || ip[1] != 0x28c08084) {
        writef(stderr, "loongarch64 requires two additional instructions at pc to restore state: 0x28c0a085 (ld.d $r5, $a0, 40) and 0x28c08084 (ld.d $r4, $a0, 32).\n");
        writef(stderr, "was: 0x%x and 0x%x\n", ip[0], ip[1]);
        exit(-1);
    }
}

// defined in loader_asm.S
extern void arch_setup_registers(struct register_state* registers_before);

// defined in loader_asm.S
extern void arch_store_vector_registers(struct register_state* state);

void arch_store_registers(int signo, struct siginfo* info, void* ucontext, struct register_state* state) {
    memcpy(&state->gp_registers, SIG_GPS(ucontext), 32*sizeof(uint64_t));
    state->pc = SIG_PC(ucontext);
    
    // apparently vector registers are also stored in the struct. TODO: get the offset in a more sensible way
    memcpy(&state->vec_registers, &((uint8_t*)ucontext)[464], 32*sizeof(union vector_register));
    
    // no need to do the below anymore since we can just copy from the provided struct
    // vector registers should not be touched by kernel or our code, so it is fine if we save them here, long after the crash.
    // arch_store_vector_registers(state);
}

uint64_t arch_get_crash_address(int signo, struct siginfo* info, void* ucontext) {
    return (uint64_t) info->_sigfault.si_addr;
}

// defined in loader_asm.S
extern  void wrap_main(int argc, char** argv, void* stack);
