#include "difffuzz_runner.S"

// void arch_setup_registers(struct register_state* registers_before);
.global arch_setup_registers2

// void arch_store_vector_registers(struct register_state* state);
.global arch_store_vector_registers

//  void wrap_main(int argc, char** argv, void* stack);
.global wrap_main

.extern wrapped_main

arch_setup_registers2:
    add x1, x0, #8

#if defined(FLOATS) || defined(VECTOR)
    // Zero out fpsr
    mov x0, #0
    msr fpsr, x0
#endif
#ifdef FLOATS
    LOAD_FP
#endif
#ifdef VECTOR
    LOAD_VEC
#endif
    LOAD_GP

    // address to jump to (pc)
    ldr x0, [x1, #-8]

    // put an instruction barrier here just in case the architecture needs it
    isb

    // jump to target address
    // target address must start with
    // ldr x0,    [x1,  #0]
    // ldr x1,    [x1,  #8]
    br  x0

#ifdef VECTOR
arch_store_vector_registers:
    mov x9, x1
    add x1, x0, #8

    STORE_VEC

    mov x1, x9
    ret
#endif

wrap_main:
    // set stack pointer to third argument
    mov sp, x2
    // other arguments are still in the correct registers, so we can just branch to main
    ldr x9, =wrapped_main
    br x9
