// NOTE: ld x1 needs to be commented out because this runner works a bit differently
// x1 needs to be preserved to load pc

// TODO: stp
.macro STORE_GP
    str x0,    [x1,   #0]
    str x2,    [x1,  #16]
    str x3,    [x1,  #24]
    str x4,    [x1,  #32]
    str x5,    [x1,  #40]
    str x6,    [x1,  #48]
    str x7,    [x1,  #56]
    str x8,    [x1,  #64]
    str x9,    [x1,  #72]
    str x10,   [x1,  #80]
    str x11,   [x1,  #88]
    str x12,   [x1,  #96]
    str x13,   [x1, #104]
    str x14,   [x1, #112]
    str x15,   [x1, #120]
    str x16,   [x1, #128]
    str x17,   [x1, #136]
    str x18,   [x1, #144]
    str x19,   [x1, #152]
    str x20,   [x1, #160]
    str x21,   [x1, #168]
    str x22,   [x1, #176]
    str x23,   [x1, #184]
    str x24,   [x1, #192]
    str x25,   [x1, #200]
    str x26,   [x1, #208]
    str x27,   [x1, #216]
    str x28,   [x1, #224]
    str x29,   [x1, #232]
    str x30,   [x1, #240]
    mov  x0,   sp
    str  x0,   [x1, #248]
.endm

// TODO: are others important?
// nzcv, fpsr, fpcr https://developer.arm.com/documentation/ddi0601/2024-03/AArch64-Registers
// CNTVCT_EL0
// cntfrq_el0
// tpidr_el0
// tpidrro_el0

// TODO: d21 is broken for some reason
.macro STORE_FP
    str  d0,   [x1,  #272]
    str  d1,   [x1,  #280]
    str  d2,   [x1,  #288]
    str  d3,   [x1,  #296]
    str  d4,   [x1,  #304]
    str  d5,   [x1,  #312]
    str  d6,   [x1,  #320]
    str  d7,   [x1,  #328]
    str  d8,   [x1,  #336]
    str  d9,   [x1,  #344]
    str d10,   [x1,  #352]
    str d11,   [x1,  #360]
    str d12,   [x1,  #368]
    str d13,   [x1,  #376]
    str d14,   [x1,  #384]
    str d15,   [x1,  #392]
    str d16,   [x1,  #400]
    str d17,   [x1,  #408]
    str d18,   [x1,  #416]
    str d19,   [x1,  #424]
    str d20,   [x1,  #432]
    str d21,   [x1,  #440]
    str d22,   [x1,  #448]
    str d23,   [x1,  #456]
    str d24,   [x1,  #464]
    str d25,   [x1,  #472]
    str d26,   [x1,  #480]
    str d27,   [x1,  #488]
    str d28,   [x1,  #496]
    str d29,   [x1,  #504]
    str d30,   [x1,  #512]
    str d31,   [x1,  #520]
.endm

.macro STORE_VEC
    add x1, x1, #272
    st1  {v0.16b}, [x1], #16
    st1  {v1.16b}, [x1], #16
    st1  {v2.16b}, [x1], #16
    st1  {v3.16b}, [x1], #16
    st1  {v4.16b}, [x1], #16
    st1  {v5.16b}, [x1], #16
    st1  {v6.16b}, [x1], #16
    st1  {v7.16b}, [x1], #16
    st1  {v8.16b}, [x1], #16
    st1  {v9.16b}, [x1], #16
    st1 {v10.16b}, [x1], #16
    st1 {v11.16b}, [x1], #16
    st1 {v12.16b}, [x1], #16
    st1 {v13.16b}, [x1], #16
    st1 {v14.16b}, [x1], #16
    st1 {v15.16b}, [x1], #16
    st1 {v16.16b}, [x1], #16
    st1 {v17.16b}, [x1], #16
    st1 {v18.16b}, [x1], #16
    st1 {v19.16b}, [x1], #16
    st1 {v20.16b}, [x1], #16
    st1 {v21.16b}, [x1], #16
    st1 {v22.16b}, [x1], #16
    st1 {v23.16b}, [x1], #16
    st1 {v24.16b}, [x1], #16
    st1 {v25.16b}, [x1], #16
    st1 {v26.16b}, [x1], #16
    st1 {v27.16b}, [x1], #16
    st1 {v28.16b}, [x1], #16
    st1 {v29.16b}, [x1], #16
    st1 {v30.16b}, [x1], #16
    st1 {v31.16b}, [x1], #16
    sub x1, x1, #512
    sub x1, x1, #272
.endm

.macro SAVE_STATE regs
save_state_\regs\()_\()__COUNTER__:
    ldr  x1, =\regs
    STORE_GP
.endm

.macro SAVE_STATE_EXTENDED regs
save_state_extended_\regs\()_\()__COUNTER__:
    ldr  x1, =\regs
    STORE_GP

    // pstate
    mrs  x0,   nzcv
    str  x0,   [x1, #256]

#if defined(FLOATS) || defined(VECTOR)
    // fpsr
    mrs  x0,   fpsr
    str  x0,   [x1, #264]
#endif
#ifdef FLOATS
    STORE_FP
#endif
#ifdef VECTOR
    STORE_VEC
#endif
.endm

#ifdef VECTOR
.macro SAVE_STATE_VECTOR regs
save_state_vector_\regs\()_\()__COUNTER__:
    ldr  x1, =\regs
    STORE_VEC
.endm
#endif

.macro LD_X0
    ldr x0,    [x1,  #0]
.endm
.macro LD_X1
    ldr x1,    [x1,  #8]
.endm
.macro LD_X2
    ldr x2,    [x1,  #16]
.endm

.macro LOAD_GP
    ldr  x2,   [x1,  #16]
    ldr  x3,   [x1,  #24]
    ldr  x4,   [x1,  #32]
    ldr  x5,   [x1,  #40]
    ldr  x6,   [x1,  #48]
    ldr  x7,   [x1,  #56]
    ldr  x8,   [x1,  #64]
    ldr  x9,   [x1,  #72]
    ldr x10,   [x1,  #80]
    ldr x11,   [x1,  #88]
    ldr x12,   [x1,  #96]
    ldr x13,   [x1, #104]
    ldr x14,   [x1, #112]
    ldr x15,   [x1, #120]
    ldr x16,   [x1, #128]
    ldr x17,   [x1, #136]
    ldr x18,   [x1, #144]
    ldr x19,   [x1, #152]
    ldr x20,   [x1, #160]
    ldr x21,   [x1, #168]
    ldr x22,   [x1, #176]
    ldr x23,   [x1, #184]
    ldr x24,   [x1, #192]
    ldr x25,   [x1, #200]
    ldr x26,   [x1, #208]
    ldr x27,   [x1, #216]
    ldr x28,   [x1, #224]
    ldr x29,   [x1, #232]
    ldr x30,   [x1, #240]
    ldr  x0,   [x1, #248]
    mov sp, x0
    LD_X0
    // LD_X1
.endm

.macro LOAD_FP
    ldr  d0,   [x1,  #272]
    ldr  d1,   [x1,  #280]
    ldr  d2,   [x1,  #288]
    ldr  d3,   [x1,  #296]
    ldr  d4,   [x1,  #304]
    ldr  d5,   [x1,  #312]
    ldr  d6,   [x1,  #320]
    ldr  d7,   [x1,  #328]
    ldr  d8,   [x1,  #336]
    ldr  d9,   [x1,  #344]
    ldr d10,   [x1,  #352]
    ldr d11,   [x1,  #360]
    ldr d12,   [x1,  #368]
    ldr d13,   [x1,  #376]
    ldr d14,   [x1,  #384]
    ldr d15,   [x1,  #392]
    ldr d16,   [x1,  #400]
    ldr d17,   [x1,  #408]
    ldr d18,   [x1,  #416]
    ldr d19,   [x1,  #424]
    ldr d20,   [x1,  #432]
    ldr d21,   [x1,  #440]
    ldr d22,   [x1,  #448]
    ldr d23,   [x1,  #456]
    ldr d24,   [x1,  #464]
    ldr d25,   [x1,  #472]
    ldr d26,   [x1,  #480]
    ldr d27,   [x1,  #488]
    ldr d28,   [x1,  #496]
    ldr d29,   [x1,  #504]
    ldr d30,   [x1,  #512]
    ldr d31,   [x1,  #520]
.endm

.macro LOAD_VEC
    add x1, x1, #272
    ld1  {v0.16b}, [x1], #16
    ld1  {v1.16b}, [x1], #16
    ld1  {v2.16b}, [x1], #16
    ld1  {v3.16b}, [x1], #16
    ld1  {v4.16b}, [x1], #16
    ld1  {v5.16b}, [x1], #16
    ld1  {v6.16b}, [x1], #16
    ld1  {v7.16b}, [x1], #16
    ld1  {v8.16b}, [x1], #16
    ld1  {v9.16b}, [x1], #16
    ld1 {v10.16b}, [x1], #16
    ld1 {v11.16b}, [x1], #16
    ld1 {v12.16b}, [x1], #16
    ld1 {v13.16b}, [x1], #16
    ld1 {v14.16b}, [x1], #16
    ld1 {v15.16b}, [x1], #16
    ld1 {v16.16b}, [x1], #16
    ld1 {v17.16b}, [x1], #16
    ld1 {v18.16b}, [x1], #16
    ld1 {v19.16b}, [x1], #16
    ld1 {v20.16b}, [x1], #16
    ld1 {v21.16b}, [x1], #16
    ld1 {v22.16b}, [x1], #16
    ld1 {v23.16b}, [x1], #16
    ld1 {v24.16b}, [x1], #16
    ld1 {v25.16b}, [x1], #16
    ld1 {v26.16b}, [x1], #16
    ld1 {v27.16b}, [x1], #16
    ld1 {v28.16b}, [x1], #16
    ld1 {v29.16b}, [x1], #16
    ld1 {v30.16b}, [x1], #16
    ld1 {v31.16b}, [x1], #16
    sub x1, x1, #512
    sub x1, x1, #272
.endm

.macro RESTORE_STATE regs
restore_state_\regs\()_\()__COUNTER__:
    ldr  x1, =\regs
    LOAD_GP
.endm

.macro RESTORE_STATE_EXTENDED regs
restore_state_\regs\()_\()__COUNTER__:
    ldr x1, =\regs
    // Zero out pstate
    // TODO: we currently only set nzcv
    mov x0, #0
    msr nzcv, x0
#if defined(FLOATS) || defined(VECTOR)
    // Zero out fpsr
    msr fpsr, x0
#endif
#ifdef FLOATS
    LOAD_FP
#endif
#ifdef VECTOR
    LOAD_VEC
#endif
    LOAD_GP
.endm

.macro SAVE_META meta
    ldr x1, =\meta
    mrs x0, cntvct_el0
    str x0,   [x1]
.endm

.macro FILL_BREAK
    // Make sure that this is bigger than 1/2 * 1/4 * page size.
    //                                    (we fill twice and the instructions are 4 byte wide)
    .rept 0x800
    brk #0
    .endr
.endm
