#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Copyright 2023 Ulrich Kerzel

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

    _summary_ : Create metadata schema for CHANGEME

    More details
"""


from pybis import Openbis
import os
import sys

import logging

##
## codes for use in other modules
##

def create_CHANGEME_schema(oBis):

    # ##############################################################################################################
    # restricted vocabulary
    # ##############################################################################################################

    logging.debug('--> create controlled vocabulary:')
    voc_ = oBis.new_vocabulary(
        code = '',
        description = '',
        terms = [
             #{'code': '', 'label': '', 'description':'' },
        ]
    )
    try:
        voc_.save()
    except ValueError as e:
        if str(e).find('already exists') :
            logging.debug('Already registered: {}'.format(e))

    # ###############################################################################################################
    # Property Types
    # ###############################################################################################################

    logging.debug('Register property type: ')
    pt_ = oBis.new_property_type(
        code        = '',
        label       = '',
        description = '',
        dataType    = 'CONTROLLEDVOCABULARY',
        vocabulary  =  CHANGEME.code
    )
    try:
        pt_.save()
    except ValueError as e:
        logging.debug('Property type already registered ')    

    #
    #
    #
    logging.debug('Register property type: ')
    pt_ = oBis.new_property_type(
        code        = '',
        label       = '',
        description = '',
        dataType    = 'VARCHAR'
    )
    try:
        pt_.save()
    except ValueError as e:
        logging.debug('Property type already registered ')   

    # #######################################################################################################
    # Objects
    # #######################################################################################################

    logging.debug('Register Object: ')
    code_obj_= ''
    obj_CHANGEME_new = oBis.new_object_type(
        code                = code_obj_,
        generatedCodePrefix = '',
        #description         = '',
        autoGeneratedCode   = True
    )
    try:
        obj_CHANGEME_new.save()
        
    except ValueError as e:
        if str(e).find('already exists') :
            logging.debug('Object type already registered ')  

    obj_CHANGEME = oBis.get_object_type(code_obj_)

    
    obj_CHANGEME.assign_property(prop = ''                       , section = '', ordinal = 1, mandatory = False, showInEditView = True)

    obj_CHANGEME.assign_property(prop = '$NAME'                       , section = 'General', ordinal = 1, mandatory = True , showInEditView = True)
    obj_CHANGEME.assign_property(prop = '$SHOW_IN_PROJECT_OVERVIEW'   , section = 'General', ordinal = 2, mandatory = False, showInEditView = True)
    obj_CHANGEME.assign_property(prop = 'FINISHED_FLAG'               , section = 'General', ordinal = 3, mandatory = False, showInEditView = True)
    obj_CHANGEME.assign_property(prop = 'START_DATE'                  , section = 'General', ordinal = 4, mandatory = True , showInEditView = True)
    obj_CHANGEME.assign_property(prop = 'END_DATE'                    , section = 'General', ordinal = 5, mandatory = False, showInEditView = True)
    obj_CHANGEME.assign_property(prop = 'COMMENTS'                    , section = 'General', ordinal = 6, mandatory = False, showInEditView = True)

    # ################################################################################################
    # Dataset types
    # ################################################################################################
    logging.debug('---->> Register Dataset Types <<-----------')

    logging.debug('Register Dataset Type:')
    ds_CHANGEME_code = ''
    ds_CHANGEME_new = oBis.new_dataset_type(
        code                = ds_CHANGEME_code,       # mandatory
        description         = '',
        mainDataSetPattern  = None,
        mainDataSetPath     = None,
        disallowDeletion    = False,
        validationPlugin    = None
    )
    try:
        ds_CHANGEME_newl_new.save()
    except ValueError as e:
        if str(e).find('already exists') :
            logging.debug('Dataset type already registered ')    

    ds_CHANGEME = oBis.get_dataset_type(ds_CHANGEME_code)

    ##
    ## note: general section should come last, 
    ## it seems that openBIS adds the sections in reverse order to what is done in code here.
    ##
    ds_CHANGEME.assign_property(prop = '$NAME'             , section = 'General', ordinal = 1, mandatory = True , showInEditView = True)
    ds_CHANGEME.assign_property(prop = 'DATE'              , section = 'General', ordinal = 2, mandatory = False, showInEditView = True)
    ds_CHANGEME.assign_property(prop = 'DESCRIPTION'       , section = 'General', ordinal = 3, mandatory = False, showInEditView = True)
    ds_CHANGEME.assign_property(prop = 'COMMENTS'          , section = 'General', ordinal = 4, mandatory = False, showInEditView = True)