#!/usr/bin/env python
# -*- coding: utf-8 -*-


"""
    Copyright 2025 Ulrich Kerzel, Khalil Rejiba

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

    _summary_ : Create metadata schema for Energy Dispersive Spectroscopy

"""


from pybis import Openbis
from schema_helpers import *


# openBIS codes for the objects (also used in other modules)

code_ds_eds_data = "EDS_DATA"


def create_eds_schema(oBis: Openbis):
    """Creates EDS/EDX Dataset Type.

        We create "empty" types so that data can be uploaded to the correct place.
        Once parsers are developed, we update the properties.

    Args:
        oBis (pybis.Openbis): OpenBIS python object.
    """
    # #########################################################################
    # Controlled Vocabularies
    # #########################################################################

    # terms_CHANGEME =[
    #     {'code': '', 'label': '', 'description': ''},
    # ]
    # voc_CHANGEME = oBis.new_vocabulary(
    #     code = '',
    #     description = '',
    #     terms = terms_CHANGEME,
    # )
    # register_controlled_vocabulary(oBis, voc_CHANGEME, terms_CHANGEME)

    # #########################################################################
    # Property Types
    # #########################################################################

    # pt_CHANGEME = oBis.new_property_type(
    #     code = '',
    #     label = '',
    #     description = '',
    #     dataType = 'CONTROLLEDVOCABULARY',
    #     vocabulary = voc_CHANGEME.code,
    # )
    # register_property_type(oBis, pt_CHANGEME)

    # pt_CHANGEME = oBis.new_property_type(
    #     code = '',
    #     label = '',
    #     description = '',
    #     dataType = 'VARCHAR',
    # )
    # register_property_type(oBis, pt_CHANGEME)

    # #########################################################################
    # Objects
    # #########################################################################

    # code_obj_CHANGEME = ''
    # obj_CHANGEME = oBis.new_object_type(
    #     code = code_obj_CHANGEME,
    #     generatedCodePrefix = '',
    #     autoGeneratedCode = True,
    # )
    # register_object_type(oBis, obj_CHANGEME)
    
    # obj_CHANGEME = oBis.get_object_type(code_obj_CHANGEME)
    # obj_CHANGEME.description = ''
    # register_object_type(oBis, obj_CHANGEME)

    # obj_CHANGEME = oBis.get_object_type(code_obj_CHANGEME)

    # # Define display order
    # sec2props = {
    #     'General': [
    #         ('$NAME', 1, None), ('$SHOW_IN_PROJECT_OVERVIEW', 0, None),
    #         ('FINISHED_FLAG', 0, None), ('START_DATE', 0, None), ('END_DATE', 0, None),
    #         ('COMMENTS', 0, None),
    #     ],
    #     'Section Name': [
    #         ('PROPERTY_CODE', is_mandatory, plugin),
    #     ],
    # }
    # assign_property_types(obj_CHANGEME, sec2props)

    # #########################################################################
    # Dataset Types
    # #########################################################################

    ds_eds_data = oBis.new_dataset_type(
        code=code_ds_eds_data,
        description="Data from Energy Dispersive Spectroscopy (EDS/EDX)",
        mainDataSetPattern=None,
        mainDataSetPath=None,
        disallowDeletion=False,
        validationPlugin=None,
    )
    register_dataset_type(oBis, ds_eds_data)

    ds_eds_data = oBis.get_dataset_type(code_ds_eds_data)

    # Define display order

    sec2props = {
        "General": [
            ("$NAME", 1, None),
            ("DATE", 0, None),
            ("COMMENTS", 0, None),
            ("S3_DOWNLOAD_LINK", 0, None),  # Download Link -> automatic script
        ],
        "Details": [
            ("ACCELERATING_VOLTAGE", 0, None),
            ("SOFTWAREVERSION", 0, None),
            ("PROJECT_NAME", 0, None),
            ("SAMPLE_NAME", 0, None),
            ("NUM_SAMPLES", 0, None),
            ("AREA_NAME", 0, None),
            ("NUM_AREAS", 0, None),
        ],
    }
    assign_property_types(ds_eds_data, sec2props)
