def get_elements(e):
    """Returns a list of comma-seperated elements contained in a sample with atomic percentages.
    Sorts by weight percentage, and alphabetically in case of ex aequo.
    """
    MASSES = """
    H:1.008,He:4.0026,Li:6.94,Be:9.0122,B:10.81,C:12.011,N:14.007,O:15.999,
    F:18.998,Ne:20.18,Na:22.99,Mg:24.305,Al:26.982,Si:28.085,P:30.974,S:32.06,
    Cl:35.45,Ar:39.95,K:39.098,Ca:40.078,Sc:44.956,Ti:47.867,V:50.942,Cr:51.996,
    Mn:54.938,Fe:55.845,Co:58.933,Ni:58.693,Cu:63.546,Zn:65.38,Ga:69.723,Ge:72.63,
    As:74.922,Se:78.971,Br:79.904,Kr:83.798,Rb:85.468,Sr:87.62,Y:88.906,Zr:91.224,
    Nb:92.906,Mo:95.95,Tc:97,Ru:101.07,Rh:102.91,Pd:106.42,Ag:107.87,Cd:112.41,
    In:114.82,Sn:118.71,Sb:121.76,Te:127.6,I:126.9,Xe:131.29,Cs:132.91,Ba:137.33,
    La:138.91,Ce:140.12,Pr:140.91,Nd:144.24,Pm:145,Sm:150.36,Eu:151.96,Gd:157.25,
    Tb:158.93,Dy:162.5,Ho:164.93,Er:167.26,Tm:168.93,Yb:173.05,Lu:174.97,Hf:178.49,
    Ta:180.95,W:183.84,Re:186.21,Os:190.23,Ir:192.22,Pt:195.08,Au:196.97,Hg:200.59,
    Tl:204.38,Pb:207.2,Bi:208.98,Po:209,At:210,Rn:222,Fr:223,Ra:226,
    Ac:227,Th:232.04,Pa:231.04,U:238.03,Np:237,Pu:244,Am:243,Bk:247,
    Cf:251,Es:252,Fm:257,Md:258,No:259,Lr:262,Rf:267,Db:268,
    Hs:269,Bh:270,Mt:277,Ds:281,Rg:282,Cn:285,Nh:286,Mc:290,
    Lv:293,Og:294
    """
    atomic_weights = {}
    for kv in "".join(MASSES.split()).split(","):
        key, value = kv.split(":")
        atomic_weights[key] = float(value)
    properties = e.properties()
    if properties is None:
        return "NoElements"
    else:
        element_dict_with_percentages = {}
        for p in properties:
            property_code = p.propertyTypeCode()
            value = p.renderedValue()
            if (
                property_code.startswith("ELEMENT")
                and property_code.count("_") == 1
                and value != "empty"
            ):
                element_dict_with_percentages[property_code] = [value, 0]
        for code, (element_symbol, _) in element_dict_with_percentages.items():
            for p in properties:
                property_code = p.propertyTypeCode()
                value = p.renderedValue()
                if property_code == (code) + "_AT_PERCENT" and value != "empty":
                    element_dict_with_percentages[code][1] = value
        total_weight = 0
        for element, atomic_percent in element_dict_with_percentages.values():
            total_weight += float(atomic_percent) * atomic_weights[element]
        elements_unsorted = []
        for element, atomic_percent in element_dict_with_percentages.values():
            weigth_percent = (
                (float(atomic_percent) * atomic_weights[element]) / total_weight * 100
            )
            elements_unsorted.append([element, weigth_percent])

        # elements_sorted = sorted(elements_unsorted , key=lambda x: (-x[1], x[0]))

        elements_sorted = []
        for atom_symbol, weight_percentage in elements_unsorted:
            intermediate = (-float(weight_percentage), atom_symbol)
            elements_sorted.append(intermediate)
        elements_sorted.sort()

        result = ",".join("%s%.6f" % (x[1], -float(x[0])) for x in elements_sorted)
        return result


def calculate():
    return get_elements(entity)
