def get_num_species(e):
    """Returns the number of chemical species in a material"""
    properties = e.properties()
    if properties is None:
        return 0
    else:
        for p in properties:
            property_code = p.propertyTypeCode()
            value = p.renderedValue()
            if property_code == "CHEMICAL_SYSTEM":
                return value.count("-") + 1
            if property_code == "CHEM_SPECIES_ADDRESSED":
                return value.count(",") + 1
    return 0


def calculate():
    return get_num_species(entity)
