# Initial Setup
To use openBIS in a multi-institutional setting and enable scalable data storage, we use [Coscine](https://about.coscine.de/).  
If you do not need this functionality, please adapt the code accordingly.

## Upload to Coscine / S3
The openBIS framework allows External Data Stores, which must be registered.
```
dms_nfdi = openbis_client.create_external_data_management_system(
    code='S3_NFDI_DEMO_01', 
    label='S3 bucket FOR NFDI MatWerk Demos', 
    address='COSCINE:/RWTH-RDS-S3/NFDI_DEMO',
    address_type='FILE_SYSTEM',
)
```
We use the DMS code in the [S3 configuration files](https://git.rwth-aachen.de/Kerzel/openbistools/-/blob/main/register_linkdata/s3_credentials_demo.cfg?ref_type=heads).  

Users who are allowed to upload to S3 are added to the User Group (`COSCINE_UPLOAD`).  

Read configuration files are uploaded as Datasets to Default Experiments (for example `/CRC1394/CRC1394_COSCINE/CRC1394_COSCINE_CONFIG`).

In addition, we store image previews of non-image data in an S3 bucket (`S3_OPENBIS_CACHE`).  

## Upload to openBIS server
Users who are allowed to upload directly to the openBIS server are added to a specific Space (`IMM`) with `OBSERVER` access.  
