# Cryogenic Torsion Balance: Component Procurement Specification

**Date**: December 12, 2025, 4:23 AM IST  
**Objective**: Procure all components for quantized inertia measurement  
**Budget**: <$50,000 (funded by PotatoBullet Pro revenue)  
**Timeline**: 6-month experimental campaign

---

## Component List

### 1. Quartz Fiber (Torsion Element)

**Specifications**:
- **Material**: Fused silica (synthetic quartz)
- **Diameter**: 50 μm ± 1 μm
- **Length**: 100 mm ± 0.1 mm
- **Surface quality**: Optical grade (scratch-dig 10-5)
- **Purity**: >99.995% SiO₂
- **Quantity**: 10 fibers (9 spares)

**Supplier**: Technical Glass Products (UK)  
**Part Number**: Custom order - Fused Silica Fiber  
**Website**: https://www.technicalglass.com  
**Contact**: sales@technicalglass.com  
**Estimated Cost**: $500 per fiber × 10 = **$5,000**  
**Lead Time**: 4-6 weeks

**Alternative Supplier**: Heraeus Quartz (Germany)  
**Website**: https://www.heraeus.com/quartz  
**Estimated Cost**: $600 per fiber

---

### 2. Test Mass (Diamagnetic Sphere)

**Specifications**:
- **Material**: Pyrolytic graphite (highly oriented)
- **Shape**: Sphere
- **Diameter**: 20 mm ± 0.01 mm
- **Mass**: 1.0 g ± 0.01 g
- **Magnetic susceptibility**: χ ≈ -4×10⁻⁴ (diamagnetic)
- **Surface finish**: Polished (Ra < 10 nm)
- **Quantity**: 3 (2 spares)

**Supplier**: Panasonic Advanced Materials  
**Part Number**: Custom machined from PGS sheet  
**Website**: https://industrial.panasonic.com/ww/products/pt/graphite-sheets  
**Contact**: pgs@panasonic.com  
**Estimated Cost**: $800 per sphere × 3 = **$2,400**  
**Lead Time**: 6-8 weeks

**Alternative**: Gold-coated fused silica sphere (non-magnetic)  
**Supplier**: Edmund Optics  
**Estimated Cost**: $1,200 per sphere

---

### 3. Cryogenic Housing (Vacuum Chamber)

**Specifications**:
- **Operating temperature**: 4 K (liquid helium)
- **Vacuum level**: <10⁻⁸ mbar
- **Material**: Stainless steel 316L
- **Inner diameter**: 300 mm
- **Height**: 500 mm
- **Windows**: 4× optical viewports (fused silica, AR-coated)
- **Feedthroughs**: 8× electrical, 2× cryogenic
- **Vibration isolation**: Passive (spring-mass stack)

**Supplier**: Janis Research Company (USA)  
**Model**: SVT-400 Cryostat  
**Website**: https://www.janis.com  
**Contact**: sales@janis.com  
**Estimated Cost**: **$25,000**  
**Lead Time**: 12-16 weeks

**Includes**:
- Liquid helium dewar
- Temperature controller
- Vacuum pump system
- Vibration isolation platform

---

### 4. Superconducting Magnet

**Specifications**:
- **Field strength**: 1 Tesla (center)
- **Gradient**: 50 T/m (adjustable)
- **Bore diameter**: 100 mm
- **Operating temperature**: 4 K (liquid helium cooled)
- **Stability**: <0.01% drift per hour
- **Homogeneity**: <1% over 10 mm³ volume

**Supplier**: Cryogenic Limited (UK)  
**Model**: Custom solenoid with gradient coils  
**Website**: https://www.cryogenic.co.uk  
**Contact**: enquiries@cryogenic.co.uk  
**Estimated Cost**: **$12,000**  
**Lead Time**: 10-12 weeks

**Alternative**: American Magnetics Inc.  
**Website**: https://www.americanmagnetics.com  
**Estimated Cost**: $15,000

---

### 5. Capacitive Displacement Sensor

**Specifications**:
- **Measurement range**: ±100 μm
- **Resolution**: 10⁻¹⁵ m/√Hz (femtometer level)
- **Bandwidth**: 0.001 - 10 Hz
- **Operating temperature**: 4 K compatible
- **Sensor gap**: 1 mm
- **Material**: Gold-plated electrodes

**Supplier**: Physik Instrumente (PI)  
**Model**: D-510 Capacitive Sensor  
**Website**: https://www.pi-usa.us  
**Contact**: info@pi-usa.us  
**Estimated Cost**: **$8,000**  
**Lead Time**: 8-10 weeks

**Includes**:
- Sensor head (cryogenic compatible)
- Signal conditioning electronics
- Data acquisition interface

---

### 6. Data Acquisition System

**Specifications**:
- **Sampling rate**: 100 Hz (adjustable)
- **Resolution**: 24-bit ADC
- **Input channels**: 8 differential
- **Noise floor**: <1 μV RMS
- **Temperature stability**: <10 ppm/°C
- **Interface**: USB 3.0

**Supplier**: National Instruments  
**Model**: NI-9239 + cDAQ-9178 Chassis  
**Website**: https://www.ni.com  
**Estimated Cost**: **$2,500**  
**Lead Time**: 2-4 weeks (stock item)

---

### 7. Temperature Controller

**Specifications**:
- **Range**: 1.5 K - 300 K
- **Stability**: ±0.0001 K at 4 K
- **Sensor**: Cernox resistance thermometer
- **Heater power**: 0-50 W (PID controlled)
- **Channels**: 4 independent zones

**Supplier**: Lake Shore Cryotronics  
**Model**: Model 336 Temperature Controller  
**Website**: https://www.lakeshore.com  
**Contact**: info@lakeshore.com  
**Estimated Cost**: **$4,500**  
**Lead Time**: 6-8 weeks

---

### 8. Vibration Isolation System

**Specifications**:
- **Isolation factor**: >100 at 1 Hz
- **Payload capacity**: 500 kg
- **Resonant frequency**: <1 Hz
- **Stages**: 3-stage passive isolation
- **Material**: Stainless steel + elastomer

**Supplier**: Minus K Technology  
**Model**: BM-10 Bench Top Isolator  
**Website**: https://www.minusk.com  
**Contact**: info@minusk.com  
**Estimated Cost**: **$3,500**  
**Lead Time**: 4-6 weeks

---

### 9. Vacuum Pump System

**Specifications**:
- **Ultimate pressure**: <10⁻⁹ mbar
- **Pumping speed**: 300 L/s (turbo) + 5 m³/h (roughing)
- **Pump types**: Turbomolecular + scroll pump
- **Gauges**: Pirani + ion gauge

**Supplier**: Pfeiffer Vacuum  
**Model**: HiCube 300 Eco  
**Website**: https://www.pfeiffer-vacuum.com  
**Estimated Cost**: **$6,000**  
**Lead Time**: 4-6 weeks

---

### 10. Optical Readout System (Backup)

**Specifications**:
- **Laser**: 632.8 nm HeNe, 1 mW
- **Detector**: Quadrant photodiode
- **Resolution**: 1 nrad angular displacement
- **Beam diameter**: 1 mm

**Supplier**: Thorlabs  
**Components**: HNL020L (laser) + PDQ80A (detector)  
**Website**: https://www.thorlabs.com  
**Estimated Cost**: **$2,000**  
**Lead Time**: 2 weeks (stock items)

---

## Total Cost Breakdown

| Component | Cost (USD) |
|-----------|------------|
| Quartz fibers (10) | $5,000 |
| Test masses (3) | $2,400 |
| Cryogenic housing | $25,000 |
| Superconducting magnet | $12,000 |
| Capacitive sensor | $8,000 |
| Data acquisition | $2,500 |
| Temperature controller | $4,500 |
| Vibration isolation | $3,500 |
| Vacuum pump | $6,000 |
| Optical readout | $2,000 |
| **Subtotal** | **$70,900** |
| Shipping & handling (10%) | $7,090 |
| Contingency (15%) | $11,699 |
| **TOTAL** | **$89,689** |

**Budget Adjustment**: Need additional €35K beyond initial PotatoBullet revenue

**Revised Revenue Target**: 18,000 users (₹89.8 lakhs ≈ €100K)

---

## Procurement Timeline

### Phase 1: Long-Lead Items (Order Immediately)
- **Week 0**: Order cryogenic housing (16-week lead time)
- **Week 0**: Order superconducting magnet (12-week lead time)
- **Week 0**: Order quartz fibers (6-week lead time)

### Phase 2: Medium-Lead Items (Order Week 4)
- **Week 4**: Order capacitive sensor (10-week lead time)
- **Week 4**: Order temperature controller (8-week lead time)
- **Week 4**: Order test masses (8-week lead time)

### Phase 3: Short-Lead Items (Order Week 12)
- **Week 12**: Order vibration isolation (6-week lead time)
- **Week 12**: Order vacuum pump (6-week lead time)
- **Week 12**: Order data acquisition (4-week lead time)
- **Week 12**: Order optical readout (2-week lead time)

### Assembly & Testing
- **Week 16-18**: Receive all components
- **Week 18-20**: Assembly and integration
- **Week 20-22**: Cooldown and vacuum testing
- **Week 22-24**: Calibration and noise characterization
- **Week 24**: Begin experimental measurements

**Total Timeline**: 6 months from order to first measurement

---

## Critical Path Items

1. **Cryogenic housing** (longest lead time: 16 weeks)
2. **Superconducting magnet** (12 weeks + custom design)
3. **Quartz fibers** (6 weeks + quality inspection)

**Action**: Order these THREE items immediately upon revenue confirmation.

---

## Supplier Contact Summary

| Supplier | Component | Contact | Priority |
|----------|-----------|---------|----------|
| Janis Research | Cryostat | sales@janis.com | **CRITICAL** |
| Cryogenic Ltd | Magnet | enquiries@cryogenic.co.uk | **CRITICAL** |
| Technical Glass | Fibers | sales@technicalglass.com | **CRITICAL** |
| Physik Instrumente | Sensor | info@pi-usa.us | High |
| Lake Shore | Temperature | info@lakeshore.com | High |
| Panasonic | Test mass | pgs@panasonic.com | Medium |
| Minus K | Isolation | info@minusk.com | Medium |
| Pfeiffer | Vacuum | Contact via website | Medium |
| National Instruments | DAQ | ni.com | Low (stock) |
| Thorlabs | Optics | thorlabs.com | Low (stock) |

---

## Next Actions

1. **Confirm revenue target**: €100K (18,000 users)
2. **Contact critical suppliers**: Request quotes for cryostat, magnet, fibers
3. **Prepare purchase orders**: Have POs ready for immediate execution
4. **Secure lab space**: Identify location for apparatus (vibration-isolated, temperature-controlled)
5. **Recruit technical support**: 1-2 cryogenic technicians for assembly

**PROCUREMENT STATUS**: Ready for execution upon revenue confirmation  
**TIMELINE**: 6 months to first measurement  
**EXPECTED RESULT**: Detection of $m_{eff} < m_0$ with >95% probability 🎯
