# Ammonia model

Ammonia is a common fertilizer, and also has the potential to serve as a lower-cost form of hydrogen storage than compressed hydrogen gas. This is typically an energy-intensive process, with the ammonia reactor requiring electricity connected from an electric generator. The primary inputs are hydrogen and air, with the air fed into an air separator to produce nitrogen in an intermediate step, and oxygen as a co-product that is sold to offset opex costs. The ammonia synthesis is highly exothermic, and future versions of this model are planned to connect the generated heat (in the form of steam) to other converters requiring thermal energy as an input. Currently, H2I has two ammonia production models:

1. The 'Simple' Ammonia Model: A model that only uses the ratios of feedstocks to ammonia output as performance parameters. This model is found at `h2integrate/converters/ammonia/simple_ammonia_model.py`. This model is based off of ASPEN modeling performed at Argonne National Lab (ANL) by [Lee et al.](https:/doi.org/10.1039/d2gc00843b), and was orginally developed for H2I by [Reznicek et al.](https://doi.org/10.1016/j.crsus.2025.100338). The cost modeling in this model directly follows the two above studies. One of the plants included in the Reznicek et al study is shown in the example `examples/02_texas_ammonia/`.

2. The Synloop Ammonia Model: This model allows direct stream table measurements (or modeled values) from an ammonia synthesis loop to be used as performance parameters. The cost parameters are largely the same as the simple ammonia model. This model is found at `h2integrate/converters/ammonia/ammonia_synloop.py`. The example in `examples/12_ammonia_synloop/` uses mostly the same parameters as those used by Reznicek et al., but with updated capex values for the air separator and synthesis loop derived from an NETL baseline study of ammonia production by [Brasington et al.](https://doi.org/10.2172/1515254)
