from ConfigV1 import out_dir
from Utils import create_dir

import subprocess

# Define the command
command = [
    "nohup",
    "stdbuf", "-oL", "-eL",
    "nice", "-n", "19",
    "python", "main.py",
]

output = f"{out_dir}/OUTPUT"
error  = f"{out_dir}/ERROR"

create_dir(output)
create_dir(error)

# Define the output and error redirection
with open(f"{output}/UNet.out", "w") as stdout_file, \
     open(f"{error}/UNet.err", "w") as stderr_file:
    # Run the command in the background
    subprocess.Popen(
        command,
        stdout=stdout_file,
        stderr=stderr_file
    )

print(f'\nLOG OUTPUT --> {output}/UNet.out')
print(f'LOG ERROR  --> {error}/UNet.err')

print("Process started in the background.")