#include <stddef.h>

#include "frame/src/cframe.h"

double frame_hamiltonian(CFrameType *fr, double t, double *qp, int n_dim) {
    double v = (fr->energy)(t, (fr->parameters), qp, n_dim, NULL);
    return v;
}

void frame_gradient(CFrameType *fr, double t, double *qp, int n_dim, size_t N, double *dH) {
    (fr->gradient)(t, (fr->parameters), qp, n_dim, N, dH, NULL);
}

void frame_hessian(CFrameType *fr, double t, double *qp, int n_dim, double *d2H) {
    // TODO: not implemented!!
    // TODO: can I just add in the terms from the frame here?
    // (fr->hessian)(t, (fr->parameters), qp, n_dim, d2H);
}
