import numpy as np

filename = "multibeam_topog.bin"
rows, cols = 801, 801

dtype = np.dtype('>f4')

with open(filename, 'rb') as f:
    data = np.fromfile(f, dtype=dtype)

    data = data.reshape((rows, cols))

lon_start = 138.52
dlon      = 2.0e-4    
lon = lon_start + np.arange(cols) * dlon 

lat_start =  34.66
dlat      = 2.0e-4    
lat = lat_start + np.arange(rows) * dlat

for i in range(0,cols):
    for j in range(0,rows):
        print(f"LON, LAT, DEPTH: {lon[i]} {lat[j]} {data[j,i]}")
