
## Introduction

WSIMOD contains a variety of components to represent physical processes.
We recommend viewing the [API](./../reference) for a detailed description of the
models included, however, we provide an overview of documented
components, their assumptions and required input data on this page.




## Component Library
| Component                                                                                        | Assumptions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Data                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
|:-------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [`Catchment`](./../reference-other/#wsimod.nodes.catchment.Catchment)                            | - Flows from `Catchment` nodes are simply read from data, thus assumed to be unresponsive to wider water cycle changes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | - Flow data in the `data_input_dict` at the model timestep. _Units_: cubic metres/timestep<br> - Values for each variable defined in `constants.POLLUTANTS` also stored in `data_input_dict` at the model timestep. _Units_: kg/m3/timestep (additive pollutants)                                                                                                                                                                                                                                                                                                                                                  |
| [`Distribution`](./../reference-other/#wsimod.nodes.distribution.Distribution)                   | - No distribution processes yet represented, this class is just for conveyance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | - None                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [`FWTW`](./../reference-wtw/#wsimod.nodes.wtw.FWTW)                                              | - See `wtw.py/WTW` for treatment.<br> - Stores treated water in a service reservoir tank, with a single tank per `FWTW` node.<br> - Aims to satisfy a throughput that would top up the service reservoirs until full.<br> - Currently, will not allow a deficit, thus introducing water from 'other measures' if pulls cannot fulfil demand. Behaviour under a deficit should be determined and validated before introducing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | - See `wtw.py/WTW` for treatment.<br> - Service reservoir tank `capacity`, `area`, and `datum`. _Units_: cubic metres, squared metres, metres                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`Groundwater`](./../reference-storage/#wsimod.nodes.storage.Groundwater)                        | - Conceptualises groundwater as a tank.<br> - Baseflow is generated following a residence-time method.<br> - Baseflow is sent to `storage.py/River`, `nodes.py/Node` or `waste.py/Waste` nodes.<br> - Infiltration to `sewer.py/Sewer` nodes occurs when the storage in the tank is greater than a specified threshold, at a rate proportional to the sqrt of volume above the threshold. (Note, this behaviour is __not validated__ and a high uncertainty process in general)<br> - If `decays` are provided to model water quality transformations, see `core.py/DecayObj`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | - Groundwater tank `capacity`, `area`, and `datum`. _Units_: cubic metres, squared metres, metres<br> - Infiltration behaviour determined by an `infiltration_threshold` and `infiltration_pct`. _Units_: proportion of capacity<br> - Optional dictionary of decays with pollutants as keys and decay parameters (a constant and a temperature sensitivity exponent) as values. _Units_: -                                                                                                                                                                                                                        |
| [`GrowingSurface`](./../reference-land/#wsimod.nodes.land.GrowingSurface)                        | - In the soil water module, crop stages and crop coefficients control the evapotranspiration.<br> - Fertiliser and manure application are the major source of soil nutrients, which are added into soil nutrient pools, including dissovled inorganic, dissolved organic, fast and humus for both nitrogen and phosphorus.<br> - Nutrient transformation processes in soil are simulated, including fluxes between the soil nutrient pools, denitrification for nitrogen, adsorption/desorption for phosphorus. These processes are affected by temperature and soil moisture.<br> - Crop uptake of nutrients are simulated based on crop stages, which is different for spring-sown and autumn-sown crops.<br> - Soil erosion from the growing surface is simulated as one of the major sources of suspended solids in rivers, which is mainly affected by rainfall energy and crop/ground cover. Phosphorus will also be eroded along with the soil particles, in both adsorbed inorganic and humus form.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | - `data_input_dict` can contain a variety of pollutant deposition data. `srp-fertiliser` describes phosphate. `noy-fertiliser` describes nitrogen as nitrates. `nhx-fertiliser` describes nitrogen as ammonia. `srp/noy/ nhx-manure` can also be used to specify manure application. _Units_: kg/m2/timestep (data is read at a monthly timestep)<br> - Rooting depth. _Units_: m<br> - Evapotranspiration depletion factor. _Units_:<br> - Sowing day, harvest day and crop calendars. _Units_: day number in Julian calendar<br> - Crop factor. _Units_:<br> - Initial storage for solid pollutants. _Units_: kg |
| [`Land`](./../reference-land/#wsimod.nodes.land.Land)                                            | - Percolation, surface runoff, and subsurface runoff, can be described with a residence-time method.<br> - Flows to percolation, surface runoff, and subsurface runoff are generated by different hydrological response units (subclasses of `land.py/Surface`), but aggregated for a given land node.<br> - Flows to percolation are distributed to `storage.py/Groundwater` nodes while surface/subsurface runoff to `nodes.py/Node` or `storage.py/River` nodes.<br> - Input data associated with the land node (precipitation, temperature, evapotranspiartion) are the same for every surface.<br> - Water received from `sewer.py/Sewer` objects is sent to the first `land.py/ImperviousSurface` in the surfaces list.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | - Precipitation and evapotranspiration are in the `data_input_dict` at the model timestep. _Units_: metres/timestep<br> - Temperature in the `data_input_dict` at the model timestep. _Units_: C<br> - Residence time of surface, subsurface and percolation flows. _Units_: number of timesteps                                                                                                                                                                                                                                                                                                                   |
| [`Node`](./../reference-nodes/#wsimod.nodes.nodes.Node)                                          | - No physical processes represented, can be used as a junction.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | - All nodes require a `name`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [`NutrientPool`](./../reference-land/#wsimod.nodes.nutrient_pool.NutrientPool)                   | - Four nutrient pools are conceptualised for both nitrogen and phosphorus in soil, which includes humus pool, fast pool, dissolved inorganic pool, and dissolved organic pool. Humus and fast pool represent immobile pool of organic nutrients in the soil with slow and fast turnover, respectively. Dissolved inorganic and organic pool represent nutrients in dissolved phase in soil water (for phosphorus, dissolved organic pool might contain particulate phase). Given that phoshphorus can be adsorbed and attached to soil particles, an adsorbed inorganic pool is created specifically for phosphorus.<br> - The major sources of nutrients to soil are conceptualised as<br> - atmospheric deposition:<br> - dry deposition:<br> - for nitrogen, inorganic fraction of dry deposition is added to the dissovled inorganic pool, while the rest is added to the fast pool;<br> - for phosphorus, all is added to adsorbed inorganic pool.<br> - wet deposition: all is added to the dissolved inorganic pool.<br> - fertilisers: all added to the dissolved inorganic pool.<br> - manure: the inorganic fraction is added to the dissovled inorganic pool, with the rest added to the fast pool.<br> - residue: the part with fast turnover is added to the fast pool, with the rest added to the humus pool.<br> - Nutrient fluxes between these pools are simulated to represent the biochemical processes that can transform the nutrients between different forms. These processes include<br> - degradation of humus pool to fast pool<br> - dissolution of humus pool to dissovled organic pool<br> - mineralisation of fast pool to dissolved inorganic pool<br> - dissolution of fast pool to dissolved organic pool<br> - immobilisation of dissolved inroganic pool to fast pool The rate of these processes are affected by the soil temperature and moisture conditions.<br> - When soil erosion happens, a portion of both the adsorbed inorganic pool and humus pool for phosphorus will be eroded as well. | - fraction_dry_n_to_dissolved_inorganic, fraction_manure_to_dissolved_inorganic, fraction_residue_to_fast. _Units_: -, all should in [0-1]<br> - degrhpar, dishpar, minfpar, disfpar, immobdpar. _Units_: -, all should in [0-1]                                                                                                                                                                                                                                                                                                                                                                                   |
| [`PerviousSurface`](./../reference-land/#wsimod.nodes.land.PerviousSurface)                      | - In IHACRES, the maximum infiltration per time step is controlled by an infiltration capacity, beyond which the precipitation will flow directly as surface runoff.<br> - Evapotranspiration and effective precipitation are calculated based on soil moisture content.<br> - Effective precipitation is then divided into percolation, surface runoff, and subsurface runoff by multiplying the corresponding coefficient.<br> - Percolation, surface runoff, and subsurface runoff are sent into the corresponding residence tanks for rounting to downstream.<br> - The mass of pollutants in soil water tank proportionately leaves the soil water tank into the routing residence tanks. Evapotranspiration can only bring out water, with pollutants left in the soil tank.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | - Field capacity and wilting point. _Units_: -, both should in [0-1], with field capacity > wilting point<br> - Infiltration capacity. _Units_: m/day<br> - Surface, percolation coefficient. _Units_: -, both should in [0-1]<br> - et0 coefficient. _Units_:<br> - ihacres_p. _Units_: -                                                                                                                                                                                                                                                                                                                         |
| [`QueueGroundwater`](./../reference-storage/#wsimod.nodes.storage.QueueGroundwater)              | - Conceptualises groundwater as a tank.<br> - Baseflow is generated following a timearea method.<br> - Baseflow is sent to `storage.py/River`, `nodes.py/Node` or `waste.py/Waste` nodes.<br> - No infiltration to sewers is modelled.<br> - If `decays` are provided to model water quality transformations, see `core.py/DecayObj`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | - Groundwater tank `capacity`, `area`, and `datum`. _Units_: cubic metres, squared metres, metres<br> - `timearea` is a dictionary containing the timearea diagram. _Units_: duration of flow (in timesteps) and proportion of flow<br> - Optional dictionary of decays with pollutants as keys and decay parameters (a constant and a temperature sensitivity exponent) as values. _Units_: -                                                                                                                                                                                                                     |
| [`Reservoir`](./../reference-storage/#wsimod.nodes.storage.Reservoir)                            | - Conceptualised as a `Tank`.<br> - Recharged only via pumped abstractions.<br> - Evaporation/precipitation onto surface area currently ignored.<br> - If `decays` are provided to model water quality transformations, see `core.py/DecayObj`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | - Tank `capacity`, `area`, and `datum`. _Units_: cubic metres, squared metres, metres<br> - Optional dictionary of decays with pollutants as keys and decay parameters (a constant and a temperature sensitivity exponent) as values. _Units_: -                                                                                                                                                                                                                                                                                                                                                                   |
| [`ResidentialDemand`](./../reference-other/#wsimod.nodes.demand.ResidentialDemand)               | - Per capita calculations to generate demand based on population.<br> - Pollutant concentration of generated demand uses a fixed mass per person per timestep.<br> - Temperature of generated wastewater is based partially on air temperature and partially on a constant.<br> - Can interact with `land.py/GardenSurface` to simulate garden water use.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | - `population`. _Units_: n<br> - `per_capita`. _Units_: m3/timestep<br> - `data_input_dict` should contain air temperature at model timestep. _Units_: C                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [`RiverReservoir`](./../reference-storage/#wsimod.nodes.storage.RiverReservoir)                  | - Conceptualised as a `Tank`.<br> - Recharged via pumped abstractions and receives water from inflowing arcs.<br> - Reservoir aims to satisfy a static `environmental_flow`.<br> - If tank capacity is exceeded, reservoir spills downstream towards `nodes.py/Node`, `storage.py/River` or `waste.py/Waste` nodes. Spill counts towards `environmental_flow`.<br> - Evaporation/precipitation onto surface area currently ignored.<br> - Currently, if a reservoir satisfies a pull from a downstream node, it does __not__ count towards `environmental_flow`.<br> - If `decays` are provided to model water quality transformations, see `core.py/DecayObj`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | - Tank `capacity`, `area`, and `datum`. _Units_: cubic metres, squared metres, metres<br> - `environmental_flow` _Units_: cubic metres/timestep<br> - Optional dictionary of decays with pollutants as keys and decay parameters (a constant and a temperature sensitivity exponent) as values. _Units_: -                                                                                                                                                                                                                                                                                                         |
| [`River`](./../reference-storage/#wsimod.nodes.storage.River)                                    | - River is conceptualised as a water tank that receives flows from various sources (e.g., runoffs from urban and rural land, baseflow from groundwater), interacts with water infrastructure (e.g., abstraction for irrigation and domestic supply, sewage and treated effluent discharge), and discharges flows downstream. It has length and width as shape parameters, average velocity to indicate flow speed and capacity to indicate the maximum storage limit.<br> - Flows from different sources into rivers will fully mix. River tank is assumed to have delay and attenuation effects when generate outflows. These effects are simulated based on the average velocity.<br> - In-river biochemical processes are simulated as sources/sinks of nutrients in the river tank, including<br> - denitrification (for nitrogen)<br> - phytoplankton absorption/release (for nitrogen and phosphorus)<br> - macrophyte uptake (for nitrogen and phosphorus) These processes are affected by river temperature.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | - depth, length, width _Units_: m<br> - velocity _Units_: m/day<br> - damping coefficient _Units_:<br> - minimum required flow _Units_: m3/day                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`Sewer`](./../reference-sewer/#wsimod.nodes.sewer.Sewer)                                        | - Sewer networks can be represented in an aggregated manner, where the behaviour of collections of manholes/pipes can be captured in a single component.<br> - Travel time of water received from either `land.py/Land` objects or `demand.py/Demand` objects is assumed to be received as a non-point source and thus can be represented with the time-area method.<br> - Travel time of water from an upstream `Sewer` object has a fixed travel time through the node.<br> - The flow capacity of sewer network can be represented as with a `Tank`.<br> - The `Sewer` object is not currently biochemically active.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | - `pipe_timearea` is a dictionary containing the timearea diagram. _Units_: duration of flow (in timesteps) and proportion of flow<br> - `pipe_time` describes the travel time of water received from upstream `Sewer` objects. _Units_: number of timesteps<br> - `capacity`, `chamber_area`, `chamber_datum` describe the dimensions of the `Tank` that controls flow. _Units_: cubic metres, squared metres, metres                                                                                                                                                                                             |
| [`Surface`](./../reference-land/#wsimod.nodes.land.Surface)                                      | - Generic `Surface` that reads data and can apply simple forms of pollution deposition.<br> - Formulated as a `Tank` object.<br> - Ammonia->Nitrite->Nitrate decay takes place if parameters describing this process are provided in `decays` (see `core.py/DecayObj` for transformation details).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | - `data_input_dict` can contain a variety of pollutant deposition data. `srp-dry` describes phosphate. `noy-dry` describes nitrogen as nitrates. `nhx-dry` describes nitrogen as ammonia. `srp/noy/ nhx-wet` can also be used to specify wet deposition. _Units_: kg/m2/timestep (data is read at a monthly timestep)                                                                                                                                                                                                                                                                                              |
| [`UnlimitedDistribution`](./../reference-other/#wsimod.nodes.distribution.UnlimitedDistribution) | - Water demand is always satisfied.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | - None                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [`WTW`](./../reference-wtw/#wsimod.nodes.wtw.WTW)                                                | - Throughput can be modelled entirely with a set capacity.<br> - Pollutant reduction for the entire treatment process can be modelled primarily with a single (temperature sensitive) transformation for each pollutant.<br> - Liquor and solids are tracked and calculated with proportional multiplier parameters.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | - `treatment_throughput_capacity` _Units_: cubic metres/timestep<br> - `process_parameters` contains the constant (non temperature sensitive) and exponent (temperature sensitive) transformations applied to treated water for each pollutant. _Units_:<br> - `liquor_multiplier` and `percent_solids` describe the proportion of throughput that goes to liquor/solids.                                                                                                                                                                                                                                          |
| [`WWTW`](./../reference-wtw/#wsimod.nodes.wtw.WWTW)                                              | - See `wtw.py/WTW` for treatment.<br> - When `treatment_throughput_capacity` is exceeded, water is first sent to a stormwater storage tank before denying pushes. Leftover water in this tank aims to be treated in subsequent timesteps.<br> - Can be pulled from to simulate active wastewater effluent use.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | - See `wtw.py/WTW` for treatment.<br> - Stormwater tank `capacity`, `area`, and `datum`. _Units_: cubic metres, squared metres, metres                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [`Waste`](./../reference-other/#wsimod.nodes.waste.Waste)                                        | - Water 'disappears' (leaves the model) from these nodes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | - None                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |