---
abstract: 'The NFDI4Earth Label is being developed as a tool to support the

  harmonization of data infrastructures in the Earth System Sciences (ESS)

  towards a FAIR ecosystem of services within NFDI4Earth. The Label

  primarily focuses on assessing the technical interoperability and

  trustworthiness of repositories. This milestone builds on the [first  Status Report
  on the NFDI4Earth Label](https://doi.org/10.5281/zenodo.13711420), which introduced
  the overall

  concept, motivation, and theoretical background. The present document

  focuses on the current release version, summarizing the practical

  implementation and community feedback, and outlining the next steps for

  further development.

  '
author:
- email: robert.brylka@senckenberg.de
  name: Robert Brylka
  orcid: 0000-0002-5872-9959
- name: Jonas Grieb
  orcid: 0000-0002-8876-1722
- name: Ronny Gey
  orcid: 0000-0003-1028-1670
- name: Claudia Müller
  orcid: 0000-0002-0709-5044
- name: Stephan Frickenhaus
  orcid: 0000-0002-0356-9791
- name: Claus Weiland
  orcid: 0000-0003-0351-6523
date: 2025-10
doi: 10.5281/zenodo.17856067
figPrefix: Fig.
identifier: MS3.2.2
include-before: '\section*{Contributions}


  Based on CRediT Contributor Roles, see <https://credit.niso.org/>.


  RB: Writing -- original draft, Software


  JG: Writing -- review \& editing, Software


  RG: Writing -- review \& editing


  CM: Writing -- review \& editing


  SF: Writing -- review \& editing


  CW: Writing -- review \& editing


  \newpage


  \section*{Abbreviations}


  API -- Application Programming Interface


  CTS -- CoreTrustSeal


  DCAT -- Data Catalog Vocabulary


  DIF -- Directory Interchange Format


  DOI -- Digital Object Identifier


  ESS -- Earth System Sciences


  FAIR -- Findable, Accessible, Interoperable, Reusable


  FTP -- File Transfer Protocol


  F-UJI -- FAIRsFAIR F-UJI Automated FAIR Data Assessment Tool


  Handle -- Handle System (Persistent Identifier System)


  ISO 19115 -- International Standard for Geographic Information Metadata


  JSON -- JavaScript Object Notation


  NetCDF -- Network Common Data Form


  OAI-PMH -- Open Archives Initiative Protocol for Metadata Harvesting


  OGC CSW -- Open Geospatial Consortium Catalogue Service for the Web


  OPeNDAP -- Open-source Project for a Network Data Access Protocol


  ORCID -- Open Researcher and Contributor ID


  PID -- Persistent Identifier


  REST -- Representational State Transfer


  SOAP -- Simple Object Access Protocol


  SPARQL -- SPARQL Protocol and RDF Query Language


  SWORD -- Simple Web-service Offering Repository Deposit


  URL -- Uniform Resource Locator


  URN -- Uniform Resource Name


  \newpage

  '
include-preamble: '\interfootnotelinepenalty=10000

  \clubpenalty=1000

  \widowpenalty=1000

  '
keywords:
- NFDI
- NFDI4Earth
- NFDI4Earth Milestone
- FAIR
- Label
- Repository Assessment
- Interoperability
- Trustworthiness
- ESS
- F-UJI
- NFDI4Earth Label
lang: en-GB
link-citations: 'true'
milestone: 'true'
tblPrefix: Tab.
title: NFDI4Earth Label Status Report
toc: 'true'
---

# Executive Summary

The NFDI4Earth Label is being developed as a tool to support the
harmonization of data infrastructures in the Earth System Sciences (ESS)
towards a FAIR ecosystem of services within NFDI4Earth. The Label
primarily focuses on assessing the technical interoperability and
trustworthiness of repositories.

Interoperability is evaluated through a workflow that relies on
information retrievable from the re3data[^1] registry of data
repositories, while the trustworthiness of repositories is assessed
using a questionnaire-based self-assessment. In addition, an optional
automated FAIRness assessment using the F-UJI[^2] tool extends the
concept by evaluating interoperability at the dataset level. All
assessments are based on a set of metrics that were defined through an
iterative process within the ESS community.

This milestone builds on the first Status Report on the NFDI4Earth Label
(Grieb et al., 2023), which introduced the overall concept, motivation,
and theoretical background of the Label. The present document focuses on
the current release version, summarizing the practical implementation
and community feedback, and outlining the next steps for further
development, including the implementation, testing, and refinement of
the current workflow.

# Introduction

Harmonizing research data infrastructures within the Earth System
Sciences (ESS) is one of the key goals of NFDI4Earth, the German
National Research Data Infrastructure for the ESS (Bernard et al.,
2021). To support this process, the NFDI4Earth Label is being developed
as a framework for assessing the FAIRness of participating research data
infrastructures, referring to the principles of Findability,
Accessibility, Interoperability, and Reusability (Wilkinson et al.,
2016). The Label primarily focuses on the technical interoperability and
organizational trustworthiness of repositories and introduces a
structured yet lightweight evaluation process that complements existing
certification schemes (Grieb et al., 2023).

The conceptual foundation of the Label builds upon prior work on
FAIRness assessment tools such as F-UJI, FAIRassist[^3], and
FAIR-Checker[^4], which translate the abstract FAIR principles into
measurable indicators for individual datasets. In contrast, the
NFDI4Earth Label moves beyond the dataset level, focusing on
repositories as active components within a larger network of
interoperable services. Similar approaches have recently been proposed
(d'Aquin et al., 2023), emphasizing the importance of governance, trust,
and community engagement in repository evaluation. These ideas are
reflected in the Label's design through its self-assessment component,
which complements the automated technical checks.

The NFDI4Earth Label serves dual purposes: it offers researchers and
data users a clear indicator for identifying interoperable and
trustworthy repositories, while simultaneously providing repository
operators with structured feedback and practical recommendations to
strengthen interoperability and sustainability. In this way, the Label
serves as both a quality mark and a mechanism for continuous
improvement, contributing to the broader harmonization of ESS data
infrastructures towards a coherent NFDI4Earth data ecosystem.

The current stage of development represents the first operational
release of the Label framework. It has been implemented and tested
within the NFDI4Earth infrastructure, where initial evaluations
demonstrated its technical feasibility and usability. Designed as an
iterative, community-driven process, the Label continuously evolves
based on feedback from pilot assessments and workshops, which are
systematically analysed and integrated to refine the framework, broaden
its applicability, and align it more closely with community needs. In
this way, the NFDI4Earth Label develops dynamically as both a practical
tool and a collaborative effort toward a harmonized, FAIR-oriented ESS
data ecosystem.

# Current Release State and Application Workflow

The current release of the NFDI4Earth Label represents the first
operational version of the assessment framework. It defines the
components, data sources, and evaluation logic required to determine the
interoperability and trustworthiness of repositories within the ESS. The
implementation reflects the results of previous development phases
(Grieb et al., 2023) and community feedback, serving as the basis for
testing and further refinement.

## Assessment Framework

The assessment procedure is implemented as part of the established
OneStop4All[^5] service within NFDI4Earth. User authentication is
handled through the NFDI Authentication and Authorization
Infrastructure, provided by the IAM4NFDI[^6] project, and ORCID[^7],
ensuring secure, standards-based, and reliable identification of
repository representatives. As a prerequisite, each participating
repository must be registered in the re3data registry of data
repositories and classified as relevant to NFDI4Earth.

The workflow integrates three assessment components, each addressing a
distinct aspect of FAIR-aligned repository quality:

1. **re3data-based automated assessment (mandatory)**

   > This component retrieves and analyses metadata directly from the
   > repository\'s re3data record. The extracted information is evaluated
   > against a set of predefined criteria, with particular focus on
   > metadata standards, API availability, and the use of persistent
   > identifiers (for a complete list of metrics, see Appendix, [[Table
   > 1]{.underline}](#table-1-re3data-assessment)).

2. **Self-assessment (mandatory)**

   > This component captures additional information not available through
   > re3data, such as governance, sustainability, and institutional
   > trustworthiness. The data are collected via a structured online form
   > and contribute to the qualitative dimension of the overall evaluation
   > (for a complete list of metrics, see Appendix, [[Table
   > 2]{.underline}](#table-2-self-assessment)).

3. **F-UJI-based automated assessment (optional)**

   > To estimate the FAIRness of data holdings at the dataset level, a
   > subset of records is analysed using the F-UJI tool. The resulting
   > metrics provide insight into metadata completeness and standard
   > compliance (for a complete list of metrics, see Appendix, [[Table
   > 3]{.underline}](#table-3-f-uji-assessment)).

The information obtained from the re3data record and the self-assessment
form serves as input for the Label evaluation, which is conducted
according to a defined set of metrics. The assessment result consists of
individual numeric scores for each component. Where criteria are not
fulfilled, detailed recommendations are generated to guide improvements
in subsequent iterations.

At the current stage, the F-UJI-based assessment remains optional, as it
depends on the availability of an OAI-PMH[^8] endpoint, which is not yet
consistently implemented across all repositories.

## Label Award and Public Representation

The Label assessment follows an iterative process, allowing repositories
to refine their entries and resubmit updated information as needed. Once
all assessment components accurately represent the repository\'s
capabilities and the required thresholds are met, the NFDI4Earth Label
is awarded.

![NFDI4Earth Label Badge](./label-badge.png){width="3.6718755468066493in"
height="0.6304374453193351in"}

The awarded Label is visualized as a digital badge confirming the
successful assessment. The badge, along with repository information, is
publicly displayed in the *Explore awarded repositories*[^9] *section*
of the OneStop4All portal.

Repositories are encouraged to include the Label badge on their own
webpages. For this purpose, an HTML code snippet is provided for direct
integration into the repository\'s website. Along with the HTML code for
the badge icon, a verification link is provided that directs users to
the official list of awarded repositories on the OneStop4All portal,
serving as a verification mechanism for the displayed badge.

## Alignment with the CoreTrustSeal

Repositories already certified with the CoreTrustSeal[^10] (CTS) are
considered to comply with all criteria covered by the self-assessment
component of the NFDI4Earth Label. Consequently, representatives of
CTS-certified repositories are exempt from completing the
self-assessment form.

This alignment reflects the shared objectives and overlapping standards
between CTS and the NFDI4Earth Label framework, while reducing redundant
effort for certified repositories.

# Report on the second workshop on September 23, 2025

On September 23, 2025, the NFDI4Earth Label team, in collaboration with
the NFDI4Earth FAIRness and Openness Commitment initiative, hosted the
workshop *Label and Commitment -- Joint efforts towards FAIR and Open
services and practices* together as part of ongoing efforts to promote
FAIR and Open services. The workshop aimed to present the current state
of development of the NFDI4Earth Label, discussed first ideas regarding
its concept and implementation, and collected feedback from the
community.

The NFDI4Earth Label team presented the progress achieved so far on
behalf of the Label initiative. This included a live demonstration of
the assessment procedure, showcasing how repositories can perform and
interpret the assessment within the current evaluation framework.

The 90-minute session also featured an experience report from a
repository representative who had already completed the assessment. The
presentation provided valuable insights into the usability, clarity of
the criteria, and practical challenges encountered during the process.

In the ensuing discussion, various concerns, suggestions, and ideas were
voiced. The main topics were:

- **Meaning of the Label**

  > The discussion was initiated by the question of whether requiring a
  > publicly accessible API as a mandatory condition for the Label is
  > reasonable. A few participants expressed concerns, noting that
  > government-run repositories are subject to legal restrictions that
  > currently prevent them from offering public APIs.
  >
  > It became clear that these concerns were based on a misunderstanding
  > of the Label\'s intent. The Label is intended to confirm fundamental
  > FAIR practices rather than determine inclusion or exclusion from the
  > NFDI4Earth community. The requirement for a standard API reflects the
  > FAIR principle A1, which states that data should be accessible through
  > a standardized communication protocol.
  >
  > In a constructive exchange, the idea emerged to voluntarily disclose
  > unmet criteria, showing that a repository can still demonstrate strong
  > FAIR practices even if certain features, such as a public API, are
  > missing due to legal or institutional constraints.

- **Peer Review for the self-assessment**

  > A suggestion was made to introduce a peer review mechanism for the
  > self-assessment part of the label process. The idea is that
  > repositories already awarded the Label could be invited to review new
  > applicants once.
  >
  > Such an approach could enhance trust and transparency within the
  > process, encouraging active community participation. By involving
  > experienced repository representatives, the review could promote a
  > common understanding of the criteria and provide constructive feedback
  > to applicants.
  >
  > At the same time, the additional effort required might discourage
  > participation, as the process would become more time-consuming.

- **Handling of Evaluation Information**

  > The question was raised whether greater transparency would be
  > beneficial. Although the overall procedure has been communicated, the
  > detailed results are not currently available to the public. Publishing
  > all partial evaluation results could further strengthen openness and
  > trust in the label process.
  >
  > It was discussed whether repository representatives could be
  > encouraged to voluntarily publish their results. Although the
  > information is not sensitive, some may be reluctant to disclose
  > incomplete assessments. It was therefore suggested to develop a
  > balanced and transparent way of presenting results that highlights
  > strengths and clearly indicates where criteria are only partially met.

- **Visual Design of the Label**

  > Another point raised during the discussion concerned the visual
  > appearance of the Label. One participant suggested that the current
  > design might be too generic and could therefore resemble common
  > \"GitHub-style\" badges, making it less distinctive. However, several
  > voices from the audience supported the simplicity of the current
  > design, emphasizing its clarity and neutrality.
  >
  > It was proposed to consider multiple design variants of the Label,
  > allowing the appropriate version to be chosen depending on the context
  > of presentation or placement. The more elaborate variant should
  > include the NFDI4Earth logo to connect the Label to the initiative
  > visually.

- **Support for non restful APIs**

  > During the discussion on the requirement for a publicly accessible
  > API, SPARQL endpoints and FAIR Signposting were mentioned as
  > alternative interfaces. SPARQL endpoints provide standardized,
  > machine-actionable access to structured, linked data and are
  > recognized as equivalent within the Label assessment. An update to the
  > documentation is planned to make this explicitly clear. FAIR
  > Signposting, however, does not constitute an API or a direct
  > alternative to a search and harvesting endpoint. It offers a
  > lightweight mechanism for exposing machine-readable links between
  > data, metadata, and identifiers and will be considered in future
  > developments as a complementary method to enhance metadata
  > accessibility and discoverability.

These ideas will serve as the basis for further discussion in upcoming
internal Label meetings, where a decision will be made on whether and
how to implement them.

# Outlook

The presented report reflects the current state of implementation of the
NFDI4Earth Label, as consolidated by the discussions with the community
and ongoing work within the Label team. Since the release of the current
version, several repositories have successfully completed the evaluation
process and obtained the Label. The experiences gathered from these
first implementations have provided valuable feedback on the usability
and clarity of the assessment workflow. This feedback is continuously
analysed and integrated into the ongoing refinement of the framework to
ensure that the NFDI4Earth Label remains both technically robust and
user-oriented.

Community feedback, particularly from the workshop on September 23,
2025, has been instrumental in identifying strengths and areas for
improvement. The collected input is being analysed and will guide the
next iteration of the framework, ensuring that the Label continues to
evolve in close alignment with the needs of repository providers.

Therefore, future work will focus on enhancing the automation of the
evaluation steps, improving user guidance, and exploring new ways to
present assessment results more transparently, thereby strengthening
both the usability and the overall trust in the NFDI4Earth Label
process.

# References {.unnumbered}

Bernard, L., Braesicke, P., Bertelmann, R., Frickenhaus, S., Gödde, H.,
Keßler, C., Lorenz, S., Mahecha, M., Marschall, H., Hezel, D., Nagel, W.
E., Reichstein, M., Sester, M., Thiemann, H., Weiland, C.,
Wytzisk-Arens, A., & NFDI Consortium Earth System Sciences. (2021). NFDI
Consortium Earth System Sciences - Proposal 2020 revised (Revision 1
from 2021-10-01). Zenodo.
<https://doi.org/10.5281/zenodo.5718944>

d'Aquin, M., Kirstein, F., Oliveira, D., et al. (2023). FAIREST: A
framework for assessing research repositories. Data Intelligence, 5(1),
202--241.
<https://doi.org/10.1162/dint_a_00159>

Gaignard, A., Rosnet, T., De Lamotte, F., Lefort, V., & Devignes, M.-D.
(2023). FAIR-Checker: Supporting digital resource findability and reuse
with Knowledge Graphs and Semantic Web standards. Journal of Biomedical
Semantics, 14(1), 7.
<https://doi.org/10.1186/s13326-023-00289-5>

Grieb, J., Weiland, C., Gey, R., Stocker, M., Degbelo, A., Henzen, C., &
Thießen, F. (2023). First draft of resource information types
(protocols, vocabularies, metadata schemes) in use in NFDI4Earth
(NFDI4Earth Deliverable D3.2.1) (1.0). Zenodo.
<https://doi.org/10.5281/zenodo.8344901>

Grieb, J., Schäfer, T., Frickenhaus, S., Gey, R., & Weiland, C. (2024).
NFDI4Earth Label Status Report (NFDI4Earth Milestone MS3.2.1).
NFDI4Earth Community on Zenodo.
<https://doi.org/10.5281/zenodo.13711420>

Wilkinson, Mark D., et al. (2016). The FAIR Guiding Principles for
scientific data management and stewardship. Scientific Data, 3.1 (2016):
1-9.
<https://doi.org/10.1038/sdata.2016.18>

\appendix

# NFDI4Earth Label Metrics

The following tables list the evaluation criteria across the three assessment components. (Release date: July 17, 2025.)

## Table 1: re3data Assessment {#table-1-re3data-assessment}

The re3data component is based on metadata automatically retrieved via
the [re3data API](https://www.re3data.org/api/doc/) using
the repository's unique identifier. Each criterion is evaluated based on
the presence of specific metadata elements. A criterion is considered
fulfilled if at least one of the accepted standards listed in the table
is present in the re3data record.

\scriptsize

| **N4E metric** | **Guideline** | **Considered Standards** | **Related FAIR principle** |
|---------------------------------------|---------------------------------------|-----------------------------|-------------------------|
| n4e:assignsUniqueIds | Supports ID system with unique IDs | [URL](http://purl.org/spar/datacite/url), [URN](http://purl.org/spar/datacite/urn), [DOI](http://purl.org/spar/datacite/doi), [Handle](http://purl.org/spar/datacite/handle) | [F1](https://www.go-fair.org/fair-principles/f1-meta-data-assigned-globally-unique-persistent-identifiers/) |
| n4e:assignsPersistentIds | Supports ID system with persistent IDs | [DOI](http://purl.org/spar/datacite/doi), [Handle](http://purl.org/spar/datacite/handle) | [F1](https://www.go-fair.org/fair-principles/f1-meta-data-assigned-globally-unique-persistent-identifiers/) |
| n4e:providesAnyAPI | Provides an API to access metadata | [FTP](https://en.wikipedia.org/wiki/File_Transfer_Protocol), [NetCDF](https://www.unidata.ucar.edu/software/netcdf/), [OAI-PMH](https://www.openarchives.org/pmh/), [OGC CSW](https://www.ogc.org/), [OPeNDAP](https://www.opendap.org/), [REST](https://en.wikipedia.org/wiki/Representational_state_transfer), [SOAP](https://en.wikipedia.org/wiki/SOAP), [SPARQL](https://en.wikipedia.org/wiki/SPARQL), [SWORD](https://swordapp.org/) | [A1](https://www.go-fair.org/fair-principles/metadata-retrievable-identifier-standardised-communication-protocol/) |
| n4e:providesHarvestAPI | Provided API supports harvesting | [NetCDF](https://www.unidata.ucar.edu/software/netcdf/), [OAI-PMH](https://www.openarchives.org/pmh/), [OGC CSW](https://www.ogc.org/) | [A1](https://www.go-fair.org/fair-principles/metadata-retrievable-identifier-standardised-communication-protocol/) |
| n4e:supportsCrossDomainStandard | Supports at least one of (by us considered) cross-domain metadata standards | [Dublin Core](https://rdamsc.bath.ac.uk/msc/m15), [schema.org](https://rdamsc.bath.ac.uk/msc/m101), [DataCite](https://rdamsc.bath.ac.uk/msc/m11), [DCAT](https://rdamsc.bath.ac.uk/msc/m12) | [F4](https://www.go-fair.org/fair-principles/f4-metadata-registered-indexed-searchable-resource/) |
| n4e:supportsSpecificESSStandard | Supports an ESS-specific metadata standard | [ISO 19115](https://rdamsc.bath.ac.uk/msc/m22), [DIF](https://rdamsc.bath.ac.uk/msc/m14), [Darwin Core](https://rdamsc.bath.ac.uk/msc/m9) | [R1.3](https://www.go-fair.org/fair-principles/r1-3-metadata-meet-domain-relevant-community-standards/) |

\normalsize

## Table 2: Self-Assessment {#table-2-self-assessment}

The Self-Assessment component consists of a structured form to be
completed by repository representatives and covers aspects such as
sustainability, user support and data maintenance. Each item is
evaluated individually and scored as either fulfilled or not fulfilled.
The submitted answers - including the attached explanations and
references - are reviewed and can be supplemented with follow-up
questions for clarification if necessary.

\scriptsize

| **N4E metric** | **SAF Field** | **Guideline** | **Corresponding CTS criteria** |
|-----------------------------------|-------------------|-------------------------------------------------------|--------------------|
| n4e:hasBackupStrategy | Backup Strategy | The repository should have a backup strategy. | [R14](https://zenodo.org/records/7051012) |
| n4e:hasArchivingStrategy | Archiving Strategy | The repository should have a long-term preservation strategy in place. | [R09](https://zenodo.org/records/7051012) |
| n4e:hasFundingStatement | Funding | The repository should have a funding statement, mission statement or some other self description that allows users to understand the purpose of the repository, which institution runs it, and how it is funded. The mentioned information should be made clear to repository users on the repository website. | [R05](https://zenodo.org/records/7051012) |
| n4e:hasCuration | Curation | The repository should have data curation. The degree of curation should be made clear to repository users on the repository website. | [R08/R10](https://zenodo.org/records/7051012) |
| n4e:hasUserSupport | User Support | The repository should have some form of user support. The options for user support should be made clear to repository users on the repository website. | [R06](https://zenodo.org/records/7051012) |

\normalsize

## Table 3: F-UJI Assessment {#table-3-f-uji-assessment}

The F-UJI tool evaluates the FAIRness of individual datasets rather than
entire repositories. For this reason, a fixed number of datasets is
randomly sampled from the repository and assessed using the F-UJI tool.
To derive the final F-UJI assessment result, each metric is evaluated
across all sampled datasets. The metric is marked as fulfilled if more
than 50% of the sampled datasets meet the corresponding condition.

\scriptsize

| **N4E metric** | **Guideline** | **F-UJI Metric** |
|------------------------------|-----------------------------------------------------------------------|----------------------|
| n4e:hasDescriptiveMetadata | Metadata of records stored in the repository should include descriptive core elements. | [FsF-F2-01M](https://www.f-uji.net/index.php?action=methods) |
| n4e:metadataIncludesIdentifier | Metadata of records stored in the repository should include the identifier of the data it describes. | [FsF-F3-01M](https://www.f-uji.net/index.php?action=methods) |
| n4e:metadataLinks | Metadata of records stored in the repository should include links between the data and its related entities. | [FsF-I3-01M](https://www.f-uji.net/index.php?action=methods) |
| n4e:includesLicense | Metadata of records stored in the repository should include license information under which data can be reused. | [FsF-R1.1-01M](https://www.f-uji.net/index.php?action=methods) |
| n4e:includesProvenance | Metadata of records stored in the repository should include provenance information about data creation or generation. | [FsF-R1.2-01M](https://www.f-uji.net/index.php?action=methods) |
| n4e:metadataRepresentation | Metadata of records stored in the repository should be represented using a formal knowledge representation language. | [FsF-I1-01M](https://www.f-uji.net/index.php?action=methods) |
| n4e:specifiesContent | Metadata of records stored in the repository should specify the content of the data: the type of the object and technical properties like file format, size, and names. | [FsF-R1-01MD](https://www.f-uji.net/index.php?action=methods) |

\normalsize

[^1]: re3data.org - Registry of Research Data Repositories.
    <https://doi.org/10.17616/R3D> last accessed: 2023-12-19

[^2]: Devaraju, Anusuriya and Huber, Robert (2021) "An automated
    solution for measuring the progress toward FAIR research data"
    *Patterns* 2(11). <https://doi.org/10.1016/j.patter.2021.100370>

[^3]: <https://fairassist.org/>

[^4]: <https://fair-checker.france-bioinformatique.fr/>

[^5]: <https://onestop4all.nfdi4earth.de/>

[^6]: <https://iam.services.base4nfdi.de/>

[^7]: <https://orcid.org/>

[^8]: <https://www.openarchives.org/pmh/>

[^9]: <https://onestop4all.nfdi4earth.de/label/explore/>

[^10]: <https://www.coretrustseal.org/>
