import matplotlib.pyplot as plt
from matplotlib.colors import LinearSegmentedColormap, to_hex


def create_custom_colormap(color_start, color_end, n_colors=256):
    """
    Creates a Plotly-compatible continuous colorscale from two hex colors.

    Parameters:
        color_start (str): Hex color code for the start color (e.g., '#FF0000').
        color_end (str): Hex color code for the end color (e.g., '#0000FF').
        n_colors (int): Number of discrete steps in the colorscale.

    Returns:
        List: A Plotly-compatible colorscale.
    """
    cmap = LinearSegmentedColormap.from_list('custom', [color_start, color_end], N=n_colors)
    colorscale = []

    for i in range(n_colors):
        normalized_value = i / (n_colors - 1)
        rgba = cmap(normalized_value)
        hex_color = to_hex(rgba)
        colorscale.append([normalized_value, hex_color])

    return colorscale


transparent_n719_cmap = create_custom_colormap(color_start="#c53c21",color_end="#e59967")
underlying_mechanism_cmap = create_custom_colormap(color_start="#c53c21",color_end="#dc742e")
