from contracts.plotter_options import PlotterOptions
from implementations.data.data_processors.iv_data_processor import IVScatterDataProcessor
from implementations.data.data_types.iv_scatter import IVData
from contracts.device_worker import DeviceWorkerCore
from implementations.plotters.scatter_data_plotter import ScatterDataPlotter
from utils.custom_datetime import CustomDatetime
import json


class Sunbrick(DeviceWorkerCore):
    """
         Implements the plotting function for the Sunbrick devices.
         Relevant data types and processors are IVData and IVScatterDataProcessor.
    """
    def __init__(self, device, dataset, plot_type, options: PlotterOptions):
        super().__init__(device, dataset, plot_type, options)

        self.set_data_type(IVData)
        self.set_processor_type(IVScatterDataProcessor)

    def plot_fulliv(self, title):
        plotter = ScatterDataPlotter(title, "voltage", "current", options=self.options)
        self._scatter_plot(plotter)

    def plot_iv(self, title):
        plotter = ScatterDataPlotter(title, "forward_voltage", "forward_current", options=self.options)
        self._scatter_plot(plotter)

    def plot_fullpv(self, title):
        plotter = ScatterDataPlotter(title, "voltage", "power", options=self.options)
        self._scatter_plot(plotter)

    def plot_pv(self, title):
        plotter = ScatterDataPlotter(title, "forward_voltage", "forward_power", options=self.options)
        self._scatter_plot(plotter)

    def _scatter_plot(self, plotter: ScatterDataPlotter):
        plotter.ready_plot(self.data_processors, self.options)
        plotter.draw_plot()

    def print_parameters(self, *args, **kwargs):
        # Get the parameters
        parameter_dict = {}
        for lbl in self.data_processors:
            parameter_dict[lbl] = self.data_processors[lbl].get_data("parameters")
        formatted_parameters = json.dumps(parameter_dict)

        # Write them to a file in a default dir
        # TODO: Magic String, make this a setting/config
        current_datetime = CustomDatetime().get_current_timestamp()
        with open(rf"C:\Users\lucp8023\Downloads\{current_datetime}_parameters.txt", "w+") as dumpfile:
            dumpfile.write(formatted_parameters)
        print(formatted_parameters)
