from contracts.plotter_options import PlotterOptions
from implementations.data.data_processors.iv_stability_data_processor import IVStabilityDataProcessor
from implementations.data.data_types.iv_scatter import IVData
from contracts.device_worker import DeviceWorkerCore
from implementations.plotters.iv_stability_plotter import IVStabilityPlotter
from dataset_manager.dataset import DataSet


class Stability(DeviceWorkerCore):
    def __init__(self, device, dataset, plot_type, options: PlotterOptions):
        # super() delegates method calls to a parent
        super().__init__(device, dataset, plot_type, options)

        self.cell_area = None
        self.relative = None
        self.log_time = None
        self.export = None
        self.legend_title = None
        self.colours = None

        self.iv_stability_processors = None

    def set_data(self, dataset: DataSet):
        if not dataset.get_structure_type() == "dirlabelled":
            raise ValueError("Incorrect DataSet structure, must be set to 'dirlabelled' for Stability plotting.")

        # Initialise an empty dict and get the required filepaths
        filepaths = dataset.get_filepaths()
        start_date = dataset.get_experiment_date()
        self.iv_stability_processors = {}

        # Progress housekeeping
        nr_of_files = len(filepaths)
        counter = 0

        # Read the data and instantiate a processor for each cell
        for solar_cell in filepaths:
            processors_list = []
            for iv_curve in filepaths[solar_cell]:
                iv_data = IVData(iv_curve)
                iv_data.read_file(filepaths[solar_cell][iv_curve])
                processors_list.append(iv_data)

            self.iv_stability_processors[solar_cell] = IVStabilityDataProcessor(processors_list, start_date)

            # Emit progress signal
            counter += 1
            self.progress.emit(int(100*counter/nr_of_files))

        # Err: 'DataSpec' object has no attribute 'get_colours'. Did you mean: 'set_colours'?
        self.colours = dataset.get_all_colours()
        self.options.add_option(label="colours", value=self.colours)

    def plot_four(self, title):
        plotter = IVStabilityPlotter(title)
        plotter.ready_plot(self.iv_stability_processors, self.options)
        plotter.draw_plot()

    def plot_isc(self, title):
        raise NotImplementedError

    def plot_jsc(self, title):
        raise NotImplementedError

    def plot_voc(self, title):
        raise NotImplementedError

    def plot_ff(self, title):
        raise NotImplementedError

    def plot_mpp(self, title):
        raise NotImplementedError

    def plot_isc_voc_scatter(self, title):
        raise NotImplementedError

    def plot_eff(self, title):
        raise NotImplementedError
