import warnings
from implementations.data.data_processors.lbic_image_processor import LBICImageProcessor
from contracts.device_worker import DeviceWorkerCore
from contracts.plotter_options import PlotterOptions
from implementations.data.data_types.lbic_image import LBICImage
from implementations.plotters.histogram_plotter import HistogramPlotter
from implementations.plotters.heatmap_plotter import HeatmapPlotter
from implementations.plotters.scatter_data_plotter import ScatterDataPlotter
from utils.logging import decorate_class_with_logging, DEBUG_WORKER


@decorate_class_with_logging(log_level=DEBUG_WORKER)
class LBIC(DeviceWorkerCore):
    def __init__(self, device, dataspec, plot_type, options: PlotterOptions):
        # super() delegates method calls to a parent
        super().__init__(device, dataspec, plot_type, options)

        self.upper_bound = None
        self.lower_bound = None
        self.profile_position = None
        self.enable_profiles = None

        self.iv_stability_processors = None #TODO: Heh?
        self.set_data_type(LBICImage)
        self.set_processor_type(LBICImageProcessor)

    def plot_image(self, title):
        """
        Heatmap/Image plot of the measured intensities at each position
        """
        plotter = HeatmapPlotter(title, observable="current", options=self.options)
        plotter.ready_plot(self.data_processors, self.options)

        # Ranges must be converted from GUI units (uA) to SI units (A)
        zrange = [self.options.get_option('lower_bound')/ 1000000, self.options.get_option('upper_bound')/ 1000000]
        plotter.set_options(zrange=zrange, profiles=self.options.get_option('enable_profiles'))
        plotter.draw_plot()

    def plot_3d(self, title):
        """
        Surface plot of the measured intensities at each position
        """
        raise NotImplementedError
        plotter = SurfacePlotter(title)
        plotter.ready_plot(self.data_processors, self.legend_title)
        plotter.set_options(zrange=[self.lower_bound, self.upper_bound])
        plotter.draw_plot()

    def plot_intensities(self, title):
        """
        Scatter plot of all measured intensities
        """
        warnings.warn("Intensity plot quite slow, debug later")

        tlx = self.options.get_option('top_left_x')
        tly = self.options.get_option('top_left_y')
        brx = self.options.get_option('bottom_right_x')
        bry = self.options.get_option('bottom_right_y')

        if tlx == 0.0 and tly == 0.0 and brx == 0.0 and bry == 0.0:
            self.options.add_option(label='source', value='full')
        else:
            self.options.add_option(label='source', value='area')

        plotter = HistogramPlotter(title, "current_list", options=self.options)
        plotter.ready_plot(self.data_processors, self.options)
        plotter.draw_plot(**self.options.as_kwargs())

    def plot_horiz_profile(self, title):
        """
        Scatter plot of the measured intensities along a horizontal profile
        """
        raise NotImplementedError
        plotter = ScatterDataPlotter(title, "x_axis", "horizontal_profile")
        plotter.ready_plot(self.data_processors, self.options)
        # FIXME: plotter.draw_plot(y_position=self.profile_position)
        plotter.draw_plot()

    def plot_vert_profile(self, title):
        """
        Scatter plot of the measured intensities along a vertical profile
        """
        raise NotImplementedError

    def plot_diagonal_profile(self, title):
        """
        Scatter plot of the measured intensities along a diagonal profile.
        """
        raise NotImplementedError


