from contracts.plotter_options import PlotterOptions
from implementations.data.data_processors.ftir_data_processor import FTIRDataProcessor
from implementations.data.data_types.ftir_scatter import FTIRData
from contracts.device_worker import DeviceWorkerCore
from implementations.plotters.scatter_data_plotter import ScatterDataPlotter


class FTIR(DeviceWorkerCore):

    def __init__(self, device, dataspec, plot_type, options: PlotterOptions):
        # super() delegates method calls to a parent
        super().__init__(device, dataspec, plot_type, options)

        self.x_title = None
        self.y_title = None
        self.legend_title = None
        self.data_processors = None

        self.options = options
        self.options.add_option("reverse_x_axis", value = True)
        self.options.add_option("vertical_gridlines", value = True)

        self.set_data_type(FTIRData)
        self.set_processor_type(FTIRDataProcessor)

    def set_options(self, legend_title: str, *args, **kwargs):
        self.legend_title = legend_title

    def plot(self, title):
        """
        Show the scatter plot
        """
        plotter = ScatterDataPlotter(title, "wavenumber", "transmittance", options=self.options)
        plotter.ready_plot(self.data_processors, self.options)
        plotter.draw_plot()