from contracts.plotter_options import PlotterOptions
from implementations.data.data_processors.absorbance_data_processor import AbsorbanceScatterDataProcessor
from implementations.data.data_types.absorbance_scatter import AbsorbanceData
from contracts.device_worker import DeviceWorkerCore
from implementations.plotters.scatter_data_plotter import ScatterDataPlotter


class DW2000(DeviceWorkerCore):
    def __init__(self, device, dataset, plot_type, options: PlotterOptions):
        # super() delegates method calls to a parent
        super().__init__(device, dataset, plot_type, options)

        self.presentation = None
        self.set_data_type(AbsorbanceData)
        self.set_processor_type(AbsorbanceScatterDataProcessor)

    def normal_plot(self, title):
        plotter = ScatterDataPlotter(title, "wavelength", "absorbance", self.options)
        plotter.ready_plot(self.data_processors, self.options)
        plotter.draw_plot()

    def rainbow_plot(self, title, legend):
        # FEATURE REQUEST: Add a rainbow plotting thing for a single file
        raise NotImplementedError
