from contracts.data_types import DataCore
from implementations.utils.file_readers.read_lbic_from_json import read_lbic_from_json
from utils.logging import with_logging


class LBICImage(DataCore):
    def __init__(self, label):
        super().__init__(file_reader=read_lbic_from_json)
        self.raw_data = {
            "label": {"units": "N/A", "data": label},
            "x_axis": None,
            "y_axis": None,
            "current": None,
            "step_size": None
        }
        self._allowed_observables = self.raw_data.keys()

    @with_logging
    def read_file(self, filepath: str) -> None:
        data = self.file_reader(filepath)
        if self.raw_data['x_axis'] is None:
            self.raw_data['x_axis'] = {"units": "X-Position (mm)", "data": data['x']}
        if self.raw_data['y_axis'] is None:
            self.raw_data['y_axis'] = {"units": "Y-Position (mm)", "data": data['y']}
        if self.raw_data['current'] is None:
            self.raw_data['current'] = {"units": "Current (A)", "data": data['z']}
        if self.raw_data['step_size'] is None:
            self.raw_data['step_size'] = {'units': "Step Size (mm", 'data': data['metadata']}
