from contracts.data_types import DataCore
from implementations.utils.file_readers.read_table_csv import read_csv


class IVData(DataCore):
    def __init__(self, label):
        super().__init__(file_reader=read_csv)
        self.raw_data = {
            "label": {"units": "N/A", "data": label},
            "voltage": None,
            "current": None,
            "datetime": None,
        }
        self._allowed_observables = self.raw_data.keys()

    def read_file(self, filepath: str):
        data = self.file_reader(filepath)
        if self.raw_data['voltage'] is None:
            self.raw_data['voltage'] = {"units": "$Voltage ~(V)$", "data": data['0']}
        if self.raw_data['current'] is None:
            self.raw_data['current'] = {"units": "$Current ~(I)$", "data": data['1']}
        if self.raw_data['datetime'] is None:
            self._get_datetime_from_filename(filepath)
