from contracts.data_types import DataCore
from implementations.utils.file_readers.read_table_csv import read_csv


class FTIRData(DataCore):
    def __init__(self, label):
        super().__init__(file_reader=read_csv)
        self.raw_data = {
            "label": {"units": "N/A", "data": label},
            "wavenumber": None,
            "transmittance": None,
            "datetime": None,
        }
        self._allowed_observables = self.raw_data.keys()

    def read_file(self, filepath: str):
        data = self.file_reader(filepath)
        if self.raw_data['wavenumber'] is None:
            self.raw_data['wavenumber'] = {"units": "$Wavenumber ~(cm^{-1})$", "data": data['0']}
        if self.raw_data['transmittance'] is None:
            self.raw_data['transmittance'] = {"units": "$Transmittance ~(arb. units)$", "data": data['1']}
        if self.raw_data['datetime'] is None:
            self._get_datetime_from_filename(filepath)
