from contracts.data_types import DataCore
from implementations.utils.file_readers.read_table_csv import read_csv
import pandas as pd


class AbsorbanceData(DataCore):
    def __init__(self, label):
        super().__init__(file_reader=read_csv)
        self.raw_data = {
            "label": {"units": "N/A", "data": label},
            "wavelength": None,
            "absorbance": None,
            # TO DO: This should be a responsability of the core but cannot be so as the core does not access the filepath
            "datetime": None,
        }
        self._allowed_observables = self.raw_data.keys()

    def read_file(self, filepath: str):
        data = self.file_reader(filepath)
        x_data = data['0'][1:]
        y_data = data['1'][1:]

        # If the very first element of the first column is a 0 then there's a header and it can be skipped
        if x_data[0] == 0:
            x_data = x_data[1:]
            y_data = y_data[1:]

        self.raw_data['wavelength'] = {"units": "$Wavelength ~(nm)$", "data": x_data}
        self.raw_data['absorbance'] = {"units": "$Absorbance ~(arb. units)$", "data": y_data}

        # TO DO: This should be a responsability of the core but cannot be so as the core does not access the filepath
        if self.raw_data['datetime'] is None:
            self._get_datetime_from_filename(filepath)
