from contracts.data_processors import DataProcessorCore
from implementations.data.data_types.generic_scatter import GenericScatterData
from utils.errors.errors import ObservableNotComputableError


class ScatterDataProcessor(DataProcessorCore):
    def __init__(self, scatter_data: GenericScatterData):
        super().__init__(scatter_data)

    def validate_observables(self, *args):
        # Checks whether all desired observables can be obtained for this data
        try:
            for observable in args:
                self.get_data(observable)
        # FIXME: Catchall try-except
        except:
            raise ObservableNotComputableError
