from contracts.data_processors import DataProcessorCore
from implementations.data.data_types.ftir_scatter import FTIRData
import warnings


class FTIRDataProcessor(DataProcessorCore):
    def __init__(self, ftir_data: FTIRData):
        # I need to call super to call the superclasses initialisation
        super().__init__(data=FTIRData)
        self.data = ftir_data

        self._processing_functions.update({
            "range": self.find_range,
        })

        # Is filled by parent class_utils function get.data()
        self.processed_data = {}
        for key in self._processing_functions:
            self.processed_data[key] = None

        self._processed_observables = self.processed_data.keys()

    def validate_observables(self, *args):
        # Checks whether all desired observables can be obtained for this data
        for observable in args:
            try:
                self.get_data(observable)
            except ValueError:
                warnings.warn(f'Observable(s) {observable} could not be computed for file {self.get_data("label")}')

    def find_range(self) -> dict:
        wavenumbers = self.get_data("wavenumber")
        range = [wavenumbers[0], wavenumbers[-1]]
        return {"units": "$Wavenumber Range (cm^{-1})$", "data": range}
