from contracts.data_processors import DataProcessorCore
from implementations.data.data_types.absorbance_scatter import AbsorbanceData
from utils.errors.errors import ObservableNotComputableError


class AbsorbanceScatterDataProcessor(DataProcessorCore):
    def __init__(self, absorbance_data: AbsorbanceData):
        self.data = absorbance_data

        self._processing_functions = {
            "max_normalised": self.max_normalised,
            "area_normalised": self.area_normalised,
            "value_normalised": self.value_normalised,
            "elapsed_time": self.elapsed_time
        }

        self.processed_data = {}
        for key in self._processing_functions:
            self.processed_data[key] = None

        self._processed_observables = self.processed_data.keys()

    def validate_observables(self, *args, **kwargs):
        # Checks whether all desired observables can be obtained for this data
        try:
            for observable in args:
                self.get_data(observable)
        # FIXME: Catchall try-except
        except:
            raise ObservableNotComputableError

    def max_normalised(self, *args, **kwargs):
        # Get the highest value and normalise to it
        absorbance = self.get_data("absorbance")
        norm = max(absorbance)
        normalised_absorbance = [value/norm for value in absorbance]
        return {"units": "$Normalised ~Absorbance ~(arb. unit)$", "data": normalised_absorbance}

    def area_normalised(self, *args, **kwargs):
        # Shift the whole curve up so it is completely above the x-axis
        # Compute the area under the curve
        # Normalise to this area
        raise NotImplementedError

    def value_normalised(self, *args, **kwargs):
        # Get wavelength and absorbances
        # Find nearest wavelength index and get corresponding absorbance
        # Normalise to this absorbance
        raise NotImplementedError

    def elapsed_time(self, *args, **kwargs):
        # Get a reference timestamp from *args
        reference_datetime = kwargs["experiment_datetime"]
        data_datetime = self.get_data("datetime")
        return {"units": "$Elapsed ~time ~(hrs)$", "data": data_datetime - reference_datetime}