# X-LAB Plotting Manager — In-House Implementations

This repository contains the **implementations** I use in my research at X-LAB  for reading data, processing measurements, and running device-specific plotting workflows.

It extends the core application:

- **Core GUI + contracts**  
  https://allyson-robert.github.io/X-LAB_Plotting_Manager/

with a set of **research-specific implementations**:

- Custom `Data` subclasses  
- Custom `DataProcessor` subclasses  
- Device-specific `DeviceWorker` classes  
- Plotter options and experiment-specific logic

Although primarily intended for internal lab use, it is published openly so that:

- collaborators can inspect how our workflows are built,  
- labs can fork it into private repositories,  
- and upstream pull requests can be contributed if desired.

---

## Installation

This package is designed to be installed alongside the main X-LAB Plotting Manager.

```bash
# Move to Plotting Manager Directory and activate virtual environment
cd X-LAB_Plotting_Manager
python -m venv .venv
source .venv/bin/activate       # Windows: .venv\Scripts\activate

# Clone into /implementations and install requirements
git clone https://github.com/Allyson-Robert/lab_implementations implementations/
pip install -r implementations/requirements-312.txt

```

For full installation instructions, refer to the main documentation:  
🔗 https://allyson-robert.github.io/X-LAB_Plotting_Manager/installing/

---

## Using this module with the GUI

This particular implementation of the X-LAB plotting manager offers the following devices:
* DW2000: UV-VIS absorbance plots for the DW2000 spectrometer, can read CSV, XLS(X) and TXT versions of the spectra
* Sunbrick: Allows showing individual IV-curves made using the Sunbrick measurement device. Works with any IV curve as long as each curve is in a dedicated file and the header is not too complicated to be automatically detected.
* Stability: Takes in a more structured version of the Sunbrick IV curved and can produce time-series plots of the photovoltaic parameters.
* LBIC: Compatible with the in-house LBIC file format. Can produce current distributions and images.
* FTIR: Compatible with the chemistry department's dpt files. Will automatically reverse the x-axis to go from high to low wavenumbers.

General usage guide:  
🔗 https://allyson-robert.github.io/X-LAB_Plotting_Manager/getting_started/

Public example implementations:  
🔗 https://allyson-robert.github.io/X-LAB_Plotting_Implementations/

---

## License

This repository is released under the **AGPL-3.0** license to ensure that derivative works remain open when redistributed.

---

## Third-Party Credits

This project uses **PyQt5**, which is licensed under the GPL v3.  
A license notice is included as required:

> This software uses PyQt5, licensed under the GPL v3.  
> Copyright © Riverbank Computing.

---

## Contributing

Pull requests are welcome—especially fixes or general improvements that benefit the upstream ecosystem of X-LAB tools.

If your fork is intended for private in-lab use, feel free to modify or extend the implementations as needed.
