namespace UnityEngine.Rendering.HighDefinition
{
    partial class SPTDistribution
    {
        //-------------------------------------------------------------------------------------------
        // SPTD (Spherical Pivot Transformed Distributions): Pivot parameter for GGX.
        // The pivot transform fits the GGX from the transform of a uniform distribution,
        // so the integral against solid angle measure yields 4*pi.
        // Use FGD (with D == GGX) to renormalize to GGX.
        //-------------------------------------------------------------------------------------------

        // This table is precomputed and indexed by sqrt(roughness) = PerceptualRoughness
        // and (2*theta)/PI, both in 64 steps.
        // entry[0] == PivotNorm, entry[1] == PivotElevation (rest is pre-integration, not used)
        public static double[,] s_PivotLUTData = new double[k_PivotLUTResolution * k_PivotLUTResolution, k_PivotLUTEntryDim]
        {
            {0.998002, 0.000000, 1.000000, 1.000000},
            {0.998002, 0.000000, 1.000000, 1.000000},
            {0.997987, 0.000000, 1.000000, 1.000000},
            {0.995475, 0.000000, 1.000000, 1.000000},
            {0.991970, 0.000000, 1.000000, 1.000000},
            {0.987481, 0.000000, 1.000000, 1.000000},
            {0.982023, 0.000000, 1.000000, 1.000000},
            {0.975610, 0.000000, 1.000000, 1.000000},
            {0.968262, 0.000000, 1.000000, 1.000000},
            {0.960000, 0.000000, 1.000000, 1.000000},
            {0.950848, 0.000000, 1.000000, 1.000000},
            {0.940832, 0.000000, 0.999998, 1.000000},
            {0.929979, 0.000000, 0.999995, 0.999995},
            {0.918319, 0.000000, 0.999988, 0.999990},
            {0.905884, 0.000000, 0.999972, 0.999971},
            {0.892707, 0.000000, 0.999947, 0.999936},
            {0.878823, 0.000000, 0.999905, 0.999853},
            {0.864269, 0.000000, 0.999829, 0.999670},
            {0.849083, 0.000000, 0.999701, 0.999138},
            {0.833309, 0.000000, 0.999451, 0.996746},
            {0.817000, 0.000000, 0.998959, 0.979578},
            {0.800245, 0.000000, 0.997833, 0.979309},
            {0.783256, 0.000000, 0.994754, 0.978836},
            {0.766838, 0.000000, 0.984304, 0.977972},
            {0.752409, 0.000000, 0.958531, 0.976223},
            {0.734104, 0.000000, 0.957760, 0.972205},
            {0.715698, 0.000000, 0.956561, 0.962466},
            {0.697119, 0.000000, 0.954639, 0.953919},
            {0.678513, 0.000000, 0.951438, 0.949829},
            {0.660123, 0.000000, 0.945965, 0.942492},
            {0.642463, 0.000000, 0.936538, 0.929870},
            {0.626094, 0.000000, 0.920911, 0.921319},
            {0.610358, 0.000000, 0.904241, 0.911112},
            {0.591493, 0.000000, 0.897121, 0.896015},
            {0.574432, 0.000000, 0.886849, 0.885105},
            {0.558394, 0.000000, 0.872455, 0.869971},
            {0.543965, 0.000000, 0.853116, 0.855017},
            {0.529288, 0.000000, 0.837067, 0.838328},
            {0.515049, 0.000000, 0.822361, 0.821241},
            {0.502417, 0.000000, 0.803759, 0.802352},
            {0.487196, 0.000000, 0.780937, 0.783874},
            {0.474266, 0.000000, 0.764043, 0.763309},
            {0.462847, 0.000000, 0.743935, 0.743058},
            {0.452939, 0.000000, 0.720302, 0.721929},
            {0.442980, 0.000000, 0.700322, 0.699755},
            {0.434531, 0.000000, 0.678374, 0.677721},
            {0.421734, 0.000000, 0.654089, 0.655456},
            {0.412596, 0.000000, 0.633143, 0.632681},
            {0.405555, 0.000000, 0.609768, 0.609629},
            {0.398658, 0.000000, 0.586846, 0.586831},
            {0.392295, 0.000000, 0.564682, 0.564287},
            {0.387248, 0.000000, 0.540736, 0.541772},
            {0.382735, 0.000000, 0.519746, 0.519428},
            {0.377585, 0.000000, 0.497205, 0.497353},
            {0.373750, 0.000000, 0.475887, 0.475624},
            {0.370449, 0.000000, 0.454889, 0.454606},
            {0.367293, 0.000000, 0.433727, 0.434099},
            {0.355295, 0.000000, 0.414316, 0.414085},
            {0.352426, 0.000000, 0.394048, 0.394605},
            {0.348919, 0.000000, 0.375894, 0.375698},
            {0.346727, 0.000000, 0.357465, 0.357386},
            {0.344289, 0.000000, 0.339848, 0.339871},
            {0.341995, 0.000000, 0.323250, 0.323085},
            {0.340625, 0.000000, 0.306253, 0.306905},
            {0.998003, -0.024933, 1.000000, 1.000000},
            {0.998003, -0.024933, 1.000000, 1.000000},
            {0.997987, -0.024933, 1.000000, 1.000000},
            {0.995476, -0.024933, 1.000000, 1.000000},
            {0.991971, -0.024933, 1.000000, 1.000000},
            {0.987483, -0.024933, 1.000000, 1.000000},
            {0.982025, -0.024933, 1.000000, 1.000000},
            {0.975613, -0.024933, 1.000000, 1.000000},
            {0.968267, -0.024933, 1.000000, 0.999999},
            {0.960006, -0.024933, 1.000000, 0.999999},
            {0.950856, -0.024933, 0.999997, 0.999998},
            {0.940840, -0.024933, 0.999997, 0.999995},
            {0.929989, -0.024933, 0.999992, 0.999990},
            {0.918331, -0.024933, 0.999984, 0.999980},
            {0.905898, -0.024933, 0.999970, 0.999959},
            {0.892723, -0.024933, 0.999946, 0.999923},
            {0.878841, -0.024933, 0.999904, 0.999842},
            {0.864289, -0.024932, 0.999830, 0.999660},
            {0.849104, -0.024931, 0.999697, 0.999119},
            {0.833333, -0.024932, 0.999449, 0.996613},
            {0.817027, -0.024932, 0.998948, 0.981824},
            {0.800276, -0.024930, 0.997807, 0.979298},
            {0.783295, -0.024928, 0.994653, 0.978826},
            {0.766938, -0.024898, 0.983852, 0.977957},
            {0.752213, -0.024927, 0.959419, 0.976184},
            {0.734147, -0.024899, 0.957749, 0.972091},
            {0.715733, -0.024939, 0.956543, 0.962188},
            {0.696240, 0.000000, 0.954606, 0.953875},
            {0.678536, -0.024902, 0.951381, 0.949746},
            {0.659513, 0.000000, 0.945858, 0.942335},
            {0.642559, -0.024779, 0.936342, 0.930166},
            {0.625606, 0.000000, 0.920614, 0.921210},
            {0.609674, 0.000000, 0.904315, 0.910927},
            {0.591298, 0.000000, 0.897007, 0.896979},
            {0.574139, 0.000000, 0.886688, 0.884940},
            {0.558101, 0.000000, 0.872241, 0.869864},
            {0.543946, -0.024354, 0.852983, 0.854835},
            {0.528995, 0.000000, 0.836911, 0.838200},
            {0.514853, 0.000000, 0.822166, 0.821049},
            {0.502417, 0.000000, 0.803528, 0.802552},
            {0.486805, 0.000000, 0.782203, 0.783659},
            {0.474299, -0.022846, 0.763846, 0.763512},
            {0.462847, 0.000000, 0.743709, 0.742928},
            {0.452744, 0.000000, 0.720980, 0.721715},
            {0.443175, 0.000000, 0.700119, 0.699938},
            {0.434336, 0.000000, 0.678156, 0.677775},
            {0.421343, 0.000000, 0.654803, 0.655246},
            {0.412596, 0.000000, 0.632943, 0.632555},
            {0.405555, 0.000000, 0.609625, 0.609805},
            {0.398658, 0.000000, 0.586737, 0.586996},
            {0.392295, 0.000000, 0.564492, 0.564225},
            {0.386586, -0.014003, 0.541467, 0.541606},
            {0.381954, 0.000000, 0.519571, 0.519346},
            {0.377585, 0.000000, 0.497281, 0.497419},
            {0.373750, 0.000000, 0.475742, 0.475863},
            {0.370059, 0.000000, 0.454735, 0.454738},
            {0.367293, 0.000000, 0.433983, 0.434099},
            {0.355295, 0.000000, 0.414179, 0.414003},
            {0.352035, 0.000000, 0.394488, 0.394547},
            {0.349309, 0.000000, 0.375773, 0.375747},
            {0.346337, 0.000000, 0.357459, 0.357564},
            {0.344289, 0.000000, 0.339888, 0.340012},
            {0.342385, 0.000000, 0.323148, 0.323099},
            {0.340625, 0.000000, 0.306793, 0.306861},
            {0.998003, -0.049866, 1.000000, 1.000000},
            {0.998003, -0.049866, 1.000000, 1.000000},
            {0.997988, -0.049866, 1.000000, 1.000000},
            {0.995478, -0.049866, 1.000002, 1.000000},
            {0.991975, -0.049866, 1.000000, 1.000000},
            {0.987489, -0.049867, 1.000000, 1.000000},
            {0.982034, -0.049866, 1.000000, 1.000000},
            {0.975625, -0.049866, 0.999999, 1.000000},
            {0.968281, -0.049866, 0.999999, 1.000000},
            {0.960024, -0.049866, 1.000000, 0.999999},
            {0.950878, -0.049866, 0.999998, 0.999998},
            {0.940867, -0.049866, 0.999996, 0.999995},
            {0.930021, -0.049867, 0.999990, 0.999991},
            {0.918368, -0.049866, 0.999982, 0.999979},
            {0.905940, -0.049866, 0.999968, 0.999959},
            {0.892771, -0.049866, 0.999943, 0.999917},
            {0.878894, -0.049865, 0.999900, 0.999839},
            {0.864347, -0.049865, 0.999824, 0.999648},
            {0.849170, -0.049864, 0.999688, 0.999074},
            {0.833405, -0.049862, 0.999435, 0.996168},
            {0.817106, -0.049860, 0.998922, 0.983770},
            {0.800368, -0.049859, 0.997732, 0.979279},
            {0.783434, -0.049852, 0.994345, 0.978800},
            {0.767198, -0.049844, 0.982442, 0.977905},
            {0.751830, -0.049854, 0.962724, 0.976058},
            {0.734307, -0.049891, 0.957709, 0.971727},
            {0.715836, -0.049800, 0.956485, 0.962121},
            {0.697275, -0.049806, 0.954508, 0.953901},
            {0.678684, -0.049766, 0.951207, 0.949486},
            {0.660378, -0.049677, 0.945530, 0.941859},
            {0.642768, -0.049649, 0.935758, 0.930911},
            {0.624114, 0.000000, 0.919995, 0.920853},
            {0.608184, 0.000000, 0.905935, 0.910394},
            {0.592436, -0.049684, 0.896665, 0.897600},
            {0.574801, -0.049064, 0.886201, 0.884427},
            {0.558841, -0.048919, 0.871593, 0.870101},
            {0.543990, -0.048584, 0.853807, 0.854522},
            {0.529455, -0.048104, 0.837072, 0.838324},
            {0.515362, -0.047101, 0.821582, 0.820754},
            {0.501449, -0.048662, 0.802835, 0.802707},
            {0.486926, -0.046096, 0.783127, 0.783223},
            {0.473875, 0.000000, 0.763264, 0.763605},
            {0.463146, -0.044152, 0.743037, 0.742872},
            {0.452702, -0.042712, 0.721654, 0.721566},
            {0.443504, -0.041490, 0.699715, 0.699935},
            {0.434940, -0.039957, 0.677699, 0.677726},
            {0.423599, -0.042554, 0.655375, 0.655242},
            {0.413140, -0.037371, 0.632370, 0.632580},
            {0.405165, 0.000000, 0.609875, 0.609766},
            {0.398658, 0.000000, 0.587031, 0.586946},
            {0.392295, 0.000000, 0.564122, 0.564275},
            {0.387639, 0.000000, 0.541893, 0.541759},
            {0.381954, 0.000000, 0.519214, 0.519467},
            {0.377585, 0.000000, 0.497585, 0.497478},
            {0.373750, 0.000000, 0.475921, 0.475886},
            {0.370059, 0.000000, 0.454763, 0.454794},
            {0.366902, 0.000000, 0.434326, 0.434233},
            {0.356076, 0.000000, 0.413974, 0.414207},
            {0.352035, 0.000000, 0.394835, 0.394751},
            {0.349309, 0.000000, 0.375763, 0.375892},
            {0.346727, 0.000000, 0.357711, 0.357683},
            {0.344368, -0.004874, 0.340185, 0.340146},
            {0.341995, 0.000000, 0.323117, 0.323287},
            {0.340234, 0.000000, 0.307143, 0.307095},
            {0.998005, -0.074800, 1.000000, 1.000000},
            {0.998005, -0.074800, 1.000000, 1.000000},
            {0.997989, -0.074800, 1.000000, 1.000000},
            {0.995482, -0.074800, 1.000000, 1.000000},
            {0.991981, -0.074799, 0.999999, 1.000000},
            {0.987499, -0.074799, 1.000001, 1.000000},
            {0.982048, -0.074800, 0.999999, 1.000000},
            {0.975644, -0.074800, 1.000000, 0.999999},
            {0.968306, -0.074799, 0.999999, 0.999999},
            {0.960055, -0.074799, 0.999999, 0.999998},
            {0.950915, -0.074799, 0.999996, 0.999996},
            {0.940912, -0.074799, 0.999993, 0.999992},
            {0.930073, -0.074799, 0.999988, 0.999986},
            {0.918428, -0.074799, 0.999980, 0.999975},
            {0.906010, -0.074798, 0.999963, 0.999953},
            {0.892849, -0.074799, 0.999937, 0.999913},
            {0.878983, -0.074797, 0.999893, 0.999831},
            {0.864446, -0.074797, 0.999815, 0.999630},
            {0.849279, -0.074796, 0.999675, 0.998993},
            {0.833525, -0.074794, 0.999412, 0.995279},
            {0.817240, -0.074790, 0.998875, 0.985142},
            {0.800524, -0.074784, 0.997599, 0.979252},
            {0.783647, -0.074776, 0.993783, 0.978754},
            {0.767638, -0.074775, 0.980223, 0.977821},
            {0.751616, -0.074757, 0.965475, 0.975838},
            {0.734464, -0.074775, 0.957641, 0.971088},
            {0.716089, -0.074751, 0.956383, 0.962563},
            {0.697483, -0.074705, 0.954342, 0.954785},
            {0.678963, -0.074588, 0.950908, 0.949048},
            {0.660703, -0.074592, 0.944969, 0.941052},
            {0.643282, -0.074401, 0.934767, 0.931420},
            {0.626737, -0.074134, 0.920455, 0.920812},
            {0.609705, -0.074313, 0.907562, 0.909750},
            {0.592826, -0.074342, 0.896089, 0.897867},
            {0.575511, -0.074140, 0.885384, 0.883856},
            {0.559294, -0.073259, 0.870510, 0.870091},
            {0.544011, -0.072854, 0.854485, 0.854353},
            {0.529599, -0.071680, 0.837734, 0.838166},
            {0.515483, -0.071477, 0.820604, 0.820660},
            {0.501280, -0.071688, 0.802494, 0.802465},
            {0.485047, 0.000000, 0.783623, 0.783308},
            {0.474914, -0.068065, 0.763158, 0.763346},
            {0.463564, -0.066178, 0.742549, 0.742734},
            {0.453014, -0.064497, 0.721900, 0.721608},
            {0.443748, -0.062709, 0.699694, 0.699747},
            {0.433817, -0.062013, 0.677508, 0.677626},
            {0.424097, -0.060662, 0.655527, 0.655245},
            {0.413480, -0.056359, 0.632293, 0.632547},
            {0.405965, -0.052903, 0.609870, 0.609793},
            {0.398983, -0.050538, 0.587081, 0.587044},
            {0.392272, 0.000000, 0.564170, 0.564340},
            {0.386843, 0.000000, 0.541957, 0.541779},
            {0.381677, 0.000000, 0.519511, 0.519529},
            {0.377585, 0.000000, 0.497623, 0.497633},
            {0.373637, -0.031504, 0.476084, 0.476114},
            {0.370449, 0.000000, 0.454958, 0.455030},
            {0.366902, 0.000000, 0.434418, 0.434430},
            {0.355295, 0.000000, 0.414408, 0.414405},
            {0.352035, 0.000000, 0.394929, 0.394974},
            {0.348919, 0.000000, 0.376155, 0.376154},
            {0.346727, 0.000000, 0.357923, 0.357979},
            {0.344094, -0.007267, 0.340392, 0.340443},
            {0.342385, 0.000000, 0.323558, 0.323572},
            {0.340234, 0.000000, 0.307301, 0.307379},
            {0.998007, -0.099733, 1.000001, 1.000000},
            {0.998007, -0.099733, 1.000001, 1.000000},
            {0.997992, -0.099733, 1.000000, 1.000000},
            {0.995487, -0.099733, 0.999999, 1.000000},
            {0.991990, -0.099733, 1.000000, 1.000000},
            {0.987512, -0.099733, 0.999999, 1.000000},
            {0.982067, -0.099732, 0.999999, 1.000000},
            {0.975670, -0.099733, 0.999999, 1.000000},
            {0.968340, -0.099733, 1.000000, 0.999998},
            {0.960098, -0.099733, 0.999996, 0.999998},
            {0.950968, -0.099733, 0.999995, 0.999996},
            {0.940974, -0.099732, 0.999991, 0.999991},
            {0.930146, -0.099732, 0.999986, 0.999984},
            {0.918514, -0.099732, 0.999976, 0.999970},
            {0.906107, -0.099731, 0.999959, 0.999946},
            {0.892960, -0.099730, 0.999930, 0.999905},
            {0.879107, -0.099729, 0.999883, 0.999815},
            {0.864585, -0.099729, 0.999800, 0.999599},
            {0.849431, -0.099728, 0.999654, 0.998856},
            {0.833693, -0.099723, 0.999379, 0.993704},
            {0.817427, -0.099719, 0.998808, 0.986135},
            {0.800736, -0.099715, 0.997397, 0.979212},
            {0.783956, -0.099708, 0.992878, 0.978690},
            {0.767937, -0.099711, 0.979584, 0.977691},
            {0.751546, -0.099690, 0.967744, 0.975504},
            {0.734680, -0.099589, 0.957621, 0.970133},
            {0.716392, -0.099665, 0.956237, 0.962951},
            {0.697773, -0.099567, 0.954101, 0.955649},
            {0.679296, -0.099523, 0.950472, 0.948405},
            {0.661153, -0.099375, 0.944153, 0.940418},
            {0.643878, -0.099176, 0.933351, 0.931660},
            {0.626746, -0.099062, 0.921050, 0.920881},
            {0.609873, -0.099020, 0.908793, 0.909376},
            {0.593113, -0.098862, 0.895924, 0.897785},
            {0.576319, -0.098600, 0.884225, 0.883844},
            {0.559802, -0.097839, 0.869820, 0.869756},
            {0.544441, -0.096960, 0.854894, 0.854326},
            {0.529932, -0.095872, 0.838151, 0.837732},
            {0.515779, -0.095548, 0.819548, 0.820617},
            {0.501731, -0.095113, 0.802226, 0.802053},
            {0.488460, -0.094089, 0.783689, 0.783195},
            {0.475327, -0.090839, 0.762983, 0.763119},
            {0.464226, -0.088742, 0.742139, 0.742610},
            {0.453269, -0.086276, 0.721726, 0.721344},
            {0.443945, -0.082999, 0.699622, 0.699709},
            {0.433817, -0.083011, 0.677414, 0.677623},
            {0.424498, -0.080343, 0.655256, 0.655114},
            {0.414815, -0.075562, 0.632608, 0.632523},
            {0.406163, -0.070498, 0.609704, 0.609812},
            {0.399245, -0.067020, 0.587097, 0.587052},
            {0.393124, -0.062668, 0.564505, 0.564417},
            {0.387649, -0.057298, 0.541749, 0.541966},
            {0.382560, -0.052581, 0.519836, 0.519751},
            {0.377529, 0.000000, 0.497710, 0.497824},
            {0.373563, 0.000000, 0.476366, 0.476309},
            {0.370059, 0.000000, 0.455306, 0.455271},
            {0.366902, 0.000000, 0.434612, 0.434735},
            {0.354904, 0.000000, 0.414817, 0.414736},
            {0.352035, 0.000000, 0.395202, 0.395317},
            {0.349309, 0.000000, 0.376564, 0.376524},
            {0.346337, 0.000000, 0.358293, 0.358364},
            {0.344133, -0.010306, 0.340758, 0.340852},
            {0.341995, 0.000000, 0.324003, 0.323988},
            {0.340234, 0.000000, 0.307692, 0.307786},
            {0.998010, -0.124666, 1.000001, 1.000000},
            {0.998010, -0.124666, 1.000001, 1.000000},
            {0.997994, -0.124666, 1.000000, 1.000000},
            {0.995493, -0.124666, 0.999999, 1.000000},
            {0.992001, -0.124666, 1.000000, 1.000000},
            {0.987530, -0.124666, 1.000000, 1.000000},
            {0.982092, -0.124666, 0.999999, 0.999999},
            {0.975703, -0.124666, 0.999999, 0.999999},
            {0.968383, -0.124666, 0.999997, 0.999997},
            {0.960153, -0.124665, 0.999996, 0.999996},
            {0.951035, -0.124666, 0.999994, 0.999994},
            {0.941055, -0.124665, 0.999989, 0.999989},
            {0.930242, -0.124664, 0.999982, 0.999980},
            {0.918624, -0.124665, 0.999970, 0.999965},
            {0.906233, -0.124663, 0.999951, 0.999940},
            {0.893102, -0.124662, 0.999920, 0.999895},
            {0.879266, -0.124662, 0.999869, 0.999796},
            {0.864762, -0.124659, 0.999781, 0.999559},
            {0.849629, -0.124657, 0.999627, 0.998638},
            {0.833908, -0.124653, 0.999335, 0.992774},
            {0.817668, -0.124645, 0.998716, 0.986878},
            {0.801021, -0.124637, 0.997103, 0.980297},
            {0.784393, -0.124629, 0.991495, 0.978602},
            {0.768238, -0.124616, 0.979466, 0.977514},
            {0.751591, -0.124581, 0.969611, 0.975026},
            {0.734773, -0.124573, 0.959383, 0.969169},
            {0.716714, -0.124564, 0.956046, 0.963214},
            {0.698253, -0.124507, 0.953779, 0.956267},
            {0.679802, -0.124364, 0.949880, 0.947689},
            {0.661770, -0.124175, 0.943050, 0.940054},
            {0.644439, -0.124130, 0.932086, 0.931637},
            {0.627064, -0.123910, 0.921443, 0.920678},
            {0.609990, -0.123776, 0.909707, 0.908990},
            {0.593436, -0.123513, 0.896351, 0.897349},
            {0.577073, -0.123060, 0.882710, 0.883905},
            {0.560607, -0.122310, 0.869399, 0.869139},
            {0.544946, -0.121039, 0.854934, 0.854177},
            {0.530011, -0.120548, 0.838158, 0.837476},
            {0.516098, -0.119524, 0.819443, 0.820295},
            {0.502275, -0.118482, 0.801765, 0.801977},
            {0.488962, -0.116352, 0.783326, 0.782798},
            {0.475847, -0.113155, 0.762984, 0.762978},
            {0.464642, -0.110482, 0.742223, 0.742418},
            {0.454059, -0.107284, 0.721135, 0.721193},
            {0.443653, -0.105104, 0.699750, 0.699560},
            {0.434044, -0.103018, 0.677474, 0.677402},
            {0.424792, -0.099393, 0.654870, 0.655108},
            {0.415998, -0.095481, 0.632726, 0.632543},
            {0.406385, -0.087957, 0.609722, 0.609804},
            {0.399631, -0.082885, 0.587096, 0.587158},
            {0.393386, -0.078041, 0.564603, 0.564557},
            {0.387760, -0.073057, 0.542021, 0.542096},
            {0.382730, -0.066062, 0.519998, 0.519908},
            {0.377029, 0.000000, 0.498098, 0.498089},
            {0.373195, 0.000000, 0.476529, 0.476632},
            {0.369670, 0.000000, 0.455626, 0.455623},
            {0.363865, -0.047976, 0.435142, 0.435104},
            {0.355295, 0.000000, 0.415047, 0.415161},
            {0.351644, 0.000000, 0.395796, 0.395783},
            {0.349309, 0.000000, 0.376910, 0.377005},
            {0.347118, 0.000000, 0.358875, 0.358843},
            {0.344033, -0.012357, 0.341346, 0.341345},
            {0.341995, 0.000000, 0.324417, 0.324529},
            {0.339844, 0.000000, 0.308354, 0.308355},
            {0.998013, -0.149599, 1.000001, 1.000000},
            {0.998013, -0.149599, 1.000001, 1.000000},
            {0.997998, -0.149599, 1.000000, 1.000000},
            {0.995501, -0.149599, 1.000001, 1.000000},
            {0.992015, -0.149599, 1.000000, 1.000000},
            {0.987551, -0.149599, 0.999998, 0.999999},
            {0.982122, -0.149599, 0.999999, 0.999999},
            {0.975745, -0.149599, 0.999998, 0.999998},
            {0.968437, -0.149599, 0.999996, 0.999997},
            {0.960219, -0.149598, 0.999993, 0.999992},
            {0.951117, -0.149598, 0.999992, 0.999991},
            {0.941153, -0.149599, 0.999986, 0.999984},
            {0.930357, -0.149597, 0.999976, 0.999977},
            {0.918757, -0.149596, 0.999963, 0.999959},
            {0.906386, -0.149594, 0.999941, 0.999935},
            {0.893276, -0.149595, 0.999908, 0.999878},
            {0.879460, -0.149592, 0.999852, 0.999773},
            {0.864978, -0.149591, 0.999758, 0.999505},
            {0.849866, -0.149584, 0.999594, 0.998284},
            {0.834175, -0.149579, 0.999279, 0.992353},
            {0.817961, -0.149573, 0.998594, 0.987457},
            {0.801368, -0.149565, 0.996678, 0.981665},
            {0.784957, -0.149551, 0.989437, 0.978492},
            {0.768560, -0.149524, 0.979658, 0.977277},
            {0.751736, -0.149500, 0.971115, 0.974360},
            {0.734841, -0.149475, 0.961485, 0.968716},
            {0.717145, -0.149447, 0.955802, 0.963374},
            {0.698753, -0.149378, 0.953362, 0.956629},
            {0.680352, -0.149196, 0.949107, 0.947397},
            {0.662511, -0.149037, 0.941623, 0.939657},
            {0.645011, -0.148896, 0.931489, 0.931339},
            {0.627499, -0.148682, 0.921687, 0.920588},
            {0.610295, -0.148405, 0.910304, 0.908975},
            {0.593805, -0.148025, 0.896685, 0.896712},
            {0.577917, -0.147631, 0.881347, 0.883763},
            {0.561646, -0.146706, 0.868825, 0.868890},
            {0.545586, -0.145065, 0.854604, 0.853731},
            {0.530487, -0.144351, 0.837705, 0.837333},
            {0.516539, -0.143385, 0.819667, 0.819702},
            {0.502760, -0.141577, 0.801112, 0.801738},
            {0.489904, -0.139676, 0.782527, 0.782454},
            {0.477751, -0.137187, 0.763006, 0.762712},
            {0.465275, -0.132897, 0.742172, 0.742024},
            {0.454775, -0.128364, 0.720495, 0.721037},
            {0.443848, -0.126589, 0.699600, 0.699325},
            {0.434338, -0.122553, 0.677377, 0.677359},
            {0.425289, -0.119426, 0.654861, 0.655030},
            {0.416113, -0.114183, 0.632587, 0.632439},
            {0.406646, -0.105950, 0.609956, 0.609869},
            {0.400168, -0.099864, 0.587146, 0.587221},
            {0.393393, -0.092724, 0.564662, 0.564663},
            {0.387897, -0.086827, 0.542425, 0.542328},
            {0.382989, -0.078421, 0.520021, 0.520220},
            {0.378406, -0.072065, 0.498508, 0.498400},
            {0.372973, 0.000000, 0.476946, 0.476997},
            {0.369892, 0.000000, 0.455980, 0.456053},
            {0.363604, -0.055038, 0.435604, 0.435593},
            {0.355322, -0.043520, 0.415619, 0.415658},
            {0.351254, 0.000000, 0.396344, 0.396300},
            {0.348919, 0.000000, 0.377520, 0.377577},
            {0.346337, 0.000000, 0.359392, 0.359473},
            {0.344033, -0.013267, 0.341958, 0.342004},
            {0.341994, 0.000000, 0.325138, 0.325170},
            {0.340234, 0.000000, 0.308978, 0.308997},
            {0.998017, -0.174532, 1.000000, 1.000000},
            {0.998017, -0.174532, 1.000000, 1.000000},
            {0.998002, -0.174532, 1.000000, 1.000000},
            {0.995510, -0.174532, 1.000000, 1.000000},
            {0.992031, -0.174532, 1.000000, 1.000000},
            {0.987576, -0.174532, 0.999998, 0.999999},
            {0.982158, -0.174532, 0.999998, 0.999998},
            {0.975794, -0.174532, 0.999996, 0.999998},
            {0.968499, -0.174532, 0.999996, 0.999996},
            {0.960299, -0.174531, 0.999993, 0.999992},
            {0.951213, -0.174530, 0.999989, 0.999988},
            {0.941268, -0.174531, 0.999982, 0.999981},
            {0.930493, -0.174529, 0.999971, 0.999971},
            {0.918917, -0.174528, 0.999955, 0.999952},
            {0.906567, -0.174526, 0.999931, 0.999921},
            {0.893483, -0.174525, 0.999893, 0.999863},
            {0.879692, -0.174521, 0.999832, 0.999748},
            {0.865234, -0.174519, 0.999731, 0.999433},
            {0.850150, -0.174515, 0.999553, 0.997680},
            {0.834484, -0.174508, 0.999211, 0.992120},
            {0.818308, -0.174495, 0.998433, 0.987920},
            {0.801794, -0.174488, 0.996063, 0.982864},
            {0.785589, -0.174473, 0.987451, 0.978353},
            {0.768932, -0.174437, 0.979839, 0.976961},
            {0.751980, -0.174425, 0.972340, 0.973451},
            {0.734960, -0.174375, 0.963656, 0.968396},
            {0.717674, -0.174339, 0.955498, 0.963400},
            {0.699330, -0.174267, 0.952834, 0.956680},
            {0.681149, -0.174094, 0.948118, 0.947529},
            {0.663342, -0.173892, 0.939830, 0.939151},
            {0.645663, -0.173746, 0.931115, 0.930747},
            {0.627999, -0.173486, 0.921785, 0.920511},
            {0.610831, -0.173049, 0.910534, 0.908867},
            {0.594427, -0.172682, 0.896589, 0.896142},
            {0.578503, -0.171979, 0.881321, 0.883335},
            {0.562470, -0.171048, 0.868139, 0.868764},
            {0.546105, -0.169632, 0.853896, 0.853025},
            {0.531429, -0.168226, 0.837156, 0.837015},
            {0.517261, -0.166574, 0.819794, 0.819452},
            {0.503478, -0.165037, 0.800873, 0.801249},
            {0.490768, -0.162795, 0.781791, 0.782176},
            {0.478109, -0.159164, 0.762733, 0.762345},
            {0.466228, -0.153915, 0.741928, 0.741843},
            {0.454693, -0.151504, 0.720465, 0.720721},
            {0.444531, -0.147723, 0.699137, 0.699135},
            {0.434511, -0.142839, 0.677326, 0.677193},
            {0.425672, -0.138472, 0.655015, 0.654889},
            {0.416701, -0.131783, 0.632203, 0.632487},
            {0.408557, -0.125120, 0.610078, 0.609902},
            {0.400564, -0.116431, 0.587325, 0.587328},
            {0.393033, -0.107098, 0.564768, 0.564891},
            {0.388423, -0.100189, 0.542619, 0.542567},
            {0.383167, -0.092935, 0.520485, 0.520501},
            {0.378436, -0.083485, 0.498665, 0.498793},
            {0.372456, 0.000000, 0.477487, 0.477442},
            {0.369608, 0.000000, 0.456553, 0.456528},
            {0.363472, -0.064706, 0.436142, 0.436131},
            {0.358164, -0.054311, 0.416344, 0.416273},
            {0.351472, 0.000000, 0.396827, 0.396980},
            {0.348528, 0.000000, 0.378254, 0.378276},
            {0.346337, 0.000000, 0.360116, 0.360177},
            {0.343821, -0.017100, 0.342718, 0.342738},
            {0.341973, -0.008623, 0.325998, 0.325950},
            {0.339844, 0.000000, 0.309684, 0.309803},
            {0.998022, -0.199466, 1.000000, 1.000000},
            {0.998022, -0.199466, 1.000000, 1.000000},
            {0.998006, -0.199465, 1.000000, 1.000000},
            {0.995520, -0.199465, 1.000000, 1.000000},
            {0.992050, -0.199466, 0.999999, 1.000000},
            {0.987605, -0.199465, 1.000000, 0.999999},
            {0.982199, -0.199464, 0.999999, 0.999999},
            {0.975850, -0.199465, 0.999997, 0.999997},
            {0.968573, -0.199465, 0.999995, 0.999995},
            {0.960391, -0.199466, 0.999990, 0.999991},
            {0.951324, -0.199464, 0.999985, 0.999985},
            {0.941402, -0.199464, 0.999976, 0.999978},
            {0.930650, -0.199464, 0.999965, 0.999963},
            {0.919097, -0.199460, 0.999946, 0.999942},
            {0.906777, -0.199457, 0.999919, 0.999907},
            {0.893717, -0.199456, 0.999877, 0.999844},
            {0.879958, -0.199450, 0.999809, 0.999715},
            {0.865532, -0.199447, 0.999698, 0.999332},
            {0.850476, -0.199442, 0.999505, 0.996612},
            {0.834846, -0.199431, 0.999127, 0.991974},
            {0.818711, -0.199418, 0.998221, 0.988297},
            {0.802309, -0.199400, 0.995152, 0.983843},
            {0.786139, -0.199378, 0.986538, 0.978349},
            {0.769397, -0.199360, 0.979924, 0.976540},
            {0.752369, -0.199306, 0.973351, 0.972351},
            {0.735233, -0.199259, 0.965362, 0.968109},
            {0.718078, -0.199210, 0.956530, 0.963281},
            {0.700065, -0.199094, 0.952173, 0.956464},
            {0.681951, -0.198954, 0.946874, 0.947779},
            {0.664227, -0.198680, 0.938478, 0.938754},
            {0.646343, -0.198504, 0.930550, 0.929952},
            {0.628704, -0.198237, 0.921642, 0.920253},
            {0.611536, -0.197696, 0.910391, 0.908530},
            {0.595206, -0.197049, 0.896140, 0.895785},
            {0.579187, -0.196341, 0.881745, 0.882679},
            {0.563419, -0.195271, 0.867146, 0.868456},
            {0.547670, -0.194077, 0.852802, 0.852669},
            {0.532267, -0.192403, 0.836808, 0.836406},
            {0.517804, -0.190552, 0.819559, 0.819138},
            {0.504444, -0.188091, 0.800583, 0.800708},
            {0.491803, -0.185303, 0.781154, 0.781803},
            {0.479418, -0.182071, 0.762128, 0.761855},
            {0.467285, -0.176740, 0.741658, 0.741534},
            {0.455649, -0.173278, 0.720544, 0.720405},
            {0.445010, -0.168298, 0.698484, 0.698959},
            {0.435292, -0.163204, 0.677109, 0.676964},
            {0.426280, -0.156678, 0.654864, 0.654827},
            {0.417611, -0.150564, 0.632290, 0.632411},
            {0.409411, -0.142547, 0.609907, 0.609922},
            {0.400622, -0.132929, 0.587561, 0.587477},
            {0.394428, -0.124135, 0.565101, 0.565050},
            {0.388433, -0.115203, 0.542818, 0.542829},
            {0.383590, -0.106024, 0.520961, 0.520889},
            {0.378708, -0.095563, 0.499103, 0.499225},
            {0.372967, -0.088771, 0.477962, 0.477951},
            {0.369232, 0.000000, 0.457135, 0.457148},
            {0.363690, -0.072637, 0.436734, 0.436791},
            {0.358323, -0.062925, 0.416955, 0.416963},
            {0.351406, 0.000000, 0.397717, 0.397723},
            {0.349309, 0.000000, 0.379007, 0.379068},
            {0.346337, 0.000000, 0.361031, 0.361025},
            {0.343927, -0.018620, 0.343566, 0.343608},
            {0.341457, -0.004841, 0.326753, 0.326842},
            {0.339062, 0.000000, 0.310702, 0.310718},
            {0.998027, -0.224399, 0.999999, 0.999999},
            {0.998027, -0.224399, 0.999999, 0.999999},
            {0.998012, -0.224399, 1.000000, 0.999999},
            {0.995532, -0.224399, 1.000000, 0.999999},
            {0.992071, -0.224399, 0.999999, 0.999999},
            {0.987638, -0.224398, 0.999998, 0.999999},
            {0.982247, -0.224398, 0.999998, 0.999998},
            {0.975913, -0.224397, 0.999996, 0.999994},
            {0.968655, -0.224397, 0.999993, 0.999994},
            {0.960494, -0.224396, 0.999988, 0.999990},
            {0.951451, -0.224398, 0.999982, 0.999983},
            {0.941555, -0.224395, 0.999972, 0.999971},
            {0.930829, -0.224394, 0.999958, 0.999954},
            {0.919304, -0.224394, 0.999936, 0.999932},
            {0.907014, -0.224392, 0.999903, 0.999892},
            {0.893987, -0.224382, 0.999857, 0.999820},
            {0.880255, -0.224383, 0.999783, 0.999675},
            {0.865865, -0.224372, 0.999662, 0.999190},
            {0.850847, -0.224359, 0.999449, 0.995492},
            {0.835255, -0.224353, 0.999024, 0.991911},
            {0.819178, -0.224337, 0.997936, 0.988610},
            {0.802931, -0.224324, 0.993787, 0.984662},
            {0.786708, -0.224296, 0.985865, 0.979221},
            {0.769921, -0.224271, 0.979968, 0.975975},
            {0.752803, -0.224206, 0.974190, 0.971671},
            {0.735663, -0.224138, 0.966648, 0.967788},
            {0.718470, -0.224040, 0.958051, 0.963002},
            {0.700804, -0.223941, 0.951349, 0.955938},
            {0.682895, -0.223842, 0.945325, 0.947964},
            {0.665121, -0.223624, 0.937613, 0.938692},
            {0.647189, -0.223217, 0.930151, 0.929309},
            {0.629574, -0.222855, 0.921248, 0.919781},
            {0.612434, -0.222434, 0.909867, 0.908267},
            {0.596037, -0.221683, 0.896151, 0.895518},
            {0.579976, -0.220658, 0.881943, 0.882022},
            {0.564195, -0.219908, 0.866677, 0.867884},
            {0.548836, -0.218443, 0.851554, 0.852346},
            {0.532999, -0.216171, 0.836276, 0.835746},
            {0.518642, -0.214135, 0.819210, 0.818607},
            {0.505233, -0.211584, 0.800352, 0.800261},
            {0.492462, -0.208315, 0.780997, 0.781335},
            {0.480614, -0.204064, 0.761186, 0.761539},
            {0.468125, -0.199492, 0.741318, 0.741063},
            {0.456020, -0.194454, 0.720254, 0.720116},
            {0.445911, -0.190284, 0.698417, 0.698617},
            {0.436025, -0.182811, 0.676778, 0.676815},
            {0.426951, -0.175659, 0.654860, 0.654700},
            {0.418488, -0.167981, 0.632431, 0.632388},
            {0.410008, -0.160241, 0.609716, 0.610037},
            {0.401561, -0.149331, 0.587745, 0.587591},
            {0.395057, -0.138999, 0.565368, 0.565328},
            {0.389084, -0.129040, 0.543082, 0.543205},
            {0.383746, -0.118135, 0.521279, 0.521293},
            {0.379130, -0.106869, 0.499792, 0.499745},
            {0.372505, -0.100363, 0.478451, 0.478562},
            {0.369180, 0.000000, 0.457849, 0.457776},
            {0.363416, -0.081489, 0.437482, 0.437515},
            {0.357859, -0.069490, 0.417636, 0.417776},
            {0.351406, 0.000000, 0.398638, 0.398586},
            {0.348854, -0.042826, 0.379941, 0.379963},
            {0.345946, 0.000000, 0.361951, 0.361984},
            {0.343677, -0.022048, 0.344548, 0.344616},
            {0.341790, -0.011875, 0.327777, 0.327857},
            {0.339844, 0.000000, 0.311769, 0.311751},
            {0.998033, -0.249332, 1.000000, 0.999999},
            {0.998033, -0.249332, 1.000000, 0.999999},
            {0.998018, -0.249332, 0.999999, 0.999999},
            {0.995545, -0.249332, 1.000000, 0.999999},
            {0.992094, -0.249331, 1.000000, 0.999999},
            {0.987675, -0.249331, 0.999999, 0.999999},
            {0.982300, -0.249332, 0.999998, 0.999997},
            {0.975983, -0.249332, 0.999994, 0.999996},
            {0.968747, -0.249330, 0.999991, 0.999992},
            {0.960609, -0.249330, 0.999986, 0.999986},
            {0.951593, -0.249328, 0.999978, 0.999977},
            {0.941723, -0.249329, 0.999966, 0.999965},
            {0.931031, -0.249323, 0.999948, 0.999947},
            {0.919535, -0.249321, 0.999922, 0.999916},
            {0.907278, -0.249314, 0.999888, 0.999873},
            {0.894284, -0.249314, 0.999834, 0.999794},
            {0.880595, -0.249309, 0.999751, 0.999628},
            {0.866241, -0.249298, 0.999619, 0.998966},
            {0.851260, -0.249280, 0.999382, 0.994914},
            {0.835719, -0.249272, 0.998898, 0.991849},
            {0.819705, -0.249250, 0.997542, 0.988873},
            {0.803689, -0.249235, 0.991747, 0.985288},
            {0.787306, -0.249188, 0.985552, 0.980170},
            {0.770490, -0.249145, 0.980255, 0.975207},
            {0.753344, -0.249108, 0.974886, 0.971156},
            {0.736132, -0.249028, 0.968048, 0.967476},
            {0.718938, -0.248888, 0.959566, 0.962538},
            {0.701722, -0.248786, 0.950325, 0.955601},
            {0.683905, -0.248631, 0.943492, 0.947978},
            {0.666124, -0.248382, 0.936773, 0.938541},
            {0.648143, -0.247902, 0.929574, 0.928618},
            {0.630520, -0.247504, 0.920588, 0.919056},
            {0.613525, -0.246993, 0.908949, 0.907890},
            {0.596897, -0.246020, 0.896121, 0.895098},
            {0.580796, -0.245180, 0.882068, 0.881352},
            {0.565223, -0.244015, 0.866256, 0.867263},
            {0.549929, -0.242322, 0.850455, 0.851805},
            {0.534190, -0.239840, 0.835520, 0.835168},
            {0.519745, -0.237669, 0.818448, 0.818003},
            {0.506167, -0.234357, 0.800241, 0.799785},
            {0.493486, -0.230484, 0.780767, 0.780633},
            {0.481641, -0.226612, 0.760388, 0.761080},
            {0.469400, -0.222127, 0.740815, 0.740618},
            {0.457069, -0.215291, 0.719901, 0.719795},
            {0.446560, -0.209903, 0.698423, 0.698332},
            {0.436914, -0.202267, 0.676314, 0.676629},
            {0.427596, -0.194895, 0.654730, 0.654544},
            {0.418767, -0.186099, 0.632448, 0.632411},
            {0.411442, -0.176891, 0.610046, 0.610042},
            {0.401958, -0.164415, 0.587681, 0.587805},
            {0.395643, -0.153837, 0.565682, 0.565593},
            {0.389255, -0.142443, 0.543544, 0.543549},
            {0.384345, -0.130031, 0.521638, 0.521793},
            {0.377918, -0.122184, 0.500376, 0.500309},
            {0.372677, -0.110922, 0.479203, 0.479195},
            {0.368397, -0.099449, 0.458473, 0.458546},
            {0.362789, -0.089046, 0.438397, 0.438353},
            {0.358126, -0.076486, 0.418691, 0.418669},
            {0.351261, 0.000000, 0.399465, 0.399557},
            {0.348617, -0.048163, 0.381017, 0.381012},
            {0.345555, 0.000000, 0.362950, 0.363049},
            {0.343519, -0.024963, 0.345716, 0.345710},
            {0.341207, -0.012142, 0.329006, 0.329006},
            {0.339453, 0.000000, 0.312783, 0.312948},
            {0.998039, -0.274265, 1.000000, 0.999999},
            {0.998039, -0.274265, 1.000000, 0.999999},
            {0.998024, -0.274265, 1.000000, 0.999999},
            {0.995560, -0.274265, 1.000000, 0.999999},
            {0.992120, -0.274265, 0.999999, 0.999999},
            {0.987716, -0.274265, 0.999998, 0.999998},
            {0.982357, -0.274265, 0.999996, 0.999997},
            {0.976062, -0.274264, 0.999993, 0.999993},
            {0.968849, -0.274264, 0.999989, 0.999990},
            {0.960736, -0.274261, 0.999982, 0.999984},
            {0.951751, -0.274261, 0.999972, 0.999972},
            {0.941912, -0.274258, 0.999959, 0.999959},
            {0.931251, -0.274257, 0.999939, 0.999939},
            {0.919789, -0.274252, 0.999911, 0.999906},
            {0.907572, -0.274245, 0.999869, 0.999853},
            {0.894617, -0.274236, 0.999809, 0.999765},
            {0.880963, -0.274234, 0.999716, 0.999567},
            {0.866652, -0.274218, 0.999569, 0.998603},
            {0.851720, -0.274210, 0.999307, 0.994519},
            {0.836220, -0.274194, 0.998741, 0.991794},
            {0.820293, -0.274164, 0.996975, 0.989089},
            {0.804410, -0.274134, 0.990332, 0.985781},
            {0.787985, -0.274100, 0.985107, 0.980956},
            {0.771114, -0.274039, 0.980497, 0.974161},
            {0.753969, -0.273984, 0.975464, 0.970688},
            {0.736722, -0.273876, 0.969143, 0.967064},
            {0.719530, -0.273748, 0.960655, 0.961890},
            {0.702542, -0.273639, 0.950350, 0.955292},
            {0.685065, -0.273418, 0.942177, 0.947848},
            {0.667199, -0.273137, 0.936029, 0.938359},
            {0.649251, -0.272686, 0.928802, 0.928226},
            {0.631679, -0.272205, 0.919638, 0.918214},
            {0.614667, -0.271485, 0.908095, 0.907361},
            {0.597955, -0.270506, 0.895886, 0.894702},
            {0.581750, -0.269595, 0.881994, 0.880834},
            {0.566381, -0.268427, 0.865978, 0.866500},
            {0.551073, -0.266311, 0.849741, 0.851209},
            {0.535956, -0.264236, 0.834375, 0.834627},
            {0.521154, -0.260946, 0.817638, 0.817211},
            {0.507385, -0.257388, 0.799753, 0.799250},
            {0.495153, -0.253061, 0.780198, 0.780131},
            {0.482828, -0.248564, 0.760166, 0.760512},
            {0.470146, -0.244367, 0.740032, 0.740218},
            {0.458252, -0.236553, 0.719560, 0.719264},
            {0.447631, -0.229724, 0.698191, 0.698063},
            {0.437695, -0.222536, 0.676260, 0.676325},
            {0.428515, -0.214088, 0.654251, 0.654450},
            {0.419908, -0.203849, 0.632416, 0.632316},
            {0.412093, -0.194488, 0.610294, 0.610170},
            {0.403844, -0.182293, 0.587843, 0.587988},
            {0.396026, -0.168644, 0.565942, 0.565891},
            {0.390224, -0.155824, 0.544079, 0.544013},
            {0.383679, -0.146284, 0.522337, 0.522305},
            {0.377718, -0.136529, 0.500844, 0.500958},
            {0.372089, -0.122664, 0.480037, 0.479971},
            {0.367591, -0.110665, 0.459304, 0.459377},
            {0.362948, -0.098067, 0.439282, 0.439271},
            {0.358900, -0.086513, 0.419663, 0.419698},
            {0.350659, 0.000000, 0.400520, 0.400620},
            {0.348834, -0.052185, 0.382174, 0.382126},
            {0.345555, 0.000000, 0.364207, 0.364246},
            {0.343254, -0.025501, 0.346905, 0.346967},
            {0.341207, -0.012529, 0.330238, 0.330273},
            {0.339453, 0.000000, 0.314210, 0.314236},
            {0.998047, -0.299198, 1.000000, 0.999999},
            {0.998047, -0.299198, 1.000000, 0.999999},
            {0.998031, -0.299198, 1.000000, 0.999999},
            {0.995576, -0.299198, 1.000000, 0.999999},
            {0.992149, -0.299198, 0.999998, 0.999999},
            {0.987760, -0.299197, 0.999999, 0.999998},
            {0.982420, -0.299196, 0.999997, 0.999996},
            {0.976149, -0.299197, 0.999993, 0.999994},
            {0.968960, -0.299197, 0.999988, 0.999988},
            {0.960877, -0.299196, 0.999979, 0.999979},
            {0.951920, -0.299191, 0.999968, 0.999967},
            {0.942117, -0.299188, 0.999951, 0.999952},
            {0.931487, -0.299188, 0.999928, 0.999924},
            {0.920069, -0.299183, 0.999895, 0.999888},
            {0.907891, -0.299167, 0.999848, 0.999833},
            {0.894980, -0.299161, 0.999781, 0.999733},
            {0.881374, -0.299158, 0.999678, 0.999490},
            {0.867110, -0.299144, 0.999514, 0.997946},
            {0.852228, -0.299124, 0.999217, 0.994192},
            {0.836792, -0.299103, 0.998541, 0.991812},
            {0.820972, -0.299078, 0.996129, 0.989274},
            {0.805132, -0.299045, 0.989510, 0.986224},
            {0.788697, -0.298976, 0.984797, 0.981547},
            {0.771822, -0.298928, 0.980697, 0.974000},
            {0.754669, -0.298842, 0.975936, 0.970269},
            {0.737399, -0.298750, 0.969957, 0.966545},
            {0.720196, -0.298598, 0.961827, 0.961031},
            {0.703393, -0.298440, 0.950509, 0.954921},
            {0.686144, -0.298222, 0.941217, 0.947416},
            {0.668224, -0.297845, 0.935115, 0.938226},
            {0.650534, -0.297584, 0.927812, 0.928003},
            {0.632972, -0.296698, 0.918374, 0.917390},
            {0.615894, -0.295869, 0.907390, 0.906553},
            {0.599096, -0.294917, 0.895483, 0.894191},
            {0.583018, -0.293830, 0.881480, 0.880329},
            {0.567532, -0.292442, 0.865727, 0.865540},
            {0.552499, -0.290664, 0.849488, 0.850476},
            {0.537608, -0.287717, 0.832948, 0.834058},
            {0.522455, -0.284225, 0.816731, 0.816467},
            {0.508922, -0.280434, 0.799042, 0.798509},
            {0.496058, -0.276034, 0.779816, 0.779561},
            {0.483837, -0.270485, 0.759792, 0.759828},
            {0.471412, -0.265351, 0.739233, 0.739738},
            {0.459903, -0.258310, 0.718998, 0.718877},
            {0.448655, -0.250335, 0.697835, 0.697718},
            {0.438634, -0.241947, 0.676333, 0.676138},
            {0.429491, -0.232216, 0.654004, 0.654342},
            {0.420914, -0.222163, 0.632351, 0.632317},
            {0.412545, -0.211082, 0.610378, 0.610292},
            {0.405478, -0.198478, 0.588197, 0.588207},
            {0.396755, -0.182829, 0.566066, 0.566288},
            {0.389951, -0.172310, 0.544559, 0.544443},
            {0.383903, -0.158932, 0.522895, 0.522927},
            {0.377994, -0.147288, 0.501525, 0.501674},
            {0.372753, -0.133649, 0.480854, 0.480765},
            {0.367773, -0.119592, 0.460280, 0.460314},
            {0.362933, -0.104927, 0.440250, 0.440304},
            {0.358734, -0.091380, 0.420794, 0.420782},
            {0.351822, -0.071445, 0.401844, 0.401824},
            {0.348617, -0.056545, 0.383324, 0.383410},
            {0.345555, 0.000000, 0.365498, 0.365538},
            {0.343117, 0.000000, 0.348363, 0.348312},
            {0.341028, -0.013635, 0.331557, 0.331692},
            {0.339062, 0.000000, 0.315681, 0.315688},
            {0.998055, -0.324131, 1.000000, 0.999999},
            {0.998055, -0.324131, 1.000000, 0.999999},
            {0.998039, -0.324131, 1.000001, 0.999999},
            {0.995593, -0.324132, 1.000000, 0.999999},
            {0.992180, -0.324131, 0.999999, 0.999999},
            {0.987807, -0.324130, 0.999998, 0.999998},
            {0.982489, -0.324131, 0.999996, 0.999996},
            {0.976243, -0.324129, 0.999991, 0.999993},
            {0.969081, -0.324127, 0.999985, 0.999985},
            {0.961030, -0.324125, 0.999976, 0.999976},
            {0.952102, -0.324127, 0.999962, 0.999961},
            {0.942338, -0.324121, 0.999943, 0.999943},
            {0.931752, -0.324111, 0.999916, 0.999913},
            {0.920372, -0.324110, 0.999879, 0.999872},
            {0.908246, -0.324104, 0.999825, 0.999807},
            {0.895380, -0.324093, 0.999748, 0.999691},
            {0.881820, -0.324076, 0.999634, 0.999390},
            {0.867608, -0.324060, 0.999452, 0.996859},
            {0.852774, -0.324042, 0.999111, 0.994003},
            {0.837390, -0.324006, 0.998280, 0.991808},
            {0.821738, -0.323966, 0.994823, 0.989423},
            {0.805904, -0.323924, 0.988765, 0.986523},
            {0.789445, -0.323875, 0.984780, 0.981783},
            {0.772580, -0.323787, 0.980854, 0.974511},
            {0.755442, -0.323696, 0.976308, 0.969791},
            {0.738207, -0.323599, 0.970524, 0.965933},
            {0.721033, -0.323435, 0.962465, 0.960377},
            {0.704299, -0.323242, 0.950837, 0.954434},
            {0.687238, -0.322966, 0.940273, 0.946803},
            {0.669490, -0.322611, 0.934089, 0.938026},
            {0.651820, -0.322088, 0.926574, 0.927620},
            {0.634555, -0.321395, 0.916870, 0.916545},
            {0.617157, -0.320559, 0.906614, 0.905639},
            {0.600420, -0.319521, 0.894718, 0.893489},
            {0.584391, -0.317996, 0.880559, 0.879820},
            {0.568739, -0.316379, 0.865682, 0.864852},
            {0.553565, -0.314243, 0.849204, 0.849513},
            {0.539225, -0.311438, 0.831973, 0.833311},
            {0.524118, -0.307328, 0.815541, 0.815878},
            {0.510141, -0.303817, 0.797968, 0.797622},
            {0.497253, -0.299296, 0.779450, 0.778938},
            {0.485035, -0.293331, 0.759429, 0.759253},
            {0.473097, -0.287718, 0.738883, 0.739142},
            {0.461340, -0.279904, 0.718023, 0.718479},
            {0.449436, -0.270651, 0.697541, 0.697274},
            {0.439791, -0.261033, 0.676156, 0.675902},
            {0.430282, -0.250004, 0.654121, 0.654135},
            {0.421908, -0.239887, 0.632177, 0.632357},
            {0.413567, -0.227475, 0.610393, 0.610364},
            {0.405798, -0.214191, 0.588638, 0.588497},
            {0.396800, -0.199125, 0.566611, 0.566631},
            {0.389934, -0.187022, 0.544880, 0.545012},
            {0.383579, -0.173287, 0.523709, 0.523579},
            {0.378222, -0.158683, 0.502422, 0.502429},
            {0.373010, -0.143554, 0.481628, 0.481680},
            {0.368002, -0.128381, 0.461291, 0.461304},
            {0.362959, -0.113550, 0.441508, 0.441425},
            {0.359054, -0.098528, 0.421925, 0.422039},
            {0.351764, -0.078216, 0.403106, 0.403135},
            {0.348437, -0.060463, 0.384854, 0.384779},
            {0.345673, -0.044417, 0.366767, 0.366976},
            {0.342727, 0.000000, 0.349895, 0.349796},
            {0.341021, -0.016250, 0.333130, 0.333231},
            {0.339062, 0.000000, 0.317174, 0.317277},
            {0.998063, -0.349065, 0.999999, 0.999999},
            {0.998063, -0.349065, 0.999999, 0.999999},
            {0.998048, -0.349065, 1.000000, 0.999999},
            {0.995612, -0.349065, 0.999999, 0.999999},
            {0.992213, -0.349064, 0.999999, 0.999999},
            {0.987859, -0.349064, 0.999998, 0.999998},
            {0.982564, -0.349064, 0.999994, 0.999996},
            {0.976343, -0.349061, 0.999991, 0.999991},
            {0.969211, -0.349061, 0.999983, 0.999983},
            {0.961193, -0.349058, 0.999972, 0.999974},
            {0.952307, -0.349054, 0.999956, 0.999956},
            {0.942581, -0.349051, 0.999933, 0.999932},
            {0.932033, -0.349046, 0.999903, 0.999901},
            {0.920704, -0.349040, 0.999861, 0.999852},
            {0.908618, -0.349021, 0.999799, 0.999780},
            {0.895799, -0.349015, 0.999713, 0.999646},
            {0.882295, -0.348992, 0.999586, 0.999248},
            {0.868130, -0.348979, 0.999381, 0.996193},
            {0.853359, -0.348940, 0.998988, 0.993784},
            {0.838064, -0.348902, 0.997924, 0.991782},
            {0.822623, -0.348887, 0.992957, 0.989539},
            {0.806707, -0.348830, 0.988238, 0.986694},
            {0.790234, -0.348745, 0.984718, 0.981765},
            {0.773414, -0.348653, 0.980973, 0.975135},
            {0.756303, -0.348567, 0.976586, 0.969309},
            {0.739084, -0.348434, 0.970852, 0.965129},
            {0.722028, -0.348229, 0.962589, 0.959788},
            {0.705212, -0.347978, 0.951448, 0.953831},
            {0.688326, -0.347747, 0.940777, 0.946255},
            {0.670830, -0.347312, 0.933148, 0.937664},
            {0.653306, -0.346715, 0.925154, 0.927351},
            {0.635985, -0.346114, 0.915690, 0.916044},
            {0.618664, -0.344920, 0.905646, 0.904715},
            {0.602010, -0.343892, 0.893576, 0.892528},
            {0.585720, -0.342376, 0.879958, 0.879111},
            {0.570163, -0.340142, 0.865312, 0.864256},
            {0.555083, -0.338080, 0.848682, 0.848452},
            {0.540592, -0.334705, 0.831603, 0.832434},
            {0.525992, -0.331033, 0.814192, 0.815129},
            {0.511708, -0.326461, 0.796974, 0.796806},
            {0.498571, -0.321685, 0.778734, 0.778118},
            {0.486021, -0.315835, 0.758918, 0.758668},
            {0.474507, -0.308578, 0.738591, 0.738466},
            {0.463200, -0.300658, 0.717452, 0.718024},
            {0.451064, -0.290777, 0.696999, 0.696958},
            {0.440327, -0.280339, 0.675768, 0.675643},
            {0.431670, -0.269370, 0.654222, 0.654067},
            {0.422732, -0.257609, 0.632243, 0.632325},
            {0.414780, -0.243940, 0.610389, 0.610546},
            {0.406640, -0.228902, 0.588978, 0.588786},
            {0.397652, -0.214055, 0.567124, 0.567123},
            {0.390566, -0.199527, 0.545443, 0.545617},
            {0.384346, -0.185413, 0.524416, 0.524312},
            {0.377985, -0.168733, 0.503216, 0.503348},
            {0.373237, -0.152538, 0.482786, 0.482637},
            {0.368156, -0.138102, 0.462156, 0.462418},
            {0.362991, -0.121597, 0.442793, 0.442657},
            {0.359038, -0.104896, 0.423257, 0.423338},
            {0.351661, -0.083763, 0.404482, 0.404564},
            {0.348504, -0.064361, 0.386384, 0.386277},
            {0.345457, 0.000000, 0.368348, 0.368545},
            {0.342998, -0.033262, 0.351508, 0.351448},
            {0.340620, -0.015896, 0.334826, 0.334906},
            {0.338672, 0.000000, 0.318875, 0.318961},
            {0.998072, -0.373998, 1.000000, 0.999998},
            {0.998072, -0.373998, 1.000000, 0.999998},
            {0.998057, -0.373998, 1.000000, 0.999998},
            {0.995633, -0.373997, 1.000000, 0.999998},
            {0.992249, -0.373996, 0.999999, 0.999998},
            {0.987916, -0.373998, 0.999996, 0.999998},
            {0.982645, -0.373995, 0.999993, 0.999994},
            {0.976450, -0.373996, 0.999988, 0.999989},
            {0.969352, -0.373991, 0.999980, 0.999979},
            {0.961368, -0.373990, 0.999967, 0.999968},
            {0.952522, -0.373989, 0.999948, 0.999949},
            {0.942839, -0.373978, 0.999924, 0.999921},
            {0.932335, -0.373967, 0.999888, 0.999886},
            {0.921060, -0.373967, 0.999840, 0.999833},
            {0.909025, -0.373943, 0.999772, 0.999747},
            {0.896257, -0.373943, 0.999675, 0.999596},
            {0.882808, -0.373922, 0.999531, 0.999029},
            {0.868707, -0.373902, 0.999299, 0.995748},
            {0.854011, -0.373854, 0.998838, 0.993677},
            {0.838792, -0.373827, 0.997409, 0.991724},
            {0.823475, -0.373767, 0.991865, 0.989620},
            {0.807510, -0.373735, 0.987991, 0.986723},
            {0.791105, -0.373614, 0.984606, 0.981515},
            {0.774305, -0.373515, 0.981045, 0.975767},
            {0.757243, -0.373387, 0.976762, 0.969056},
            {0.740112, -0.373239, 0.970933, 0.964124},
            {0.723183, -0.373055, 0.962193, 0.959142},
            {0.706265, -0.372792, 0.951962, 0.953036},
            {0.689347, -0.372439, 0.941603, 0.945650},
            {0.672237, -0.371936, 0.931994, 0.937022},
            {0.654822, -0.371390, 0.923533, 0.926971},
            {0.637606, -0.370501, 0.914569, 0.915515},
            {0.620111, -0.369352, 0.904629, 0.903584},
            {0.603736, -0.367932, 0.892300, 0.891602},
            {0.587283, -0.366501, 0.879221, 0.878212},
            {0.571576, -0.364111, 0.864702, 0.863472},
            {0.556658, -0.361635, 0.847948, 0.847653},
            {0.542168, -0.357881, 0.831100, 0.831398},
            {0.528004, -0.354624, 0.812981, 0.814299},
            {0.513418, -0.349563, 0.795858, 0.796105},
            {0.500283, -0.343379, 0.777636, 0.777231},
            {0.487711, -0.337660, 0.758318, 0.757977},
            {0.475641, -0.329814, 0.738190, 0.737895},
            {0.464585, -0.321054, 0.717259, 0.717415},
            {0.452395, -0.310744, 0.696207, 0.696595},
            {0.442548, -0.300067, 0.675452, 0.675317},
            {0.432783, -0.288370, 0.654163, 0.653980},
            {0.423824, -0.276253, 0.632435, 0.632343},
            {0.416070, -0.261435, 0.610347, 0.610735},
            {0.406893, -0.247817, 0.589256, 0.589076},
            {0.398741, -0.233753, 0.567560, 0.567620},
            {0.390217, -0.215165, 0.546382, 0.546251},
            {0.384639, -0.197299, 0.524947, 0.525165},
            {0.378560, -0.180890, 0.504260, 0.504255},
            {0.373126, -0.163499, 0.483963, 0.483759},
            {0.368128, -0.145635, 0.463409, 0.463666},
            {0.363078, -0.129936, 0.444114, 0.443987},
            {0.358982, -0.111324, 0.424761, 0.424783},
            {0.354300, -0.093704, 0.405950, 0.406042},
            {0.348117, -0.070791, 0.387886, 0.387891},
            {0.344796, 0.000000, 0.370265, 0.370293},
            {0.342666, -0.034046, 0.353198, 0.353221},
            {0.340526, -0.016694, 0.336656, 0.336715},
            {0.338281, 0.000000, 0.320783, 0.320806},
            {0.998081, -0.398931, 1.000001, 0.999998},
            {0.998081, -0.398931, 1.000001, 0.999998},
            {0.998067, -0.398931, 1.000000, 0.999998},
            {0.995654, -0.398931, 1.000000, 0.999998},
            {0.992287, -0.398930, 0.999999, 0.999998},
            {0.987975, -0.398930, 0.999996, 0.999998},
            {0.982729, -0.398930, 0.999992, 0.999993},
            {0.976566, -0.398930, 0.999987, 0.999987},
            {0.969501, -0.398922, 0.999977, 0.999977},
            {0.961556, -0.398923, 0.999962, 0.999964},
            {0.952749, -0.398916, 0.999941, 0.999943},
            {0.943109, -0.398912, 0.999912, 0.999911},
            {0.932665, -0.398904, 0.999872, 0.999867},
            {0.921434, -0.398892, 0.999817, 0.999808},
            {0.909451, -0.398873, 0.999740, 0.999714},
            {0.896750, -0.398859, 0.999632, 0.999531},
            {0.883358, -0.398834, 0.999472, 0.998645},
            {0.869317, -0.398796, 0.999207, 0.995399},
            {0.854683, -0.398746, 0.998652, 0.993512},
            {0.839608, -0.398714, 0.996621, 0.991717},
            {0.824368, -0.398656, 0.991045, 0.989661},
            {0.808405, -0.398575, 0.987638, 0.986652},
            {0.792043, -0.398482, 0.984441, 0.981559},
            {0.775277, -0.398390, 0.981072, 0.976182},
            {0.758285, -0.398235, 0.976831, 0.969411},
            {0.741222, -0.398057, 0.970745, 0.963317},
            {0.724371, -0.397815, 0.961662, 0.958457},
            {0.707364, -0.397578, 0.952736, 0.952091},
            {0.690487, -0.397079, 0.942367, 0.944951},
            {0.673583, -0.396564, 0.931131, 0.936307},
            {0.656368, -0.395919, 0.922058, 0.926454},
            {0.639163, -0.395067, 0.913294, 0.915043},
            {0.621980, -0.393763, 0.903292, 0.902668},
            {0.605348, -0.392277, 0.891035, 0.890462},
            {0.589016, -0.390509, 0.878274, 0.877245},
            {0.573209, -0.388126, 0.863726, 0.862672},
            {0.558574, -0.384850, 0.847388, 0.846823},
            {0.543929, -0.381716, 0.830618, 0.830201},
            {0.529589, -0.377277, 0.812391, 0.813293},
            {0.515077, -0.372005, 0.794564, 0.795306},
            {0.501890, -0.365782, 0.776505, 0.776393},
            {0.489220, -0.359114, 0.757669, 0.757199},
            {0.477103, -0.350787, 0.737674, 0.737324},
            {0.465868, -0.341539, 0.716848, 0.716808},
            {0.454952, -0.330989, 0.695805, 0.696187},
            {0.444084, -0.318887, 0.674953, 0.675094},
            {0.434159, -0.306562, 0.654040, 0.653814},
            {0.424907, -0.292654, 0.632653, 0.632453},
            {0.416821, -0.279409, 0.610762, 0.610885},
            {0.408017, -0.264281, 0.589459, 0.589483},
            {0.399884, -0.246119, 0.568040, 0.568099},
            {0.391340, -0.230122, 0.547131, 0.546975},
            {0.385296, -0.211528, 0.525895, 0.525953},
            {0.378981, -0.191755, 0.505116, 0.505268},
            {0.373714, -0.172836, 0.485055, 0.484936},
            {0.368414, -0.155549, 0.464998, 0.464988},
            {0.363693, -0.135640, 0.445311, 0.445458},
            {0.358739, -0.116347, 0.426408, 0.426314},
            {0.353921, -0.096167, 0.407703, 0.407750},
            {0.348314, -0.075358, 0.389601, 0.389670},
            {0.344553, 0.000000, 0.372156, 0.372098},
            {0.343059, -0.037410, 0.354981, 0.355105},
            {0.340385, -0.017527, 0.338675, 0.338682},
            {0.338672, 0.000000, 0.322766, 0.322825},
            {0.998091, -0.423864, 1.000000, 0.999998},
            {0.998091, -0.423864, 1.000000, 0.999998},
            {0.998077, -0.423864, 1.000000, 0.999998},
            {0.995677, -0.423863, 1.000000, 0.999998},
            {0.992328, -0.423864, 0.999998, 0.999998},
            {0.988039, -0.423864, 0.999996, 0.999996},
            {0.982819, -0.423860, 0.999992, 0.999992},
            {0.976691, -0.423863, 0.999984, 0.999983},
            {0.969663, -0.423857, 0.999974, 0.999976},
            {0.961758, -0.423851, 0.999957, 0.999959},
            {0.952997, -0.423844, 0.999933, 0.999933},
            {0.943403, -0.423845, 0.999900, 0.999898},
            {0.933005, -0.423828, 0.999853, 0.999849},
            {0.921830, -0.423818, 0.999792, 0.999780},
            {0.909915, -0.423802, 0.999706, 0.999676},
            {0.897277, -0.423777, 0.999584, 0.999454},
            {0.883930, -0.423766, 0.999405, 0.997884},
            {0.869966, -0.423712, 0.999102, 0.995166},
            {0.855406, -0.423650, 0.998411, 0.993394},
            {0.840480, -0.423614, 0.995353, 0.991723},
            {0.825227, -0.423529, 0.990505, 0.989654},
            {0.809359, -0.423451, 0.987152, 0.986389},
            {0.793037, -0.423353, 0.984214, 0.981632},
            {0.776325, -0.423236, 0.981042, 0.976607},
            {0.759382, -0.423079, 0.976768, 0.969701},
            {0.742462, -0.422864, 0.970245, 0.962555},
            {0.725569, -0.422540, 0.961807, 0.957605},
            {0.708553, -0.422224, 0.953271, 0.951232},
            {0.691631, -0.421768, 0.943034, 0.944099},
            {0.675004, -0.421184, 0.931019, 0.935556},
            {0.658154, -0.420361, 0.920601, 0.925699},
            {0.641006, -0.419497, 0.911790, 0.914492},
            {0.623978, -0.418181, 0.901602, 0.902027},
            {0.607155, -0.416548, 0.889703, 0.889116},
            {0.590822, -0.414350, 0.876989, 0.876093},
            {0.575151, -0.411656, 0.862516, 0.861649},
            {0.560217, -0.408855, 0.846928, 0.845956},
            {0.545622, -0.404716, 0.829871, 0.829238},
            {0.531646, -0.400414, 0.811659, 0.812220},
            {0.517049, -0.394105, 0.793268, 0.794420},
            {0.503960, -0.388075, 0.775119, 0.775657},
            {0.491135, -0.379887, 0.756711, 0.756265},
            {0.478935, -0.371817, 0.736931, 0.736673},
            {0.467521, -0.361214, 0.716522, 0.716372},
            {0.456566, -0.350864, 0.695687, 0.695669},
            {0.445831, -0.337617, 0.674254, 0.674886},
            {0.435796, -0.323687, 0.653824, 0.653728},
            {0.425714, -0.309630, 0.632742, 0.632568},
            {0.417430, -0.295109, 0.611140, 0.611217},
            {0.409158, -0.280587, 0.589909, 0.589929},
            {0.400062, -0.262827, 0.568563, 0.568783},
            {0.391914, -0.242925, 0.547891, 0.547751},
            {0.384929, -0.225756, 0.527059, 0.526930},
            {0.379264, -0.204396, 0.506168, 0.506425},
            {0.373388, -0.185462, 0.486251, 0.486238},
            {0.368513, -0.164963, 0.466471, 0.466425},
            {0.363458, -0.143201, 0.446821, 0.446945},
            {0.358603, -0.122394, 0.428032, 0.428026},
            {0.354330, -0.103864, 0.409469, 0.409536},
            {0.348297, -0.078643, 0.391551, 0.391551},
            {0.344599, 0.000000, 0.374076, 0.374087},
            {0.342568, -0.037317, 0.357059, 0.357155},
            {0.340244, -0.017932, 0.340851, 0.340787},
            {0.338281, 0.000000, 0.324875, 0.324974},
            {0.998102, -0.448797, 1.000000, 0.999996},
            {0.998102, -0.448797, 1.000000, 0.999996},
            {0.998087, -0.448797, 1.000000, 0.999996},
            {0.995703, -0.448797, 0.999999, 0.999996},
            {0.992371, -0.448796, 0.999999, 0.999996},
            {0.988105, -0.448796, 0.999996, 0.999996},
            {0.982917, -0.448795, 0.999991, 0.999990},
            {0.976818, -0.448794, 0.999982, 0.999984},
            {0.969829, -0.448790, 0.999970, 0.999970},
            {0.961967, -0.448780, 0.999951, 0.999952},
            {0.953251, -0.448780, 0.999924, 0.999925},
            {0.943720, -0.448770, 0.999886, 0.999886},
            {0.933374, -0.448749, 0.999834, 0.999831},
            {0.922264, -0.448735, 0.999765, 0.999757},
            {0.910390, -0.448718, 0.999668, 0.999633},
            {0.897817, -0.448693, 0.999534, 0.999356},
            {0.884573, -0.448658, 0.999331, 0.997017},
            {0.870665, -0.448621, 0.998979, 0.994868},
            {0.856187, -0.448550, 0.998085, 0.993337},
            {0.841474, -0.448504, 0.993610, 0.991710},
            {0.826180, -0.448456, 0.989713, 0.989580},
            {0.810393, -0.448304, 0.986677, 0.985848},
            {0.794091, -0.448173, 0.983916, 0.981640},
            {0.777448, -0.448048, 0.980948, 0.976711},
            {0.760600, -0.447813, 0.976549, 0.969755},
            {0.743807, -0.447590, 0.969366, 0.962166},
            {0.726854, -0.447277, 0.961966, 0.956609},
            {0.709840, -0.446934, 0.953778, 0.950365},
            {0.693002, -0.446441, 0.943326, 0.943026},
            {0.676566, -0.445758, 0.930871, 0.934693},
            {0.659846, -0.444992, 0.919328, 0.924880},
            {0.642826, -0.443820, 0.910299, 0.913729},
            {0.626074, -0.442341, 0.899730, 0.901350},
            {0.609110, -0.440440, 0.888474, 0.887966},
            {0.592953, -0.438095, 0.875653, 0.874726},
            {0.577277, -0.435200, 0.861264, 0.860474},
            {0.562024, -0.431928, 0.845990, 0.844905},
            {0.547419, -0.428073, 0.829030, 0.828269},
            {0.533458, -0.422870, 0.811082, 0.810905},
            {0.519119, -0.417039, 0.792670, 0.793364},
            {0.505893, -0.409783, 0.773754, 0.774812},
            {0.492994, -0.400875, 0.755677, 0.755478},
            {0.480742, -0.392546, 0.736210, 0.735886},
            {0.469718, -0.381563, 0.716179, 0.715847},
            {0.457858, -0.369426, 0.695485, 0.695231},
            {0.447057, -0.355900, 0.674029, 0.674537},
            {0.436603, -0.342671, 0.653570, 0.653667},
            {0.427016, -0.327810, 0.632693, 0.632527},
            {0.418206, -0.312674, 0.611538, 0.611475},
            {0.409803, -0.294467, 0.590551, 0.590363},
            {0.401507, -0.277422, 0.569201, 0.569462},
            {0.392690, -0.255718, 0.548511, 0.548571},
            {0.385360, -0.236315, 0.528170, 0.527976},
            {0.379793, -0.216417, 0.507615, 0.507634},
            {0.373768, -0.197552, 0.487481, 0.487632},
            {0.368528, -0.176518, 0.468024, 0.467901},
            {0.363786, -0.154127, 0.448671, 0.448680},
            {0.359193, -0.130711, 0.429786, 0.429833},
            {0.353868, -0.107930, 0.411419, 0.411467},
            {0.348077, -0.082617, 0.393549, 0.393568},
            {0.344590, 0.000000, 0.376201, 0.376197},
            {0.342761, -0.040558, 0.359294, 0.359374},
            {0.340244, -0.018429, 0.342954, 0.343034},
            {0.338281, 0.000000, 0.327295, 0.327273},
            {0.998113, -0.473730, 1.000000, 0.999997},
            {0.998113, -0.473730, 1.000000, 0.999997},
            {0.998099, -0.473730, 1.000000, 0.999997},
            {0.995727, -0.473729, 1.000000, 0.999997},
            {0.992417, -0.473730, 0.999998, 0.999997},
            {0.988177, -0.473729, 0.999994, 0.999993},
            {0.983016, -0.473728, 0.999989, 0.999989},
            {0.976957, -0.473723, 0.999980, 0.999980},
            {0.970003, -0.473722, 0.999966, 0.999965},
            {0.962176, -0.473708, 0.999944, 0.999945},
            {0.953525, -0.473707, 0.999914, 0.999913},
            {0.944051, -0.473691, 0.999872, 0.999869},
            {0.933759, -0.473683, 0.999814, 0.999810},
            {0.922710, -0.473664, 0.999736, 0.999723},
            {0.910896, -0.473633, 0.999628, 0.999583},
            {0.898401, -0.473611, 0.999477, 0.999213},
            {0.885221, -0.473574, 0.999248, 0.996540},
            {0.871394, -0.473522, 0.998835, 0.994740},
            {0.857030, -0.473456, 0.997611, 0.993245},
            {0.842423, -0.473377, 0.992760, 0.991671},
            {0.827179, -0.473275, 0.989384, 0.989411},
            {0.811419, -0.473185, 0.986626, 0.985533},
            {0.795232, -0.472983, 0.983539, 0.981616},
            {0.778615, -0.472816, 0.980772, 0.976847},
            {0.761842, -0.472654, 0.976124, 0.969968},
            {0.745254, -0.472369, 0.968447, 0.962314},
            {0.728198, -0.472007, 0.962038, 0.955468},
            {0.711199, -0.471558, 0.953902, 0.949420},
            {0.694550, -0.470949, 0.943239, 0.942017},
            {0.678008, -0.470310, 0.931141, 0.933617},
            {0.661587, -0.469285, 0.918886, 0.923949},
            {0.644724, -0.467961, 0.908485, 0.912899},
            {0.627957, -0.466574, 0.898219, 0.900495},
            {0.611364, -0.464335, 0.886880, 0.887022},
            {0.594967, -0.461816, 0.874090, 0.873283},
            {0.579381, -0.459031, 0.860073, 0.859153},
            {0.564115, -0.455406, 0.844652, 0.843830},
            {0.549329, -0.451055, 0.828078, 0.827325},
            {0.535419, -0.445144, 0.810403, 0.809888},
            {0.521553, -0.439036, 0.791942, 0.792172},
            {0.507918, -0.431382, 0.772601, 0.773832},
            {0.494960, -0.422460, 0.754439, 0.754686},
            {0.483131, -0.412552, 0.735162, 0.735035},
            {0.471295, -0.400326, 0.715647, 0.715297},
            {0.460233, -0.388673, 0.695362, 0.694955},
            {0.448046, -0.374747, 0.674108, 0.674242},
            {0.437894, -0.360362, 0.653432, 0.653660},
            {0.427713, -0.345286, 0.632579, 0.632752},
            {0.419345, -0.328664, 0.611896, 0.611804},
            {0.410150, -0.310801, 0.591115, 0.590993},
            {0.402460, -0.292370, 0.570213, 0.570154},
            {0.393426, -0.270517, 0.549181, 0.549539},
            {0.386276, -0.248594, 0.529320, 0.529087},
            {0.380308, -0.228551, 0.509043, 0.508974},
            {0.373530, -0.205695, 0.488947, 0.489030},
            {0.369113, -0.183039, 0.469484, 0.469599},
            {0.363079, -0.158043, 0.450444, 0.450465},
            {0.358829, -0.139915, 0.431699, 0.431761},
            {0.353796, -0.116170, 0.413536, 0.413508},
            {0.348533, -0.087165, 0.395707, 0.395761},
            {0.345177, -0.063550, 0.378476, 0.378480},
            {0.342252, -0.041331, 0.361690, 0.361679},
            {0.340310, -0.017693, 0.345258, 0.345465},
            {0.337891, 0.000000, 0.329772, 0.329753},
            {0.998126, -0.498664, 1.000001, 0.999996},
            {0.998126, -0.498664, 1.000001, 0.999996},
            {0.998111, -0.498664, 1.000000, 0.999996},
            {0.995754, -0.498664, 0.999999, 0.999996},
            {0.992465, -0.498662, 0.999997, 0.999996},
            {0.988252, -0.498661, 0.999994, 0.999994},
            {0.983123, -0.498660, 0.999988, 0.999987},
            {0.977103, -0.498656, 0.999977, 0.999978},
            {0.970198, -0.498651, 0.999960, 0.999961},
            {0.962428, -0.498640, 0.999937, 0.999936},
            {0.953819, -0.498641, 0.999904, 0.999903},
            {0.944394, -0.498619, 0.999855, 0.999855},
            {0.934171, -0.498609, 0.999790, 0.999786},
            {0.923181, -0.498598, 0.999704, 0.999689},
            {0.911454, -0.498563, 0.999583, 0.999527},
            {0.899021, -0.498522, 0.999414, 0.998988},
            {0.885902, -0.498459, 0.999154, 0.996137},
            {0.872174, -0.498396, 0.998657, 0.994527},
            {0.857937, -0.498334, 0.996865, 0.993108},
            {0.843410, -0.498239, 0.991887, 0.991599},
            {0.828207, -0.498137, 0.989176, 0.989084},
            {0.812483, -0.497990, 0.986536, 0.985308},
            {0.796374, -0.497851, 0.983461, 0.981527},
            {0.779874, -0.497664, 0.980492, 0.976677},
            {0.763282, -0.497406, 0.975429, 0.970079},
            {0.746671, -0.497056, 0.968041, 0.962535},
            {0.729700, -0.496652, 0.961805, 0.954490},
            {0.712790, -0.496198, 0.953644, 0.948270},
            {0.696148, -0.495531, 0.943271, 0.940942},
            {0.679575, -0.494665, 0.931545, 0.932422},
            {0.663149, -0.493631, 0.919041, 0.922836},
            {0.646929, -0.492321, 0.906382, 0.911896},
            {0.630016, -0.490501, 0.896590, 0.899632},
            {0.613744, -0.488274, 0.884911, 0.886119},
            {0.597198, -0.485397, 0.872524, 0.871864},
            {0.581534, -0.482437, 0.858720, 0.857720},
            {0.566298, -0.478246, 0.843416, 0.842536},
            {0.551428, -0.473134, 0.827205, 0.826163},
            {0.537236, -0.467498, 0.809614, 0.808849},
            {0.523534, -0.460995, 0.791222, 0.790860},
            {0.510044, -0.452575, 0.772058, 0.772802},
            {0.497125, -0.443216, 0.753003, 0.753860},
            {0.485343, -0.432287, 0.734019, 0.734335},
            {0.473320, -0.420324, 0.714960, 0.714582},
            {0.461630, -0.408972, 0.695001, 0.694543},
            {0.450352, -0.393256, 0.673963, 0.674071},
            {0.439019, -0.378376, 0.653500, 0.653544},
            {0.429249, -0.361569, 0.632617, 0.632922},
            {0.420723, -0.342709, 0.612104, 0.612153},
            {0.411385, -0.324965, 0.591805, 0.591573},
            {0.403291, -0.304272, 0.571123, 0.570951},
            {0.394068, -0.282652, 0.550236, 0.550520},
            {0.387027, -0.261358, 0.530221, 0.530352},
            {0.380768, -0.239209, 0.510533, 0.510311},
            {0.374103, -0.216495, 0.490708, 0.490707},
            {0.369079, -0.193351, 0.471260, 0.471359},
            {0.363988, -0.170568, 0.452377, 0.452396},
            {0.358931, -0.146387, 0.433773, 0.433837},
            {0.354350, -0.121890, 0.415796, 0.415736},
            {0.348435, -0.093696, 0.398022, 0.398052},
            {0.345177, -0.065763, 0.380767, 0.380874},
            {0.342531, -0.044706, 0.364274, 0.364233},
            {0.339924, -0.022553, 0.347987, 0.348023},
            {0.337891, 0.000000, 0.332236, 0.332368},
            {0.998139, -0.523596, 1.000000, 0.999997},
            {0.998139, -0.523596, 1.000000, 0.999997},
            {0.998123, -0.523596, 0.999999, 0.999997},
            {0.995783, -0.523596, 1.000000, 0.999997},
            {0.992516, -0.523597, 0.999997, 0.999997},
            {0.988331, -0.523593, 0.999994, 0.999994},
            {0.983236, -0.523593, 0.999986, 0.999988},
            {0.977256, -0.523589, 0.999975, 0.999976},
            {0.970397, -0.523582, 0.999956, 0.999957},
            {0.962676, -0.523567, 0.999929, 0.999928},
            {0.954126, -0.523558, 0.999891, 0.999891},
            {0.944746, -0.523552, 0.999838, 0.999837},
            {0.934601, -0.523530, 0.999766, 0.999759},
            {0.923667, -0.523495, 0.999668, 0.999650},
            {0.912030, -0.523461, 0.999534, 0.999463},
            {0.899671, -0.523438, 0.999344, 0.998551},
            {0.886643, -0.523381, 0.999048, 0.995879},
            {0.872997, -0.523295, 0.998432, 0.994366},
            {0.858903, -0.523234, 0.995606, 0.992964},
            {0.844412, -0.523124, 0.991487, 0.991479},
            {0.829252, -0.523001, 0.988876, 0.988521},
            {0.813614, -0.522812, 0.986401, 0.985101},
            {0.797605, -0.522649, 0.983348, 0.981482},
            {0.781194, -0.522414, 0.980071, 0.976168},
            {0.764787, -0.522121, 0.974383, 0.970242},
            {0.748161, -0.521756, 0.967739, 0.962585},
            {0.731248, -0.521332, 0.961618, 0.953950},
            {0.714491, -0.520737, 0.952984, 0.946973},
            {0.697690, -0.520132, 0.943254, 0.939686},
            {0.681218, -0.519140, 0.931718, 0.931248},
            {0.664957, -0.517956, 0.918995, 0.921614},
            {0.649022, -0.516558, 0.905168, 0.910765},
            {0.632424, -0.514697, 0.894796, 0.898617},
            {0.616053, -0.512180, 0.882927, 0.885183},
            {0.599442, -0.509257, 0.870691, 0.870772},
            {0.583800, -0.505913, 0.856946, 0.856138},
            {0.568573, -0.501317, 0.841818, 0.841120},
            {0.553745, -0.495811, 0.825858, 0.824962},
            {0.539952, -0.489976, 0.808574, 0.807732},
            {0.526026, -0.482657, 0.790354, 0.789813},
            {0.512089, -0.473219, 0.771510, 0.771638},
            {0.499329, -0.463544, 0.752020, 0.753008},
            {0.487178, -0.452283, 0.732867, 0.733686},
            {0.474788, -0.440990, 0.714279, 0.713927},
            {0.463262, -0.426857, 0.694551, 0.694082},
            {0.452340, -0.412355, 0.674132, 0.673967},
            {0.440552, -0.395679, 0.653644, 0.653549},
            {0.431349, -0.378229, 0.633000, 0.633135},
            {0.421439, -0.360178, 0.612245, 0.612702},
            {0.412325, -0.339365, 0.592361, 0.592200},
            {0.404347, -0.319082, 0.572052, 0.571904},
            {0.395276, -0.296369, 0.551714, 0.551679},
            {0.387685, -0.272987, 0.531371, 0.531678},
            {0.380493, -0.250116, 0.511986, 0.511898},
            {0.374697, -0.225795, 0.492411, 0.492437},
            {0.369784, -0.201421, 0.473231, 0.473239},
            {0.364190, -0.177893, 0.454432, 0.454451},
            {0.358598, -0.154469, 0.436006, 0.436067},
            {0.354302, -0.128409, 0.418042, 0.418054},
            {0.348123, -0.099274, 0.400595, 0.400541},
            {0.345186, -0.077131, 0.383393, 0.383486},
            {0.342550, -0.046618, 0.366744, 0.366848},
            {0.340253, -0.024354, 0.350870, 0.350781},
            {0.338281, 0.000000, 0.335117, 0.335182},
            {0.998151, -0.548529, 1.000000, 0.999995},
            {0.998151, -0.548529, 1.000000, 0.999995},
            {0.998137, -0.548530, 0.999999, 0.999995},
            {0.995813, -0.548529, 1.000000, 0.999995},
            {0.992568, -0.548531, 0.999998, 0.999995},
            {0.988412, -0.548529, 0.999993, 0.999993},
            {0.983353, -0.548524, 0.999985, 0.999985},
            {0.977416, -0.548521, 0.999971, 0.999972},
            {0.970604, -0.548520, 0.999951, 0.999951},
            {0.962936, -0.548501, 0.999921, 0.999919},
            {0.954446, -0.548485, 0.999878, 0.999877},
            {0.945146, -0.548474, 0.999820, 0.999817},
            {0.935049, -0.548444, 0.999737, 0.999733},
            {0.924201, -0.548427, 0.999629, 0.999608},
            {0.912624, -0.548383, 0.999481, 0.999380},
            {0.900333, -0.548336, 0.999267, 0.997685},
            {0.887407, -0.548274, 0.998925, 0.995603},
            {0.873835, -0.548203, 0.998128, 0.994264},
            {0.859964, -0.548101, 0.994029, 0.992911},
            {0.845452, -0.547955, 0.990870, 0.991286},
            {0.830382, -0.547821, 0.988453, 0.987923},
            {0.814828, -0.547633, 0.986208, 0.984871},
            {0.798874, -0.547470, 0.983162, 0.981239},
            {0.782615, -0.547186, 0.979456, 0.975933},
            {0.766340, -0.546865, 0.973410, 0.970149},
            {0.749723, -0.546451, 0.967513, 0.962511},
            {0.732859, -0.546008, 0.961334, 0.953824},
            {0.716161, -0.545256, 0.952189, 0.945699},
            {0.699541, -0.544454, 0.943090, 0.938285},
            {0.683014, -0.543547, 0.931523, 0.929907},
            {0.666884, -0.542251, 0.918925, 0.920343},
            {0.651031, -0.540537, 0.904636, 0.909537},
            {0.634699, -0.538600, 0.892620, 0.897435},
            {0.618462, -0.535998, 0.880999, 0.884057},
            {0.601872, -0.532880, 0.868630, 0.869626},
            {0.586153, -0.529121, 0.855254, 0.854490},
            {0.571141, -0.524118, 0.840069, 0.839459},
            {0.556261, -0.518613, 0.824524, 0.823511},
            {0.542083, -0.511632, 0.807636, 0.806511},
            {0.528150, -0.503476, 0.789272, 0.788752},
            {0.514671, -0.494914, 0.770896, 0.770440},
            {0.501385, -0.484510, 0.751531, 0.751995},
            {0.489222, -0.472705, 0.731812, 0.732962},
            {0.476759, -0.459604, 0.713248, 0.713424},
            {0.464881, -0.445810, 0.693926, 0.693525},
            {0.453886, -0.429669, 0.673994, 0.673798},
            {0.442096, -0.412198, 0.653786, 0.653622},
            {0.432369, -0.394789, 0.633541, 0.633301},
            {0.422910, -0.374964, 0.612891, 0.613224},
            {0.413652, -0.354085, 0.592703, 0.592938},
            {0.404720, -0.331253, 0.573153, 0.572833},
            {0.396466, -0.309083, 0.553006, 0.552904},
            {0.388075, -0.283031, 0.532992, 0.533030},
            {0.381168, -0.259854, 0.513393, 0.513556},
            {0.375221, -0.235500, 0.494326, 0.494215},
            {0.369395, -0.211012, 0.475214, 0.475279},
            {0.363878, -0.185698, 0.456724, 0.456673},
            {0.358838, -0.159748, 0.438384, 0.438411},
            {0.353822, -0.133660, 0.420463, 0.420583},
            {0.347943, -0.104151, 0.403205, 0.403178},
            {0.344527, -0.080899, 0.386232, 0.386178},
            {0.341711, -0.055927, 0.369599, 0.369728},
            {0.339561, -0.034551, 0.353647, 0.353688},
            {0.338672, 0.000000, 0.338241, 0.338147},
            {0.998165, -0.573463, 1.000000, 0.999993},
            {0.998165, -0.573463, 1.000000, 0.999993},
            {0.998151, -0.573463, 1.000000, 0.999993},
            {0.995844, -0.573462, 0.999999, 0.999993},
            {0.992623, -0.573463, 0.999996, 0.999993},
            {0.988495, -0.573461, 0.999992, 0.999991},
            {0.983481, -0.573457, 0.999982, 0.999984},
            {0.977582, -0.573450, 0.999968, 0.999967},
            {0.970819, -0.573446, 0.999945, 0.999944},
            {0.963210, -0.573428, 0.999912, 0.999912},
            {0.954771, -0.573415, 0.999863, 0.999863},
            {0.945529, -0.573393, 0.999798, 0.999796},
            {0.935535, -0.573366, 0.999709, 0.999703},
            {0.924749, -0.573329, 0.999588, 0.999563},
            {0.913253, -0.573295, 0.999421, 0.999279},
            {0.901070, -0.573235, 0.999182, 0.997104},
            {0.888184, -0.573150, 0.998783, 0.995394},
            {0.874778, -0.573105, 0.997680, 0.994111},
            {0.860990, -0.572948, 0.993279, 0.992825},
            {0.846620, -0.572785, 0.990083, 0.990979},
            {0.831597, -0.572659, 0.987868, 0.987529},
            {0.816095, -0.572501, 0.985946, 0.984661},
            {0.800266, -0.572258, 0.982879, 0.980774},
            {0.784097, -0.571934, 0.978574, 0.975758},
            {0.767904, -0.571639, 0.972739, 0.969866},
            {0.751356, -0.571123, 0.967043, 0.962465},
            {0.734580, -0.570531, 0.960749, 0.953678},
            {0.718129, -0.569851, 0.951660, 0.944489},
            {0.701351, -0.569081, 0.942740, 0.936886},
            {0.684981, -0.567797, 0.931071, 0.928356},
            {0.668746, -0.566495, 0.919025, 0.918820},
            {0.652961, -0.564452, 0.904694, 0.908073},
            {0.637107, -0.562419, 0.890744, 0.896092},
            {0.621080, -0.559558, 0.878798, 0.882833},
            {0.604645, -0.555911, 0.866357, 0.868463},
            {0.588852, -0.551840, 0.853331, 0.853212},
            {0.573719, -0.546733, 0.838191, 0.837744},
            {0.558777, -0.540723, 0.823056, 0.822048},
            {0.544636, -0.533600, 0.806418, 0.805333},
            {0.530830, -0.524753, 0.788044, 0.787643},
            {0.517299, -0.515525, 0.770371, 0.769414},
            {0.503441, -0.505249, 0.750888, 0.750830},
            {0.491484, -0.493003, 0.731158, 0.732178},
            {0.478831, -0.479027, 0.712125, 0.712972},
            {0.467013, -0.464602, 0.693432, 0.693227},
            {0.455644, -0.447099, 0.673789, 0.673569},
            {0.444038, -0.428776, 0.653926, 0.653744},
            {0.433820, -0.410221, 0.633989, 0.633739},
            {0.423941, -0.389340, 0.613696, 0.613735},
            {0.414710, -0.367420, 0.593257, 0.593822},
            {0.405569, -0.345964, 0.573946, 0.573916},
            {0.397270, -0.320962, 0.554452, 0.554158},
            {0.389118, -0.295475, 0.534717, 0.534652},
            {0.381589, -0.270532, 0.515132, 0.515248},
            {0.375247, -0.244339, 0.496160, 0.496233},
            {0.369129, -0.219098, 0.477440, 0.477436},
            {0.363977, -0.192928, 0.459084, 0.459009},
            {0.358750, -0.165698, 0.440896, 0.440929},
            {0.354350, -0.139920, 0.423217, 0.423259},
            {0.348031, -0.110630, 0.405788, 0.405951},
            {0.344155, -0.083902, 0.389240, 0.389136},
            {0.341498, -0.061908, 0.372694, 0.372690},
            {0.339366, -0.040650, 0.356536, 0.356789},
            {0.334375, 0.000000, 0.341409, 0.341329},
            {0.998180, -0.598396, 0.999999, 0.999995},
            {0.998180, -0.598396, 0.999999, 0.999995},
            {0.998165, -0.598397, 1.000000, 0.999995},
            {0.995878, -0.598395, 0.999999, 0.999995},
            {0.992681, -0.598395, 0.999996, 0.999995},
            {0.988586, -0.598393, 0.999991, 0.999991},
            {0.983609, -0.598388, 0.999982, 0.999981},
            {0.977756, -0.598381, 0.999965, 0.999966},
            {0.971040, -0.598370, 0.999939, 0.999939},
            {0.963490, -0.598359, 0.999902, 0.999903},
            {0.955126, -0.598333, 0.999849, 0.999847},
            {0.945948, -0.598315, 0.999775, 0.999771},
            {0.936014, -0.598292, 0.999676, 0.999666},
            {0.925317, -0.598246, 0.999541, 0.999510},
            {0.913893, -0.598211, 0.999355, 0.999131},
            {0.901782, -0.598131, 0.999085, 0.996690},
            {0.889035, -0.598043, 0.998611, 0.995147},
            {0.875714, -0.597931, 0.996951, 0.993882},
            {0.862060, -0.597841, 0.992348, 0.992696},
            {0.847705, -0.597684, 0.989945, 0.990474},
            {0.832838, -0.597542, 0.987446, 0.987227},
            {0.817424, -0.597339, 0.985598, 0.984334},
            {0.801692, -0.596982, 0.982459, 0.980153},
            {0.785801, -0.596701, 0.977316, 0.975438},
            {0.769579, -0.596251, 0.972088, 0.969406},
            {0.753102, -0.595678, 0.966422, 0.962238},
            {0.736457, -0.595062, 0.959808, 0.953598},
            {0.720047, -0.594295, 0.951305, 0.943868},
            {0.703349, -0.593283, 0.942147, 0.935356},
            {0.687103, -0.592110, 0.930960, 0.926721},
            {0.670736, -0.590524, 0.918696, 0.917122},
            {0.655137, -0.588644, 0.904108, 0.906430},
            {0.639392, -0.586083, 0.890025, 0.894550},
            {0.623579, -0.583177, 0.876586, 0.881354},
            {0.607454, -0.579224, 0.864092, 0.867131},
            {0.591585, -0.574722, 0.851220, 0.851954},
            {0.576429, -0.569217, 0.836158, 0.835972},
            {0.561548, -0.562609, 0.821353, 0.820331},
            {0.547081, -0.554782, 0.804968, 0.803911},
            {0.533292, -0.546496, 0.786868, 0.786452},
            {0.519693, -0.536227, 0.769441, 0.768420},
            {0.505763, -0.525470, 0.750410, 0.749821},
            {0.493476, -0.512308, 0.730622, 0.731298},
            {0.480943, -0.498422, 0.711505, 0.712393},
            {0.469438, -0.482044, 0.692671, 0.692979},
            {0.458320, -0.464892, 0.673524, 0.673418},
            {0.445470, -0.446354, 0.653980, 0.653859},
            {0.435224, -0.426433, 0.634567, 0.634232},
            {0.425133, -0.404748, 0.614609, 0.614327},
            {0.415660, -0.382429, 0.594361, 0.594732},
            {0.407540, -0.358972, 0.574640, 0.575131},
            {0.398115, -0.332943, 0.555897, 0.555584},
            {0.389403, -0.306933, 0.536350, 0.536346},
            {0.381939, -0.280584, 0.517215, 0.517175},
            {0.375634, -0.253511, 0.498193, 0.498323},
            {0.369408, -0.225791, 0.479702, 0.479744},
            {0.364051, -0.200261, 0.461417, 0.461485},
            {0.358596, -0.171246, 0.443575, 0.443645},
            {0.353901, -0.144468, 0.426189, 0.426061},
            {0.347905, -0.114649, 0.408712, 0.408969},
            {0.344159, -0.090641, 0.392138, 0.392154},
            {0.341281, -0.064359, 0.376068, 0.375921},
            {0.336782, -0.018732, 0.359937, 0.360060},
            {0.335156, 0.000000, 0.344496, 0.344677},
            {0.998195, -0.623329, 1.000000, 0.999994},
            {0.998195, -0.623329, 1.000000, 0.999994},
            {0.998181, -0.623330, 1.000000, 0.999994},
            {0.995911, -0.623328, 0.999999, 0.999994},
            {0.992741, -0.623328, 0.999997, 0.999994},
            {0.988684, -0.623322, 0.999990, 0.999991},
            {0.983741, -0.623321, 0.999979, 0.999979},
            {0.977936, -0.623313, 0.999961, 0.999960},
            {0.971280, -0.623309, 0.999932, 0.999931},
            {0.963779, -0.623293, 0.999891, 0.999891},
            {0.955478, -0.623277, 0.999831, 0.999832},
            {0.946390, -0.623232, 0.999750, 0.999748},
            {0.936522, -0.623204, 0.999640, 0.999629},
            {0.925913, -0.623150, 0.999490, 0.999449},
            {0.914568, -0.623121, 0.999283, 0.998879},
            {0.902578, -0.623052, 0.998977, 0.996305},
            {0.889887, -0.622956, 0.998393, 0.995024},
            {0.876786, -0.622842, 0.995648, 0.993812},
            {0.863140, -0.622669, 0.992030, 0.992508},
            {0.848860, -0.622479, 0.989741, 0.989721},
            {0.834053, -0.622292, 0.987333, 0.986936},
            {0.818786, -0.622077, 0.985142, 0.983936},
            {0.803186, -0.621781, 0.981844, 0.979629},
            {0.787473, -0.621407, 0.976245, 0.974979},
            {0.771236, -0.620888, 0.971596, 0.968928},
            {0.754873, -0.620397, 0.965955, 0.961970},
            {0.738463, -0.619663, 0.958447, 0.953291},
            {0.721985, -0.618730, 0.950648, 0.943458},
            {0.705516, -0.617586, 0.941092, 0.933644},
            {0.689168, -0.616221, 0.930512, 0.925007},
            {0.673111, -0.614589, 0.918003, 0.915388},
            {0.657360, -0.612313, 0.903963, 0.904755},
            {0.641691, -0.609783, 0.889680, 0.892932},
            {0.626548, -0.606489, 0.874439, 0.879831},
            {0.610452, -0.602653, 0.861765, 0.865794},
            {0.594392, -0.597319, 0.848754, 0.850672},
            {0.579243, -0.591357, 0.834163, 0.834591},
            {0.564267, -0.584472, 0.819391, 0.818398},
            {0.549676, -0.576577, 0.803195, 0.802304},
            {0.535621, -0.567508, 0.785843, 0.785151},
            {0.522205, -0.556839, 0.768298, 0.767450},
            {0.507884, -0.545213, 0.749987, 0.748987},
            {0.495553, -0.531259, 0.730263, 0.730325},
            {0.482937, -0.516631, 0.711075, 0.711758},
            {0.471777, -0.500163, 0.692055, 0.692761},
            {0.460119, -0.481529, 0.673165, 0.673417},
            {0.447186, -0.463140, 0.654165, 0.653908},
            {0.436735, -0.441932, 0.634992, 0.634686},
            {0.426385, -0.418914, 0.615452, 0.615168},
            {0.417274, -0.395575, 0.595758, 0.595707},
            {0.407907, -0.370156, 0.575807, 0.576393},
            {0.399472, -0.344842, 0.557056, 0.557198},
            {0.389815, -0.317108, 0.538209, 0.538018},
            {0.382304, -0.291431, 0.519307, 0.519253},
            {0.375651, -0.261065, 0.500572, 0.500555},
            {0.369871, -0.234932, 0.482211, 0.482220},
            {0.364152, -0.206298, 0.464102, 0.464197},
            {0.359256, -0.177692, 0.446329, 0.446414},
            {0.353553, -0.148938, 0.429251, 0.429106},
            {0.347657, -0.118991, 0.411947, 0.412035},
            {0.344355, -0.093159, 0.395349, 0.395508},
            {0.338905, -0.047478, 0.379286, 0.379284},
            {0.336896, -0.024737, 0.363574, 0.363538},
            {0.334766, 0.000000, 0.348221, 0.348220},
            {0.998210, -0.648262, 1.000000, 0.999993},
            {0.998210, -0.648262, 1.000000, 0.999993},
            {0.998196, -0.648262, 1.000000, 0.999993},
            {0.995946, -0.648261, 0.999998, 0.999993},
            {0.992805, -0.648260, 0.999995, 0.999993},
            {0.988778, -0.648256, 0.999989, 0.999989},
            {0.983880, -0.648255, 0.999976, 0.999977},
            {0.978128, -0.648250, 0.999955, 0.999956},
            {0.971520, -0.648242, 0.999924, 0.999924},
            {0.964094, -0.648217, 0.999879, 0.999879},
            {0.955867, -0.648201, 0.999813, 0.999813},
            {0.946825, -0.648138, 0.999723, 0.999722},
            {0.937059, -0.648125, 0.999600, 0.999590},
            {0.926501, -0.648065, 0.999435, 0.999381},
            {0.915289, -0.648012, 0.999203, 0.998335},
            {0.903382, -0.647917, 0.998854, 0.996088},
            {0.890832, -0.647811, 0.998099, 0.994814},
            {0.877866, -0.647701, 0.994258, 0.993709},
            {0.864265, -0.647510, 0.991520, 0.992220},
            {0.850080, -0.647315, 0.989440, 0.989209},
            {0.835367, -0.647126, 0.987169, 0.986575},
            {0.820240, -0.646778, 0.984542, 0.983383},
            {0.804805, -0.646506, 0.980940, 0.979084},
            {0.789193, -0.645965, 0.975399, 0.974272},
            {0.773015, -0.645499, 0.970876, 0.968359},
            {0.756765, -0.644945, 0.965196, 0.961275},
            {0.740527, -0.644090, 0.957068, 0.953025},
            {0.723963, -0.643146, 0.950073, 0.943098},
            {0.707791, -0.641876, 0.939600, 0.932434},
            {0.691421, -0.640361, 0.929935, 0.923101},
            {0.675474, -0.638504, 0.917169, 0.913477},
            {0.659663, -0.636222, 0.903753, 0.902861},
            {0.644245, -0.633252, 0.888962, 0.891059},
            {0.629023, -0.629521, 0.873220, 0.878071},
            {0.613805, -0.625268, 0.859228, 0.864118},
            {0.597359, -0.619744, 0.846169, 0.849188},
            {0.581984, -0.613523, 0.832127, 0.833281},
            {0.567083, -0.606618, 0.817270, 0.816808},
            {0.552471, -0.597542, 0.801463, 0.800596},
            {0.538221, -0.587830, 0.784381, 0.783745},
            {0.524539, -0.576774, 0.767107, 0.766331},
            {0.510750, -0.564382, 0.749151, 0.748123},
            {0.497995, -0.549746, 0.730107, 0.729687},
            {0.485371, -0.534338, 0.710749, 0.711078},
            {0.473683, -0.517027, 0.691799, 0.692527},
            {0.461412, -0.499389, 0.672840, 0.673491},
            {0.449661, -0.478948, 0.654080, 0.654296},
            {0.438214, -0.456786, 0.635417, 0.635113},
            {0.427986, -0.433178, 0.616461, 0.616048},
            {0.417704, -0.410504, 0.597175, 0.596848},
            {0.409209, -0.383812, 0.577577, 0.577720},
            {0.400217, -0.357073, 0.558568, 0.558879},
            {0.390875, -0.328272, 0.539909, 0.540028},
            {0.383158, -0.300442, 0.521611, 0.521371},
            {0.376311, -0.271094, 0.502999, 0.502996},
            {0.369513, -0.241706, 0.484907, 0.484858},
            {0.364665, -0.213506, 0.466992, 0.466997},
            {0.358901, -0.183546, 0.449260, 0.449477},
            {0.354012, -0.155277, 0.432231, 0.432217},
            {0.346341, -0.118804, 0.415578, 0.415426},
            {0.341284, -0.076299, 0.398850, 0.398924},
            {0.339163, -0.054247, 0.382619, 0.382890},
            {0.336938, -0.027798, 0.367258, 0.367206},
            {0.334375, 0.000000, 0.352076, 0.351955},
            {0.998226, -0.673195, 1.000000, 0.999993},
            {0.998226, -0.673195, 1.000000, 0.999993},
            {0.998213, -0.673196, 0.999999, 0.999993},
            {0.995984, -0.673193, 0.999999, 0.999993},
            {0.992871, -0.673194, 0.999995, 0.999993},
            {0.988880, -0.673194, 0.999987, 0.999988},
            {0.984028, -0.673188, 0.999973, 0.999974},
            {0.978320, -0.673186, 0.999951, 0.999953},
            {0.971778, -0.673154, 0.999917, 0.999918},
            {0.964420, -0.673144, 0.999865, 0.999865},
            {0.956250, -0.673128, 0.999793, 0.999791},
            {0.947318, -0.673102, 0.999694, 0.999690},
            {0.937597, -0.673032, 0.999557, 0.999542},
            {0.927150, -0.672979, 0.999373, 0.999294},
            {0.916045, -0.672916, 0.999116, 0.997535},
            {0.904194, -0.672812, 0.998710, 0.995790},
            {0.891786, -0.672712, 0.997660, 0.994609},
            {0.878948, -0.672531, 0.993534, 0.993557},
            {0.865477, -0.672390, 0.990703, 0.991766},
            {0.851342, -0.672173, 0.989008, 0.988767},
            {0.836744, -0.671901, 0.986939, 0.986255},
            {0.821780, -0.671602, 0.983749, 0.982544},
            {0.806512, -0.671200, 0.979656, 0.978541},
            {0.790925, -0.670716, 0.974545, 0.973528},
            {0.774921, -0.670133, 0.969860, 0.967700},
            {0.758758, -0.669456, 0.964067, 0.960596},
            {0.742660, -0.668592, 0.956163, 0.952299},
            {0.726217, -0.667485, 0.949125, 0.942684},
            {0.710168, -0.666095, 0.938420, 0.931653},
            {0.693797, -0.664429, 0.928913, 0.921211},
            {0.677796, -0.662322, 0.916594, 0.911489},
            {0.662168, -0.659671, 0.903113, 0.900818},
            {0.646730, -0.656612, 0.888266, 0.889018},
            {0.631493, -0.652815, 0.872921, 0.876245},
            {0.616566, -0.647744, 0.857109, 0.862406},
            {0.600243, -0.641876, 0.843218, 0.847517},
            {0.585232, -0.635771, 0.829895, 0.831852},
            {0.570089, -0.627853, 0.815043, 0.815367},
            {0.555267, -0.618626, 0.799557, 0.798719},
            {0.541323, -0.608743, 0.782885, 0.782223},
            {0.527621, -0.596884, 0.766066, 0.765167},
            {0.513755, -0.583228, 0.748414, 0.747304},
            {0.499932, -0.568693, 0.729810, 0.729133},
            {0.487434, -0.552087, 0.710437, 0.710485},
            {0.475581, -0.534891, 0.691964, 0.692196},
            {0.463387, -0.515937, 0.672876, 0.673589},
            {0.451727, -0.494579, 0.654179, 0.654770},
            {0.440165, -0.471645, 0.635697, 0.635717},
            {0.429488, -0.447681, 0.617436, 0.616986},
            {0.418988, -0.422767, 0.598476, 0.598119},
            {0.409820, -0.396329, 0.579484, 0.579298},
            {0.401253, -0.368503, 0.560293, 0.560560},
            {0.391050, -0.338381, 0.541752, 0.542163},
            {0.383453, -0.308931, 0.523883, 0.523669},
            {0.376973, -0.280121, 0.505544, 0.505564},
            {0.370257, -0.250016, 0.487688, 0.487642},
            {0.364286, -0.218076, 0.470106, 0.469991},
            {0.359004, -0.189819, 0.452562, 0.452658},
            {0.354171, -0.159636, 0.435488, 0.435620},
            {0.344629, -0.106817, 0.418969, 0.418937},
            {0.341801, -0.085562, 0.402677, 0.402612},
            {0.338996, -0.057973, 0.386639, 0.386633},
            {0.336401, -0.028567, 0.370835, 0.371091},
            {0.333984, 0.000000, 0.355929, 0.355949},
            {0.998243, -0.698129, 1.000000, 0.999992},
            {0.998243, -0.698129, 1.000000, 0.999992},
            {0.998230, -0.698129, 0.999999, 0.999992},
            {0.996019, -0.698128, 0.999999, 0.999992},
            {0.992936, -0.698126, 0.999994, 0.999992},
            {0.988984, -0.698126, 0.999985, 0.999986},
            {0.984175, -0.698120, 0.999971, 0.999973},
            {0.978519, -0.698106, 0.999946, 0.999948},
            {0.972046, -0.698102, 0.999908, 0.999909},
            {0.964742, -0.698081, 0.999851, 0.999852},
            {0.956667, -0.698054, 0.999772, 0.999769},
            {0.947790, -0.697997, 0.999661, 0.999656},
            {0.938168, -0.697942, 0.999510, 0.999490},
            {0.927834, -0.697915, 0.999305, 0.999186},
            {0.916803, -0.697786, 0.999017, 0.997059},
            {0.905062, -0.697699, 0.998537, 0.995624},
            {0.892794, -0.697582, 0.996908, 0.994510},
            {0.880077, -0.697374, 0.992583, 0.993327},
            {0.866694, -0.697218, 0.990326, 0.991020},
            {0.852750, -0.696962, 0.988391, 0.988380},
            {0.838165, -0.696683, 0.986618, 0.985771},
            {0.823387, -0.696342, 0.982873, 0.981971},
            {0.808172, -0.695851, 0.978647, 0.978051},
            {0.792730, -0.695262, 0.973880, 0.972892},
            {0.776872, -0.694786, 0.969085, 0.967020},
            {0.760876, -0.693847, 0.962605, 0.959965},
            {0.744817, -0.692949, 0.955064, 0.951625},
            {0.728572, -0.691730, 0.947709, 0.941902},
            {0.712513, -0.690237, 0.937742, 0.930951},
            {0.696280, -0.688369, 0.927661, 0.919370},
            {0.680197, -0.686071, 0.915769, 0.909285},
            {0.664753, -0.683264, 0.902066, 0.898562},
            {0.649335, -0.679671, 0.887621, 0.886809},
            {0.634077, -0.675518, 0.872215, 0.874251},
            {0.619287, -0.670761, 0.855785, 0.860597},
            {0.604024, -0.664649, 0.840479, 0.845808},
            {0.588040, -0.657335, 0.827307, 0.830365},
            {0.573248, -0.649119, 0.812858, 0.813972},
            {0.558382, -0.639703, 0.797183, 0.797260},
            {0.544019, -0.628505, 0.781279, 0.780597},
            {0.529904, -0.616602, 0.764725, 0.763854},
            {0.516412, -0.602591, 0.747297, 0.746401},
            {0.502424, -0.586660, 0.729464, 0.728519},
            {0.489943, -0.570446, 0.710562, 0.710203},
            {0.477694, -0.551587, 0.692146, 0.691882},
            {0.465562, -0.531764, 0.673200, 0.673687},
            {0.453713, -0.510111, 0.654575, 0.655275},
            {0.441830, -0.485575, 0.635836, 0.636621},
            {0.430370, -0.462371, 0.618269, 0.617909},
            {0.420457, -0.435046, 0.599876, 0.599473},
            {0.411142, -0.408139, 0.581251, 0.581032},
            {0.401964, -0.379443, 0.562608, 0.562560},
            {0.392308, -0.350203, 0.543967, 0.544295},
            {0.384134, -0.318625, 0.525984, 0.526228},
            {0.377297, -0.288714, 0.508430, 0.508293},
            {0.369938, -0.257264, 0.490522, 0.490652},
            {0.364741, -0.225342, 0.473338, 0.473242},
            {0.359114, -0.195195, 0.456127, 0.456004},
            {0.353732, -0.165283, 0.439047, 0.439212},
            {0.345613, -0.118441, 0.422506, 0.422663},
            {0.342018, -0.089762, 0.406540, 0.406476},
            {0.338598, -0.059035, 0.390788, 0.390647},
            {0.336291, -0.030236, 0.375178, 0.375204},
            {0.333594, 0.000000, 0.359825, 0.360129},
            {0.999000, -0.723059, 1.000000, 0.999990},
            {0.999000, -0.723059, 1.000000, 0.999990},
            {0.999000, -0.723054, 1.000000, 0.999990},
            {0.996061, -0.723062, 0.999999, 0.999990},
            {0.993006, -0.723059, 0.999992, 0.999990},
            {0.989092, -0.723057, 0.999985, 0.999984},
            {0.984338, -0.723047, 0.999968, 0.999969},
            {0.978736, -0.723045, 0.999940, 0.999940},
            {0.972324, -0.723026, 0.999897, 0.999898},
            {0.965085, -0.723001, 0.999835, 0.999837},
            {0.957082, -0.722985, 0.999747, 0.999746},
            {0.948309, -0.722926, 0.999626, 0.999617},
            {0.938776, -0.722879, 0.999458, 0.999438},
            {0.928516, -0.722808, 0.999231, 0.999016},
            {0.917581, -0.722681, 0.998904, 0.996703},
            {0.905983, -0.722641, 0.998318, 0.995302},
            {0.893895, -0.722446, 0.995479, 0.994356},
            {0.881177, -0.722233, 0.992303, 0.992993},
            {0.867902, -0.722051, 0.990155, 0.990390},
            {0.854080, -0.721723, 0.987730, 0.988072},
            {0.839654, -0.721371, 0.986175, 0.985152},
            {0.825069, -0.721049, 0.981934, 0.981446},
            {0.810016, -0.720535, 0.977771, 0.977273},
            {0.794680, -0.719819, 0.972965, 0.972234},
            {0.778931, -0.719251, 0.968026, 0.966113},
            {0.763111, -0.718355, 0.961343, 0.959033},
            {0.747100, -0.717449, 0.953963, 0.950869},
            {0.730972, -0.715986, 0.945984, 0.941217},
            {0.715040, -0.714239, 0.936638, 0.930175},
            {0.698869, -0.712146, 0.925894, 0.918279},
            {0.682976, -0.709751, 0.914844, 0.906941},
            {0.667463, -0.706487, 0.900848, 0.896201},
            {0.652038, -0.702834, 0.886746, 0.884509},
            {0.636837, -0.698302, 0.871525, 0.871920},
            {0.621935, -0.693196, 0.854914, 0.858420},
            {0.607234, -0.686696, 0.838478, 0.843905},
            {0.591551, -0.678759, 0.824459, 0.828730},
            {0.576229, -0.670237, 0.810525, 0.812524},
            {0.561668, -0.659732, 0.795020, 0.795978},
            {0.547112, -0.648583, 0.779377, 0.778979},
            {0.532975, -0.634545, 0.763410, 0.762450},
            {0.519572, -0.620326, 0.746411, 0.745459},
            {0.504737, -0.605105, 0.728867, 0.727966},
            {0.492164, -0.586420, 0.710804, 0.710046},
            {0.479936, -0.567391, 0.692061, 0.691808},
            {0.467163, -0.547150, 0.673993, 0.673739},
            {0.455434, -0.524347, 0.655138, 0.655756},
            {0.443564, -0.499694, 0.636499, 0.637574},
            {0.432198, -0.475417, 0.618803, 0.619153},
            {0.422139, -0.447816, 0.601362, 0.600887},
            {0.412308, -0.420427, 0.583151, 0.582796},
            {0.402731, -0.391172, 0.564996, 0.564748},
            {0.392956, -0.358694, 0.546575, 0.546636},
            {0.384732, -0.327627, 0.528607, 0.528904},
            {0.377448, -0.295852, 0.511094, 0.511252},
            {0.370768, -0.264460, 0.493695, 0.493791},
            {0.364425, -0.230679, 0.476638, 0.476563},
            {0.358533, -0.197461, 0.459827, 0.459694},
            {0.350807, -0.152645, 0.442926, 0.442942},
            {0.345561, -0.124968, 0.426505, 0.426632},
            {0.341713, -0.092541, 0.410369, 0.410558},
            {0.338648, -0.061232, 0.394962, 0.394895},
            {0.335761, -0.031332, 0.379672, 0.379517},
            {0.333594, 0.000000, 0.364490, 0.364560},
            {0.999000, -0.747987, 1.000000, 0.999989},
            {0.999000, -0.747987, 1.000000, 0.999989},
            {0.999000, -0.747995, 1.000000, 0.999989},
            {0.996101, -0.747994, 0.999998, 0.999989},
            {0.993078, -0.747994, 0.999993, 0.999989},
            {0.989207, -0.747986, 0.999983, 0.999984},
            {0.984491, -0.747973, 0.999965, 0.999966},
            {0.978949, -0.747961, 0.999934, 0.999934},
            {0.972594, -0.747957, 0.999887, 0.999887},
            {0.965447, -0.747917, 0.999818, 0.999819},
            {0.957523, -0.747895, 0.999719, 0.999720},
            {0.948834, -0.747848, 0.999585, 0.999578},
            {0.939402, -0.747772, 0.999401, 0.999367},
            {0.929249, -0.747722, 0.999147, 0.998696},
            {0.918398, -0.747583, 0.998775, 0.996353},
            {0.906953, -0.747473, 0.998021, 0.995201},
            {0.895006, -0.747281, 0.994330, 0.994115},
            {0.882383, -0.747104, 0.991839, 0.992665},
            {0.869210, -0.746797, 0.989904, 0.989948},
            {0.855462, -0.746496, 0.987543, 0.987633},
            {0.841215, -0.746158, 0.985550, 0.984331},
            {0.826731, -0.745634, 0.980631, 0.980826},
            {0.811778, -0.745135, 0.976904, 0.976390},
            {0.796594, -0.744464, 0.971715, 0.971327},
            {0.781050, -0.743651, 0.966545, 0.965201},
            {0.765366, -0.742769, 0.959917, 0.957977},
            {0.749505, -0.741525, 0.952440, 0.949712},
            {0.733617, -0.739933, 0.944563, 0.940128},
            {0.717523, -0.738228, 0.935407, 0.929187},
            {0.701623, -0.735916, 0.924214, 0.917237},
            {0.685706, -0.733070, 0.913493, 0.904644},
            {0.670278, -0.729680, 0.899883, 0.893711},
            {0.654849, -0.725658, 0.885733, 0.882113},
            {0.639519, -0.720855, 0.871087, 0.869516},
            {0.625263, -0.714877, 0.853921, 0.856236},
            {0.610303, -0.707924, 0.837067, 0.841929},
            {0.594610, -0.700019, 0.821670, 0.826924},
            {0.579542, -0.690853, 0.807776, 0.810991},
            {0.565090, -0.679747, 0.792919, 0.794686},
            {0.550106, -0.667840, 0.777407, 0.777761},
            {0.536034, -0.653681, 0.761675, 0.760980},
            {0.522085, -0.638560, 0.745601, 0.744384},
            {0.507510, -0.622512, 0.727896, 0.727314},
            {0.494381, -0.603739, 0.710857, 0.709877},
            {0.481926, -0.584092, 0.692420, 0.691988},
            {0.469280, -0.562554, 0.674468, 0.674098},
            {0.457142, -0.538485, 0.656402, 0.656243},
            {0.444889, -0.514835, 0.637644, 0.638603},
            {0.433718, -0.488551, 0.619650, 0.620606},
            {0.423511, -0.460750, 0.602521, 0.602574},
            {0.413454, -0.432380, 0.585106, 0.584694},
            {0.403419, -0.400634, 0.567438, 0.567018},
            {0.393439, -0.370654, 0.549367, 0.549311},
            {0.385324, -0.335800, 0.531639, 0.531673},
            {0.377673, -0.304757, 0.514147, 0.514403},
            {0.370422, -0.268510, 0.497003, 0.497148},
            {0.365365, -0.239732, 0.480136, 0.480177},
            {0.358868, -0.202899, 0.463435, 0.463439},
            {0.351338, -0.162556, 0.447177, 0.446998},
            {0.345574, -0.129095, 0.430734, 0.430743},
            {0.341751, -0.095618, 0.414822, 0.414943},
            {0.338575, -0.062735, 0.399054, 0.399304},
            {0.335683, -0.032857, 0.384238, 0.384121},
            {0.333203, 0.000000, 0.369408, 0.369251},
            {0.999000, -0.772934, 0.999999, 0.999988},
            {0.999000, -0.772934, 0.999999, 0.999988},
            {0.999000, -0.772914, 1.000000, 0.999988},
            {0.996143, -0.772928, 0.999997, 0.999988},
            {0.993154, -0.772923, 0.999992, 0.999988},
            {0.989321, -0.772924, 0.999981, 0.999981},
            {0.984663, -0.772911, 0.999961, 0.999962},
            {0.979176, -0.772894, 0.999927, 0.999927},
            {0.972896, -0.772897, 0.999875, 0.999874},
            {0.965824, -0.772841, 0.999800, 0.999798},
            {0.957949, -0.772822, 0.999691, 0.999690},
            {0.949363, -0.772744, 0.999542, 0.999533},
            {0.940040, -0.772714, 0.999338, 0.999291},
            {0.929995, -0.772571, 0.999054, 0.997909},
            {0.919253, -0.772483, 0.998626, 0.996117},
            {0.907876, -0.772329, 0.997562, 0.995029},
            {0.896132, -0.772114, 0.993561, 0.993880},
            {0.883599, -0.771911, 0.991049, 0.992142},
            {0.870545, -0.771615, 0.989535, 0.989577},
            {0.856937, -0.771339, 0.987272, 0.987185},
            {0.842899, -0.770888, 0.984652, 0.983588},
            {0.828609, -0.770413, 0.979681, 0.980055},
            {0.813738, -0.769691, 0.976199, 0.975487},
            {0.798632, -0.768918, 0.970565, 0.970172},
            {0.783309, -0.768091, 0.965065, 0.963998},
            {0.767637, -0.767026, 0.958846, 0.956738},
            {0.752009, -0.765735, 0.950597, 0.948637},
            {0.736100, -0.764047, 0.942842, 0.939083},
            {0.720246, -0.761916, 0.933632, 0.928169},
            {0.704376, -0.759502, 0.922796, 0.916143},
            {0.688679, -0.756572, 0.911745, 0.903147},
            {0.673151, -0.752799, 0.898297, 0.890916},
            {0.657742, -0.748352, 0.884392, 0.879389},
            {0.642766, -0.742994, 0.869872, 0.866895},
            {0.628079, -0.736802, 0.853229, 0.853826},
            {0.613140, -0.729598, 0.836208, 0.839729},
            {0.597676, -0.720385, 0.819941, 0.824957},
            {0.583000, -0.711210, 0.805115, 0.809472},
            {0.568099, -0.699115, 0.790506, 0.793341},
            {0.553374, -0.686533, 0.775293, 0.776743},
            {0.539214, -0.672699, 0.760000, 0.759808},
            {0.524603, -0.656656, 0.744380, 0.743277},
            {0.509855, -0.639884, 0.727574, 0.726643},
            {0.496949, -0.620462, 0.710536, 0.709685},
            {0.484244, -0.599344, 0.692952, 0.692249},
            {0.471044, -0.577581, 0.675204, 0.674639},
            {0.458969, -0.552899, 0.657499, 0.657008},
            {0.446754, -0.527688, 0.639298, 0.639576},
            {0.435071, -0.500220, 0.621271, 0.622114},
            {0.424782, -0.472360, 0.603533, 0.604471},
            {0.414675, -0.442566, 0.586950, 0.586851},
            {0.404661, -0.411059, 0.569853, 0.569340},
            {0.394942, -0.381571, 0.552364, 0.552135},
            {0.385378, -0.345622, 0.534807, 0.534806},
            {0.378498, -0.314512, 0.517637, 0.517599},
            {0.370931, -0.279478, 0.500679, 0.500765},
            {0.365234, -0.244773, 0.483669, 0.484035},
            {0.357164, -0.198992, 0.467490, 0.467440},
            {0.351481, -0.168502, 0.451260, 0.451212},
            {0.344885, -0.132225, 0.435329, 0.435240},
            {0.341417, -0.099442, 0.419509, 0.419399},
            {0.338210, -0.065175, 0.403855, 0.404083},
            {0.335177, -0.031899, 0.388734, 0.388944},
            {0.332812, 0.000000, 0.374354, 0.374182},
            {0.999000, -0.797847, 1.000000, 0.999987},
            {0.999000, -0.797847, 1.000000, 0.999987},
            {0.999000, -0.797857, 0.999999, 0.999987},
            {0.996186, -0.797859, 0.999997, 0.999987},
            {0.993232, -0.797855, 0.999991, 0.999987},
            {0.989445, -0.797855, 0.999979, 0.999979},
            {0.984834, -0.797842, 0.999957, 0.999958},
            {0.979414, -0.797838, 0.999919, 0.999919},
            {0.973199, -0.797816, 0.999862, 0.999861},
            {0.966190, -0.797789, 0.999778, 0.999774},
            {0.958417, -0.797730, 0.999659, 0.999656},
            {0.949929, -0.797664, 0.999493, 0.999482},
            {0.940698, -0.797575, 0.999267, 0.999195},
            {0.930767, -0.797490, 0.998949, 0.997307},
            {0.920146, -0.797379, 0.998445, 0.995837},
            {0.908921, -0.797194, 0.996718, 0.994722},
            {0.897253, -0.796970, 0.992678, 0.993707},
            {0.884910, -0.796678, 0.990494, 0.991391},
            {0.871888, -0.796436, 0.988988, 0.989169},
            {0.858465, -0.795991, 0.986885, 0.986461},
            {0.844565, -0.795617, 0.983335, 0.982904},
            {0.830406, -0.794956, 0.978740, 0.979062},
            {0.815643, -0.794264, 0.975204, 0.974536},
            {0.800817, -0.793528, 0.969162, 0.969035},
            {0.785582, -0.792532, 0.963615, 0.962653},
            {0.770040, -0.791275, 0.957491, 0.955486},
            {0.754536, -0.789902, 0.949069, 0.947243},
            {0.738803, -0.788089, 0.940870, 0.937747},
            {0.723027, -0.785844, 0.931646, 0.926861},
            {0.707255, -0.783105, 0.921379, 0.914936},
            {0.691674, -0.779766, 0.909757, 0.901835},
            {0.676169, -0.775581, 0.896721, 0.888472},
            {0.660679, -0.770789, 0.883430, 0.876572},
            {0.645821, -0.765082, 0.868624, 0.864223},
            {0.631047, -0.758187, 0.852480, 0.851252},
            {0.616474, -0.750663, 0.835185, 0.837374},
            {0.601332, -0.741996, 0.818887, 0.822985},
            {0.586381, -0.731059, 0.802651, 0.807788},
            {0.571398, -0.718544, 0.788182, 0.791927},
            {0.556756, -0.705628, 0.772928, 0.775701},
            {0.542162, -0.690656, 0.758242, 0.758928},
            {0.527685, -0.673484, 0.743030, 0.742347},
            {0.512430, -0.655549, 0.727014, 0.725914},
            {0.499536, -0.636051, 0.710212, 0.709495},
            {0.486157, -0.614656, 0.693233, 0.692569},
            {0.473172, -0.591188, 0.676077, 0.675363},
            {0.461301, -0.567565, 0.658607, 0.658085},
            {0.447639, -0.540631, 0.641118, 0.640639},
            {0.436247, -0.513378, 0.623293, 0.623698},
            {0.426430, -0.484869, 0.605589, 0.606505},
            {0.415600, -0.452777, 0.588577, 0.589267},
            {0.405300, -0.421771, 0.572325, 0.572008},
            {0.395847, -0.388854, 0.555428, 0.554939},
            {0.386478, -0.354946, 0.538164, 0.538132},
            {0.378511, -0.318984, 0.521314, 0.521212},
            {0.370278, -0.283819, 0.504564, 0.504487},
            {0.360897, -0.232928, 0.487848, 0.488048},
            {0.357925, -0.208289, 0.471547, 0.471807},
            {0.351366, -0.173260, 0.455602, 0.455651},
            {0.345304, -0.135884, 0.439902, 0.439858},
            {0.341366, -0.101025, 0.424499, 0.424332},
            {0.337888, -0.067906, 0.408982, 0.408983},
            {0.334662, -0.032731, 0.393935, 0.394071},
            {0.332422, 0.000000, 0.379117, 0.379402},
            {0.999000, -0.822791, 1.000000, 0.999986},
            {0.999000, -0.822791, 1.000000, 0.999986},
            {0.999000, -0.822792, 0.999999, 0.999986},
            {0.996233, -0.822793, 0.999996, 0.999986},
            {0.993312, -0.822789, 0.999990, 0.999986},
            {0.989567, -0.822785, 0.999977, 0.999978},
            {0.985016, -0.822780, 0.999952, 0.999954},
            {0.979649, -0.822760, 0.999912, 0.999913},
            {0.973501, -0.822728, 0.999847, 0.999844},
            {0.966600, -0.822707, 0.999755, 0.999753},
            {0.958915, -0.822635, 0.999622, 0.999618},
            {0.950490, -0.822600, 0.999440, 0.999424},
            {0.941354, -0.822505, 0.999188, 0.999067},
            {0.931548, -0.822388, 0.998831, 0.996875},
            {0.921072, -0.822201, 0.998216, 0.995659},
            {0.910021, -0.822051, 0.995201, 0.994603},
            {0.898430, -0.821764, 0.992394, 0.993420},
            {0.886191, -0.821513, 0.990319, 0.990874},
            {0.873365, -0.821134, 0.988177, 0.988713},
            {0.859981, -0.820768, 0.986316, 0.985585},
            {0.846396, -0.820190, 0.981610, 0.982193},
            {0.832181, -0.819661, 0.977901, 0.978145},
            {0.817695, -0.818784, 0.973807, 0.973416},
            {0.803027, -0.817930, 0.967417, 0.967801},
            {0.787968, -0.816778, 0.961834, 0.961483},
            {0.772608, -0.815434, 0.955608, 0.954069},
            {0.757052, -0.813783, 0.947521, 0.945704},
            {0.741702, -0.811733, 0.938644, 0.936138},
            {0.725950, -0.809457, 0.929770, 0.925374},
            {0.710135, -0.806271, 0.919632, 0.913395},
            {0.694905, -0.802884, 0.907187, 0.900339},
            {0.679326, -0.798011, 0.895111, 0.886675},
            {0.663975, -0.793186, 0.881897, 0.873512},
            {0.648889, -0.786862, 0.867051, 0.861326},
            {0.634126, -0.779648, 0.851503, 0.848513},
            {0.619673, -0.771029, 0.834180, 0.834955},
            {0.604346, -0.762341, 0.818237, 0.820820},
            {0.589352, -0.750458, 0.801140, 0.805943},
            {0.575122, -0.738135, 0.785532, 0.790574},
            {0.560073, -0.723975, 0.770872, 0.774677},
            {0.545250, -0.708609, 0.756292, 0.758279},
            {0.530839, -0.691123, 0.741617, 0.741807},
            {0.515280, -0.673317, 0.726335, 0.725271},
            {0.502075, -0.652200, 0.710221, 0.709231},
            {0.488750, -0.628503, 0.693499, 0.692874},
            {0.475327, -0.604921, 0.676957, 0.676189},
            {0.462884, -0.580775, 0.660127, 0.659352},
            {0.450028, -0.553122, 0.642662, 0.642296},
            {0.437840, -0.524772, 0.625700, 0.625250},
            {0.427588, -0.495835, 0.608082, 0.608700},
            {0.416743, -0.464038, 0.590687, 0.591823},
            {0.405914, -0.432498, 0.574497, 0.575012},
            {0.396011, -0.398182, 0.558425, 0.558143},
            {0.386007, -0.360847, 0.541981, 0.541491},
            {0.379219, -0.328315, 0.524931, 0.525075},
            {0.369877, -0.286474, 0.508757, 0.508558},
            {0.362429, -0.249036, 0.492369, 0.492277},
            {0.357697, -0.216870, 0.476094, 0.476270},
            {0.351291, -0.178151, 0.460174, 0.460459},
            {0.345190, -0.138558, 0.444639, 0.444739},
            {0.340547, -0.103716, 0.429486, 0.429400},
            {0.337598, -0.068503, 0.414487, 0.414309},
            {0.334294, -0.033087, 0.399492, 0.399421},
            {0.332031, 0.000000, 0.384700, 0.384907},
            {0.999000, -0.847721, 0.999999, 0.999985},
            {0.999000, -0.847721, 0.999999, 0.999985},
            {0.999000, -0.847731, 0.999999, 0.999985},
            {0.996278, -0.847729, 0.999996, 0.999985},
            {0.993392, -0.847728, 0.999990, 0.999985},
            {0.989690, -0.847711, 0.999975, 0.999977},
            {0.985180, -0.847723, 0.999946, 0.999947},
            {0.979897, -0.847685, 0.999902, 0.999902},
            {0.973833, -0.847656, 0.999832, 0.999832},
            {0.966998, -0.847629, 0.999729, 0.999730},
            {0.959412, -0.847553, 0.999583, 0.999577},
            {0.951096, -0.847503, 0.999380, 0.999359},
            {0.942057, -0.847400, 0.999099, 0.998845},
            {0.932345, -0.847251, 0.998694, 0.996554},
            {0.921969, -0.847070, 0.997895, 0.995328},
            {0.911130, -0.846900, 0.994258, 0.994442},
            {0.899596, -0.846640, 0.991903, 0.992919},
            {0.887548, -0.846363, 0.990062, 0.990392},
            {0.874832, -0.845955, 0.987583, 0.988170},
            {0.861594, -0.845431, 0.985456, 0.984854},
            {0.848202, -0.844918, 0.980291, 0.981312},
            {0.834191, -0.844132, 0.977120, 0.977149},
            {0.819760, -0.843374, 0.972447, 0.972137},
            {0.805258, -0.842362, 0.965981, 0.966207},
            {0.790259, -0.841081, 0.960390, 0.959968},
            {0.775193, -0.839522, 0.953509, 0.952454},
            {0.759851, -0.837688, 0.945585, 0.943873},
            {0.744634, -0.835569, 0.936301, 0.934434},
            {0.728854, -0.832970, 0.927736, 0.923813},
            {0.713299, -0.829523, 0.917656, 0.911942},
            {0.698135, -0.825498, 0.904650, 0.898928},
            {0.682462, -0.820573, 0.893095, 0.885120},
            {0.667048, -0.815104, 0.880437, 0.871043},
            {0.652074, -0.808374, 0.865559, 0.858248},
            {0.637396, -0.800459, 0.850315, 0.845666},
            {0.622576, -0.792190, 0.833799, 0.832346},
            {0.607852, -0.781422, 0.816907, 0.818482},
            {0.592359, -0.769233, 0.800968, 0.804029},
            {0.578507, -0.756591, 0.784099, 0.788982},
            {0.563407, -0.742293, 0.768722, 0.773571},
            {0.548609, -0.725678, 0.754236, 0.757700},
            {0.533877, -0.707493, 0.740072, 0.741484},
            {0.517983, -0.689083, 0.725455, 0.725186},
            {0.504497, -0.667309, 0.710135, 0.708915},
            {0.490734, -0.643473, 0.693865, 0.693244},
            {0.477687, -0.619785, 0.677757, 0.677028},
            {0.464426, -0.593684, 0.661468, 0.660656},
            {0.451801, -0.565534, 0.644816, 0.644079},
            {0.439247, -0.537100, 0.627877, 0.627377},
            {0.428248, -0.505880, 0.611095, 0.610804},
            {0.417594, -0.473749, 0.593846, 0.594542},
            {0.406684, -0.441047, 0.576847, 0.578112},
            {0.397148, -0.407133, 0.561399, 0.561650},
            {0.386993, -0.369365, 0.545491, 0.545163},
            {0.378408, -0.335099, 0.529229, 0.528962},
            {0.368076, -0.283339, 0.513048, 0.512926},
            {0.362849, -0.257167, 0.496936, 0.496893},
            {0.357671, -0.222703, 0.481120, 0.481007},
            {0.351216, -0.185971, 0.465261, 0.465397},
            {0.344415, -0.144080, 0.449716, 0.450042},
            {0.340175, -0.105223, 0.434619, 0.434740},
            {0.337274, -0.069983, 0.419854, 0.419831},
            {0.334184, -0.033896, 0.405352, 0.405156},
            {0.332031, 0.000000, 0.390790, 0.390692},
            {0.999000, -0.872656, 1.000000, 0.999981},
            {0.999000, -0.872656, 1.000000, 0.999981},
            {0.999000, -0.872658, 0.999999, 0.999981},
            {0.996327, -0.872659, 0.999996, 0.999981},
            {0.993481, -0.872660, 0.999988, 0.999981},
            {0.989825, -0.872654, 0.999972, 0.999973},
            {0.985378, -0.872639, 0.999941, 0.999942},
            {0.980146, -0.872621, 0.999892, 0.999891},
            {0.974162, -0.872573, 0.999814, 0.999813},
            {0.967412, -0.872530, 0.999700, 0.999698},
            {0.959907, -0.872478, 0.999538, 0.999532},
            {0.951694, -0.872399, 0.999312, 0.999285},
            {0.942772, -0.872291, 0.999000, 0.998286},
            {0.933217, -0.872140, 0.998531, 0.996295},
            {0.922990, -0.871966, 0.997365, 0.995215},
            {0.912289, -0.871653, 0.993305, 0.994182},
            {0.900903, -0.871460, 0.991010, 0.992032},
            {0.888853, -0.871024, 0.989682, 0.989855},
            {0.876345, -0.870693, 0.987196, 0.987415},
            {0.863344, -0.870101, 0.984114, 0.984047},
            {0.850113, -0.869465, 0.979051, 0.980050},
            {0.836127, -0.868697, 0.975981, 0.976017},
            {0.821991, -0.867706, 0.970769, 0.970845},
            {0.807635, -0.866709, 0.964174, 0.964767},
            {0.792840, -0.865291, 0.958509, 0.958269},
            {0.777731, -0.863602, 0.951812, 0.950600},
            {0.762823, -0.861721, 0.943318, 0.942033},
            {0.747721, -0.859230, 0.933703, 0.932501},
            {0.731930, -0.856103, 0.925449, 0.921807},
            {0.716530, -0.852476, 0.915014, 0.910017},
            {0.701194, -0.848395, 0.902840, 0.897149},
            {0.685952, -0.843110, 0.890550, 0.883414},
            {0.670488, -0.836854, 0.878424, 0.869182},
            {0.655240, -0.829654, 0.864332, 0.855055},
            {0.640798, -0.821088, 0.848488, 0.842687},
            {0.625770, -0.811803, 0.833007, 0.829548},
            {0.610813, -0.801255, 0.816508, 0.816162},
            {0.595591, -0.788715, 0.800274, 0.802072},
            {0.581282, -0.775754, 0.783543, 0.787436},
            {0.566374, -0.760175, 0.767276, 0.772533},
            {0.552245, -0.743392, 0.752463, 0.757043},
            {0.537047, -0.725238, 0.738423, 0.741263},
            {0.521373, -0.704897, 0.724547, 0.725330},
            {0.506672, -0.682891, 0.709873, 0.709262},
            {0.492805, -0.659264, 0.694493, 0.693497},
            {0.479435, -0.635266, 0.678454, 0.678038},
            {0.466029, -0.607530, 0.662954, 0.662128},
            {0.453086, -0.578581, 0.646898, 0.646068},
            {0.440708, -0.549302, 0.630543, 0.629824},
            {0.429351, -0.517378, 0.614046, 0.613436},
            {0.418947, -0.484372, 0.597549, 0.597334},
            {0.407791, -0.450057, 0.580438, 0.581401},
            {0.397215, -0.413133, 0.564376, 0.565372},
            {0.388086, -0.380963, 0.549012, 0.549288},
            {0.377687, -0.338789, 0.533515, 0.533182},
            {0.369701, -0.297440, 0.517585, 0.517405},
            {0.363366, -0.263951, 0.501828, 0.501765},
            {0.357482, -0.228132, 0.486261, 0.486143},
            {0.350860, -0.189596, 0.470795, 0.470675},
            {0.344247, -0.148682, 0.455360, 0.455464},
            {0.340122, -0.109542, 0.440214, 0.440531},
            {0.336964, -0.070740, 0.425459, 0.425630},
            {0.334175, -0.035768, 0.411100, 0.411113},
            {0.331250, 0.000000, 0.397113, 0.396887},
            {0.999000, -0.897581, 0.999999, 0.999982},
            {0.999000, -0.897581, 0.999999, 0.999982},
            {0.999000, -0.897578, 1.000000, 0.999982},
            {0.996376, -0.897594, 0.999996, 0.999982},
            {0.993563, -0.897588, 0.999987, 0.999982},
            {0.989963, -0.897582, 0.999969, 0.999970},
            {0.985581, -0.897577, 0.999935, 0.999934},
            {0.980418, -0.897553, 0.999880, 0.999878},
            {0.974491, -0.897523, 0.999793, 0.999793},
            {0.967834, -0.897476, 0.999667, 0.999665},
            {0.960462, -0.897417, 0.999488, 0.999481},
            {0.952329, -0.897312, 0.999238, 0.999192},
            {0.943544, -0.897184, 0.998886, 0.997505},
            {0.934095, -0.897049, 0.998334, 0.995926},
            {0.924026, -0.896821, 0.996260, 0.995009},
            {0.913410, -0.896544, 0.992662, 0.993736},
            {0.902118, -0.896227, 0.990523, 0.991298},
            {0.890312, -0.895846, 0.989094, 0.989326},
            {0.877897, -0.895401, 0.986608, 0.986371},
            {0.865212, -0.894716, 0.982515, 0.983199},
            {0.851945, -0.894048, 0.978278, 0.979031},
            {0.838223, -0.893146, 0.974324, 0.974595},
            {0.824267, -0.892150, 0.969190, 0.969364},
            {0.809983, -0.891006, 0.962342, 0.963198},
            {0.795489, -0.889356, 0.956210, 0.956385},
            {0.780462, -0.887435, 0.949619, 0.948509},
            {0.765757, -0.885160, 0.940747, 0.939993},
            {0.750515, -0.882465, 0.931302, 0.930421},
            {0.735122, -0.879260, 0.922977, 0.919590},
            {0.719929, -0.875239, 0.912312, 0.908140},
            {0.704674, -0.870496, 0.900389, 0.895349},
            {0.689304, -0.864954, 0.888173, 0.881699},
            {0.673970, -0.858363, 0.876121, 0.867456},
            {0.658903, -0.850689, 0.862543, 0.852784},
            {0.644106, -0.841717, 0.847433, 0.839500},
            {0.629093, -0.831513, 0.831749, 0.826629},
            {0.614390, -0.820162, 0.816155, 0.813602},
            {0.598797, -0.807533, 0.799692, 0.799983},
            {0.584004, -0.793195, 0.783452, 0.785873},
            {0.569527, -0.777848, 0.766682, 0.771340},
            {0.555404, -0.759945, 0.750958, 0.756480},
            {0.540168, -0.740772, 0.736694, 0.741190},
            {0.524571, -0.720262, 0.723421, 0.725687},
            {0.509320, -0.697454, 0.709652, 0.709997},
            {0.495414, -0.673084, 0.694854, 0.694192},
            {0.481487, -0.648024, 0.679710, 0.678975},
            {0.467894, -0.619910, 0.664261, 0.663673},
            {0.454716, -0.591091, 0.648899, 0.648135},
            {0.441115, -0.560409, 0.633307, 0.632442},
            {0.430818, -0.528754, 0.617195, 0.616477},
            {0.419018, -0.492396, 0.601193, 0.600565},
            {0.408520, -0.459514, 0.584880, 0.584772},
            {0.398149, -0.423460, 0.568209, 0.569202},
            {0.388177, -0.386133, 0.552796, 0.553595},
            {0.375447, -0.335033, 0.537534, 0.537882},
            {0.370490, -0.306941, 0.522443, 0.522193},
            {0.363297, -0.269658, 0.507071, 0.506784},
            {0.357456, -0.232220, 0.491582, 0.491554},
            {0.350621, -0.194295, 0.476504, 0.476349},
            {0.343608, -0.152784, 0.461399, 0.461278},
            {0.340352, -0.117714, 0.446323, 0.446419},
            {0.336503, -0.078434, 0.431656, 0.431913},
            {0.333428, -0.037306, 0.417189, 0.417443},
            {0.331641, 0.000000, 0.403280, 0.403271},
            {0.999000, -0.922533, 0.999999, 0.999980},
            {0.999000, -0.922533, 0.999999, 0.999980},
            {0.999000, -0.922527, 0.999999, 0.999980},
            {0.996425, -0.922525, 0.999996, 0.999980},
            {0.993654, -0.922519, 0.999986, 0.999980},
            {0.990107, -0.922518, 0.999965, 0.999966},
            {0.985776, -0.922506, 0.999928, 0.999927},
            {0.980685, -0.922470, 0.999867, 0.999866},
            {0.974852, -0.922436, 0.999771, 0.999772},
            {0.968292, -0.922371, 0.999631, 0.999629},
            {0.960996, -0.922300, 0.999432, 0.999423},
            {0.952995, -0.922220, 0.999152, 0.999075},
            {0.944307, -0.922053, 0.998756, 0.997024},
            {0.934984, -0.921909, 0.998077, 0.995773},
            {0.925092, -0.921611, 0.994607, 0.994651},
            {0.914538, -0.921413, 0.992322, 0.993353},
            {0.903476, -0.920925, 0.990307, 0.990822},
            {0.891657, -0.920543, 0.988176, 0.988569},
            {0.879572, -0.920098, 0.985665, 0.985596},
            {0.866943, -0.919409, 0.981390, 0.982182},
            {0.853903, -0.918693, 0.977341, 0.977871},
            {0.840460, -0.917534, 0.972737, 0.973140},
            {0.826632, -0.916451, 0.967432, 0.967584},
            {0.812559, -0.915237, 0.960304, 0.961408},
            {0.798075, -0.913391, 0.954264, 0.954294},
            {0.783408, -0.911391, 0.947150, 0.946398},
            {0.768646, -0.908975, 0.937799, 0.937603},
            {0.753742, -0.906078, 0.928727, 0.927937},
            {0.738557, -0.902224, 0.919749, 0.917305},
            {0.723325, -0.897984, 0.909641, 0.905833},
            {0.708038, -0.893091, 0.897731, 0.893138},
            {0.693363, -0.887213, 0.885365, 0.879770},
            {0.677470, -0.879434, 0.873768, 0.865720},
            {0.662176, -0.871383, 0.860519, 0.851023},
            {0.647216, -0.861598, 0.846222, 0.836801},
            {0.632535, -0.851007, 0.830188, 0.823784},
            {0.617393, -0.838931, 0.815482, 0.810909},
            {0.601781, -0.825576, 0.799803, 0.797886},
            {0.587012, -0.810171, 0.783079, 0.784177},
            {0.572221, -0.794351, 0.767398, 0.770243},
            {0.558114, -0.775921, 0.750654, 0.755925},
            {0.543153, -0.756521, 0.735328, 0.741144},
            {0.528061, -0.735139, 0.722294, 0.726214},
            {0.512045, -0.710819, 0.709212, 0.710971},
            {0.497319, -0.687749, 0.695280, 0.695563},
            {0.483337, -0.660895, 0.680871, 0.680212},
            {0.469833, -0.632271, 0.665983, 0.665304},
            {0.456957, -0.603076, 0.651023, 0.650297},
            {0.442642, -0.572271, 0.635986, 0.635168},
            {0.431076, -0.539288, 0.620677, 0.619796},
            {0.419390, -0.503454, 0.605008, 0.604217},
            {0.408210, -0.466291, 0.589194, 0.588692},
            {0.399317, -0.431736, 0.573289, 0.573254},
            {0.387729, -0.388615, 0.557188, 0.557998},
            {0.377718, -0.348059, 0.541959, 0.542839},
            {0.371131, -0.313727, 0.527157, 0.527470},
            {0.363221, -0.275345, 0.512282, 0.512162},
            {0.357220, -0.237051, 0.497427, 0.497115},
            {0.350564, -0.196114, 0.482293, 0.482296},
            {0.343113, -0.155674, 0.467659, 0.467477},
            {0.339039, -0.118421, 0.452916, 0.452812},
            {0.335698, -0.080429, 0.438276, 0.438310},
            {0.333200, -0.045202, 0.424035, 0.424184},
            {0.332422, 0.000000, 0.409731, 0.410163},
            {0.999000, -0.947458, 0.999999, 0.999977},
            {0.999000, -0.947458, 0.999999, 0.999977},
            {0.999000, -0.947456, 0.999998, 0.999977},
            {0.996479, -0.947458, 0.999996, 0.999977},
            {0.993747, -0.947460, 0.999985, 0.999977},
            {0.990243, -0.947449, 0.999961, 0.999962},
            {0.985997, -0.947447, 0.999919, 0.999920},
            {0.980960, -0.947410, 0.999853, 0.999852},
            {0.975243, -0.947363, 0.999746, 0.999745},
            {0.968738, -0.947291, 0.999590, 0.999586},
            {0.961538, -0.947191, 0.999368, 0.999354},
            {0.953659, -0.947123, 0.999056, 0.998894},
            {0.945085, -0.946955, 0.998603, 0.996685},
            {0.935875, -0.946726, 0.997693, 0.995485},
            {0.926193, -0.946420, 0.993967, 0.994493},
            {0.915744, -0.946169, 0.991687, 0.992573},
            {0.904802, -0.945785, 0.989988, 0.990323},
            {0.893300, -0.945257, 0.987298, 0.987772},
            {0.881363, -0.944737, 0.984142, 0.984692},
            {0.868868, -0.944019, 0.979848, 0.980887},
            {0.855883, -0.943104, 0.975923, 0.976446},
            {0.842659, -0.942138, 0.971010, 0.971625},
            {0.828885, -0.940944, 0.965392, 0.965717},
            {0.815128, -0.939140, 0.957914, 0.959421},
            {0.800809, -0.937449, 0.951913, 0.951975},
            {0.786458, -0.935068, 0.944378, 0.944086},
            {0.772015, -0.932437, 0.935085, 0.935066},
            {0.756948, -0.929238, 0.926069, 0.925403},
            {0.741810, -0.925063, 0.916657, 0.914814},
            {0.726836, -0.920241, 0.906368, 0.903208},
            {0.711508, -0.914634, 0.895159, 0.890958},
            {0.696418, -0.908194, 0.883124, 0.877817},
            {0.681024, -0.900274, 0.870836, 0.863828},
            {0.665673, -0.891336, 0.858453, 0.849289},
            {0.650787, -0.880981, 0.844772, 0.834872},
            {0.635738, -0.869808, 0.829460, 0.820890},
            {0.620797, -0.857118, 0.814328, 0.808183},
            {0.604608, -0.843167, 0.799710, 0.795660},
            {0.589922, -0.827008, 0.783779, 0.782556},
            {0.575011, -0.809995, 0.767647, 0.769066},
            {0.560419, -0.790966, 0.751983, 0.755386},
            {0.545917, -0.770993, 0.735630, 0.741229},
            {0.530960, -0.749097, 0.721168, 0.726726},
            {0.515035, -0.725676, 0.708704, 0.712170},
            {0.500043, -0.700474, 0.695608, 0.697209},
            {0.485360, -0.672423, 0.681985, 0.682170},
            {0.471646, -0.644386, 0.667860, 0.667203},
            {0.457924, -0.613585, 0.653210, 0.652689},
            {0.444082, -0.583120, 0.638706, 0.637938},
            {0.431817, -0.548489, 0.623967, 0.623262},
            {0.420063, -0.516000, 0.609211, 0.608190},
            {0.409685, -0.475679, 0.593750, 0.593002},
            {0.399063, -0.438196, 0.578278, 0.577817},
            {0.384028, -0.386889, 0.562706, 0.562737},
            {0.378670, -0.357450, 0.547212, 0.547836},
            {0.371342, -0.319771, 0.532167, 0.533036},
            {0.363632, -0.280591, 0.517613, 0.518052},
            {0.356959, -0.241573, 0.503224, 0.503135},
            {0.350364, -0.201319, 0.488634, 0.488422},
            {0.343112, -0.158828, 0.474020, 0.473986},
            {0.338907, -0.120888, 0.459713, 0.459552},
            {0.335177, -0.083182, 0.445470, 0.445282},
            {0.332690, -0.050082, 0.431259, 0.431149},
            {0.326562, 0.000000, 0.417184, 0.417407},
            {0.999000, -0.972390, 0.999999, 0.999973},
            {0.999000, -0.972390, 0.999999, 0.999973},
            {0.999000, -0.972391, 0.999999, 0.999973},
            {0.996530, -0.972392, 0.999994, 0.999973},
            {0.993844, -0.972392, 0.999983, 0.999973},
            {0.990386, -0.972375, 0.999958, 0.999957},
            {0.986192, -0.972358, 0.999911, 0.999914},
            {0.981250, -0.972326, 0.999835, 0.999836},
            {0.975588, -0.972296, 0.999718, 0.999718},
            {0.969199, -0.972230, 0.999545, 0.999538},
            {0.962105, -0.972134, 0.999295, 0.999275},
            {0.954366, -0.972003, 0.998946, 0.998454},
            {0.945900, -0.971846, 0.998420, 0.996341},
            {0.936841, -0.971565, 0.996964, 0.995246},
            {0.927268, -0.971320, 0.992795, 0.994222},
            {0.917081, -0.970904, 0.990620, 0.991844},
            {0.906211, -0.970557, 0.989497, 0.989829},
            {0.894822, -0.970034, 0.986617, 0.986688},
            {0.883074, -0.969398, 0.982838, 0.983562},
            {0.870714, -0.968641, 0.978577, 0.979638},
            {0.858060, -0.967480, 0.974005, 0.974932},
            {0.844916, -0.966359, 0.969384, 0.969827},
            {0.831486, -0.964917, 0.962929, 0.963621},
            {0.817671, -0.963273, 0.955719, 0.957146},
            {0.803656, -0.961310, 0.949309, 0.949365},
            {0.789585, -0.958325, 0.941070, 0.941398},
            {0.774952, -0.955893, 0.932523, 0.932245},
            {0.760334, -0.952047, 0.922793, 0.922556},
            {0.745470, -0.947518, 0.913310, 0.911949},
            {0.730437, -0.942553, 0.903087, 0.900627},
            {0.715339, -0.936459, 0.891881, 0.888440},
            {0.700000, -0.929072, 0.880576, 0.875544},
            {0.684966, -0.921311, 0.867743, 0.862005},
            {0.669548, -0.911132, 0.856136, 0.847810},
            {0.654077, -0.900057, 0.842883, 0.833372},
            {0.638842, -0.888241, 0.828657, 0.819134},
            {0.623971, -0.874829, 0.813630, 0.805509},
            {0.607715, -0.860502, 0.799192, 0.793339},
            {0.592591, -0.843990, 0.784379, 0.780916},
            {0.577767, -0.826596, 0.768597, 0.767837},
            {0.562960, -0.806955, 0.753033, 0.754858},
            {0.548560, -0.786578, 0.737276, 0.741307},
            {0.533601, -0.763966, 0.721854, 0.727496},
            {0.517250, -0.740249, 0.708194, 0.713386},
            {0.502378, -0.714321, 0.695851, 0.699131},
            {0.487261, -0.686198, 0.683072, 0.684542},
            {0.473643, -0.656192, 0.669576, 0.669878},
            {0.459607, -0.623383, 0.655921, 0.655261},
            {0.445776, -0.592807, 0.641510, 0.641035},
            {0.433135, -0.557503, 0.627330, 0.626685},
            {0.420063, -0.523171, 0.613321, 0.612377},
            {0.410302, -0.485584, 0.598644, 0.597625},
            {0.397995, -0.440984, 0.583544, 0.582805},
            {0.387090, -0.400979, 0.568462, 0.568030},
            {0.378681, -0.365147, 0.553372, 0.553204},
            {0.371279, -0.325604, 0.538096, 0.538684},
            {0.363514, -0.285561, 0.523488, 0.524269},
            {0.357321, -0.245642, 0.509058, 0.509662},
            {0.349741, -0.205338, 0.495003, 0.495119},
            {0.342809, -0.163015, 0.481061, 0.480735},
            {0.338717, -0.123842, 0.466706, 0.466634},
            {0.334814, -0.087839, 0.452666, 0.452593},
            {0.328591, -0.030173, 0.438932, 0.438748},
            {0.326562, 0.000000, 0.425143, 0.424915},
            {0.999000, -0.997319, 0.999999, 0.999971},
            {0.999000, -0.997319, 0.999999, 0.999971},
            {0.999000, -0.997324, 0.999999, 0.999971},
            {0.996586, -0.997327, 0.999994, 0.999971},
            {0.993938, -0.997322, 0.999981, 0.999971},
            {0.990542, -0.997310, 0.999952, 0.999956},
            {0.986411, -0.997283, 0.999901, 0.999901},
            {0.981547, -0.997249, 0.999816, 0.999818},
            {0.975979, -0.997216, 0.999684, 0.999683},
            {0.969678, -0.997144, 0.999492, 0.999487},
            {0.962708, -0.996995, 0.999214, 0.999185},
            {0.955091, -0.996860, 0.998818, 0.997584},
            {0.946736, -0.996624, 0.998189, 0.996004},
            {0.937871, -0.996479, 0.995364, 0.995050},
            {0.928406, -0.996091, 0.992518, 0.993715},
            {0.918277, -0.995792, 0.990411, 0.991212},
            {0.907595, -0.995220, 0.988696, 0.989057},
            {0.896459, -0.994582, 0.985452, 0.985879},
            {0.884849, -0.993914, 0.981548, 0.982243},
            {0.872730, -0.993081, 0.977018, 0.978206},
            {0.860250, -0.992089, 0.972124, 0.973119},
            {0.847256, -0.990621, 0.967265, 0.967919},
            {0.834133, -0.989149, 0.960225, 0.961343},
            {0.820489, -0.987060, 0.953222, 0.954603},
            {0.806606, -0.984642, 0.946378, 0.946712},
            {0.792693, -0.982082, 0.937489, 0.938378},
            {0.778257, -0.978790, 0.929478, 0.929266},
            {0.763715, -0.974816, 0.919739, 0.919443},
            {0.749085, -0.970127, 0.909551, 0.908911},
            {0.734031, -0.964428, 0.899488, 0.897725},
            {0.718986, -0.957735, 0.888786, 0.885589},
            {0.703706, -0.949794, 0.877688, 0.873254},
            {0.688619, -0.940876, 0.865447, 0.859889},
            {0.673219, -0.930506, 0.853406, 0.846123},
            {0.657747, -0.919665, 0.841023, 0.832094},
            {0.642111, -0.906551, 0.827651, 0.817898},
            {0.627152, -0.892494, 0.813419, 0.803866},
            {0.610919, -0.876910, 0.798718, 0.791061},
            {0.595479, -0.859846, 0.784778, 0.779235},
            {0.580258, -0.841916, 0.770095, 0.766885},
            {0.565319, -0.821261, 0.754486, 0.754292},
            {0.550564, -0.799772, 0.739253, 0.741565},
            {0.535218, -0.777183, 0.723956, 0.728331},
            {0.519891, -0.753144, 0.709199, 0.714861},
            {0.504685, -0.725698, 0.696104, 0.701179},
            {0.489830, -0.698294, 0.684045, 0.687166},
            {0.475322, -0.668211, 0.671377, 0.673012},
            {0.461168, -0.635923, 0.658440, 0.658716},
            {0.446503, -0.601297, 0.644940, 0.644443},
            {0.434604, -0.567149, 0.630893, 0.630472},
            {0.421779, -0.531619, 0.617194, 0.616519},
            {0.409516, -0.494840, 0.603489, 0.602514},
            {0.401168, -0.456590, 0.589275, 0.588172},
            {0.388108, -0.408636, 0.574354, 0.573689},
            {0.379154, -0.370372, 0.559663, 0.559281},
            {0.371231, -0.330833, 0.545065, 0.544768},
            {0.363006, -0.291403, 0.530136, 0.530543},
            {0.356225, -0.250305, 0.515735, 0.516485},
            {0.349680, -0.207380, 0.501590, 0.502303},
            {0.342607, -0.166567, 0.487841, 0.488100},
            {0.338463, -0.126592, 0.474252, 0.474095},
            {0.330107, -0.067978, 0.460402, 0.460245},
            {0.328946, -0.035797, 0.446603, 0.446598},
            {0.326172, 0.000000, 0.433367, 0.433169},
            {0.999000, -1.022262, 0.999999, 0.999967},
            {0.999000, -1.022262, 0.999999, 0.999967},
            {0.999000, -1.022255, 0.999999, 0.999967},
            {0.996642, -1.022257, 0.999993, 0.999967},
            {0.994035, -1.022248, 0.999978, 0.999967},
            {0.990697, -1.022246, 0.999947, 0.999947},
            {0.986634, -1.022223, 0.999889, 0.999891},
            {0.981832, -1.022185, 0.999794, 0.999794},
            {0.976362, -1.022148, 0.999648, 0.999647},
            {0.970171, -1.022049, 0.999432, 0.999425},
            {0.963312, -1.021913, 0.999120, 0.999062},
            {0.955765, -1.021768, 0.998668, 0.997049},
            {0.947552, -1.021469, 0.997869, 0.995778},
            {0.938886, -1.021351, 0.994294, 0.994652},
            {0.929548, -1.020905, 0.992004, 0.992778},
            {0.919565, -1.020478, 0.990098, 0.990482},
            {0.909095, -1.019951, 0.987342, 0.988004},
            {0.898144, -1.019224, 0.983737, 0.984893},
            {0.886630, -1.018406, 0.980225, 0.980881},
            {0.874719, -1.017599, 0.975058, 0.976605},
            {0.862378, -1.016420, 0.970543, 0.971199},
            {0.849721, -1.014793, 0.964833, 0.965610},
            {0.836724, -1.013153, 0.957659, 0.958925},
            {0.823308, -1.011041, 0.950457, 0.951746},
            {0.809802, -1.008374, 0.942739, 0.943791},
            {0.795804, -1.005410, 0.934468, 0.935200},
            {0.781538, -1.001623, 0.925721, 0.926018},
            {0.767263, -0.997208, 0.916041, 0.916028},
            {0.752596, -0.992028, 0.905821, 0.905724},
            {0.737761, -0.985598, 0.895707, 0.894528},
            {0.722570, -0.978381, 0.885265, 0.882914},
            {0.707619, -0.970196, 0.874411, 0.870741},
            {0.692167, -0.960475, 0.863080, 0.857802},
            {0.676893, -0.949984, 0.850713, 0.844552},
            {0.661486, -0.937608, 0.838787, 0.830857},
            {0.645646, -0.924181, 0.826418, 0.816921},
            {0.630524, -0.909553, 0.813113, 0.803102},
            {0.614047, -0.892981, 0.798979, 0.789625},
            {0.598549, -0.875187, 0.784877, 0.777480},
            {0.582949, -0.856387, 0.771470, 0.765891},
            {0.567654, -0.835604, 0.756806, 0.753908},
            {0.552811, -0.813513, 0.741362, 0.741795},
            {0.536951, -0.789586, 0.726816, 0.729390},
            {0.521920, -0.764794, 0.712095, 0.716440},
            {0.506570, -0.738183, 0.697722, 0.703411},
            {0.491716, -0.710001, 0.685102, 0.690068},
            {0.476346, -0.678147, 0.673110, 0.676438},
            {0.462822, -0.646811, 0.660979, 0.662587},
            {0.447707, -0.613512, 0.648327, 0.648698},
            {0.436228, -0.576183, 0.635072, 0.634732},
            {0.422868, -0.540858, 0.621309, 0.620997},
            {0.411674, -0.505190, 0.608249, 0.607451},
            {0.397389, -0.457620, 0.594783, 0.593765},
            {0.387686, -0.417921, 0.580789, 0.579748},
            {0.378780, -0.377372, 0.566512, 0.565661},
            {0.371215, -0.336810, 0.551929, 0.551594},
            {0.363110, -0.295719, 0.537730, 0.537396},
            {0.355430, -0.252730, 0.523369, 0.523433},
            {0.349506, -0.211601, 0.508965, 0.509708},
            {0.342555, -0.170031, 0.495189, 0.495972},
            {0.334037, -0.108608, 0.481675, 0.482082},
            {0.331555, -0.075607, 0.468522, 0.468427},
            {0.328263, -0.038525, 0.455076, 0.454890},
            {0.326172, 0.000000, 0.441624, 0.441623},
            {0.999000, -1.047197, 0.999999, 0.999964},
            {0.999000, -1.047197, 0.999999, 0.999964},
            {0.999000, -1.047194, 0.999998, 0.999964},
            {0.996700, -1.047194, 0.999993, 0.999964},
            {0.994138, -1.047183, 0.999976, 0.999964},
            {0.990852, -1.047174, 0.999940, 0.999940},
            {0.986860, -1.047140, 0.999877, 0.999875},
            {0.982155, -1.047103, 0.999770, 0.999768},
            {0.976759, -1.047050, 0.999605, 0.999605},
            {0.970677, -1.046961, 0.999361, 0.999352},
            {0.963919, -1.046793, 0.999010, 0.998882},
            {0.956504, -1.046632, 0.998488, 0.996665},
            {0.948531, -1.046458, 0.997310, 0.995459},
            {0.939973, -1.046094, 0.993080, 0.994380},
            {0.930739, -1.045684, 0.990887, 0.992013},
            {0.920953, -1.045259, 0.989608, 0.989912},
            {0.910586, -1.044612, 0.986343, 0.986796},
            {0.899771, -1.043911, 0.982631, 0.983537},
            {0.888570, -1.042945, 0.978734, 0.979326},
            {0.876834, -1.041913, 0.972950, 0.974792},
            {0.864633, -1.040581, 0.968329, 0.969140},
            {0.852297, -1.038904, 0.961665, 0.963160},
            {0.839268, -1.037076, 0.954857, 0.956222},
            {0.826200, -1.034585, 0.947332, 0.948807},
            {0.812757, -1.031556, 0.938826, 0.940518},
            {0.799070, -1.028276, 0.930836, 0.931755},
            {0.784912, -1.024364, 0.922201, 0.922452},
            {0.770862, -1.019586, 0.912285, 0.912319},
            {0.756421, -1.013560, 0.901434, 0.902227},
            {0.741487, -1.006699, 0.891874, 0.891142},
            {0.726603, -0.999005, 0.881524, 0.879838},
            {0.711410, -0.989740, 0.871242, 0.868047},
            {0.695790, -0.979712, 0.860320, 0.855745},
            {0.680644, -0.968126, 0.848482, 0.842718},
            {0.665079, -0.955201, 0.836667, 0.829827},
            {0.649384, -0.941072, 0.825090, 0.816398},
            {0.633805, -0.925422, 0.812725, 0.802786},
            {0.617185, -0.908849, 0.799407, 0.789396},
            {0.601599, -0.889774, 0.785764, 0.776581},
            {0.585257, -0.869678, 0.772551, 0.764901},
            {0.569964, -0.848608, 0.759139, 0.753710},
            {0.554647, -0.825759, 0.744781, 0.742102},
            {0.539245, -0.802237, 0.729783, 0.730448},
            {0.523579, -0.776590, 0.715694, 0.718337},
            {0.507666, -0.749889, 0.701511, 0.705768},
            {0.493934, -0.720420, 0.687584, 0.693172},
            {0.478984, -0.690263, 0.674960, 0.680153},
            {0.464608, -0.656576, 0.663407, 0.666882},
            {0.449116, -0.622599, 0.651590, 0.653402},
            {0.435111, -0.586645, 0.639258, 0.639837},
            {0.422214, -0.545775, 0.626346, 0.626152},
            {0.412127, -0.510560, 0.612854, 0.612676},
            {0.398964, -0.467647, 0.600245, 0.599435},
            {0.386772, -0.427589, 0.587128, 0.586109},
            {0.379358, -0.382990, 0.573516, 0.572473},
            {0.371337, -0.341819, 0.559601, 0.558715},
            {0.362865, -0.301020, 0.545321, 0.544964},
            {0.355288, -0.258514, 0.531458, 0.531112},
            {0.349048, -0.216409, 0.517568, 0.517416},
            {0.341997, -0.172994, 0.503489, 0.503992},
            {0.334554, -0.116657, 0.489888, 0.490653},
            {0.331555, -0.078229, 0.476513, 0.477162},
            {0.328059, -0.040190, 0.463780, 0.463832},
            {0.325391, 0.000000, 0.450809, 0.450645},
            {0.999000, -1.072133, 0.999999, 0.999958},
            {0.999000, -1.072133, 0.999999, 0.999958},
            {0.999000, -1.072124, 0.999998, 0.999958},
            {0.996759, -1.072122, 0.999992, 0.999958},
            {0.994241, -1.072114, 0.999974, 0.999958},
            {0.991012, -1.072107, 0.999932, 0.999933},
            {0.987091, -1.072066, 0.999861, 0.999861},
            {0.982457, -1.072044, 0.999742, 0.999741},
            {0.977188, -1.071955, 0.999556, 0.999554},
            {0.971200, -1.071864, 0.999282, 0.999267},
            {0.964578, -1.071716, 0.998880, 0.998411},
            {0.957272, -1.071485, 0.998265, 0.996303},
            {0.949464, -1.071249, 0.995865, 0.995191},
            {0.940982, -1.070931, 0.992593, 0.993945},
            {0.931940, -1.070473, 0.990426, 0.991406},
            {0.922345, -1.069909, 0.988777, 0.989019},
            {0.912184, -1.069274, 0.984713, 0.985720},
            {0.901626, -1.068562, 0.981109, 0.982057},
            {0.890521, -1.067550, 0.976362, 0.977501},
            {0.878988, -1.066271, 0.971238, 0.972605},
            {0.867008, -1.064824, 0.965830, 0.966698},
            {0.854861, -1.062979, 0.958894, 0.960340},
            {0.842205, -1.060850, 0.951698, 0.953031},
            {0.829385, -1.058156, 0.943221, 0.945347},
            {0.815999, -1.055100, 0.935226, 0.936866},
            {0.802431, -1.051229, 0.926884, 0.927917},
            {0.788510, -1.046685, 0.917800, 0.918563},
            {0.774371, -1.041121, 0.908220, 0.908598},
            {0.760154, -1.035011, 0.897361, 0.898486},
            {0.745156, -1.027398, 0.887839, 0.887794},
            {0.730250, -1.019442, 0.877684, 0.876545},
            {0.715392, -1.009445, 0.867779, 0.865379},
            {0.699869, -0.998348, 0.857528, 0.853428},
            {0.684040, -0.985642, 0.846329, 0.841168},
            {0.668793, -0.972087, 0.834607, 0.828649},
            {0.652852, -0.957144, 0.823476, 0.815967},
            {0.636060, -0.940190, 0.812231, 0.802957},
            {0.619835, -0.923110, 0.799957, 0.789865},
            {0.604119, -0.903610, 0.787105, 0.777077},
            {0.587902, -0.882771, 0.774006, 0.764695},
            {0.572194, -0.861248, 0.761320, 0.753544},
            {0.556373, -0.838673, 0.748081, 0.742694},
            {0.540799, -0.813919, 0.734258, 0.731571},
            {0.524689, -0.787531, 0.719526, 0.720304},
            {0.509050, -0.760197, 0.706087, 0.708490},
            {0.494760, -0.729730, 0.692280, 0.696351},
            {0.480798, -0.699523, 0.678592, 0.684134},
            {0.465948, -0.666008, 0.666011, 0.671470},
            {0.450976, -0.631637, 0.654834, 0.658541},
            {0.436937, -0.596517, 0.643373, 0.645376},
            {0.424289, -0.559029, 0.631194, 0.632209},
            {0.409442, -0.510759, 0.618644, 0.618776},
            {0.399185, -0.475684, 0.605726, 0.605510},
            {0.387738, -0.435539, 0.593242, 0.592527},
            {0.379247, -0.387943, 0.580540, 0.579546},
            {0.370758, -0.346545, 0.567384, 0.566310},
            {0.362619, -0.304773, 0.553858, 0.552860},
            {0.355310, -0.262722, 0.539885, 0.539492},
            {0.349097, -0.219905, 0.526421, 0.526005},
            {0.338368, -0.160559, 0.512931, 0.512564},
            {0.334739, -0.120649, 0.499155, 0.499340},
            {0.330681, -0.082590, 0.485725, 0.486360},
            {0.327929, -0.037817, 0.472638, 0.473357},
            {0.325391, 0.000000, 0.459877, 0.460306},
            {0.999000, -1.097059, 0.999998, 0.999956},
            {0.999000, -1.097059, 0.999998, 0.999956},
            {0.999000, -1.097051, 0.999998, 0.999956},
            {0.996821, -1.097059, 0.999989, 0.999956},
            {0.994355, -1.097047, 0.999969, 0.999956},
            {0.991184, -1.097026, 0.999925, 0.999926},
            {0.987336, -1.096997, 0.999842, 0.999842},
            {0.982809, -1.096951, 0.999708, 0.999710},
            {0.977582, -1.096874, 0.999500, 0.999498},
            {0.971749, -1.096776, 0.999186, 0.999164},
            {0.965226, -1.096604, 0.998728, 0.997463},
            {0.957993, -1.096219, 0.997962, 0.995870},
            {0.950367, -1.096092, 0.994427, 0.994917},
            {0.942081, -1.095688, 0.992092, 0.992911},
            {0.933205, -1.095186, 0.990071, 0.990682},
            {0.923689, -1.094574, 0.987248, 0.987816},
            {0.913869, -1.093998, 0.983305, 0.984410},
            {0.903355, -1.092944, 0.979830, 0.980551},
            {0.892656, -1.091939, 0.973457, 0.975693},
            {0.881242, -1.090577, 0.968897, 0.970263},
            {0.869416, -1.089060, 0.962415, 0.963946},
            {0.857448, -1.086936, 0.955864, 0.957248},
            {0.844959, -1.084243, 0.948131, 0.949765},
            {0.832391, -1.081309, 0.939160, 0.941571},
            {0.819235, -1.078151, 0.930825, 0.932941},
            {0.805903, -1.073513, 0.922614, 0.923873},
            {0.792188, -1.068716, 0.913597, 0.914332},
            {0.778168, -1.062874, 0.903709, 0.904560},
            {0.763897, -1.055760, 0.893453, 0.894394},
            {0.749187, -1.047800, 0.883244, 0.884127},
            {0.734211, -1.038781, 0.873591, 0.873294},
            {0.719148, -1.028376, 0.864411, 0.862503},
            {0.703391, -1.016997, 0.854607, 0.851335},
            {0.687653, -1.003270, 0.844230, 0.839566},
            {0.672123, -0.988836, 0.833084, 0.827776},
            {0.656406, -0.973494, 0.822180, 0.815708},
            {0.639418, -0.955863, 0.811749, 0.803370},
            {0.622626, -0.937874, 0.800355, 0.790821},
            {0.606805, -0.916910, 0.788541, 0.778386},
            {0.590247, -0.896300, 0.776546, 0.766121},
            {0.574563, -0.872930, 0.763553, 0.754193},
            {0.558395, -0.850393, 0.751390, 0.743420},
            {0.542289, -0.824450, 0.738618, 0.732975},
            {0.526021, -0.797258, 0.725032, 0.722326},
            {0.510570, -0.769569, 0.711062, 0.711376},
            {0.495979, -0.739394, 0.697826, 0.699992},
            {0.481755, -0.708179, 0.684334, 0.688180},
            {0.467258, -0.674291, 0.670895, 0.676354},
            {0.451821, -0.639577, 0.658580, 0.664004},
            {0.437148, -0.602761, 0.647344, 0.651449},
            {0.424848, -0.566094, 0.636150, 0.638600},
            {0.410340, -0.523003, 0.624394, 0.625776},
            {0.399671, -0.481520, 0.612155, 0.612660},
            {0.387943, -0.440700, 0.599646, 0.599603},
            {0.379013, -0.393360, 0.587399, 0.586719},
            {0.370894, -0.350687, 0.574982, 0.574078},
            {0.362341, -0.308919, 0.562338, 0.561273},
            {0.354709, -0.265726, 0.549260, 0.548129},
            {0.342709, -0.205126, 0.535786, 0.535155},
            {0.338177, -0.165468, 0.522405, 0.522015},
            {0.333976, -0.124126, 0.509389, 0.508851},
            {0.330405, -0.082162, 0.495964, 0.495837},
            {0.327258, -0.039803, 0.482710, 0.483190},
            {0.325000, 0.000000, 0.469842, 0.470624},
            {0.999000, -1.121998, 0.999998, 0.999947},
            {0.999000, -1.121998, 0.999998, 0.999947},
            {0.999000, -1.121998, 0.999998, 0.999947},
            {0.996879, -1.121988, 0.999989, 0.999947},
            {0.994456, -1.121979, 0.999965, 0.999947},
            {0.991367, -1.121963, 0.999913, 0.999916},
            {0.987576, -1.121936, 0.999821, 0.999823},
            {0.983145, -1.121853, 0.999669, 0.999669},
            {0.978024, -1.121783, 0.999431, 0.999425},
            {0.972265, -1.121668, 0.999075, 0.999025},
            {0.965881, -1.121466, 0.998543, 0.996874},
            {0.958901, -1.121204, 0.997460, 0.995670},
            {0.951341, -1.120959, 0.993249, 0.994415},
            {0.943198, -1.120503, 0.990899, 0.991991},
            {0.934434, -1.120009, 0.989490, 0.989766},
            {0.925242, -1.119245, 0.985563, 0.986646},
            {0.915542, -1.118597, 0.981729, 0.982812},
            {0.905164, -1.117446, 0.977663, 0.978356},
            {0.894665, -1.116226, 0.971599, 0.973317},
            {0.883420, -1.114586, 0.966191, 0.967611},
            {0.872058, -1.112751, 0.959238, 0.960820},
            {0.860059, -1.110287, 0.952443, 0.953603},
            {0.848077, -1.107954, 0.943415, 0.945969},
            {0.835402, -1.104663, 0.934916, 0.937323},
            {0.822615, -1.100521, 0.926618, 0.928661},
            {0.809478, -1.095773, 0.917867, 0.919507},
            {0.795845, -1.090202, 0.908797, 0.909833},
            {0.782021, -1.083698, 0.898828, 0.900245},
            {0.767777, -1.076283, 0.889017, 0.890390},
            {0.753156, -1.067447, 0.878848, 0.880252},
            {0.738214, -1.057932, 0.869637, 0.870000},
            {0.722826, -1.046259, 0.860899, 0.859518},
            {0.707249, -1.034063, 0.851518, 0.849162},
            {0.691434, -1.019869, 0.841939, 0.838101},
            {0.675806, -1.004758, 0.831794, 0.826960},
            {0.659476, -0.988483, 0.821512, 0.815688},
            {0.642844, -0.970444, 0.811066, 0.804126},
            {0.625382, -0.951565, 0.800991, 0.792234},
            {0.609075, -0.930386, 0.790083, 0.780356},
            {0.592460, -0.908596, 0.778955, 0.768474},
            {0.576490, -0.885426, 0.767286, 0.756678},
            {0.560408, -0.860488, 0.754776, 0.745159},
            {0.543934, -0.835034, 0.742962, 0.734601},
            {0.527167, -0.807411, 0.730522, 0.724624},
            {0.511019, -0.778932, 0.717459, 0.714339},
            {0.496915, -0.748749, 0.704057, 0.703751},
            {0.482047, -0.715977, 0.690994, 0.692766},
            {0.468122, -0.682477, 0.677902, 0.681267},
            {0.452242, -0.648462, 0.664663, 0.669799},
            {0.439757, -0.612935, 0.652586, 0.657871},
            {0.422079, -0.566898, 0.640912, 0.645577},
            {0.411647, -0.532385, 0.630025, 0.633102},
            {0.400845, -0.487154, 0.618589, 0.620560},
            {0.388159, -0.445093, 0.606845, 0.607737},
            {0.378590, -0.403453, 0.594672, 0.594890},
            {0.370940, -0.353680, 0.582562, 0.582143},
            {0.362200, -0.309962, 0.570703, 0.569779},
            {0.348938, -0.250966, 0.558436, 0.557360},
            {0.343308, -0.211836, 0.545816, 0.544651},
            {0.338178, -0.170620, 0.532800, 0.531942},
            {0.333251, -0.126631, 0.519654, 0.519228},
            {0.329921, -0.085278, 0.506828, 0.506467},
            {0.326815, -0.042237, 0.494072, 0.493710},
            {0.325000, 0.000000, 0.481178, 0.481143},
            {0.999000, -1.146922, 0.999997, 0.999938},
            {0.999000, -1.146922, 0.999997, 0.999938},
            {0.999000, -1.146923, 0.999998, 0.999938},
            {0.996944, -1.146916, 0.999988, 0.999938},
            {0.994572, -1.146912, 0.999960, 0.999938},
            {0.991532, -1.146885, 0.999903, 0.999901},
            {0.987833, -1.146854, 0.999797, 0.999798},
            {0.983485, -1.146798, 0.999622, 0.999622},
            {0.978481, -1.146664, 0.999350, 0.999341},
            {0.972860, -1.146529, 0.998941, 0.998801},
            {0.966593, -1.146340, 0.998311, 0.996398},
            {0.959763, -1.146054, 0.996113, 0.995225},
            {0.952412, -1.145731, 0.992574, 0.993927},
            {0.944397, -1.145253, 0.990347, 0.991339},
            {0.935795, -1.144667, 0.988423, 0.988500},
            {0.926827, -1.143588, 0.983732, 0.985327},
            {0.917247, -1.142929, 0.980414, 0.981195},
            {0.907153, -1.141960, 0.974333, 0.976383},
            {0.896737, -1.140516, 0.969074, 0.970726},
            {0.885882, -1.138715, 0.962579, 0.964471},
            {0.874560, -1.136755, 0.955851, 0.957386},
            {0.862872, -1.134069, 0.948277, 0.949813},
            {0.851123, -1.131738, 0.938871, 0.941694},
            {0.838695, -1.127250, 0.929822, 0.932681},
            {0.826013, -1.123130, 0.921472, 0.923974},
            {0.813024, -1.117540, 0.912872, 0.914755},
            {0.799531, -1.111172, 0.903456, 0.905026},
            {0.785773, -1.104438, 0.894194, 0.895649},
            {0.771523, -1.096050, 0.884521, 0.886178},
            {0.756954, -1.086726, 0.874321, 0.876277},
            {0.741960, -1.076022, 0.865630, 0.866629},
            {0.726731, -1.064182, 0.857113, 0.856890},
            {0.710910, -1.050875, 0.848687, 0.846934},
            {0.694901, -1.036118, 0.839859, 0.836887},
            {0.678931, -1.020439, 0.830588, 0.826373},
            {0.662719, -1.002929, 0.821057, 0.815885},
            {0.645969, -0.984039, 0.811238, 0.805169},
            {0.628126, -0.964255, 0.801529, 0.794133},
            {0.611341, -0.942985, 0.791746, 0.782812},
            {0.594431, -0.920802, 0.781561, 0.771547},
            {0.578296, -0.896357, 0.770891, 0.760175},
            {0.561839, -0.870301, 0.759667, 0.748896},
            {0.545159, -0.843992, 0.747649, 0.737688},
            {0.528856, -0.816747, 0.735959, 0.727151},
            {0.512112, -0.787611, 0.724093, 0.717601},
            {0.497899, -0.756284, 0.711588, 0.707670},
            {0.482628, -0.723550, 0.698609, 0.697425},
            {0.467346, -0.689726, 0.685491, 0.686789},
            {0.451704, -0.655336, 0.672882, 0.675664},
            {0.439741, -0.619262, 0.660051, 0.664513},
            {0.424015, -0.577646, 0.647653, 0.652962},
            {0.412815, -0.539111, 0.635867, 0.640965},
            {0.400348, -0.496290, 0.624952, 0.628851},
            {0.387716, -0.454718, 0.613980, 0.616551},
            {0.378529, -0.407335, 0.602659, 0.604169},
            {0.371765, -0.359187, 0.590954, 0.591559},
            {0.362297, -0.314484, 0.578965, 0.579009},
            {0.351687, -0.262880, 0.567422, 0.566648},
            {0.342922, -0.216554, 0.555591, 0.554597},
            {0.337384, -0.173797, 0.543376, 0.542382},
            {0.332725, -0.131448, 0.530996, 0.529999},
            {0.328887, -0.087933, 0.518350, 0.517655},
            {0.326243, -0.047338, 0.505665, 0.505254},
            {0.325391, 0.000000, 0.493382, 0.492894},
            {0.999000, -1.171862, 0.999998, 0.999929},
            {0.999000, -1.171862, 0.999998, 0.999929},
            {0.999000, -1.171863, 0.999997, 0.999929},
            {0.997013, -1.171850, 0.999985, 0.999929},
            {0.994686, -1.171835, 0.999954, 0.999929},
            {0.991711, -1.171819, 0.999888, 0.999889},
            {0.988095, -1.171755, 0.999767, 0.999766},
            {0.983827, -1.171709, 0.999567, 0.999562},
            {0.978948, -1.171596, 0.999253, 0.999240},
            {0.973419, -1.171435, 0.998779, 0.997952},
            {0.967264, -1.171182, 0.997992, 0.996094},
            {0.960667, -1.170950, 0.994408, 0.994979},
            {0.953343, -1.170454, 0.991969, 0.992773},
            {0.945477, -1.169904, 0.989880, 0.990536},
            {0.937135, -1.169315, 0.986186, 0.987213},
            {0.928282, -1.168505, 0.982230, 0.983322},
            {0.918898, -1.167406, 0.978255, 0.978938},
            {0.909121, -1.166230, 0.971639, 0.973714},
            {0.898854, -1.164672, 0.965949, 0.967681},
            {0.888170, -1.162747, 0.958824, 0.960981},
            {0.877201, -1.160484, 0.952106, 0.953144},
            {0.865848, -1.157617, 0.943239, 0.945475},
            {0.854228, -1.153961, 0.933548, 0.936909},
            {0.841914, -1.149724, 0.924863, 0.927734},
            {0.829351, -1.145072, 0.916280, 0.918826},
            {0.816522, -1.139113, 0.907393, 0.909590},
            {0.803244, -1.132159, 0.898210, 0.900085},
            {0.789338, -1.124419, 0.889091, 0.890867},
            {0.775471, -1.115616, 0.879742, 0.881801},
            {0.760979, -1.105570, 0.870124, 0.872565},
            {0.745876, -1.093818, 0.861392, 0.863236},
            {0.730390, -1.080544, 0.853716, 0.854239},
            {0.714312, -1.066986, 0.845942, 0.845060},
            {0.698286, -1.051393, 0.837797, 0.835686},
            {0.681965, -1.034750, 0.829396, 0.826251},
            {0.666137, -1.016497, 0.821080, 0.816284},
            {0.648788, -0.996923, 0.812122, 0.806586},
            {0.631056, -0.976410, 0.802445, 0.796419},
            {0.613406, -0.954864, 0.793666, 0.785914},
            {0.596777, -0.931740, 0.784309, 0.775210},
            {0.580075, -0.907507, 0.774640, 0.764461},
            {0.563228, -0.880222, 0.764582, 0.753599},
            {0.546364, -0.853628, 0.753662, 0.742805},
            {0.529670, -0.824569, 0.742123, 0.731872},
            {0.513221, -0.795360, 0.730661, 0.721370},
            {0.497757, -0.764439, 0.719055, 0.711898},
            {0.483165, -0.731800, 0.707286, 0.702337},
            {0.468554, -0.698233, 0.694761, 0.692383},
            {0.453522, -0.664402, 0.681597, 0.682137},
            {0.435461, -0.620962, 0.669227, 0.671365},
            {0.424786, -0.584234, 0.656884, 0.660479},
            {0.412723, -0.545146, 0.644352, 0.649314},
            {0.400184, -0.505937, 0.632596, 0.637685},
            {0.388155, -0.460912, 0.621127, 0.625899},
            {0.379253, -0.413060, 0.610540, 0.613898},
            {0.371896, -0.363844, 0.599650, 0.601865},
            {0.358921, -0.306607, 0.588267, 0.589582},
            {0.352181, -0.268356, 0.576637, 0.577285},
            {0.343492, -0.221341, 0.565221, 0.565013},
            {0.337350, -0.176815, 0.553946, 0.553106},
            {0.332024, -0.132885, 0.542327, 0.541280},
            {0.328684, -0.092521, 0.530482, 0.529367},
            {0.320901, 0.000000, 0.518377, 0.517320},
            {0.319531, 0.000000, 0.506118, 0.505411},
            {0.999000, -1.196783, 0.999996, 0.999920},
            {0.999000, -1.196783, 0.999996, 0.999920},
            {0.999000, -1.196789, 0.999996, 0.999920},
            {0.997073, -1.196781, 0.999983, 0.999920},
            {0.994809, -1.196772, 0.999946, 0.999920},
            {0.991906, -1.196737, 0.999871, 0.999869},
            {0.988356, -1.196682, 0.999731, 0.999732},
            {0.984185, -1.196612, 0.999500, 0.999499},
            {0.979406, -1.196460, 0.999136, 0.999110},
            {0.974016, -1.196289, 0.998576, 0.997167},
            {0.968038, -1.196081, 0.997457, 0.995720},
            {0.961521, -1.195688, 0.992872, 0.994349},
            {0.954452, -1.195283, 0.990529, 0.991727},
            {0.946726, -1.194719, 0.989032, 0.989197},
            {0.938620, -1.193912, 0.983984, 0.985883},
            {0.929904, -1.192895, 0.980671, 0.981483},
            {0.920875, -1.191756, 0.974701, 0.976618},
            {0.911180, -1.190503, 0.968830, 0.970597},
            {0.901125, -1.188364, 0.961969, 0.964122},
            {0.890769, -1.186247, 0.955013, 0.956994},
            {0.879820, -1.183891, 0.946894, 0.948639},
            {0.868808, -1.180473, 0.937922, 0.940500},
            {0.857442, -1.176862, 0.927893, 0.931606},
            {0.845309, -1.172151, 0.919152, 0.922385},
            {0.832983, -1.166066, 0.910629, 0.913291},
            {0.820345, -1.159733, 0.901538, 0.904205},
            {0.807184, -1.151792, 0.892661, 0.894938},
            {0.793149, -1.143989, 0.883822, 0.885890},
            {0.779290, -1.134269, 0.874694, 0.877334},
            {0.764559, -1.123305, 0.865901, 0.868754},
            {0.749613, -1.110677, 0.857431, 0.860053},
            {0.734015, -1.097270, 0.850442, 0.851683},
            {0.718134, -1.082433, 0.843210, 0.843447},
            {0.701785, -1.066176, 0.835954, 0.834889},
            {0.685162, -1.048990, 0.828626, 0.826304},
            {0.667640, -1.029588, 0.821223, 0.817441},
            {0.651195, -1.009278, 0.813145, 0.808285},
            {0.633529, -0.988741, 0.804738, 0.799141},
            {0.616229, -0.965677, 0.795848, 0.789570},
            {0.598525, -0.942661, 0.787425, 0.779600},
            {0.581561, -0.917717, 0.778543, 0.769510},
            {0.563984, -0.890453, 0.769567, 0.759155},
            {0.547708, -0.862056, 0.759854, 0.748882},
            {0.530355, -0.832576, 0.749410, 0.738346},
            {0.513764, -0.804332, 0.738297, 0.727629},
            {0.498585, -0.771282, 0.726858, 0.717273},
            {0.482834, -0.737006, 0.715819, 0.707467},
            {0.466922, -0.703789, 0.704405, 0.698283},
            {0.449913, -0.664995, 0.692427, 0.688609},
            {0.436667, -0.628160, 0.679772, 0.678748},
            {0.424979, -0.591456, 0.667015, 0.668371},
            {0.412578, -0.549973, 0.655110, 0.657739},
            {0.399988, -0.509189, 0.643079, 0.646951},
            {0.388193, -0.467780, 0.630651, 0.635765},
            {0.379543, -0.418869, 0.619163, 0.624253},
            {0.368840, -0.373331, 0.608151, 0.612647},
            {0.359976, -0.315167, 0.597691, 0.600900},
            {0.352127, -0.272018, 0.586857, 0.589061},
            {0.343492, -0.224842, 0.575693, 0.576998},
            {0.336963, -0.179687, 0.564626, 0.564991},
            {0.332268, -0.137040, 0.553524, 0.553102},
            {0.327993, -0.095813, 0.542414, 0.541517},
            {0.321291, 0.000000, 0.531130, 0.530027},
            {0.319531, 0.000000, 0.519549, 0.518495},
            {0.999000, -1.221723, 0.999996, 0.999906},
            {0.999000, -1.221723, 0.999996, 0.999906},
            {0.999000, -1.221726, 0.999996, 0.999906},
            {0.997146, -1.221713, 0.999981, 0.999906},
            {0.994932, -1.221707, 0.999939, 0.999906},
            {0.992085, -1.221669, 0.999851, 0.999851},
            {0.988622, -1.221602, 0.999687, 0.999684},
            {0.984552, -1.221529, 0.999417, 0.999412},
            {0.979878, -1.221361, 0.998992, 0.998925},
            {0.974626, -1.221155, 0.998315, 0.996597},
            {0.968753, -1.220868, 0.995740, 0.995207},
            {0.962395, -1.220440, 0.992425, 0.993603},
            {0.955482, -1.219953, 0.990113, 0.990903},
            {0.947972, -1.219367, 0.987172, 0.987594},
            {0.939964, -1.218369, 0.982426, 0.983814},
            {0.931564, -1.217385, 0.978288, 0.979016},
            {0.922635, -1.216060, 0.971721, 0.973647},
            {0.913268, -1.214556, 0.965078, 0.967048},
            {0.903562, -1.212392, 0.957671, 0.960109},
            {0.893175, -1.210101, 0.950470, 0.952123},
            {0.882760, -1.207013, 0.941595, 0.943560},
            {0.872010, -1.203114, 0.931891, 0.934900},
            {0.860600, -1.199076, 0.921818, 0.925747},
            {0.848786, -1.193946, 0.913225, 0.916566},
            {0.836629, -1.187464, 0.904181, 0.907305},
            {0.823975, -1.180009, 0.895346, 0.898441},
            {0.810713, -1.171976, 0.886838, 0.889629},
            {0.797196, -1.162495, 0.878212, 0.881042},
            {0.783012, -1.151854, 0.870009, 0.872874},
            {0.768199, -1.140128, 0.861796, 0.865065},
            {0.753237, -1.127199, 0.854245, 0.857225},
            {0.737576, -1.112298, 0.847258, 0.849446},
            {0.721138, -1.097032, 0.840922, 0.842063},
            {0.705007, -1.079944, 0.834436, 0.834561},
            {0.688051, -1.061536, 0.828193, 0.826814},
            {0.670871, -1.042082, 0.821557, 0.818875},
            {0.653557, -1.021538, 0.814650, 0.810748},
            {0.635493, -0.999387, 0.807282, 0.802316},
            {0.617763, -0.976973, 0.799465, 0.793699},
            {0.600589, -0.953007, 0.791033, 0.784704},
            {0.582803, -0.927693, 0.782989, 0.775198},
            {0.565620, -0.899573, 0.774738, 0.765642},
            {0.548492, -0.870996, 0.766050, 0.755735},
            {0.530590, -0.842320, 0.756827, 0.745873},
            {0.514081, -0.810650, 0.746859, 0.735526},
            {0.498020, -0.778609, 0.736171, 0.725229},
            {0.483594, -0.746234, 0.724875, 0.714892},
            {0.465316, -0.711429, 0.714074, 0.704807},
            {0.448567, -0.672124, 0.703135, 0.695502},
            {0.436312, -0.634142, 0.691630, 0.686241},
            {0.424039, -0.595036, 0.679597, 0.676633},
            {0.412110, -0.554725, 0.666870, 0.666688},
            {0.398697, -0.515583, 0.654715, 0.656384},
            {0.387331, -0.470852, 0.643059, 0.645871},
            {0.378440, -0.428604, 0.631116, 0.635174},
            {0.366058, -0.369365, 0.618956, 0.624113},
            {0.360361, -0.319431, 0.607779, 0.612788},
            {0.352298, -0.275977, 0.597090, 0.601426},
            {0.342586, -0.225470, 0.586754, 0.589925},
            {0.336726, -0.180860, 0.576109, 0.578399},
            {0.331922, -0.141351, 0.565286, 0.566612},
            {0.324248, -0.077407, 0.554470, 0.554931},
            {0.321604, -0.037855, 0.543680, 0.543383},
            {0.319141, 0.000000, 0.532992, 0.532065},
            {0.999000, -1.246659, 0.999995, 0.999889},
            {0.999000, -1.246659, 0.999995, 0.999889},
            {0.999000, -1.246655, 0.999996, 0.999889},
            {0.997213, -1.246646, 0.999978, 0.999889},
            {0.995062, -1.246637, 0.999928, 0.999889},
            {0.992292, -1.246584, 0.999824, 0.999824},
            {0.988921, -1.246527, 0.999632, 0.999633},
            {0.984936, -1.246420, 0.999314, 0.999306},
            {0.980354, -1.246246, 0.998807, 0.998430},
            {0.975250, -1.245968, 0.997943, 0.996133},
            {0.969547, -1.245736, 0.994138, 0.994890},
            {0.963311, -1.245269, 0.991389, 0.992316},
            {0.956569, -1.244681, 0.989344, 0.989752},
            {0.949290, -1.243906, 0.984082, 0.986095},
            {0.941500, -1.242992, 0.980634, 0.981564},
            {0.933203, -1.241754, 0.974496, 0.976234},
            {0.924511, -1.240243, 0.967955, 0.970081},
            {0.915450, -1.238379, 0.960240, 0.962779},
            {0.905900, -1.236093, 0.953344, 0.955232},
            {0.895966, -1.233207, 0.944622, 0.946702},
            {0.885502, -1.229984, 0.935147, 0.937716},
            {0.874961, -1.225828, 0.924937, 0.928604},
            {0.863846, -1.220696, 0.915307, 0.919281},
            {0.852076, -1.214933, 0.906317, 0.910167},
            {0.840159, -1.208175, 0.897412, 0.901046},
            {0.827604, -1.199728, 0.889022, 0.892446},
            {0.814377, -1.190471, 0.880779, 0.884183},
            {0.800707, -1.180350, 0.872932, 0.876253},
            {0.786634, -1.169117, 0.865319, 0.868620},
            {0.771964, -1.156348, 0.857945, 0.861545},
            {0.756672, -1.142383, 0.851217, 0.854673},
            {0.740728, -1.126807, 0.844609, 0.847885},
            {0.724752, -1.110924, 0.838894, 0.841074},
            {0.708073, -1.092705, 0.833476, 0.834610},
            {0.691038, -1.073815, 0.828066, 0.827984},
            {0.673575, -1.053641, 0.822414, 0.820945},
            {0.656045, -1.031973, 0.816529, 0.813648},
            {0.637764, -1.009874, 0.810148, 0.806232},
            {0.619685, -0.986597, 0.803427, 0.798444},
            {0.601576, -0.962280, 0.796116, 0.790232},
            {0.584701, -0.934934, 0.788127, 0.781853},
            {0.567074, -0.908428, 0.780312, 0.772897},
            {0.549435, -0.878888, 0.772544, 0.763648},
            {0.530933, -0.848299, 0.764329, 0.754227},
            {0.514586, -0.816436, 0.755415, 0.744542},
            {0.498749, -0.784761, 0.745929, 0.734689},
            {0.483195, -0.750998, 0.735750, 0.724526},
            {0.460808, -0.712314, 0.724934, 0.714204},
            {0.449310, -0.679460, 0.713911, 0.704152},
            {0.435330, -0.642045, 0.703440, 0.694222},
            {0.423692, -0.599173, 0.692439, 0.685143},
            {0.410936, -0.560266, 0.680836, 0.675860},
            {0.397817, -0.517811, 0.668805, 0.666319},
            {0.386741, -0.474868, 0.656402, 0.656415},
            {0.372222, -0.423252, 0.644659, 0.646273},
            {0.364367, -0.380648, 0.633304, 0.635902},
            {0.357027, -0.330346, 0.621521, 0.625399},
            {0.352146, -0.278680, 0.609546, 0.614563},
            {0.342799, -0.228458, 0.598579, 0.603490},
            {0.337067, -0.184867, 0.587784, 0.592413},
            {0.327974, -0.121412, 0.577708, 0.581217},
            {0.324547, -0.082436, 0.567468, 0.570000},
            {0.321683, -0.039520, 0.557024, 0.558608},
            {0.319531, 0.000000, 0.546553, 0.547242},
            {0.999000, -1.271590, 0.999996, 0.999867},
            {0.999000, -1.271590, 0.999996, 0.999867},
            {0.999000, -1.271592, 0.999995, 0.999867},
            {0.997289, -1.271578, 0.999973, 0.999867},
            {0.995182, -1.271561, 0.999914, 0.999867},
            {0.992479, -1.271514, 0.999791, 0.999790},
            {0.989196, -1.271436, 0.999564, 0.999561},
            {0.985338, -1.271316, 0.999183, 0.999168},
            {0.980872, -1.271168, 0.998570, 0.997237},
            {0.975851, -1.270863, 0.997210, 0.995672},
            {0.970352, -1.270564, 0.992651, 0.994074},
            {0.964287, -1.270029, 0.990248, 0.991219},
            {0.957593, -1.269403, 0.987555, 0.987792},
            {0.950577, -1.268535, 0.982264, 0.983822},
            {0.943045, -1.267322, 0.977634, 0.978599},
            {0.935034, -1.266020, 0.970867, 0.972804},
            {0.926563, -1.264245, 0.963436, 0.965718},
            {0.917708, -1.262270, 0.955583, 0.958053},
            {0.908394, -1.259560, 0.947135, 0.949461},
            {0.898695, -1.256456, 0.937826, 0.940503},
            {0.888568, -1.252535, 0.927959, 0.931011},
            {0.878056, -1.247778, 0.917655, 0.921608},
            {0.867128, -1.242053, 0.908038, 0.912409},
            {0.855694, -1.235473, 0.899077, 0.903378},
            {0.843760, -1.227677, 0.890559, 0.894606},
            {0.831381, -1.218563, 0.882521, 0.886369},
            {0.818050, -1.208565, 0.874866, 0.878756},
            {0.804273, -1.197417, 0.867718, 0.871573},
            {0.789972, -1.185649, 0.860796, 0.864862},
            {0.775201, -1.171540, 0.854462, 0.858421},
            {0.759744, -1.156781, 0.848643, 0.852541},
            {0.743815, -1.140718, 0.842945, 0.846802},
            {0.727674, -1.123320, 0.837571, 0.841027},
            {0.710922, -1.105370, 0.832998, 0.835206},
            {0.693105, -1.085304, 0.828475, 0.829628},
            {0.675316, -1.063547, 0.823860, 0.823730},
            {0.657847, -1.041523, 0.818781, 0.817415},
            {0.639431, -1.019442, 0.813547, 0.810655},
            {0.621032, -0.995461, 0.807795, 0.803873},
            {0.603460, -0.969780, 0.801399, 0.796659},
            {0.585372, -0.943560, 0.794704, 0.788887},
            {0.567575, -0.915290, 0.787204, 0.780940},
            {0.550427, -0.886080, 0.779297, 0.772537},
            {0.532083, -0.856316, 0.772024, 0.763507},
            {0.514848, -0.823398, 0.764162, 0.754487},
            {0.497463, -0.789415, 0.755728, 0.745163},
            {0.482831, -0.757254, 0.746686, 0.735572},
            {0.462560, -0.720166, 0.737052, 0.725687},
            {0.449067, -0.684611, 0.726715, 0.715611},
            {0.434761, -0.647022, 0.715998, 0.705398},
            {0.422318, -0.607586, 0.705193, 0.695418},
            {0.407955, -0.567188, 0.694796, 0.685592},
            {0.394018, -0.522940, 0.683884, 0.676518},
            {0.379128, -0.475056, 0.672512, 0.667304},
            {0.371897, -0.429514, 0.660798, 0.657875},
            {0.363872, -0.384552, 0.648648, 0.648182},
            {0.354839, -0.337900, 0.636936, 0.638235},
            {0.349978, -0.277577, 0.625784, 0.628062},
            {0.342273, -0.233124, 0.614386, 0.617813},
            {0.332121, -0.167927, 0.602659, 0.607283},
            {0.328186, -0.128051, 0.591701, 0.596552},
            {0.324687, -0.084356, 0.580763, 0.585770},
            {0.321128, -0.040726, 0.570937, 0.575033},
            {0.319141, 0.000000, 0.561038, 0.564153},
            {0.999000, -1.296521, 0.999993, 0.999840},
            {0.999000, -1.296521, 0.999993, 0.999840},
            {0.999000, -1.296522, 0.999994, 0.999840},
            {0.997359, -1.296519, 0.999967, 0.999840},
            {0.995313, -1.296482, 0.999896, 0.999840},
            {0.992692, -1.296451, 0.999749, 0.999748},
            {0.989521, -1.296361, 0.999475, 0.999472},
            {0.985696, -1.296245, 0.999013, 0.998969},
            {0.981427, -1.296035, 0.998243, 0.996528},
            {0.976547, -1.295666, 0.994597, 0.995102},
            {0.971140, -1.295277, 0.991882, 0.992701},
            {0.965222, -1.294808, 0.989452, 0.989963},
            {0.958842, -1.293942, 0.983987, 0.985981},
            {0.951949, -1.292995, 0.980176, 0.981194},
            {0.944597, -1.291739, 0.973716, 0.975183},
            {0.936800, -1.290330, 0.965997, 0.968501},
            {0.928625, -1.288084, 0.957730, 0.960502},
            {0.919955, -1.285784, 0.949694, 0.952012},
            {0.910905, -1.282780, 0.940258, 0.942861},
            {0.901411, -1.278937, 0.930410, 0.933376},
            {0.891589, -1.274653, 0.919759, 0.923506},
            {0.881292, -1.269133, 0.909668, 0.914042},
            {0.870509, -1.262445, 0.900187, 0.904921},
            {0.859087, -1.254650, 0.891467, 0.896282},
            {0.847218, -1.246197, 0.883516, 0.887987},
            {0.834870, -1.236658, 0.875975, 0.880341},
            {0.821366, -1.225553, 0.869166, 0.873536},
            {0.807769, -1.213441, 0.862679, 0.867293},
            {0.793211, -1.200652, 0.856759, 0.861556},
            {0.778384, -1.185907, 0.851479, 0.856148},
            {0.762782, -1.170331, 0.846631, 0.850987},
            {0.746401, -1.153440, 0.841939, 0.846352},
            {0.730241, -1.135127, 0.837317, 0.841684},
            {0.713558, -1.115619, 0.833239, 0.836879},
            {0.695701, -1.095744, 0.829632, 0.832036},
            {0.678000, -1.074000, 0.825849, 0.827091},
            {0.659883, -1.050665, 0.821781, 0.821900},
            {0.641070, -1.028689, 0.817407, 0.816206},
            {0.622862, -1.003930, 0.812656, 0.810042},
            {0.604546, -0.977878, 0.807324, 0.803629},
            {0.586602, -0.950308, 0.801523, 0.796918},
            {0.568389, -0.922042, 0.795054, 0.789653},
            {0.550088, -0.892016, 0.788123, 0.781915},
            {0.532644, -0.862981, 0.780438, 0.774014},
            {0.515715, -0.828312, 0.773129, 0.765530},
            {0.496985, -0.793688, 0.765713, 0.756526},
            {0.477807, -0.759973, 0.757632, 0.747669},
            {0.462734, -0.726590, 0.749026, 0.738342},
            {0.448663, -0.690165, 0.739890, 0.728770},
            {0.433682, -0.651085, 0.730224, 0.718942},
            {0.419286, -0.610585, 0.720094, 0.708942},
            {0.405368, -0.570843, 0.709662, 0.698855},
            {0.388896, -0.519799, 0.698865, 0.688933},
            {0.378288, -0.480724, 0.688585, 0.679131},
            {0.369381, -0.437035, 0.677805, 0.669855},
            {0.360931, -0.386098, 0.666768, 0.660811},
            {0.353979, -0.343048, 0.655415, 0.651549},
            {0.334386, -0.276794, 0.643654, 0.642127},
            {0.333118, -0.232948, 0.631710, 0.632454},
            {0.331781, -0.174244, 0.620934, 0.622651},
            {0.327762, -0.131443, 0.609978, 0.612709},
            {0.323820, -0.084987, 0.598681, 0.602606},
            {0.321037, -0.043081, 0.587252, 0.592344},
            {0.319141, 0.000000, 0.576846, 0.581877},
            {0.999000, -1.321453, 0.999993, 0.999806},
            {0.999000, -1.321453, 0.999993, 0.999806},
            {0.999000, -1.321449, 0.999992, 0.999806},
            {0.997430, -1.321434, 0.999960, 0.999806},
            {0.995443, -1.321409, 0.999875, 0.999806},
            {0.992880, -1.321387, 0.999692, 0.999691},
            {0.989787, -1.321278, 0.999357, 0.999350},
            {0.986104, -1.321104, 0.998786, 0.998431},
            {0.981901, -1.320871, 0.997712, 0.995873},
            {0.977241, -1.320584, 0.992774, 0.994456},
            {0.972016, -1.319973, 0.990291, 0.991327},
            {0.966264, -1.319349, 0.987357, 0.987798},
            {0.960051, -1.318463, 0.981662, 0.983232},
            {0.953371, -1.317378, 0.975849, 0.977500},
            {0.946221, -1.316043, 0.968955, 0.970828},
            {0.938674, -1.314288, 0.959823, 0.962815},
            {0.930611, -1.311809, 0.952019, 0.954228},
            {0.922280, -1.309055, 0.942438, 0.944752},
            {0.913570, -1.305318, 0.932231, 0.935126},
            {0.904216, -1.301095, 0.921184, 0.925179},
            {0.894508, -1.295668, 0.911111, 0.915102},
            {0.884345, -1.289558, 0.900815, 0.905763},
            {0.873568, -1.282233, 0.891802, 0.897087},
            {0.862451, -1.273661, 0.883821, 0.888933},
            {0.850803, -1.264065, 0.876355, 0.881452},
            {0.838062, -1.253422, 0.869809, 0.874687},
            {0.825022, -1.241643, 0.863724, 0.868716},
            {0.810751, -1.228633, 0.858304, 0.863585},
            {0.796091, -1.214213, 0.853311, 0.858931},
            {0.781129, -1.198862, 0.849204, 0.854662},
            {0.765599, -1.182691, 0.845440, 0.850569},
            {0.749157, -1.165352, 0.841690, 0.846719},
            {0.732553, -1.145945, 0.838100, 0.843151},
            {0.714915, -1.126586, 0.834664, 0.839426},
            {0.697575, -1.104814, 0.831578, 0.835588},
            {0.679503, -1.081862, 0.828566, 0.831443},
            {0.662054, -1.059172, 0.825448, 0.827004},
            {0.642396, -1.036452, 0.821985, 0.822395},
            {0.624092, -1.011821, 0.818004, 0.817254},
            {0.605450, -0.985356, 0.813657, 0.811630},
            {0.587101, -0.956362, 0.808817, 0.805464},
            {0.569494, -0.927644, 0.803298, 0.799124},
            {0.551151, -0.898303, 0.797411, 0.792382},
            {0.531903, -0.867973, 0.790791, 0.785091},
            {0.515580, -0.832847, 0.783605, 0.777315},
            {0.492592, -0.797475, 0.775958, 0.769360},
            {0.478468, -0.765443, 0.768728, 0.760908},
            {0.462749, -0.730628, 0.761159, 0.751957},
            {0.447176, -0.694163, 0.753163, 0.743128},
            {0.433748, -0.656935, 0.744591, 0.733917},
            {0.418728, -0.616268, 0.735541, 0.724340},
            {0.398642, -0.564838, 0.725952, 0.714712},
            {0.389047, -0.526291, 0.716098, 0.704721},
            {0.377878, -0.483507, 0.705901, 0.694835},
            {0.368558, -0.440922, 0.695237, 0.684862},
            {0.358384, -0.394717, 0.684920, 0.675099},
            {0.349718, -0.348693, 0.674542, 0.665570},
            {0.335875, -0.288694, 0.663930, 0.656644},
            {0.330564, -0.242657, 0.652974, 0.647651},
            {0.331185, -0.174314, 0.641695, 0.638581},
            {0.326589, -0.131346, 0.630117, 0.629337},
            {0.323330, -0.086758, 0.618944, 0.619926},
            {0.320310, -0.047896, 0.608577, 0.610358},
            {0.319922, 0.000000, 0.597928, 0.600707},
            {0.999000, -1.346386, 0.999991, 0.999759},
            {0.999000, -1.346386, 0.999991, 0.999759},
            {0.999000, -1.346386, 0.999991, 0.999759},
            {0.997516, -1.346367, 0.999951, 0.999759},
            {0.995591, -1.346345, 0.999843, 0.999759},
            {0.993098, -1.346291, 0.999616, 0.999613},
            {0.990082, -1.346187, 0.999196, 0.999186},
            {0.986532, -1.345989, 0.998465, 0.997025},
            {0.982478, -1.345690, 0.995698, 0.995317},
            {0.977894, -1.345315, 0.992033, 0.992849},
            {0.972797, -1.344749, 0.989324, 0.989760},
            {0.967299, -1.343946, 0.983514, 0.985270},
            {0.961251, -1.342891, 0.978767, 0.979807},
            {0.954739, -1.341622, 0.971416, 0.973049},
            {0.947967, -1.339802, 0.962487, 0.965228},
            {0.940732, -1.337816, 0.953815, 0.956248},
            {0.932804, -1.335011, 0.944060, 0.946394},
            {0.924740, -1.331767, 0.933480, 0.936324},
            {0.916088, -1.327438, 0.922221, 0.926124},
            {0.907019, -1.322509, 0.911729, 0.915808},
            {0.897548, -1.316180, 0.901409, 0.905942},
            {0.887591, -1.309290, 0.891531, 0.897060},
            {0.877050, -1.301184, 0.883455, 0.889001},
            {0.865744, -1.291684, 0.876009, 0.881755},
            {0.853921, -1.280409, 0.869670, 0.875351},
            {0.841073, -1.268713, 0.863974, 0.869688},
            {0.828062, -1.256063, 0.859068, 0.864736},
            {0.813754, -1.242387, 0.854752, 0.860745},
            {0.799054, -1.227607, 0.850967, 0.857306},
            {0.783702, -1.210686, 0.847943, 0.854190},
            {0.767912, -1.193551, 0.845221, 0.851261},
            {0.751369, -1.175871, 0.842464, 0.848484},
            {0.734916, -1.156212, 0.839896, 0.845642},
            {0.717235, -1.135497, 0.837459, 0.842948},
            {0.699179, -1.113244, 0.834810, 0.840060},
            {0.681144, -1.090613, 0.832213, 0.836901},
            {0.663287, -1.066445, 0.829874, 0.833379},
            {0.643654, -1.043074, 0.827175, 0.829393},
            {0.625029, -1.018555, 0.824115, 0.825103},
            {0.606245, -0.990919, 0.820546, 0.820431},
            {0.587932, -0.961910, 0.816584, 0.815288},
            {0.569996, -0.932899, 0.812055, 0.809574},
            {0.551153, -0.903041, 0.806922, 0.803326},
            {0.531744, -0.872117, 0.801309, 0.796949},
            {0.516134, -0.840119, 0.795196, 0.790174},
            {0.495312, -0.803509, 0.788498, 0.782873},
            {0.478995, -0.768759, 0.781349, 0.775048},
            {0.462361, -0.735650, 0.773907, 0.767139},
            {0.446784, -0.698369, 0.766420, 0.758772},
            {0.433066, -0.659304, 0.758855, 0.750019},
            {0.409356, -0.610178, 0.750906, 0.741120},
            {0.399835, -0.574428, 0.742506, 0.732127},
            {0.388676, -0.531868, 0.733661, 0.722743},
            {0.376777, -0.488466, 0.724386, 0.713225},
            {0.366895, -0.443282, 0.714934, 0.703637},
            {0.357267, -0.398461, 0.705055, 0.693768},
            {0.339224, -0.343827, 0.694821, 0.684016},
            {0.333019, -0.297515, 0.684233, 0.674277},
            {0.329408, -0.244445, 0.674276, 0.664703},
            {0.324270, -0.199500, 0.664262, 0.655328},
            {0.325622, -0.131768, 0.653978, 0.646550},
            {0.322598, -0.091619, 0.643426, 0.637812},
            {0.315823, 0.000000, 0.632577, 0.629036},
            {0.314844, 0.000000, 0.621521, 0.620129},
            {0.999000, -1.371320, 0.999988, 0.999692},
            {0.999000, -1.371320, 0.999988, 0.999692},
            {0.999000, -1.371317, 0.999987, 0.999692},
            {0.997592, -1.371296, 0.999937, 0.999692},
            {0.995722, -1.371278, 0.999800, 0.999692},
            {0.993317, -1.371200, 0.999511, 0.999508},
            {0.990398, -1.371069, 0.998968, 0.998917},
            {0.986989, -1.370839, 0.997959, 0.996236},
            {0.983059, -1.370498, 0.993124, 0.994617},
            {0.978600, -1.370049, 0.990205, 0.991176},
            {0.973692, -1.369321, 0.985994, 0.987089},
            {0.968338, -1.368551, 0.980667, 0.981881},
            {0.962508, -1.367315, 0.973607, 0.974966},
            {0.956270, -1.365744, 0.964472, 0.967156},
            {0.949606, -1.363714, 0.955134, 0.957914},
            {0.942489, -1.361285, 0.945143, 0.947585},
            {0.935126, -1.357885, 0.934111, 0.936938},
            {0.927125, -1.353969, 0.922465, 0.926318},
            {0.918750, -1.348798, 0.911519, 0.915661},
            {0.909889, -1.343123, 0.901047, 0.905567},
            {0.900622, -1.335729, 0.890868, 0.896223},
            {0.890635, -1.327943, 0.882299, 0.888166},
            {0.879937, -1.318592, 0.874933, 0.881117},
            {0.868879, -1.307842, 0.868763, 0.875079},
            {0.856800, -1.295900, 0.863466, 0.869981},
            {0.843899, -1.283463, 0.858993, 0.865675},
            {0.830540, -1.269208, 0.855372, 0.862091},
            {0.816093, -1.254277, 0.852291, 0.859183},
            {0.801355, -1.238882, 0.849883, 0.856981},
            {0.785895, -1.221455, 0.847904, 0.855065},
            {0.769947, -1.203366, 0.846189, 0.853273},
            {0.753238, -1.184987, 0.844475, 0.851572},
            {0.735505, -1.164381, 0.842898, 0.849782},
            {0.718437, -1.143429, 0.841335, 0.847768},
            {0.700443, -1.120522, 0.839488, 0.845668},
            {0.682739, -1.096956, 0.837488, 0.843345},
            {0.664500, -1.073117, 0.835243, 0.840703},
            {0.644645, -1.049322, 0.833172, 0.837646},
            {0.625827, -1.024067, 0.830941, 0.834095},
            {0.607131, -0.997497, 0.828092, 0.830030},
            {0.588519, -0.968407, 0.824818, 0.825631},
            {0.570379, -0.938751, 0.821138, 0.820873},
            {0.551919, -0.908469, 0.816933, 0.815619},
            {0.531873, -0.875933, 0.812282, 0.809856},
            {0.511323, -0.843641, 0.807105, 0.803578},
            {0.495728, -0.807766, 0.801410, 0.797096},
            {0.478741, -0.772848, 0.795186, 0.790359},
            {0.462088, -0.737735, 0.788522, 0.783152},
            {0.446298, -0.702292, 0.781432, 0.775507},
            {0.432939, -0.662251, 0.774154, 0.767504},
            {0.412916, -0.618868, 0.766387, 0.759411},
            {0.399907, -0.578709, 0.758930, 0.750982},
            {0.386510, -0.535334, 0.751179, 0.742208},
            {0.375356, -0.489848, 0.743065, 0.733382},
            {0.366374, -0.445596, 0.734591, 0.724445},
            {0.348698, -0.397307, 0.725842, 0.715190},
            {0.338338, -0.349281, 0.716910, 0.705827},
            {0.331227, -0.300565, 0.707686, 0.696440},
            {0.325163, -0.254001, 0.698142, 0.686773},
            {0.320444, -0.205976, 0.688290, 0.677242},
            {0.325444, -0.132732, 0.678163, 0.667735},
            {0.317879, -0.066596, 0.668278, 0.658471},
            {0.315432, 0.000000, 0.658754, 0.649236},
            {0.314062, 0.000000, 0.648986, 0.640305},
            {0.999000, -1.396247, 0.999985, 0.999595},
            {0.999000, -1.396247, 0.999985, 0.999595},
            {0.999000, -1.396247, 0.999984, 0.999595},
            {0.997671, -1.396236, 0.999917, 0.999595},
            {0.995864, -1.396182, 0.999737, 0.999595},
            {0.993548, -1.396070, 0.999354, 0.999350},
            {0.990700, -1.395946, 0.998627, 0.997576},
            {0.987398, -1.395649, 0.996239, 0.995477},
            {0.983630, -1.395288, 0.991829, 0.992614},
            {0.979323, -1.394769, 0.988651, 0.988817},
            {0.974631, -1.393875, 0.981817, 0.983601},
            {0.969414, -1.392802, 0.975061, 0.976880},
            {0.963875, -1.391412, 0.966509, 0.968694},
            {0.957869, -1.389597, 0.955994, 0.959092},
            {0.951401, -1.387395, 0.945630, 0.948297},
            {0.944656, -1.383933, 0.933988, 0.936831},
            {0.937455, -1.380001, 0.921672, 0.925592},
            {0.929690, -1.375027, 0.910360, 0.914494},
            {0.921401, -1.369217, 0.899474, 0.904159},
            {0.912513, -1.362380, 0.889186, 0.894643},
            {0.903368, -1.354256, 0.880185, 0.886417},
            {0.893520, -1.344734, 0.873091, 0.879620},
            {0.882825, -1.334000, 0.867203, 0.874023},
            {0.871415, -1.322615, 0.862459, 0.869533},
            {0.859233, -1.309431, 0.858631, 0.865967},
            {0.846276, -1.295708, 0.855584, 0.863237},
            {0.832438, -1.281493, 0.853193, 0.861113},
            {0.818308, -1.265408, 0.851521, 0.859527},
            {0.803091, -1.249063, 0.850404, 0.858367},
            {0.787540, -1.230954, 0.849455, 0.857594},
            {0.771422, -1.212537, 0.848605, 0.856882},
            {0.754603, -1.193679, 0.847936, 0.856172},
            {0.736688, -1.172387, 0.847240, 0.855316},
            {0.719288, -1.150667, 0.846383, 0.854197},
            {0.701674, -1.127143, 0.845341, 0.852818},
            {0.683414, -1.103077, 0.844117, 0.851062},
            {0.664400, -1.079114, 0.842543, 0.849046},
            {0.645797, -1.054783, 0.840556, 0.846747},
            {0.626508, -1.028620, 0.838359, 0.844043},
            {0.607797, -1.001129, 0.836284, 0.840842},
            {0.589431, -0.974003, 0.833765, 0.837164},
            {0.570314, -0.941372, 0.830845, 0.832985},
            {0.552029, -0.911623, 0.827429, 0.828344},
            {0.528027, -0.878599, 0.823521, 0.823544},
            {0.512357, -0.847295, 0.819197, 0.818276},
            {0.496204, -0.810426, 0.814431, 0.812543},
            {0.478684, -0.775198, 0.809236, 0.806374},
            {0.461312, -0.740852, 0.803555, 0.799838},
            {0.446112, -0.705073, 0.797477, 0.793170},
            {0.425257, -0.663402, 0.790970, 0.786247},
            {0.413297, -0.623832, 0.784082, 0.778956},
            {0.398752, -0.581200, 0.777031, 0.771297},
            {0.385129, -0.538978, 0.769735, 0.763278},
            {0.375135, -0.494437, 0.762070, 0.755252},
            {0.357587, -0.447204, 0.754556, 0.746984},
            {0.346693, -0.402270, 0.746999, 0.738445},
            {0.336898, -0.352150, 0.739152, 0.729688},
            {0.330539, -0.305076, 0.731014, 0.721045},
            {0.313486, -0.246876, 0.722656, 0.712189},
            {0.310602, -0.204784, 0.714162, 0.703099},
            {0.316563, 0.000000, 0.705400, 0.694045},
            {0.315771, 0.000000, 0.696399, 0.684930},
            {0.290041, 0.000000, 0.687146, 0.675601},
            {0.288281, 0.000000, 0.677666, 0.666480},
            {0.999000, -1.421182, 0.999978, 0.999439},
            {0.999000, -1.421182, 0.999978, 0.999439},
            {0.999000, -1.421180, 0.999979, 0.999439},
            {0.997751, -1.421154, 0.999887, 0.999439},
            {0.996015, -1.421081, 0.999640, 0.999439},
            {0.993757, -1.420976, 0.999110, 0.999093},
            {0.991041, -1.420760, 0.998044, 0.996310},
            {0.987872, -1.420359, 0.992722, 0.994405},
            {0.984221, -1.419979, 0.989787, 0.990527},
            {0.980046, -1.419277, 0.983433, 0.985186},
            {0.975503, -1.418303, 0.976813, 0.978518},
            {0.970598, -1.416875, 0.967984, 0.969748},
            {0.965203, -1.415114, 0.956348, 0.959597},
            {0.959494, -1.412732, 0.945331, 0.948104},
            {0.953263, -1.409984, 0.932794, 0.935724},
            {0.946599, -1.406193, 0.919780, 0.923704},
            {0.939559, -1.401217, 0.907685, 0.912023},
            {0.932039, -1.395239, 0.896277, 0.901356},
            {0.923899, -1.388194, 0.886157, 0.891850},
            {0.915168, -1.379914, 0.877277, 0.883847},
            {0.905870, -1.370850, 0.870296, 0.877279},
            {0.895677, -1.360213, 0.864937, 0.872289},
            {0.885361, -1.348225, 0.860831, 0.868583},
            {0.873552, -1.334828, 0.857800, 0.865913},
            {0.861139, -1.321322, 0.855569, 0.864098},
            {0.848049, -1.307130, 0.854103, 0.862993},
            {0.834270, -1.291372, 0.853194, 0.862356},
            {0.819373, -1.274696, 0.852854, 0.862125},
            {0.804474, -1.257118, 0.852790, 0.862107},
            {0.788516, -1.238479, 0.852770, 0.862169},
            {0.772066, -1.220093, 0.852874, 0.862359},
            {0.755059, -1.199130, 0.853051, 0.862490},
            {0.737732, -1.178565, 0.852984, 0.862430},
            {0.719888, -1.155648, 0.852848, 0.862063},
            {0.702213, -1.132780, 0.852417, 0.861431},
            {0.683810, -1.108184, 0.851692, 0.860386},
            {0.664864, -1.083705, 0.850785, 0.858950},
            {0.645537, -1.059584, 0.849489, 0.857090},
            {0.626724, -1.033360, 0.847881, 0.854848},
            {0.608360, -1.006701, 0.845831, 0.852381},
            {0.589119, -0.977834, 0.843346, 0.849503},
            {0.570667, -0.947553, 0.840977, 0.846167},
            {0.544860, -0.914353, 0.838266, 0.842399},
            {0.529903, -0.883279, 0.835147, 0.838194},
            {0.512757, -0.850389, 0.831586, 0.833566},
            {0.496131, -0.816997, 0.827642, 0.828579},
            {0.478212, -0.779664, 0.823303, 0.823464},
            {0.461001, -0.742767, 0.818622, 0.817951},
            {0.440355, -0.703785, 0.813605, 0.812079},
            {0.425104, -0.667528, 0.808247, 0.805873},
            {0.412935, -0.627591, 0.802558, 0.799320},
            {0.397441, -0.583299, 0.796520, 0.792533},
            {0.375351, -0.535670, 0.790155, 0.785715},
            {0.365951, -0.498812, 0.783488, 0.778636},
            {0.355574, -0.453146, 0.776690, 0.771260},
            {0.345313, -0.405531, 0.769691, 0.763618},
            {0.335706, -0.355387, 0.762405, 0.755719},
            {0.320400, -0.296833, 0.754860, 0.747815},
            {0.313909, -0.257073, 0.747427, 0.739825},
            {0.310222, -0.212524, 0.740083, 0.731602},
            {0.304945, -0.170450, 0.732504, 0.723212},
            {0.282180, 0.000000, 0.724717, 0.714846},
            {0.280276, 0.000000, 0.716839, 0.706465},
            {0.278125, 0.000000, 0.708807, 0.697933},
            {0.999000, -1.446110, 0.999968, 0.999179},
            {0.999000, -1.446110, 0.999968, 0.999179},
            {0.999000, -1.446107, 0.999967, 0.999179},
            {0.997830, -1.446077, 0.999835, 0.999179},
            {0.996143, -1.445986, 0.999478, 0.999179},
            {0.993982, -1.445840, 0.998695, 0.997943},
            {0.991369, -1.445621, 0.995235, 0.995219},
            {0.988292, -1.445187, 0.990388, 0.991760},
            {0.984833, -1.444520, 0.985001, 0.986663},
            {0.980875, -1.443713, 0.978285, 0.979592},
            {0.976547, -1.442447, 0.968576, 0.970218},
            {0.971754, -1.440871, 0.955984, 0.959155},
            {0.966587, -1.438532, 0.943707, 0.946575},
            {0.961151, -1.435736, 0.929952, 0.933047},
            {0.955185, -1.431870, 0.915892, 0.920022},
            {0.948702, -1.427036, 0.903236, 0.907749},
            {0.941769, -1.421149, 0.891455, 0.896801},
            {0.934439, -1.413859, 0.881539, 0.887506},
            {0.926321, -1.405529, 0.873151, 0.880077},
            {0.917514, -1.395689, 0.866569, 0.874322},
            {0.907986, -1.385183, 0.862186, 0.870126},
            {0.897654, -1.373311, 0.859086, 0.867481},
            {0.886872, -1.360021, 0.857015, 0.865949},
            {0.875265, -1.346167, 0.855831, 0.865293},
            {0.862584, -1.331546, 0.855379, 0.865287},
            {0.848996, -1.315788, 0.855345, 0.865746},
            {0.835184, -1.299572, 0.855978, 0.866502},
            {0.820361, -1.282494, 0.856661, 0.867439},
            {0.805091, -1.263937, 0.857473, 0.868442},
            {0.789112, -1.244720, 0.858286, 0.869382},
            {0.772152, -1.225216, 0.859208, 0.870161},
            {0.755277, -1.204827, 0.859837, 0.870782},
            {0.737896, -1.183291, 0.860324, 0.871303},
            {0.719768, -1.160510, 0.860694, 0.871511},
            {0.702408, -1.137064, 0.860780, 0.871427},
            {0.684235, -1.112286, 0.860656, 0.870978},
            {0.665016, -1.086997, 0.860116, 0.870136},
            {0.646039, -1.061805, 0.859303, 0.868893},
            {0.626374, -1.036717, 0.858160, 0.867248},
            {0.607368, -1.010233, 0.856699, 0.865209},
            {0.589003, -0.981299, 0.854822, 0.862775},
            {0.562550, -0.950850, 0.852600, 0.859944},
            {0.548602, -0.916563, 0.850005, 0.857004},
            {0.531177, -0.886356, 0.847117, 0.853671},
            {0.513389, -0.853913, 0.844248, 0.849984},
            {0.495421, -0.822634, 0.841187, 0.845927},
            {0.477800, -0.782681, 0.837786, 0.841518},
            {0.455089, -0.742068, 0.834057, 0.836774},
            {0.441422, -0.708977, 0.830002, 0.831750},
            {0.425554, -0.672369, 0.825670, 0.826407},
            {0.410943, -0.631198, 0.821062, 0.821001},
            {0.385946, -0.585065, 0.816164, 0.815333},
            {0.377256, -0.543766, 0.810989, 0.809412},
            {0.365407, -0.501776, 0.805548, 0.803238},
            {0.354878, -0.457075, 0.799846, 0.796802},
            {0.344933, -0.408418, 0.793904, 0.790204},
            {0.326357, -0.351310, 0.787727, 0.783457},
            {0.318100, -0.311514, 0.781348, 0.776713},
            {0.313166, -0.262941, 0.774853, 0.769749},
            {0.309152, -0.216214, 0.768244, 0.762596},
            {0.284737, -0.139670, 0.761433, 0.755239},
            {0.280529, 0.000000, 0.754418, 0.747690},
            {0.278323, 0.000000, 0.747224, 0.740127},
            {0.276172, 0.000000, 0.740018, 0.732595},
            {0.999000, -1.471040, 0.999950, 0.998113},
            {0.999000, -1.471040, 0.999950, 0.998113},
            {0.999000, -1.471040, 0.999948, 0.998113},
            {0.997914, -1.470985, 0.999743, 0.998113},
            {0.996299, -1.470865, 0.999176, 0.998113},
            {0.994235, -1.470670, 0.997803, 0.996124},
            {0.991707, -1.470367, 0.992047, 0.992844},
            {0.988763, -1.469756, 0.987039, 0.987757},
            {0.985456, -1.469020, 0.978850, 0.980062},
            {0.981672, -1.467921, 0.967953, 0.969642},
            {0.977569, -1.466360, 0.954183, 0.957087},
            {0.973109, -1.464133, 0.939451, 0.942736},
            {0.968234, -1.460890, 0.924198, 0.927747},
            {0.962900, -1.457211, 0.909311, 0.913622},
            {0.957007, -1.452084, 0.895819, 0.900889},
            {0.950720, -1.446047, 0.884335, 0.890115},
            {0.943788, -1.438741, 0.874909, 0.881584},
            {0.936157, -1.429812, 0.867586, 0.875288},
            {0.928024, -1.420044, 0.862538, 0.870926},
            {0.918889, -1.409085, 0.859484, 0.868307},
            {0.908897, -1.397004, 0.857747, 0.867033},
            {0.898571, -1.383184, 0.857048, 0.866972},
            {0.887781, -1.369477, 0.857130, 0.867692},
            {0.875469, -1.354844, 0.857811, 0.868950},
            {0.862689, -1.339054, 0.858860, 0.870549},
            {0.849220, -1.322864, 0.860310, 0.872320},
            {0.835249, -1.306004, 0.861797, 0.874144},
            {0.820680, -1.288632, 0.863356, 0.875947},
            {0.804753, -1.269298, 0.864808, 0.877674},
            {0.788041, -1.249453, 0.866235, 0.879192},
            {0.771730, -1.229812, 0.867473, 0.880478},
            {0.754745, -1.208635, 0.868620, 0.881539},
            {0.737578, -1.186112, 0.869466, 0.882307},
            {0.719435, -1.164335, 0.870074, 0.882739},
            {0.702050, -1.140005, 0.870457, 0.882902},
            {0.683974, -1.114559, 0.870589, 0.882847},
            {0.664337, -1.090016, 0.870385, 0.882461},
            {0.645297, -1.064015, 0.869906, 0.881725},
            {0.626246, -1.039272, 0.869135, 0.880636},
            {0.608092, -1.012672, 0.868149, 0.879197},
            {0.590205, -0.983917, 0.866867, 0.877421},
            {0.566909, -0.955148, 0.865321, 0.875296},
            {0.549002, -0.918705, 0.863459, 0.872849},
            {0.531107, -0.888543, 0.861289, 0.870076},
            {0.513169, -0.857039, 0.858861, 0.866988},
            {0.494978, -0.824334, 0.856157, 0.863637},
            {0.471360, -0.786330, 0.853185, 0.860159},
            {0.457676, -0.746172, 0.849925, 0.856475},
            {0.442197, -0.712755, 0.846572, 0.852525},
            {0.425385, -0.675899, 0.843196, 0.848327},
            {0.398956, -0.632853, 0.839593, 0.843883},
            {0.388247, -0.594569, 0.835772, 0.839198},
            {0.377298, -0.552146, 0.831749, 0.834322},
            {0.365377, -0.509436, 0.827500, 0.829221},
            {0.354864, -0.463958, 0.823054, 0.823907},
            {0.333706, -0.408159, 0.818400, 0.818460},
            {0.326601, -0.360199, 0.813558, 0.812972},
            {0.317404, -0.316583, 0.808529, 0.807315},
            {0.312804, -0.270856, 0.803316, 0.801473},
            {0.288902, -0.198139, 0.797940, 0.795458},
            {0.283969, -0.150611, 0.792391, 0.789275},
            {0.277591, 0.000000, 0.786678, 0.783025},
            {0.275979, 0.000000, 0.780819, 0.776615},
            {0.274219, 0.000000, 0.774805, 0.770223},
            {0.999000, -1.495959, 0.999910, 0.995737},
            {0.999000, -1.495959, 0.999910, 0.995737},
            {0.999000, -1.495959, 0.999910, 0.995737},
            {0.997990, -1.495886, 0.999539, 0.995737},
            {0.996444, -1.495717, 0.998492, 0.995737},
            {0.994434, -1.495425, 0.992621, 0.994123},
            {0.992042, -1.494976, 0.987766, 0.988168},
            {0.989233, -1.494385, 0.977901, 0.979344},
            {0.986071, -1.493197, 0.964866, 0.967003},
            {0.982534, -1.491542, 0.948515, 0.951763},
            {0.978651, -1.489452, 0.931414, 0.934724},
            {0.974317, -1.486230, 0.913588, 0.917948},
            {0.969621, -1.482379, 0.897991, 0.902918},
            {0.964245, -1.477028, 0.884671, 0.890432},
            {0.958407, -1.470286, 0.874198, 0.880902},
            {0.951849, -1.462357, 0.866683, 0.874401},
            {0.945079, -1.453147, 0.861542, 0.870394},
            {0.936973, -1.442490, 0.858951, 0.868503},
            {0.928423, -1.431187, 0.858043, 0.868209},
            {0.919125, -1.418609, 0.858307, 0.869062},
            {0.909245, -1.405338, 0.859374, 0.870725},
            {0.898669, -1.391626, 0.860851, 0.873006},
            {0.887447, -1.376025, 0.862800, 0.875558},
            {0.875220, -1.360591, 0.864977, 0.878230},
            {0.861937, -1.344128, 0.867123, 0.880892},
            {0.848286, -1.327417, 0.869207, 0.883445},
            {0.834257, -1.309885, 0.871324, 0.885832},
            {0.818954, -1.291879, 0.873298, 0.888059},
            {0.803253, -1.272361, 0.875060, 0.890058},
            {0.787695, -1.251811, 0.876621, 0.891782},
            {0.770479, -1.231761, 0.878003, 0.893247},
            {0.753668, -1.209861, 0.879152, 0.894460},
            {0.736901, -1.188281, 0.880040, 0.895397},
            {0.719111, -1.165940, 0.880731, 0.896023},
            {0.700848, -1.141172, 0.881271, 0.896380},
            {0.682860, -1.116233, 0.881596, 0.896434},
            {0.663776, -1.091549, 0.881708, 0.896198},
            {0.644944, -1.064697, 0.881562, 0.895673},
            {0.626358, -1.040953, 0.881180, 0.894865},
            {0.608943, -1.015294, 0.880615, 0.893908},
            {0.585501, -0.987585, 0.879797, 0.892700},
            {0.567607, -0.956551, 0.878742, 0.891224},
            {0.549213, -0.924139, 0.877455, 0.889501},
            {0.530152, -0.891260, 0.875932, 0.887539},
            {0.512058, -0.859977, 0.874212, 0.885336},
            {0.488616, -0.825742, 0.872294, 0.882903},
            {0.473348, -0.791216, 0.870168, 0.880244},
            {0.458471, -0.751819, 0.867830, 0.877373},
            {0.442802, -0.715833, 0.865296, 0.874296},
            {0.415091, -0.674910, 0.862564, 0.871019},
            {0.400160, -0.640294, 0.859649, 0.867549},
            {0.388754, -0.603211, 0.856549, 0.863932},
            {0.375072, -0.559734, 0.853280, 0.860153},
            {0.353478, -0.508646, 0.849837, 0.856355},
            {0.341307, -0.463300, 0.846238, 0.852395},
            {0.333558, -0.417959, 0.842726, 0.848277},
            {0.322491, -0.374832, 0.839152, 0.844006},
            {0.316960, -0.327660, 0.835444, 0.839587},
            {0.298970, -0.269387, 0.831600, 0.835045},
            {0.287139, -0.208021, 0.827627, 0.830378},
            {0.281739, -0.157196, 0.823534, 0.825579},
            {0.277495, -0.108804, 0.819316, 0.820649},
            {0.275198, 0.000000, 0.814977, 0.815592},
            {0.267578, 0.000000, 0.810521, 0.810432},
            {0.999000, -1.520892, 0.999799, 0.991627},
            {0.999000, -1.520892, 0.999799, 0.991627},
            {0.999000, -1.520878, 0.999795, 0.991627},
            {0.997993, -1.520764, 0.998945, 0.991627},
            {0.996475, -1.520547, 0.993098, 0.991627},
            {0.994505, -1.520132, 0.986154, 0.987290},
            {0.992185, -1.519464, 0.973825, 0.975397},
            {0.989504, -1.518478, 0.955429, 0.958508},
            {0.986474, -1.516849, 0.935032, 0.938352},
            {0.983142, -1.514478, 0.913351, 0.917733},
            {0.979357, -1.510971, 0.894703, 0.899800},
            {0.975017, -1.506092, 0.879726, 0.885878},
            {0.970165, -1.500017, 0.869186, 0.876516},
            {0.964739, -1.492694, 0.862635, 0.871200},
            {0.958680, -1.483902, 0.859330, 0.869099},
            {0.951850, -1.474231, 0.858729, 0.869317},
            {0.944612, -1.462816, 0.859638, 0.871112},
            {0.936355, -1.451337, 0.861585, 0.873870},
            {0.927730, -1.438611, 0.864090, 0.877160},
            {0.917946, -1.424287, 0.866884, 0.880682},
            {0.907919, -1.410406, 0.869719, 0.884229},
            {0.897254, -1.395649, 0.872615, 0.887737},
            {0.885309, -1.379949, 0.875428, 0.891076},
            {0.873002, -1.363727, 0.878000, 0.894161},
            {0.860371, -1.346795, 0.880389, 0.896981},
            {0.846189, -1.329342, 0.882571, 0.899543},
            {0.831654, -1.311465, 0.884478, 0.901847},
            {0.816960, -1.293519, 0.886205, 0.903882},
            {0.801290, -1.274145, 0.887816, 0.905672},
            {0.785150, -1.253385, 0.889273, 0.907188},
            {0.768998, -1.232785, 0.890510, 0.908451},
            {0.752397, -1.211693, 0.891556, 0.909480},
            {0.735037, -1.189709, 0.892467, 0.910289},
            {0.718070, -1.167889, 0.893177, 0.910878},
            {0.700001, -1.143083, 0.893710, 0.911259},
            {0.682540, -1.116947, 0.894060, 0.911430},
            {0.662700, -1.093455, 0.894247, 0.911396},
            {0.644049, -1.066570, 0.894302, 0.911154},
            {0.619526, -1.044535, 0.894189, 0.910712},
            {0.603856, -1.017707, 0.893905, 0.910081},
            {0.586069, -0.990840, 0.893458, 0.909266},
            {0.567814, -0.957883, 0.892851, 0.908264},
            {0.549561, -0.925090, 0.892082, 0.907094},
            {0.530077, -0.892469, 0.891165, 0.905752},
            {0.507261, -0.860550, 0.890091, 0.904244},
            {0.490305, -0.829791, 0.888876, 0.902577},
            {0.474536, -0.793532, 0.887512, 0.900799},
            {0.456864, -0.753375, 0.886016, 0.898931},
            {0.430365, -0.713569, 0.884390, 0.896923},
            {0.420754, -0.685591, 0.882639, 0.894782},
            {0.400134, -0.645615, 0.880761, 0.892513},
            {0.388107, -0.611645, 0.878756, 0.890117},
            {0.366831, -0.563738, 0.876640, 0.887600},
            {0.356515, -0.526954, 0.874408, 0.884968},
            {0.341286, -0.472941, 0.872064, 0.882222},
            {0.328656, -0.432217, 0.869615, 0.879369},
            {0.312352, -0.366893, 0.867065, 0.876408},
            {0.308681, -0.330987, 0.864414, 0.873345},
            {0.302482, -0.294009, 0.861665, 0.870183},
            {0.284601, -0.214769, 0.858825, 0.866925},
            {0.271838, -0.117640, 0.855898, 0.863575},
            {0.269728, -0.081975, 0.852883, 0.860160},
            {0.266706, 0.000000, 0.849782, 0.856672},
            {0.266016, 0.000000, 0.846598, 0.853098},
            {0.999000, -1.545799, 0.999183, 0.979942},
            {0.999000, -1.545799, 0.999183, 0.979942},
            {0.999000, -1.545808, 0.999172, 0.979942},
            {0.997874, -1.545658, 0.992052, 0.979942},
            {0.996232, -1.545355, 0.978872, 0.979942},
            {0.994240, -1.544645, 0.954269, 0.969716},
            {0.991802, -1.543481, 0.924582, 0.946057},
            {0.988906, -1.541594, 0.896509, 0.919578},
            {0.985585, -1.538247, 0.876200, 0.897061},
            {0.981685, -1.533897, 0.864558, 0.881240},
            {0.977098, -1.528419, 0.859646, 0.872544},
            {0.972188, -1.521226, 0.859498, 0.869415},
            {0.966835, -1.513453, 0.862065, 0.870091},
            {0.961041, -1.503939, 0.865778, 0.873049},
            {0.955159, -1.493293, 0.869866, 0.877196},
            {0.948253, -1.481726, 0.874118, 0.881826},
            {0.940938, -1.468990, 0.878117, 0.886523},
            {0.932758, -1.455619, 0.881750, 0.891022},
            {0.923766, -1.441666, 0.884998, 0.895225},
            {0.914425, -1.426987, 0.887837, 0.899054},
            {0.904600, -1.412200, 0.890499, 0.902538},
            {0.893428, -1.396345, 0.892935, 0.905714},
            {0.881931, -1.380391, 0.895060, 0.908532},
            {0.869452, -1.363906, 0.897008, 0.911016},
            {0.856122, -1.346414, 0.898713, 0.913201},
            {0.842209, -1.329691, 0.900210, 0.915120},
            {0.828528, -1.311922, 0.901579, 0.916813},
            {0.814196, -1.293687, 0.902802, 0.918292},
            {0.798546, -1.274434, 0.903872, 0.919581},
            {0.782621, -1.253411, 0.904805, 0.920674},
            {0.766757, -1.231799, 0.905609, 0.921575},
            {0.749569, -1.210905, 0.906297, 0.922321},
            {0.733372, -1.187808, 0.906876, 0.922902},
            {0.715485, -1.167154, 0.907346, 0.923329},
            {0.698152, -1.142268, 0.907723, 0.923616},
            {0.681521, -1.115347, 0.908013, 0.923756},
            {0.661638, -1.092931, 0.908204, 0.923765},
            {0.637642, -1.069981, 0.908306, 0.923641},
            {0.621755, -1.048491, 0.908313, 0.923396},
            {0.604506, -1.019426, 0.908237, 0.923026},
            {0.587016, -0.991205, 0.908070, 0.922542},
            {0.569248, -0.954272, 0.907822, 0.921943},
            {0.549203, -0.918160, 0.907492, 0.921237},
            {0.524695, -0.889257, 0.907079, 0.920427},
            {0.508940, -0.864156, 0.906590, 0.919514},
            {0.490213, -0.834613, 0.906028, 0.918502},
            {0.474526, -0.796861, 0.905389, 0.917397},
            {0.449861, -0.745435, 0.904679, 0.916203},
            {0.433046, -0.720009, 0.903899, 0.914920},
            {0.422334, -0.697470, 0.903057, 0.913553},
            {0.399384, -0.655950, 0.902149, 0.912107},
            {0.379823, -0.604661, 0.901179, 0.910581},
            {0.369195, -0.578957, 0.900147, 0.908980},
            {0.357848, -0.546173, 0.899057, 0.907306},
            {0.342520, -0.493077, 0.897911, 0.905561},
            {0.319185, -0.423245, 0.896711, 0.903749},
            {0.313371, -0.391453, 0.895462, 0.901869},
            {0.305189, -0.352829, 0.894162, 0.899925},
            {0.299358, -0.318515, 0.892813, 0.897961},
            {0.275665, -0.181268, 0.891416, 0.895966},
            {0.270356, -0.131532, 0.889973, 0.893913},
            {0.262844, 0.000000, 0.888486, 0.891804},
            {0.263272, -0.036188, 0.886956, 0.889640},
            {0.261914, 0.000000, 0.885385, 0.887423},
            {0.993413, -1.570700, 0.860271, 0.979942},
            {0.993413, -1.570700, 0.860271, 0.979942},
            {0.993753, -1.570700, 0.860101, 0.979942},
            {0.996572, -1.566064, 0.881301, 0.979942},
            {0.994739, -1.563310, 0.896434, 0.979942},
            {0.993306, -1.559541, 0.905160, 0.969716},
            {0.990886, -1.555062, 0.910351, 0.946057},
            {0.987864, -1.549696, 0.913755, 0.919578},
            {0.984082, -1.544192, 0.916049, 0.897061},
            {0.979339, -1.538659, 0.917661, 0.881240},
            {0.973581, -1.532254, 0.918803, 0.872544},
            {0.967769, -1.524807, 0.919658, 0.869415},
            {0.961414, -1.517330, 0.920313, 0.870091},
            {0.953758, -1.509305, 0.920813, 0.873049},
            {0.945507, -1.500196, 0.921219, 0.877196},
            {0.937784, -1.490051, 0.921544, 0.881826},
            {0.929729, -1.477943, 0.921811, 0.886523},
            {0.921803, -1.463488, 0.922032, 0.891022},
            {0.914829, -1.446657, 0.922215, 0.895225},
            {0.906536, -1.430048, 0.922370, 0.899054},
            {0.896982, -1.413060, 0.922501, 0.902538},
            {0.886604, -1.396337, 0.922614, 0.905714},
            {0.875495, -1.380241, 0.922710, 0.908532},
            {0.863775, -1.362518, 0.922794, 0.911016},
            {0.850858, -1.346323, 0.922867, 0.913201},
            {0.837942, -1.328600, 0.922929, 0.915120},
            {0.824019, -1.309110, 0.922985, 0.916813},
            {0.808853, -1.290971, 0.923032, 0.918292},
            {0.793902, -1.270452, 0.923074, 0.919581},
            {0.778645, -1.251670, 0.923109, 0.920674},
            {0.762762, -1.229811, 0.923140, 0.921575},
            {0.746180, -1.207724, 0.923166, 0.922321},
            {0.730727, -1.184803, 0.923188, 0.922902},
            {0.712606, -1.163169, 0.923206, 0.923329},
            {0.695269, -1.139390, 0.923220, 0.923616},
            {0.680215, -1.113084, 0.923231, 0.923756},
            {0.654615, -1.093716, 0.923238, 0.923765},
            {0.636897, -1.069553, 0.923243, 0.923641},
            {0.619659, -1.049859, 0.923244, 0.923396},
            {0.607981, -1.023796, 0.923242, 0.923026},
            {0.583535, -0.981428, 0.923238, 0.922542},
            {0.567007, -0.948682, 0.923230, 0.921943},
            {0.542287, -0.917625, 0.923221, 0.921237},
            {0.523609, -0.894110, 0.923208, 0.920427},
            {0.510273, -0.873709, 0.923193, 0.919514},
            {0.495608, -0.816763, 0.923176, 0.918502},
            {0.472767, -0.822127, 0.923156, 0.917397},
            {0.443162, -0.775458, 0.923134, 0.916203},
            {0.438406, -0.731812, 0.923110, 0.914920},
            {0.414123, -0.690037, 0.923083, 0.913553},
            {0.405815, -0.623476, 0.923055, 0.912107},
            {0.375375, -0.637057, 0.923025, 0.910581},
            {0.361388, -0.600222, 0.922992, 0.908980},
            {0.353467, -0.577637, 0.922958, 0.907306},
            {0.320246, -0.500224, 0.922923, 0.905561},
            {0.314765, -0.441195, 0.922885, 0.903749},
            {0.322326, -0.331178, 0.922846, 0.901869},
            {0.317700, -0.276777, 0.922804, 0.899925},
            {0.304282, -0.230403, 0.922762, 0.897961},
            {0.303553, -0.182916, 0.922718, 0.895966},
            {0.297899, 0.000000, 0.922672, 0.893913},
            {0.255922, 0.000000, 0.922626, 0.891804},
            {0.255911, 0.000000, 0.922577, 0.889640},
            {0.255896, 0.000000, 0.922528, 0.887423}
        };
    }
}
