namespace UnityEngine.Rendering.HighDefinition
{
    partial class LTCAreaLight
    {
        //-------------------------------------------------------------------------------------------
        // LTC area light Look up table (fit for GGX with height-correlated Smith's visibility term)
        //-------------------------------------------------------------------------------------------

        // This table is precomputed for sqrt(roughness) and normalized so that last entry
        // is 1 and thus does not need to be store in a texture.
        public static double[,] s_LtcGGXMatrixData = new double[k_LtcLUTResolution * k_LtcLUTResolution, k_LtcLUTMatrixDim * k_LtcLUTMatrixDim]
        {
            {499.999756, 0, 0.000000, 0, 499.999756, 0, 0.000000, 0, 1},
            {499.999756, 0, 0.000000, 0, 499.999756, 0, 0.000000, 0, 1},
            {496.124756, 0, 0.000000, 0, 496.124756, 0, 0.000000, 0, 1},
            {220.499603, 0, 0.000000, 0, 220.499603, 0, 0.000000, 0, 1},
            {124.030647, 0, 0.000000, 0, 124.030647, 0, 0.000000, 0, 1},
            {79.379128, 0, 0.000000, 0, 79.379128, 0, 0.000000, 0, 1},
            {55.123638, 0, 0.000000, 0, 55.123638, 0, 0.000000, 0, 1},
            {40.498169, 0, 0.000000, 0, 40.498169, 0, 0.000000, 0, 1},
            {31.005251, 0, 0.000000, 0, 31.005251, 0, 0.000000, 0, 1},
            {24.496883, 0, 0.000000, 0, 24.496883, 0, 0.000000, 0, 1},
            {19.841213, 0, 0.000000, 0, 19.841213, 0, 0.000000, 0, 1},
            {16.396168, 0, 0.000000, 0, 16.396168, 0, 0.000000, 0, 1},
            {13.775769, 0, 0.000000, 0, 13.775769, 0, 0.000000, 0, 1},
            {11.736223, 0, 0.000000, 0, 11.736223, 0, 0.000000, 0, 1},
            {10.117792, 0, 0.000000, 0, 10.117792, 0, 0.000000, 0, 1},
            {8.811788, 0, 0.000000, 0, 8.811788, 0, 0.000000, 0, 1},
            {7.742715, 0, 0.000000, 0, 7.742715, 0, 0.000000, 0, 1},
            {6.856590, 0, 0.000000, 0, 6.856590, 0, 0.000000, 0, 1},
            {6.113935, 0, 0.000000, 0, 6.113935, 0, 0.000000, 0, 1},
            {5.485600, 0, 0.000000, 0, 5.485600, 0, 0.000000, 0, 1},
            {4.949624, 0, 0.000000, 0, 4.949624, 0, 0.000000, 0, 1},
            {4.490011, 0, 0.000000, 0, 4.490011, 0, 0.000000, 0, 1},
            {4.096192, 0, 0.000000, 0, 4.096192, 0, 0.000000, 0, 1},
            {3.770367, 0, 0.000000, 0, 3.770367, 0, 0.000000, 0, 1},
            {3.518105, 0, 0.000000, 0, 3.518105, 0, 0.000000, 0, 1},
            {3.241291, 0, 0.000000, 0, 3.241291, 0, 0.000000, 0, 1},
            {2.995717, 0, 0.000000, 0, 2.995717, 0, 0.000000, 0, 1},
            {2.777828, 0, 0.000000, 0, 2.777828, 0, 0.000000, 0, 1},
            {2.584874, 0, 0.000000, 0, 2.584874, 0, 0.000000, 0, 1},
            {2.414762, 0, 0.000000, 0, 2.414762, 0, 0.000000, 0, 1},
            {2.266992, 0, 0.000000, 0, 2.266992, 0, 0.000000, 0, 1},
            {2.141645, 0, 0.000000, 0, 2.141645, 0, 0.000000, 0, 1},
            {2.028596, 0, 0.000000, 0, 2.028596, 0, 0.000000, 0, 1},
            {1.913056, 0, 0.000000, 0, 1.913056, 0, 0.000000, 0, 1},
            {1.811136, 0, 0.000000, 0, 1.811136, 0, 0.000000, 0, 1},
            {1.722395, 0, 0.000000, 0, 1.722395, 0, 0.000000, 0, 1},
            {1.646110, 0, 0.000000, 0, 1.646110, 0, 0.000000, 0, 1},
            {1.572143, 0, 0.000000, 0, 1.572143, 0, 0.000000, 0, 1},
            {1.502802, 0, 0.000000, 0, 1.502802, 0, 0.000000, 0, 1},
            {1.442505, 0, 0.000000, 0, 1.442505, 0, 0.000000, 0, 1},
            {1.390581, 0, 0.000000, 0, 1.390581, 0, 0.000000, 0, 1},
            {1.337562, 0, 0.000000, 0, 1.337562, 0, 0.000000, 0, 1},
            {1.291246, 0, 0.000000, 0, 1.291246, 0, 0.000000, 0, 1},
            {1.251378, 0, 0.000000, 0, 1.251378, 0, 0.000000, 0, 1},
            {1.211648, 0, 0.000000, 0, 1.211648, 0, 0.000000, 0, 1},
            {1.176736, 0, 0.000000, 0, 1.176736, 0, 0.000000, 0, 1},
            {1.146271, 0, 0.000000, 0, 1.146271, 0, 0.000000, 0, 1},
            {1.116030, 0, 0.000000, 0, 1.116030, 0, 0.000000, 0, 1},
            {1.089959, 0, 0.000000, 0, 1.089959, 0, 0.000000, 0, 1},
            {1.065901, 0, 0.000000, 0, 1.065901, 0, 0.000000, 0, 1},
            {1.043491, 0, 0.000000, 0, 1.043491, 0, 0.000000, 0, 1},
            {1.024384, 0, 0.000000, 0, 1.024384, 0, 0.000000, 0, 1},
            {1.005152, 0, 0.000000, 0, 1.005152, 0, 0.000000, 0, 1},
            {0.988931, 0, 0.000000, 0, 0.988931, 0, 0.000000, 0, 1},
            {0.973526, 0, 0.000000, 0, 0.973526, 0, 0.000000, 0, 1},
            {0.959606, 0, 0.000000, 0, 0.959606, 0, 0.000000, 0, 1},
            {0.947352, 0, 0.000000, 0, 0.947352, 0, 0.000000, 0, 1},
            {0.935462, 0, 0.000000, 0, 0.935462, 0, 0.000000, 0, 1},
            {0.925545, 0, 0.000000, 0, 0.925545, 0, 0.000000, 0, 1},
            {0.915651, 0, 0.000000, 0, 0.915651, 0, 0.000000, 0, 1},
            {0.907310, 0, 0.000000, 0, 0.907310, 0, 0.000000, 0, 1},
            {0.899582, 0, 0.000000, 0, 0.899582, 0, 0.000000, 0, 1},
            {0.892452, 0, 0.000000, 0, 0.892452, 0, 0.000000, 0, 1},
            {0.886714, 0, 0.000000, 0, 0.886714, 0, 0.000000, 0, 1},
            {499.997467, 0, -0.024938, 0, 500.315308, 0, 12.469114, 0, 1},
            {499.997467, 0, -0.024938, 0, 500.315308, 0, 12.469114, 0, 1},
            {496.120789, 0, -0.024938, 0, 496.432007, 0, 12.372410, 0, 1},
            {220.501129, 0, -0.024938, 0, 220.634109, 0, 5.498928, 0, 1},
            {124.029526, 0, -0.024938, 0, 124.107147, 0, 3.093094, 0, 1},
            {79.380730, 0, -0.024938, 0, 79.425026, 0, 1.979585, 0, 1},
            {55.125454, 0, -0.024938, 0, 55.154995, 0, 1.374758, 0, 1},
            {40.497589, 0, -0.024938, 0, 40.519520, 0, 1.009913, 0, 1},
            {31.004519, 0, -0.024938, 0, 31.025820, 0, 0.773211, 0, 1},
            {24.500708, 0, -0.024938, 0, 24.513670, 0, 0.611046, 0, 1},
            {19.841555, 0, -0.024938, 0, 19.853317, 0, 0.494783, 0, 1},
            {16.396729, 0, -0.024938, 0, 16.405884, 0, 0.408921, 0, 1},
            {13.775448, 0, -0.024938, 0, 13.784056, 0, 0.343552, 0, 1},
            {11.736258, 0, -0.024938, 0, 11.743598, 0, 0.292695, 0, 1},
            {10.117566, 0, -0.024937, 0, 10.124036, 0, 0.252312, 0, 1},
            {8.812078, 0, -0.024937, 0, 8.817113, 0, 0.219782, 0, 1},
            {7.742629, 0, -0.024935, 0, 7.747515, 0, 0.193081, 0, 1},
            {6.856578, 0, -0.024932, 0, 6.860840, 0, 0.170986, 0, 1},
            {6.113971, 0, -0.024925, 0, 6.117671, 0, 0.152466, 0, 1},
            {5.485563, 0, -0.024910, 0, 5.489127, 0, 0.136802, 0, 1},
            {4.949559, 0, -0.024870, 0, 4.952751, 0, 0.123416, 0, 1},
            {4.489937, 0, -0.024745, 0, 4.492629, 0, 0.111934, 0, 1},
            {4.096371, 0, -0.024262, 0, 4.098849, 0, 0.102052, 0, 1},
            {3.771275, 0, -0.022097, 0, 3.773541, 0, 0.093597, 0, 1},
            {3.516103, 0, -0.023925, 0, 3.518279, 0, 0.087490, 0, 1},
            {3.241332, 0, -0.024830, 0, 3.243283, 0, 0.080765, 0, 1},
            {2.995699, 0, -0.024748, 0, 2.997590, 0, 0.074613, 0, 1},
            {2.777862, 0, -0.024592, 0, 2.779489, 0, 0.069120, 0, 1},
            {2.584914, 0, -0.024281, 0, 2.586422, 0, 0.064225, 0, 1},
            {2.414872, 0, -0.023657, 0, 2.416185, 0, 0.059820, 0, 1},
            {2.267114, 0, -0.022465, 0, 2.268396, 0, 0.055784, 0, 1},
            {2.141941, 0, -0.020477, 0, 2.143198, 0, 0.052087, 0, 1},
            {2.028542, 0, -0.023611, 0, 2.029632, 0, 0.049974, 0, 1},
            {1.913215, 0, -0.023107, 0, 1.914276, 0, 0.046906, 0, 1},
            {1.811212, 0, -0.022033, 0, 1.812173, 0, 0.043959, 0, 1},
            {1.722411, 0, -0.020495, 0, 1.723353, 0, 0.041147, 0, 1},
            {1.646026, 0, -0.018657, 0, 1.646907, 0, 0.038474, 0, 1},
            {1.572377, 0, -0.021412, 0, 1.573126, 0, 0.037363, 0, 1},
            {1.502932, 0, -0.019942, 0, 1.503651, 0, 0.034957, 0, 1},
            {1.442565, 0, -0.018071, 0, 1.443349, 0, 0.032557, 0, 1},
            {1.389405, 0, -0.017912, 0, 1.389993, 0, 0.030870, 0, 1},
            {1.337534, 0, -0.018389, 0, 1.338214, 0, 0.029500, 0, 1},
            {1.291183, 0, -0.016379, 0, 1.291845, 0, 0.027284, 0, 1},
            {1.250589, 0, -0.015515, 0, 1.251112, 0, 0.025561, 0, 1},
            {1.211601, 0, -0.016135, 0, 1.212186, 0, 0.024493, 0, 1},
            {1.176648, 0, -0.013892, 0, 1.177168, 0, 0.022343, 0, 1},
            {1.145530, 0, -0.013874, 0, 1.145999, 0, 0.021082, 0, 1},
            {1.115965, 0, -0.013290, 0, 1.116396, 0, 0.019656, 0, 1},
            {1.089884, 0, -0.010950, 0, 1.090292, 0, 0.017533, 0, 1},
            {1.065711, 0, -0.012243, 0, 1.066189, 0, 0.016981, 0, 1},
            {1.043418, 0, -0.009963, 0, 1.043784, 0, 0.015012, 0, 1},
            {1.023707, 0, -0.009491, 0, 1.024012, 0, 0.013768, 0, 1},
            {1.005073, 0, -0.008990, 0, 1.005400, 0, 0.012594, 0, 1},
            {0.988718, 0, -0.006973, 0, 0.988881, 0, 0.010736, 0, 1},
            {0.973377, 0, -0.007934, 0, 0.973646, 0, 0.010213, 0, 1},
            {0.959581, 0, -0.005300, 0, 0.959736, 0, 0.008216, 0, 1},
            {0.947100, 0, -0.005782, 0, 0.947218, 0, 0.007536, 0, 1},
            {0.935461, 0, -0.004359, 0, 0.935582, 0, 0.006105, 0, 1},
            {0.925285, 0, -0.003382, 0, 0.925340, 0, 0.004898, 0, 1},
            {0.915672, 0, -0.003535, 0, 0.915789, 0, 0.004238, 0, 1},
            {0.907287, 0, -0.001205, 0, 0.907276, 0, 0.002472, 0, 1},
            {0.899553, 0, -0.002254, 0, 0.899631, 0, 0.002261, 0, 1},
            {0.892552, 0, -0.000191, 0, 0.892524, 0, 0.000671, 0, 1},
            {0.886461, 0, 0.000076, 0, 0.886428, 0, -0.000037, 0, 1},
            {500.000763, 0, -0.049908, 0, 501.241730, 0, 24.953888, 0, 1},
            {500.000763, 0, -0.049908, 0, 501.241730, 0, 24.953888, 0, 1},
            {496.124786, 0, -0.049908, 0, 497.354095, 0, 24.760460, 0, 1},
            {220.502029, 0, -0.049908, 0, 221.048279, 0, 11.004783, 0, 1},
            {124.031570, 0, -0.049908, 0, 124.337486, 0, 6.190133, 0, 1},
            {79.375877, 0, -0.049908, 0, 79.579933, 0, 3.961427, 0, 1},
            {55.123718, 0, -0.049908, 0, 55.262177, 0, 2.751114, 0, 1},
            {40.498699, 0, -0.049908, 0, 40.605160, 0, 2.021145, 0, 1},
            {31.006849, 0, -0.049908, 0, 31.083014, 0, 1.547495, 0, 1},
            {24.497278, 0, -0.049907, 0, 24.555908, 0, 1.222601, 0, 1},
            {19.841276, 0, -0.049907, 0, 19.890913, 0, 0.990210, 0, 1},
            {16.397182, 0, -0.049907, 0, 16.436363, 0, 0.818381, 0, 1},
            {13.775660, 0, -0.049907, 0, 13.810318, 0, 0.687523, 0, 1},
            {11.736480, 0, -0.049906, 0, 11.765283, 0, 0.585738, 0, 1},
            {10.117846, 0, -0.049905, 0, 10.142936, 0, 0.504958, 0, 1},
            {8.811889, 0, -0.049903, 0, 8.833607, 0, 0.439785, 0, 1},
            {7.742730, 0, -0.049899, 0, 7.761981, 0, 0.386421, 0, 1},
            {6.856680, 0, -0.049893, 0, 6.873636, 0, 0.342192, 0, 1},
            {6.114114, 0, -0.049879, 0, 6.129047, 0, 0.305132, 0, 1},
            {5.485716, 0, -0.049847, 0, 5.499178, 0, 0.273756, 0, 1},
            {4.949782, 0, -0.049764, 0, 4.961692, 0, 0.246984, 0, 1},
            {4.490149, 0, -0.049505, 0, 4.501019, 0, 0.224018, 0, 1},
            {4.097056, 0, -0.048478, 0, 4.107090, 0, 0.204225, 0, 1},
            {3.774032, 0, -0.043886, 0, 3.783077, 0, 0.187406, 0, 1},
            {3.508570, 0, -0.045740, 0, 3.516984, 0, 0.174357, 0, 1},
            {3.241517, 0, -0.049683, 0, 3.249252, 0, 0.161645, 0, 1},
            {2.995973, 0, -0.049517, 0, 3.003005, 0, 0.149331, 0, 1},
            {2.778171, 0, -0.049198, 0, 2.784698, 0, 0.138350, 0, 1},
            {2.585188, 0, -0.048562, 0, 2.591244, 0, 0.128554, 0, 1},
            {2.415389, 0, -0.047285, 0, 2.420921, 0, 0.119684, 0, 1},
            {2.267856, 0, -0.044864, 0, 2.273003, 0, 0.111664, 0, 1},
            {2.142349, 0, -0.041214, 0, 2.147094, 0, 0.104325, 0, 1},
            {2.026238, 0, -0.045263, 0, 2.030645, 0, 0.099390, 0, 1},
            {1.913620, 0, -0.046191, 0, 1.917722, 0, 0.093860, 0, 1},
            {1.811767, 0, -0.044024, 0, 1.815528, 0, 0.087973, 0, 1},
            {1.722954, 0, -0.040932, 0, 1.726578, 0, 0.082334, 0, 1},
            {1.644901, 0, -0.039208, 0, 1.648202, 0, 0.077520, 0, 1},
            {1.571913, 0, -0.041873, 0, 1.575045, 0, 0.074419, 0, 1},
            {1.503270, 0, -0.039833, 0, 1.506199, 0, 0.069899, 0, 1},
            {1.442908, 0, -0.036082, 0, 1.445582, 0, 0.065106, 0, 1},
            {1.388112, 0, -0.036042, 0, 1.390726, 0, 0.061864, 0, 1},
            {1.337609, 0, -0.036698, 0, 1.340105, 0, 0.058965, 0, 1},
            {1.291279, 0, -0.032700, 0, 1.293611, 0, 0.054525, 0, 1},
            {1.249435, 0, -0.031700, 0, 1.251650, 0, 0.051350, 0, 1},
            {1.211340, 0, -0.031811, 0, 1.213610, 0, 0.048750, 0, 1},
            {1.176439, 0, -0.028136, 0, 1.178426, 0, 0.044750, 0, 1},
            {1.144471, 0, -0.027408, 0, 1.146456, 0, 0.042026, 0, 1},
            {1.115653, 0, -0.026454, 0, 1.117463, 0, 0.039242, 0, 1},
            {1.088942, 0, -0.023544, 0, 1.090648, 0, 0.035801, 0, 1},
            {1.064893, 0, -0.022785, 0, 1.066460, 0, 0.033264, 0, 1},
            {1.043063, 0, -0.020388, 0, 1.044470, 0, 0.030166, 0, 1},
            {1.022807, 0, -0.018916, 0, 1.024093, 0, 0.027487, 0, 1},
            {1.004772, 0, -0.017485, 0, 1.005940, 0, 0.024861, 0, 1},
            {0.987888, 0, -0.015340, 0, 0.988963, 0, 0.022016, 0, 1},
            {0.972935, 0, -0.014043, 0, 0.973770, 0, 0.019711, 0, 1},
            {0.959224, 0, -0.012082, 0, 0.959891, 0, 0.017081, 0, 1},
            {0.946621, 0, -0.010581, 0, 0.947148, 0, 0.014730, 0, 1},
            {0.935432, 0, -0.009036, 0, 0.935867, 0, 0.012380, 0, 1},
            {0.924873, 0, -0.007271, 0, 0.925218, 0, 0.010048, 0, 1},
            {0.915710, 0, -0.005702, 0, 0.915873, 0, 0.007844, 0, 1},
            {0.907153, 0, -0.004224, 0, 0.907238, 0, 0.005758, 0, 1},
            {0.899406, 0, -0.002766, 0, 0.899481, 0, 0.003776, 0, 1},
            {0.892606, 0, -0.001541, 0, 0.892650, 0, 0.001899, 0, 1},
            {0.886250, 0, 0.000097, 0, 0.886236, 0, -0.000010, 0, 1},
            {500.003906, 0, -0.074939, 0, 502.811340, 0, 37.469978, 0, 1},
            {500.003906, 0, -0.074939, 0, 502.811340, 0, 37.469978, 0, 1},
            {496.126373, 0, -0.074939, 0, 498.908203, 0, 37.179375, 0, 1},
            {220.498306, 0, -0.074939, 0, 221.739334, 0, 16.524048, 0, 1},
            {124.030350, 0, -0.074939, 0, 124.718994, 0, 9.294769, 0, 1},
            {79.379128, 0, -0.074939, 0, 79.824699, 0, 5.948611, 0, 1},
            {55.123489, 0, -0.074939, 0, 55.433598, 0, 4.130918, 0, 1},
            {40.500011, 0, -0.074939, 0, 40.723366, 0, 3.035039, 0, 1},
            {31.005369, 0, -0.074939, 0, 31.179090, 0, 2.323509, 0, 1},
            {24.496525, 0, -0.074939, 0, 24.633451, 0, 1.835765, 0, 1},
            {19.841644, 0, -0.074938, 0, 19.952940, 0, 1.486910, 0, 1},
            {16.396143, 0, -0.074938, 0, 16.487474, 0, 1.228654, 0, 1},
            {13.776081, 0, -0.074937, 0, 13.853146, 0, 1.032362, 0, 1},
            {11.736395, 0, -0.074935, 0, 11.802135, 0, 0.879502, 0, 1},
            {10.117812, 0, -0.074933, 0, 10.174429, 0, 0.758217, 0, 1},
            {8.811981, 0, -0.074929, 0, 8.861101, 0, 0.660355, 0, 1},
            {7.742858, 0, -0.074923, 0, 7.786114, 0, 0.580231, 0, 1},
            {6.856779, 0, -0.074912, 0, 6.894941, 0, 0.513821, 0, 1},
            {6.114171, 0, -0.074889, 0, 6.148230, 0, 0.458161, 0, 1},
            {5.485709, 0, -0.074839, 0, 5.516331, 0, 0.411046, 0, 1},
            {4.950073, 0, -0.074708, 0, 4.977382, 0, 0.370891, 0, 1},
            {4.490536, 0, -0.074292, 0, 4.515291, 0, 0.336361, 0, 1},
            {4.098239, 0, -0.072590, 0, 4.120820, 0, 0.306734, 0, 1},
            {3.778176, 0, -0.065358, 0, 3.798698, 0, 0.281599, 0, 1},
            {3.501400, 0, -0.068271, 0, 3.520339, 0, 0.261196, 0, 1},
            {3.241759, 0, -0.074584, 0, 3.259283, 0, 0.242727, 0, 1},
            {2.996215, 0, -0.074327, 0, 3.012302, 0, 0.224223, 0, 1},
            {2.778568, 0, -0.073832, 0, 2.793303, 0, 0.207776, 0, 1},
            {2.585738, 0, -0.072843, 0, 2.599365, 0, 0.193040, 0, 1},
            {2.416121, 0, -0.070857, 0, 2.428695, 0, 0.179718, 0, 1},
            {2.268859, 0, -0.067130, 0, 2.280476, 0, 0.167671, 0, 1},
            {2.141096, 0, -0.063785, 0, 2.152040, 0, 0.157027, 0, 1},
            {2.023644, 0, -0.066946, 0, 2.033512, 0, 0.148756, 0, 1},
            {1.914204, 0, -0.069230, 0, 1.923599, 0, 0.140941, 0, 1},
            {1.812284, 0, -0.065931, 0, 1.821127, 0, 0.132011, 0, 1},
            {1.723733, 0, -0.061254, 0, 1.731673, 0, 0.123587, 0, 1},
            {1.643700, 0, -0.060073, 0, 1.651181, 0, 0.116759, 0, 1},
            {1.570878, 0, -0.061255, 0, 1.577947, 0, 0.111093, 0, 1},
            {1.503769, 0, -0.059626, 0, 1.510444, 0, 0.104935, 0, 1},
            {1.442635, 0, -0.055255, 0, 1.448715, 0, 0.098180, 0, 1},
            {1.387056, 0, -0.054241, 0, 1.392869, 0, 0.092851, 0, 1},
            {1.337041, 0, -0.053462, 0, 1.342574, 0, 0.087917, 0, 1},
            {1.290878, 0, -0.050026, 0, 1.296141, 0, 0.082196, 0, 1},
            {1.248439, 0, -0.047915, 0, 1.253429, 0, 0.077195, 0, 1},
            {1.210667, 0, -0.046026, 0, 1.215250, 0, 0.072448, 0, 1},
            {1.175449, 0, -0.043601, 0, 1.180079, 0, 0.067715, 0, 1},
            {1.143403, 0, -0.040953, 0, 1.147558, 0, 0.062874, 0, 1},
            {1.114792, 0, -0.038485, 0, 1.118552, 0, 0.058326, 0, 1},
            {1.087870, 0, -0.036310, 0, 1.091672, 0, 0.054108, 0, 1},
            {1.064033, 0, -0.033135, 0, 1.067198, 0, 0.049455, 0, 1},
            {1.041912, 0, -0.031405, 0, 1.045065, 0, 0.045583, 0, 1},
            {1.021936, 0, -0.028342, 0, 1.024621, 0, 0.041212, 0, 1},
            {1.003819, 0, -0.025671, 0, 1.006238, 0, 0.037092, 0, 1},
            {0.987085, 0, -0.023775, 0, 0.989336, 0, 0.033446, 0, 1},
            {0.972217, 0, -0.020270, 0, 0.973956, 0, 0.029156, 0, 1},
            {0.958542, 0, -0.018758, 0, 0.960061, 0, 0.025897, 0, 1},
            {0.946206, 0, -0.015383, 0, 0.947357, 0, 0.021807, 0, 1},
            {0.934889, 0, -0.013428, 0, 0.935841, 0, 0.018565, 0, 1},
            {0.924647, 0, -0.011186, 0, 0.925321, 0, 0.015190, 0, 1},
            {0.915382, 0, -0.008364, 0, 0.915812, 0, 0.011722, 0, 1},
            {0.906943, 0, -0.006877, 0, 0.907291, 0, 0.008911, 0, 1},
            {0.899339, 0, -0.003664, 0, 0.899526, 0, 0.005431, 0, 1},
            {0.892387, 0, -0.002221, 0, 0.892474, 0, 0.002847, 0, 1},
            {0.886227, 0, 0.000064, 0, 0.886204, 0, -0.000034, 0, 1},
            {499.983826, 0, -0.100065, 0, 505.023865, 0, 50.030712, 0, 1},
            {499.983826, 0, -0.100065, 0, 505.023865, 0, 50.030712, 0, 1},
            {496.132507, 0, -0.100065, 0, 501.084991, 0, 49.645359, 0, 1},
            {220.501862, 0, -0.100065, 0, 222.708817, 0, 22.064491, 0, 1},
            {124.032257, 0, -0.100065, 0, 125.271431, 0, 12.411230, 0, 1},
            {79.379440, 0, -0.100065, 0, 80.174622, 0, 7.943080, 0, 1},
            {55.123135, 0, -0.100064, 0, 55.675999, 0, 5.515856, 0, 1},
            {40.497456, 0, -0.100064, 0, 40.905289, 0, 4.052378, 0, 1},
            {31.005117, 0, -0.100064, 0, 31.316229, 0, 3.102522, 0, 1},
            {24.498039, 0, -0.100063, 0, 24.743013, 0, 2.451441, 0, 1},
            {19.841043, 0, -0.100062, 0, 20.039982, 0, 1.985378, 0, 1},
            {16.396048, 0, -0.100061, 0, 16.560276, 0, 1.640648, 0, 1},
            {13.776016, 0, -0.100059, 0, 13.913796, 0, 1.378505, 0, 1},
            {11.736537, 0, -0.100056, 0, 11.853859, 0, 1.174419, 0, 1},
            {10.118081, 0, -0.100052, 0, 10.218950, 0, 1.012446, 0, 1},
            {8.812102, 0, -0.100045, 0, 8.899796, 0, 0.881770, 0, 1},
            {7.743134, 0, -0.100035, 0, 7.820218, 0, 0.774784, 0, 1},
            {6.856761, 0, -0.100018, 0, 6.924968, 0, 0.686070, 0, 1},
            {6.114274, 0, -0.099985, 0, 6.174966, 0, 0.611784, 0, 1},
            {5.486098, 0, -0.099914, 0, 5.540296, 0, 0.548911, 0, 1},
            {4.950230, 0, -0.099727, 0, 4.999048, 0, 0.495238, 0, 1},
            {4.490978, 0, -0.099115, 0, 4.535179, 0, 0.449195, 0, 1},
            {4.100280, 0, -0.096506, 0, 4.140200, 0, 0.409693, 0, 1},
            {3.778569, 0, -0.088914, 0, 3.815209, 0, 0.376297, 0, 1},
            {3.495200, 0, -0.091444, 0, 3.528899, 0, 0.348182, 0, 1},
            {3.241935, 0, -0.099470, 0, 3.273196, 0, 0.324086, 0, 1},
            {2.996644, 0, -0.099199, 0, 3.025353, 0, 0.299427, 0, 1},
            {2.779053, 0, -0.098507, 0, 2.805380, 0, 0.277436, 0, 1},
            {2.586476, 0, -0.097117, 0, 2.610731, 0, 0.257765, 0, 1},
            {2.417085, 0, -0.094336, 0, 2.439497, 0, 0.240043, 0, 1},
            {2.270406, 0, -0.089196, 0, 2.291107, 0, 0.223905, 0, 1},
            {2.139853, 0, -0.086879, 0, 2.158984, 0, 0.209936, 0, 1},
            {2.021571, 0, -0.088889, 0, 2.039346, 0, 0.198304, 0, 1},
            {1.914086, 0, -0.091324, 0, 1.930882, 0, 0.187834, 0, 1},
            {1.813416, 0, -0.087712, 0, 1.828976, 0, 0.176267, 0, 1},
            {1.723984, 0, -0.082584, 0, 1.738285, 0, 0.165269, 0, 1},
            {1.642613, 0, -0.081077, 0, 1.656077, 0, 0.156015, 0, 1},
            {1.569811, 0, -0.080575, 0, 1.582335, 0, 0.147811, 0, 1},
            {1.504189, 0, -0.078769, 0, 1.515917, 0, 0.139826, 0, 1},
            {1.442117, 0, -0.075025, 0, 1.453279, 0, 0.131437, 0, 1},
            {1.386219, 0, -0.072455, 0, 1.396548, 0, 0.123838, 0, 1},
            {1.336734, 0, -0.069700, 0, 1.345977, 0, 0.116663, 0, 1},
            {1.290254, 0, -0.067901, 0, 1.299658, 0, 0.110078, 0, 1},
            {1.247579, 0, -0.064105, 0, 1.256130, 0, 0.103060, 0, 1},
            {1.209898, 0, -0.060546, 0, 1.217607, 0, 0.096296, 0, 1},
            {1.174434, 0, -0.058685, 0, 1.182144, 0, 0.090393, 0, 1},
            {1.142631, 0, -0.054454, 0, 1.149469, 0, 0.083838, 0, 1},
            {1.113513, 0, -0.051220, 0, 1.119927, 0, 0.077738, 0, 1},
            {1.086981, 0, -0.048682, 0, 1.093063, 0, 0.072191, 0, 1},
            {1.062786, 0, -0.044314, 0, 1.068357, 0, 0.065921, 0, 1},
            {1.040858, 0, -0.041433, 0, 1.045878, 0, 0.060476, 0, 1},
            {1.020989, 0, -0.037974, 0, 1.025619, 0, 0.054945, 0, 1},
            {1.002567, 0, -0.034336, 0, 1.006743, 0, 0.049497, 0, 1},
            {0.986308, 0, -0.031079, 0, 0.989842, 0, 0.044312, 0, 1},
            {0.971085, 0, -0.027686, 0, 0.974268, 0, 0.039176, 0, 1},
            {0.957699, 0, -0.024253, 0, 0.960263, 0, 0.034145, 0, 1},
            {0.945356, 0, -0.021318, 0, 0.947588, 0, 0.029488, 0, 1},
            {0.934259, 0, -0.017754, 0, 0.935834, 0, 0.024674, 0, 1},
            {0.924229, 0, -0.014611, 0, 0.925383, 0, 0.020181, 0, 1},
            {0.914933, 0, -0.011603, 0, 0.915777, 0, 0.015785, 0, 1},
            {0.906746, 0, -0.008179, 0, 0.907248, 0, 0.011415, 0, 1},
            {0.899098, 0, -0.005942, 0, 0.899435, 0, 0.007740, 0, 1},
            {0.892211, 0, -0.002476, 0, 0.892303, 0, 0.003563, 0, 1},
            {0.886070, 0, 0.000087, 0, 0.886099, 0, -0.000117, 0, 1},
            {499.988678, 0, -0.125316, 0, 507.848236, 0, 62.656498, 0, 1},
            {499.988678, 0, -0.125316, 0, 507.848236, 0, 62.656498, 0, 1},
            {496.129761, 0, -0.125316, 0, 503.914063, 0, 62.172882, 0, 1},
            {220.497086, 0, -0.125316, 0, 223.959366, 0, 27.631804, 0, 1},
            {124.019318, 0, -0.125316, 0, 125.981674, 0, 15.541595, 0, 1},
            {79.381973, 0, -0.125315, 0, 80.623238, 0, 9.947818, 0, 1},
            {55.123730, 0, -0.125315, 0, 55.990360, 0, 6.907876, 0, 1},
            {40.499413, 0, -0.125315, 0, 41.132862, 0, 5.075211, 0, 1},
            {31.005598, 0, -0.125314, 0, 31.492960, 0, 3.885517, 0, 1},
            {24.498001, 0, -0.125312, 0, 24.882656, 0, 3.070006, 0, 1},
            {19.841513, 0, -0.125310, 0, 20.152517, 0, 2.486452, 0, 1},
            {16.395920, 0, -0.125308, 0, 16.653996, 0, 2.054650, 0, 1},
            {13.776306, 0, -0.125304, 0, 13.992229, 0, 1.726372, 0, 1},
            {11.736536, 0, -0.125299, 0, 11.920282, 0, 1.470755, 0, 1},
            {10.118100, 0, -0.125292, 0, 10.276620, 0, 1.267936, 0, 1},
            {8.812184, 0, -0.125282, 0, 8.949860, 0, 1.104275, 0, 1},
            {7.743106, 0, -0.125267, 0, 7.863972, 0, 0.970299, 0, 1},
            {6.857152, 0, -0.125242, 0, 6.963921, 0, 0.859257, 0, 1},
            {6.114560, 0, -0.125197, 0, 6.209592, 0, 0.766163, 0, 1},
            {5.486320, 0, -0.125099, 0, 5.571335, 0, 0.687425, 0, 1},
            {4.950572, 0, -0.124844, 0, 5.027175, 0, 0.620248, 0, 1},
            {4.491789, 0, -0.123975, 0, 4.560817, 0, 0.562587, 0, 1},
            {4.103055, 0, -0.120083, 0, 4.165789, 0, 0.513305, 0, 1},
            {3.777709, 0, -0.113248, 0, 3.835187, 0, 0.471403, 0, 1},
            {3.489725, 0, -0.115143, 0, 3.542538, 0, 0.435448, 0, 1},
            {3.237550, 0, -0.122470, 0, 3.286473, 0, 0.404937, 0, 1},
            {2.997180, 0, -0.124153, 0, 3.042161, 0, 0.375008, 0, 1},
            {2.779752, 0, -0.123233, 0, 2.821080, 0, 0.347483, 0, 1},
            {2.587363, 0, -0.121377, 0, 2.625501, 0, 0.322832, 0, 1},
            {2.418493, 0, -0.117683, 0, 2.453598, 0, 0.300661, 0, 1},
            {2.271636, 0, -0.111763, 0, 2.304001, 0, 0.280542, 0, 1},
            {2.138656, 0, -0.110167, 0, 2.168852, 0, 0.263093, 0, 1},
            {2.019761, 0, -0.111032, 0, 2.047639, 0, 0.247931, 0, 1},
            {1.912891, 0, -0.112309, 0, 1.939135, 0, 0.234426, 0, 1},
            {1.814850, 0, -0.109323, 0, 1.839034, 0, 0.220689, 0, 1},
            {1.723768, 0, -0.104629, 0, 1.746386, 0, 0.207252, 0, 1},
            {1.641915, 0, -0.102120, 0, 1.662966, 0, 0.195394, 0, 1},
            {1.569105, 0, -0.099893, 0, 1.588437, 0, 0.184631, 0, 1},
            {1.503554, 0, -0.097455, 0, 1.521679, 0, 0.174583, 0, 1},
            {1.441778, 0, -0.094928, 0, 1.458937, 0, 0.164771, 0, 1},
            {1.385807, 0, -0.090627, 0, 1.401628, 0, 0.154927, 0, 1},
            {1.335691, 0, -0.086796, 0, 1.350160, 0, 0.145743, 0, 1},
            {1.289436, 0, -0.084635, 0, 1.303330, 0, 0.137498, 0, 1},
            {1.247463, 0, -0.080219, 0, 1.260158, 0, 0.128819, 0, 1},
            {1.208796, 0, -0.075910, 0, 1.220506, 0, 0.120424, 0, 1},
            {1.173811, 0, -0.072647, 0, 1.184842, 0, 0.112685, 0, 1},
            {1.141949, 0, -0.068515, 0, 1.152425, 0, 0.104874, 0, 1},
            {1.112584, 0, -0.064082, 0, 1.121989, 0, 0.097076, 0, 1},
            {1.086414, 0, -0.059860, 0, 1.094814, 0, 0.089718, 0, 1},
            {1.061834, 0, -0.056167, 0, 1.069931, 0, 0.082653, 0, 1},
            {1.040016, 0, -0.051208, 0, 1.047066, 0, 0.075299, 0, 1},
            {1.019809, 0, -0.047463, 0, 1.026480, 0, 0.068631, 0, 1},
            {1.001626, 0, -0.043084, 0, 1.007392, 0, 0.061772, 0, 1},
            {0.985189, 0, -0.038572, 0, 0.990411, 0, 0.055197, 0, 1},
            {0.970203, 0, -0.035021, 0, 0.974849, 0, 0.049107, 0, 1},
            {0.956741, 0, -0.030024, 0, 0.960630, 0, 0.042536, 0, 1},
            {0.944591, 0, -0.026461, 0, 0.947661, 0, 0.036732, 0, 1},
            {0.933605, 0, -0.022093, 0, 0.936114, 0, 0.030734, 0, 1},
            {0.923538, 0, -0.018221, 0, 0.925506, 0, 0.025107, 0, 1},
            {0.914564, 0, -0.014631, 0, 0.915917, 0, 0.019829, 0, 1},
            {0.906314, 0, -0.010410, 0, 0.907137, 0, 0.014384, 0, 1},
            {0.898843, 0, -0.007030, 0, 0.899280, 0, 0.009481, 0, 1},
            {0.892090, 0, -0.003253, 0, 0.892242, 0, 0.004531, 0, 1},
            {0.885826, 0, 0.000163, 0, 0.885772, 0, -0.000108, 0, 1},
            {499.975067, 0, -0.150725, 0, 511.384979, 0, 75.358841, 0, 1},
            {499.975067, 0, -0.150725, 0, 511.384979, 0, 75.358841, 0, 1},
            {496.103210, 0, -0.150725, 0, 507.432037, 0, 74.775238, 0, 1},
            {220.498627, 0, -0.150725, 0, 225.508652, 0, 33.234734, 0, 1},
            {124.037292, 0, -0.150725, 0, 126.842415, 0, 18.695688, 0, 1},
            {79.374237, 0, -0.150724, 0, 81.185875, 0, 11.963627, 0, 1},
            {55.122051, 0, -0.150724, 0, 56.377090, 0, 8.308264, 0, 1},
            {40.495537, 0, -0.150723, 0, 41.419373, 0, 6.103695, 0, 1},
            {31.006496, 0, -0.150722, 0, 31.705175, 0, 4.673535, 0, 1},
            {24.502220, 0, -0.150719, 0, 25.054398, 0, 3.693235, 0, 1},
            {19.841686, 0, -0.150716, 0, 20.291641, 0, 2.990625, 0, 1},
            {16.396605, 0, -0.150712, 0, 16.768789, 0, 2.471370, 0, 1},
            {13.776132, 0, -0.150705, 0, 14.088309, 0, 2.076396, 0, 1},
            {11.736781, 0, -0.150697, 0, 12.002884, 0, 1.769014, 0, 1},
            {10.118110, 0, -0.150686, 0, 10.347181, 0, 1.525028, 0, 1},
            {8.812341, 0, -0.150671, 0, 9.011584, 0, 1.328194, 0, 1},
            {7.743464, 0, -0.150649, 0, 7.918241, 0, 1.167073, 0, 1},
            {6.857213, 0, -0.150614, 0, 7.011972, 0, 1.033487, 0, 1},
            {6.114755, 0, -0.150553, 0, 6.252233, 0, 0.921551, 0, 1},
            {5.486509, 0, -0.150423, 0, 5.609710, 0, 0.826825, 0, 1},
            {4.951097, 0, -0.150081, 0, 5.061741, 0, 0.746066, 0, 1},
            {4.492796, 0, -0.148855, 0, 4.592881, 0, 0.676774, 0, 1},
            {4.106829, 0, -0.143114, 0, 4.197904, 0, 0.617765, 0, 1},
            {3.776172, 0, -0.138048, 0, 3.859241, 0, 0.567013, 0, 1},
            {3.485237, 0, -0.139282, 0, 3.561492, 0, 0.523169, 0, 1},
            {3.232046, 0, -0.145310, 0, 3.302608, 0, 0.485838, 0, 1},
            {2.997767, 0, -0.149207, 0, 3.062907, 0, 0.451090, 0, 1},
            {2.780419, 0, -0.148017, 0, 2.840446, 0, 0.417909, 0, 1},
            {2.588510, 0, -0.145605, 0, 2.643693, 0, 0.388345, 0, 1},
            {2.420171, 0, -0.140849, 0, 2.471030, 0, 0.361647, 0, 1},
            {2.271814, 0, -0.135408, 0, 2.318790, 0, 0.337650, 0, 1},
            {2.137570, 0, -0.133633, 0, 2.181172, 0, 0.316517, 0, 1},
            {2.018142, 0, -0.133331, 0, 2.058458, 0, 0.297881, 0, 1},
            {1.911721, 0, -0.133095, 0, 1.949249, 0, 0.281156, 0, 1},
            {1.815834, 0, -0.130985, 0, 1.850734, 0, 0.265446, 0, 1},
            {1.723832, 0, -0.126806, 0, 1.756498, 0, 0.249452, 0, 1},
            {1.641533, 0, -0.123155, 0, 1.671640, 0, 0.235015, 0, 1},
            {1.569057, 0, -0.119176, 0, 1.596424, 0, 0.221675, 0, 1},
            {1.502528, 0, -0.116564, 0, 1.528443, 0, 0.209495, 0, 1},
            {1.441651, 0, -0.114442, 0, 1.466111, 0, 0.198148, 0, 1},
            {1.386014, 0, -0.108702, 0, 1.407911, 0, 0.186116, 0, 1},
            {1.335108, 0, -0.104388, 0, 1.355553, 0, 0.175068, 0, 1},
            {1.288948, 0, -0.100873, 0, 1.307853, 0, 0.164819, 0, 1},
            {1.247475, 0, -0.096616, 0, 1.264802, 0, 0.154775, 0, 1},
            {1.208317, 0, -0.091453, 0, 1.224510, 0, 0.144569, 0, 1},
            {1.173928, 0, -0.086347, 0, 1.188000, 0, 0.134849, 0, 1},
            {1.141393, 0, -0.082366, 0, 1.155138, 0, 0.125718, 0, 1},
            {1.112421, 0, -0.076983, 0, 1.124588, 0, 0.116446, 0, 1},
            {1.085617, 0, -0.071706, 0, 1.096798, 0, 0.107384, 0, 1},
            {1.061435, 0, -0.067265, 0, 1.071699, 0, 0.098925, 0, 1},
            {1.039405, 0, -0.061565, 0, 1.048640, 0, 0.090198, 0, 1},
            {1.019217, 0, -0.056655, 0, 1.027570, 0, 0.081968, 0, 1},
            {1.000977, 0, -0.051743, 0, 1.008677, 0, 0.074058, 0, 1},
            {0.984202, 0, -0.046389, 0, 0.991082, 0, 0.066087, 0, 1},
            {0.969449, 0, -0.041229, 0, 0.975348, 0, 0.058478, 0, 1},
            {0.955665, 0, -0.036702, 0, 0.961025, 0, 0.051242, 0, 1},
            {0.943725, 0, -0.031285, 0, 0.948032, 0, 0.043797, 0, 1},
            {0.932732, 0, -0.026812, 0, 0.936218, 0, 0.036990, 0, 1},
            {0.922815, 0, -0.021847, 0, 0.925515, 0, 0.030171, 0, 1},
            {0.914039, 0, -0.016994, 0, 0.915852, 0, 0.023478, 0, 1},
            {0.905853, 0, -0.013168, 0, 0.907115, 0, 0.017547, 0, 1},
            {0.898514, 0, -0.007937, 0, 0.899218, 0, 0.011117, 0, 1},
            {0.891748, 0, -0.004133, 0, 0.892026, 0, 0.005548, 0, 1},
            {0.885656, 0, 0.000266, 0, 0.885656, 0, -0.000179, 0, 1},
            {500.137848, 0, -0.176326, 0, 515.448792, 0, 88.187454, 0, 1},
            {500.137848, 0, -0.176326, 0, 515.448792, 0, 88.187454, 0, 1},
            {496.078827, 0, -0.176326, 0, 511.576691, 0, 87.471741, 0, 1},
            {220.496750, 0, -0.176326, 0, 227.360535, 0, 38.879414, 0, 1},
            {124.028099, 0, -0.176326, 0, 127.887680, 0, 21.869419, 0, 1},
            {79.379059, 0, -0.176325, 0, 81.847160, 0, 13.996596, 0, 1},
            {55.123569, 0, -0.176324, 0, 56.838345, 0, 9.719764, 0, 1},
            {40.497410, 0, -0.176323, 0, 41.758190, 0, 7.140716, 0, 1},
            {31.010031, 0, -0.176320, 0, 31.968016, 0, 5.467903, 0, 1},
            {24.498796, 0, -0.176317, 0, 25.258919, 0, 4.319749, 0, 1},
            {19.841389, 0, -0.176311, 0, 20.457605, 0, 3.498529, 0, 1},
            {16.397121, 0, -0.176305, 0, 16.906359, 0, 2.891195, 0, 1},
            {13.776705, 0, -0.176295, 0, 14.203604, 0, 2.429163, 0, 1},
            {11.737144, 0, -0.176283, 0, 12.100784, 0, 2.069515, 0, 1},
            {10.118380, 0, -0.176267, 0, 10.431730, 0, 1.784079, 0, 1},
            {8.812522, 0, -0.176244, 0, 9.085212, 0, 1.553809, 0, 1},
            {7.743594, 0, -0.176213, 0, 7.982780, 0, 1.365311, 0, 1},
            {6.857443, 0, -0.176165, 0, 7.069174, 0, 1.209043, 0, 1},
            {6.115237, 0, -0.176083, 0, 6.303002, 0, 1.078138, 0, 1},
            {5.487206, 0, -0.175914, 0, 5.655299, 0, 0.967364, 0, 1},
            {4.951627, 0, -0.175459, 0, 5.103069, 0, 0.872822, 0, 1},
            {4.494173, 0, -0.173714, 0, 4.631212, 0, 0.791896, 0, 1},
            {4.110331, 0, -0.166438, 0, 4.234978, 0, 0.723129, 0, 1},
            {3.774621, 0, -0.163092, 0, 3.888469, 0, 0.663263, 0, 1},
            {3.481253, 0, -0.163796, 0, 3.585593, 0, 0.611419, 0, 1},
            {3.226119, 0, -0.168430, 0, 3.322400, 0, 0.566981, 0, 1},
            {2.998593, 0, -0.174378, 0, 3.087643, 0, 0.527768, 0, 1},
            {2.781536, 0, -0.172860, 0, 2.863415, 0, 0.489044, 0, 1},
            {2.589859, 0, -0.169774, 0, 2.665395, 0, 0.454364, 0, 1},
            {2.422226, 0, -0.163780, 0, 2.491674, 0, 0.423142, 0, 1},
            {2.271880, 0, -0.159524, 0, 2.336085, 0, 0.395227, 0, 1},
            {2.136761, 0, -0.157259, 0, 2.196419, 0, 0.370258, 0, 1},
            {2.016938, 0, -0.155739, 0, 2.072157, 0, 0.348111, 0, 1},
            {1.910869, 0, -0.153894, 0, 1.961848, 0, 0.328188, 0, 1},
            {1.815034, 0, -0.152270, 0, 1.862665, 0, 0.309955, 0, 1},
            {1.723901, 0, -0.149119, 0, 1.768507, 0, 0.292020, 0, 1},
            {1.641692, 0, -0.144131, 0, 1.682457, 0, 0.274827, 0, 1},
            {1.568958, 0, -0.138928, 0, 1.606070, 0, 0.259001, 0, 1},
            {1.501811, 0, -0.135819, 0, 1.536432, 0, 0.244606, 0, 1},
            {1.441540, 0, -0.132694, 0, 1.473682, 0, 0.231117, 0, 1},
            {1.386211, 0, -0.127474, 0, 1.415470, 0, 0.217634, 0, 1},
            {1.335120, 0, -0.122118, 0, 1.361721, 0, 0.204512, 0, 1},
            {1.289377, 0, -0.116811, 0, 1.313414, 0, 0.192047, 0, 1},
            {1.247203, 0, -0.112536, 0, 1.269721, 0, 0.180439, 0, 1},
            {1.208800, 0, -0.107041, 0, 1.229093, 0, 0.168721, 0, 1},
            {1.173918, 0, -0.100700, 0, 1.191805, 0, 0.157202, 0, 1},
            {1.141539, 0, -0.095628, 0, 1.158289, 0, 0.146366, 0, 1},
            {1.112548, 0, -0.090031, 0, 1.127686, 0, 0.135788, 0, 1},
            {1.085812, 0, -0.083715, 0, 1.099267, 0, 0.125136, 0, 1},
            {1.061281, 0, -0.077684, 0, 1.073643, 0, 0.114829, 0, 1},
            {1.038917, 0, -0.072414, 0, 1.050455, 0, 0.105254, 0, 1},
            {1.019049, 0, -0.065656, 0, 1.029130, 0, 0.095291, 0, 1},
            {1.000216, 0, -0.060083, 0, 1.009833, 0, 0.086050, 0, 1},
            {0.983558, 0, -0.054356, 0, 0.992151, 0, 0.076948, 0, 1},
            {0.968492, 0, -0.048041, 0, 0.976051, 0, 0.068061, 0, 1},
            {0.954849, 0, -0.042631, 0, 0.961450, 0, 0.059557, 0, 1},
            {0.942548, 0, -0.036554, 0, 0.948345, 0, 0.051056, 0, 1},
            {0.931768, 0, -0.030994, 0, 0.936276, 0, 0.042978, 0, 1},
            {0.922134, 0, -0.025629, 0, 0.925676, 0, 0.035135, 0, 1},
            {0.913335, 0, -0.019997, 0, 0.915830, 0, 0.027508, 0, 1},
            {0.905483, 0, -0.014687, 0, 0.907031, 0, 0.020128, 0, 1},
            {0.898067, 0, -0.009774, 0, 0.898977, 0, 0.013180, 0, 1},
            {0.891410, 0, -0.004567, 0, 0.891737, 0, 0.006331, 0, 1},
            {0.885377, 0, 0.000120, 0, 0.885377, 0, -0.000109, 0, 1},
            {500.002136, 0, -0.202154, 0, 520.401855, 0, 101.077248, 0, 1},
            {500.002136, 0, -0.202154, 0, 520.401855, 0, 101.077248, 0, 1},
            {496.121338, 0, -0.202154, 0, 516.361938, 0, 100.292641, 0, 1},
            {220.502655, 0, -0.202153, 0, 229.510117, 0, 44.575531, 0, 1},
            {123.999191, 0, -0.202153, 0, 129.105179, 0, 25.067114, 0, 1},
            {79.376472, 0, -0.202152, 0, 82.622795, 0, 16.046227, 0, 1},
            {55.120224, 0, -0.202151, 0, 57.375393, 0, 11.142715, 0, 1},
            {40.498074, 0, -0.202148, 0, 42.151817, 0, 8.186816, 0, 1},
            {31.005764, 0, -0.202145, 0, 32.273041, 0, 6.267910, 0, 1},
            {24.496655, 0, -0.202139, 0, 25.498249, 0, 4.952050, 0, 1},
            {19.841209, 0, -0.202131, 0, 20.652281, 0, 4.010926, 0, 1},
            {16.396740, 0, -0.202121, 0, 17.065317, 0, 3.314617, 0, 1},
            {13.776087, 0, -0.202107, 0, 14.337918, 0, 2.784805, 0, 1},
            {11.736927, 0, -0.202089, 0, 12.215576, 0, 2.372608, 0, 1},
            {10.117808, 0, -0.202065, 0, 10.530962, 0, 2.045225, 0, 1},
            {8.812817, 0, -0.202034, 0, 9.170947, 0, 1.781436, 0, 1},
            {7.743863, 0, -0.201990, 0, 8.058211, 0, 1.565313, 0, 1},
            {6.857856, 0, -0.201926, 0, 7.135773, 0, 1.386182, 0, 1},
            {6.115432, 0, -0.201820, 0, 6.362723, 0, 1.236057, 0, 1},
            {5.487375, 0, -0.201601, 0, 5.708670, 0, 1.109041, 0, 1},
            {4.952326, 0, -0.200992, 0, 5.151335, 0, 1.000741, 0, 1},
            {4.496054, 0, -0.198467, 0, 4.676206, 0, 0.908137, 0, 1},
            {4.111419, 0, -0.191120, 0, 4.275214, 0, 0.829276, 0, 1},
            {3.773230, 0, -0.188319, 0, 3.922716, 0, 0.760296, 0, 1},
            {3.477818, 0, -0.188648, 0, 3.614793, 0, 0.700339, 0, 1},
            {3.221098, 0, -0.192139, 0, 3.347462, 0, 0.648791, 0, 1},
            {2.995774, 0, -0.198064, 0, 3.112610, 0, 0.604101, 0, 1},
            {2.782646, 0, -0.197759, 0, 2.890333, 0, 0.560737, 0, 1},
            {2.591527, 0, -0.193848, 0, 2.690751, 0, 0.521002, 0, 1},
            {2.423693, 0, -0.187492, 0, 2.514939, 0, 0.485291, 0, 1},
            {2.271948, 0, -0.183692, 0, 2.356494, 0, 0.453180, 0, 1},
            {2.136155, 0, -0.180966, 0, 2.214588, 0, 0.424463, 0, 1},
            {2.016137, 0, -0.178201, 0, 2.088436, 0, 0.398745, 0, 1},
            {1.910310, 0, -0.174738, 0, 1.976897, 0, 0.375515, 0, 1},
            {1.813429, 0, -0.173377, 0, 1.875835, 0, 0.354591, 0, 1},
            {1.724669, 0, -0.171366, 0, 1.782674, 0, 0.334854, 0, 1},
            {1.642285, 0, -0.164999, 0, 1.695323, 0, 0.314955, 0, 1},
            {1.568593, 0, -0.159429, 0, 1.616958, 0, 0.296641, 0, 1},
            {1.501747, 0, -0.155140, 0, 1.546379, 0, 0.279952, 0, 1},
            {1.442147, 0, -0.150522, 0, 1.482591, 0, 0.264179, 0, 1},
            {1.386560, 0, -0.146354, 0, 1.424087, 0, 0.249275, 0, 1},
            {1.336091, 0, -0.139864, 0, 1.369359, 0, 0.234266, 0, 1},
            {1.290110, 0, -0.133329, 0, 1.319812, 0, 0.219634, 0, 1},
            {1.247460, 0, -0.128134, 0, 1.275250, 0, 0.206112, 0, 1},
            {1.210189, 0, -0.122320, 0, 1.234548, 0, 0.192902, 0, 1},
            {1.174714, 0, -0.115431, 0, 1.196491, 0, 0.179668, 0, 1},
            {1.142451, 0, -0.108658, 0, 1.162076, 0, 0.166836, 0, 1},
            {1.112871, 0, -0.102621, 0, 1.131117, 0, 0.154679, 0, 1},
            {1.086229, 0, -0.095825, 0, 1.102497, 0, 0.142680, 0, 1},
            {1.061453, 0, -0.088686, 0, 1.075995, 0, 0.130891, 0, 1},
            {1.038903, 0, -0.082343, 0, 1.052435, 0, 0.119805, 0, 1},
            {1.018590, 0, -0.075305, 0, 1.030991, 0, 0.108658, 0, 1},
            {0.999955, 0, -0.068336, 0, 1.010974, 0, 0.097934, 0, 1},
            {0.983050, 0, -0.061738, 0, 0.993355, 0, 0.087585, 0, 1},
            {0.967750, 0, -0.054981, 0, 0.976869, 0, 0.077547, 0, 1},
            {0.954319, 0, -0.048012, 0, 0.962132, 0, 0.067642, 0, 1},
            {0.941693, 0, -0.042210, 0, 0.948741, 0, 0.058381, 0, 1},
            {0.930924, 0, -0.035178, 0, 0.936629, 0, 0.048898, 0, 1},
            {0.921219, 0, -0.029154, 0, 0.925665, 0, 0.040093, 0, 1},
            {0.912509, 0, -0.023188, 0, 0.915857, 0, 0.031532, 0, 1},
            {0.904780, 0, -0.016546, 0, 0.906863, 0, 0.022884, 0, 1},
            {0.897692, 0, -0.011130, 0, 0.898842, 0, 0.015020, 0, 1},
            {0.891087, 0, -0.005098, 0, 0.891608, 0, 0.007156, 0, 1},
            {0.885051, 0, 0.000194, 0, 0.885016, 0, -0.000143, 0, 1},
            {500.122223, 0, -0.228243, 0, 525.877747, 0, 114.149078, 0, 1},
            {500.122223, 0, -0.228243, 0, 525.877747, 0, 114.149078, 0, 1},
            {496.093170, 0, -0.228243, 0, 521.986084, 0, 113.229523, 0, 1},
            {220.491501, 0, -0.228243, 0, 231.998520, 0, 50.325714, 0, 1},
            {124.052315, 0, -0.228242, 0, 130.483047, 0, 28.314045, 0, 1},
            {79.374489, 0, -0.228241, 0, 83.516861, 0, 18.116611, 0, 1},
            {55.126289, 0, -0.228239, 0, 57.994217, 0, 12.582159, 0, 1},
            {40.494789, 0, -0.228235, 0, 42.608646, 0, 9.242578, 0, 1},
            {31.007071, 0, -0.228230, 0, 32.619976, 0, 7.077108, 0, 1},
            {24.497461, 0, -0.228222, 0, 25.772018, 0, 5.591317, 0, 1},
            {19.841955, 0, -0.228211, 0, 20.874607, 0, 4.528726, 0, 1},
            {16.397472, 0, -0.228196, 0, 17.249781, 0, 3.742531, 0, 1},
            {13.776735, 0, -0.228176, 0, 14.492861, 0, 3.144354, 0, 1},
            {11.737115, 0, -0.228151, 0, 12.346711, 0, 2.678810, 0, 1},
            {10.118634, 0, -0.228118, 0, 10.644080, 0, 2.309386, 0, 1},
            {8.812924, 0, -0.228074, 0, 9.269695, 0, 2.011329, 0, 1},
            {7.744034, 0, -0.228016, 0, 8.144842, 0, 1.767344, 0, 1},
            {6.858088, 0, -0.227931, 0, 7.212428, 0, 1.565093, 0, 1},
            {6.115783, 0, -0.227793, 0, 6.430929, 0, 1.395625, 0, 1},
            {5.487657, 0, -0.227510, 0, 5.769895, 0, 1.252177, 0, 1},
            {4.952886, 0, -0.226687, 0, 5.206831, 0, 1.129947, 0, 1},
            {4.498596, 0, -0.222958, 0, 4.728174, 0, 1.025697, 0, 1},
            {4.111821, 0, -0.216263, 0, 4.320670, 0, 0.936399, 0, 1},
            {3.771975, 0, -0.213770, 0, 3.962561, 0, 0.858223, 0, 1},
            {3.474705, 0, -0.213818, 0, 3.649158, 0, 0.790099, 0, 1},
            {3.217051, 0, -0.216378, 0, 3.377828, 0, 0.731423, 0, 1},
            {2.991493, 0, -0.221334, 0, 3.139953, 0, 0.680570, 0, 1},
            {2.783987, 0, -0.222700, 0, 2.921229, 0, 0.633180, 0, 1},
            {2.593481, 0, -0.217779, 0, 2.719782, 0, 0.588350, 0, 1},
            {2.424382, 0, -0.212017, 0, 2.540804, 0, 0.548022, 0, 1},
            {2.271759, 0, -0.208226, 0, 2.379544, 0, 0.511726, 0, 1},
            {2.135913, 0, -0.204723, 0, 2.235539, 0, 0.479155, 0, 1},
            {2.015712, 0, -0.200659, 0, 2.107507, 0, 0.449816, 0, 1},
            {1.909178, 0, -0.196539, 0, 1.993785, 0, 0.423315, 0, 1},
            {1.812193, 0, -0.194714, 0, 1.891061, 0, 0.399540, 0, 1},
            {1.724654, 0, -0.192304, 0, 1.797391, 0, 0.377470, 0, 1},
            {1.643706, 0, -0.186074, 0, 1.709625, 0, 0.355460, 0, 1},
            {1.569063, 0, -0.180126, 0, 1.629651, 0, 0.334774, 0, 1},
            {1.502403, 0, -0.174491, 0, 1.557406, 0, 0.315483, 0, 1},
            {1.442658, 0, -0.168890, 0, 1.492295, 0, 0.297574, 0, 1},
            {1.387433, 0, -0.164301, 0, 1.432868, 0, 0.280697, 0, 1},
            {1.337891, 0, -0.157574, 0, 1.378132, 0, 0.263940, 0, 1},
            {1.291350, 0, -0.150381, 0, 1.327500, 0, 0.247574, 0, 1},
            {1.249125, 0, -0.143636, 0, 1.281654, 0, 0.231814, 0, 1},
            {1.210989, 0, -0.137179, 0, 1.240054, 0, 0.216849, 0, 1},
            {1.176099, 0, -0.130248, 0, 1.202006, 0, 0.202095, 0, 1},
            {1.143640, 0, -0.122030, 0, 1.166520, 0, 0.187469, 0, 1},
            {1.113656, 0, -0.114914, 0, 1.134639, 0, 0.173427, 0, 1},
            {1.087245, 0, -0.107734, 0, 1.105856, 0, 0.160079, 0, 1},
            {1.062218, 0, -0.099742, 0, 1.078947, 0, 0.146995, 0, 1},
            {1.039564, 0, -0.091852, 0, 1.054720, 0, 0.134005, 0, 1},
            {1.018476, 0, -0.085016, 0, 1.032979, 0, 0.121964, 0, 1},
            {1.000159, 0, -0.076685, 0, 1.012538, 0, 0.109632, 0, 1},
            {0.982598, 0, -0.069218, 0, 0.994354, 0, 0.098101, 0, 1},
            {0.967187, 0, -0.061944, 0, 0.977866, 0, 0.086843, 0, 1},
            {0.953322, 0, -0.054171, 0, 0.962735, 0, 0.075863, 0, 1},
            {0.941093, 0, -0.046914, 0, 0.949198, 0, 0.065247, 0, 1},
            {0.929940, 0, -0.039891, 0, 0.937012, 0, 0.054986, 0, 1},
            {0.920349, 0, -0.032428, 0, 0.925826, 0, 0.044881, 0, 1},
            {0.911883, 0, -0.025649, 0, 0.915800, 0, 0.035198, 0, 1},
            {0.904131, 0, -0.019146, 0, 0.906757, 0, 0.025940, 0, 1},
            {0.897232, 0, -0.012147, 0, 0.898667, 0, 0.016695, 0, 1},
            {0.890751, 0, -0.006171, 0, 0.891334, 0, 0.008220, 0, 1},
            {0.884623, 0, 0.000406, 0, 0.884599, 0, -0.000256, 0, 1},
            {500.103027, 0, -0.254630, 0, 532.306519, 0, 127.341362, 0, 1},
            {500.103027, 0, -0.254630, 0, 532.306519, 0, 127.341362, 0, 1},
            {496.100189, 0, -0.254631, 0, 528.302429, 0, 126.321968, 0, 1},
            {220.501587, 0, -0.254630, 0, 234.797379, 0, 56.146561, 0, 1},
            {124.030739, 0, -0.254629, 0, 132.072113, 0, 31.581966, 0, 1},
            {79.376091, 0, -0.254627, 0, 84.526520, 0, 20.211533, 0, 1},
            {55.118771, 0, -0.254625, 0, 58.700134, 0, 14.034864, 0, 1},
            {40.498608, 0, -0.254620, 0, 43.125511, 0, 10.312164, 0, 1},
            {31.003874, 0, -0.254612, 0, 33.016865, 0, 7.894447, 0, 1},
            {24.497622, 0, -0.254601, 0, 26.084778, 0, 6.237792, 0, 1},
            {19.841394, 0, -0.254587, 0, 21.127436, 0, 5.052134, 0, 1},
            {16.397062, 0, -0.254565, 0, 17.458454, 0, 4.175098, 0, 1},
            {13.776876, 0, -0.254539, 0, 14.667887, 0, 3.507907, 0, 1},
            {11.737298, 0, -0.254504, 0, 12.496222, 0, 2.988537, 0, 1},
            {10.118900, 0, -0.254459, 0, 10.772487, 0, 2.576407, 0, 1},
            {8.813082, 0, -0.254400, 0, 9.381595, 0, 2.243875, 0, 1},
            {7.744377, 0, -0.254323, 0, 8.242908, 0, 1.971711, 0, 1},
            {6.858314, 0, -0.254213, 0, 7.299338, 0, 1.746056, 0, 1},
            {6.116047, 0, -0.254036, 0, 6.508431, 0, 1.556966, 0, 1},
            {5.488258, 0, -0.253672, 0, 5.839362, 0, 1.397014, 0, 1},
            {4.953928, 0, -0.252536, 0, 5.269868, 0, 1.260769, 0, 1},
            {4.502042, 0, -0.246960, 0, 4.787960, 0, 1.144903, 0, 1},
            {4.111449, 0, -0.241994, 0, 4.371355, 0, 1.044598, 0, 1},
            {3.770156, 0, -0.239634, 0, 4.007247, 0, 0.957071, 0, 1},
            {3.471863, 0, -0.239300, 0, 3.688913, 0, 0.880745, 0, 1},
            {3.212559, 0, -0.240961, 0, 3.412190, 0, 0.814673, 0, 1},
            {2.986591, 0, -0.244737, 0, 3.171037, 0, 0.757477, 0, 1},
            {2.785418, 0, -0.247656, 0, 2.956166, 0, 0.706487, 0, 1},
            {2.595679, 0, -0.241602, 0, 2.752573, 0, 0.656518, 0, 1},
            {2.425078, 0, -0.236800, 0, 2.569859, 0, 0.611459, 0, 1},
            {2.271984, 0, -0.232837, 0, 2.405893, 0, 0.570904, 0, 1},
            {2.135780, 0, -0.228497, 0, 2.259562, 0, 0.534347, 0, 1},
            {2.015866, 0, -0.223057, 0, 2.129377, 0, 0.501389, 0, 1},
            {1.908273, 0, -0.218877, 0, 2.013013, 0, 0.471732, 0, 1},
            {1.811260, 0, -0.215926, 0, 1.908179, 0, 0.444832, 0, 1},
            {1.725002, 0, -0.212658, 0, 1.813764, 0, 0.420265, 0, 1},
            {1.645228, 0, -0.207778, 0, 1.726113, 0, 0.396551, 0, 1},
            {1.570355, 0, -0.200955, 0, 1.644067, 0, 0.373226, 0, 1},
            {1.504491, 0, -0.193737, 0, 1.570159, 0, 0.351686, 0, 1},
            {1.443768, 0, -0.187609, 0, 1.503430, 0, 0.331315, 0, 1},
            {1.389422, 0, -0.181798, 0, 1.443022, 0, 0.312214, 0, 1},
            {1.340532, 0, -0.175411, 0, 1.387548, 0, 0.293937, 0, 1},
            {1.294192, 0, -0.167390, 0, 1.336115, 0, 0.275390, 0, 1},
            {1.251942, 0, -0.159030, 0, 1.288808, 0, 0.257580, 0, 1},
            {1.212910, 0, -0.151889, 0, 1.246415, 0, 0.240685, 0, 1},
            {1.178843, 0, -0.144487, 0, 1.207720, 0, 0.224191, 0, 1},
            {1.145883, 0, -0.135860, 0, 1.171619, 0, 0.208076, 0, 1},
            {1.115708, 0, -0.127168, 0, 1.138902, 0, 0.192163, 0, 1},
            {1.088149, 0, -0.119284, 0, 1.109597, 0, 0.177288, 0, 1},
            {1.063894, 0, -0.110899, 0, 1.082339, 0, 0.162657, 0, 1},
            {1.040087, 0, -0.101909, 0, 1.057316, 0, 0.148334, 0, 1},
            {1.019179, 0, -0.093683, 0, 1.034936, 0, 0.134590, 0, 1},
            {1.000154, 0, -0.085460, 0, 1.014711, 0, 0.121574, 0, 1},
            {0.982812, 0, -0.076492, 0, 0.995743, 0, 0.108528, 0, 1},
            {0.966830, 0, -0.068357, 0, 0.979060, 0, 0.095997, 0, 1},
            {0.952733, 0, -0.060522, 0, 0.963675, 0, 0.084182, 0, 1},
            {0.940343, 0, -0.051711, 0, 0.949730, 0, 0.072128, 0, 1},
            {0.928987, 0, -0.044153, 0, 0.937170, 0, 0.060903, 0, 1},
            {0.919374, 0, -0.036123, 0, 0.926009, 0, 0.049763, 0, 1},
            {0.910883, 0, -0.028427, 0, 0.915768, 0, 0.039010, 0, 1},
            {0.903483, 0, -0.021144, 0, 0.906677, 0, 0.028717, 0, 1},
            {0.896611, 0, -0.013532, 0, 0.898392, 0, 0.018558, 0, 1},
            {0.890131, 0, -0.006580, 0, 0.890875, 0, 0.009008, 0, 1},
            {0.884366, 0, 0.000233, 0, 0.884355, 0, -0.000117, 0, 1},
            {500.085388, 0, -0.281355, 0, 539.498718, 0, 140.701538, 0, 1},
            {500.085388, 0, -0.281355, 0, 539.498718, 0, 140.701538, 0, 1},
            {496.129486, 0, -0.281355, 0, 535.442322, 0, 139.588684, 0, 1},
            {220.504822, 0, -0.281355, 0, 237.947388, 0, 62.040401, 0, 1},
            {124.021149, 0, -0.281354, 0, 133.850250, 0, 34.894020, 0, 1},
            {79.382919, 0, -0.281351, 0, 85.656876, 0, 22.334780, 0, 1},
            {55.149910, 0, -0.281347, 0, 59.449463, 0, 15.516068, 0, 1},
            {40.500046, 0, -0.281341, 0, 43.702549, 0, 11.394857, 0, 1},
            {31.005716, 0, -0.281331, 0, 33.458839, 0, 8.723551, 0, 1},
            {24.495970, 0, -0.281317, 0, 26.436306, 0, 6.891986, 0, 1},
            {19.841774, 0, -0.281296, 0, 21.410387, 0, 5.582484, 0, 1},
            {16.397760, 0, -0.281269, 0, 17.692585, 0, 4.613454, 0, 1},
            {13.777157, 0, -0.281232, 0, 14.865791, 0, 3.876162, 0, 1},
            {11.739849, 0, -0.281186, 0, 12.664932, 0, 3.302845, 0, 1},
            {10.119039, 0, -0.281126, 0, 10.916929, 0, 2.846814, 0, 1},
            {8.813169, 0, -0.281049, 0, 9.507375, 0, 2.479377, 0, 1},
            {7.744403, 0, -0.280948, 0, 8.353477, 0, 2.178619, 0, 1},
            {6.858627, 0, -0.280807, 0, 7.396985, 0, 1.929334, 0, 1},
            {6.116360, 0, -0.280583, 0, 6.595296, 0, 1.720405, 0, 1},
            {5.488473, 0, -0.280110, 0, 5.917017, 0, 1.543655, 0, 1},
            {4.954888, 0, -0.278502, 0, 5.340717, 0, 1.393211, 0, 1},
            {4.503970, 0, -0.271941, 0, 4.853060, 0, 1.265407, 0, 1},
            {4.111181, 0, -0.267891, 0, 4.428566, 0, 1.154133, 0, 1},
            {3.768369, 0, -0.265773, 0, 4.057742, 0, 1.057074, 0, 1},
            {3.469303, 0, -0.265095, 0, 3.734051, 0, 0.972462, 0, 1},
            {3.208770, 0, -0.265972, 0, 3.452065, 0, 0.898932, 0, 1},
            {2.982601, 0, -0.268632, 0, 3.207271, 0, 0.835382, 0, 1},
            {2.783643, 0, -0.271034, 0, 2.991666, 0, 0.779474, 0, 1},
            {2.597197, 0, -0.266337, 0, 2.788484, 0, 0.725532, 0, 1},
            {2.425579, 0, -0.261946, 0, 2.602286, 0, 0.675694, 0, 1},
            {2.272363, 0, -0.257507, 0, 2.435682, 0, 0.630789, 0, 1},
            {2.136257, 0, -0.252249, 0, 2.286722, 0, 0.590288, 0, 1},
            {2.016254, 0, -0.245987, 0, 2.153961, 0, 0.553734, 0, 1},
            {1.907715, 0, -0.241477, 0, 2.034765, 0, 0.520631, 0, 1},
            {1.811054, 0, -0.237456, 0, 1.927814, 0, 0.490697, 0, 1},
            {1.725645, 0, -0.232799, 0, 1.831199, 0, 0.463338, 0, 1},
            {1.647041, 0, -0.228883, 0, 1.743480, 0, 0.437833, 0, 1},
            {1.573429, 0, -0.221666, 0, 1.660221, 0, 0.412361, 0, 1},
            {1.507411, 0, -0.213485, 0, 1.584587, 0, 0.388152, 0, 1},
            {1.446732, 0, -0.206352, 0, 1.516284, 0, 0.365515, 0, 1},
            {1.392234, 0, -0.199052, 0, 1.453997, 0, 0.343852, 0, 1},
            {1.342587, 0, -0.192529, 0, 1.397789, 0, 0.323495, 0, 1},
            {1.299102, 0, -0.184474, 0, 1.345410, 0, 0.303644, 0, 1},
            {1.255443, 0, -0.175094, 0, 1.297125, 0, 0.283501, 0, 1},
            {1.216458, 0, -0.166503, 0, 1.253496, 0, 0.264238, 0, 1},
            {1.181663, 0, -0.158164, 0, 1.213940, 0, 0.246031, 0, 1},
            {1.149839, 0, -0.149660, 0, 1.177642, 0, 0.228438, 0, 1},
            {1.118388, 0, -0.139728, 0, 1.143770, 0, 0.210864, 0, 1},
            {1.090139, 0, -0.130611, 0, 1.113322, 0, 0.194271, 0, 1},
            {1.065430, 0, -0.121766, 0, 1.086090, 0, 0.178163, 0, 1},
            {1.041704, 0, -0.112248, 0, 1.060429, 0, 0.162552, 0, 1},
            {1.019805, 0, -0.102431, 0, 1.037337, 0, 0.147282, 0, 1},
            {1.000136, 0, -0.093689, 0, 1.016569, 0, 0.133074, 0, 1},
            {0.982816, 0, -0.084240, 0, 0.997568, 0, 0.118970, 0, 1},
            {0.966497, 0, -0.074905, 0, 0.980175, 0, 0.105174, 0, 1},
            {0.952294, 0, -0.065937, 0, 0.964740, 0, 0.091903, 0, 1},
            {0.939346, 0, -0.057105, 0, 0.950457, 0, 0.079127, 0, 1},
            {0.928469, 0, -0.048083, 0, 0.937540, 0, 0.066597, 0, 1},
            {0.918467, 0, -0.039785, 0, 0.926216, 0, 0.054651, 0, 1},
            {0.909924, 0, -0.031266, 0, 0.915738, 0, 0.042831, 0, 1},
            {0.902773, 0, -0.022766, 0, 0.906595, 0, 0.031309, 0, 1},
            {0.895922, 0, -0.015399, 0, 0.898194, 0, 0.020658, 0, 1},
            {0.889737, 0, -0.006970, 0, 0.890620, 0, 0.009789, 0, 1},
            {0.883759, 0, 0.000554, 0, 0.883808, 0, -0.000305, 0, 1},
            {500.004059, 0, -0.308458, 0, 547.499817, 0, 154.230072, 0, 1},
            {500.004059, 0, -0.308458, 0, 547.499817, 0, 154.230072, 0, 1},
            {496.133301, 0, -0.308458, 0, 543.290894, 0, 153.036163, 0, 1},
            {220.502060, 0, -0.308457, 0, 241.478271, 0, 68.015839, 0, 1},
            {124.038658, 0, -0.308455, 0, 135.831497, 0, 38.260685, 0, 1},
            {79.373352, 0, -0.308453, 0, 86.937347, 0, 24.483274, 0, 1},
            {55.120831, 0, -0.308448, 0, 60.371891, 0, 17.002504, 0, 1},
            {40.501167, 0, -0.308439, 0, 44.350986, 0, 12.492838, 0, 1},
            {31.007027, 0, -0.308426, 0, 33.955410, 0, 9.564268, 0, 1},
            {24.496967, 0, -0.308407, 0, 26.827276, 0, 7.556172, 0, 1},
            {19.841742, 0, -0.308381, 0, 21.728579, 0, 6.120216, 0, 1},
            {16.396502, 0, -0.308344, 0, 17.953857, 0, 5.057411, 0, 1},
            {13.777060, 0, -0.308297, 0, 15.084830, 0, 4.249446, 0, 1},
            {11.737354, 0, -0.308236, 0, 12.851175, 0, 3.620251, 0, 1},
            {10.119093, 0, -0.308158, 0, 11.078324, 0, 3.121022, 0, 1},
            {8.813456, 0, -0.308059, 0, 9.647766, 0, 2.718237, 0, 1},
            {7.744670, 0, -0.307930, 0, 8.476608, 0, 2.388505, 0, 1},
            {6.858791, 0, -0.307751, 0, 7.506066, 0, 2.115157, 0, 1},
            {6.116662, 0, -0.307467, 0, 6.692422, 0, 1.886139, 0, 1},
            {5.489186, 0, -0.306847, 0, 6.004448, 0, 1.692433, 0, 1},
            {4.956407, 0, -0.304492, 0, 5.420118, 0, 1.527707, 0, 1},
            {4.504546, 0, -0.297869, 0, 4.924323, 0, 1.387340, 0, 1},
            {4.110711, 0, -0.294196, 0, 4.491868, 0, 1.265113, 0, 1},
            {3.766632, 0, -0.292215, 0, 4.114164, 0, 1.158363, 0, 1},
            {3.466798, 0, -0.291212, 0, 3.784793, 0, 1.065333, 0, 1},
            {3.205278, 0, -0.291376, 0, 3.497379, 0, 0.984259, 0, 1},
            {2.977990, 0, -0.292664, 0, 3.247300, 0, 0.913924, 0, 1},
            {2.780754, 0, -0.293825, 0, 3.029927, 0, 0.852807, 0, 1},
            {2.598023, 0, -0.291780, 0, 2.827943, 0, 0.795426, 0, 1},
            {2.426359, 0, -0.287189, 0, 2.638381, 0, 0.740788, 0, 1},
            {2.273150, 0, -0.282217, 0, 2.468720, 0, 0.691511, 0, 1},
            {2.137629, 0, -0.275934, 0, 2.316854, 0, 0.647072, 0, 1},
            {2.016649, 0, -0.269536, 0, 2.180969, 0, 0.606828, 0, 1},
            {1.908316, 0, -0.264354, 0, 2.059195, 0, 0.570376, 0, 1},
            {1.811435, 0, -0.259004, 0, 1.949594, 0, 0.537145, 0, 1},
            {1.726024, 0, -0.253698, 0, 1.851022, 0, 0.506971, 0, 1},
            {1.646184, 0, -0.249188, 0, 1.761314, 0, 0.478495, 0, 1},
            {1.575210, 0, -0.242344, 0, 1.677494, 0, 0.451335, 0, 1},
            {1.508448, 0, -0.233604, 0, 1.600387, 0, 0.424862, 0, 1},
            {1.447650, 0, -0.225295, 0, 1.529939, 0, 0.399420, 0, 1},
            {1.393654, 0, -0.216970, 0, 1.465873, 0, 0.375509, 0, 1},
            {1.344273, 0, -0.209296, 0, 1.408222, 0, 0.352670, 0, 1},
            {1.301307, 0, -0.201157, 0, 1.355528, 0, 0.331085, 0, 1},
            {1.257490, 0, -0.191377, 0, 1.306143, 0, 0.309278, 0, 1},
            {1.218765, 0, -0.181237, 0, 1.260903, 0, 0.287959, 0, 1},
            {1.184050, 0, -0.172065, 0, 1.220422, 0, 0.267983, 0, 1},
            {1.153910, 0, -0.162713, 0, 1.183954, 0, 0.248840, 0, 1},
            {1.121970, 0, -0.152483, 0, 1.149423, 0, 0.229599, 0, 1},
            {1.093292, 0, -0.141802, 0, 1.118023, 0, 0.210850, 0, 1},
            {1.066901, 0, -0.132184, 0, 1.089554, 0, 0.193371, 0, 1},
            {1.044133, 0, -0.122252, 0, 1.063750, 0, 0.176534, 0, 1},
            {1.020997, 0, -0.111558, 0, 1.040082, 0, 0.160080, 0, 1},
            {1.000942, 0, -0.101469, 0, 1.018656, 0, 0.144094, 0, 1},
            {0.982803, 0, -0.091778, 0, 0.999520, 0, 0.128977, 0, 1},
            {0.966798, 0, -0.081454, 0, 0.981585, 0, 0.114236, 0, 1},
            {0.951777, 0, -0.071569, 0, 0.965495, 0, 0.099797, 0, 1},
            {0.938715, 0, -0.062319, 0, 0.951172, 0, 0.086088, 0, 1},
            {0.927341, 0, -0.052435, 0, 0.938074, 0, 0.072465, 0, 1},
            {0.917571, 0, -0.042911, 0, 0.926259, 0, 0.059213, 0, 1},
            {0.909057, 0, -0.034213, 0, 0.915905, 0, 0.046631, 0, 1},
            {0.901856, 0, -0.024780, 0, 0.906398, 0, 0.034085, 0, 1},
            {0.895258, 0, -0.016189, 0, 0.897839, 0, 0.022177, 0, 1},
            {0.889168, 0, -0.008146, 0, 0.890250, 0, 0.010948, 0, 1},
            {0.883230, 0, 0.000466, 0, 0.883192, 0, -0.000240, 0, 1},
            {499.963531, 0, -0.335981, 0, 556.524414, 0, 167.978119, 0, 1},
            {499.963531, 0, -0.335981, 0, 556.524414, 0, 167.978119, 0, 1},
            {495.969940, 0, -0.335980, 0, 552.236511, 0, 166.636154, 0, 1},
            {220.496994, 0, -0.335980, 0, 245.397583, 0, 74.082863, 0, 1},
            {124.029747, 0, -0.335978, 0, 138.030594, 0, 41.671597, 0, 1},
            {79.380211, 0, -0.335974, 0, 88.337929, 0, 26.670174, 0, 1},
            {55.124668, 0, -0.335967, 0, 61.346493, 0, 18.520765, 0, 1},
            {40.500416, 0, -0.335957, 0, 45.064106, 0, 13.607367, 0, 1},
            {31.006538, 0, -0.335939, 0, 34.504578, 0, 10.417412, 0, 1},
            {24.497702, 0, -0.335915, 0, 27.260410, 0, 8.230656, 0, 1},
            {19.842403, 0, -0.335880, 0, 22.079950, 0, 6.666481, 0, 1},
            {16.396784, 0, -0.335834, 0, 18.246504, 0, 5.508804, 0, 1},
            {13.776938, 0, -0.335773, 0, 15.328876, 0, 4.628520, 0, 1},
            {11.737518, 0, -0.335695, 0, 13.059061, 0, 3.943273, 0, 1},
            {10.118959, 0, -0.335595, 0, 11.257472, 0, 3.399409, 0, 1},
            {8.813545, 0, -0.335469, 0, 9.803328, 0, 2.960751, 0, 1},
            {7.744760, 0, -0.335306, 0, 8.613284, 0, 2.601569, 0, 1},
            {6.858911, 0, -0.335081, 0, 7.626686, 0, 2.303839, 0, 1},
            {6.116867, 0, -0.334722, 0, 6.799984, 0, 2.054390, 0, 1},
            {5.489538, 0, -0.333899, 0, 6.100828, 0, 1.843467, 0, 1},
            {4.958295, 0, -0.330330, 0, 5.508531, 0, 1.664420, 0, 1},
            {4.504887, 0, -0.324234, 0, 5.002817, 0, 1.511109, 0, 1},
            {4.109335, 0, -0.321090, 0, 4.561582, 0, 1.377486, 0, 1},
            {3.764962, 0, -0.318983, 0, 4.176945, 0, 1.261108, 0, 1},
            {3.464554, 0, -0.317661, 0, 3.841364, 0, 1.159541, 0, 1},
            {3.202218, 0, -0.317137, 0, 3.548244, 0, 1.070838, 0, 1},
            {2.974161, 0, -0.317094, 0, 3.293050, 0, 0.993661, 0, 1},
            {2.776942, 0, -0.316438, 0, 3.071263, 0, 0.926642, 0, 1},
            {2.598937, 0, -0.317193, 0, 2.870964, 0, 0.866299, 0, 1},
            {2.427425, 0, -0.312590, 0, 2.678270, 0, 0.806866, 0, 1},
            {2.274718, 0, -0.306936, 0, 2.505201, 0, 0.753265, 0, 1},
            {2.139724, 0, -0.299649, 0, 2.350118, 0, 0.704787, 0, 1},
            {2.017244, 0, -0.293404, 0, 2.210779, 0, 0.660614, 0, 1},
            {1.907668, 0, -0.287240, 0, 2.086214, 0, 0.620401, 0, 1},
            {1.811692, 0, -0.280550, 0, 1.974219, 0, 0.584016, 0, 1},
            {1.724951, 0, -0.274917, 0, 1.872771, 0, 0.550807, 0, 1},
            {1.646035, 0, -0.269329, 0, 1.780547, 0, 0.519510, 0, 1},
            {1.576869, 0, -0.262878, 0, 1.695965, 0, 0.490367, 0, 1},
            {1.510845, 0, -0.253765, 0, 1.617368, 0, 0.461647, 0, 1},
            {1.450702, 0, -0.244095, 0, 1.544855, 0, 0.433864, 0, 1},
            {1.395025, 0, -0.235015, 0, 1.479174, 0, 0.407386, 0, 1},
            {1.346266, 0, -0.225913, 0, 1.419951, 0, 0.382305, 0, 1},
            {1.302227, 0, -0.217139, 0, 1.366424, 0, 0.358755, 0, 1},
            {1.261261, 0, -0.207478, 0, 1.316138, 0, 0.335440, 0, 1},
            {1.222082, 0, -0.196285, 0, 1.269962, 0, 0.312482, 0, 1},
            {1.185929, 0, -0.185691, 0, 1.228030, 0, 0.290027, 0, 1},
            {1.153747, 0, -0.175477, 0, 1.190625, 0, 0.269032, 0, 1},
            {1.125762, 0, -0.165237, 0, 1.155834, 0, 0.248998, 0, 1},
            {1.096721, 0, -0.153589, 0, 1.123515, 0, 0.228308, 0, 1},
            {1.069360, 0, -0.142489, 0, 1.094246, 0, 0.209027, 0, 1},
            {1.045367, 0, -0.131878, 0, 1.067532, 0, 0.190257, 0, 1},
            {1.023498, 0, -0.120932, 0, 1.043118, 0, 0.172562, 0, 1},
            {1.001724, 0, -0.109595, 0, 1.020579, 0, 0.155437, 0, 1},
            {0.983142, 0, -0.098630, 0, 1.001269, 0, 0.138937, 0, 1},
            {0.966655, 0, -0.088558, 0, 0.983110, 0, 0.123324, 0, 1},
            {0.951723, 0, -0.077180, 0, 0.966699, 0, 0.107542, 0, 1},
            {0.938071, 0, -0.066745, 0, 0.951660, 0, 0.092593, 0, 1},
            {0.926456, 0, -0.057052, 0, 0.938666, 0, 0.078171, 0, 1},
            {0.916660, 0, -0.046150, 0, 0.926532, 0, 0.063782, 0, 1},
            {0.908106, 0, -0.036718, 0, 0.915869, 0, 0.050231, 0, 1},
            {0.901014, 0, -0.027080, 0, 0.906376, 0, 0.036927, 0, 1},
            {0.894417, 0, -0.017603, 0, 0.897523, 0, 0.024040, 0, 1},
            {0.888523, 0, -0.008631, 0, 0.889810, 0, 0.011757, 0, 1},
            {0.882652, 0, 0.000441, 0, 0.882652, 0, -0.000229, 0, 1},
            {499.968231, 0, -0.363969, 0, 566.297241, 0, 181.972702, 0, 1},
            {499.968231, 0, -0.363969, 0, 566.297241, 0, 181.972702, 0, 1},
            {496.146088, 0, -0.363969, 0, 561.857544, 0, 180.581558, 0, 1},
            {220.504272, 0, -0.363968, 0, 249.704727, 0, 80.256622, 0, 1},
            {124.030128, 0, -0.363966, 0, 140.464020, 0, 45.143036, 0, 1},
            {79.378242, 0, -0.363961, 0, 89.894493, 0, 28.891125, 0, 1},
            {55.123013, 0, -0.363952, 0, 62.429966, 0, 20.062996, 0, 1},
            {40.498146, 0, -0.363938, 0, 45.862816, 0, 14.739956, 0, 1},
            {31.005125, 0, -0.363917, 0, 35.114017, 0, 11.284781, 0, 1},
            {24.498278, 0, -0.363885, 0, 27.739168, 0, 8.916480, 0, 1},
            {19.842779, 0, -0.363842, 0, 22.467678, 0, 7.221962, 0, 1},
            {16.396282, 0, -0.363782, 0, 18.565359, 0, 5.967456, 0, 1},
            {13.777002, 0, -0.363706, 0, 15.598725, 0, 5.014091, 0, 1},
            {11.737373, 0, -0.363606, 0, 13.288247, 0, 4.271647, 0, 1},
            {10.119102, 0, -0.363481, 0, 11.454740, 0, 3.682573, 0, 1},
            {8.813531, 0, -0.363323, 0, 9.975114, 0, 3.207305, 0, 1},
            {7.744850, 0, -0.363118, 0, 8.763934, 0, 2.818219, 0, 1},
            {6.859071, 0, -0.362839, 0, 7.760055, 0, 2.495710, 0, 1},
            {6.117049, 0, -0.362386, 0, 6.918628, 0, 2.225478, 0, 1},
            {5.490108, 0, -0.361265, 0, 6.207444, 0, 1.997018, 0, 1},
            {4.960614, 0, -0.355924, 0, 5.606764, 0, 1.803529, 0, 1},
            {4.504549, 0, -0.351189, 0, 5.088837, 0, 1.636706, 0, 1},
            {4.108239, 0, -0.348333, 0, 4.638559, 0, 1.491735, 0, 1},
            {3.763214, 0, -0.346106, 0, 4.246560, 0, 1.365421, 0, 1},
            {3.462314, 0, -0.344456, 0, 3.904105, 0, 1.255177, 0, 1},
            {3.199532, 0, -0.343225, 0, 3.605123, 0, 1.158787, 0, 1},
            {2.971133, 0, -0.341804, 0, 3.344415, 0, 1.074774, 0, 1},
            {2.772751, 0, -0.340274, 0, 3.116952, 0, 1.001515, 0, 1},
            {2.596363, 0, -0.341637, 0, 2.914270, 0, 0.936749, 0, 1},
            {2.429267, 0, -0.338366, 0, 2.721623, 0, 0.874241, 0, 1},
            {2.276716, 0, -0.331707, 0, 2.545249, 0, 0.816045, 0, 1},
            {2.139614, 0, -0.324164, 0, 2.386361, 0, 0.762833, 0, 1},
            {2.017068, 0, -0.317407, 0, 2.243773, 0, 0.714914, 0, 1},
            {1.909117, 0, -0.310076, 0, 2.115968, 0, 0.671554, 0, 1},
            {1.811493, 0, -0.302688, 0, 2.000518, 0, 0.631529, 0, 1},
            {1.724347, 0, -0.296097, 0, 1.896322, 0, 0.594904, 0, 1},
            {1.648275, 0, -0.289193, 0, 1.801607, 0, 0.561194, 0, 1},
            {1.578603, 0, -0.282627, 0, 1.715451, 0, 0.529671, 0, 1},
            {1.515418, 0, -0.274036, 0, 1.636306, 0, 0.499329, 0, 1},
            {1.454588, 0, -0.263284, 0, 1.561852, 0, 0.468878, 0, 1},
            {1.398949, 0, -0.253081, 0, 1.494254, 0, 0.440075, 0, 1},
            {1.349936, 0, -0.242881, 0, 1.433237, 0, 0.413068, 0, 1},
            {1.304861, 0, -0.233360, 0, 1.378308, 0, 0.387099, 0, 1},
            {1.265099, 0, -0.223168, 0, 1.328517, 0, 0.362542, 0, 1},
            {1.224683, 0, -0.211487, 0, 1.280142, 0, 0.337065, 0, 1},
            {1.188010, 0, -0.199550, 0, 1.236707, 0, 0.312683, 0, 1},
            {1.156214, 0, -0.188218, 0, 1.198166, 0, 0.289877, 0, 1},
            {1.127514, 0, -0.177076, 0, 1.162704, 0, 0.267919, 0, 1},
            {1.097764, 0, -0.165343, 0, 1.129468, 0, 0.245598, 0, 1},
            {1.072534, 0, -0.152843, 0, 1.099195, 0, 0.224450, 0, 1},
            {1.047298, 0, -0.141324, 0, 1.071817, 0, 0.204210, 0, 1},
            {1.025331, 0, -0.129715, 0, 1.046660, 0, 0.184897, 0, 1},
            {1.003407, 0, -0.117908, 0, 1.023641, 0, 0.166445, 0, 1},
            {0.984019, 0, -0.105527, 0, 1.003265, 0, 0.148492, 0, 1},
            {0.966239, 0, -0.094785, 0, 0.984484, 0, 0.131894, 0, 1},
            {0.951617, 0, -0.082853, 0, 0.968104, 0, 0.115195, 0, 1},
            {0.937585, 0, -0.071767, 0, 0.952411, 0, 0.099140, 0, 1},
            {0.925780, 0, -0.060710, 0, 0.939094, 0, 0.083724, 0, 1},
            {0.915454, 0, -0.050148, 0, 0.926720, 0, 0.068595, 0, 1},
            {0.907022, 0, -0.039372, 0, 0.915744, 0, 0.053866, 0, 1},
            {0.900234, 0, -0.028820, 0, 0.906250, 0, 0.039533, 0, 1},
            {0.893538, 0, -0.019208, 0, 0.897160, 0, 0.025980, 0, 1},
            {0.887857, 0, -0.008673, 0, 0.889286, 0, 0.012327, 0, 1},
            {0.882119, 0, 0.000182, 0, 0.882073, 0, -0.000104, 0, 1},
            {499.895782, 0, -0.392469, 0, 577.124207, 0, 196.193802, 0, 1},
            {499.895782, 0, -0.392469, 0, 577.124207, 0, 196.193802, 0, 1},
            {496.178070, 0, -0.392469, 0, 572.483826, 0, 194.734726, 0, 1},
            {220.505005, 0, -0.392468, 0, 254.459412, 0, 86.541306, 0, 1},
            {124.066757, 0, -0.392465, 0, 143.123749, 0, 48.692413, 0, 1},
            {79.377106, 0, -0.392460, 0, 91.606567, 0, 31.153023, 0, 1},
            {55.125988, 0, -0.392448, 0, 63.613686, 0, 21.635195, 0, 1},
            {40.497841, 0, -0.392431, 0, 46.736820, 0, 15.894069, 0, 1},
            {31.004784, 0, -0.392404, 0, 35.781277, 0, 12.168279, 0, 1},
            {24.498316, 0, -0.392365, 0, 28.267958, 0, 9.614630, 0, 1},
            {19.842012, 0, -0.392310, 0, 22.895582, 0, 7.787116, 0, 1},
            {16.393692, 0, -0.392236, 0, 18.921135, 0, 6.433811, 0, 1},
            {13.776231, 0, -0.392140, 0, 15.895071, 0, 5.406358, 0, 1},
            {11.737317, 0, -0.392017, 0, 13.540437, 0, 4.606046, 0, 1},
            {10.119299, 0, -0.391860, 0, 11.671990, 0, 3.970945, 0, 1},
            {8.813539, 0, -0.391663, 0, 10.164061, 0, 3.458361, 0, 1},
            {7.744664, 0, -0.391410, 0, 8.929850, 0, 3.038735, 0, 1},
            {6.859041, 0, -0.391064, 0, 7.906443, 0, 2.690988, 0, 1},
            {6.117191, 0, -0.390493, 0, 7.049109, 0, 2.399647, 0, 1},
            {5.490591, 0, -0.388913, 0, 6.324887, 0, 2.153405, 0, 1},
            {4.961344, 0, -0.382807, 0, 5.712574, 0, 1.944774, 0, 1},
            {4.503645, 0, -0.378847, 0, 5.182839, 0, 1.764357, 0, 1},
            {4.106829, 0, -0.375953, 0, 4.723369, 0, 1.607849, 0, 1},
            {3.761420, 0, -0.373613, 0, 4.322923, 0, 1.471496, 0, 1},
            {3.459984, 0, -0.371609, 0, 3.973384, 0, 1.352316, 0, 1},
            {3.197148, 0, -0.369602, 0, 3.667831, 0, 1.248221, 0, 1},
            {2.968586, 0, -0.366670, 0, 3.401501, 0, 1.157259, 0, 1},
            {2.769268, 0, -0.365084, 0, 3.167947, 0, 1.077879, 0, 1},
            {2.593266, 0, -0.365885, 0, 2.960350, 0, 1.007893, 0, 1},
            {2.429741, 0, -0.364240, 0, 2.769236, 0, 0.942258, 0, 1},
            {2.278213, 0, -0.356507, 0, 2.588331, 0, 0.879522, 0, 1},
            {2.140011, 0, -0.349117, 0, 2.425995, 0, 0.822054, 0, 1},
            {2.017176, 0, -0.341723, 0, 2.279764, 0, 0.770096, 0, 1},
            {1.910110, 0, -0.333101, 0, 2.148236, 0, 0.723308, 0, 1},
            {1.812697, 0, -0.325185, 0, 2.029458, 0, 0.679938, 0, 1},
            {1.726252, 0, -0.317534, 0, 1.921885, 0, 0.640257, 0, 1},
            {1.650866, 0, -0.309423, 0, 1.824884, 0, 0.603797, 0, 1},
            {1.581178, 0, -0.302480, 0, 1.737038, 0, 0.569681, 0, 1},
            {1.519795, 0, -0.293708, 0, 1.656026, 0, 0.537762, 0, 1},
            {1.458826, 0, -0.282751, 0, 1.580788, 0, 0.505354, 0, 1},
            {1.403581, 0, -0.271053, 0, 1.511274, 0, 0.473801, 0, 1},
            {1.353397, 0, -0.259951, 0, 1.448919, 0, 0.444228, 0, 1},
            {1.308285, 0, -0.248922, 0, 1.391315, 0, 0.416226, 0, 1},
            {1.268348, 0, -0.238120, 0, 1.340640, 0, 0.389633, 0, 1},
            {1.229288, 0, -0.226738, 0, 1.292624, 0, 0.363043, 0, 1},
            {1.191782, 0, -0.213640, 0, 1.247216, 0, 0.336137, 0, 1},
            {1.158123, 0, -0.200732, 0, 1.206612, 0, 0.310605, 0, 1},
            {1.127971, 0, -0.188975, 0, 1.170084, 0, 0.286786, 0, 1},
            {1.101525, 0, -0.176419, 0, 1.136978, 0, 0.263543, 0, 1},
            {1.073173, 0, -0.163796, 0, 1.104285, 0, 0.240321, 0, 1},
            {1.049204, 0, -0.150419, 0, 1.076553, 0, 0.218232, 0, 1},
            {1.026314, 0, -0.138238, 0, 1.050268, 0, 0.197342, 0, 1},
            {1.006098, 0, -0.126123, 0, 1.026766, 0, 0.177471, 0, 1},
            {0.984793, 0, -0.112915, 0, 1.005000, 0, 0.158189, 0, 1},
            {0.966549, 0, -0.100712, 0, 0.986082, 0, 0.140060, 0, 1},
            {0.951129, 0, -0.088804, 0, 0.969373, 0, 0.122769, 0, 1},
            {0.937059, 0, -0.076745, 0, 0.953264, 0, 0.105741, 0, 1},
            {0.925190, 0, -0.064338, 0, 0.939572, 0, 0.088949, 0, 1},
            {0.914462, 0, -0.053706, 0, 0.926965, 0, 0.073288, 0, 1},
            {0.906082, 0, -0.041747, 0, 0.915858, 0, 0.057396, 0, 1},
            {0.898882, 0, -0.030772, 0, 0.905788, 0, 0.042190, 0, 1},
            {0.892759, 0, -0.020500, 0, 0.896808, 0, 0.027660, 0, 1},
            {0.887003, 0, -0.009507, 0, 0.888728, 0, 0.013275, 0, 1},
            {0.881333, 0, 0.000384, 0, 0.881380, 0, -0.000207, 0, 1},
            {500.059601, 0, -0.421533, 0, 588.824036, 0, 210.791840, 0, 1},
            {500.059601, 0, -0.421533, 0, 588.824036, 0, 210.791840, 0, 1},
            {496.084259, 0, -0.421533, 0, 584.296509, 0, 209.116089, 0, 1},
            {220.478745, 0, -0.421532, 0, 259.678864, 0, 92.938858, 0, 1},
            {124.071396, 0, -0.421528, 0, 146.019547, 0, 52.299969, 0, 1},
            {79.379288, 0, -0.421521, 0, 93.482513, 0, 33.460957, 0, 1},
            {55.121456, 0, -0.421507, 0, 64.919861, 0, 23.235432, 0, 1},
            {40.498322, 0, -0.421486, 0, 47.693100, 0, 17.071272, 0, 1},
            {31.004887, 0, -0.421452, 0, 36.514622, 0, 13.069407, 0, 1},
            {24.497126, 0, -0.421403, 0, 28.848557, 0, 10.326144, 0, 1},
            {19.840986, 0, -0.421336, 0, 23.364748, 0, 8.363354, 0, 1},
            {16.396778, 0, -0.421245, 0, 19.307020, 0, 6.911393, 0, 1},
            {13.776492, 0, -0.421126, 0, 16.220074, 0, 5.806774, 0, 1},
            {11.737366, 0, -0.420973, 0, 13.817286, 0, 4.947097, 0, 1},
            {10.118930, 0, -0.420781, 0, 11.910255, 0, 4.264768, 0, 1},
            {8.813279, 0, -0.420539, 0, 10.371409, 0, 3.714247, 0, 1},
            {7.744568, 0, -0.420229, 0, 9.111755, 0, 3.263614, 0, 1},
            {6.859016, 0, -0.419803, 0, 8.067348, 0, 2.890126, 0, 1},
            {6.117234, 0, -0.419075, 0, 7.192148, 0, 2.577196, 0, 1},
            {5.491295, 0, -0.416748, 0, 6.453664, 0, 2.312911, 0, 1},
            {4.961310, 0, -0.410452, 0, 5.827813, 0, 2.088539, 0, 1},
            {4.502675, 0, -0.406869, 0, 5.286016, 0, 1.894400, 0, 1},
            {4.105444, 0, -0.403979, 0, 4.816198, 0, 1.726133, 0, 1},
            {3.759574, 0, -0.401532, 0, 4.406865, 0, 1.579451, 0, 1},
            {3.457894, 0, -0.399128, 0, 4.049322, 0, 1.451311, 0, 1},
            {3.194794, 0, -0.396226, 0, 3.737089, 0, 1.339215, 0, 1},
            {2.966285, 0, -0.391930, 0, 3.464280, 0, 1.241265, 0, 1},
            {2.765135, 0, -0.390198, 0, 3.222786, 0, 1.155112, 0, 1},
            {2.587516, 0, -0.390249, 0, 3.010828, 0, 1.079116, 0, 1},
            {2.430748, 0, -0.389467, 0, 2.818973, 0, 1.011274, 0, 1},
            {2.279364, 0, -0.381881, 0, 2.635402, 0, 0.944029, 0, 1},
            {2.141573, 0, -0.374249, 0, 2.469073, 0, 0.882394, 0, 1},
            {2.019445, 0, -0.366010, 0, 2.318337, 0, 0.826555, 0, 1},
            {1.912733, 0, -0.356592, 0, 2.182500, 0, 0.775859, 0, 1},
            {1.814888, 0, -0.347909, 0, 2.060533, 0, 0.729075, 0, 1},
            {1.728283, 0, -0.339014, 0, 1.949563, 0, 0.686079, 0, 1},
            {1.651824, 0, -0.330054, 0, 1.850127, 0, 0.646755, 0, 1},
            {1.582111, 0, -0.321679, 0, 1.759212, 0, 0.609780, 0, 1},
            {1.520755, 0, -0.312708, 0, 1.677031, 0, 0.575687, 0, 1},
            {1.462069, 0, -0.302372, 0, 1.600912, 0, 0.542151, 0, 1},
            {1.406505, 0, -0.289490, 0, 1.529467, 0, 0.507994, 0, 1},
            {1.355670, 0, -0.277096, 0, 1.464466, 0, 0.475681, 0, 1},
            {1.310462, 0, -0.264909, 0, 1.405518, 0, 0.445162, 0, 1},
            {1.269723, 0, -0.253147, 0, 1.352767, 0, 0.416433, 0, 1},
            {1.232644, 0, -0.241229, 0, 1.304071, 0, 0.388466, 0, 1},
            {1.195341, 0, -0.227774, 0, 1.258229, 0, 0.359962, 0, 1},
            {1.161219, 0, -0.213755, 0, 1.215797, 0, 0.332265, 0, 1},
            {1.129898, 0, -0.200684, 0, 1.177878, 0, 0.306082, 0, 1},
            {1.102760, 0, -0.187138, 0, 1.143550, 0, 0.280904, 0, 1},
            {1.076280, 0, -0.174702, 0, 1.111130, 0, 0.256666, 0, 1},
            {1.050704, 0, -0.159825, 0, 1.081843, 0, 0.232502, 0, 1},
            {1.027316, 0, -0.146853, 0, 1.054068, 0, 0.209984, 0, 1},
            {1.006763, 0, -0.133423, 0, 1.030436, 0, 0.188332, 0, 1},
            {0.986885, 0, -0.120554, 0, 1.008011, 0, 0.168001, 0, 1},
            {0.967502, 0, -0.106695, 0, 0.987827, 0, 0.148440, 0, 1},
            {0.950414, 0, -0.093989, 0, 0.970286, 0, 0.129859, 0, 1},
            {0.936580, 0, -0.081503, 0, 0.954511, 0, 0.112117, 0, 1},
            {0.924112, 0, -0.068650, 0, 0.939973, 0, 0.094527, 0, 1},
            {0.913757, 0, -0.056414, 0, 0.927188, 0, 0.077515, 0, 1},
            {0.904744, 0, -0.044583, 0, 0.915818, 0, 0.061041, 0, 1},
            {0.897668, 0, -0.033002, 0, 0.905418, 0, 0.044985, 0, 1},
            {0.891905, 0, -0.021049, 0, 0.896403, 0, 0.029089, 0, 1},
            {0.886193, 0, -0.010424, 0, 0.888067, 0, 0.014262, 0, 1},
            {0.880556, 0, 0.000243, 0, 0.880561, 0, -0.000090, 0, 1},
            {500.116302, 0, -0.451214, 0, 601.644836, 0, 225.660080, 0, 1},
            {500.116302, 0, -0.451214, 0, 601.644836, 0, 225.660080, 0, 1},
            {496.419373, 0, -0.451215, 0, 596.902283, 0, 223.992233, 0, 1},
            {220.515854, 0, -0.451213, 0, 265.362183, 0, 99.499649, 0, 1},
            {124.011566, 0, -0.451209, 0, 149.283890, 0, 55.956001, 0, 1},
            {79.376762, 0, -0.451200, 0, 95.543793, 0, 35.815880, 0, 1},
            {55.119709, 0, -0.451184, 0, 66.349274, 0, 24.870659, 0, 1},
            {40.497002, 0, -0.451157, 0, 48.741329, 0, 18.272650, 0, 1},
            {31.004295, 0, -0.451116, 0, 37.316608, 0, 13.989375, 0, 1},
            {24.494001, 0, -0.451056, 0, 29.478388, 0, 11.051729, 0, 1},
            {19.841381, 0, -0.450973, 0, 23.878242, 0, 8.952353, 0, 1},
            {16.395880, 0, -0.450861, 0, 19.731627, 0, 7.397599, 0, 1},
            {13.776148, 0, -0.450716, 0, 16.576433, 0, 6.215408, 0, 1},
            {11.736938, 0, -0.450530, 0, 14.120349, 0, 5.295169, 0, 1},
            {10.119166, 0, -0.450294, 0, 12.171436, 0, 4.565055, 0, 1},
            {8.813128, 0, -0.449999, 0, 10.598472, 0, 3.975619, 0, 1},
            {7.744275, 0, -0.449622, 0, 9.310493, 0, 3.493130, 0, 1},
            {6.858771, 0, -0.449100, 0, 8.242989, 0, 3.093338, 0, 1},
            {6.117043, 0, -0.448158, 0, 7.348832, 0, 2.758377, 0, 1},
            {5.492260, 0, -0.444563, 0, 6.594917, 0, 2.475857, 0, 1},
            {4.960506, 0, -0.438925, 0, 5.953280, 0, 2.234970, 0, 1},
            {4.501591, 0, -0.435264, 0, 5.398923, 0, 2.027037, 0, 1},
            {4.103823, 0, -0.432443, 0, 4.917849, 0, 1.846695, 0, 1},
            {3.757566, 0, -0.429890, 0, 4.498732, 0, 1.689497, 0, 1},
            {3.455610, 0, -0.427014, 0, 4.132447, 0, 1.552106, 0, 1},
            {3.192770, 0, -0.423034, 0, 3.812856, 0, 1.432030, 0, 1},
            {2.963300, 0, -0.418234, 0, 3.531601, 0, 1.326616, 0, 1},
            {2.759787, 0, -0.415778, 0, 3.283630, 0, 1.233227, 0, 1},
            {2.582890, 0, -0.414688, 0, 3.065355, 0, 1.151779, 0, 1},
            {2.427227, 0, -0.413388, 0, 2.870349, 0, 1.079376, 0, 1},
            {2.281916, 0, -0.407680, 0, 2.686105, 0, 1.010475, 0, 1},
            {2.144573, 0, -0.399463, 0, 2.515150, 0, 0.944232, 0, 1},
            {2.023315, 0, -0.390213, 0, 2.360065, 0, 0.884447, 0, 1},
            {1.914623, 0, -0.380385, 0, 2.220392, 0, 0.829614, 0, 1},
            {1.816992, 0, -0.370609, 0, 2.094660, 0, 0.779126, 0, 1},
            {1.731204, 0, -0.360706, 0, 1.979890, 0, 0.733292, 0, 1},
            {1.653296, 0, -0.351016, 0, 1.877266, 0, 0.690765, 0, 1},
            {1.584838, 0, -0.341118, 0, 1.783811, 0, 0.651464, 0, 1},
            {1.522878, 0, -0.331569, 0, 1.699450, 0, 0.614818, 0, 1},
            {1.465904, 0, -0.320999, 0, 1.621733, 0, 0.579242, 0, 1},
            {1.410381, 0, -0.307961, 0, 1.549033, 0, 0.543202, 0, 1},
            {1.359675, 0, -0.294216, 0, 1.481353, 0, 0.508173, 0, 1},
            {1.313381, 0, -0.281083, 0, 1.420702, 0, 0.475130, 0, 1},
            {1.272297, 0, -0.267575, 0, 1.365447, 0, 0.443751, 0, 1},
            {1.234194, 0, -0.255146, 0, 1.315637, 0, 0.413804, 0, 1},
            {1.198219, 0, -0.241424, 0, 1.269803, 0, 0.383810, 0, 1},
            {1.164671, 0, -0.226983, 0, 1.226230, 0, 0.354420, 0, 1},
            {1.132555, 0, -0.212096, 0, 1.186634, 0, 0.325748, 0, 1},
            {1.103982, 0, -0.198021, 0, 1.151011, 0, 0.298620, 0, 1},
            {1.077696, 0, -0.184425, 0, 1.117435, 0, 0.272656, 0, 1},
            {1.052748, 0, -0.169861, 0, 1.087163, 0, 0.246974, 0, 1},
            {1.028253, 0, -0.155031, 0, 1.058456, 0, 0.222256, 0, 1},
            {1.008012, 0, -0.140822, 0, 1.034137, 0, 0.199352, 0, 1},
            {0.988116, 0, -0.127468, 0, 1.010818, 0, 0.177468, 0, 1},
            {0.968735, 0, -0.113119, 0, 0.990031, 0, 0.156765, 0, 1},
            {0.951031, 0, -0.099299, 0, 0.971698, 0, 0.137179, 0, 1},
            {0.936031, 0, -0.085956, 0, 0.955635, 0, 0.118275, 0, 1},
            {0.923193, 0, -0.073156, 0, 0.940697, 0, 0.100178, 0, 1},
            {0.912895, 0, -0.059621, 0, 0.927538, 0, 0.081887, 0, 1},
            {0.903714, 0, -0.047079, 0, 0.915609, 0, 0.064473, 0, 1},
            {0.896694, 0, -0.034858, 0, 0.905266, 0, 0.047523, 0, 1},
            {0.890835, 0, -0.022628, 0, 0.895919, 0, 0.030910, 0, 1},
            {0.885225, 0, -0.010897, 0, 0.887333, 0, 0.015067, 0, 1},
            {0.879812, 0, 0.000622, 0, 0.879796, 0, -0.000225, 0, 1},
            {500.142303, 0, -0.481572, 0, 615.636475, 0, 240.854446, 0, 1},
            {500.142303, 0, -0.481572, 0, 615.636475, 0, 240.854446, 0, 1},
            {496.084595, 0, -0.481572, 0, 611.148499, 0, 238.900360, 0, 1},
            {220.510513, 0, -0.481570, 0, 271.639252, 0, 106.191238, 0, 1},
            {124.057518, 0, -0.481565, 0, 152.745911, 0, 59.742542, 0, 1},
            {79.381859, 0, -0.481553, 0, 97.788277, 0, 38.228016, 0, 1},
            {55.124126, 0, -0.481534, 0, 67.906372, 0, 26.546095, 0, 1},
            {40.496948, 0, -0.481502, 0, 49.884426, 0, 19.502005, 0, 1},
            {31.002106, 0, -0.481452, 0, 38.196342, 0, 14.929495, 0, 1},
            {24.498438, 0, -0.481379, 0, 30.178972, 0, 11.797418, 0, 1},
            {19.840780, 0, -0.481278, 0, 24.439901, 0, 9.554322, 0, 1},
            {16.395788, 0, -0.481142, 0, 20.194504, 0, 7.895192, 0, 1},
            {13.775730, 0, -0.480966, 0, 16.965696, 0, 6.633308, 0, 1},
            {11.736637, 0, -0.480740, 0, 14.451633, 0, 5.651190, 0, 1},
            {10.118291, 0, -0.480456, 0, 12.456468, 0, 4.871670, 0, 1},
            {8.812709, 0, -0.480098, 0, 10.846252, 0, 4.242721, 0, 1},
            {7.743920, 0, -0.479641, 0, 9.527981, 0, 3.727806, 0, 1},
            {6.858428, 0, -0.479003, 0, 8.435132, 0, 3.301105, 0, 1},
            {6.116847, 0, -0.477754, 0, 7.519803, 0, 2.943619, 0, 1},
            {5.493080, 0, -0.472378, 0, 6.749546, 0, 2.642394, 0, 1},
            {4.959749, 0, -0.467682, 0, 6.090446, 0, 2.384650, 0, 1},
            {4.500247, 0, -0.464200, 0, 5.521990, 0, 2.162462, 0, 1},
            {4.102044, 0, -0.461375, 0, 5.028761, 0, 1.969752, 0, 1},
            {3.755406, 0, -0.458712, 0, 4.598831, 0, 1.801749, 0, 1},
            {3.453321, 0, -0.455255, 0, 4.223391, 0, 1.654983, 0, 1},
            {3.190980, 0, -0.449937, 0, 3.895595, 0, 1.526821, 0, 1},
            {2.958884, 0, -0.445284, 0, 3.605617, 0, 1.413050, 0, 1},
            {2.755563, 0, -0.442242, 0, 3.350090, 0, 1.313269, 0, 1},
            {2.577801, 0, -0.439782, 0, 3.125904, 0, 1.225549, 0, 1},
            {2.424818, 0, -0.437158, 0, 2.924916, 0, 1.149112, 0, 1},
            {2.283442, 0, -0.434142, 0, 2.742248, 0, 1.078217, 0, 1},
            {2.145899, 0, -0.425074, 0, 2.565708, 0, 1.007205, 0, 1},
            {2.025461, 0, -0.414567, 0, 2.405426, 0, 0.943441, 0, 1},
            {1.916772, 0, -0.404674, 0, 2.261385, 0, 0.884947, 0, 1},
            {1.820042, 0, -0.393643, 0, 2.130748, 0, 0.830977, 0, 1},
            {1.733991, 0, -0.382752, 0, 2.013048, 0, 0.781948, 0, 1},
            {1.655815, 0, -0.371868, 0, 1.906421, 0, 0.735973, 0, 1},
            {1.586961, 0, -0.361063, 0, 1.809920, 0, 0.693817, 0, 1},
            {1.524529, 0, -0.350222, 0, 1.722922, 0, 0.654277, 0, 1},
            {1.468299, 0, -0.339151, 0, 1.642883, 0, 0.616865, 0, 1},
            {1.414571, 0, -0.326556, 0, 1.569844, 0, 0.579456, 0, 1},
            {1.363360, 0, -0.311730, 0, 1.499179, 0, 0.541726, 0, 1},
            {1.316947, 0, -0.297192, 0, 1.437031, 0, 0.506222, 0, 1},
            {1.274491, 0, -0.282565, 0, 1.379374, 0, 0.471675, 0, 1},
            {1.237046, 0, -0.269189, 0, 1.327798, 0, 0.439577, 0, 1},
            {1.201312, 0, -0.254431, 0, 1.281244, 0, 0.407588, 0, 1},
            {1.166449, 0, -0.240163, 0, 1.236316, 0, 0.375985, 0, 1},
            {1.134363, 0, -0.223883, 0, 1.195412, 0, 0.345184, 0, 1},
            {1.105575, 0, -0.208647, 0, 1.158576, 0, 0.316303, 0, 1},
            {1.079856, 0, -0.193740, 0, 1.124746, 0, 0.288531, 0, 1},
            {1.053782, 0, -0.179356, 0, 1.093294, 0, 0.261333, 0, 1},
            {1.030322, 0, -0.163585, 0, 1.063753, 0, 0.235141, 0, 1},
            {1.008895, 0, -0.148491, 0, 1.037665, 0, 0.210275, 0, 1},
            {0.988353, 0, -0.133701, 0, 1.013934, 0, 0.187020, 0, 1},
            {0.969570, 0, -0.119553, 0, 0.992656, 0, 0.165160, 0, 1},
            {0.951590, 0, -0.104649, 0, 0.973196, 0, 0.144189, 0, 1},
            {0.935427, 0, -0.090354, 0, 0.956373, 0, 0.124339, 0, 1},
            {0.922397, 0, -0.076839, 0, 0.941249, 0, 0.105099, 0, 1},
            {0.911450, 0, -0.063076, 0, 0.927700, 0, 0.086331, 0, 1},
            {0.902659, 0, -0.049555, 0, 0.915691, 0, 0.067933, 0, 1},
            {0.895581, 0, -0.036382, 0, 0.904873, 0, 0.049954, 0, 1},
            {0.889648, 0, -0.024224, 0, 0.895366, 0, 0.032801, 0, 1},
            {0.884380, 0, -0.011396, 0, 0.886784, 0, 0.015819, 0, 1},
            {0.878901, 0, 0.000752, 0, 0.878886, 0, -0.000350, 0, 1},
            {499.833038, 0, -0.512667, 0, 631.441956, 0, 256.248108, 0, 1},
            {499.833038, 0, -0.512667, 0, 631.441956, 0, 256.248108, 0, 1},
            {496.158051, 0, -0.512667, 0, 626.537048, 0, 254.363953, 0, 1},
            {220.518692, 0, -0.512665, 0, 278.424103, 0, 113.052116, 0, 1},
            {124.058762, 0, -0.512658, 0, 156.580750, 0, 63.600826, 0, 1},
            {79.377831, 0, -0.512645, 0, 100.243629, 0, 40.694302, 0, 1},
            {55.124279, 0, -0.512621, 0, 69.611153, 0, 28.260294, 0, 1},
            {40.494614, 0, -0.512583, 0, 51.140453, 0, 20.760023, 0, 1},
            {31.003603, 0, -0.512522, 0, 39.156490, 0, 15.894115, 0, 1},
            {24.494518, 0, -0.512434, 0, 30.930185, 0, 12.557170, 0, 1},
            {19.839989, 0, -0.512313, 0, 25.052380, 0, 10.170775, 0, 1},
            {16.395456, 0, -0.512150, 0, 20.700644, 0, 8.404720, 0, 1},
            {13.775427, 0, -0.511937, 0, 17.390364, 0, 7.061382, 0, 1},
            {11.735991, 0, -0.511665, 0, 14.813210, 0, 6.015653, 0, 1},
            {10.117810, 0, -0.511322, 0, 12.767522, 0, 5.185846, 0, 1},
            {8.812005, 0, -0.510893, 0, 11.116779, 0, 4.516166, 0, 1},
            {7.743429, 0, -0.510343, 0, 9.765045, 0, 3.968071, 0, 1},
            {6.857736, 0, -0.509558, 0, 8.644680, 0, 3.513671, 0, 1},
            {6.116433, 0, -0.507841, 0, 7.706219, 0, 3.133188, 0, 1},
            {5.492404, 0, -0.501837, 0, 6.916293, 0, 2.812324, 0, 1},
            {4.958022, 0, -0.497532, 0, 6.239026, 0, 2.537439, 0, 1},
            {4.497925, 0, -0.494140, 0, 5.655237, 0, 2.300593, 0, 1},
            {4.100157, 0, -0.490804, 0, 5.149754, 0, 2.095579, 0, 1},
            {3.753082, 0, -0.488019, 0, 4.707974, 0, 1.916456, 0, 1},
            {3.451247, 0, -0.483821, 0, 4.322457, 0, 1.760169, 0, 1},
            {3.188345, 0, -0.477359, 0, 3.985661, 0, 1.623221, 0, 1},
            {2.955361, 0, -0.472948, 0, 3.686046, 0, 1.501682, 0, 1},
            {2.750720, 0, -0.469106, 0, 3.423305, 0, 1.394630, 0, 1},
            {2.574424, 0, -0.465402, 0, 3.191475, 0, 1.301486, 0, 1},
            {2.420457, 0, -0.461761, 0, 2.984488, 0, 1.219465, 0, 1},
            {2.280467, 0, -0.459156, 0, 2.799470, 0, 1.144915, 0, 1},
            {2.148587, 0, -0.450660, 0, 2.620453, 0, 1.072513, 0, 1},
            {2.027889, 0, -0.439798, 0, 2.454997, 0, 1.004191, 0, 1},
            {1.919624, 0, -0.428882, 0, 2.305794, 0, 0.941869, 0, 1},
            {1.823223, 0, -0.416811, 0, 2.170411, 0, 0.884438, 0, 1},
            {1.736360, 0, -0.405050, 0, 2.048491, 0, 0.831502, 0, 1},
            {1.659158, 0, -0.392667, 0, 1.937715, 0, 0.782747, 0, 1},
            {1.589230, 0, -0.380929, 0, 1.838086, 0, 0.737227, 0, 1},
            {1.527017, 0, -0.368788, 0, 1.746600, 0, 0.694725, 0, 1},
            {1.470582, 0, -0.357054, 0, 1.664725, 0, 0.654904, 0, 1},
            {1.418556, 0, -0.344040, 0, 1.590104, 0, 0.615562, 0, 1},
            {1.367267, 0, -0.329366, 0, 1.518735, 0, 0.575605, 0, 1},
            {1.320187, 0, -0.313070, 0, 1.453649, 0, 0.536870, 0, 1},
            {1.277404, 0, -0.297768, 0, 1.393976, 0, 0.500023, 0, 1},
            {1.238920, 0, -0.282633, 0, 1.340037, 0, 0.465346, 0, 1},
            {1.203396, 0, -0.267288, 0, 1.292495, 0, 0.431370, 0, 1},
            {1.169605, 0, -0.252603, 0, 1.247279, 0, 0.398253, 0, 1},
            {1.137221, 0, -0.236090, 0, 1.205140, 0, 0.365478, 0, 1},
            {1.106866, 0, -0.219355, 0, 1.166418, 0, 0.333940, 0, 1},
            {1.080629, 0, -0.203533, 0, 1.131532, 0, 0.304547, 0, 1},
            {1.055715, 0, -0.187983, 0, 1.099271, 0, 0.275948, 0, 1},
            {1.031158, 0, -0.172449, 0, 1.068871, 0, 0.247808, 0, 1},
            {1.009003, 0, -0.156074, 0, 1.041632, 0, 0.221478, 0, 1},
            {0.989099, 0, -0.140250, 0, 1.017254, 0, 0.196571, 0, 1},
            {0.969476, 0, -0.125351, 0, 0.995050, 0, 0.173181, 0, 1},
            {0.952149, 0, -0.110199, 0, 0.975125, 0, 0.151162, 0, 1},
            {0.935578, 0, -0.094911, 0, 0.957281, 0, 0.130319, 0, 1},
            {0.921855, 0, -0.080171, 0, 0.941969, 0, 0.110122, 0, 1},
            {0.910342, 0, -0.066290, 0, 0.928011, 0, 0.090644, 0, 1},
            {0.901261, 0, -0.052273, 0, 0.915516, 0, 0.071411, 0, 1},
            {0.894295, 0, -0.038210, 0, 0.904521, 0, 0.052497, 0, 1},
            {0.888607, 0, -0.025149, 0, 0.894789, 0, 0.034253, 0, 1},
            {0.883473, 0, -0.012290, 0, 0.886115, 0, 0.016722, 0, 1},
            {0.877935, 0, 0.000665, 0, 0.877965, 0, -0.000345, 0, 1},
            {499.964600, 0, -0.544568, 0, 648.281921, 0, 272.264343, 0, 1},
            {499.964600, 0, -0.544568, 0, 648.281921, 0, 272.264343, 0, 1},
            {496.047424, 0, -0.544568, 0, 643.325500, 0, 270.131653, 0, 1},
            {220.488297, 0, -0.544565, 0, 285.888458, 0, 120.070152, 0, 1},
            {124.029099, 0, -0.544557, 0, 160.816254, 0, 67.542206, 0, 1},
            {79.379036, 0, -0.544541, 0, 102.917030, 0, 43.227154, 0, 1},
            {55.124950, 0, -0.544513, 0, 71.467789, 0, 30.019081, 0, 1},
            {40.495598, 0, -0.544466, 0, 52.503517, 0, 22.052328, 0, 1},
            {31.007767, 0, -0.544394, 0, 40.197323, 0, 16.885170, 0, 1},
            {24.495283, 0, -0.544289, 0, 31.757868, 0, 13.338841, 0, 1},
            {19.836905, 0, -0.544144, 0, 25.721111, 0, 10.801979, 0, 1},
            {16.394938, 0, -0.543948, 0, 21.252571, 0, 8.927350, 0, 1},
            {13.774549, 0, -0.543693, 0, 17.853453, 0, 7.500184, 0, 1},
            {11.735194, 0, -0.543368, 0, 15.207374, 0, 6.389414, 0, 1},
            {10.116846, 0, -0.542959, 0, 13.106936, 0, 5.507866, 0, 1},
            {8.811126, 0, -0.542446, 0, 11.411842, 0, 4.796541, 0, 1},
            {7.742423, 0, -0.541784, 0, 10.023723, 0, 4.214224, 0, 1},
            {6.856839, 0, -0.540818, 0, 8.872921, 0, 3.731567, 0, 1},
            {6.115932, 0, -0.538320, 0, 7.909827, 0, 3.327516, 0, 1},
            {5.491170, 0, -0.531933, 0, 7.097507, 0, 2.986258, 0, 1},
            {4.955805, 0, -0.528191, 0, 6.400644, 0, 2.693787, 0, 1},
            {4.495482, 0, -0.524701, 0, 5.800350, 0, 2.442038, 0, 1},
            {4.097378, 0, -0.521103, 0, 5.280610, 0, 2.224023, 0, 1},
            {3.750728, 0, -0.517823, 0, 4.826674, 0, 2.033879, 0, 1},
            {3.448358, 0, -0.512657, 0, 4.430115, 0, 1.867394, 0, 1},
            {3.185436, 0, -0.505882, 0, 4.082632, 0, 1.721818, 0, 1},
            {2.951017, 0, -0.500943, 0, 3.774083, 0, 1.591852, 0, 1},
            {2.747175, 0, -0.496302, 0, 3.502885, 0, 1.478221, 0, 1},
            {2.570778, 0, -0.490996, 0, 3.261750, 0, 1.378683, 0, 1},
            {2.414072, 0, -0.486501, 0, 3.048726, 0, 1.290131, 0, 1},
            {2.276909, 0, -0.483158, 0, 2.857607, 0, 1.212195, 0, 1},
            {2.151454, 0, -0.476280, 0, 2.679210, 0, 1.139442, 0, 1},
            {2.029948, 0, -0.465295, 0, 2.508307, 0, 1.066667, 0, 1},
            {1.922984, 0, -0.452975, 0, 2.352989, 0, 1.000628, 0, 1},
            {1.826360, 0, -0.440447, 0, 2.212558, 0, 0.939624, 0, 1},
            {1.739519, 0, -0.427570, 0, 2.085970, 0, 0.883070, 0, 1},
            {1.662084, 0, -0.414159, 0, 1.970891, 0, 0.830612, 0, 1},
            {1.591782, 0, -0.401020, 0, 1.867387, 0, 0.781635, 0, 1},
            {1.527778, 0, -0.387815, 0, 1.773135, 0, 0.735067, 0, 1},
            {1.470978, 0, -0.374850, 0, 1.688238, 0, 0.692502, 0, 1},
            {1.419374, 0, -0.360991, 0, 1.611230, 0, 0.650772, 0, 1},
            {1.370268, 0, -0.347067, 0, 1.538865, 0, 0.610021, 0, 1},
            {1.324325, 0, -0.329195, 0, 1.471813, 0, 0.568878, 0, 1},
            {1.280913, 0, -0.312954, 0, 1.409399, 0, 0.529189, 0, 1},
            {1.241405, 0, -0.296203, 0, 1.354398, 0, 0.491309, 0, 1},
            {1.206234, 0, -0.280184, 0, 1.304585, 0, 0.455905, 0, 1},
            {1.171914, 0, -0.264093, 0, 1.257975, 0, 0.419949, 0, 1},
            {1.139891, 0, -0.248016, 0, 1.215121, 0, 0.385831, 0, 1},
            {1.109539, 0, -0.230063, 0, 1.175352, 0, 0.352087, 0, 1},
            {1.081135, 0, -0.212976, 0, 1.138444, 0, 0.319821, 0, 1},
            {1.056964, 0, -0.196264, 0, 1.105688, 0, 0.290159, 0, 1},
            {1.033070, 0, -0.180463, 0, 1.074996, 0, 0.261001, 0, 1},
            {1.010903, 0, -0.163769, 0, 1.046055, 0, 0.232721, 0, 1},
            {0.988432, 0, -0.146893, 0, 1.019785, 0, 0.205913, 0, 1},
            {0.969959, 0, -0.130679, 0, 0.997071, 0, 0.180926, 0, 1},
            {0.951529, 0, -0.115382, 0, 0.976638, 0, 0.157946, 0, 1},
            {0.935498, 0, -0.099787, 0, 0.958721, 0, 0.136321, 0, 1},
            {0.921286, 0, -0.084040, 0, 0.942499, 0, 0.115253, 0, 1},
            {0.909408, 0, -0.068988, 0, 0.928135, 0, 0.094595, 0, 1},
            {0.900124, 0, -0.054561, 0, 0.915531, 0, 0.074658, 0, 1},
            {0.892791, 0, -0.040426, 0, 0.904311, 0, 0.055110, 0, 1},
            {0.887428, 0, -0.025947, 0, 0.894170, 0, 0.035730, 0, 1},
            {0.882287, 0, -0.012705, 0, 0.885185, 0, 0.017470, 0, 1},
            {0.877015, 0, 0.000072, 0, 0.877030, 0, -0.000040, 0, 1},
            {500.018127, 0, -0.577347, 0, 666.741516, 0, 288.683624, 0, 1},
            {500.018127, 0, -0.577347, 0, 666.741516, 0, 288.683624, 0, 1},
            {496.097687, 0, -0.577346, 0, 661.498901, 0, 286.420258, 0, 1},
            {220.509628, 0, -0.577344, 0, 294.003113, 0, 127.310104, 0, 1},
            {124.006050, 0, -0.577335, 0, 165.390106, 0, 71.594391, 0, 1},
            {79.378586, 0, -0.577316, 0, 105.838509, 0, 45.828773, 0, 1},
            {55.122433, 0, -0.577280, 0, 73.496788, 0, 31.824512, 0, 1},
            {40.497952, 0, -0.577225, 0, 53.993816, 0, 23.381008, 0, 1},
            {31.003929, 0, -0.577139, 0, 41.337330, 0, 17.899559, 0, 1},
            {24.494070, 0, -0.577015, 0, 32.658623, 0, 14.140984, 0, 1},
            {19.840250, 0, -0.576841, 0, 26.453827, 0, 11.454021, 0, 1},
            {16.394211, 0, -0.576608, 0, 21.853865, 0, 9.464190, 0, 1},
            {13.773612, 0, -0.576305, 0, 18.358515, 0, 7.950984, 0, 1},
            {11.734133, 0, -0.575918, 0, 15.637076, 0, 6.773256, 0, 1},
            {10.115806, 0, -0.575432, 0, 13.476646, 0, 5.838628, 0, 1},
            {8.809996, 0, -0.574821, 0, 11.733068, 0, 5.084384, 0, 1},
            {7.741207, 0, -0.574030, 0, 10.305275, 0, 4.466939, 0, 1},
            {6.855765, 0, -0.572821, 0, 9.121772, 0, 3.955261, 0, 1},
            {6.115031, 0, -0.568942, 0, 8.131938, 0, 3.526886, 0, 1},
            {5.488869, 0, -0.563314, 0, 7.294135, 0, 3.164334, 0, 1},
            {4.953284, 0, -0.559480, 0, 6.576398, 0, 2.854054, 0, 1},
            {4.492596, 0, -0.555925, 0, 5.958310, 0, 2.586941, 0, 1},
            {4.094578, 0, -0.552047, 0, 5.422942, 0, 2.355748, 0, 1},
            {3.748152, 0, -0.548119, 0, 4.955694, 0, 2.154149, 0, 1},
            {3.445738, 0, -0.541672, 0, 4.546956, 0, 1.977378, 0, 1},
            {3.181209, 0, -0.535137, 0, 4.188271, 0, 1.822137, 0, 1},
            {2.947188, 0, -0.529686, 0, 3.869549, 0, 1.684381, 0, 1},
            {2.744051, 0, -0.523755, 0, 3.589326, 0, 1.563893, 0, 1},
            {2.565445, 0, -0.517369, 0, 3.338645, 0, 1.457006, 0, 1},
            {2.409017, 0, -0.512125, 0, 3.118602, 0, 1.362977, 0, 1},
            {2.273139, 0, -0.507864, 0, 2.920849, 0, 1.280931, 0, 1},
            {2.151341, 0, -0.501463, 0, 2.739769, 0, 1.206435, 0, 1},
            {2.032765, 0, -0.491007, 0, 2.564208, 0, 1.131025, 0, 1},
            {1.926557, 0, -0.477448, 0, 2.403278, 0, 1.061221, 0, 1},
            {1.827807, 0, -0.464125, 0, 2.258311, 0, 0.994956, 0, 1},
            {1.741566, 0, -0.449924, 0, 2.126067, 0, 0.934917, 0, 1},
            {1.660114, 0, -0.435590, 0, 2.007916, 0, 0.877202, 0, 1},
            {1.589580, 0, -0.420918, 0, 1.899860, 0, 0.824254, 0, 1},
            {1.525931, 0, -0.407009, 0, 1.802565, 0, 0.775067, 0, 1},
            {1.469439, 0, -0.392144, 0, 1.713783, 0, 0.729089, 0, 1},
            {1.418139, 0, -0.377949, 0, 1.632838, 0, 0.685314, 0, 1},
            {1.370206, 0, -0.363367, 0, 1.560151, 0, 0.642775, 0, 1},
            {1.323761, 0, -0.345699, 0, 1.491048, 0, 0.599351, 0, 1},
            {1.282438, 0, -0.328074, 0, 1.425775, 0, 0.557789, 0, 1},
            {1.244317, 0, -0.310119, 0, 1.368643, 0, 0.518010, 0, 1},
            {1.207352, 0, -0.292714, 0, 1.316545, 0, 0.479277, 0, 1},
            {1.174196, 0, -0.275618, 0, 1.268610, 0, 0.442052, 0, 1},
            {1.142261, 0, -0.259139, 0, 1.224709, 0, 0.406320, 0, 1},
            {1.111881, 0, -0.241217, 0, 1.184688, 0, 0.370689, 0, 1},
            {1.082894, 0, -0.222689, 0, 1.146485, 0, 0.336129, 0, 1},
            {1.057850, 0, -0.204917, 0, 1.112059, 0, 0.303957, 0, 1},
            {1.033615, 0, -0.187739, 0, 1.080596, 0, 0.273180, 0, 1},
            {1.011315, 0, -0.171021, 0, 1.051114, 0, 0.243954, 0, 1},
            {0.989738, 0, -0.153753, 0, 1.024040, 0, 0.215570, 0, 1},
            {0.970972, 0, -0.136460, 0, 0.999989, 0, 0.189355, 0, 1},
            {0.951252, 0, -0.120018, 0, 0.978592, 0, 0.164635, 0, 1},
            {0.934632, 0, -0.103986, 0, 0.959674, 0, 0.141955, 0, 1},
            {0.920438, 0, -0.087980, 0, 0.943254, 0, 0.120291, 0, 1},
            {0.908753, 0, -0.071985, 0, 0.928291, 0, 0.098603, 0, 1},
            {0.898769, 0, -0.056729, 0, 0.915308, 0, 0.077731, 0, 1},
            {0.891474, 0, -0.042209, 0, 0.903846, 0, 0.057448, 0, 1},
            {0.886116, 0, -0.027432, 0, 0.893643, 0, 0.037431, 0, 1},
            {0.881084, 0, -0.012906, 0, 0.884266, 0, 0.018066, 0, 1},
            {0.875985, 0, 0.000404, 0, 0.875942, 0, -0.000225, 0, 1},
            {500.059753, 0, -0.611084, 0, 687.020447, 0, 305.577911, 0, 1},
            {500.059753, 0, -0.611084, 0, 687.020447, 0, 305.577911, 0, 1},
            {496.131104, 0, -0.611084, 0, 681.313354, 0, 303.177673, 0, 1},
            {220.503235, 0, -0.611079, 0, 302.831818, 0, 134.745651, 0, 1},
            {124.032204, 0, -0.611068, 0, 170.349152, 0, 75.793968, 0, 1},
            {79.376831, 0, -0.611046, 0, 109.018860, 0, 48.505707, 0, 1},
            {55.118790, 0, -0.611006, 0, 75.706657, 0, 33.681911, 0, 1},
            {40.496830, 0, -0.610939, 0, 55.616562, 0, 24.746468, 0, 1},
            {31.003130, 0, -0.610838, 0, 42.578850, 0, 18.944946, 0, 1},
            {24.494944, 0, -0.610689, 0, 33.638340, 0, 14.967728, 0, 1},
            {19.839455, 0, -0.610484, 0, 27.240908, 0, 12.122551, 0, 1},
            {16.391743, 0, -0.610209, 0, 22.509579, 0, 10.015670, 0, 1},
            {13.772236, 0, -0.609849, 0, 18.908459, 0, 8.414637, 0, 1},
            {11.732980, 0, -0.609391, 0, 16.105103, 0, 7.168170, 0, 1},
            {10.114366, 0, -0.608815, 0, 13.880643, 0, 6.178736, 0, 1},
            {8.808816, 0, -0.608090, 0, 12.082842, 0, 5.380540, 0, 1},
            {7.739786, 0, -0.607146, 0, 10.612023, 0, 4.726828, 0, 1},
            {6.854265, 0, -0.605599, 0, 9.392420, 0, 4.185153, 0, 1},
            {6.113844, 0, -0.599966, 0, 8.373297, 0, 3.731737, 0, 1},
            {5.486492, 0, -0.595251, 0, 7.507792, 0, 3.347297, 0, 1},
            {4.950495, 0, -0.591420, 0, 6.767659, 0, 3.018643, 0, 1},
            {4.489434, 0, -0.587858, 0, 6.129895, 0, 2.735610, 0, 1},
            {4.091563, 0, -0.583652, 0, 5.577612, 0, 2.490912, 0, 1},
            {3.744393, 0, -0.578882, 0, 5.096111, 0, 2.276983, 0, 1},
            {3.442302, 0, -0.571441, 0, 4.673666, 0, 2.089818, 0, 1},
            {3.177282, 0, -0.565192, 0, 4.302368, 0, 1.925208, 0, 1},
            {2.943215, 0, -0.559023, 0, 3.972773, 0, 1.779118, 0, 1},
            {2.740145, 0, -0.551469, 0, 3.682717, 0, 1.651309, 0, 1},
            {2.560740, 0, -0.544530, 0, 3.422651, 0, 1.537548, 0, 1},
            {2.405007, 0, -0.538283, 0, 3.194257, 0, 1.438259, 0, 1},
            {2.269851, 0, -0.532345, 0, 2.987319, 0, 1.351191, 0, 1},
            {2.149445, 0, -0.525563, 0, 2.801316, 0, 1.273241, 0, 1},
            {2.034208, 0, -0.516618, 0, 2.625589, 0, 1.196375, 0, 1},
            {1.923855, 0, -0.502460, 0, 2.459321, 0, 1.119779, 0, 1},
            {1.826712, 0, -0.487891, 0, 2.308541, 0, 1.050307, 0, 1},
            {1.739512, 0, -0.472859, 0, 2.170905, 0, 0.985883, 0, 1},
            {1.661322, 0, -0.457224, 0, 2.047603, 0, 0.925946, 0, 1},
            {1.590618, 0, -0.441340, 0, 1.933808, 0, 0.869810, 0, 1},
            {1.527487, 0, -0.426157, 0, 1.832489, 0, 0.817512, 0, 1},
            {1.470243, 0, -0.409679, 0, 1.740569, 0, 0.767899, 0, 1},
            {1.418768, 0, -0.394768, 0, 1.656640, 0, 0.721272, 0, 1},
            {1.370922, 0, -0.378746, 0, 1.580837, 0, 0.675507, 0, 1},
            {1.325950, 0, -0.361887, 0, 1.510943, 0, 0.631064, 0, 1},
            {1.282281, 0, -0.343009, 0, 1.444533, 0, 0.585837, 0, 1},
            {1.245250, 0, -0.324201, 0, 1.383857, 0, 0.544231, 0, 1},
            {1.209798, 0, -0.305055, 0, 1.328927, 0, 0.503334, 0, 1},
            {1.175961, 0, -0.287306, 0, 1.279956, 0, 0.464460, 0, 1},
            {1.143816, 0, -0.269177, 0, 1.234930, 0, 0.425767, 0, 1},
            {1.113576, 0, -0.251675, 0, 1.193066, 0, 0.388752, 0, 1},
            {1.084812, 0, -0.232448, 0, 1.154327, 0, 0.352472, 0, 1},
            {1.057252, 0, -0.213585, 0, 1.118203, 0, 0.317450, 0, 1},
            {1.034291, 0, -0.195251, 0, 1.085671, 0, 0.285633, 0, 1},
            {1.011855, 0, -0.177823, 0, 1.055842, 0, 0.255055, 0, 1},
            {0.991743, 0, -0.160161, 0, 1.028257, 0, 0.225794, 0, 1},
            {0.971158, 0, -0.142319, 0, 1.002737, 0, 0.197439, 0, 1},
            {0.952054, 0, -0.124608, 0, 0.980425, 0, 0.170992, 0, 1},
            {0.934170, 0, -0.107886, 0, 0.960933, 0, 0.147320, 0, 1},
            {0.919185, 0, -0.091622, 0, 0.944061, 0, 0.124784, 0, 1},
            {0.907437, 0, -0.075300, 0, 0.928761, 0, 0.102708, 0, 1},
            {0.897538, 0, -0.058930, 0, 0.915182, 0, 0.080852, 0, 1},
            {0.890261, 0, -0.043578, 0, 0.903289, 0, 0.059702, 0, 1},
            {0.884575, 0, -0.029008, 0, 0.892858, 0, 0.039127, 0, 1},
            {0.879937, 0, -0.013622, 0, 0.883339, 0, 0.018893, 0, 1},
            {0.874765, 0, 0.000895, 0, 0.874699, 0, -0.000434, 0, 1},
            {499.980133, 0, -0.645864, 0, 708.598999, 0, 322.918793, 0, 1},
            {499.980133, 0, -0.645864, 0, 708.598999, 0, 322.918793, 0, 1},
            {496.017120, 0, -0.645864, 0, 703.275818, 0, 320.360229, 0, 1},
            {220.501709, 0, -0.645860, 0, 312.467621, 0, 142.414230, 0, 1},
            {124.024284, 0, -0.645847, 0, 175.772400, 0, 80.102768, 0, 1},
            {79.373238, 0, -0.645819, 0, 112.490692, 0, 51.264164, 0, 1},
            {55.122040, 0, -0.645772, 0, 78.116310, 0, 35.601017, 0, 1},
            {40.499382, 0, -0.645695, 0, 57.385887, 0, 26.156567, 0, 1},
            {31.001198, 0, -0.645573, 0, 43.931107, 0, 20.021948, 0, 1},
            {24.493385, 0, -0.645399, 0, 34.708286, 0, 15.818537, 0, 1},
            {19.838543, 0, -0.645157, 0, 28.108135, 0, 12.811936, 0, 1},
            {16.393085, 0, -0.644832, 0, 23.223579, 0, 10.586369, 0, 1},
            {13.771312, 0, -0.644408, 0, 19.508339, 0, 8.892781, 0, 1},
            {11.731657, 0, -0.643867, 0, 16.614929, 0, 7.575101, 0, 1},
            {10.112901, 0, -0.643188, 0, 14.318110, 0, 6.529218, 0, 1},
            {8.806743, 0, -0.642332, 0, 12.464256, 0, 5.685175, 0, 1},
            {7.737839, 0, -0.641200, 0, 10.945989, 0, 4.994275, 0, 1},
            {6.852201, 0, -0.639143, 0, 9.687261, 0, 4.421630, 0, 1},
            {6.111566, 0, -0.632858, 0, 8.633825, 0, 3.942178, 0, 1},
            {5.483883, 0, -0.627844, 0, 7.739667, 0, 3.535588, 0, 1},
            {4.947381, 0, -0.624017, 0, 6.975159, 0, 3.187831, 0, 1},
            {4.486110, 0, -0.620546, 0, 6.316311, 0, 2.888543, 0, 1},
            {4.087338, 0, -0.615942, 0, 5.745611, 0, 2.629270, 0, 1},
            {3.740768, 0, -0.610050, 0, 5.247872, 0, 2.403260, 0, 1},
            {3.438387, 0, -0.602321, 0, 4.810745, 0, 2.205128, 0, 1},
            {3.172844, 0, -0.595671, 0, 4.426208, 0, 2.030723, 0, 1},
            {2.938661, 0, -0.588711, 0, 4.085194, 0, 1.876083, 0, 1},
            {2.736077, 0, -0.579877, 0, 3.782948, 0, 1.740864, 0, 1},
            {2.556285, 0, -0.572356, 0, 3.513409, 0, 1.620289, 0, 1},
            {2.401605, 0, -0.564621, 0, 3.275337, 0, 1.515545, 0, 1},
            {2.265606, 0, -0.557336, 0, 3.058467, 0, 1.422700, 0, 1},
            {2.144067, 0, -0.550026, 0, 2.866941, 0, 1.339311, 0, 1},
            {2.031228, 0, -0.541524, 0, 2.689938, 0, 1.260069, 0, 1},
            {1.924598, 0, -0.527483, 0, 2.519325, 0, 1.181578, 0, 1},
            {1.828354, 0, -0.511716, 0, 2.360447, 0, 1.108573, 0, 1},
            {1.741445, 0, -0.495876, 0, 2.217819, 0, 1.039997, 0, 1},
            {1.662840, 0, -0.478652, 0, 2.088299, 0, 0.976298, 0, 1},
            {1.590112, 0, -0.462021, 0, 1.971833, 0, 0.914662, 0, 1},
            {1.526299, 0, -0.445163, 0, 1.864987, 0, 0.858934, 0, 1},
            {1.469457, 0, -0.427458, 0, 1.769146, 0, 0.806228, 0, 1},
            {1.416942, 0, -0.411264, 0, 1.681657, 0, 0.755457, 0, 1},
            {1.372203, 0, -0.394171, 0, 1.602263, 0, 0.709578, 0, 1},
            {1.327448, 0, -0.377053, 0, 1.531574, 0, 0.662382, 0, 1},
            {1.285432, 0, -0.358195, 0, 1.462897, 0, 0.616049, 0, 1},
            {1.244279, 0, -0.338131, 0, 1.399984, 0, 0.569465, 0, 1},
            {1.208152, 0, -0.317795, 0, 1.342731, 0, 0.525988, 0, 1},
            {1.176306, 0, -0.298411, 0, 1.291266, 0, 0.485026, 0, 1},
            {1.145994, 0, -0.279626, 0, 1.244691, 0, 0.445690, 0, 1},
            {1.115618, 0, -0.260951, 0, 1.201813, 0, 0.406663, 0, 1},
            {1.087264, 0, -0.242301, 0, 1.163153, 0, 0.369296, 0, 1},
            {1.059455, 0, -0.222153, 0, 1.125428, 0, 0.332279, 0, 1},
            {1.034064, 0, -0.202894, 0, 1.091386, 0, 0.297528, 0, 1},
            {1.011627, 0, -0.184135, 0, 1.060351, 0, 0.264989, 0, 1},
            {0.990930, 0, -0.166174, 0, 1.031740, 0, 0.234591, 0, 1},
            {0.971057, 0, -0.148343, 0, 1.005721, 0, 0.205668, 0, 1},
            {0.952838, 0, -0.129633, 0, 0.982726, 0, 0.178213, 0, 1},
            {0.933675, 0, -0.112114, 0, 0.961719, 0, 0.152871, 0, 1},
            {0.918455, 0, -0.094587, 0, 0.944371, 0, 0.129046, 0, 1},
            {0.905734, 0, -0.078401, 0, 0.928969, 0, 0.106618, 0, 1},
            {0.896020, 0, -0.061671, 0, 0.915177, 0, 0.084168, 0, 1},
            {0.888601, 0, -0.044967, 0, 0.902650, 0, 0.061854, 0, 1},
            {0.883323, 0, -0.029851, 0, 0.892035, 0, 0.040600, 0, 1},
            {0.878707, 0, -0.014673, 0, 0.882504, 0, 0.019807, 0, 1},
            {0.873546, 0, 0.000659, 0, 0.873541, 0, -0.000367, 0, 1},
            {500.016876, 0, -0.681783, 0, 732.371582, 0, 340.902985, 0, 1},
            {500.016876, 0, -0.681783, 0, 732.371582, 0, 340.902985, 0, 1},
            {496.155914, 0, -0.681784, 0, 726.702454, 0, 338.271820, 0, 1},
            {220.495682, 0, -0.681779, 0, 323.010406, 0, 150.330475, 0, 1},
            {124.033257, 0, -0.681764, 0, 181.677536, 0, 84.563828, 0, 1},
            {79.408386, 0, -0.681732, 0, 116.274788, 0, 54.139229, 0, 1},
            {55.120922, 0, -0.681676, 0, 80.743622, 0, 37.580193, 0, 1},
            {40.497543, 0, -0.681584, 0, 59.318542, 0, 27.609968, 0, 1},
            {31.002672, 0, -0.681442, 0, 45.409443, 0, 21.136337, 0, 1},
            {24.493113, 0, -0.681236, 0, 35.873871, 0, 16.697989, 0, 1},
            {19.836802, 0, -0.680952, 0, 29.052166, 0, 13.523138, 0, 1},
            {16.391424, 0, -0.680570, 0, 24.003088, 0, 11.173841, 0, 1},
            {13.770196, 0, -0.680072, 0, 20.160379, 0, 9.386407, 0, 1},
            {11.730108, 0, -0.679436, 0, 17.170685, 0, 7.995108, 0, 1},
            {10.111138, 0, -0.678637, 0, 14.796307, 0, 6.890862, 0, 1},
            {8.804667, 0, -0.677631, 0, 12.879583, 0, 5.999617, 0, 1},
            {7.735567, 0, -0.676267, 0, 11.309587, 0, 5.270127, 0, 1},
            {6.850010, 0, -0.673349, 0, 10.008334, 0, 4.665566, 0, 1},
            {6.108877, 0, -0.666476, 0, 8.917023, 0, 4.158981, 0, 1},
            {5.480227, 0, -0.662130, 0, 7.991238, 0, 3.729142, 0, 1},
            {4.943895, 0, -0.657692, 0, 7.200201, 0, 3.362040, 0, 1},
            {4.482470, 0, -0.654025, 0, 6.518629, 0, 3.045914, 0, 1},
            {4.083369, 0, -0.648919, 0, 5.927822, 0, 2.771881, 0, 1},
            {3.737030, 0, -0.641517, 0, 5.412598, 0, 2.533196, 0, 1},
            {3.433909, 0, -0.633991, 0, 4.959464, 0, 2.323574, 0, 1},
            {3.167929, 0, -0.626710, 0, 4.560731, 0, 2.138983, 0, 1},
            {2.934361, 0, -0.618678, 0, 4.206789, 0, 1.975868, 0, 1},
            {2.731036, 0, -0.609360, 0, 3.891839, 0, 1.832556, 0, 1},
            {2.552360, 0, -0.600730, 0, 3.611895, 0, 1.705638, 0, 1},
            {2.397617, 0, -0.591453, 0, 3.360650, 0, 1.594607, 0, 1},
            {2.259826, 0, -0.582914, 0, 3.137116, 0, 1.495050, 0, 1},
            {2.136186, 0, -0.574709, 0, 2.939179, 0, 1.405275, 0, 1},
            {2.027894, 0, -0.565916, 0, 2.755896, 0, 1.324382, 0, 1},
            {1.925520, 0, -0.552896, 0, 2.582570, 0, 1.245067, 0, 1},
            {1.827450, 0, -0.535966, 0, 2.418150, 0, 1.166359, 0, 1},
            {1.740295, 0, -0.519019, 0, 2.268801, 0, 1.093660, 0, 1},
            {1.662354, 0, -0.500280, 0, 2.133667, 0, 1.026175, 0, 1},
            {1.591575, 0, -0.482772, 0, 2.010278, 0, 0.962501, 0, 1},
            {1.527386, 0, -0.464290, 0, 1.899148, 0, 0.902033, 0, 1},
            {1.469803, 0, -0.445517, 0, 1.799705, 0, 0.845807, 0, 1},
            {1.417182, 0, -0.427603, 0, 1.707743, 0, 0.791809, 0, 1},
            {1.370499, 0, -0.409700, 0, 1.625589, 0, 0.741554, 0, 1},
            {1.326349, 0, -0.390878, 0, 1.550612, 0, 0.692471, 0, 1},
            {1.284132, 0, -0.372653, 0, 1.482105, 0, 0.643872, 0, 1},
            {1.246743, 0, -0.351932, 0, 1.416913, 0, 0.596930, 0, 1},
            {1.208694, 0, -0.330888, 0, 1.357680, 0, 0.549688, 0, 1},
            {1.175035, 0, -0.309654, 0, 1.303756, 0, 0.505529, 0, 1},
            {1.145971, 0, -0.290014, 0, 1.255198, 0, 0.464900, 0, 1},
            {1.116934, 0, -0.270010, 0, 1.210890, 0, 0.424332, 0, 1},
            {1.088665, 0, -0.251156, 0, 1.171127, 0, 0.385352, 0, 1},
            {1.061705, 0, -0.231114, 0, 1.133231, 0, 0.346937, 0, 1},
            {1.034626, 0, -0.210698, 0, 1.097110, 0, 0.309980, 0, 1},
            {1.011930, 0, -0.190783, 0, 1.065267, 0, 0.275522, 0, 1},
            {0.989540, 0, -0.171851, 0, 1.035638, 0, 0.243229, 0, 1},
            {0.971887, 0, -0.153392, 0, 1.009374, 0, 0.213532, 0, 1},
            {0.953534, 0, -0.135031, 0, 0.985142, 0, 0.185297, 0, 1},
            {0.934509, 0, -0.116182, 0, 0.963268, 0, 0.158043, 0, 1},
            {0.917624, 0, -0.097711, 0, 0.944910, 0, 0.133504, 0, 1},
            {0.904516, 0, -0.081121, 0, 0.928990, 0, 0.110361, 0, 1},
            {0.894524, 0, -0.063957, 0, 0.915037, 0, 0.087158, 0, 1},
            {0.886979, 0, -0.047131, 0, 0.902208, 0, 0.064242, 0, 1},
            {0.881912, 0, -0.030413, 0, 0.891152, 0, 0.041851, 0, 1},
            {0.877410, 0, -0.014838, 0, 0.881437, 0, 0.020394, 0, 1},
            {0.872406, 0, -0.000274, 0, 0.872409, 0, 0.000072, 0, 1},
            {500.032013, 0, -0.718945, 0, 758.369934, 0, 359.495880, 0, 1},
            {500.032013, 0, -0.718945, 0, 758.369934, 0, 359.495880, 0, 1},
            {496.130157, 0, -0.718945, 0, 752.568359, 0, 356.691406, 0, 1},
            {220.512146, 0, -0.718939, 0, 334.448303, 0, 158.537460, 0, 1},
            {124.039993, 0, -0.718922, 0, 188.145279, 0, 89.178047, 0, 1},
            {79.382301, 0, -0.718885, 0, 120.416916, 0, 57.071358, 0, 1},
            {55.120506, 0, -0.718820, 0, 83.611397, 0, 39.628212, 0, 1},
            {40.496445, 0, -0.718711, 0, 61.426361, 0, 29.114059, 0, 1},
            {31.000265, 0, -0.718545, 0, 47.020287, 0, 22.286556, 0, 1},
            {24.492365, 0, -0.718304, 0, 37.146885, 0, 17.607481, 0, 1},
            {19.835760, 0, -0.717970, 0, 30.081579, 0, 14.259347, 0, 1},
            {16.390028, 0, -0.717523, 0, 24.852650, 0, 11.781696, 0, 1},
            {13.768762, 0, -0.716939, 0, 20.874529, 0, 9.896759, 0, 1},
            {11.728228, 0, -0.716195, 0, 17.776852, 0, 8.429270, 0, 1},
            {10.108951, 0, -0.715258, 0, 15.317552, 0, 7.264587, 0, 1},
            {8.802353, 0, -0.714073, 0, 13.332113, 0, 6.324620, 0, 1},
            {7.733030, 0, -0.712416, 0, 11.705751, 0, 5.555141, 0, 1},
            {6.847572, 0, -0.707902, 0, 10.357367, 0, 4.917505, 0, 1},
            {6.105253, 0, -0.701894, 0, 9.224761, 0, 4.382462, 0, 1},
            {5.476176, 0, -0.697378, 0, 8.265043, 0, 3.928820, 0, 1},
            {4.939616, 0, -0.692705, 0, 7.444839, 0, 3.541454, 0, 1},
            {4.477792, 0, -0.688335, 0, 6.738754, 0, 3.207675, 0, 1},
            {4.078594, 0, -0.682563, 0, 6.125970, 0, 2.918445, 0, 1},
            {3.732535, 0, -0.674057, 0, 5.590599, 0, 2.666733, 0, 1},
            {3.428672, 0, -0.666706, 0, 5.120468, 0, 2.445154, 0, 1},
            {3.162721, 0, -0.658748, 0, 4.705711, 0, 2.250343, 0, 1},
            {2.930273, 0, -0.648831, 0, 4.337759, 0, 2.078657, 0, 1},
            {2.726574, 0, -0.639266, 0, 4.009264, 0, 1.927037, 0, 1},
            {2.549029, 0, -0.629298, 0, 3.717577, 0, 1.793829, 0, 1},
            {2.392198, 0, -0.618840, 0, 3.454342, 0, 1.674880, 0, 1},
            {2.250609, 0, -0.609047, 0, 3.223337, 0, 1.566916, 0, 1},
            {2.130680, 0, -0.598721, 0, 3.012872, 0, 1.473901, 0, 1},
            {2.020753, 0, -0.589301, 0, 2.823599, 0, 1.387247, 0, 1},
            {1.923138, 0, -0.577389, 0, 2.649179, 0, 1.307466, 0, 1},
            {1.828392, 0, -0.560529, 0, 2.478947, 0, 1.226768, 0, 1},
            {1.742087, 0, -0.541997, 0, 2.322065, 0, 1.150241, 0, 1},
            {1.663531, 0, -0.522300, 0, 2.181002, 0, 1.078066, 0, 1},
            {1.593258, 0, -0.503514, 0, 2.051865, 0, 1.010960, 0, 1},
            {1.528930, 0, -0.483300, 0, 1.935584, 0, 0.946670, 0, 1},
            {1.470800, 0, -0.463543, 0, 1.831405, 0, 0.886385, 0, 1},
            {1.418596, 0, -0.444045, 0, 1.735271, 0, 0.829469, 0, 1},
            {1.370767, 0, -0.424807, 0, 1.648844, 0, 0.775200, 0, 1},
            {1.326695, 0, -0.405178, 0, 1.571946, 0, 0.723364, 0, 1},
            {1.285100, 0, -0.385776, 0, 1.501127, 0, 0.672123, 0, 1},
            {1.246613, 0, -0.365875, 0, 1.434922, 0, 0.623269, 0, 1},
            {1.211120, 0, -0.343442, 0, 1.373150, 0, 0.574652, 0, 1},
            {1.175555, 0, -0.321426, 0, 1.317194, 0, 0.527285, 0, 1},
            {1.144507, 0, -0.299880, 0, 1.265650, 0, 0.482539, 0, 1},
            {1.118137, 0, -0.279505, 0, 1.220311, 0, 0.441885, 0, 1},
            {1.089746, 0, -0.258845, 0, 1.178671, 0, 0.400607, 0, 1},
            {1.062682, 0, -0.239124, 0, 1.140741, 0, 0.361070, 0, 1},
            {1.036801, 0, -0.218450, 0, 1.103758, 0, 0.322947, 0, 1},
            {1.012466, 0, -0.197355, 0, 1.070472, 0, 0.286262, 0, 1},
            {0.990144, 0, -0.177485, 0, 1.039325, 0, 0.252411, 0, 1},
            {0.970039, 0, -0.158026, 0, 1.012321, 0, 0.220625, 0, 1},
            {0.952546, 0, -0.139411, 0, 0.987297, 0, 0.191264, 0, 1},
            {0.934977, 0, -0.120574, 0, 0.965056, 0, 0.163709, 0, 1},
            {0.917043, 0, -0.101592, 0, 0.945727, 0, 0.138122, 0, 1},
            {0.903555, 0, -0.083195, 0, 0.928961, 0, 0.113702, 0, 1},
            {0.893154, 0, -0.065870, 0, 0.914673, 0, 0.089974, 0, 1},
            {0.885244, 0, -0.049363, 0, 0.901701, 0, 0.066657, 0, 1},
            {0.880259, 0, -0.031656, 0, 0.890309, 0, 0.043354, 0, 1},
            {0.875875, 0, -0.014862, 0, 0.880188, 0, 0.020891, 0, 1},
            {0.871043, 0, 0.000256, 0, 0.870945, 0, -0.000137, 0, 1},
            {500.016571, 0, -0.757465, 0, 786.858398, 0, 378.745361, 0, 1},
            {500.016571, 0, -0.757465, 0, 786.858398, 0, 378.745361, 0, 1},
            {496.087402, 0, -0.757465, 0, 780.799805, 0, 375.770020, 0, 1},
            {220.496460, 0, -0.757456, 0, 347.001892, 0, 167.018478, 0, 1},
            {124.021706, 0, -0.757437, 0, 195.195587, 0, 93.942039, 0, 1},
            {79.354782, 0, -0.757394, 0, 124.907188, 0, 60.108276, 0, 1},
            {55.123611, 0, -0.757317, 0, 86.745041, 0, 41.753639, 0, 1},
            {40.493320, 0, -0.757190, 0, 63.723457, 0, 30.671453, 0, 1},
            {31.001829, 0, -0.756997, 0, 48.782738, 0, 23.481710, 0, 1},
            {24.491461, 0, -0.756715, 0, 38.537193, 0, 18.550026, 0, 1},
            {19.834652, 0, -0.756324, 0, 31.206244, 0, 15.022271, 0, 1},
            {16.388771, 0, -0.755801, 0, 25.780468, 0, 12.411734, 0, 1},
            {13.766821, 0, -0.755119, 0, 21.652681, 0, 10.425264, 0, 1},
            {11.726192, 0, -0.754249, 0, 18.438374, 0, 8.879026, 0, 1},
            {10.106738, 0, -0.753154, 0, 15.885935, 0, 7.651758, 0, 1},
            {8.799608, 0, -0.751759, 0, 13.825396, 0, 6.660956, 0, 1},
            {7.730100, 0, -0.749701, 0, 12.137217, 0, 5.850013, 0, 1},
            {6.844899, 0, -0.743462, 0, 10.735440, 0, 5.178157, 0, 1},
            {6.101553, 0, -0.738226, 0, 9.559602, 0, 4.613752, 0, 1},
            {5.471830, 0, -0.733636, 0, 8.562824, 0, 4.135220, 0, 1},
            {4.934471, 0, -0.728749, 0, 7.711218, 0, 3.726457, 0, 1},
            {4.473125, 0, -0.723497, 0, 6.977385, 0, 3.374942, 0, 1},
            {4.073567, 0, -0.716803, 0, 6.340463, 0, 3.069777, 0, 1},
            {3.727019, 0, -0.707811, 0, 5.784211, 0, 2.804099, 0, 1},
            {3.422580, 0, -0.700011, 0, 5.294843, 0, 2.570042, 0, 1},
            {3.157044, 0, -0.691252, 0, 4.863124, 0, 2.364830, 0, 1},
            {2.925684, 0, -0.679736, 0, 4.478961, 0, 2.184515, 0, 1},
            {2.722253, 0, -0.670128, 0, 4.136032, 0, 2.024818, 0, 1},
            {2.544445, 0, -0.658046, 0, 3.831401, 0, 1.883826, 0, 1},
            {2.382300, 0, -0.647027, 0, 3.558311, 0, 1.754153, 0, 1},
            {2.245936, 0, -0.635682, 0, 3.314620, 0, 1.643791, 0, 1},
            {2.121977, 0, -0.623786, 0, 3.093869, 0, 1.542036, 0, 1},
            {2.016015, 0, -0.613245, 0, 2.896573, 0, 1.453048, 0, 1},
            {1.920516, 0, -0.600915, 0, 2.715904, 0, 1.370420, 0, 1},
            {1.829693, 0, -0.585172, 0, 2.543165, 0, 1.288862, 0, 1},
            {1.743612, 0, -0.565172, 0, 2.379242, 0, 1.207866, 0, 1},
            {1.665633, 0, -0.544631, 0, 2.230448, 0, 1.131523, 0, 1},
            {1.594965, 0, -0.524193, 0, 2.096458, 0, 1.059918, 0, 1},
            {1.530862, 0, -0.502763, 0, 1.973897, 0, 0.992010, 0, 1},
            {1.472046, 0, -0.481219, 0, 1.864800, 0, 0.927470, 0, 1},
            {1.419386, 0, -0.460845, 0, 1.764531, 0, 0.866984, 0, 1},
            {1.371530, 0, -0.439620, 0, 1.673750, 0, 0.809381, 0, 1},
            {1.327209, 0, -0.419270, 0, 1.593743, 0, 0.754078, 0, 1},
            {1.286139, 0, -0.398293, 0, 1.520195, 0, 0.700851, 0, 1},
            {1.247699, 0, -0.378401, 0, 1.452214, 0, 0.649469, 0, 1},
            {1.210732, 0, -0.356349, 0, 1.389294, 0, 0.598509, 0, 1},
            {1.177412, 0, -0.333050, 0, 1.331034, 0, 0.549290, 0, 1},
            {1.144334, 0, -0.310286, 0, 1.277276, 0, 0.501625, 0, 1},
            {1.117230, 0, -0.288298, 0, 1.229205, 0, 0.458115, 0, 1},
            {1.090315, 0, -0.267211, 0, 1.186310, 0, 0.416001, 0, 1},
            {1.063710, 0, -0.246106, 0, 1.147072, 0, 0.374799, 0, 1},
            {1.037720, 0, -0.225958, 0, 1.110195, 0, 0.335533, 0, 1},
            {1.012769, 0, -0.204172, 0, 1.075655, 0, 0.297130, 0, 1},
            {0.990244, 0, -0.183358, 0, 1.043497, 0, 0.261470, 0, 1},
            {0.968461, 0, -0.162830, 0, 1.014392, 0, 0.227643, 0, 1},
            {0.950116, 0, -0.143248, 0, 0.988938, 0, 0.197337, 0, 1},
            {0.933208, 0, -0.124340, 0, 0.966441, 0, 0.168937, 0, 1},
            {0.916615, 0, -0.105101, 0, 0.946501, 0, 0.142467, 0, 1},
            {0.902946, 0, -0.086103, 0, 0.929131, 0, 0.117331, 0, 1},
            {0.891502, 0, -0.067630, 0, 0.914060, 0, 0.092642, 0, 1},
            {0.883863, 0, -0.050308, 0, 0.901030, 0, 0.068653, 0, 1},
            {0.878615, 0, -0.033412, 0, 0.889532, 0, 0.045106, 0, 1},
            {0.874271, 0, -0.015795, 0, 0.878952, 0, 0.021789, 0, 1},
            {0.869484, 0, 0.001046, 0, 0.869574, 0, -0.000553, 0, 1},
            {500.017303, 0, -0.797466, 0, 817.871033, 0, 398.747833, 0, 1},
            {500.017303, 0, -0.797466, 0, 817.871033, 0, 398.747833, 0, 1},
            {496.127563, 0, -0.797467, 0, 811.633179, 0, 395.647186, 0, 1},
            {220.492523, 0, -0.797459, 0, 360.665405, 0, 175.835709, 0, 1},
            {124.072601, 0, -0.797435, 0, 202.856842, 0, 98.943756, 0, 1},
            {79.373917, 0, -0.797385, 0, 129.864807, 0, 63.297756, 0, 1},
            {55.121258, 0, -0.797295, 0, 90.172737, 0, 43.956730, 0, 1},
            {40.495140, 0, -0.797146, 0, 66.241463, 0, 32.292618, 0, 1},
            {31.000458, 0, -0.796920, 0, 50.708515, 0, 24.720581, 0, 1},
            {24.491554, 0, -0.796592, 0, 40.057415, 0, 19.529551, 0, 1},
            {19.833290, 0, -0.796136, 0, 32.436165, 0, 15.814341, 0, 1},
            {16.386721, 0, -0.795526, 0, 26.795473, 0, 13.065339, 0, 1},
            {13.764978, 0, -0.794731, 0, 22.503210, 0, 10.974028, 0, 1},
            {11.723998, 0, -0.793717, 0, 19.161100, 0, 9.345816, 0, 1},
            {10.104026, 0, -0.792437, 0, 16.507286, 0, 8.053266, 0, 1},
            {8.796682, 0, -0.790791, 0, 14.364434, 0, 7.009870, 0, 1},
            {7.726801, 0, -0.788135, 0, 12.608691, 0, 6.155709, 0, 1},
            {6.840981, 0, -0.781123, 0, 11.149081, 0, 5.447814, 0, 1},
            {6.097093, 0, -0.775400, 0, 9.924636, 0, 4.853001, 0, 1},
            {5.467016, 0, -0.770942, 0, 8.887487, 0, 4.348842, 0, 1},
            {4.929003, 0, -0.765887, 0, 8.000960, 0, 3.917835, 0, 1},
            {4.467512, 0, -0.759514, 0, 7.237631, 0, 3.547466, 0, 1},
            {4.067760, 0, -0.751551, 0, 6.573490, 0, 3.225742, 0, 1},
            {3.720563, 0, -0.742531, 0, 5.994136, 0, 2.945441, 0, 1},
            {3.416248, 0, -0.733854, 0, 5.484142, 0, 2.698927, 0, 1},
            {3.151365, 0, -0.724136, 0, 5.033256, 0, 2.483075, 0, 1},
            {2.920730, 0, -0.712086, 0, 4.631833, 0, 2.293504, 0, 1},
            {2.715982, 0, -0.701324, 0, 4.273705, 0, 2.124066, 0, 1},
            {2.535126, 0, -0.687603, 0, 3.955679, 0, 1.972982, 0, 1},
            {2.377020, 0, -0.675481, 0, 3.667966, 0, 1.839237, 0, 1},
            {2.237835, 0, -0.662376, 0, 3.410899, 0, 1.720161, 0, 1},
            {2.116522, 0, -0.649335, 0, 3.179844, 0, 1.614362, 0, 1},
            {2.010905, 0, -0.636700, 0, 2.972357, 0, 1.520011, 0, 1},
            {1.916303, 0, -0.623563, 0, 2.782754, 0, 1.433122, 0, 1},
            {1.830436, 0, -0.608887, 0, 2.608755, 0, 1.351484, 0, 1},
            {1.743522, 0, -0.588093, 0, 2.439840, 0, 1.265660, 0, 1},
            {1.665256, 0, -0.567021, 0, 2.284506, 0, 1.184838, 0, 1},
            {1.595436, 0, -0.544727, 0, 2.142789, 0, 1.109166, 0, 1},
            {1.529808, 0, -0.522298, 0, 2.015306, 0, 1.036543, 0, 1},
            {1.471729, 0, -0.499149, 0, 1.899347, 0, 0.968507, 0, 1},
            {1.418189, 0, -0.477280, 0, 1.795287, 0, 0.903782, 0, 1},
            {1.371309, 0, -0.455059, 0, 1.700773, 0, 0.843494, 0, 1},
            {1.327345, 0, -0.432719, 0, 1.615324, 0, 0.784955, 0, 1},
            {1.286379, 0, -0.411237, 0, 1.539990, 0, 0.729372, 0, 1},
            {1.247780, 0, -0.389590, 0, 1.468775, 0, 0.674986, 0, 1},
            {1.211524, 0, -0.367984, 0, 1.405173, 0, 0.622546, 0, 1},
            {1.177005, 0, -0.344678, 0, 1.345087, 0, 0.570945, 0, 1},
            {1.145418, 0, -0.320562, 0, 1.289806, 0, 0.521267, 0, 1},
            {1.114639, 0, -0.297473, 0, 1.239357, 0, 0.473857, 0, 1},
            {1.090549, 0, -0.275152, 0, 1.194652, 0, 0.430556, 0, 1},
            {1.064188, 0, -0.253187, 0, 1.153395, 0, 0.388250, 0, 1},
            {1.038570, 0, -0.232337, 0, 1.116358, 0, 0.347149, 0, 1},
            {1.013901, 0, -0.210886, 0, 1.081003, 0, 0.307919, 0, 1},
            {0.990528, 0, -0.189382, 0, 1.048208, 0, 0.270504, 0, 1},
            {0.968848, 0, -0.167786, 0, 1.017692, 0, 0.235323, 0, 1},
            {0.949038, 0, -0.147367, 0, 0.990954, 0, 0.203049, 0, 1},
            {0.931911, 0, -0.127610, 0, 0.967629, 0, 0.173836, 0, 1},
            {0.915025, 0, -0.108382, 0, 0.947114, 0, 0.146519, 0, 1},
            {0.900909, 0, -0.089164, 0, 0.929632, 0, 0.120909, 0, 1},
            {0.890059, 0, -0.069694, 0, 0.913788, 0, 0.095417, 0, 1},
            {0.882400, 0, -0.051166, 0, 0.900090, 0, 0.070433, 0, 1},
            {0.876997, 0, -0.034103, 0, 0.888359, 0, 0.046330, 0, 1},
            {0.872843, 0, -0.017226, 0, 0.877864, 0, 0.022875, 0, 1},
            {0.868087, 0, 0.000993, 0, 0.868095, 0, -0.000517, 0, 1},
            {500.061951, 0, -0.839092, 0, 852.310974, 0, 419.597229, 0, 1},
            {500.061951, 0, -0.839092, 0, 852.310974, 0, 419.597229, 0, 1},
            {496.196442, 0, -0.839093, 0, 845.390015, 0, 416.356049, 0, 1},
            {220.471832, 0, -0.839081, 0, 375.759491, 0, 184.996674, 0, 1},
            {124.015244, 0, -0.839055, 0, 211.417328, 0, 104.060410, 0, 1},
            {79.380630, 0, -0.838997, 0, 135.254730, 0, 66.607300, 0, 1},
            {55.120049, 0, -0.838891, 0, 93.925743, 0, 46.250122, 0, 1},
            {40.490086, 0, -0.838720, 0, 69.000076, 0, 33.973907, 0, 1},
            {30.997051, 0, -0.838455, 0, 52.817276, 0, 26.007944, 0, 1},
            {24.481707, 0, -0.838073, 0, 41.730366, 0, 20.540449, 0, 1},
            {19.833473, 0, -0.837542, 0, 33.779564, 0, 16.639612, 0, 1},
            {16.385019, 0, -0.836833, 0, 27.906063, 0, 13.745603, 0, 1},
            {13.762700, 0, -0.835907, 0, 23.434160, 0, 11.544593, 0, 1},
            {11.721079, 0, -0.834725, 0, 19.951761, 0, 9.830773, 0, 1},
            {10.100230, 0, -0.833233, 0, 17.187639, 0, 8.469976, 0, 1},
            {8.793116, 0, -0.831283, 0, 14.953251, 0, 7.372204, 0, 1},
            {7.723076, 0, -0.827602, 0, 13.123185, 0, 6.473154, 0, 1},
            {6.836372, 0, -0.819847, 0, 11.599359, 0, 5.727441, 0, 1},
            {6.091511, 0, -0.814450, 0, 10.322539, 0, 5.100740, 0, 1},
            {5.461082, 0, -0.809315, 0, 9.241489, 0, 4.569826, 0, 1},
            {4.922778, 0, -0.804183, 0, 8.316956, 0, 4.115965, 0, 1},
            {4.460990, 0, -0.796565, 0, 7.520323, 0, 3.725735, 0, 1},
            {4.061113, 0, -0.787762, 0, 6.826444, 0, 3.386944, 0, 1},
            {3.713335, 0, -0.778575, 0, 6.222120, 0, 3.091404, 0, 1},
            {3.409401, 0, -0.769000, 0, 5.689177, 0, 2.832045, 0, 1},
            {3.145958, 0, -0.757468, 0, 5.216529, 0, 2.605641, 0, 1},
            {2.913903, 0, -0.745044, 0, 4.797429, 0, 2.405021, 0, 1},
            {2.706408, 0, -0.732698, 0, 4.423292, 0, 2.224132, 0, 1},
            {2.528517, 0, -0.718415, 0, 4.087810, 0, 2.067148, 0, 1},
            {2.368678, 0, -0.704462, 0, 3.787008, 0, 1.924415, 0, 1},
            {2.231644, 0, -0.689712, 0, 3.514945, 0, 1.800064, 0, 1},
            {2.111736, 0, -0.675275, 0, 3.272635, 0, 1.689158, 0, 1},
            {2.005742, 0, -0.660258, 0, 3.051764, 0, 1.588759, 0, 1},
            {1.909973, 0, -0.646635, 0, 2.855904, 0, 1.496072, 0, 1},
            {1.819564, 0, -0.631361, 0, 2.678693, 0, 1.406525, 0, 1},
            {1.738574, 0, -0.611670, 0, 2.506556, 0, 1.321244, 0, 1},
            {1.660726, 0, -0.589152, 0, 2.342970, 0, 1.236298, 0, 1},
            {1.590554, 0, -0.565663, 0, 2.194014, 0, 1.156271, 0, 1},
            {1.526449, 0, -0.541301, 0, 2.059833, 0, 1.080103, 0, 1},
            {1.467188, 0, -0.517240, 0, 1.938357, 0, 1.007356, 0, 1},
            {1.414559, 0, -0.493476, 0, 1.828179, 0, 0.939381, 0, 1},
            {1.370525, 0, -0.470171, 0, 1.729083, 0, 0.877393, 0, 1},
            {1.325549, 0, -0.446532, 0, 1.639331, 0, 0.815431, 0, 1},
            {1.286233, 0, -0.423341, 0, 1.559244, 0, 0.757016, 0, 1},
            {1.247492, 0, -0.401134, 0, 1.486929, 0, 0.700020, 0, 1},
            {1.212348, 0, -0.378347, 0, 1.420771, 0, 0.645661, 0, 1},
            {1.177561, 0, -0.355993, 0, 1.359709, 0, 0.592399, 0, 1},
            {1.145355, 0, -0.330840, 0, 1.302774, 0, 0.540237, 0, 1},
            {1.114929, 0, -0.306848, 0, 1.250311, 0, 0.490992, 0, 1},
            {1.089528, 0, -0.282816, 0, 1.203116, 0, 0.444872, 0, 1},
            {1.063232, 0, -0.260588, 0, 1.160838, 0, 0.400718, 0, 1},
            {1.039013, 0, -0.237949, 0, 1.121873, 0, 0.358791, 0, 1},
            {1.014354, 0, -0.216970, 0, 1.086610, 0, 0.318310, 0, 1},
            {0.991115, 0, -0.195158, 0, 1.052459, 0, 0.279775, 0, 1},
            {0.968756, 0, -0.173124, 0, 1.021447, 0, 0.243295, 0, 1},
            {0.949337, 0, -0.151596, 0, 0.993445, 0, 0.209255, 0, 1},
            {0.931425, 0, -0.130794, 0, 0.968499, 0, 0.178360, 0, 1},
            {0.913483, 0, -0.111179, 0, 0.947533, 0, 0.150638, 0, 1},
            {0.898757, 0, -0.091677, 0, 0.929436, 0, 0.124443, 0, 1},
            {0.888046, 0, -0.072420, 0, 0.913495, 0, 0.098317, 0, 1},
            {0.880235, 0, -0.052744, 0, 0.899423, 0, 0.072399, 0, 1},
            {0.875197, 0, -0.034421, 0, 0.887249, 0, 0.047351, 0, 1},
            {0.871148, 0, -0.017173, 0, 0.876458, 0, 0.023356, 0, 1},
            {0.866682, 0, -0.000118, 0, 0.866652, 0, 0.000045, 0, 1},
            {500.131042, 0, -0.882497, 0, 889.079346, 0, 441.363556, 0, 1},
            {500.131042, 0, -0.882497, 0, 889.079346, 0, 441.363556, 0, 1},
            {495.881348, 0, -0.882497, 0, 882.177551, 0, 437.613770, 0, 1},
            {220.509079, 0, -0.882485, 0, 392.221130, 0, 194.599243, 0, 1},
            {124.028885, 0, -0.882453, 0, 220.623901, 0, 109.455116, 0, 1},
            {79.377640, 0, -0.882386, 0, 141.192078, 0, 70.050079, 0, 1},
            {55.118439, 0, -0.882263, 0, 98.043686, 0, 48.640995, 0, 1},
            {40.493782, 0, -0.882064, 0, 72.019936, 0, 35.734364, 0, 1},
            {30.999401, 0, -0.881756, 0, 55.125107, 0, 27.355206, 0, 1},
            {24.487234, 0, -0.881312, 0, 43.546761, 0, 21.607693, 0, 1},
            {19.829800, 0, -0.880694, 0, 35.258209, 0, 17.496971, 0, 1},
            {16.382486, 0, -0.879869, 0, 29.123596, 0, 14.454084, 0, 1},
            {13.760002, 0, -0.878792, 0, 24.454414, 0, 12.139007, 0, 1},
            {11.717984, 0, -0.877418, 0, 20.818827, 0, 10.336102, 0, 1},
            {10.097014, 0, -0.875677, 0, 17.930525, 0, 8.904661, 0, 1},
            {8.789146, 0, -0.873344, 0, 15.597968, 0, 7.749365, 0, 1},
            {7.718943, 0, -0.867686, 0, 13.683362, 0, 6.803425, 0, 1},
            {6.830849, 0, -0.860952, 0, 12.092108, 0, 6.017935, 0, 1},
            {6.085179, 0, -0.855248, 0, 10.758094, 0, 5.357964, 0, 1},
            {5.454656, 0, -0.849018, 0, 9.627773, 0, 4.799277, 0, 1},
            {4.915613, 0, -0.843686, 0, 8.661961, 0, 4.321169, 0, 1},
            {4.453752, 0, -0.834738, 0, 7.827643, 0, 3.910462, 0, 1},
            {4.053242, 0, -0.825356, 0, 7.102279, 0, 3.553410, 0, 1},
            {3.705397, 0, -0.815419, 0, 6.469771, 0, 3.242329, 0, 1},
            {3.402260, 0, -0.804816, 0, 5.911213, 0, 2.969801, 0, 1},
            {3.140205, 0, -0.792056, 0, 5.414690, 0, 2.732658, 0, 1},
            {2.903370, 0, -0.778928, 0, 4.978415, 0, 2.517220, 0, 1},
            {2.700214, 0, -0.764462, 0, 4.582938, 0, 2.330147, 0, 1},
            {2.519197, 0, -0.749486, 0, 4.231819, 0, 2.162038, 0, 1},
            {2.363564, 0, -0.733487, 0, 3.913390, 0, 2.015040, 0, 1},
            {2.226328, 0, -0.717834, 0, 3.626251, 0, 1.883066, 0, 1},
            {2.107657, 0, -0.701267, 0, 3.369889, 0, 1.766898, 0, 1},
            {1.998437, 0, -0.684466, 0, 3.138471, 0, 1.657171, 0, 1},
            {1.899259, 0, -0.669577, 0, 2.934640, 0, 1.556509, 0, 1},
            {1.814318, 0, -0.652042, 0, 2.745214, 0, 1.465691, 0, 1},
            {1.736606, 0, -0.633872, 0, 2.572179, 0, 1.379555, 0, 1},
            {1.661191, 0, -0.611125, 0, 2.402454, 0, 1.291961, 0, 1},
            {1.590615, 0, -0.586628, 0, 2.247036, 0, 1.207066, 0, 1},
            {1.526334, 0, -0.560843, 0, 2.106422, 0, 1.126522, 0, 1},
            {1.467914, 0, -0.535057, 0, 1.978291, 0, 1.049531, 0, 1},
            {1.414042, 0, -0.510065, 0, 1.862797, 0, 0.977122, 0, 1},
            {1.365696, 0, -0.485082, 0, 1.758440, 0, 0.908894, 0, 1},
            {1.321159, 0, -0.460233, 0, 1.665493, 0, 0.843520, 0, 1},
            {1.284118, 0, -0.435750, 0, 1.580328, 0, 0.783909, 0, 1},
            {1.248044, 0, -0.412070, 0, 1.504833, 0, 0.725637, 0, 1},
            {1.211028, 0, -0.388556, 0, 1.436081, 0, 0.667618, 0, 1},
            {1.178240, 0, -0.365558, 0, 1.373633, 0, 0.613518, 0, 1},
            {1.145880, 0, -0.341586, 0, 1.316458, 0, 0.559875, 0, 1},
            {1.116671, 0, -0.315906, 0, 1.261373, 0, 0.508747, 0, 1},
            {1.086212, 0, -0.291249, 0, 1.211337, 0, 0.458242, 0, 1},
            {1.062977, 0, -0.267059, 0, 1.167779, 0, 0.413072, 0, 1},
            {1.036993, 0, -0.244402, 0, 1.128034, 0, 0.369039, 0, 1},
            {1.014246, 0, -0.221603, 0, 1.091346, 0, 0.327930, 0, 1},
            {0.991596, 0, -0.200200, 0, 1.057211, 0, 0.288680, 0, 1},
            {0.969782, 0, -0.178648, 0, 1.024976, 0, 0.251601, 0, 1},
            {0.948710, 0, -0.155682, 0, 0.996039, 0, 0.215546, 0, 1},
            {0.930451, 0, -0.134603, 0, 0.969911, 0, 0.183457, 0, 1},
            {0.912840, 0, -0.113499, 0, 0.947872, 0, 0.154009, 0, 1},
            {0.897718, 0, -0.093768, 0, 0.929566, 0, 0.127358, 0, 1},
            {0.886099, 0, -0.074419, 0, 0.913216, 0, 0.100924, 0, 1},
            {0.878136, 0, -0.055149, 0, 0.898608, 0, 0.074780, 0, 1},
            {0.873177, 0, -0.035307, 0, 0.886040, 0, 0.048633, 0, 1},
            {0.869362, 0, -0.016836, 0, 0.874910, 0, 0.023622, 0, 1},
            {0.864932, 0, 0.000313, 0, 0.864848, 0, -0.000105, 0, 1},
            {499.908478, 0, -0.927855, 0, 930.500305, 0, 463.842773, 0, 1},
            {499.908478, 0, -0.927855, 0, 930.500305, 0, 463.842773, 0, 1},
            {496.019867, 0, -0.927855, 0, 923.053040, 0, 460.236145, 0, 1},
            {220.502594, 0, -0.927841, 0, 410.345581, 0, 204.594955, 0, 1},
            {124.029205, 0, -0.927803, 0, 230.803741, 0, 115.081070, 0, 1},
            {79.378181, 0, -0.927727, 0, 147.705490, 0, 73.650932, 0, 1},
            {55.116497, 0, -0.927583, 0, 102.567078, 0, 51.139164, 0, 1},
            {40.490452, 0, -0.927351, 0, 75.345779, 0, 37.567810, 0, 1},
            {30.996964, 0, -0.926994, 0, 57.670261, 0, 28.758696, 0, 1},
            {24.488325, 0, -0.926478, 0, 45.551537, 0, 22.719057, 0, 1},
            {19.827961, 0, -0.925760, 0, 36.881195, 0, 18.394314, 0, 1},
            {16.379869, 0, -0.924802, 0, 30.461296, 0, 15.194170, 0, 1},
            {13.756917, 0, -0.923550, 0, 25.574484, 0, 12.759556, 0, 1},
            {11.714156, 0, -0.921954, 0, 21.769402, 0, 10.863268, 0, 1},
            {10.093195, 0, -0.919921, 0, 18.746195, 0, 9.358130, 0, 1},
            {8.784454, 0, -0.917080, 0, 16.304501, 0, 8.142523, 0, 1},
            {7.713624, 0, -0.909769, 0, 14.297624, 0, 7.147200, 0, 1},
            {6.823885, 0, -0.903473, 0, 12.631841, 0, 6.319734, 0, 1},
            {6.077799, 0, -0.897557, 0, 11.234589, 0, 5.625329, 0, 1},
            {5.446403, 0, -0.890848, 0, 10.050310, 0, 5.036999, 0, 1},
            {4.907801, 0, -0.884419, 0, 9.038234, 0, 4.534451, 0, 1},
            {4.445316, 0, -0.873740, 0, 8.162788, 0, 4.101727, 0, 1},
            {4.044328, 0, -0.864251, 0, 7.402873, 0, 3.725650, 0, 1},
            {3.696771, 0, -0.852993, 0, 6.738603, 0, 3.398484, 0, 1},
            {3.395342, 0, -0.841136, 0, 6.151515, 0, 3.113235, 0, 1},
            {3.127434, 0, -0.827421, 0, 5.632942, 0, 2.858315, 0, 1},
            {2.895621, 0, -0.813156, 0, 5.172462, 0, 2.635826, 0, 1},
            {2.690136, 0, -0.797548, 0, 4.757117, 0, 2.436781, 0, 1},
            {2.512220, 0, -0.781254, 0, 4.385640, 0, 2.261955, 0, 1},
            {2.358229, 0, -0.763409, 0, 4.048933, 0, 2.108631, 0, 1},
            {2.218923, 0, -0.746178, 0, 3.746610, 0, 1.967116, 0, 1},
            {2.092763, 0, -0.727519, 0, 3.478552, 0, 1.837282, 0, 1},
            {1.986424, 0, -0.709407, 0, 3.234240, 0, 1.724144, 0, 1},
            {1.892072, 0, -0.692215, 0, 3.014810, 0, 1.620646, 0, 1},
            {1.809130, 0, -0.673452, 0, 2.817690, 0, 1.526411, 0, 1},
            {1.733035, 0, -0.654370, 0, 2.637035, 0, 1.436569, 0, 1},
            {1.658695, 0, -0.633478, 0, 2.467819, 0, 1.346815, 0, 1},
            {1.588832, 0, -0.607105, 0, 2.302829, 0, 1.257592, 0, 1},
            {1.527209, 0, -0.580322, 0, 2.154327, 0, 1.174574, 0, 1},
            {1.468240, 0, -0.552996, 0, 2.019936, 0, 1.092972, 0, 1},
            {1.414084, 0, -0.526105, 0, 1.899011, 0, 1.015422, 0, 1},
            {1.365278, 0, -0.500260, 0, 1.789665, 0, 0.943152, 0, 1},
            {1.320623, 0, -0.473509, 0, 1.691689, 0, 0.874706, 0, 1},
            {1.279080, 0, -0.448183, 0, 1.602969, 0, 0.808758, 0, 1},
            {1.245666, 0, -0.422511, 0, 1.523303, 0, 0.749607, 0, 1},
            {1.211175, 0, -0.398514, 0, 1.451762, 0, 0.690656, 0, 1},
            {1.177195, 0, -0.374133, 0, 1.386911, 0, 0.632779, 0, 1},
            {1.146160, 0, -0.350095, 0, 1.329179, 0, 0.578229, 0, 1},
            {1.115566, 0, -0.325518, 0, 1.273694, 0, 0.525008, 0, 1},
            {1.086968, 0, -0.299404, 0, 1.221791, 0, 0.473555, 0, 1},
            {1.061792, 0, -0.274184, 0, 1.175437, 0, 0.425841, 0, 1},
            {1.036679, 0, -0.250434, 0, 1.134076, 0, 0.379570, 0, 1},
            {1.012360, 0, -0.226726, 0, 1.096226, 0, 0.336435, 0, 1},
            {0.989209, 0, -0.204502, 0, 1.061142, 0, 0.296004, 0, 1},
            {0.970135, 0, -0.182453, 0, 1.028751, 0, 0.258358, 0, 1},
            {0.948646, 0, -0.160789, 0, 0.998611, 0, 0.222258, 0, 1},
            {0.929732, 0, -0.138072, 0, 0.971441, 0, 0.188430, 0, 1},
            {0.912429, 0, -0.116434, 0, 0.948350, 0, 0.157687, 0, 1},
            {0.895975, 0, -0.095600, 0, 0.928999, 0, 0.130181, 0, 1},
            {0.884479, 0, -0.075905, 0, 0.912408, 0, 0.103223, 0, 1},
            {0.876235, 0, -0.056627, 0, 0.897797, 0, 0.076690, 0, 1},
            {0.871366, 0, -0.037032, 0, 0.884918, 0, 0.050406, 0, 1},
            {0.867513, 0, -0.017359, 0, 0.873494, 0, 0.024282, 0, 1},
            {0.862955, 0, 0.001008, 0, 0.862967, 0, -0.000406, 0, 1},
            {498.993134, 0, -0.975364, 0, 976.678406, 0, 486.700562, 0, 1},
            {498.993134, 0, -0.975364, 0, 976.678406, 0, 486.700562, 0, 1},
            {496.104645, 0, -0.975363, 0, 968.191040, 0, 483.884094, 0, 1},
            {220.493851, 0, -0.975346, 0, 430.348663, 0, 215.060410, 0, 1},
            {124.026276, 0, -0.975303, 0, 242.001144, 0, 120.970490, 0, 1},
            {79.373550, 0, -0.975213, 0, 154.865677, 0, 77.417633, 0, 1},
            {55.121506, 0, -0.975046, 0, 107.539261, 0, 53.762280, 0, 1},
            {40.495274, 0, -0.974777, 0, 79.001297, 0, 39.495827, 0, 1},
            {30.994772, 0, -0.974362, 0, 60.471733, 0, 30.228813, 0, 1},
            {24.483818, 0, -0.973762, 0, 47.757706, 0, 23.877586, 0, 1},
            {19.826784, 0, -0.972930, 0, 38.664623, 0, 19.334599, 0, 1},
            {16.377377, 0, -0.971816, 0, 31.930515, 0, 15.969238, 0, 1},
            {13.753089, 0, -0.970365, 0, 26.807053, 0, 13.408640, 0, 1},
            {11.710072, 0, -0.968508, 0, 22.814585, 0, 11.414821, 0, 1},
            {10.088183, 0, -0.966128, 0, 19.643433, 0, 9.831615, 0, 1},
            {8.779231, 0, -0.962527, 0, 17.080414, 0, 8.553432, 0, 1},
            {7.706794, 0, -0.954200, 0, 14.971908, 0, 7.505392, 0, 1},
            {6.816430, 0, -0.947334, 0, 13.222908, 0, 6.634820, 0, 1},
            {6.069510, 0, -0.941459, 0, 11.756576, 0, 5.903896, 0, 1},
            {5.437681, 0, -0.934260, 0, 10.513264, 0, 5.284787, 0, 1},
            {4.898997, 0, -0.926350, 0, 9.449535, 0, 4.756173, 0, 1},
            {4.435613, 0, -0.914688, 0, 8.529024, 0, 4.300109, 0, 1},
            {4.034491, 0, -0.904784, 0, 7.731143, 0, 3.904481, 0, 1},
            {3.687969, 0, -0.891974, 0, 7.031538, 0, 3.561143, 0, 1},
            {3.385607, 0, -0.878620, 0, 6.413283, 0, 3.260022, 0, 1},
            {3.117722, 0, -0.864378, 0, 5.868060, 0, 2.991642, 0, 1},
            {2.885299, 0, -0.847743, 0, 5.381703, 0, 2.756853, 0, 1},
            {2.681940, 0, -0.831104, 0, 4.944142, 0, 2.548940, 0, 1},
            {2.506321, 0, -0.813058, 0, 4.549020, 0, 2.366774, 0, 1},
            {2.350028, 0, -0.794126, 0, 4.195113, 0, 2.202568, 0, 1},
            {2.206787, 0, -0.774717, 0, 3.878904, 0, 2.049569, 0, 1},
            {2.086035, 0, -0.753674, 0, 3.590309, 0, 1.916902, 0, 1},
            {1.980427, 0, -0.734701, 0, 3.333446, 0, 1.797973, 0, 1},
            {1.886191, 0, -0.714553, 0, 3.099187, 0, 1.687468, 0, 1},
            {1.800217, 0, -0.695010, 0, 2.894012, 0, 1.585271, 0, 1},
            {1.724818, 0, -0.673644, 0, 2.702550, 0, 1.490888, 0, 1},
            {1.656403, 0, -0.653161, 0, 2.529073, 0, 1.401430, 0, 1},
            {1.589200, 0, -0.627952, 0, 2.361250, 0, 1.310598, 0, 1},
            {1.525179, 0, -0.599427, 0, 2.204435, 0, 1.220875, 0, 1},
            {1.465978, 0, -0.570864, 0, 2.064462, 0, 1.134797, 0, 1},
            {1.411806, 0, -0.542452, 0, 1.936784, 0, 1.053385, 0, 1},
            {1.364771, 0, -0.514894, 0, 1.821312, 0, 0.977994, 0, 1},
            {1.319653, 0, -0.487250, 0, 1.719127, 0, 0.905201, 0, 1},
            {1.278415, 0, -0.460174, 0, 1.626256, 0, 0.836438, 0, 1},
            {1.239993, 0, -0.433354, 0, 1.542820, 0, 0.770893, 0, 1},
            {1.208869, 0, -0.407817, 0, 1.467569, 0, 0.711487, 0, 1},
            {1.176574, 0, -0.382780, 0, 1.400645, 0, 0.652386, 0, 1},
            {1.144650, 0, -0.357695, 0, 1.339664, 0, 0.595230, 0, 1},
            {1.115058, 0, -0.333450, 0, 1.284167, 0, 0.541150, 0, 1},
            {1.088207, 0, -0.307685, 0, 1.232362, 0, 0.488884, 0, 1},
            {1.059847, 0, -0.281549, 0, 1.183181, 0, 0.437421, 0, 1},
            {1.036572, 0, -0.256226, 0, 1.139530, 0, 0.390744, 0, 1},
            {1.010978, 0, -0.232329, 0, 1.100796, 0, 0.345220, 0, 1},
            {0.987828, 0, -0.208445, 0, 1.064368, 0, 0.303018, 0, 1},
            {0.967001, 0, -0.186070, 0, 1.031720, 0, 0.264075, 0, 1},
            {0.946787, 0, -0.164335, 0, 1.000664, 0, 0.227604, 0, 1},
            {0.929630, 0, -0.141922, 0, 0.973669, 0, 0.193628, 0, 1},
            {0.911838, 0, -0.119756, 0, 0.949531, 0, 0.162297, 0, 1},
            {0.895213, 0, -0.098019, 0, 0.929034, 0, 0.133357, 0, 1},
            {0.883037, 0, -0.076844, 0, 0.911660, 0, 0.105312, 0, 1},
            {0.874419, 0, -0.057609, 0, 0.896608, 0, 0.078392, 0, 1},
            {0.869289, 0, -0.037963, 0, 0.883639, 0, 0.051558, 0, 1},
            {0.865568, 0, -0.018772, 0, 0.871991, 0, 0.025276, 0, 1},
            {0.861164, 0, 0.000968, 0, 0.861110, 0, -0.000445, 0, 1},
            {500.037872, 0, -1.025238, 0, 1025.517090, 0, 512.657776, 0, 1},
            {500.037872, 0, -1.025238, 0, 1025.517090, 0, 512.657776, 0, 1},
            {496.149597, 0, -1.025239, 0, 1017.573975, 0, 508.672821, 0, 1},
            {220.490112, 0, -1.025220, 0, 452.287750, 0, 226.055649, 0, 1},
            {123.898338, 0, -1.025170, 0, 254.619720, 0, 127.025589, 0, 1},
            {79.391258, 0, -1.025063, 0, 162.793762, 0, 81.394318, 0, 1},
            {55.119484, 0, -1.024873, 0, 113.037849, 0, 56.509220, 0, 1},
            {40.488483, 0, -1.024557, 0, 83.037262, 0, 41.508354, 0, 1},
            {30.993290, 0, -1.024077, 0, 63.554382, 0, 31.772776, 0, 1},
            {24.480589, 0, -1.023379, 0, 50.200405, 0, 25.094837, 0, 1},
            {19.822830, 0, -1.022414, 0, 40.632015, 0, 20.318817, 0, 1},
            {16.373678, 0, -1.021120, 0, 33.553726, 0, 16.781538, 0, 1},
            {13.748674, 0, -1.019434, 0, 28.165298, 0, 14.089147, 0, 1},
            {11.705168, 0, -1.017277, 0, 23.967451, 0, 11.992762, 0, 1},
            {10.083005, 0, -1.014477, 0, 20.631399, 0, 10.328159, 0, 1},
            {8.772611, 0, -1.009526, 0, 17.933300, 0, 8.982896, 0, 1},
            {7.699113, 0, -1.000448, 0, 15.712477, 0, 7.880071, 0, 1},
            {6.807818, 0, -0.993442, 0, 13.872507, 0, 6.963836, 0, 1},
            {6.060381, 0, -0.987011, 0, 12.329924, 0, 6.194833, 0, 1},
            {5.427757, 0, -0.979336, 0, 11.021285, 0, 5.543046, 0, 1},
            {4.888412, 0, -0.969358, 0, 9.900178, 0, 4.986307, 0, 1},
            {4.424665, 0, -0.957246, 0, 8.929996, 0, 4.506370, 0, 1},
            {4.023794, 0, -0.946408, 0, 8.089095, 0, 4.090411, 0, 1},
            {3.677202, 0, -0.931942, 0, 7.350788, 0, 3.729072, 0, 1},
            {3.372041, 0, -0.917404, 0, 6.700420, 0, 3.409127, 0, 1},
            {3.105673, 0, -0.902082, 0, 6.123778, 0, 3.128247, 0, 1},
            {2.875522, 0, -0.883758, 0, 5.608041, 0, 2.883012, 0, 1},
            {2.674237, 0, -0.865197, 0, 5.144587, 0, 2.666038, 0, 1},
            {2.497020, 0, -0.845380, 0, 4.726780, 0, 2.472375, 0, 1},
            {2.336472, 0, -0.825321, 0, 4.355277, 0, 2.294547, 0, 1},
            {2.199103, 0, -0.803629, 0, 4.016941, 0, 2.138724, 0, 1},
            {2.078905, 0, -0.780611, 0, 3.711555, 0, 1.998574, 0, 1},
            {1.970641, 0, -0.759876, 0, 3.438906, 0, 1.869376, 0, 1},
            {1.877239, 0, -0.737689, 0, 3.191887, 0, 1.753589, 0, 1},
            {1.794387, 0, -0.715423, 0, 2.969989, 0, 1.647656, 0, 1},
            {1.717408, 0, -0.693435, 0, 2.773737, 0, 1.546270, 0, 1},
            {1.649466, 0, -0.671235, 0, 2.589671, 0, 1.452259, 0, 1},
            {1.586323, 0, -0.647398, 0, 2.420877, 0, 1.361515, 0, 1},
            {1.523070, 0, -0.618852, 0, 2.259597, 0, 1.267477, 0, 1},
            {1.466873, 0, -0.588191, 0, 2.109860, 0, 1.179627, 0, 1},
            {1.412098, 0, -0.558778, 0, 1.976553, 0, 1.093307, 0, 1},
            {1.362247, 0, -0.529468, 0, 1.855979, 0, 1.011874, 0, 1},
            {1.318768, 0, -0.500596, 0, 1.747553, 0, 0.936205, 0, 1},
            {1.277224, 0, -0.472318, 0, 1.650914, 0, 0.864115, 0, 1},
            {1.238423, 0, -0.443965, 0, 1.563302, 0, 0.794573, 0, 1},
            {1.203593, 0, -0.417095, 0, 1.484466, 0, 0.730561, 0, 1},
            {1.175799, 0, -0.391155, 0, 1.414344, 0, 0.671763, 0, 1},
            {1.143384, 0, -0.365221, 0, 1.351420, 0, 0.612008, 0, 1},
            {1.114282, 0, -0.340166, 0, 1.294105, 0, 0.556355, 0, 1},
            {1.086062, 0, -0.315273, 0, 1.241617, 0, 0.502284, 0, 1},
            {1.060104, 0, -0.288886, 0, 1.192894, 0, 0.451043, 0, 1},
            {1.035165, 0, -0.262812, 0, 1.146646, 0, 0.401512, 0, 1},
            {1.010927, 0, -0.237303, 0, 1.105342, 0, 0.354568, 0, 1},
            {0.986868, 0, -0.213225, 0, 1.068711, 0, 0.310890, 0, 1},
            {0.963888, 0, -0.189524, 0, 1.033689, 0, 0.269485, 0, 1},
            {0.944575, 0, -0.166984, 0, 1.002348, 0, 0.232086, 0, 1},
            {0.925989, 0, -0.144904, 0, 0.974783, 0, 0.197529, 0, 1},
            {0.909718, 0, -0.123194, 0, 0.950088, 0, 0.165804, 0, 1},
            {0.893602, 0, -0.100585, 0, 0.929001, 0, 0.135989, 0, 1},
            {0.880930, 0, -0.078820, 0, 0.911111, 0, 0.107735, 0, 1},
            {0.872501, 0, -0.058035, 0, 0.895415, 0, 0.079710, 0, 1},
            {0.867507, 0, -0.038358, 0, 0.882132, 0, 0.052461, 0, 1},
            {0.863453, 0, -0.019345, 0, 0.870294, 0, 0.025992, 0, 1},
            {0.859288, 0, 0.000110, 0, 0.859383, 0, -0.000014, 0, 1},
            {499.996735, 0, -1.077731, 0, 1080.664673, 0, 538.861328, 0, 1},
            {499.996735, 0, -1.077731, 0, 1080.664673, 0, 538.861328, 0, 1},
            {496.170593, 0, -1.077731, 0, 1072.279297, 0, 534.739807, 0, 1},
            {220.517517, 0, -1.077709, 0, 476.652893, 0, 237.659348, 0, 1},
            {124.117775, 0, -1.077652, 0, 268.725189, 0, 133.765640, 0, 1},
            {79.410866, 0, -1.077531, 0, 171.527359, 0, 85.583138, 0, 1},
            {55.113548, 0, -1.077307, 0, 119.128113, 0, 59.396004, 0, 1},
            {40.485504, 0, -1.076940, 0, 87.496834, 0, 43.630085, 0, 1},
            {30.995348, 0, -1.076383, 0, 66.968063, 0, 33.401592, 0, 1},
            {24.478037, 0, -1.075572, 0, 52.888393, 0, 26.376728, 0, 1},
            {19.818436, 0, -1.074451, 0, 42.809273, 0, 21.353882, 0, 1},
            {16.369066, 0, -1.072950, 0, 35.347332, 0, 17.635206, 0, 1},
            {13.744530, 0, -1.070992, 0, 29.665915, 0, 14.805332, 0, 1},
            {11.699392, 0, -1.068479, 0, 25.240294, 0, 12.599726, 0, 1},
            {10.076106, 0, -1.065157, 0, 21.721914, 0, 10.848528, 0, 1},
            {8.765397, 0, -1.057776, 0, 18.870815, 0, 9.433759, 0, 1},
            {7.689671, 0, -1.049772, 0, 16.531149, 0, 8.271976, 0, 1},
            {6.797180, 0, -1.042245, 0, 14.589982, 0, 7.307357, 0, 1},
            {6.049593, 0, -1.034233, 0, 12.960362, 0, 6.498483, 0, 1},
            {5.416529, 0, -1.026134, 0, 11.579355, 0, 5.812615, 0, 1},
            {4.876689, 0, -1.013528, 0, 10.392941, 0, 5.226410, 0, 1},
            {4.411905, 0, -1.001664, 0, 9.369521, 0, 4.720509, 0, 1},
            {4.012266, 0, -0.989026, 0, 8.480060, 0, 4.284074, 0, 1},
            {3.662950, 0, -0.972831, 0, 7.699392, 0, 3.900908, 0, 1},
            {3.360163, 0, -0.956997, 0, 7.010824, 0, 3.566742, 0, 1},
            {3.094684, 0, -0.940183, 0, 6.400454, 0, 3.271647, 0, 1},
            {2.865789, 0, -0.920848, 0, 5.853747, 0, 3.014791, 0, 1},
            {2.663946, 0, -0.899793, 0, 5.361293, 0, 2.785320, 0, 1},
            {2.481951, 0, -0.878705, 0, 4.922871, 0, 2.575858, 0, 1},
            {2.327681, 0, -0.856813, 0, 4.523750, 0, 2.394462, 0, 1},
            {2.192445, 0, -0.832278, 0, 4.164162, 0, 2.231818, 0, 1},
            {2.069360, 0, -0.808212, 0, 3.840145, 0, 2.080414, 0, 1},
            {1.964869, 0, -0.784627, 0, 3.548100, 0, 1.946890, 0, 1},
            {1.867790, 0, -0.761011, 0, 3.290413, 0, 1.821110, 0, 1},
            {1.784666, 0, -0.736268, 0, 3.054466, 0, 1.707456, 0, 1},
            {1.705916, 0, -0.712094, 0, 2.846312, 0, 1.598577, 0, 1},
            {1.638266, 0, -0.688936, 0, 2.655171, 0, 1.499242, 0, 1},
            {1.578253, 0, -0.664921, 0, 2.481119, 0, 1.407212, 0, 1},
            {1.518494, 0, -0.637776, 0, 2.316894, 0, 1.313202, 0, 1},
            {1.463787, 0, -0.605856, 0, 2.159441, 0, 1.221768, 0, 1},
            {1.409612, 0, -0.574727, 0, 2.017316, 0, 1.131762, 0, 1},
            {1.362154, 0, -0.544026, 0, 1.890369, 0, 1.046947, 0, 1},
            {1.315537, 0, -0.513893, 0, 1.776250, 0, 0.966523, 0, 1},
            {1.276021, 0, -0.484153, 0, 1.675288, 0, 0.891506, 0, 1},
            {1.236644, 0, -0.454743, 0, 1.585168, 0, 0.819109, 0, 1},
            {1.200984, 0, -0.426294, 0, 1.502623, 0, 0.750754, 0, 1},
            {1.172336, 0, -0.399072, 0, 1.428918, 0, 0.688631, 0, 1},
            {1.142360, 0, -0.372529, 0, 1.362915, 0, 0.628822, 0, 1},
            {1.112101, 0, -0.346395, 0, 1.303952, 0, 0.569939, 0, 1},
            {1.084985, 0, -0.321156, 0, 1.250121, 0, 0.514811, 0, 1},
            {1.059741, 0, -0.295675, 0, 1.200694, 0, 0.463237, 0, 1},
            {1.036129, 0, -0.269211, 0, 1.154357, 0, 0.413015, 0, 1},
            {1.011153, 0, -0.242809, 0, 1.111147, 0, 0.364226, 0, 1},
            {0.985804, 0, -0.217788, 0, 1.072691, 0, 0.318474, 0, 1},
            {0.963591, 0, -0.193127, 0, 1.036701, 0, 0.276046, 0, 1},
            {0.942618, 0, -0.169928, 0, 1.003960, 0, 0.236989, 0, 1},
            {0.923782, 0, -0.147286, 0, 0.975479, 0, 0.201457, 0, 1},
            {0.907602, 0, -0.125247, 0, 0.950244, 0, 0.168914, 0, 1},
            {0.890855, 0, -0.103546, 0, 0.928926, 0, 0.139068, 0, 1},
            {0.878108, 0, -0.081136, 0, 0.910830, 0, 0.110215, 0, 1},
            {0.869703, 0, -0.059410, 0, 0.894226, 0, 0.081583, 0, 1},
            {0.864859, 0, -0.038515, 0, 0.880408, 0, 0.053267, 0, 1},
            {0.861328, 0, -0.019155, 0, 0.868300, 0, 0.026207, 0, 1},
            {0.857123, 0, 0.000198, 0, 0.857174, 0, 0.000008, 0, 1},
            {499.198547, 0, -1.133124, 0, 1142.750610, 0, 565.655518, 0, 1},
            {499.198547, 0, -1.133124, 0, 1142.750610, 0, 565.655518, 0, 1},
            {495.193665, 0, -1.133123, 0, 1133.890625, 0, 561.118347, 0, 1},
            {220.530960, 0, -1.133098, 0, 503.506500, 0, 249.890884, 0, 1},
            {124.351082, 0, -1.133031, 0, 282.611023, 0, 140.903992, 0, 1},
            {79.373192, 0, -1.132888, 0, 181.277954, 0, 89.938644, 0, 1},
            {55.114239, 0, -1.132630, 0, 125.871094, 0, 62.449364, 0, 1},
            {40.487885, 0, -1.132206, 0, 92.458313, 0, 45.875217, 0, 1},
            {30.987593, 0, -1.131555, 0, 70.753319, 0, 35.109222, 0, 1},
            {24.475843, 0, -1.130616, 0, 55.873253, 0, 27.729467, 0, 1},
            {19.812593, 0, -1.129313, 0, 45.222126, 0, 22.444181, 0, 1},
            {16.364174, 0, -1.127567, 0, 37.335171, 0, 18.535343, 0, 1},
            {13.738152, 0, -1.125292, 0, 31.329901, 0, 15.558189, 0, 1},
            {11.692895, 0, -1.122363, 0, 26.650005, 0, 13.238934, 0, 1},
            {10.068810, 0, -1.118341, 0, 22.928526, 0, 11.396638, 0, 1},
            {8.755841, 0, -1.109305, 0, 19.909277, 0, 9.906425, 0, 1},
            {7.678919, 0, -1.101251, 0, 17.434750, 0, 8.683300, 0, 1},
            {6.785978, 0, -1.093312, 0, 15.380631, 0, 7.668364, 0, 1},
            {6.037260, 0, -1.083973, 0, 13.655503, 0, 6.816360, 0, 1},
            {5.403927, 0, -1.074632, 0, 12.193567, 0, 6.094520, 0, 1},
            {4.863304, 0, -1.060226, 0, 10.935308, 0, 5.476997, 0, 1},
            {4.398553, 0, -1.048059, 0, 9.852291, 0, 4.944738, 0, 1},
            {3.998689, 0, -1.033376, 0, 8.908811, 0, 4.485063, 0, 1},
            {3.649364, 0, -1.015714, 0, 8.081111, 0, 4.081708, 0, 1},
            {3.344975, 0, -0.998487, 0, 7.351129, 0, 3.728147, 0, 1},
            {3.083215, 0, -0.979162, 0, 6.700023, 0, 3.421241, 0, 1},
            {2.853763, 0, -0.958452, 0, 6.119757, 0, 3.149657, 0, 1},
            {2.648021, 0, -0.935120, 0, 5.599844, 0, 2.903464, 0, 1},
            {2.472942, 0, -0.912632, 0, 5.128753, 0, 2.689534, 0, 1},
            {2.316902, 0, -0.888726, 0, 4.706252, 0, 2.495873, 0, 1},
            {2.182334, 0, -0.861453, 0, 4.322686, 0, 2.324605, 0, 1},
            {2.059919, 0, -0.835774, 0, 3.978354, 0, 2.164635, 0, 1},
            {1.954855, 0, -0.810190, 0, 3.667906, 0, 2.022531, 0, 1},
            {1.855981, 0, -0.783856, 0, 3.393180, 0, 1.886838, 0, 1},
            {1.771806, 0, -0.757426, 0, 3.144650, 0, 1.766004, 0, 1},
            {1.697741, 0, -0.730885, 0, 2.920450, 0, 1.654005, 0, 1},
            {1.632465, 0, -0.705990, 0, 2.718796, 0, 1.551813, 0, 1},
            {1.571256, 0, -0.680496, 0, 2.537086, 0, 1.452953, 0, 1},
            {1.515108, 0, -0.653885, 0, 2.369325, 0, 1.358737, 0, 1},
            {1.459504, 0, -0.623360, 0, 2.210400, 0, 1.263101, 0, 1},
            {1.405635, 0, -0.590504, 0, 2.062133, 0, 1.168306, 0, 1},
            {1.359547, 0, -0.558369, 0, 1.928148, 0, 1.081079, 0, 1},
            {1.315915, 0, -0.526888, 0, 1.808092, 0, 0.998234, 0, 1},
            {1.272416, 0, -0.495979, 0, 1.702437, 0, 0.916954, 0, 1},
            {1.235574, 0, -0.465317, 0, 1.607036, 0, 0.842566, 0, 1},
            {1.199073, 0, -0.435563, 0, 1.520862, 0, 0.771151, 0, 1},
            {1.166111, 0, -0.406927, 0, 1.443245, 0, 0.704289, 0, 1},
            {1.140453, 0, -0.379219, 0, 1.374699, 0, 0.644617, 0, 1},
            {1.110763, 0, -0.352530, 0, 1.314012, 0, 0.584363, 0, 1},
            {1.083389, 0, -0.326091, 0, 1.257777, 0, 0.527193, 0, 1},
            {1.058973, 0, -0.301090, 0, 1.208417, 0, 0.474518, 0, 1},
            {1.034218, 0, -0.274873, 0, 1.161656, 0, 0.422728, 0, 1},
            {1.010618, 0, -0.248928, 0, 1.117511, 0, 0.373949, 0, 1},
            {0.986232, 0, -0.222285, 0, 1.077184, 0, 0.326582, 0, 1},
            {0.962839, 0, -0.196978, 0, 1.040122, 0, 0.282526, 0, 1},
            {0.941962, 0, -0.173164, 0, 1.006604, 0, 0.242452, 0, 1},
            {0.922943, 0, -0.149257, 0, 0.976292, 0, 0.205411, 0, 1},
            {0.905540, 0, -0.126989, 0, 0.950461, 0, 0.171749, 0, 1},
            {0.888568, 0, -0.105202, 0, 0.928553, 0, 0.141550, 0, 1},
            {0.875908, 0, -0.083692, 0, 0.909612, 0, 0.112693, 0, 1},
            {0.867307, 0, -0.061342, 0, 0.893228, 0, 0.083286, 0, 1},
            {0.862479, 0, -0.039478, 0, 0.878841, 0, 0.054419, 0, 1},
            {0.858952, 0, -0.018690, 0, 0.866345, 0, 0.026407, 0, 1},
            {0.854783, 0, 0.000687, 0, 0.854842, 0, -0.000233, 0, 1},
            {497.740356, 0, -1.191737, 0, 1212.297485, 0, 593.176758, 0, 1},
            {497.740356, 0, -1.191737, 0, 1212.297485, 0, 593.176758, 0, 1},
            {495.967773, 0, -1.191737, 0, 1201.587646, 0, 591.064636, 0, 1},
            {220.402115, 0, -1.191710, 0, 533.582153, 0, 262.667023, 0, 1},
            {124.037041, 0, -1.191629, 0, 300.258667, 0, 147.819244, 0, 1},
            {79.367973, 0, -1.191465, 0, 192.087326, 0, 94.584778, 0, 1},
            {55.114235, 0, -1.191163, 0, 133.370956, 0, 65.679634, 0, 1},
            {40.482887, 0, -1.190670, 0, 97.960243, 0, 48.241943, 0, 1},
            {30.985254, 0, -1.189914, 0, 74.966965, 0, 36.922112, 0, 1},
            {24.470310, 0, -1.188821, 0, 59.198898, 0, 29.156729, 0, 1},
            {19.810440, 0, -1.187304, 0, 47.906578, 0, 23.602030, 0, 1},
            {16.358372, 0, -1.185274, 0, 39.545647, 0, 19.486433, 0, 1},
            {13.731361, 0, -1.182628, 0, 33.179028, 0, 16.353985, 0, 1},
            {11.685279, 0, -1.179202, 0, 28.214518, 0, 13.913551, 0, 1},
            {10.060629, 0, -1.174106, 0, 24.266153, 0, 11.974962, 0, 1},
            {8.745026, 0, -1.163552, 0, 21.059242, 0, 10.404303, 0, 1},
            {7.666819, 0, -1.154777, 0, 18.433811, 0, 9.116149, 0, 1},
            {6.772953, 0, -1.146793, 0, 16.256334, 0, 8.047375, 0, 1},
            {6.023073, 0, -1.136482, 0, 14.424652, 0, 7.149531, 0, 1},
            {5.389208, 0, -1.124666, 0, 12.869657, 0, 6.389346, 0, 1},
            {4.847566, 0, -1.109110, 0, 11.532449, 0, 5.738188, 0, 1},
            {4.384129, 0, -1.095927, 0, 10.382030, 0, 5.179485, 0, 1},
            {3.981435, 0, -1.079033, 0, 9.378829, 0, 4.692119, 0, 1},
            {3.632331, 0, -1.059646, 0, 8.499527, 0, 4.267574, 0, 1},
            {3.330570, 0, -1.040766, 0, 7.720337, 0, 3.898030, 0, 1},
            {3.072052, 0, -1.020092, 0, 7.025834, 0, 3.578377, 0, 1},
            {2.836320, 0, -0.996664, 0, 6.410950, 0, 3.284364, 0, 1},
            {2.636429, 0, -0.970977, 0, 5.852798, 0, 3.031443, 0, 1},
            {2.461024, 0, -0.946995, 0, 5.351264, 0, 2.804762, 0, 1},
            {2.309566, 0, -0.920260, 0, 4.895450, 0, 2.605106, 0, 1},
            {2.171193, 0, -0.891770, 0, 4.492403, 0, 2.419443, 0, 1},
            {2.046365, 0, -0.862975, 0, 4.126715, 0, 2.247149, 0, 1},
            {1.940203, 0, -0.835377, 0, 3.796427, 0, 2.095363, 0, 1},
            {1.847487, 0, -0.807038, 0, 3.501757, 0, 1.957793, 0, 1},
            {1.764791, 0, -0.777984, 0, 3.236122, 0, 1.830755, 0, 1},
            {1.689787, 0, -0.749577, 0, 2.998445, 0, 1.711617, 0, 1},
            {1.623467, 0, -0.722160, 0, 2.787138, 0, 1.601701, 0, 1},
            {1.564476, 0, -0.695601, 0, 2.593500, 0, 1.499691, 0, 1},
            {1.508963, 0, -0.667965, 0, 2.419844, 0, 1.400717, 0, 1},
            {1.456745, 0, -0.639187, 0, 2.260225, 0, 1.304981, 0, 1},
            {1.404346, 0, -0.606291, 0, 2.107956, 0, 1.207875, 0, 1},
            {1.354443, 0, -0.572479, 0, 1.967472, 0, 1.113634, 0, 1},
            {1.312539, 0, -0.539868, 0, 1.840691, 0, 1.028078, 0, 1},
            {1.271663, 0, -0.507526, 0, 1.728781, 0, 0.944375, 0, 1},
            {1.231956, 0, -0.475865, 0, 1.629488, 0, 0.865228, 0, 1},
            {1.197937, 0, -0.444798, 0, 1.540237, 0, 0.791888, 0, 1},
            {1.163655, 0, -0.415022, 0, 1.458943, 0, 0.721975, 0, 1},
            {1.135947, 0, -0.385953, 0, 1.388032, 0, 0.658261, 0, 1},
            {1.108306, 0, -0.358322, 0, 1.324020, 0, 0.597250, 0, 1},
            {1.080856, 0, -0.331377, 0, 1.266384, 0, 0.538634, 0, 1},
            {1.055387, 0, -0.304981, 0, 1.213831, 0, 0.483240, 0, 1},
            {1.031967, 0, -0.279702, 0, 1.168211, 0, 0.432009, 0, 1},
            {1.011454, 0, -0.253981, 0, 1.123698, 0, 0.383715, 0, 1},
            {0.986373, 0, -0.227557, 0, 1.082180, 0, 0.335005, 0, 1},
            {0.962047, 0, -0.201322, 0, 1.044015, 0, 0.289192, 0, 1},
            {0.941474, 0, -0.175898, 0, 1.008716, 0, 0.247600, 0, 1},
            {0.920469, 0, -0.152058, 0, 0.977028, 0, 0.209385, 0, 1},
            {0.903940, 0, -0.128562, 0, 0.950335, 0, 0.174772, 0, 1},
            {0.886939, 0, -0.106209, 0, 0.927499, 0, 0.143497, 0, 1},
            {0.873628, 0, -0.084672, 0, 0.908543, 0, 0.114456, 0, 1},
            {0.864831, 0, -0.063288, 0, 0.891755, 0, 0.085164, 0, 1},
            {0.859767, 0, -0.041204, 0, 0.877256, 0, 0.055889, 0, 1},
            {0.856654, 0, -0.019310, 0, 0.864405, 0, 0.026910, 0, 1},
            {0.852336, 0, 0.001322, 0, 0.852461, 0, -0.000438, 0, 1},
            {499.753876, 0, -1.253942, 0, 1287.089722, 0, 626.664734, 0, 1},
            {499.753876, 0, -1.253942, 0, 1287.089722, 0, 626.664734, 0, 1},
            {496.028778, 0, -1.253944, 0, 1277.157959, 0, 621.993774, 0, 1},
            {220.533188, 0, -1.253909, 0, 567.170044, 0, 276.540680, 0, 1},
            {123.984047, 0, -1.253817, 0, 319.092773, 0, 155.469025, 0, 1},
            {79.369270, 0, -1.253624, 0, 204.112549, 0, 99.522591, 0, 1},
            {55.111843, 0, -1.253274, 0, 141.740967, 0, 69.104866, 0, 1},
            {40.476086, 0, -1.252697, 0, 104.107445, 0, 50.751129, 0, 1},
            {30.984922, 0, -1.251819, 0, 79.662781, 0, 38.848240, 0, 1},
            {24.465958, 0, -1.250546, 0, 62.903252, 0, 30.672558, 0, 1},
            {19.804312, 0, -1.248780, 0, 50.899647, 0, 24.825474, 0, 1},
            {16.352213, 0, -1.246419, 0, 42.008663, 0, 20.494875, 0, 1},
            {13.723763, 0, -1.243331, 0, 35.237221, 0, 17.196903, 0, 1},
            {11.676961, 0, -1.239298, 0, 29.958258, 0, 14.627940, 0, 1},
            {10.049492, 0, -1.232132, 0, 25.752495, 0, 12.584373, 0, 1},
            {8.731993, 0, -1.221280, 0, 22.339643, 0, 10.929126, 0, 1},
            {7.652759, 0, -1.211831, 0, 19.544865, 0, 9.572192, 0, 1},
            {6.758174, 0, -1.202806, 0, 17.227139, 0, 8.446236, 0, 1},
            {6.007354, 0, -1.191387, 0, 15.277209, 0, 7.500062, 0, 1},
            {5.372413, 0, -1.176719, 0, 13.616632, 0, 6.698209, 0, 1},
            {4.830769, 0, -1.161033, 0, 12.195012, 0, 6.012751, 0, 1},
            {4.365128, 0, -1.145102, 0, 10.967047, 0, 5.421536, 0, 1},
            {3.964192, 0, -1.126775, 0, 9.896423, 0, 4.910280, 0, 1},
            {3.614795, 0, -1.105273, 0, 8.956612, 0, 4.462464, 0, 1},
            {3.316762, 0, -1.083889, 0, 8.121175, 0, 4.077182, 0, 1},
            {3.049908, 0, -1.061586, 0, 7.388329, 0, 3.730012, 0, 1},
            {2.822119, 0, -1.035518, 0, 6.724327, 0, 3.429412, 0, 1},
            {2.622464, 0, -1.008090, 0, 6.127764, 0, 3.161820, 0, 1},
            {2.451163, 0, -0.981888, 0, 5.589432, 0, 2.927490, 0, 1},
            {2.296729, 0, -0.952336, 0, 5.104727, 0, 2.712390, 0, 1},
            {2.155762, 0, -0.921598, 0, 4.675928, 0, 2.512262, 0, 1},
            {2.036743, 0, -0.890929, 0, 4.283887, 0, 2.336522, 0, 1},
            {1.932510, 0, -0.860475, 0, 3.929064, 0, 2.177492, 0, 1},
            {1.839267, 0, -0.829707, 0, 3.613852, 0, 2.030046, 0, 1},
            {1.757306, 0, -0.799019, 0, 3.332942, 0, 1.896472, 0, 1},
            {1.682471, 0, -0.767880, 0, 3.080793, 0, 1.769688, 0, 1},
            {1.616012, 0, -0.738321, 0, 2.854067, 0, 1.652668, 0, 1},
            {1.556975, 0, -0.710194, 0, 2.652766, 0, 1.545087, 0, 1},
            {1.502156, 0, -0.680905, 0, 2.469531, 0, 1.441944, 0, 1},
            {1.451757, 0, -0.652191, 0, 2.305683, 0, 1.343244, 0, 1},
            {1.403035, 0, -0.621362, 0, 2.153359, 0, 1.247102, 0, 1},
            {1.353299, 0, -0.586336, 0, 2.007066, 0, 1.148998, 0, 1},
            {1.307415, 0, -0.552367, 0, 1.875375, 0, 1.055520, 0, 1},
            {1.268839, 0, -0.519201, 0, 1.757577, 0, 0.971338, 0, 1},
            {1.231022, 0, -0.485960, 0, 1.652990, 0, 0.889203, 0, 1},
            {1.195541, 0, -0.454077, 0, 1.560240, 0, 0.812061, 0, 1},
            {1.161529, 0, -0.422868, 0, 1.476693, 0, 0.739344, 0, 1},
            {1.129743, 0, -0.392830, 0, 1.401400, 0, 0.670055, 0, 1},
            {1.105266, 0, -0.363897, 0, 1.334618, 0, 0.608914, 0, 1},
            {1.077838, 0, -0.336141, 0, 1.274864, 0, 0.548889, 0, 1},
            {1.052315, 0, -0.309317, 0, 1.220056, 0, 0.492636, 0, 1},
            {1.029826, 0, -0.282778, 0, 1.171442, 0, 0.440025, 0, 1},
            {1.009347, 0, -0.257536, 0, 1.128472, 0, 0.391160, 0, 1},
            {0.986019, 0, -0.232366, 0, 1.087234, 0, 0.342713, 0, 1},
            {0.963012, 0, -0.205715, 0, 1.047779, 0, 0.296459, 0, 1},
            {0.940682, 0, -0.179674, 0, 1.011584, 0, 0.253051, 0, 1},
            {0.919427, 0, -0.154758, 0, 0.978625, 0, 0.213263, 0, 1},
            {0.902586, 0, -0.130710, 0, 0.950182, 0, 0.177850, 0, 1},
            {0.885406, 0, -0.107393, 0, 0.926769, 0, 0.145696, 0, 1},
            {0.871587, 0, -0.085046, 0, 0.907180, 0, 0.115747, 0, 1},
            {0.862558, 0, -0.063744, 0, 0.890073, 0, 0.086239, 0, 1},
            {0.857297, 0, -0.042531, 0, 0.875385, 0, 0.057043, 0, 1},
            {0.854008, 0, -0.020869, 0, 0.862320, 0, 0.028007, 0, 1},
            {0.849945, 0, 0.000879, 0, 0.850067, 0, -0.000316, 0, 1},
            {498.764313, 0, -1.320163, 0, 1373.378540, 0, 658.451599, 0, 1},
            {498.764313, 0, -1.320163, 0, 1373.378540, 0, 658.451599, 0, 1},
            {496.446625, 0, -1.320164, 0, 1360.179932, 0, 655.392273, 0, 1},
            {220.485596, 0, -1.320125, 0, 604.791382, 0, 291.081512, 0, 1},
            {124.026947, 0, -1.320016, 0, 340.108673, 0, 163.735397, 0, 1},
            {79.428589, 0, -1.319792, 0, 217.682114, 0, 104.858566, 0, 1},
            {55.094601, 0, -1.319384, 0, 151.154099, 0, 72.731087, 0, 1},
            {40.476280, 0, -1.318711, 0, 110.993645, 0, 53.431137, 0, 1},
            {30.973503, 0, -1.317686, 0, 84.935791, 0, 40.884266, 0, 1},
            {24.461092, 0, -1.316200, 0, 67.053787, 0, 32.285267, 0, 1},
            {19.798025, 0, -1.314142, 0, 54.248508, 0, 26.127316, 0, 1},
            {16.344543, 0, -1.311384, 0, 44.766365, 0, 21.565979, 0, 1},
            {13.715401, 0, -1.307778, 0, 37.540558, 0, 18.092642, 0, 1},
            {11.667095, 0, -1.302977, 0, 31.907068, 0, 15.385793, 0, 1},
            {10.036300, 0, -1.292651, 0, 27.406919, 0, 13.229581, 0, 1},
            {8.717825, 0, -1.282903, 0, 23.768972, 0, 11.485295, 0, 1},
            {7.636909, 0, -1.272602, 0, 20.785141, 0, 10.054101, 0, 1},
            {6.741018, 0, -1.261386, 0, 18.307858, 0, 8.866672, 0, 1},
            {5.989860, 0, -1.248665, 0, 16.223476, 0, 7.869553, 0, 1},
            {5.353560, 0, -1.232226, 0, 14.447929, 0, 7.023051, 0, 1},
            {4.812235, 0, -1.215270, 0, 12.926739, 0, 6.301147, 0, 1},
            {4.345270, 0, -1.196644, 0, 11.613120, 0, 5.676373, 0, 1},
            {3.943053, 0, -1.176316, 0, 10.467074, 0, 5.135668, 0, 1},
            {3.597323, 0, -1.152379, 0, 9.457210, 0, 4.668163, 0, 1},
            {3.298333, 0, -1.129210, 0, 8.564156, 0, 4.260488, 0, 1},
            {3.033204, 0, -1.104019, 0, 7.774998, 0, 3.895550, 0, 1},
            {2.804857, 0, -1.074878, 0, 7.064775, 0, 3.577148, 0, 1},
            {2.610853, 0, -1.045896, 0, 6.421424, 0, 3.301699, 0, 1},
            {2.430077, 0, -1.016253, 0, 5.852787, 0, 3.041409, 0, 1},
            {2.278789, 0, -0.985085, 0, 5.334065, 0, 2.816983, 0, 1},
            {2.145781, 0, -0.951537, 0, 4.865364, 0, 2.614515, 0, 1},
            {2.028583, 0, -0.918188, 0, 4.447055, 0, 2.430435, 0, 1},
            {1.920310, 0, -0.885812, 0, 4.072713, 0, 2.256396, 0, 1},
            {1.827242, 0, -0.852252, 0, 3.734781, 0, 2.100304, 0, 1},
            {1.741410, 0, -0.819354, 0, 3.436574, 0, 1.953809, 0, 1},
            {1.667199, 0, -0.785912, 0, 3.169833, 0, 1.820603, 0, 1},
            {1.600661, 0, -0.754258, 0, 2.929060, 0, 1.697106, 0, 1},
            {1.541972, 0, -0.723590, 0, 2.714557, 0, 1.582406, 0, 1},
            {1.490970, 0, -0.693555, 0, 2.522617, 0, 1.478268, 0, 1},
            {1.442741, 0, -0.663230, 0, 2.348330, 0, 1.377193, 0, 1},
            {1.398380, 0, -0.632923, 0, 2.193665, 0, 1.281289, 0, 1},
            {1.352417, 0, -0.600306, 0, 2.049114, 0, 1.184361, 0, 1},
            {1.306098, 0, -0.564746, 0, 1.911273, 0, 1.086684, 0, 1},
            {1.263667, 0, -0.530384, 0, 1.787241, 0, 0.995224, 0, 1},
            {1.227507, 0, -0.496238, 0, 1.677880, 0, 0.911170, 0, 1},
            {1.192177, 0, -0.463117, 0, 1.580272, 0, 0.831094, 0, 1},
            {1.159786, 0, -0.430992, 0, 1.493237, 0, 0.756722, 0, 1},
            {1.127615, 0, -0.399809, 0, 1.415863, 0, 0.685682, 0, 1},
            {1.101597, 0, -0.369629, 0, 1.345474, 0, 0.620668, 0, 1},
            {1.074312, 0, -0.340787, 0, 1.283440, 0, 0.558964, 0, 1},
            {1.048375, 0, -0.313370, 0, 1.227282, 0, 0.500063, 0, 1},
            {1.025321, 0, -0.286188, 0, 1.176411, 0, 0.446249, 0, 1},
            {1.004459, 0, -0.259980, 0, 1.131536, 0, 0.396020, 0, 1},
            {0.984215, 0, -0.235098, 0, 1.090374, 0, 0.348723, 0, 1},
            {0.962293, 0, -0.209660, 0, 1.050996, 0, 0.302458, 0, 1},
            {0.939934, 0, -0.183963, 0, 1.014945, 0, 0.258686, 0, 1},
            {0.919490, 0, -0.157603, 0, 0.980187, 0, 0.217735, 0, 1},
            {0.900178, 0, -0.133030, 0, 0.950534, 0, 0.181288, 0, 1},
            {0.884062, 0, -0.109124, 0, 0.926558, 0, 0.147997, 0, 1},
            {0.869425, 0, -0.085933, 0, 0.905910, 0, 0.117436, 0, 1},
            {0.860200, 0, -0.063534, 0, 0.888262, 0, 0.087208, 0, 1},
            {0.854847, 0, -0.042793, 0, 0.873182, 0, 0.057860, 0, 1},
            {0.851453, 0, -0.021623, 0, 0.859881, 0, 0.028712, 0, 1},
            {0.847523, 0, -0.000142, 0, 0.847737, 0, 0.000144, 0, 1},
            {499.946350, 0, -1.390894, 0, 1467.598511, 0, 695.371582, 0, 1},
            {499.946350, 0, -1.390894, 0, 1467.598511, 0, 695.371582, 0, 1},
            {496.076233, 0, -1.390894, 0, 1456.169800, 0, 689.988953, 0, 1},
            {220.496719, 0, -1.390848, 0, 647.093567, 0, 306.691040, 0, 1},
            {124.013779, 0, -1.390722, 0, 363.965607, 0, 172.489548, 0, 1},
            {79.373199, 0, -1.390458, 0, 233.001343, 0, 110.400490, 0, 1},
            {55.108978, 0, -1.389980, 0, 161.729828, 0, 76.647385, 0, 1},
            {40.467999, 0, -1.389193, 0, 118.741165, 0, 56.281498, 0, 1},
            {30.975763, 0, -1.387995, 0, 90.852692, 0, 43.077286, 0, 1},
            {24.455482, 0, -1.386258, 0, 71.715958, 0, 34.006439, 0, 1},
            {19.791021, 0, -1.383852, 0, 58.016361, 0, 27.516304, 0, 1},
            {16.335751, 0, -1.380629, 0, 47.863483, 0, 22.707855, 0, 1},
            {13.705017, 0, -1.376399, 0, 40.126877, 0, 19.045937, 0, 1},
            {11.653750, 0, -1.370543, 0, 34.092148, 0, 16.189638, 0, 1},
            {10.021158, 0, -1.358667, 0, 29.265823, 0, 13.915085, 0, 1},
            {8.701030, 0, -1.347819, 0, 25.367838, 0, 12.074658, 0, 1},
            {7.619580, 0, -1.336861, 0, 22.171335, 0, 10.565630, 0, 1},
            {6.722030, 0, -1.323397, 0, 19.511784, 0, 9.311698, 0, 1},
            {5.969267, 0, -1.308124, 0, 17.274567, 0, 8.258295, 0, 1},
            {5.332428, 0, -1.289965, 0, 15.369953, 0, 7.365280, 0, 1},
            {4.788707, 0, -1.271456, 0, 13.738621, 0, 6.600627, 0, 1},
            {4.322216, 0, -1.250397, 0, 12.327078, 0, 5.942193, 0, 1},
            {3.921430, 0, -1.227581, 0, 11.096258, 0, 5.373594, 0, 1},
            {3.576837, 0, -1.200790, 0, 10.007510, 0, 4.881275, 0, 1},
            {3.273181, 0, -1.175546, 0, 9.053289, 0, 4.444415, 0, 1},
            {3.013334, 0, -1.147349, 0, 8.200176, 0, 4.065929, 0, 1},
            {2.791491, 0, -1.115724, 0, 7.428865, 0, 3.737948, 0, 1},
            {2.587043, 0, -1.084444, 0, 6.751217, 0, 3.432292, 0, 1},
            {2.416821, 0, -1.051544, 0, 6.129459, 0, 3.169965, 0, 1},
            {2.267782, 0, -1.017314, 0, 5.569518, 0, 2.934841, 0, 1},
            {2.134773, 0, -0.982051, 0, 5.070411, 0, 2.719155, 0, 1},
            {2.011730, 0, -0.946156, 0, 4.625893, 0, 2.516692, 0, 1},
            {1.907606, 0, -0.910265, 0, 4.223953, 0, 2.336645, 0, 1},
            {1.814633, 0, -0.874876, 0, 3.862807, 0, 2.170789, 0, 1},
            {1.726175, 0, -0.839464, 0, 3.546830, 0, 2.011889, 0, 1},
            {1.651998, 0, -0.803765, 0, 3.261043, 0, 1.871454, 0, 1},
            {1.586171, 0, -0.769456, 0, 3.007546, 0, 1.741142, 0, 1},
            {1.531422, 0, -0.736866, 0, 2.776947, 0, 1.624824, 0, 1},
            {1.478677, 0, -0.704933, 0, 2.576596, 0, 1.512335, 0, 1},
            {1.430226, 0, -0.673526, 0, 2.394740, 0, 1.406849, 0, 1},
            {1.386441, 0, -0.642238, 0, 2.231730, 0, 1.306790, 0, 1},
            {1.347700, 0, -0.610335, 0, 2.083120, 0, 1.213711, 0, 1},
            {1.304647, 0, -0.576954, 0, 1.947658, 0, 1.117770, 0, 1},
            {1.262713, 0, -0.541312, 0, 1.817316, 0, 1.022935, 0, 1},
            {1.226210, 0, -0.506275, 0, 1.703293, 0, 0.935409, 0, 1},
            {1.190476, 0, -0.472115, 0, 1.601141, 0, 0.851909, 0, 1},
            {1.157802, 0, -0.438939, 0, 1.510821, 0, 0.774189, 0, 1},
            {1.126094, 0, -0.406711, 0, 1.429830, 0, 0.700163, 0, 1},
            {1.099165, 0, -0.375645, 0, 1.357510, 0, 0.633428, 0, 1},
            {1.072272, 0, -0.345376, 0, 1.292333, 0, 0.568595, 0, 1},
            {1.045140, 0, -0.317129, 0, 1.234337, 0, 0.508251, 0, 1},
            {1.022077, 0, -0.289678, 0, 1.182703, 0, 0.453208, 0, 1},
            {0.999451, 0, -0.262616, 0, 1.134882, 0, 0.400832, 0, 1},
            {0.978826, 0, -0.236418, 0, 1.092171, 0, 0.351856, 0, 1},
            {0.956364, 0, -0.212182, 0, 1.052354, 0, 0.305863, 0, 1},
            {0.936124, 0, -0.186767, 0, 1.015153, 0, 0.261983, 0, 1},
            {0.915224, 0, -0.161611, 0, 0.981272, 0, 0.221219, 0, 1},
            {0.896723, 0, -0.135741, 0, 0.951082, 0, 0.183870, 0, 1},
            {0.880615, 0, -0.110802, 0, 0.925929, 0, 0.150061, 0, 1},
            {0.866110, 0, -0.087549, 0, 0.904866, 0, 0.119470, 0, 1},
            {0.856847, 0, -0.064229, 0, 0.886618, 0, 0.088534, 0, 1},
            {0.851917, 0, -0.041981, 0, 0.871051, 0, 0.058068, 0, 1},
            {0.848660, 0, -0.021244, 0, 0.857396, 0, 0.028805, 0, 1},
            {0.844679, 0, -0.000023, 0, 0.844858, 0, 0.000067, 0, 1},
            {498.779419, 0, -1.466705, 0, 1575.844360, 0, 731.558167, 0, 1},
            {498.779419, 0, -1.466705, 0, 1575.844360, 0, 731.558167, 0, 1},
            {495.686005, 0, -1.466705, 0, 1563.839966, 0, 727.024902, 0, 1},
            {220.507874, 0, -1.466650, 0, 694.803223, 0, 323.422455, 0, 1},
            {123.952385, 0, -1.466503, 0, 390.826355, 0, 181.792984, 0, 1},
            {79.377266, 0, -1.466195, 0, 249.967194, 0, 116.420586, 0, 1},
            {55.099525, 0, -1.465636, 0, 173.619049, 0, 80.810890, 0, 1},
            {40.470554, 0, -1.464715, 0, 127.491707, 0, 59.352566, 0, 1},
            {30.965216, 0, -1.463306, 0, 97.532944, 0, 45.409164, 0, 1},
            {24.454735, 0, -1.461271, 0, 76.994362, 0, 35.857788, 0, 1},
            {19.782701, 0, -1.458454, 0, 62.267132, 0, 29.002623, 0, 1},
            {16.324949, 0, -1.454673, 0, 51.357708, 0, 23.928177, 0, 1},
            {13.692519, 0, -1.449687, 0, 43.045250, 0, 20.063829, 0, 1},
            {11.640100, 0, -1.442068, 0, 36.549221, 0, 17.049719, 0, 1},
            {10.004292, 0, -1.428058, 0, 31.351686, 0, 14.646075, 0, 1},
            {8.681810, 0, -1.416120, 0, 27.161263, 0, 12.701498, 0, 1},
            {7.598638, 0, -1.404866, 0, 23.729090, 0, 11.107257, 0, 1},
            {6.699979, 0, -1.389501, 0, 20.864613, 0, 9.782582, 0, 1},
            {5.945863, 0, -1.371374, 0, 18.451183, 0, 8.669281, 0, 1},
            {5.308502, 0, -1.351385, 0, 16.401524, 0, 7.725982, 0, 1},
            {4.763751, 0, -1.329682, 0, 14.640650, 0, 6.917427, 0, 1},
            {4.298007, 0, -1.307001, 0, 13.120390, 0, 6.223120, 0, 1},
            {3.899934, 0, -1.280435, 0, 11.787424, 0, 5.626344, 0, 1},
            {3.549153, 0, -1.251572, 0, 10.620056, 0, 5.097425, 0, 1},
            {3.253283, 0, -1.223200, 0, 9.583576, 0, 4.646020, 0, 1},
            {2.996228, 0, -1.191155, 0, 8.656814, 0, 4.249408, 0, 1},
            {2.765244, 0, -1.158044, 0, 7.837562, 0, 3.888601, 0, 1},
            {2.571919, 0, -1.122705, 0, 7.094434, 0, 3.579864, 0, 1},
            {2.403607, 0, -1.087049, 0, 6.424055, 0, 3.304322, 0, 1},
            {2.252028, 0, -1.049959, 0, 5.824631, 0, 3.050817, 0, 1},
            {2.116779, 0, -1.011578, 0, 5.289791, 0, 2.819011, 0, 1},
            {1.993860, 0, -0.973772, 0, 4.816268, 0, 2.603753, 0, 1},
            {1.890524, 0, -0.934433, 0, 4.387243, 0, 2.412890, 0, 1},
            {1.798378, 0, -0.897044, 0, 4.001345, 0, 2.238384, 0, 1},
            {1.715745, 0, -0.858754, 0, 3.656700, 0, 2.076623, 0, 1},
            {1.642515, 0, -0.821173, 0, 3.353235, 0, 1.928177, 0, 1},
            {1.575996, 0, -0.784906, 0, 3.086783, 0, 1.790380, 0, 1},
            {1.517029, 0, -0.749382, 0, 2.844139, 0, 1.662103, 0, 1},
            {1.463617, 0, -0.715590, 0, 2.629526, 0, 1.543108, 0, 1},
            {1.419676, 0, -0.682990, 0, 2.440467, 0, 1.436785, 0, 1},
            {1.375393, 0, -0.650474, 0, 2.270741, 0, 1.332324, 0, 1},
            {1.335512, 0, -0.618036, 0, 2.118298, 0, 1.234705, 0, 1},
            {1.299672, 0, -0.585888, 0, 1.978625, 0, 1.143387, 0, 1},
            {1.260211, 0, -0.552059, 0, 1.850432, 0, 1.048487, 0, 1},
            {1.220603, 0, -0.516035, 0, 1.730217, 0, 0.955238, 0, 1},
            {1.187332, 0, -0.481062, 0, 1.622624, 0, 0.870517, 0, 1},
            {1.154017, 0, -0.446628, 0, 1.528417, 0, 0.790108, 0, 1},
            {1.123595, 0, -0.413848, 0, 1.444416, 0, 0.715249, 0, 1},
            {1.093868, 0, -0.381648, 0, 1.369804, 0, 0.643891, 0, 1},
            {1.069937, 0, -0.350455, 0, 1.302023, 0, 0.579375, 0, 1},
            {1.042615, 0, -0.321163, 0, 1.241905, 0, 0.517313, 0, 1},
            {1.020031, 0, -0.292592, 0, 1.187551, 0, 0.460405, 0, 1},
            {0.996479, 0, -0.265382, 0, 1.139110, 0, 0.406380, 0, 1},
            {0.975165, 0, -0.238717, 0, 1.094910, 0, 0.356264, 0, 1},
            {0.953236, 0, -0.212812, 0, 1.053961, 0, 0.308913, 0, 1},
            {0.931561, 0, -0.188332, 0, 1.015921, 0, 0.264932, 0, 1},
            {0.911343, 0, -0.163891, 0, 0.980784, 0, 0.223958, 0, 1},
            {0.893546, 0, -0.139290, 0, 0.950847, 0, 0.186838, 0, 1},
            {0.876796, 0, -0.113372, 0, 0.924905, 0, 0.152215, 0, 1},
            {0.862211, 0, -0.089137, 0, 0.903229, 0, 0.120962, 0, 1},
            {0.853316, 0, -0.065492, 0, 0.884618, 0, 0.089734, 0, 1},
            {0.848789, 0, -0.042287, 0, 0.868789, 0, 0.058723, 0, 1},
            {0.845668, 0, -0.020147, 0, 0.854603, 0, 0.028542, 0, 1},
            {0.841710, 0, 0.000684, 0, 0.841725, 0, -0.000226, 0, 1},
            {500.563446, 0, -1.548274, 0, 1697.137573, 0, 775.003479, 0, 1},
            {500.563446, 0, -1.548274, 0, 1697.137573, 0, 775.003479, 0, 1},
            {495.507477, 0, -1.548273, 0, 1685.115112, 0, 767.177795, 0, 1},
            {220.529938, 0, -1.548211, 0, 749.035522, 0, 341.439911, 0, 1},
            {124.007294, 0, -1.548038, 0, 421.342133, 0, 191.996704, 0, 1},
            {79.365158, 0, -1.547674, 0, 269.654449, 0, 122.875969, 0, 1},
            {55.104710, 0, -1.547015, 0, 187.125687, 0, 85.312332, 0, 1},
            {40.460781, 0, -1.545932, 0, 137.423080, 0, 62.637676, 0, 1},
            {30.959267, 0, -1.544278, 0, 105.125816, 0, 47.924221, 0, 1},
            {24.441511, 0, -1.541885, 0, 82.958992, 0, 37.830250, 0, 1},
            {19.772507, 0, -1.538568, 0, 67.084435, 0, 30.598278, 0, 1},
            {16.314167, 0, -1.534121, 0, 55.317017, 0, 25.240301, 0, 1},
            {13.679079, 0, -1.528198, 0, 46.343460, 0, 21.156521, 0, 1},
            {11.623078, 0, -1.517027, 0, 39.318115, 0, 17.968763, 0, 1},
            {9.984684, 0, -1.503865, 0, 33.717480, 0, 15.426950, 0, 1},
            {8.660229, 0, -1.490569, 0, 29.189663, 0, 13.370610, 0, 1},
            {7.575959, 0, -1.476789, 0, 25.479780, 0, 11.685358, 0, 1},
            {6.674681, 0, -1.458910, 0, 22.382269, 0, 10.282349, 0, 1},
            {5.920040, 0, -1.438482, 0, 19.770836, 0, 9.105390, 0, 1},
            {5.279105, 0, -1.415795, 0, 17.555033, 0, 8.103386, 0, 1},
            {4.735237, 0, -1.391090, 0, 15.648655, 0, 7.250249, 0, 1},
            {4.271001, 0, -1.365578, 0, 14.001099, 0, 6.518698, 0, 1},
            {3.868648, 0, -1.335251, 0, 12.557265, 0, 5.880911, 0, 1},
            {3.525434, 0, -1.303971, 0, 11.290165, 0, 5.332313, 0, 1},
            {3.229289, 0, -1.272056, 0, 10.166988, 0, 4.853722, 0, 1},
            {2.973827, 0, -1.235813, 0, 9.161206, 0, 4.435764, 0, 1},
            {2.746283, 0, -1.200691, 0, 8.273100, 0, 4.057812, 0, 1},
            {2.556337, 0, -1.162222, 0, 7.466950, 0, 3.734700, 0, 1},
            {2.382043, 0, -1.122336, 0, 6.747432, 0, 3.432638, 0, 1},
            {2.226896, 0, -1.082357, 0, 6.107476, 0, 3.158011, 0, 1},
            {2.096946, 0, -1.041597, 0, 5.528396, 0, 2.918667, 0, 1},
            {1.982116, 0, -1.000798, 0, 5.012418, 0, 2.700050, 0, 1},
            {1.879899, 0, -0.959059, 0, 4.550194, 0, 2.499915, 0, 1},
            {1.787986, 0, -0.918254, 0, 4.138990, 0, 2.314356, 0, 1},
            {1.705297, 0, -0.877931, 0, 3.774493, 0, 2.142460, 0, 1},
            {1.631421, 0, -0.838081, 0, 3.449144, 0, 1.983954, 0, 1},
            {1.565757, 0, -0.799313, 0, 3.164006, 0, 1.838494, 0, 1},
            {1.506439, 0, -0.761872, 0, 2.912416, 0, 1.703796, 0, 1},
            {1.452227, 0, -0.725833, 0, 2.686754, 0, 1.577052, 0, 1},
            {1.404321, 0, -0.691368, 0, 2.485752, 0, 1.460704, 0, 1},
            {1.365700, 0, -0.658189, 0, 2.307966, 0, 1.357509, 0, 1},
            {1.324478, 0, -0.624469, 0, 2.148238, 0, 1.254797, 0, 1},
            {1.291061, 0, -0.591961, 0, 2.005686, 0, 1.161994, 0, 1},
            {1.255292, 0, -0.559582, 0, 1.878051, 0, 1.069687, 0, 1},
            {1.219139, 0, -0.525663, 0, 1.758132, 0, 0.978317, 0, 1},
            {1.185876, 0, -0.489692, 0, 1.644717, 0, 0.890671, 0, 1},
            {1.152226, 0, -0.454516, 0, 1.547585, 0, 0.806953, 0, 1},
            {1.122477, 0, -0.420693, 0, 1.458925, 0, 0.729850, 0, 1},
            {1.092114, 0, -0.387833, 0, 1.381962, 0, 0.656223, 0, 1},
            {1.066724, 0, -0.355955, 0, 1.312587, 0, 0.589727, 0, 1},
            {1.040686, 0, -0.325059, 0, 1.249859, 0, 0.526006, 0, 1},
            {1.015343, 0, -0.295967, 0, 1.193424, 0, 0.466438, 0, 1},
            {0.992501, 0, -0.267983, 0, 1.142624, 0, 0.411551, 0, 1},
            {0.973475, 0, -0.240555, 0, 1.097839, 0, 0.361304, 0, 1},
            {0.950296, 0, -0.214383, 0, 1.055521, 0, 0.312720, 0, 1},
            {0.927910, 0, -0.188892, 0, 1.016122, 0, 0.267196, 0, 1},
            {0.908641, 0, -0.164437, 0, 0.980853, 0, 0.226398, 0, 1},
            {0.890903, 0, -0.140640, 0, 0.950224, 0, 0.188913, 0, 1},
            {0.874486, 0, -0.116753, 0, 0.923639, 0, 0.154579, 0, 1},
            {0.859532, 0, -0.091214, 0, 0.901489, 0, 0.122706, 0, 1},
            {0.850227, 0, -0.066830, 0, 0.882625, 0, 0.090953, 0, 1},
            {0.845351, 0, -0.043435, 0, 0.866192, 0, 0.059751, 0, 1},
            {0.842480, 0, -0.020437, 0, 0.851819, 0, 0.028900, 0, 1},
            {0.838473, 0, 0.001596, 0, 0.838548, 0, -0.000636, 0, 1},
            {500.220978, 0, -1.636395, 0, 1838.045654, 0, 818.563416, 0, 1},
            {500.220978, 0, -1.636395, 0, 1838.045654, 0, 818.563416, 0, 1},
            {494.459290, 0, -1.636392, 0, 1827.407349, 0, 809.127563, 0, 1},
            {220.431442, 0, -1.636316, 0, 811.041321, 0, 360.718323, 0, 1},
            {124.029785, 0, -1.636115, 0, 456.058624, 0, 202.961029, 0, 1},
            {79.353287, 0, -1.635684, 0, 291.885101, 0, 129.850006, 0, 1},
            {55.093857, 0, -1.634909, 0, 202.601929, 0, 90.150055, 0, 1},
            {40.459938, 0, -1.633629, 0, 148.759323, 0, 66.200394, 0, 1},
            {30.951864, 0, -1.631676, 0, 113.779617, 0, 50.638546, 0, 1},
            {24.434439, 0, -1.628853, 0, 89.769363, 0, 39.970615, 0, 1},
            {19.761797, 0, -1.624943, 0, 72.577400, 0, 32.320358, 0, 1},
            {16.300028, 0, -1.619683, 0, 59.824959, 0, 26.651455, 0, 1},
            {13.663046, 0, -1.612532, 0, 50.098763, 0, 22.331676, 0, 1},
            {11.601674, 0, -1.598479, 0, 42.469627, 0, 18.953203, 0, 1},
            {9.961296, 0, -1.584765, 0, 36.401024, 0, 16.262905, 0, 1},
            {8.635368, 0, -1.570133, 0, 31.493324, 0, 14.086539, 0, 1},
            {7.548340, 0, -1.552589, 0, 27.456062, 0, 12.300020, 0, 1},
            {6.645660, 0, -1.531794, 0, 24.090181, 0, 10.814085, 0, 1},
            {5.889278, 0, -1.509731, 0, 21.263355, 0, 9.566248, 0, 1},
            {5.248652, 0, -1.483242, 0, 18.846333, 0, 8.506964, 0, 1},
            {4.703550, 0, -1.456504, 0, 16.778336, 0, 7.601736, 0, 1},
            {4.240797, 0, -1.426601, 0, 14.982071, 0, 6.829503, 0, 1},
            {3.838354, 0, -1.392894, 0, 13.413866, 0, 6.153612, 0, 1},
            {3.496695, 0, -1.358097, 0, 12.031889, 0, 5.574701, 0, 1},
            {3.203286, 0, -1.321386, 0, 10.806087, 0, 5.071508, 0, 1},
            {2.943733, 0, -1.282900, 0, 9.718705, 0, 4.620893, 0, 1},
            {2.728793, 0, -1.243091, 0, 8.739369, 0, 4.238695, 0, 1},
            {2.531582, 0, -1.201321, 0, 7.872953, 0, 3.882470, 0, 1},
            {2.357663, 0, -1.158122, 0, 7.100025, 0, 3.561968, 0, 1},
            {2.211334, 0, -1.114579, 0, 6.399665, 0, 3.283040, 0, 1},
            {2.084279, 0, -1.070823, 0, 5.772037, 0, 3.031426, 0, 1},
            {1.970372, 0, -1.026931, 0, 5.214870, 0, 2.800042, 0, 1},
            {1.868144, 0, -0.983288, 0, 4.723322, 0, 2.586294, 0, 1},
            {1.776766, 0, -0.939148, 0, 4.283816, 0, 2.388965, 0, 1},
            {1.695045, 0, -0.895986, 0, 3.892908, 0, 2.208352, 0, 1},
            {1.621699, 0, -0.854226, 0, 3.550321, 0, 2.040828, 0, 1},
            {1.554762, 0, -0.813286, 0, 3.247862, 0, 1.884675, 0, 1},
            {1.495525, 0, -0.773600, 0, 2.980183, 0, 1.743413, 0, 1},
            {1.442190, 0, -0.735267, 0, 2.743122, 0, 1.611380, 0, 1},
            {1.392841, 0, -0.699411, 0, 2.533287, 0, 1.487552, 0, 1},
            {1.350601, 0, -0.664157, 0, 2.345310, 0, 1.376028, 0, 1},
            {1.315291, 0, -0.630413, 0, 2.180694, 0, 1.275931, 0, 1},
            {1.279763, 0, -0.596575, 0, 2.031982, 0, 1.177584, 0, 1},
            {1.247809, 0, -0.564268, 0, 1.899718, 0, 1.085585, 0, 1},
            {1.214143, 0, -0.531699, 0, 1.780414, 0, 0.995573, 0, 1},
            {1.180461, 0, -0.498392, 0, 1.669314, 0, 0.907584, 0, 1},
            {1.151001, 0, -0.462184, 0, 1.566040, 0, 0.824480, 0, 1},
            {1.118292, 0, -0.427696, 0, 1.474647, 0, 0.743411, 0, 1},
            {1.090124, 0, -0.394140, 0, 1.394335, 0, 0.668413, 0, 1},
            {1.065651, 0, -0.361431, 0, 1.321703, 0, 0.600774, 0, 1},
            {1.039177, 0, -0.329697, 0, 1.258581, 0, 0.535377, 0, 1},
            {1.012649, 0, -0.299669, 0, 1.199650, 0, 0.473554, 0, 1},
            {0.990886, 0, -0.270667, 0, 1.147215, 0, 0.417800, 0, 1},
            {0.970691, 0, -0.242635, 0, 1.100400, 0, 0.366189, 0, 1},
            {0.947988, 0, -0.216053, 0, 1.057616, 0, 0.316603, 0, 1},
            {0.926084, 0, -0.189932, 0, 1.017089, 0, 0.270279, 0, 1},
            {0.905794, 0, -0.164557, 0, 0.980429, 0, 0.228410, 0, 1},
            {0.887501, 0, -0.140614, 0, 0.948911, 0, 0.190542, 0, 1},
            {0.872318, 0, -0.117285, 0, 0.921909, 0, 0.156126, 0, 1},
            {0.857240, 0, -0.093339, 0, 0.899640, 0, 0.124241, 0, 1},
            {0.847199, 0, -0.069224, 0, 0.880288, 0, 0.092689, 0, 1},
            {0.841875, 0, -0.044932, 0, 0.863369, 0, 0.060817, 0, 1},
            {0.839018, 0, -0.021404, 0, 0.848751, 0, 0.029542, 0, 1},
            {0.835378, 0, 0.001013, 0, 0.835340, 0, -0.000412, 0, 1},
            {499.822083, 0, -1.732011, 0, 1999.965576, 0, 865.707397, 0, 1},
            {499.822083, 0, -1.732011, 0, 1999.965576, 0, 865.707397, 0, 1},
            {494.718567, 0, -1.732012, 0, 1987.118896, 0, 856.860107, 0, 1},
            {220.339890, 0, -1.731923, 0, 882.750122, 0, 381.634308, 0, 1},
            {123.876175, 0, -1.731682, 0, 496.490784, 0, 214.553635, 0, 1},
            {79.531601, 0, -1.731174, 0, 316.509644, 0, 137.752762, 0, 1},
            {55.086246, 0, -1.730250, 0, 220.322235, 0, 95.403229, 0, 1},
            {40.451122, 0, -1.728735, 0, 161.740768, 0, 70.052254, 0, 1},
            {30.947416, 0, -1.726420, 0, 123.696022, 0, 53.588512, 0, 1},
            {24.419283, 0, -1.723074, 0, 97.583702, 0, 42.277691, 0, 1},
            {19.747540, 0, -1.718435, 0, 78.865501, 0, 34.181908, 0, 1},
            {16.284979, 0, -1.712185, 0, 64.986404, 0, 28.179916, 0, 1},
            {13.643820, 0, -1.703190, 0, 54.390690, 0, 23.599930, 0, 1},
            {11.577027, 0, -1.686008, 0, 46.065083, 0, 20.014091, 0, 1},
            {9.931022, 0, -1.670659, 0, 39.458389, 0, 17.156662, 0, 1},
            {8.607615, 0, -1.655305, 0, 34.111290, 0, 14.856005, 0, 1},
            {7.516711, 0, -1.634473, 0, 29.707855, 0, 12.957469, 0, 1},
            {6.613613, 0, -1.610853, 0, 26.035231, 0, 11.383127, 0, 1},
            {5.855110, 0, -1.585347, 0, 22.945198, 0, 10.057853, 0, 1},
            {5.212951, 0, -1.554470, 0, 20.302366, 0, 8.932099, 0, 1},
            {4.671384, 0, -1.524457, 0, 18.042673, 0, 7.978805, 0, 1},
            {4.203025, 0, -1.489348, 0, 16.079727, 0, 7.150288, 0, 1},
            {3.805731, 0, -1.452825, 0, 14.365060, 0, 6.442015, 0, 1},
            {3.465826, 0, -1.413837, 0, 12.852410, 0, 5.829659, 0, 1},
            {3.169922, 0, -1.371894, 0, 11.512827, 0, 5.290401, 0, 1},
            {2.922021, 0, -1.330249, 0, 10.316552, 0, 4.829650, 0, 1},
            {2.699599, 0, -1.286943, 0, 9.258978, 0, 4.410607, 0, 1},
            {2.504565, 0, -1.240927, 0, 8.313870, 0, 4.034696, 0, 1},
            {2.340009, 0, -1.192939, 0, 7.463354, 0, 3.707998, 0, 1},
            {2.196713, 0, -1.146727, 0, 6.703224, 0, 3.413730, 0, 1},
            {2.065565, 0, -1.099441, 0, 6.033018, 0, 3.139545, 0, 1},
            {1.949049, 0, -1.052915, 0, 5.440057, 0, 2.888410, 0, 1},
            {1.848797, 0, -1.006308, 0, 4.906864, 0, 2.663498, 0, 1},
            {1.758728, 0, -0.959468, 0, 4.438121, 0, 2.457416, 0, 1},
            {1.676180, 0, -0.913670, 0, 4.023922, 0, 2.264095, 0, 1},
            {1.602849, 0, -0.869632, 0, 3.657779, 0, 2.086621, 0, 1},
            {1.537729, 0, -0.826614, 0, 3.335497, 0, 1.924494, 0, 1},
            {1.484162, 0, -0.784605, 0, 3.046730, 0, 1.781336, 0, 1},
            {1.430466, 0, -0.744719, 0, 2.801592, 0, 1.642652, 0, 1},
            {1.382483, 0, -0.706575, 0, 2.578429, 0, 1.514299, 0, 1},
            {1.338408, 0, -0.669998, 0, 2.382433, 0, 1.396605, 0, 1},
            {1.299440, 0, -0.634587, 0, 2.210920, 0, 1.287506, 0, 1},
            {1.266996, 0, -0.600882, 0, 2.057856, 0, 1.190397, 0, 1},
            {1.237216, 0, -0.566931, 0, 1.920190, 0, 1.097397, 0, 1},
            {1.205769, 0, -0.534977, 0, 1.798528, 0, 1.007207, 0, 1},
            {1.175662, 0, -0.502904, 0, 1.687806, 0, 0.921862, 0, 1},
            {1.147457, 0, -0.470049, 0, 1.587060, 0, 0.839772, 0, 1},
            {1.116879, 0, -0.434482, 0, 1.491868, 0, 0.757348, 0, 1},
            {1.088526, 0, -0.400322, 0, 1.408114, 0, 0.681186, 0, 1},
            {1.061203, 0, -0.367178, 0, 1.333113, 0, 0.609758, 0, 1},
            {1.037013, 0, -0.334895, 0, 1.266879, 0, 0.544047, 0, 1},
            {1.011472, 0, -0.303347, 0, 1.207033, 0, 0.481285, 0, 1},
            {0.988643, 0, -0.273864, 0, 1.152427, 0, 0.424263, 0, 1},
            {0.967803, 0, -0.245225, 0, 1.103691, 0, 0.370598, 0, 1},
            {0.945870, 0, -0.217473, 0, 1.059179, 0, 0.320605, 0, 1},
            {0.923801, 0, -0.191009, 0, 1.017882, 0, 0.273655, 0, 1},
            {0.903188, 0, -0.165590, 0, 0.980649, 0, 0.230554, 0, 1},
            {0.885471, 0, -0.140123, 0, 0.947714, 0, 0.191843, 0, 1},
            {0.869008, 0, -0.116362, 0, 0.920480, 0, 0.156877, 0, 1},
            {0.854365, 0, -0.093528, 0, 0.897682, 0, 0.125335, 0, 1},
            {0.844338, 0, -0.070139, 0, 0.877891, 0, 0.093643, 0, 1},
            {0.838651, 0, -0.047558, 0, 0.860803, 0, 0.062392, 0, 1},
            {0.835562, 0, -0.023241, 0, 0.845685, 0, 0.030756, 0, 1},
            {0.831863, 0, 0.000339, 0, 0.831714, 0, -0.000151, 0, 1},
            {511.085144, 0, -1.836263, 0, 2090.899902, 0, 938.498901, 0, 1},
            {511.085144, 0, -1.836263, 0, 2090.899902, 0, 938.498901, 0, 1},
            {505.213501, 0, -1.836264, 0, 2090.900635, 0, 927.717529, 0, 1},
            {220.510849, 0, -1.836157, 0, 964.057007, 0, 404.914307, 0, 1},
            {124.024460, 0, -1.835866, 0, 542.131042, 0, 227.740662, 0, 1},
            {79.303780, 0, -1.835263, 0, 344.256348, 0, 145.624252, 0, 1},
            {55.082211, 0, -1.834161, 0, 240.742813, 0, 101.137978, 0, 1},
            {40.452766, 0, -1.832355, 0, 176.723450, 0, 74.270340, 0, 1},
            {30.935280, 0, -1.829601, 0, 135.147217, 0, 56.789921, 0, 1},
            {24.410963, 0, -1.825615, 0, 106.570564, 0, 44.805172, 0, 1},
            {19.732744, 0, -1.820089, 0, 86.123405, 0, 36.209381, 0, 1},
            {16.265142, 0, -1.812601, 0, 70.936684, 0, 29.836283, 0, 1},
            {13.619320, 0, -1.799675, 0, 59.311081, 0, 24.971399, 0, 1},
            {11.549600, 0, -1.782202, 0, 50.207493, 0, 21.163506, 0, 1},
            {9.904495, 0, -1.764755, 0, 42.965004, 0, 18.134314, 0, 1},
            {8.574452, 0, -1.746466, 0, 37.106419, 0, 15.682496, 0, 1},
            {7.481882, 0, -1.721176, 0, 32.270939, 0, 13.666021, 0, 1},
            {6.576000, 0, -1.694706, 0, 28.244230, 0, 11.990445, 0, 1},
            {5.815666, 0, -1.664285, 0, 24.849703, 0, 10.580462, 0, 1},
            {5.174417, 0, -1.631012, 0, 21.953531, 0, 9.387169, 0, 1},
            {4.628685, 0, -1.595830, 0, 19.470154, 0, 8.367079, 0, 1},
            {4.165895, 0, -1.556186, 0, 17.310062, 0, 7.496466, 0, 1},
            {3.773972, 0, -1.514913, 0, 15.418040, 0, 6.752415, 0, 1},
            {3.428263, 0, -1.469899, 0, 13.758570, 0, 6.090883, 0, 1},
            {3.141413, 0, -1.424751, 0, 12.284732, 0, 5.531658, 0, 1},
            {2.889461, 0, -1.378250, 0, 10.977796, 0, 5.033019, 0, 1},
            {2.668540, 0, -1.329931, 0, 9.820642, 0, 4.588055, 0, 1},
            {2.484793, 0, -1.280416, 0, 8.778234, 0, 4.205466, 0, 1},
            {2.322710, 0, -1.228281, 0, 7.851379, 0, 3.859567, 0, 1},
            {2.172423, 0, -1.178310, 0, 7.039433, 0, 3.533728, 0, 1},
            {2.038147, 0, -1.127417, 0, 6.319024, 0, 3.236640, 0, 1},
            {1.926231, 0, -1.077733, 0, 5.672859, 0, 2.976160, 0, 1},
            {1.825794, 0, -1.028585, 0, 5.107165, 0, 2.737221, 0, 1},
            {1.736350, 0, -0.979110, 0, 4.604621, 0, 2.517713, 0, 1},
            {1.655195, 0, -0.930475, 0, 4.163131, 0, 2.315423, 0, 1},
            {1.583655, 0, -0.883679, 0, 3.769291, 0, 2.130528, 0, 1},
            {1.519473, 0, -0.839042, 0, 3.424717, 0, 1.961308, 0, 1},
            {1.466147, 0, -0.795197, 0, 3.124171, 0, 1.810564, 0, 1},
            {1.418495, 0, -0.753046, 0, 2.856174, 0, 1.672148, 0, 1},
            {1.370672, 0, -0.713403, 0, 2.627248, 0, 1.539354, 0, 1},
            {1.326257, 0, -0.675196, 0, 2.422592, 0, 1.414866, 0, 1},
            {1.287364, 0, -0.638322, 0, 2.241496, 0, 1.301947, 0, 1},
            {1.255925, 0, -0.603308, 0, 2.080925, 0, 1.201617, 0, 1},
            {1.224782, 0, -0.569434, 0, 1.941677, 0, 1.106450, 0, 1},
            {1.196137, 0, -0.536233, 0, 1.814372, 0, 1.015351, 0, 1},
            {1.166428, 0, -0.504487, 0, 1.702504, 0, 0.929057, 0, 1},
            {1.142563, 0, -0.473197, 0, 1.601333, 0, 0.850931, 0, 1},
            {1.115591, 0, -0.441374, 0, 1.508293, 0, 0.772202, 0, 1},
            {1.087450, 0, -0.406578, 0, 1.421924, 0, 0.693273, 0, 1},
            {1.058441, 0, -0.373003, 0, 1.343416, 0, 0.619633, 0, 1},
            {1.036405, 0, -0.339918, 0, 1.274265, 0, 0.553749, 0, 1},
            {1.009811, 0, -0.308106, 0, 1.213769, 0, 0.488978, 0, 1},
            {0.987187, 0, -0.277417, 0, 1.158055, 0, 0.430549, 0, 1},
            {0.966496, 0, -0.247941, 0, 1.107122, 0, 0.376330, 0, 1},
            {0.943611, 0, -0.219767, 0, 1.061514, 0, 0.324694, 0, 1},
            {0.921372, 0, -0.192425, 0, 1.018703, 0, 0.276404, 0, 1},
            {0.901605, 0, -0.166112, 0, 0.980966, 0, 0.233120, 0, 1},
            {0.883031, 0, -0.140630, 0, 0.947478, 0, 0.193672, 0, 1},
            {0.866008, 0, -0.116135, 0, 0.918590, 0, 0.157817, 0, 1},
            {0.851028, 0, -0.092333, 0, 0.894998, 0, 0.125516, 0, 1},
            {0.841057, 0, -0.069434, 0, 0.875056, 0, 0.093820, 0, 1},
            {0.835355, 0, -0.047327, 0, 0.857536, 0, 0.062534, 0, 1},
            {0.832269, 0, -0.024353, 0, 0.842383, 0, 0.031288, 0, 1},
            {0.828228, 0, -0.001268, 0, 0.828206, 0, 0.000576, 0, 1},
            {522.856628, 0, -1.950519, 0, 2191.923096, 0, 1019.856506, 0, 1},
            {522.856628, 0, -1.950519, 0, 2191.923096, 0, 1019.856506, 0, 1},
            {516.628113, 0, -1.950522, 0, 2191.925293, 0, 1007.708191, 0, 1},
            {220.411392, 0, -1.950389, 0, 1059.556763, 0, 429.909698, 0, 1},
            {124.020309, 0, -1.950044, 0, 595.630554, 0, 241.902267, 0, 1},
            {80.171425, 0, -1.949318, 0, 369.970856, 0, 156.368896, 0, 1},
            {55.070259, 0, -1.948004, 0, 264.543182, 0, 107.406013, 0, 1},
            {40.438072, 0, -1.945839, 0, 194.107300, 0, 78.858276, 0, 1},
            {30.926123, 0, -1.942536, 0, 148.464951, 0, 60.303143, 0, 1},
            {24.393267, 0, -1.937764, 0, 117.051712, 0, 47.555790, 0, 1},
            {19.713079, 0, -1.931139, 0, 94.537262, 0, 38.420696, 0, 1},
            {16.244186, 0, -1.922046, 0, 77.826172, 0, 31.647764, 0, 1},
            {13.590987, 0, -1.904654, 0, 65.003174, 0, 26.464888, 0, 1},
            {11.518149, 0, -1.886799, 0, 54.991226, 0, 22.412935, 0, 1},
            {9.869328, 0, -1.867105, 0, 47.021591, 0, 19.187117, 0, 1},
            {8.536189, 0, -1.843594, 0, 40.553040, 0, 16.575714, 0, 1},
            {7.440576, 0, -1.815064, 0, 35.213913, 0, 14.425980, 0, 1},
            {6.533275, 0, -1.785355, 0, 30.780426, 0, 12.641932, 0, 1},
            {5.769576, 0, -1.747463, 0, 27.016623, 0, 11.136325, 0, 1},
            {5.130471, 0, -1.711248, 0, 23.826628, 0, 9.870622, 0, 1},
            {4.584968, 0, -1.669486, 0, 21.077785, 0, 8.785582, 0, 1},
            {4.125204, 0, -1.626074, 0, 18.692146, 0, 7.863742, 0, 1},
            {3.726583, 0, -1.579110, 0, 16.608892, 0, 7.058338, 0, 1},
            {3.394824, 0, -1.528215, 0, 14.758327, 0, 6.377739, 0, 1},
            {3.104619, 0, -1.477659, 0, 13.134014, 0, 5.774045, 0, 1},
            {2.853900, 0, -1.426794, 0, 11.702996, 0, 5.243056, 0, 1},
            {2.645911, 0, -1.373962, 0, 10.414655, 0, 4.789696, 0, 1},
            {2.455043, 0, -1.319252, 0, 9.289620, 0, 4.366351, 0, 1},
            {2.286029, 0, -1.263785, 0, 8.290472, 0, 3.984693, 0, 1},
            {2.144610, 0, -1.208328, 0, 7.395809, 0, 3.651616, 0, 1},
            {2.018924, 0, -1.154220, 0, 6.609995, 0, 3.347934, 0, 1},
            {1.908630, 0, -1.101906, 0, 5.915262, 0, 3.071701, 0, 1},
            {1.810057, 0, -1.049653, 0, 5.302467, 0, 2.820414, 0, 1},
            {1.722040, 0, -0.997850, 0, 4.767898, 0, 2.588821, 0, 1},
            {1.642225, 0, -0.946446, 0, 4.292281, 0, 2.376664, 0, 1},
            {1.569530, 0, -0.897342, 0, 3.881018, 0, 2.179606, 0, 1},
            {1.505592, 0, -0.850558, 0, 3.518266, 0, 2.001445, 0, 1},
            {1.446825, 0, -0.804661, 0, 3.199698, 0, 1.836233, 0, 1},
            {1.400495, 0, -0.760898, 0, 2.915498, 0, 1.693745, 0, 1},
            {1.358733, 0, -0.719661, 0, 2.672253, 0, 1.560866, 0, 1},
            {1.315017, 0, -0.679627, 0, 2.460043, 0, 1.433125, 0, 1},
            {1.275442, 0, -0.641727, 0, 2.273172, 0, 1.314863, 0, 1},
            {1.238994, 0, -0.605290, 0, 2.106010, 0, 1.205777, 0, 1},
            {1.210726, 0, -0.570206, 0, 1.959141, 0, 1.110287, 0, 1},
            {1.185854, 0, -0.537214, 0, 1.830824, 0, 1.022619, 0, 1},
            {1.156902, 0, -0.504490, 0, 1.713990, 0, 0.934736, 0, 1},
            {1.130251, 0, -0.472907, 0, 1.611545, 0, 0.853043, 0, 1},
            {1.108888, 0, -0.443138, 0, 1.520653, 0, 0.778845, 0, 1},
            {1.084594, 0, -0.411551, 0, 1.433868, 0, 0.704439, 0, 1},
            {1.057224, 0, -0.378677, 0, 1.354767, 0, 0.630756, 0, 1},
            {1.033701, 0, -0.345537, 0, 1.284055, 0, 0.562606, 0, 1},
            {1.008690, 0, -0.313160, 0, 1.219998, 0, 0.497265, 0, 1},
            {0.985571, 0, -0.281641, 0, 1.162985, 0, 0.437173, 0, 1},
            {0.961933, 0, -0.251454, 0, 1.110853, 0, 0.380646, 0, 1},
            {0.941440, 0, -0.222416, 0, 1.064740, 0, 0.329020, 0, 1},
            {0.919224, 0, -0.194301, 0, 1.020837, 0, 0.279925, 0, 1},
            {0.898780, 0, -0.167465, 0, 0.980660, 0, 0.235833, 0, 1},
            {0.879596, 0, -0.141417, 0, 0.945691, 0, 0.195061, 0, 1},
            {0.862773, 0, -0.116180, 0, 0.917014, 0, 0.159180, 0, 1},
            {0.847710, 0, -0.092103, 0, 0.892612, 0, 0.126118, 0, 1},
            {0.837527, 0, -0.068360, 0, 0.871935, 0, 0.094026, 0, 1},
            {0.831846, 0, -0.045148, 0, 0.854085, 0, 0.061922, 0, 1},
            {0.828295, 0, -0.023199, 0, 0.838678, 0, 0.030957, 0, 1},
            {0.824359, 0, -0.001179, 0, 0.824310, 0, 0.000537, 0, 1},
            {534.931519, 0, -2.076462, 0, 2304.711182, 0, 1110.782715, 0, 1},
            {534.931519, 0, -2.076462, 0, 2304.711182, 0, 1110.782715, 0, 1},
            {528.627502, 0, -2.076462, 0, 2304.711182, 0, 1097.679199, 0, 1},
            {220.649765, 0, -2.076304, 0, 1170.831055, 0, 458.160980, 0, 1},
            {123.931099, 0, -2.075889, 0, 658.919556, 0, 257.328156, 0, 1},
            {79.682602, 0, -2.075014, 0, 421.132446, 0, 165.441055, 0, 1},
            {55.126919, 0, -2.073427, 0, 292.498444, 0, 114.461647, 0, 1},
            {40.417175, 0, -2.070816, 0, 214.591156, 0, 83.909187, 0, 1},
            {30.905352, 0, -2.066834, 0, 164.035019, 0, 64.151772, 0, 1},
            {24.375099, 0, -2.061075, 0, 129.300705, 0, 50.585114, 0, 1},
            {19.691891, 0, -2.053074, 0, 104.380424, 0, 40.853252, 0, 1},
            {16.217587, 0, -2.041667, 0, 85.868156, 0, 33.630775, 0, 1},
            {13.557062, 0, -2.020104, 0, 71.643127, 0, 28.096966, 0, 1},
            {11.480399, 0, -1.999466, 0, 60.549194, 0, 23.774267, 0, 1},
            {9.829308, 0, -1.978149, 0, 51.726891, 0, 20.334194, 0, 1},
            {8.491221, 0, -1.948618, 0, 44.533123, 0, 17.542261, 0, 1},
            {7.394433, 0, -1.916266, 0, 38.615311, 0, 15.249652, 0, 1},
            {6.483265, 0, -1.881097, 0, 33.689857, 0, 13.340503, 0, 1},
            {5.721082, 0, -1.838861, 0, 29.508221, 0, 11.738617, 0, 1},
            {5.077987, 0, -1.796048, 0, 25.962015, 0, 10.381338, 0, 1},
            {4.536246, 0, -1.748015, 0, 22.900066, 0, 9.230186, 0, 1},
            {4.072760, 0, -1.698875, 0, 20.257427, 0, 8.238698, 0, 1},
            {3.686262, 0, -1.643739, 0, 17.921173, 0, 7.401805, 0, 1},
            {3.351644, 0, -1.588342, 0, 15.875896, 0, 6.667620, 0, 1},
            {3.062906, 0, -1.532489, 0, 14.084973, 0, 6.023572, 0, 1},
            {2.826135, 0, -1.475262, 0, 12.475431, 0, 5.480184, 0, 1},
            {2.612152, 0, -1.417196, 0, 11.072163, 0, 4.982215, 0, 1},
            {2.421078, 0, -1.357244, 0, 9.839993, 0, 4.528382, 0, 1},
            {2.262880, 0, -1.297832, 0, 8.733887, 0, 4.137828, 0, 1},
            {2.123210, 0, -1.237986, 0, 7.764506, 0, 3.783846, 0, 1},
            {2.001339, 0, -1.180301, 0, 6.908175, 0, 3.464269, 0, 1},
            {1.888099, 0, -1.124648, 0, 6.165969, 0, 3.165197, 0, 1},
            {1.790447, 0, -1.069121, 0, 5.508952, 0, 2.898229, 0, 1},
            {1.702892, 0, -1.014932, 0, 4.935512, 0, 2.653268, 0, 1},
            {1.627237, 0, -0.961619, 0, 4.432228, 0, 2.433160, 0, 1},
            {1.555372, 0, -0.910303, 0, 3.994545, 0, 2.228181, 0, 1},
            {1.491259, 0, -0.860476, 0, 3.608410, 0, 2.039882, 0, 1},
            {1.433191, 0, -0.813574, 0, 3.274186, 0, 1.867967, 0, 1},
            {1.380491, 0, -0.767979, 0, 2.982822, 0, 1.709671, 0, 1},
            {1.340750, 0, -0.724919, 0, 2.723112, 0, 1.574627, 0, 1},
            {1.302532, 0, -0.683928, 0, 2.499173, 0, 1.447712, 0, 1},
            {1.262818, 0, -0.644420, 0, 2.303014, 0, 1.326102, 0, 1},
            {1.227367, 0, -0.606889, 0, 2.131922, 0, 1.214240, 0, 1},
            {1.198555, 0, -0.570762, 0, 1.978062, 0, 1.115009, 0, 1},
            {1.173720, 0, -0.536307, 0, 1.843448, 0, 1.024792, 0, 1},
            {1.146015, 0, -0.503941, 0, 1.726514, 0, 0.937544, 0, 1},
            {1.120140, 0, -0.472156, 0, 1.621923, 0, 0.854947, 0, 1},
            {1.099030, 0, -0.440997, 0, 1.525176, 0, 0.779421, 0, 1},
            {1.075762, 0, -0.411637, 0, 1.441787, 0, 0.707502, 0, 1},
            {1.053021, 0, -0.381952, 0, 1.364861, 0, 0.638216, 0, 1},
            {1.032377, 0, -0.350971, 0, 1.292393, 0, 0.571711, 0, 1},
            {1.006951, 0, -0.318342, 0, 1.226765, 0, 0.505275, 0, 1},
            {0.982186, 0, -0.286424, 0, 1.166769, 0, 0.443069, 0, 1},
            {0.960956, 0, -0.255637, 0, 1.113608, 0, 0.386492, 0, 1},
            {0.939755, 0, -0.225726, 0, 1.066223, 0, 0.333393, 0, 1},
            {0.916477, 0, -0.196993, 0, 1.020408, 0, 0.283127, 0, 1},
            {0.894526, 0, -0.169568, 0, 0.979850, 0, 0.237879, 0, 1},
            {0.872932, 0, -0.142857, 0, 0.943548, 0, 0.196280, 0, 1},
            {0.856007, 0, -0.116993, 0, 0.914232, 0, 0.159830, 0, 1},
            {0.840900, 0, -0.091758, 0, 0.889403, 0, 0.126496, 0, 1},
            {0.831786, 0, -0.067669, 0, 0.868511, 0, 0.094115, 0, 1},
            {0.826912, 0, -0.044142, 0, 0.850352, 0, 0.061655, 0, 1},
            {0.823764, 0, -0.021328, 0, 0.834539, 0, 0.030128, 0, 1},
            {0.819888, 0, 0.000570, 0, 0.819848, 0, -0.000282, 0, 1},
            {547.698608, 0, -2.216152, 0, 2431.322510, 0, 1213.786133, 0, 1},
            {547.698608, 0, -2.216152, 0, 2431.322510, 0, 1213.786133, 0, 1},
            {541.724854, 0, -2.216151, 0, 2431.322021, 0, 1200.541992, 0, 1},
            {220.495575, 0, -2.215967, 0, 1304.105347, 0, 488.638763, 0, 1},
            {123.997833, 0, -2.215462, 0, 732.982117, 0, 274.797150, 0, 1},
            {79.321518, 0, -2.214395, 0, 467.576630, 0, 175.797195, 0, 1},
            {55.066784, 0, -2.212466, 0, 325.344360, 0, 122.022865, 0, 1},
            {40.409760, 0, -2.209294, 0, 238.733765, 0, 89.534386, 0, 1},
            {30.892561, 0, -2.204457, 0, 182.439606, 0, 68.435677, 0, 1},
            {24.353909, 0, -2.197461, 0, 143.744278, 0, 53.937122, 0, 1},
            {19.665783, 0, -2.187703, 0, 115.982147, 0, 43.538372, 0, 1},
            {16.184109, 0, -2.171568, 0, 95.313591, 0, 35.812431, 0, 1},
            {13.516235, 0, -2.148222, 0, 79.457481, 0, 29.888878, 0, 1},
            {11.437142, 0, -2.124542, 0, 67.084206, 0, 25.268660, 0, 1},
            {9.782360, 0, -2.098555, 0, 57.227875, 0, 21.587015, 0, 1},
            {8.438704, 0, -2.062629, 0, 49.177879, 0, 18.593519, 0, 1},
            {7.338447, 0, -2.026723, 0, 42.578079, 0, 16.136845, 0, 1},
            {6.425764, 0, -1.981691, 0, 37.038700, 0, 14.093365, 0, 1},
            {5.665631, 0, -1.935570, 0, 32.374416, 0, 12.385567, 0, 1},
            {5.022426, 0, -1.884460, 0, 28.398439, 0, 10.933270, 0, 1},
            {4.483363, 0, -1.830806, 0, 24.969889, 0, 9.706996, 0, 1},
            {4.024064, 0, -1.773879, 0, 22.003885, 0, 8.653734, 0, 1},
            {3.634933, 0, -1.711488, 0, 19.395679, 0, 7.750332, 0, 1},
            {3.303313, 0, -1.648617, 0, 17.111935, 0, 6.968053, 0, 1},
            {3.031241, 0, -1.586631, 0, 15.091459, 0, 6.310078, 0, 1},
            {2.788628, 0, -1.523853, 0, 13.331050, 0, 5.712807, 0, 1},
            {2.572773, 0, -1.459336, 0, 11.785311, 0, 5.172314, 0, 1},
            {2.395988, 0, -1.395346, 0, 10.409495, 0, 4.711967, 0, 1},
            {2.234667, 0, -1.330967, 0, 9.212646, 0, 4.285920, 0, 1},
            {2.097995, 0, -1.266162, 0, 8.152663, 0, 3.910729, 0, 1},
            {1.963727, 0, -1.204941, 0, 7.248562, 0, 3.548317, 0, 1},
            {1.857431, 0, -1.145330, 0, 6.437681, 0, 3.240990, 0, 1},
            {1.761508, 0, -1.087543, 0, 5.733542, 0, 2.958986, 0, 1},
            {1.674523, 0, -1.030845, 0, 5.118929, 0, 2.702026, 0, 1},
            {1.603867, 0, -0.975398, 0, 4.579770, 0, 2.478565, 0, 1},
            {1.537894, 0, -0.921826, 0, 4.110187, 0, 2.268970, 0, 1},
            {1.476253, 0, -0.870369, 0, 3.704278, 0, 2.075746, 0, 1},
            {1.418603, 0, -0.820998, 0, 3.345320, 0, 1.897944, 0, 1},
            {1.367561, 0, -0.774169, 0, 3.042042, 0, 1.733577, 0, 1},
            {1.321592, 0, -0.729646, 0, 2.774602, 0, 1.585879, 0, 1},
            {1.287551, 0, -0.687213, 0, 2.537718, 0, 1.457768, 0, 1},
            {1.251045, 0, -0.646876, 0, 2.333415, 0, 1.336647, 0, 1},
            {1.215090, 0, -0.608104, 0, 2.157884, 0, 1.221782, 0, 1},
            {1.187507, 0, -0.570883, 0, 1.997079, 0, 1.120181, 0, 1},
            {1.159110, 0, -0.535681, 0, 1.859120, 0, 1.024047, 0, 1},
            {1.133947, 0, -0.502004, 0, 1.737630, 0, 0.936132, 0, 1},
            {1.108356, 0, -0.470115, 0, 1.629611, 0, 0.853133, 0, 1},
            {1.087486, 0, -0.439269, 0, 1.533357, 0, 0.778441, 0, 1},
            {1.064389, 0, -0.408767, 0, 1.447046, 0, 0.704872, 0, 1},
            {1.044128, 0, -0.379859, 0, 1.370139, 0, 0.637842, 0, 1},
            {1.026752, 0, -0.351967, 0, 1.298760, 0, 0.575662, 0, 1},
            {1.004744, 0, -0.323155, 0, 1.233683, 0, 0.512586, 0, 1},
            {0.979369, 0, -0.291482, 0, 1.172323, 0, 0.448875, 0, 1},
            {0.955765, 0, -0.260312, 0, 1.116926, 0, 0.390081, 0, 1},
            {0.935192, 0, -0.230093, 0, 1.067516, 0, 0.336411, 0, 1},
            {0.909028, 0, -0.200744, 0, 1.019669, 0, 0.284630, 0, 1},
            {0.886791, 0, -0.172159, 0, 0.977862, 0, 0.238740, 0, 1},
            {0.866524, 0, -0.144931, 0, 0.939862, 0, 0.196845, 0, 1},
            {0.851267, 0, -0.118396, 0, 0.910501, 0, 0.160555, 0, 1},
            {0.836332, 0, -0.092470, 0, 0.885691, 0, 0.127088, 0, 1},
            {0.826518, 0, -0.067673, 0, 0.864291, 0, 0.094333, 0, 1},
            {0.822121, 0, -0.043668, 0, 0.846269, 0, 0.061727, 0, 1},
            {0.819036, 0, -0.020758, 0, 0.830123, 0, 0.030026, 0, 1},
            {0.815276, 0, 0.002054, 0, 0.815260, 0, -0.001032, 0, 1},
            {561.883667, 0, -2.372193, 0, 2574.354492, 0, 1332.924683, 0, 1},
            {561.883667, 0, -2.372193, 0, 2574.354492, 0, 1332.924683, 0, 1},
            {555.820129, 0, -2.372194, 0, 2574.354736, 0, 1318.537109, 0, 1},
            {220.281784, 0, -2.371958, 0, 1462.253174, 0, 522.530762, 0, 1},
            {124.201653, 0, -2.371346, 0, 819.630859, 0, 294.612000, 0, 1},
            {79.289734, 0, -2.370037, 0, 525.143250, 0, 188.088806, 0, 1},
            {55.047886, 0, -2.367670, 0, 364.698517, 0, 130.568375, 0, 1},
            {40.397610, 0, -2.363784, 0, 267.540436, 0, 95.807053, 0, 1},
            {30.873516, 0, -2.357851, 0, 204.378632, 0, 73.204865, 0, 1},
            {24.330233, 0, -2.349277, 0, 160.947327, 0, 57.672913, 0, 1},
            {19.635122, 0, -2.337193, 0, 129.779053, 0, 46.524712, 0, 1},
            {16.140512, 0, -2.314546, 0, 106.507278, 0, 38.222347, 0, 1},
            {13.471733, 0, -2.290206, 0, 88.717796, 0, 31.877861, 0, 1},
            {11.385731, 0, -2.262814, 0, 74.812531, 0, 26.913906, 0, 1},
            {9.723210, 0, -2.227956, 0, 63.686466, 0, 22.952801, 0, 1},
            {8.377718, 0, -2.188186, 0, 54.641895, 0, 19.741394, 0, 1},
            {7.275503, 0, -2.145044, 0, 47.198776, 0, 17.104599, 0, 1},
            {6.361020, 0, -2.091993, 0, 40.946705, 0, 14.910710, 0, 1},
            {5.595813, 0, -2.038194, 0, 35.699799, 0, 13.066761, 0, 1},
            {4.959548, 0, -1.978449, 0, 31.195763, 0, 11.523515, 0, 1},
            {4.418256, 0, -1.917762, 0, 27.345129, 0, 10.202260, 0, 1},
            {3.971417, 0, -1.850544, 0, 23.970930, 0, 9.097040, 0, 1},
            {3.578974, 0, -1.780140, 0, 21.051313, 0, 8.117160, 0, 1},
            {3.264671, 0, -1.710932, 0, 18.465061, 0, 7.311978, 0, 1},
            {2.974657, 0, -1.641593, 0, 16.245468, 0, 6.562681, 0, 1},
            {2.742392, 0, -1.571622, 0, 14.267390, 0, 5.941258, 0, 1},
            {2.543485, 0, -1.501255, 0, 12.535033, 0, 5.392533, 0, 1},
            {2.359228, 0, -1.431597, 0, 11.032725, 0, 4.880836, 0, 1},
            {2.195821, 0, -1.362259, 0, 9.735834, 0, 4.416909, 0, 1},
            {2.059949, 0, -1.293351, 0, 8.579062, 0, 4.018088, 0, 1},
            {1.941084, 0, -1.227354, 0, 7.574182, 0, 3.658072, 0, 1},
            {1.835384, 0, -1.164937, 0, 6.709195, 0, 3.329049, 0, 1},
            {1.741773, 0, -1.104218, 0, 5.952015, 0, 3.035784, 0, 1},
            {1.655820, 0, -1.044862, 0, 5.298123, 0, 2.762919, 0, 1},
            {1.580213, 0, -0.987338, 0, 4.727161, 0, 2.517756, 0, 1},
            {1.511588, 0, -0.932578, 0, 4.234377, 0, 2.295705, 0, 1},
            {1.458300, 0, -0.879306, 0, 3.799523, 0, 2.104888, 0, 1},
            {1.404009, 0, -0.827517, 0, 3.426577, 0, 1.921788, 0, 1},
            {1.352626, 0, -0.779565, 0, 3.106237, 0, 1.752501, 0, 1},
            {1.306817, 0, -0.733467, 0, 2.825721, 0, 1.599079, 0, 1},
            {1.271053, 0, -0.689857, 0, 2.577658, 0, 1.466005, 0, 1},
            {1.237855, 0, -0.648652, 0, 2.363580, 0, 1.344115, 0, 1},
            {1.202994, 0, -0.608877, 0, 2.179758, 0, 1.226534, 0, 1},
            {1.171368, 0, -0.570961, 0, 2.018505, 0, 1.119002, 0, 1},
            {1.147960, 0, -0.534654, 0, 1.872719, 0, 1.025949, 0, 1},
            {1.122561, 0, -0.499815, 0, 1.747553, 0, 0.935527, 0, 1},
            {1.096977, 0, -0.467389, 0, 1.636278, 0, 0.850964, 0, 1},
            {1.076256, 0, -0.436104, 0, 1.537529, 0, 0.775857, 0, 1},
            {1.054496, 0, -0.406137, 0, 1.450749, 0, 0.703234, 0, 1},
            {1.033806, 0, -0.376303, 0, 1.371762, 0, 0.634744, 0, 1},
            {1.016144, 0, -0.348055, 0, 1.301348, 0, 0.571584, 0, 1},
            {0.996595, 0, -0.321551, 0, 1.237378, 0, 0.511230, 0, 1},
            {0.973683, 0, -0.293872, 0, 1.177277, 0, 0.451901, 0, 1},
            {0.952858, 0, -0.265573, 0, 1.121921, 0, 0.395157, 0, 1},
            {0.932103, 0, -0.234927, 0, 1.070360, 0, 0.340860, 0, 1},
            {0.906343, 0, -0.205238, 0, 1.020510, 0, 0.288028, 0, 1},
            {0.883492, 0, -0.175993, 0, 0.976709, 0, 0.241092, 0, 1},
            {0.863536, 0, -0.147622, 0, 0.938731, 0, 0.199073, 0, 1},
            {0.847930, 0, -0.120674, 0, 0.907943, 0, 0.161710, 0, 1},
            {0.831768, 0, -0.094574, 0, 0.881993, 0, 0.127969, 0, 1},
            {0.821893, 0, -0.069053, 0, 0.860528, 0, 0.095084, 0, 1},
            {0.817158, 0, -0.044333, 0, 0.841729, 0, 0.062147, 0, 1},
            {0.814238, 0, -0.020307, 0, 0.825477, 0, 0.029873, 0, 1},
            {0.810121, 0, 0.002974, 0, 0.810311, 0, -0.001535, 0, 1},
            {576.155396, 0, -2.547854, 0, 2737.071289, 0, 1467.987549, 0, 1},
            {576.155396, 0, -2.547854, 0, 2737.071289, 0, 1467.987549, 0, 1},
            {570.679626, 0, -2.547851, 0, 2737.068115, 0, 1454.044189, 0, 1},
            {219.949402, 0, -2.547569, 0, 1652.645996, 0, 560.372742, 0, 1},
            {124.049660, 0, -2.546798, 0, 928.846924, 0, 316.036011, 0, 1},
            {79.356262, 0, -2.545179, 0, 592.101196, 0, 202.193970, 0, 1},
            {55.019466, 0, -2.542244, 0, 412.138947, 0, 140.161835, 0, 1},
            {40.381809, 0, -2.537436, 0, 302.276550, 0, 102.856575, 0, 1},
            {30.849314, 0, -2.530093, 0, 230.778442, 0, 78.558495, 0, 1},
            {24.298800, 0, -2.519463, 0, 181.682220, 0, 61.856510, 0, 1},
            {19.596741, 0, -2.503993, 0, 146.369858, 0, 49.862972, 0, 1},
            {16.090612, 0, -2.474526, 0, 119.922760, 0, 40.914909, 0, 1},
            {13.414685, 0, -2.445985, 0, 99.772415, 0, 34.080334, 0, 1},
            {11.326571, 0, -2.415291, 0, 84.030655, 0, 28.740780, 0, 1},
            {9.656653, 0, -2.370714, 0, 71.358482, 0, 24.465014, 0, 1},
            {8.307189, 0, -2.326006, 0, 61.118118, 0, 21.002472, 0, 1},
            {7.199588, 0, -2.270571, 0, 52.623745, 0, 18.153734, 0, 1},
            {6.282018, 0, -2.211361, 0, 45.534695, 0, 15.785805, 0, 1},
            {5.522021, 0, -2.146492, 0, 39.536274, 0, 13.813814, 0, 1},
            {4.882924, 0, -2.078670, 0, 34.440823, 0, 12.144946, 0, 1},
            {4.356023, 0, -2.006198, 0, 30.023258, 0, 10.753566, 0, 1},
            {3.898880, 0, -1.930101, 0, 26.226927, 0, 9.534962, 0, 1},
            {3.531555, 0, -1.850331, 0, 22.867672, 0, 8.535707, 0, 1},
            {3.198603, 0, -1.772878, 0, 20.004835, 0, 7.619294, 0, 1},
            {2.933550, 0, -1.695997, 0, 17.472128, 0, 6.864677, 0, 1},
            {2.701499, 0, -1.618183, 0, 15.259388, 0, 6.191448, 0, 1},
            {2.490056, 0, -1.541568, 0, 13.372395, 0, 5.570883, 0, 1},
            {2.317339, 0, -1.466060, 0, 11.708906, 0, 5.042511, 0, 1},
            {2.167865, 0, -1.391161, 0, 10.251340, 0, 4.573291, 0, 1},
            {2.034562, 0, -1.318470, 0, 8.998850, 0, 4.146386, 0, 1},
            {1.915546, 0, -1.248121, 0, 7.919498, 0, 3.760329, 0, 1},
            {1.811551, 0, -1.182497, 0, 6.981235, 0, 3.414596, 0, 1},
            {1.718818, 0, -1.118587, 0, 6.178648, 0, 3.102079, 0, 1},
            {1.635832, 0, -1.057053, 0, 5.475736, 0, 2.820240, 0, 1},
            {1.560237, 0, -0.997972, 0, 4.873555, 0, 2.561483, 0, 1},
            {1.492896, 0, -0.941521, 0, 4.354918, 0, 2.328868, 0, 1},
            {1.432661, 0, -0.886628, 0, 3.903405, 0, 2.119366, 0, 1},
            {1.386325, 0, -0.834151, 0, 3.505340, 0, 1.940481, 0, 1},
            {1.339124, 0, -0.783834, 0, 3.168668, 0, 1.770534, 0, 1},
            {1.292755, 0, -0.736675, 0, 2.876822, 0, 1.611066, 0, 1},
            {1.253299, 0, -0.691708, 0, 2.619975, 0, 1.469811, 0, 1},
            {1.225671, 0, -0.649674, 0, 2.395588, 0, 1.350131, 0, 1},
            {1.190501, 0, -0.609351, 0, 2.204555, 0, 1.229164, 0, 1},
            {1.158919, 0, -0.570638, 0, 2.035227, 0, 1.120084, 0, 1},
            {1.134398, 0, -0.533575, 0, 1.890159, 0, 1.024165, 0, 1},
            {1.111440, 0, -0.498114, 0, 1.758849, 0, 0.935233, 0, 1},
            {1.086176, 0, -0.464332, 0, 1.644120, 0, 0.849060, 0, 1},
            {1.065165, 0, -0.432413, 0, 1.541869, 0, 0.772161, 0, 1},
            {1.043913, 0, -0.401934, 0, 1.452574, 0, 0.698629, 0, 1},
            {1.023994, 0, -0.372557, 0, 1.373027, 0, 0.631276, 0, 1},
            {1.007105, 0, -0.343961, 0, 1.301265, 0, 0.568990, 0, 1},
            {0.985595, 0, -0.316279, 0, 1.237189, 0, 0.506592, 0, 1},
            {0.965932, 0, -0.290229, 0, 1.176849, 0, 0.449525, 0, 1},
            {0.947778, 0, -0.265034, 0, 1.123219, 0, 0.396264, 0, 1},
            {0.928999, 0, -0.237887, 0, 1.072133, 0, 0.344178, 0, 1},
            {0.906132, 0, -0.210059, 0, 1.022744, 0, 0.293002, 0, 1},
            {0.881884, 0, -0.180829, 0, 0.976437, 0, 0.244573, 0, 1},
            {0.861608, 0, -0.152207, 0, 0.937424, 0, 0.201887, 0, 1},
            {0.844634, 0, -0.124227, 0, 0.905560, 0, 0.163576, 0, 1},
            {0.828255, 0, -0.097599, 0, 0.878795, 0, 0.129343, 0, 1},
            {0.817685, 0, -0.071521, 0, 0.856518, 0, 0.096351, 0, 1},
            {0.812417, 0, -0.046059, 0, 0.837175, 0, 0.062946, 0, 1},
            {0.809044, 0, -0.021396, 0, 0.820474, 0, 0.030318, 0, 1},
            {0.804879, 0, 0.002828, 0, 0.805044, 0, -0.001440, 0, 1},
            {591.979065, 0, -2.747348, 0, 2923.682129, 0, 1626.421753, 0, 1},
            {591.979065, 0, -2.747348, 0, 2923.682129, 0, 1626.421753, 0, 1},
            {585.857239, 0, -2.747350, 0, 2923.684814, 0, 1609.603516, 0, 1},
            {220.596573, 0, -2.746992, 0, 1883.560547, 0, 606.021301, 0, 1},
            {124.091286, 0, -2.746026, 0, 1060.800293, 0, 340.915314, 0, 1},
            {79.291206, 0, -2.744001, 0, 677.687866, 0, 217.823547, 0, 1},
            {55.000206, 0, -2.740324, 0, 470.018585, 0, 151.078918, 0, 1},
            {40.352585, 0, -2.734293, 0, 344.664581, 0, 110.824989, 0, 1},
            {30.819353, 0, -2.725093, 0, 263.048004, 0, 84.619637, 0, 1},
            {24.259277, 0, -2.711737, 0, 206.912613, 0, 66.582367, 0, 1},
            {19.544426, 0, -2.688740, 0, 166.451782, 0, 53.611942, 0, 1},
            {16.031746, 0, -2.657396, 0, 136.256454, 0, 43.942513, 0, 1},
            {13.348059, 0, -2.623393, 0, 113.201004, 0, 36.548397, 0, 1},
            {11.250923, 0, -2.582639, 0, 95.119232, 0, 30.763483, 0, 1},
            {9.576438, 0, -2.530882, 0, 80.600281, 0, 26.136324, 0, 1},
            {8.221527, 0, -2.475935, 0, 68.837944, 0, 22.384205, 0, 1},
            {7.113983, 0, -2.409505, 0, 59.067413, 0, 19.308332, 0, 1},
            {6.197548, 0, -2.338610, 0, 50.926388, 0, 16.751787, 0, 1},
            {5.440971, 0, -2.262158, 0, 44.025623, 0, 14.628505, 0, 1},
            {4.810040, 0, -2.183774, 0, 38.160038, 0, 12.843379, 0, 1},
            {4.271906, 0, -2.099138, 0, 33.135784, 0, 11.306775, 0, 1},
            {3.841789, 0, -2.011097, 0, 28.717783, 0, 10.054306, 0, 1},
            {3.454507, 0, -1.921342, 0, 24.955898, 0, 8.917191, 0, 1},
            {3.152499, 0, -1.835073, 0, 21.643391, 0, 7.997777, 0, 1},
            {2.881393, 0, -1.748274, 0, 18.804960, 0, 7.161386, 0, 1},
            {2.646318, 0, -1.662911, 0, 16.357586, 0, 6.421481, 0, 1},
            {2.453516, 0, -1.579613, 0, 14.224945, 0, 5.790412, 0, 1},
            {2.279099, 0, -1.497639, 0, 12.393144, 0, 5.215179, 0, 1},
            {2.132395, 0, -1.418428, 0, 10.806620, 0, 4.713103, 0, 1},
            {2.000552, 0, -1.341211, 0, 9.451211, 0, 4.258870, 0, 1},
            {1.883975, 0, -1.267610, 0, 8.279186, 0, 3.849678, 0, 1},
            {1.781922, 0, -1.197456, 0, 7.275274, 0, 3.485601, 0, 1},
            {1.690599, 0, -1.131133, 0, 6.411116, 0, 3.156461, 0, 1},
            {1.609352, 0, -1.067260, 0, 5.665935, 0, 2.861347, 0, 1},
            {1.536435, 0, -1.006782, 0, 5.026215, 0, 2.595317, 0, 1},
            {1.473972, 0, -0.948499, 0, 4.474440, 0, 2.359128, 0, 1},
            {1.415006, 0, -0.892800, 0, 3.999731, 0, 2.142897, 0, 1},
            {1.362257, 0, -0.839350, 0, 3.587323, 0, 1.948521, 0, 1},
            {1.321058, 0, -0.788246, 0, 3.232098, 0, 1.781589, 0, 1},
            {1.278192, 0, -0.739176, 0, 2.923230, 0, 1.622009, 0, 1},
            {1.237881, 0, -0.693319, 0, 2.663199, 0, 1.474434, 0, 1},
            {1.207696, 0, -0.650035, 0, 2.429032, 0, 1.348468, 0, 1},
            {1.178601, 0, -0.608997, 0, 2.228594, 0, 1.232671, 0, 1},
            {1.147043, 0, -0.569985, 0, 2.055526, 0, 1.120635, 0, 1},
            {1.121972, 0, -0.532453, 0, 1.901420, 0, 1.022556, 0, 1},
            {1.100569, 0, -0.496317, 0, 1.768029, 0, 0.933909, 0, 1},
            {1.075219, 0, -0.461706, 0, 1.651654, 0, 0.846179, 0, 1},
            {1.054461, 0, -0.428867, 0, 1.546500, 0, 0.768466, 0, 1},
            {1.032911, 0, -0.397718, 0, 1.454769, 0, 0.694165, 0, 1},
            {1.013181, 0, -0.367858, 0, 1.372598, 0, 0.626156, 0, 1},
            {0.996504, 0, -0.339273, 0, 1.300198, 0, 0.563517, 0, 1},
            {0.977925, 0, -0.311489, 0, 1.235241, 0, 0.504684, 0, 1},
            {0.957146, 0, -0.284534, 0, 1.174922, 0, 0.445710, 0, 1},
            {0.939880, 0, -0.258582, 0, 1.119166, 0, 0.392739, 0, 1},
            {0.922315, 0, -0.234026, 0, 1.068956, 0, 0.343095, 0, 1},
            {0.901600, 0, -0.209740, 0, 1.021756, 0, 0.294328, 0, 1},
            {0.879210, 0, -0.184296, 0, 0.976296, 0, 0.247898, 0, 1},
            {0.859167, 0, -0.157756, 0, 0.936724, 0, 0.205469, 0, 1},
            {0.841163, 0, -0.129551, 0, 0.903177, 0, 0.166426, 0, 1},
            {0.825317, 0, -0.101891, 0, 0.875356, 0, 0.131082, 0, 1},
            {0.813604, 0, -0.074977, 0, 0.852356, 0, 0.097887, 0, 1},
            {0.807587, 0, -0.049031, 0, 0.832818, 0, 0.064502, 0, 1},
            {0.804014, 0, -0.023671, 0, 0.815511, 0, 0.031406, 0, 1},
            {0.799529, 0, 0.000896, 0, 0.799522, 0, -0.000557, 0, 1},
            {609.309082, 0, -2.976188, 0, 3139.696533, 0, 1813.482910, 0, 1},
            {609.309082, 0, -2.976188, 0, 3139.696533, 0, 1813.482910, 0, 1},
            {599.533997, 0, -2.976186, 0, 3139.695068, 0, 1784.326904, 0, 1},
            {220.005768, 0, -2.975734, 0, 2176.998535, 0, 654.730896, 0, 1},
            {123.973022, 0, -2.974506, 0, 1222.066284, 0, 368.964386, 0, 1},
            {79.281036, 0, -2.971936, 0, 781.406067, 0, 235.946762, 0, 1},
            {55.192818, 0, -2.967260, 0, 540.474792, 0, 164.247833, 0, 1},
            {40.323109, 0, -2.959602, 0, 397.124451, 0, 119.960411, 0, 1},
            {30.776093, 0, -2.947913, 0, 303.002441, 0, 91.530830, 0, 1},
            {24.212482, 0, -2.930790, 0, 238.076202, 0, 71.976578, 0, 1},
            {19.479084, 0, -2.898876, 0, 191.196457, 0, 57.867847, 0, 1},
            {15.959665, 0, -2.862951, 0, 156.304749, 0, 47.369671, 0, 1},
            {13.270151, 0, -2.822713, 0, 129.607895, 0, 39.338791, 0, 1},
            {11.160513, 0, -2.766519, 0, 108.577446, 0, 33.030273, 0, 1},
            {9.480922, 0, -2.708910, 0, 91.815163, 0, 27.997881, 0, 1},
            {8.122663, 0, -2.637697, 0, 78.090034, 0, 23.917656, 0, 1},
            {7.008977, 0, -2.559766, 0, 66.786209, 0, 20.561243, 0, 1},
            {6.096513, 0, -2.473841, 0, 57.295067, 0, 17.796728, 0, 1},
            {5.343040, 0, -2.386606, 0, 49.325001, 0, 15.497151, 0, 1},
            {4.708989, 0, -2.291916, 0, 42.511387, 0, 13.544899, 0, 1},
            {4.201791, 0, -2.193527, 0, 36.615200, 0, 11.955845, 0, 1},
            {3.752419, 0, -2.092327, 0, 31.602551, 0, 10.535487, 0, 1},
            {3.400778, 0, -1.992388, 0, 27.209482, 0, 9.388092, 0, 1},
            {3.075908, 0, -1.894753, 0, 23.517771, 0, 8.322371, 0, 1},
            {2.822646, 0, -1.798583, 0, 20.275318, 0, 7.457544, 0, 1},
            {2.596779, 0, -1.705360, 0, 17.520607, 0, 6.671628, 0, 1},
            {2.408336, 0, -1.614572, 0, 15.142595, 0, 5.996811, 0, 1},
            {2.228113, 0, -1.527009, 0, 13.147862, 0, 5.359822, 0, 1},
            {2.082584, 0, -1.442503, 0, 11.407831, 0, 4.823703, 0, 1},
            {1.954687, 0, -1.361189, 0, 9.930226, 0, 4.343667, 0, 1},
            {1.843097, 0, -1.284112, 0, 8.663873, 0, 3.915370, 0, 1},
            {1.741703, 0, -1.210228, 0, 7.587466, 0, 3.529680, 0, 1},
            {1.653501, 0, -1.141024, 0, 6.654636, 0, 3.190945, 0, 1},
            {1.574357, 0, -1.075586, 0, 5.863158, 0, 2.883028, 0, 1},
            {1.514068, 0, -1.013358, 0, 5.180198, 0, 2.625021, 0, 1},
            {1.451065, 0, -0.953914, 0, 4.595654, 0, 2.379616, 0, 1},
            {1.397773, 0, -0.897316, 0, 4.092642, 0, 2.165335, 0, 1},
            {1.344997, 0, -0.843040, 0, 3.668342, 0, 1.961642, 0, 1},
            {1.303292, 0, -0.791443, 0, 3.291798, 0, 1.788869, 0, 1},
            {1.265215, 0, -0.741998, 0, 2.976985, 0, 1.630472, 0, 1},
            {1.225075, 0, -0.694471, 0, 2.701860, 0, 1.481267, 0, 1},
            {1.194183, 0, -0.649997, 0, 2.462663, 0, 1.350566, 0, 1},
            {1.165196, 0, -0.608316, 0, 2.254755, 0, 1.231374, 0, 1},
            {1.135252, 0, -0.568783, 0, 2.073478, 0, 1.120476, 0, 1},
            {1.111022, 0, -0.530798, 0, 1.916914, 0, 1.020819, 0, 1},
            {1.089636, 0, -0.494500, 0, 1.778285, 0, 0.930296, 0, 1},
            {1.064094, 0, -0.459504, 0, 1.658414, 0, 0.842595, 0, 1},
            {1.043721, 0, -0.425796, 0, 1.551288, 0, 0.764729, 0, 1},
            {1.022393, 0, -0.393855, 0, 1.458256, 0, 0.690367, 0, 1},
            {1.002968, 0, -0.363419, 0, 1.373205, 0, 0.621274, 0, 1},
            {0.986589, 0, -0.334171, 0, 1.297770, 0, 0.558746, 0, 1},
            {0.967622, 0, -0.305847, 0, 1.230629, 0, 0.498214, 0, 1},
            {0.948060, 0, -0.278763, 0, 1.170430, 0, 0.441200, 0, 1},
            {0.930849, 0, -0.252923, 0, 1.115696, 0, 0.388823, 0, 1},
            {0.913940, 0, -0.227570, 0, 1.065467, 0, 0.339005, 0, 1},
            {0.892977, 0, -0.203280, 0, 1.017061, 0, 0.290406, 0, 1},
            {0.872234, 0, -0.179861, 0, 0.971964, 0, 0.245777, 0, 1},
            {0.854700, 0, -0.157132, 0, 0.933678, 0, 0.205812, 0, 1},
            {0.838287, 0, -0.132687, 0, 0.900439, 0, 0.168176, 0, 1},
            {0.822851, 0, -0.107598, 0, 0.871917, 0, 0.133193, 0, 1},
            {0.809299, 0, -0.080322, 0, 0.848205, 0, 0.100180, 0, 1},
            {0.802156, 0, -0.053745, 0, 0.827838, 0, 0.066531, 0, 1},
            {0.798404, 0, -0.027654, 0, 0.810059, 0, 0.033353, 0, 1},
            {0.794037, 0, -0.002317, 0, 0.793657, 0, 0.001048, 0, 1},
            {627.807556, 0, -3.241722, 0, 3392.456543, 0, 2035.267212, 0, 1},
            {627.807556, 0, -3.241722, 0, 3392.456543, 0, 2035.267212, 0, 1},
            {621.662354, 0, -3.241717, 0, 3392.452148, 0, 2015.334473, 0, 1},
            {219.384842, 0, -3.241129, 0, 2544.900879, 0, 711.118835, 0, 1},
            {123.947891, 0, -3.239542, 0, 1426.574707, 0, 401.798828, 0, 1},
            {79.003059, 0, -3.236218, 0, 917.752502, 0, 256.063232, 0, 1},
            {54.984375, 0, -3.230180, 0, 632.198608, 0, 178.201828, 0, 1},
            {40.294662, 0, -3.220297, 0, 463.117645, 0, 130.561554, 0, 1},
            {30.729254, 0, -3.205191, 0, 353.041718, 0, 99.531891, 0, 1},
            {24.151039, 0, -3.182074, 0, 277.121613, 0, 78.181152, 0, 1},
            {19.399094, 0, -3.140306, 0, 222.113632, 0, 62.750744, 0, 1},
            {15.868593, 0, -3.097450, 0, 181.281265, 0, 51.274391, 0, 1},
            {13.170238, 0, -3.046266, 0, 149.986618, 0, 42.492733, 0, 1},
            {11.050856, 0, -2.978175, 0, 125.258781, 0, 35.585133, 0, 1},
            {9.365080, 0, -2.904929, 0, 105.521988, 0, 30.077997, 0, 1},
            {7.999448, 0, -2.817907, 0, 89.409409, 0, 25.602217, 0, 1},
            {6.891818, 0, -2.722713, 0, 76.069191, 0, 21.957558, 0, 1},
            {5.980109, 0, -2.621234, 0, 64.915245, 0, 18.938150, 0, 1},
            {5.236940, 0, -2.514768, 0, 55.498199, 0, 16.453793, 0, 1},
            {4.622044, 0, -2.403527, 0, 47.479614, 0, 14.373193, 0, 1},
            {4.097895, 0, -2.289582, 0, 40.671871, 0, 12.577087, 0, 1},
            {3.686765, 0, -2.174217, 0, 34.736500, 0, 11.129078, 0, 1},
            {3.311024, 0, -2.061530, 0, 29.781372, 0, 9.799330, 0, 1},
            {3.020529, 0, -1.952210, 0, 25.481171, 0, 8.724760, 0, 1},
            {2.764692, 0, -1.846283, 0, 21.836864, 0, 7.766133, 0, 1},
            {2.532754, 0, -1.744292, 0, 18.781441, 0, 6.894820, 0, 1},
            {2.349347, 0, -1.646240, 0, 16.140751, 0, 6.170644, 0, 1},
            {2.188400, 0, -1.552627, 0, 13.893661, 0, 5.528216, 0, 1},
            {2.046618, 0, -1.462889, 0, 11.998612, 0, 4.956185, 0, 1},
            {1.915704, 0, -1.377927, 0, 10.397959, 0, 4.436332, 0, 1},
            {1.812031, 0, -1.297612, 0, 9.029160, 0, 3.997908, 0, 1},
            {1.713683, 0, -1.221086, 0, 7.877707, 0, 3.593457, 0, 1},
            {1.626020, 0, -1.148731, 0, 6.891469, 0, 3.233786, 0, 1},
            {1.549033, 0, -1.081457, 0, 6.053651, 0, 2.917126, 0, 1},
            {1.481601, 0, -1.017843, 0, 5.337873, 0, 2.636702, 0, 1},
            {1.429952, 0, -0.957599, 0, 4.717435, 0, 2.399858, 0, 1},
            {1.377009, 0, -0.899917, 0, 4.189492, 0, 2.173976, 0, 1},
            {1.327084, 0, -0.845428, 0, 3.747870, 0, 1.971158, 0, 1},
            {1.281468, 0, -0.793353, 0, 3.362427, 0, 1.788266, 0, 1},
            {1.248655, 0, -0.743373, 0, 3.024901, 0, 1.633455, 0, 1},
            {1.211484, 0, -0.696148, 0, 2.742902, 0, 1.484475, 0, 1},
            {1.177250, 0, -0.650527, 0, 2.496114, 0, 1.348093, 0, 1},
            {1.152354, 0, -0.607068, 0, 2.280983, 0, 1.230821, 0, 1},
            {1.123183, 0, -0.567146, 0, 2.094286, 0, 1.118462, 0, 1},
            {1.099171, 0, -0.528939, 0, 1.931954, 0, 1.018845, 0, 1},
            {1.078446, 0, -0.492371, 0, 1.789327, 0, 0.927930, 0, 1},
            {1.053617, 0, -0.457237, 0, 1.666223, 0, 0.839066, 0, 1},
            {1.033628, 0, -0.423433, 0, 1.556569, 0, 0.760340, 0, 1},
            {1.012232, 0, -0.390587, 0, 1.460020, 0, 0.685059, 0, 1},
            {0.993610, 0, -0.359251, 0, 1.373768, 0, 0.616781, 0, 1},
            {0.977490, 0, -0.329358, 0, 1.297351, 0, 0.554401, 0, 1},
            {0.957394, 0, -0.300853, 0, 1.228527, 0, 0.492929, 0, 1},
            {0.938283, 0, -0.273293, 0, 1.166369, 0, 0.436095, 0, 1},
            {0.920914, 0, -0.246713, 0, 1.109896, 0, 0.383355, 0, 1},
            {0.904340, 0, -0.221276, 0, 1.059823, 0, 0.334259, 0, 1},
            {0.883903, 0, -0.196707, 0, 1.011503, 0, 0.286181, 0, 1},
            {0.864120, 0, -0.172631, 0, 0.966135, 0, 0.242077, 0, 1},
            {0.846583, 0, -0.149250, 0, 0.927177, 0, 0.201925, 0, 1},
            {0.831405, 0, -0.126938, 0, 0.894544, 0, 0.165708, 0, 1},
            {0.817396, 0, -0.105439, 0, 0.866856, 0, 0.132669, 0, 1},
            {0.804355, 0, -0.082556, 0, 0.843154, 0, 0.100933, 0, 1},
            {0.796824, 0, -0.059510, 0, 0.822757, 0, 0.069400, 0, 1},
            {0.792355, 0, -0.033496, 0, 0.804279, 0, 0.036095, 0, 1},
            {0.787991, 0, -0.007457, 0, 0.787428, 0, 0.003372, 0, 1},
            {647.389587, 0, -3.553956, 0, 3691.964600, 0, 2300.922119, 0, 1},
            {647.389587, 0, -3.553956, 0, 3691.964600, 0, 2300.922119, 0, 1},
            {641.360107, 0, -3.553950, 0, 3691.958496, 0, 2279.477783, 0, 1},
            {218.265366, 0, -3.553173, 0, 3019.637451, 0, 775.611084, 0, 1},
            {123.939934, 0, -3.551092, 0, 1689.255981, 0, 440.471039, 0, 1},
            {79.242523, 0, -3.546700, 0, 1079.528564, 0, 281.592926, 0, 1},
            {55.156261, 0, -3.538764, 0, 745.203552, 0, 195.782745, 0, 1},
            {40.278416, 0, -3.525745, 0, 547.770447, 0, 143.056854, 0, 1},
            {30.671082, 0, -3.505799, 0, 417.175690, 0, 108.892921, 0, 1},
            {24.060156, 0, -3.467991, 0, 326.705200, 0, 85.365662, 0, 1},
            {19.301073, 0, -3.423038, 0, 261.538574, 0, 68.416756, 0, 1},
            {15.758986, 0, -3.369555, 0, 212.967697, 0, 55.787514, 0, 1},
            {13.041642, 0, -3.296016, 0, 175.468872, 0, 46.086483, 0, 1},
            {10.917159, 0, -3.218122, 0, 146.157425, 0, 38.485374, 0, 1},
            {9.225276, 0, -3.122428, 0, 122.516930, 0, 32.418598, 0, 1},
            {7.856061, 0, -3.014502, 0, 103.264420, 0, 27.490166, 0, 1},
            {6.747007, 0, -2.897921, 0, 87.332703, 0, 23.474401, 0, 1},
            {5.849679, 0, -2.777437, 0, 74.034065, 0, 20.199072, 0, 1},
            {5.114362, 0, -2.649389, 0, 62.826855, 0, 17.483440, 0, 1},
            {4.498669, 0, -2.518499, 0, 53.354347, 0, 15.184261, 0, 1},
            {4.007944, 0, -2.385035, 0, 45.195190, 0, 13.307499, 0, 1},
            {3.581131, 0, -2.254358, 0, 38.371635, 0, 11.654906, 0, 1},
            {3.237079, 0, -2.127479, 0, 32.555920, 0, 10.283057, 0, 1},
            {2.930858, 0, -2.005708, 0, 27.701151, 0, 9.052230, 0, 1},
            {2.689690, 0, -1.889617, 0, 23.555668, 0, 8.037099, 0, 1},
            {2.483467, 0, -1.778557, 0, 20.060087, 0, 7.155442, 0, 1},
            {2.293832, 0, -1.673535, 0, 17.148470, 0, 6.351363, 0, 1},
            {2.135620, 0, -1.573599, 0, 14.684332, 0, 5.659710, 0, 1},
            {1.987061, 0, -1.479354, 0, 12.640908, 0, 5.028449, 0, 1},
            {1.868026, 0, -1.390879, 0, 10.898802, 0, 4.499014, 0, 1},
            {1.771079, 0, -1.307645, 0, 9.410772, 0, 4.049167, 0, 1},
            {1.676226, 0, -1.228918, 0, 8.178362, 0, 3.632594, 0, 1},
            {1.593909, 0, -1.154423, 0, 7.127514, 0, 3.264067, 0, 1},
            {1.524403, 0, -1.084977, 0, 6.236141, 0, 2.946008, 0, 1},
            {1.457701, 0, -1.020340, 0, 5.487920, 0, 2.653812, 0, 1},
            {1.397869, 0, -0.959165, 0, 4.847727, 0, 2.395974, 0, 1},
            {1.353524, 0, -0.901146, 0, 4.294834, 0, 2.178798, 0, 1},
            {1.307459, 0, -0.846153, 0, 3.821842, 0, 1.975281, 0, 1},
            {1.264822, 0, -0.793965, 0, 3.427145, 0, 1.792382, 0, 1},
            {1.232861, 0, -0.744066, 0, 3.078772, 0, 1.634613, 0, 1},
            {1.198096, 0, -0.696585, 0, 2.783012, 0, 1.486259, 0, 1},
            {1.164023, 0, -0.651000, 0, 2.530066, 0, 1.347213, 0, 1},
            {1.139180, 0, -0.607608, 0, 2.308247, 0, 1.229578, 0, 1},
            {1.111229, 0, -0.565667, 0, 2.117224, 0, 1.116433, 0, 1},
            {1.084021, 0, -0.526840, 0, 1.949802, 0, 1.012064, 0, 1},
            {1.066097, 0, -0.490156, 0, 1.801883, 0, 0.922837, 0, 1},
            {1.043552, 0, -0.454714, 0, 1.673110, 0, 0.835639, 0, 1},
            {1.023415, 0, -0.420670, 0, 1.561875, 0, 0.755595, 0, 1},
            {1.002639, 0, -0.387887, 0, 1.462044, 0, 0.680924, 0, 1},
            {0.983821, 0, -0.356239, 0, 1.374733, 0, 0.612270, 0, 1},
            {0.967302, 0, -0.325740, 0, 1.295897, 0, 0.549230, 0, 1},
            {0.947598, 0, -0.296622, 0, 1.226382, 0, 0.488305, 0, 1},
            {0.928112, 0, -0.268374, 0, 1.162806, 0, 0.430749, 0, 1},
            {0.911786, 0, -0.241309, 0, 1.105636, 0, 0.378463, 0, 1},
            {0.894347, 0, -0.214930, 0, 1.053365, 0, 0.328932, 0, 1},
            {0.873960, 0, -0.189724, 0, 1.004209, 0, 0.281304, 0, 1},
            {0.855796, 0, -0.165473, 0, 0.959591, 0, 0.237673, 0, 1},
            {0.837609, 0, -0.141919, 0, 0.920479, 0, 0.198007, 0, 1},
            {0.823842, 0, -0.119185, 0, 0.888295, 0, 0.162131, 0, 1},
            {0.809707, 0, -0.096579, 0, 0.860153, 0, 0.128809, 0, 1},
            {0.797911, 0, -0.074969, 0, 0.836638, 0, 0.097869, 0, 1},
            {0.791218, 0, -0.053931, 0, 0.816275, 0, 0.066670, 0, 1},
            {0.786383, 0, -0.033321, 0, 0.797938, 0, 0.035935, 0, 1},
            {0.781418, 0, -0.010912, 0, 0.780861, 0, 0.004979, 0, 1},
            {669.793640, 0, -3.926907, 0, 4052.233643, 0, 2630.377197, 0, 1},
            {669.793640, 0, -3.926907, 0, 4052.233643, 0, 2630.377197, 0, 1},
            {662.583923, 0, -3.926905, 0, 4052.232178, 0, 2602.060547, 0, 1},
            {220.819077, 0, -3.925857, 0, 3622.162109, 0, 867.089783, 0, 1},
            {123.817673, 0, -3.923046, 0, 2034.233154, 0, 486.212982, 0, 1},
            {79.227966, 0, -3.917133, 0, 1302.296997, 0, 311.076263, 0, 1},
            {55.249779, 0, -3.906432, 0, 900.683044, 0, 216.477371, 0, 1},
            {40.206520, 0, -3.888882, 0, 658.625366, 0, 157.687820, 0, 1},
            {30.587492, 0, -3.861604, 0, 501.091522, 0, 119.964844, 0, 1},
            {23.948280, 0, -3.808159, 0, 391.395477, 0, 93.850357, 0, 1},
            {19.172970, 0, -3.751776, 0, 312.602203, 0, 75.050499, 0, 1},
            {15.616179, 0, -3.682316, 0, 253.770706, 0, 61.030109, 0, 1},
            {12.883894, 0, -3.589303, 0, 208.295837, 0, 50.240662, 0, 1},
            {10.749632, 0, -3.484726, 0, 172.584320, 0, 41.794483, 0, 1},
            {9.049759, 0, -3.365489, 0, 143.919708, 0, 35.044212, 0, 1},
            {7.683127, 0, -3.228995, 0, 120.468864, 0, 29.591896, 0, 1},
            {6.586706, 0, -3.090356, 0, 101.165565, 0, 25.184006, 0, 1},
            {5.702530, 0, -2.941245, 0, 84.986687, 0, 21.591751, 0, 1},
            {4.968021, 0, -2.787760, 0, 71.481094, 0, 18.574377, 0, 1},
            {4.386539, 0, -2.631336, 0, 59.968548, 0, 16.132710, 0, 1},
            {3.894264, 0, -2.479486, 0, 50.395161, 0, 14.031246, 0, 1},
            {3.490103, 0, -2.329895, 0, 42.329239, 0, 12.267620, 0, 1},
            {3.141735, 0, -2.188068, 0, 35.638969, 0, 10.725724, 0, 1},
            {2.859816, 0, -2.054062, 0, 29.993845, 0, 9.442187, 0, 1},
            {2.620349, 0, -1.926790, 0, 25.331533, 0, 8.325993, 0, 1},
            {2.398311, 0, -1.807517, 0, 21.489573, 0, 7.313870, 0, 1},
            {2.223137, 0, -1.695049, 0, 18.238173, 0, 6.476917, 0, 1},
            {2.072692, 0, -1.589814, 0, 15.523134, 0, 5.755404, 0, 1},
            {1.939087, 0, -1.491045, 0, 13.267519, 0, 5.116745, 0, 1},
            {1.822332, 0, -1.399625, 0, 11.394650, 0, 4.555825, 0, 1},
            {1.720811, 0, -1.314037, 0, 9.823386, 0, 4.068915, 0, 1},
            {1.630899, 0, -1.233317, 0, 8.492864, 0, 3.640526, 0, 1},
            {1.553843, 0, -1.157592, 0, 7.376961, 0, 3.268894, 0, 1},
            {1.490734, 0, -1.086639, 0, 6.433651, 0, 2.950307, 0, 1},
            {1.432929, 0, -1.020600, 0, 5.638104, 0, 2.666373, 0, 1},
            {1.374815, 0, -0.958737, 0, 4.965362, 0, 2.400652, 0, 1},
            {1.325165, 0, -0.900599, 0, 4.395979, 0, 2.171790, 0, 1},
            {1.286748, 0, -0.845554, 0, 3.904965, 0, 1.975697, 0, 1},
            {1.248133, 0, -0.793106, 0, 3.492160, 0, 1.791407, 0, 1},
            {1.209880, 0, -0.743433, 0, 3.133361, 0, 1.624267, 0, 1},
            {1.183988, 0, -0.696145, 0, 2.825088, 0, 1.484405, 0, 1},
            {1.150361, 0, -0.650712, 0, 2.563276, 0, 1.345073, 0, 1},
            {1.124895, 0, -0.607631, 0, 2.334976, 0, 1.225758, 0, 1},
            {1.100231, 0, -0.566001, 0, 2.137843, 0, 1.114179, 0, 1},
            {1.072962, 0, -0.526004, 0, 1.964423, 0, 1.008926, 0, 1},
            {1.053139, 0, -0.487676, 0, 1.813509, 0, 0.916973, 0, 1},
            {1.032387, 0, -0.452164, 0, 1.682570, 0, 0.831067, 0, 1},
            {1.013851, 0, -0.418111, 0, 1.567370, 0, 0.752596, 0, 1},
            {0.992847, 0, -0.385449, 0, 1.464371, 0, 0.677399, 0, 1},
            {0.973894, 0, -0.353736, 0, 1.374073, 0, 0.607277, 0, 1},
            {0.957402, 0, -0.323055, 0, 1.294103, 0, 0.544421, 0, 1},
            {0.937947, 0, -0.293166, 0, 1.222537, 0, 0.483155, 0, 1},
            {0.921176, 0, -0.264527, 0, 1.158591, 0, 0.427436, 0, 1},
            {0.902082, 0, -0.236924, 0, 1.099809, 0, 0.373552, 0, 1},
            {0.884630, 0, -0.209995, 0, 1.047710, 0, 0.324298, 0, 1},
            {0.864298, 0, -0.184017, 0, 0.996888, 0, 0.276542, 0, 1},
            {0.846630, 0, -0.158854, 0, 0.951949, 0, 0.233321, 0, 1},
            {0.829734, 0, -0.134642, 0, 0.912870, 0, 0.193677, 0, 1},
            {0.814766, 0, -0.111083, 0, 0.880362, 0, 0.158096, 0, 1},
            {0.800836, 0, -0.088186, 0, 0.852870, 0, 0.125093, 0, 1},
            {0.790942, 0, -0.065957, 0, 0.829340, 0, 0.093490, 0, 1},
            {0.783243, 0, -0.044794, 0, 0.808869, 0, 0.062261, 0, 1},
            {0.778025, 0, -0.023768, 0, 0.789909, 0, 0.031524, 0, 1},
            {0.773400, 0, -0.003255, 0, 0.772808, 0, 0.001599, 0, 1},
            {694.468201, 0, -4.380828, 0, 4493.511719, 0, 3042.534180, 0, 1},
            {694.468201, 0, -4.380828, 0, 4493.511719, 0, 3042.534180, 0, 1},
            {686.339905, 0, -4.380825, 0, 4493.509277, 0, 3006.936523, 0, 1},
            {219.687042, 0, -4.379368, 0, 4450.719238, 0, 962.460938, 0, 1},
            {123.969559, 0, -4.375468, 0, 2499.999512, 0, 543.001099, 0, 1},
            {79.169876, 0, -4.367267, 0, 1598.047729, 0, 346.772888, 0, 1},
            {54.884480, 0, -4.352409, 0, 1108.550537, 0, 239.909027, 0, 1},
            {40.191998, 0, -4.328050, 0, 804.701355, 0, 175.753632, 0, 1},
            {30.433971, 0, -4.284082, 0, 612.600952, 0, 133.125473, 0, 1},
            {23.807697, 0, -4.220432, 0, 478.025024, 0, 104.030556, 0, 1},
            {19.013176, 0, -4.146036, 0, 380.591400, 0, 82.960159, 0, 1},
            {15.426579, 0, -4.043351, 0, 307.380859, 0, 67.175621, 0, 1},
            {12.682364, 0, -3.929627, 0, 251.247421, 0, 55.071854, 0, 1},
            {10.536271, 0, -3.791160, 0, 206.838837, 0, 45.579884, 0, 1},
            {8.839734, 0, -3.634206, 0, 171.094849, 0, 38.043308, 0, 1},
            {7.486965, 0, -3.468320, 0, 142.060669, 0, 31.994062, 0, 1},
            {6.403177, 0, -3.292229, 0, 118.070328, 0, 27.104532, 0, 1},
            {5.523100, 0, -3.109759, 0, 98.170776, 0, 23.082695, 0, 1},
            {4.831917, 0, -2.924479, 0, 81.442329, 0, 19.855810, 0, 1},
            {4.250381, 0, -2.743827, 0, 67.674957, 0, 17.101507, 0, 1},
            {3.757152, 0, -2.567863, 0, 56.290527, 0, 14.737700, 0, 1},
            {3.377566, 0, -2.398841, 0, 46.732021, 0, 12.844433, 0, 1},
            {3.050572, 0, -2.241966, 0, 38.919209, 0, 11.195201, 0, 1},
            {2.758274, 0, -2.094188, 0, 32.562389, 0, 9.731255, 0, 1},
            {2.531044, 0, -1.957008, 0, 27.230253, 0, 8.550031, 0, 1},
            {2.327443, 0, -1.829026, 0, 22.900625, 0, 7.494730, 0, 1},
            {2.159161, 0, -1.710399, 0, 19.302103, 0, 6.611458, 0, 1},
            {2.012750, 0, -1.600246, 0, 16.353825, 0, 5.840732, 0, 1},
            {1.886550, 0, -1.498032, 0, 13.905995, 0, 5.174478, 0, 1},
            {1.774737, 0, -1.403907, 0, 11.876966, 0, 4.595283, 0, 1},
            {1.677102, 0, -1.316360, 0, 10.216613, 0, 4.087289, 0, 1},
            {1.596201, 0, -1.234255, 0, 8.792109, 0, 3.661887, 0, 1},
            {1.519374, 0, -1.157762, 0, 7.616532, 0, 3.275707, 0, 1},
            {1.452196, 0, -1.086439, 0, 6.628254, 0, 2.938795, 0, 1},
            {1.402205, 0, -1.019261, 0, 5.789808, 0, 2.661379, 0, 1},
            {1.351270, 0, -0.956486, 0, 5.087619, 0, 2.401204, 0, 1},
            {1.302528, 0, -0.898279, 0, 4.495908, 0, 2.165735, 0, 1},
            {1.267093, 0, -0.843252, 0, 3.985807, 0, 1.970988, 0, 1},
            {1.231524, 0, -0.791209, 0, 3.555437, 0, 1.790508, 0, 1},
            {1.194025, 0, -0.741673, 0, 3.186777, 0, 1.620665, 0, 1},
            {1.166682, 0, -0.694717, 0, 2.869368, 0, 1.477615, 0, 1},
            {1.136948, 0, -0.649811, 0, 2.600365, 0, 1.341036, 0, 1},
            {1.112716, 0, -0.606719, 0, 2.364336, 0, 1.221506, 0, 1},
            {1.089677, 0, -0.565527, 0, 2.159290, 0, 1.112482, 0, 1},
            {1.062996, 0, -0.526035, 0, 1.983256, 0, 1.005913, 0, 1},
            {1.044072, 0, -0.487913, 0, 1.828424, 0, 0.915047, 0, 1},
            {1.022682, 0, -0.451280, 0, 1.693817, 0, 0.828121, 0, 1},
            {1.003442, 0, -0.416265, 0, 1.574270, 0, 0.748060, 0, 1},
            {0.983337, 0, -0.382965, 0, 1.468847, 0, 0.673708, 0, 1},
            {0.964855, 0, -0.351174, 0, 1.375737, 0, 0.604308, 0, 1},
            {0.948558, 0, -0.320522, 0, 1.294130, 0, 0.540649, 0, 1},
            {0.928151, 0, -0.290747, 0, 1.219719, 0, 0.478833, 0, 1},
            {0.911260, 0, -0.261761, 0, 1.153626, 0, 0.422449, 0, 1},
            {0.892292, 0, -0.233490, 0, 1.092571, 0, 0.369654, 0, 1},
            {0.874949, 0, -0.206385, 0, 1.038161, 0, 0.319799, 0, 1},
            {0.855154, 0, -0.179844, 0, 0.987733, 0, 0.272366, 0, 1},
            {0.837398, 0, -0.153959, 0, 0.942935, 0, 0.229158, 0, 1},
            {0.819890, 0, -0.128660, 0, 0.902518, 0, 0.189735, 0, 1},
            {0.798486, 0, -0.104464, 0, 0.868445, 0, 0.153091, 0, 1},
            {0.784313, 0, -0.081117, 0, 0.841813, 0, 0.121025, 0, 1},
            {0.776996, 0, -0.058378, 0, 0.818920, 0, 0.089016, 0, 1},
            {0.773136, 0, -0.036213, 0, 0.799058, 0, 0.057511, 0, 1},
            {0.769063, 0, -0.014501, 0, 0.780764, 0, 0.026675, 0, 1},
            {0.764074, 0, 0.006566, 0, 0.763874, 0, -0.003352, 0, 1},
            {721.985046, 0, -4.946069, 0, 5046.145996, 0, 3571.211670, 0, 1},
            {721.985046, 0, -4.946069, 0, 5046.145996, 0, 3571.211670, 0, 1},
            {714.985718, 0, -4.946058, 0, 5046.135742, 0, 3536.660400, 0, 1},
            {232.125870, 0, -4.943971, 0, 5044.090820, 0, 1148.170532, 0, 1},
            {123.873604, 0, -4.938361, 0, 3149.807617, 0, 612.507385, 0, 1},
            {79.155502, 0, -4.926561, 0, 2012.432617, 0, 391.393158, 0, 1},
            {54.743370, 0, -4.905214, 0, 1391.310547, 0, 270.613251, 0, 1},
            {39.901684, 0, -4.869965, 0, 1014.800049, 0, 197.096710, 0, 1},
            {30.294024, 0, -4.799531, 0, 767.817200, 0, 149.533600, 0, 1},
            {23.608038, 0, -4.718091, 0, 597.033752, 0, 116.387131, 0, 1},
            {18.787228, 0, -4.611835, 0, 473.238251, 0, 92.445580, 0, 1},
            {15.179027, 0, -4.479045, 0, 380.186798, 0, 74.498795, 0, 1},
            {12.417994, 0, -4.319867, 0, 308.464142, 0, 60.725189, 0, 1},
            {10.276855, 0, -4.134665, 0, 251.735382, 0, 50.000065, 0, 1},
            {8.584215, 0, -3.934479, 0, 206.273911, 0, 41.477249, 0, 1},
            {7.247280, 0, -3.722689, 0, 169.325745, 0, 34.679852, 0, 1},
            {6.180845, 0, -3.501753, 0, 138.977737, 0, 29.194916, 0, 1},
            {5.320841, 0, -3.277736, 0, 113.964752, 0, 24.704174, 0, 1},
            {4.651779, 0, -3.059142, 0, 93.273788, 0, 21.118258, 0, 1},
            {4.087338, 0, -2.848116, 0, 76.500832, 0, 18.057499, 0, 1},
            {3.633870, 0, -2.645974, 0, 62.704197, 0, 15.535373, 0, 1},
            {3.239435, 0, -2.458408, 0, 51.632034, 0, 13.342704, 0, 1},
            {2.935870, 0, -2.284677, 0, 42.461651, 0, 11.585645, 0, 1},
            {2.668840, 0, -2.124792, 0, 35.115269, 0, 10.048407, 0, 1},
            {2.433447, 0, -1.977476, 0, 29.214821, 0, 8.716081, 0, 1},
            {2.237335, 0, -1.842107, 0, 24.375181, 0, 7.597365, 0, 1},
            {2.075590, 0, -1.718119, 0, 20.449934, 0, 6.658926, 0, 1},
            {1.938075, 0, -1.604022, 0, 17.212046, 0, 5.863555, 0, 1},
            {1.817005, 0, -1.499478, 0, 14.572831, 0, 5.173584, 0, 1},
            {1.716687, 0, -1.403249, 0, 12.395076, 0, 4.591091, 0, 1},
            {1.635633, 0, -1.314340, 0, 10.569445, 0, 4.104249, 0, 1},
            {1.553543, 0, -1.231609, 0, 9.085625, 0, 3.655235, 0, 1},
            {1.486551, 0, -1.154891, 0, 7.846591, 0, 3.274149, 0, 1},
            {1.421622, 0, -1.083487, 0, 6.813128, 0, 2.934341, 0, 1},
            {1.367418, 0, -1.016376, 0, 5.944501, 0, 2.640042, 0, 1},
            {1.324482, 0, -0.953508, 0, 5.207488, 0, 2.390431, 0, 1},
            {1.280684, 0, -0.894399, 0, 4.592789, 0, 2.159741, 0, 1},
            {1.246987, 0, -0.839518, 0, 4.062180, 0, 1.964467, 0, 1},
            {1.211155, 0, -0.788068, 0, 3.620679, 0, 1.781203, 0, 1},
            {1.175933, 0, -0.738902, 0, 3.243580, 0, 1.613270, 0, 1},
            {1.152336, 0, -0.692208, 0, 2.917040, 0, 1.473435, 0, 1},
            {1.123500, 0, -0.647835, 0, 2.636541, 0, 1.336179, 0, 1},
            {1.096555, 0, -0.605367, 0, 2.396568, 0, 1.213442, 0, 1},
            {1.077336, 0, -0.564784, 0, 2.185666, 0, 1.106037, 0, 1},
            {1.052653, 0, -0.525758, 0, 2.002713, 0, 1.003530, 0, 1},
            {1.031925, 0, -0.488138, 0, 1.844307, 0, 0.909873, 0, 1},
            {1.013942, 0, -0.451746, 0, 1.704971, 0, 0.825459, 0, 1},
            {0.991452, 0, -0.416619, 0, 1.584007, 0, 0.742975, 0, 1},
            {0.974240, 0, -0.382644, 0, 1.474510, 0, 0.669738, 0, 1},
            {0.955821, 0, -0.350143, 0, 1.378818, 0, 0.600725, 0, 1},
            {0.938912, 0, -0.318425, 0, 1.294800, 0, 0.536778, 0, 1},
            {0.919444, 0, -0.288514, 0, 1.217755, 0, 0.475350, 0, 1},
            {0.903474, 0, -0.259492, 0, 1.149861, 0, 0.419374, 0, 1},
            {0.883635, 0, -0.231227, 0, 1.084635, 0, 0.365386, 0, 1},
            {0.864503, 0, -0.203640, 0, 1.027821, 0, 0.314880, 0, 1},
            {0.842393, 0, -0.176839, 0, 0.973706, 0, 0.266845, 0, 1},
            {0.817137, 0, -0.150930, 0, 0.926544, 0, 0.221697, 0, 1},
            {0.800453, 0, -0.125641, 0, 0.889120, 0, 0.183984, 0, 1},
            {0.785820, 0, -0.100842, 0, 0.857413, 0, 0.149712, 0, 1},
            {0.774620, 0, -0.076499, 0, 0.831367, 0, 0.117321, 0, 1},
            {0.768187, 0, -0.052638, 0, 0.808870, 0, 0.085328, 0, 1},
            {0.763980, 0, -0.029531, 0, 0.789081, 0, 0.053670, 0, 1},
            {0.758869, 0, -0.007321, 0, 0.770790, 0, 0.022941, 0, 1},
            {0.753451, 0, 0.014465, 0, 0.753795, 0, -0.007314, 0, 1},
            {755.370728, 0, -5.670331, 0, 5757.834961, 0, 4283.786621, 0, 1},
            {755.370728, 0, -5.670331, 0, 5757.834961, 0, 4283.786621, 0, 1},
            {748.917786, 0, -5.670322, 0, 5757.825684, 0, 4247.178223, 0, 1},
            {246.101578, 0, -5.667177, 0, 5754.728027, 0, 1395.648438, 0, 1},
            {123.797058, 0, -5.658721, 0, 4106.577148, 0, 701.706238, 0, 1},
            {79.117386, 0, -5.640969, 0, 2618.795898, 0, 448.470886, 0, 1},
            {54.177662, 0, -5.608840, 0, 1834.666748, 0, 306.364075, 0, 1},
            {39.824734, 0, -5.550171, 0, 1313.560669, 0, 225.507919, 0, 1},
            {30.075279, 0, -5.454316, 0, 990.787842, 0, 170.092087, 0, 1},
            {23.337036, 0, -5.339839, 0, 767.091919, 0, 131.755875, 0, 1},
            {18.473637, 0, -5.178624, 0, 603.634888, 0, 104.043175, 0, 1},
            {14.846143, 0, -4.992064, 0, 481.186798, 0, 83.316429, 0, 1},
            {12.081261, 0, -4.772932, 0, 386.654968, 0, 67.461525, 0, 1},
            {9.940939, 0, -4.523968, 0, 311.820526, 0, 55.120632, 0, 1},
            {8.274117, 0, -4.262884, 0, 252.081955, 0, 45.424171, 0, 1},
            {6.964566, 0, -3.988830, 0, 203.697174, 0, 37.720623, 0, 1},
            {5.926566, 0, -3.710901, 0, 164.417938, 0, 31.508204, 0, 1},
            {5.129732, 0, -3.441426, 0, 132.342026, 0, 26.615784, 0, 1},
            {4.463659, 0, -3.182252, 0, 106.775970, 0, 22.479305, 0, 1},
            {3.902591, 0, -2.936867, 0, 86.341125, 0, 18.977882, 0, 1},
            {3.481073, 0, -2.709507, 0, 69.712631, 0, 16.245199, 0, 1},
            {3.118626, 0, -2.502808, 0, 56.590183, 0, 13.889335, 0, 1},
            {2.795513, 0, -2.314271, 0, 46.252998, 0, 11.844767, 0, 1},
            {2.551666, 0, -2.143013, 0, 37.847336, 0, 10.238197, 0, 1},
            {2.332592, 0, -1.987437, 0, 31.214708, 0, 8.834404, 0, 1},
            {2.155564, 0, -1.846117, 0, 25.844906, 0, 7.686929, 0, 1},
            {2.000643, 0, -1.717631, 0, 21.522562, 0, 6.701662, 0, 1},
            {1.870037, 0, -1.601066, 0, 18.046921, 0, 5.874063, 0, 1},
            {1.764007, 0, -1.494996, 0, 15.182642, 0, 5.187465, 0, 1},
            {1.663801, 0, -1.397578, 0, 12.871964, 0, 4.582635, 0, 1},
            {1.577190, 0, -1.307861, 0, 10.965149, 0, 4.061802, 0, 1},
            {1.504099, 0, -1.225326, 0, 9.397988, 0, 3.620734, 0, 1},
            {1.448169, 0, -1.148877, 0, 8.073087, 0, 3.255360, 0, 1},
            {1.392806, 0, -1.077689, 0, 6.986881, 0, 2.925269, 0, 1},
            {1.337830, 0, -1.011239, 0, 6.092653, 0, 2.623551, 0, 1},
            {1.297846, 0, -0.949130, 0, 5.329033, 0, 2.376188, 0, 1},
            {1.257372, 0, -0.890650, 0, 4.688469, 0, 2.146968, 0, 1},
            {1.217505, 0, -0.835359, 0, 4.149733, 0, 1.939995, 0, 1},
            {1.189010, 0, -0.783367, 0, 3.687076, 0, 1.766274, 0, 1},
            {1.158875, 0, -0.735030, 0, 3.302110, 0, 1.603226, 0, 1},
            {1.132490, 0, -0.689066, 0, 2.961678, 0, 1.460328, 0, 1},
            {1.107211, 0, -0.645352, 0, 2.676203, 0, 1.327499, 0, 1},
            {1.082764, 0, -0.603500, 0, 2.428947, 0, 1.207419, 0, 1},
            {1.065845, 0, -0.563333, 0, 2.212621, 0, 1.102937, 0, 1},
            {1.040707, 0, -0.524835, 0, 2.024522, 0, 0.998398, 0, 1},
            {1.020347, 0, -0.487784, 0, 1.860953, 0, 0.904858, 0, 1},
            {1.004311, 0, -0.452053, 0, 1.719984, 0, 0.821416, 0, 1},
            {0.982813, 0, -0.417382, 0, 1.592310, 0, 0.740940, 0, 1},
            {0.965647, 0, -0.383810, 0, 1.479896, 0, 0.668034, 0, 1},
            {0.946957, 0, -0.351144, 0, 1.380211, 0, 0.598401, 0, 1},
            {0.932339, 0, -0.319366, 0, 1.292450, 0, 0.535861, 0, 1},
            {0.911615, 0, -0.288792, 0, 1.213322, 0, 0.473632, 0, 1},
            {0.890619, 0, -0.259176, 0, 1.141411, 0, 0.415295, 0, 1},
            {0.871610, 0, -0.230179, 0, 1.077082, 0, 0.360902, 0, 1},
            {0.846984, 0, -0.202470, 0, 1.018013, 0, 0.307360, 0, 1},
            {0.825227, 0, -0.175689, 0, 0.963117, 0, 0.260213, 0, 1},
            {0.807204, 0, -0.149474, 0, 0.917321, 0, 0.218667, 0, 1},
            {0.791875, 0, -0.123761, 0, 0.879613, 0, 0.181071, 0, 1},
            {0.777142, 0, -0.098633, 0, 0.847924, 0, 0.147021, 0, 1},
            {0.765843, 0, -0.074229, 0, 0.821091, 0, 0.114883, 0, 1},
            {0.759266, 0, -0.050208, 0, 0.798548, 0, 0.082969, 0, 1},
            {0.753952, 0, -0.026592, 0, 0.778596, 0, 0.051373, 0, 1},
            {0.748278, 0, -0.003300, 0, 0.759784, 0, 0.020496, 0, 1},
            {0.741943, 0, 0.019648, 0, 0.742779, 0, -0.010106, 0, 1},
            {796.538452, 0, -6.633092, 0, 6708.047852, 0, 5284.574219, 0, 1},
            {796.538452, 0, -6.633092, 0, 6708.047852, 0, 5284.574219, 0, 1},
            {788.692444, 0, -6.633066, 0, 6708.022949, 0, 5232.681641, 0, 1},
            {254.366989, 0, -6.628033, 0, 6703.046387, 0, 1687.155640, 0, 1},
            {124.024818, 0, -6.614511, 0, 5539.862305, 0, 822.532288, 0, 1},
            {78.874611, 0, -6.586137, 0, 3570.532227, 0, 522.773438, 0, 1},
            {54.351654, 0, -6.534547, 0, 2444.145508, 0, 360.170929, 0, 1},
            {39.671909, 0, -6.425985, 0, 1757.696289, 0, 262.640015, 0, 1},
            {29.720913, 0, -6.296362, 0, 1330.735718, 0, 196.392914, 0, 1},
            {22.937927, 0, -6.109432, 0, 1019.533630, 0, 151.242661, 0, 1},
            {18.037071, 0, -5.883490, 0, 795.384338, 0, 118.512108, 0, 1},
            {14.389929, 0, -5.610622, 0, 626.799988, 0, 94.074753, 0, 1},
            {11.632060, 0, -5.292922, 0, 496.057587, 0, 75.492020, 0, 1},
            {9.524698, 0, -4.959748, 0, 393.665619, 0, 61.165596, 0, 1},
            {7.909891, 0, -4.608510, 0, 311.850403, 0, 50.033722, 0, 1},
            {6.641108, 0, -4.254182, 0, 246.801361, 0, 41.161034, 0, 1},
            {5.640098, 0, -3.911447, 0, 195.188507, 0, 34.034492, 0, 1},
            {4.876927, 0, -3.585286, 0, 154.037003, 0, 28.450592, 0, 1},
            {4.234858, 0, -3.282091, 0, 122.015228, 0, 23.740337, 0, 1},
            {3.706480, 0, -3.003709, 0, 97.047188, 0, 19.848419, 0, 1},
            {3.294509, 0, -2.752968, 0, 77.346321, 0, 16.757662, 0, 1},
            {2.949829, 0, -2.528190, 0, 61.985443, 0, 14.190195, 0, 1},
            {2.673619, 0, -2.326734, 0, 49.983765, 0, 12.108070, 0, 1},
            {2.421091, 0, -2.146376, 0, 40.643520, 0, 10.310018, 0, 1},
            {2.225844, 0, -1.984520, 0, 33.203148, 0, 8.879506, 0, 1},
            {2.050815, 0, -1.839347, 0, 27.348070, 0, 7.653798, 0, 1},
            {1.915180, 0, -1.708621, 0, 22.628241, 0, 6.671260, 0, 1},
            {1.794598, 0, -1.590899, 0, 18.848253, 0, 5.830236, 0, 1},
            {1.699217, 0, -1.484087, 0, 15.794706, 0, 5.150298, 0, 1},
            {1.607506, 0, -1.386482, 0, 13.345618, 0, 4.539809, 0, 1},
            {1.534696, 0, -1.297261, 0, 11.314983, 0, 4.041388, 0, 1},
            {1.463587, 0, -1.215437, 0, 9.669380, 0, 3.594791, 0, 1},
            {1.402722, 0, -1.139554, 0, 8.306990, 0, 3.209846, 0, 1},
            {1.355394, 0, -1.069360, 0, 7.170519, 0, 2.892212, 0, 1},
            {1.308239, 0, -1.003819, 0, 6.241129, 0, 2.599499, 0, 1},
            {1.265107, 0, -0.942460, 0, 5.446612, 0, 2.343331, 0, 1},
            {1.236631, 0, -0.885105, 0, 4.786221, 0, 2.134352, 0, 1},
            {1.197268, 0, -0.830972, 0, 4.235952, 0, 1.925134, 0, 1},
            {1.168772, 0, -0.779904, 0, 3.763372, 0, 1.750235, 0, 1},
            {1.140084, 0, -0.731363, 0, 3.362856, 0, 1.589927, 0, 1},
            {1.112856, 0, -0.685110, 0, 3.016409, 0, 1.443964, 0, 1},
            {1.093076, 0, -0.641937, 0, 2.718378, 0, 1.320131, 0, 1},
            {1.066269, 0, -0.600802, 0, 2.463474, 0, 1.196558, 0, 1},
            {1.052001, 0, -0.561395, 0, 2.240675, 0, 1.096340, 0, 1},
            {1.029387, 0, -0.523471, 0, 2.047421, 0, 0.993331, 0, 1},
            {1.010490, 0, -0.486986, 0, 1.876320, 0, 0.902016, 0, 1},
            {0.994934, 0, -0.451763, 0, 1.730797, 0, 0.819587, 0, 1},
            {0.974489, 0, -0.417763, 0, 1.599287, 0, 0.739916, 0, 1},
            {0.957656, 0, -0.384869, 0, 1.485222, 0, 0.666863, 0, 1},
            {0.939151, 0, -0.352948, 0, 1.383958, 0, 0.597341, 0, 1},
            {0.919569, 0, -0.321905, 0, 1.292059, 0, 0.532299, 0, 1},
            {0.903610, 0, -0.291601, 0, 1.213007, 0, 0.473077, 0, 1},
            {0.878530, 0, -0.261976, 0, 1.137926, 0, 0.410832, 0, 1},
            {0.859335, 0, -0.232993, 0, 1.072206, 0, 0.356913, 0, 1},
            {0.840088, 0, -0.204911, 0, 1.012177, 0, 0.306912, 0, 1},
            {0.817539, 0, -0.177521, 0, 0.955910, 0, 0.259635, 0, 1},
            {0.799748, 0, -0.150580, 0, 0.909657, 0, 0.217919, 0, 1},
            {0.783867, 0, -0.124083, 0, 0.870853, 0, 0.180178, 0, 1},
            {0.768642, 0, -0.098486, 0, 0.838291, 0, 0.145685, 0, 1},
            {0.756833, 0, -0.073751, 0, 0.810957, 0, 0.113385, 0, 1},
            {0.749698, 0, -0.049360, 0, 0.787669, 0, 0.081632, 0, 1},
            {0.743499, 0, -0.025327, 0, 0.767074, 0, 0.050162, 0, 1},
            {0.736850, 0, -0.001874, 0, 0.748055, 0, 0.019200, 0, 1},
            {0.730256, 0, 0.021175, 0, 0.730499, 0, -0.010886, 0, 1},
            {845.146118, 0, -7.977318, 0, 8039.750000, 0, 6744.384766, 0, 1},
            {845.146118, 0, -7.977318, 0, 8039.750000, 0, 6744.384766, 0, 1},
            {835.189026, 0, -7.977277, 0, 8039.710449, 0, 6664.471191, 0, 1},
            {281.098541, 0, -7.968528, 0, 8031.028809, 0, 2242.864746, 0, 1},
            {123.405190, 0, -7.945025, 0, 8007.711426, 0, 984.388428, 0, 1},
            {78.691490, 0, -7.895733, 0, 5077.497559, 0, 627.326538, 0, 1},
            {54.058727, 0, -7.791619, 0, 3485.158447, 0, 430.624695, 0, 1},
            {39.050835, 0, -7.625182, 0, 2508.681885, 0, 310.617584, 0, 1},
            {28.780594, 0, -7.403747, 0, 1883.278564, 0, 228.130203, 0, 1},
            {22.431581, 0, -7.116580, 0, 1415.168823, 0, 177.351303, 0, 1},
            {17.398540, 0, -6.757731, 0, 1089.876953, 0, 136.846085, 0, 1},
            {13.759562, 0, -6.336405, 0, 842.622314, 0, 107.378319, 0, 1},
            {11.054308, 0, -5.889235, 0, 653.017090, 0, 85.240372, 0, 1},
            {9.015944, 0, -5.419374, 0, 504.942902, 0, 68.333931, 0, 1},
            {7.456490, 0, -4.949159, 0, 389.530151, 0, 55.183376, 0, 1},
            {6.251395, 0, -4.500382, 0, 300.270569, 0, 44.822029, 0, 1},
            {5.308335, 0, -4.078912, 0, 231.511444, 0, 36.583969, 0, 1},
            {4.555330, 0, -3.694615, 0, 178.991898, 0, 29.968136, 0, 1},
            {3.972212, 0, -3.347843, 0, 138.743637, 0, 24.783125, 0, 1},
            {3.497174, 0, -3.039443, 0, 108.196671, 0, 20.568523, 0, 1},
            {3.085307, 0, -2.768964, 0, 85.297348, 0, 17.046770, 0, 1},
            {2.774531, 0, -2.530205, 0, 67.433861, 0, 14.344564, 0, 1},
            {2.505141, 0, -2.319404, 0, 53.952549, 0, 12.078911, 0, 1},
            {2.290914, 0, -2.133185, 0, 43.374359, 0, 10.289063, 0, 1},
            {2.109684, 0, -1.968301, 0, 35.174217, 0, 8.813835, 0, 1},
            {1.955441, 0, -1.821365, 0, 28.774702, 0, 7.586822, 0, 1},
            {1.824226, 0, -1.690827, 0, 23.718933, 0, 6.580121, 0, 1},
            {1.722245, 0, -1.573141, 0, 19.618530, 0, 5.767525, 0, 1},
            {1.623407, 0, -1.466886, 0, 16.415415, 0, 5.050951, 0, 1},
            {1.544118, 0, -1.370359, 0, 13.800963, 0, 4.461748, 0, 1},
            {1.480333, 0, -1.282609, 0, 11.673009, 0, 3.974541, 0, 1},
            {1.420210, 0, -1.201725, 0, 9.939965, 0, 3.546500, 0, 1},
            {1.363331, 0, -1.127192, 0, 8.527099, 0, 3.165497, 0, 1},
            {1.319575, 0, -1.058344, 0, 7.354059, 0, 2.850984, 0, 1},
            {1.278847, 0, -0.994206, 0, 6.383086, 0, 2.572156, 0, 1},
            {1.236565, 0, -0.934412, 0, 5.585329, 0, 2.311474, 0, 1},
            {1.207651, 0, -0.878088, 0, 4.897930, 0, 2.104635, 0, 1},
            {1.175019, 0, -0.825141, 0, 4.323633, 0, 1.906726, 0, 1},
            {1.150577, 0, -0.775119, 0, 3.832266, 0, 1.739005, 0, 1},
            {1.122119, 0, -0.727749, 0, 3.422934, 0, 1.578306, 0, 1},
            {1.093680, 0, -0.682578, 0, 3.074646, 0, 1.429569, 0, 1},
            {1.077174, 0, -0.639512, 0, 2.766084, 0, 1.310087, 0, 1},
            {1.052574, 0, -0.598284, 0, 2.504311, 0, 1.187682, 0, 1},
            {1.034594, 0, -0.558858, 0, 2.275589, 0, 1.083231, 0, 1},
            {1.014468, 0, -0.521607, 0, 2.075143, 0, 0.984314, 0, 1},
            {0.995375, 0, -0.486011, 0, 1.901797, 0, 0.894436, 0, 1},
            {0.982971, 0, -0.451649, 0, 1.749210, 0, 0.816267, 0, 1},
            {0.963105, 0, -0.418406, 0, 1.615647, 0, 0.735724, 0, 1},
            {0.948792, 0, -0.386159, 0, 1.495226, 0, 0.666280, 0, 1},
            {0.926610, 0, -0.354891, 0, 1.391581, 0, 0.593153, 0, 1},
            {0.907713, 0, -0.324492, 0, 1.297812, 0, 0.527906, 0, 1},
            {0.892103, 0, -0.294840, 0, 1.215060, 0, 0.469247, 0, 1},
            {0.869415, 0, -0.265860, 0, 1.136338, 0, 0.410502, 0, 1},
            {0.852913, 0, -0.237496, 0, 1.068437, 0, 0.358726, 0, 1},
            {0.834536, 0, -0.209674, 0, 1.007072, 0, 0.308860, 0, 1},
            {0.811033, 0, -0.182364, 0, 0.948978, 0, 0.260958, 0, 1},
            {0.791168, 0, -0.155507, 0, 0.900506, 0, 0.218397, 0, 1},
            {0.775269, 0, -0.129110, 0, 0.861032, 0, 0.180906, 0, 1},
            {0.760805, 0, -0.103290, 0, 0.828452, 0, 0.146492, 0, 1},
            {0.747453, 0, -0.078003, 0, 0.799894, 0, 0.114311, 0, 1},
            {0.739498, 0, -0.053023, 0, 0.776211, 0, 0.082466, 0, 1},
            {0.731962, 0, -0.028297, 0, 0.754456, 0, 0.050896, 0, 1},
            {0.724600, 0, -0.003833, 0, 0.734939, 0, 0.020031, 0, 1},
            {0.717370, 0, 0.020161, 0, 0.717078, 0, -0.010468, 0, 1},
            {906.439392, 0, -9.988728, 0, 10038.660156, 0, 9060.019531, 0, 1},
            {906.439392, 0, -9.988728, 0, 10038.660156, 0, 9060.019531, 0, 1},
            {896.722473, 0, -9.988659, 0, 10038.589844, 0, 8960.477539, 0, 1},
            {304.300293, 0, -9.971466, 0, 10021.482422, 0, 3038.479248, 0, 1},
            {135.957443, 0, -9.925411, 0, 9975.659180, 0, 1357.243042, 0, 1},
            {78.026291, 0, -9.828078, 0, 7876.573730, 0, 778.600769, 0, 1},
            {53.712955, 0, -9.617829, 0, 5350.844238, 0, 535.068176, 0, 1},
            {38.286682, 0, -9.333091, 0, 3821.416992, 0, 380.668152, 0, 1},
            {28.837351, 0, -8.931132, 0, 2776.563721, 0, 285.601776, 0, 1},
            {21.382069, 0, -8.424834, 0, 2087.045654, 0, 210.541641, 0, 1},
            {16.448494, 0, -7.826952, 0, 1564.820190, 0, 160.475967, 0, 1},
            {12.875075, 0, -7.180136, 0, 1174.784180, 0, 123.837555, 0, 1},
            {10.294890, 0, -6.514475, 0, 878.429626, 0, 96.924232, 0, 1},
            {8.364246, 0, -5.860951, 0, 655.093750, 0, 76.379807, 0, 1},
            {6.896718, 0, -5.246315, 0, 487.947388, 0, 60.519421, 0, 1},
            {5.768393, 0, -4.686076, 0, 364.209167, 0, 48.198494, 0, 1},
            {4.898552, 0, -4.185898, 0, 272.602905, 0, 38.672321, 0, 1},
            {4.209528, 0, -3.746351, 0, 205.600281, 0, 31.163448, 0, 1},
            {3.670874, 0, -3.365174, 0, 156.234818, 0, 25.370182, 0, 1},
            {3.232810, 0, -3.036278, 0, 119.865585, 0, 20.767403, 0, 1},
            {2.862235, 0, -2.751556, 0, 93.030350, 0, 17.048080, 0, 1},
            {2.571143, 0, -2.504743, 0, 72.933678, 0, 14.185691, 0, 1},
            {2.338569, 0, -2.290083, 0, 57.715157, 0, 11.917953, 0, 1},
            {2.142554, 0, -2.102626, 0, 46.087078, 0, 10.092039, 0, 1},
            {1.980509, 0, -1.937902, 0, 37.124104, 0, 8.610742, 0, 1},
            {1.848721, 0, -1.792767, 0, 30.175062, 0, 7.427349, 0, 1},
            {1.729413, 0, -1.663505, 0, 24.773699, 0, 6.417544, 0, 1},
            {1.643981, 0, -1.547935, 0, 20.372276, 0, 5.646828, 0, 1},
            {1.557670, 0, -1.443718, 0, 16.987263, 0, 4.954495, 0, 1},
            {1.488696, 0, -1.349465, 0, 14.220825, 0, 4.386989, 0, 1},
            {1.422584, 0, -1.263479, 0, 12.027329, 0, 3.887997, 0, 1},
            {1.372155, 0, -1.184875, 0, 10.213785, 0, 3.477706, 0, 1},
            {1.323880, 0, -1.112276, 0, 8.750161, 0, 3.116966, 0, 1},
            {1.281696, 0, -1.045049, 0, 7.540591, 0, 2.802569, 0, 1},
            {1.243254, 0, -0.982565, 0, 6.547980, 0, 2.525293, 0, 1},
            {1.206903, 0, -0.924224, 0, 5.716578, 0, 2.280795, 0, 1},
            {1.178057, 0, -0.869383, 0, 5.011660, 0, 2.069224, 0, 1},
            {1.151483, 0, -0.817765, 0, 4.425074, 0, 1.881721, 0, 1},
            {1.120193, 0, -0.768990, 0, 3.927121, 0, 1.703048, 0, 1},
            {1.098377, 0, -0.722899, 0, 3.503269, 0, 1.553067, 0, 1},
            {1.075574, 0, -0.679074, 0, 3.139438, 0, 1.413851, 0, 1},
            {1.058857, 0, -0.637342, 0, 2.823851, 0, 1.295056, 0, 1},
            {1.036178, 0, -0.597396, 0, 2.551916, 0, 1.176856, 0, 1},
            {1.022086, 0, -0.559055, 0, 2.316213, 0, 1.078076, 0, 1},
            {1.004328, 0, -0.522252, 0, 2.110385, 0, 0.981383, 0, 1},
            {0.980973, 0, -0.486794, 0, 1.931046, 0, 0.887075, 0, 1},
            {0.969568, 0, -0.452552, 0, 1.772196, 0, 0.810623, 0, 1},
            {0.951322, 0, -0.419358, 0, 1.634960, 0, 0.732065, 0, 1},
            {0.935125, 0, -0.387447, 0, 1.510649, 0, 0.660078, 0, 1},
            {0.914376, 0, -0.356842, 0, 1.400242, 0, 0.590169, 0, 1},
            {0.900328, 0, -0.327078, 0, 1.303935, 0, 0.529932, 0, 1},
            {0.885727, 0, -0.298086, 0, 1.218222, 0, 0.471886, 0, 1},
            {0.862652, 0, -0.269809, 0, 1.135611, 0, 0.413001, 0, 1},
            {0.846136, 0, -0.242122, 0, 1.065906, 0, 0.361114, 0, 1},
            {0.829365, 0, -0.215009, 0, 1.002608, 0, 0.311811, 0, 1},
            {0.804026, 0, -0.188377, 0, 0.941965, 0, 0.263681, 0, 1},
            {0.782924, 0, -0.162206, 0, 0.891738, 0, 0.221028, 0, 1},
            {0.766848, 0, -0.136437, 0, 0.851588, 0, 0.183283, 0, 1},
            {0.751721, 0, -0.111023, 0, 0.817718, 0, 0.148957, 0, 1},
            {0.737474, 0, -0.085955, 0, 0.788427, 0, 0.117159, 0, 1},
            {0.727614, 0, -0.061166, 0, 0.763491, 0, 0.085510, 0, 1},
            {0.719368, 0, -0.036628, 0, 0.740881, 0, 0.054307, 0, 1},
            {0.711084, 0, -0.012337, 0, 0.720461, 0, 0.023948, 0, 1},
            {0.702920, 0, 0.011765, 0, 0.702302, 0, -0.006149, 0, 1},
            {998.483765, 0, -13.333044, 0, 13370.491211, 0, 13333.158203, 0, 1},
            {998.483765, 0, -13.333044, 0, 13370.491211, 0, 13333.158203, 0, 1},
            {998.551636, 0, -13.332921, 0, 13370.369141, 0, 13333.028320, 0, 1},
            {333.518036, 0, -13.292059, 0, 13329.624023, 0, 4440.960449, 0, 1},
            {152.949051, 0, -13.182705, 0, 13220.579102, 0, 2038.156982, 0, 1},
            {81.445961, 0, -12.905185, 0, 12943.871094, 0, 1075.949829, 0, 1},
            {52.685406, 0, -12.495064, 0, 9238.716797, 0, 688.496521, 0, 1},
            {36.778500, 0, -11.867575, 0, 6461.258301, 0, 486.234314, 0, 1},
            {26.697067, 0, -11.059551, 0, 4604.681152, 0, 350.370178, 0, 1},
            {19.892454, 0, -10.101795, 0, 3292.892090, 0, 258.057037, 0, 1},
            {15.110569, 0, -9.079334, 0, 2360.091064, 0, 192.029236, 0, 1},
            {11.722652, 0, -8.046182, 0, 1682.049927, 0, 144.493683, 0, 1},
            {9.317204, 0, -7.075084, 0, 1193.297241, 0, 110.032280, 0, 1},
            {7.530802, 0, -6.194766, 0, 848.054138, 0, 84.183929, 0, 1},
            {6.241379, 0, -5.422619, 0, 603.452820, 0, 65.286018, 0, 1},
            {5.206351, 0, -4.759813, 0, 434.533142, 0, 50.620579, 0, 1},
            {4.434587, 0, -4.196141, 0, 315.658630, 0, 39.794804, 0, 1},
            {3.797335, 0, -3.722212, 0, 233.010849, 0, 31.377222, 0, 1},
            {3.310014, 0, -3.322509, 0, 173.897430, 0, 25.083139, 0, 1},
            {2.936420, 0, -2.984247, 0, 131.499344, 0, 20.375296, 0, 1},
            {2.630209, 0, -2.696600, 0, 100.757813, 0, 16.706327, 0, 1},
            {2.380113, 0, -2.450179, 0, 78.039215, 0, 13.848163, 0, 1},
            {2.157723, 0, -2.238436, 0, 61.371338, 0, 11.512774, 0, 1},
            {2.007470, 0, -2.054964, 0, 48.493896, 0, 9.821982, 0, 1},
            {1.867061, 0, -1.894419, 0, 38.807777, 0, 8.390295, 0, 1},
            {1.746883, 0, -1.752979, 0, 31.355574, 0, 7.218071, 0, 1},
            {1.647169, 0, -1.627822, 0, 25.627239, 0, 6.269635, 0, 1},
            {1.564148, 0, -1.515979, 0, 21.054731, 0, 5.493749, 0, 1},
            {1.494478, 0, -1.415249, 0, 17.477192, 0, 4.845518, 0, 1},
            {1.428326, 0, -1.323985, 0, 14.654338, 0, 4.279845, 0, 1},
            {1.369799, 0, -1.240867, 0, 12.368030, 0, 3.800760, 0, 1},
            {1.317991, 0, -1.164637, 0, 10.531270, 0, 3.383482, 0, 1},
            {1.276579, 0, -1.094296, 0, 9.003316, 0, 3.036331, 0, 1},
            {1.238669, 0, -1.029195, 0, 7.764783, 0, 2.734841, 0, 1},
            {1.204133, 0, -0.968769, 0, 6.746184, 0, 2.467308, 0, 1},
            {1.171257, 0, -0.912329, 0, 5.892015, 0, 2.227766, 0, 1},
            {1.141953, 0, -0.859412, 0, 5.166983, 0, 2.020631, 0, 1},
            {1.119480, 0, -0.809528, 0, 4.559603, 0, 1.838840, 0, 1},
            {1.091946, 0, -0.762381, 0, 4.042816, 0, 1.668872, 0, 1},
            {1.076758, 0, -0.717771, 0, 3.603195, 0, 1.529597, 0, 1},
            {1.053507, 0, -0.675306, 0, 3.222058, 0, 1.392012, 0, 1},
            {1.029980, 0, -0.634791, 0, 2.897578, 0, 1.264203, 0, 1},
            {1.020478, 0, -0.596030, 0, 2.609970, 0, 1.164827, 0, 1},
            {0.998523, 0, -0.558837, 0, 2.366715, 0, 1.059033, 0, 1},
            {0.988348, 0, -0.523123, 0, 2.150631, 0, 0.971995, 0, 1},
            {0.969123, 0, -0.488738, 0, 1.963932, 0, 0.883356, 0, 1},
            {0.954624, 0, -0.455531, 0, 1.800147, 0, 0.804052, 0, 1},
            {0.941420, 0, -0.423373, 0, 1.655541, 0, 0.731793, 0, 1},
            {0.923654, 0, -0.392182, 0, 1.525702, 0, 0.660430, 0, 1},
            {0.907187, 0, -0.361855, 0, 1.412402, 0, 0.593770, 0, 1},
            {0.891124, 0, -0.332323, 0, 1.310456, 0, 0.532708, 0, 1},
            {0.873500, 0, -0.303496, 0, 1.218038, 0, 0.473138, 0, 1},
            {0.857091, 0, -0.275330, 0, 1.138666, 0, 0.418062, 0, 1},
            {0.832424, 0, -0.247736, 0, 1.059338, 0, 0.361886, 0, 1},
            {0.814533, 0, -0.220684, 0, 0.993187, 0, 0.312974, 0, 1},
            {0.797868, 0, -0.194567, 0, 0.935784, 0, 0.267691, 0, 1},
            {0.774203, 0, -0.169058, 0, 0.882685, 0, 0.224154, 0, 1},
            {0.759330, 0, -0.143976, 0, 0.842071, 0, 0.186639, 0, 1},
            {0.744530, 0, -0.119264, 0, 0.807175, 0, 0.152273, 0, 1},
            {0.727192, 0, -0.094892, 0, 0.775597, 0, 0.119979, 0, 1},
            {0.715008, 0, -0.070835, 0, 0.749520, 0, 0.089518, 0, 1},
            {0.705109, 0, -0.047042, 0, 0.725758, 0, 0.059135, 0, 1},
            {0.695260, 0, -0.023482, 0, 0.704104, 0, 0.029348, 0, 1},
            {0.685708, 0, -0.000131, 0, 0.684713, 0, 0.000322, 0, 1},
            {998.305664, 0, -20.000895, 0, 20025.880859, 0, 20000.980469, 0, 1},
            {998.305664, 0, -20.000895, 0, 20025.880859, 0, 20000.980469, 0, 1},
            {998.172546, 0, -20.000353, 0, 20025.337891, 0, 20000.443359, 0, 1},
            {378.913116, 0, -19.862547, 0, 19887.705078, 0, 7549.223145, 0, 1},
            {173.887909, 0, -19.426416, 0, 19452.136719, 0, 3437.047363, 0, 1},
            {91.336052, 0, -18.647791, 0, 18674.585938, 0, 1823.601807, 0, 1},
            {51.090645, 0, -17.419607, 0, 17448.287109, 0, 1016.308838, 0, 1},
            {34.765503, 0, -15.781409, 0, 12609.438477, 0, 641.824646, 0, 1},
            {22.935726, 0, -13.923059, 0, 8201.116211, 0, 439.613495, 0, 1},
            {17.374336, 0, -12.009401, 0, 5580.807129, 0, 321.256165, 0, 1},
            {13.162230, 0, -10.229010, 0, 3661.013672, 0, 230.669128, 0, 1},
            {10.154156, 0, -8.664251, 0, 2402.113770, 0, 165.740784, 0, 1},
            {8.055133, 0, -7.347579, 0, 1588.059937, 0, 120.749664, 0, 1},
            {6.493501, 0, -6.264519, 0, 1066.951294, 0, 88.587204, 0, 1},
            {5.356596, 0, -5.382983, 0, 728.006592, 0, 66.117699, 0, 1},
            {4.484689, 0, -4.668671, 0, 507.806549, 0, 49.950119, 0, 1},
            {3.836012, 0, -4.085837, 0, 360.194397, 0, 38.486553, 0, 1},
            {3.339977, 0, -3.607764, 0, 259.826752, 0, 30.185396, 0, 1},
            {2.933768, 0, -3.212286, 0, 190.955856, 0, 23.957863, 0, 1},
            {2.625576, 0, -2.882353, 0, 142.308273, 0, 19.377966, 0, 1},
            {2.377281, 0, -2.604426, 0, 107.424568, 0, 15.909470, 0, 1},
            {2.172325, 0, -2.368577, 0, 82.501915, 0, 13.208935, 0, 1},
            {2.011713, 0, -2.166433, 0, 64.119171, 0, 11.131875, 0, 1},
            {1.863040, 0, -1.991312, 0, 50.531494, 0, 9.415673, 0, 1},
            {1.737537, 0, -1.838462, 0, 40.393814, 0, 8.039965, 0, 1},
            {1.633933, 0, -1.703898, 0, 32.603786, 0, 6.932382, 0, 1},
            {1.554610, 0, -1.584310, 0, 26.532118, 0, 6.046955, 0, 1},
            {1.475402, 0, -1.477418, 0, 21.890182, 0, 5.280934, 0, 1},
            {1.406395, 0, -1.381327, 0, 18.212904, 0, 4.635618, 0, 1},
            {1.350537, 0, -1.294286, 0, 15.260345, 0, 4.104113, 0, 1},
            {1.304659, 0, -1.214812, 0, 12.874681, 0, 3.658871, 0, 1},
            {1.258044, 0, -1.141865, 0, 10.956322, 0, 3.263624, 0, 1},
            {1.214879, 0, -1.074652, 0, 9.396078, 0, 2.919321, 0, 1},
            {1.186597, 0, -1.012289, 0, 8.089111, 0, 2.639096, 0, 1},
            {1.153076, 0, -0.954190, 0, 7.022493, 0, 2.378364, 0, 1},
            {1.128181, 0, -0.899823, 0, 6.120345, 0, 2.159361, 0, 1},
            {1.105751, 0, -0.848775, 0, 5.361947, 0, 1.966318, 0, 1},
            {1.084143, 0, -0.800726, 0, 4.716421, 0, 1.791840, 0, 1},
            {1.062140, 0, -0.755278, 0, 4.180991, 0, 1.631325, 0, 1},
            {1.041897, 0, -0.712143, 0, 3.718901, 0, 1.488189, 0, 1},
            {1.028538, 0, -0.671095, 0, 3.320058, 0, 1.365576, 0, 1},
            {1.012829, 0, -0.631921, 0, 2.973172, 0, 1.251476, 0, 1},
            {1.000671, 0, -0.594426, 0, 2.679246, 0, 1.150313, 0, 1},
            {0.979573, 0, -0.558470, 0, 2.421418, 0, 1.046061, 0, 1},
            {0.971715, 0, -0.523884, 0, 2.194597, 0, 0.964354, 0, 1},
            {0.955829, 0, -0.490565, 0, 2.001263, 0, 0.879904, 0, 1},
            {0.935232, 0, -0.458370, 0, 1.826279, 0, 0.796294, 0, 1},
            {0.936694, 0, -0.427225, 0, 1.679218, 0, 0.738003, 0, 1},
            {0.913400, 0, -0.397028, 0, 1.541822, 0, 0.662934, 0, 1},
            {0.903221, 0, -0.367699, 0, 1.424504, 0, 0.602501, 0, 1},
            {0.880391, 0, -0.339149, 0, 1.317439, 0, 0.536449, 0, 1},
            {0.862923, 0, -0.311303, 0, 1.221370, 0, 0.477796, 0, 1},
            {0.850968, 0, -0.284116, 0, 1.138954, 0, 0.426038, 0, 1},
            {0.826887, 0, -0.257515, 0, 1.057532, 0, 0.370011, 0, 1},
            {0.812749, 0, -0.231445, 0, 0.992746, 0, 0.322627, 0, 1},
            {0.795176, 0, -0.205869, 0, 0.933137, 0, 0.276691, 0, 1},
            {0.764240, 0, -0.180738, 0, 0.872033, 0, 0.230579, 0, 1},
            {0.746094, 0, -0.156005, 0, 0.828593, 0, 0.192347, 0, 1},
            {0.731032, 0, -0.131632, 0, 0.792854, 0, 0.157679, 0, 1},
            {0.715943, 0, -0.107589, 0, 0.761541, 0, 0.125760, 0, 1},
            {0.700419, 0, -0.083846, 0, 0.732819, 0, 0.095441, 0, 1},
            {0.688468, 0, -0.060364, 0, 0.707722, 0, 0.065242, 0, 1},
            {0.676600, 0, -0.037115, 0, 0.684819, 0, 0.036227, 0, 1},
            {0.665275, 0, -0.014072, 0, 0.664032, 0, 0.007569, 0, 1},
            {994.893127, 0, -39.820560, 0, 39833.109375, 0, 39820.683594, 0, 1},
            {994.893127, 0, -39.820560, 0, 39833.109375, 0, 39820.683594, 0, 1},
            {994.406372, 0, -39.816357, 0, 39828.910156, 0, 39816.492188, 0, 1},
            {483.708405, 0, -38.576591, 0, 38589.546875, 0, 18686.171875, 0, 1},
            {197.322464, 0, -35.799675, 0, 35813.636719, 0, 7299.633301, 0, 1},
            {100.446022, 0, -31.315689, 0, 31331.654297, 0, 3950.703613, 0, 1},
            {56.279198, 0, -25.957386, 0, 25976.642578, 0, 1797.385010, 0, 1},
            {28.154728, 0, -20.744593, 0, 20768.679688, 0, 725.731995, 0, 1},
            {19.027901, 0, -16.364071, 0, 16394.599609, 0, 464.752045, 0, 1},
            {13.055046, 0, -12.959450, 0, 8970.863281, 0, 352.151031, 0, 1},
            {10.366891, 0, -10.395847, 0, 5685.630859, 0, 253.332947, 0, 1},
            {7.880549, 0, -8.480193, 0, 3241.803711, 0, 167.085403, 0, 1},
            {6.323206, 0, -7.036265, 0, 2002.726563, 0, 116.059944, 0, 1},
            {5.031785, 0, -5.930668, 0, 1186.607544, 0, 83.446808, 0, 1},
            {4.369559, 0, -5.070666, 0, 843.374939, 0, 61.138889, 0, 1},
            {3.756168, 0, -4.392256, 0, 569.649048, 0, 46.177486, 0, 1},
            {3.284899, 0, -3.848196, 0, 394.281097, 0, 35.739964, 0, 1},
            {2.883921, 0, -3.405721, 0, 281.049377, 0, 27.902145, 0, 1},
            {2.571442, 0, -3.041261, 0, 204.300674, 0, 22.228493, 0, 1},
            {2.339132, 0, -2.737367, 0, 150.837967, 0, 18.141542, 0, 1},
            {2.120369, 0, -2.481805, 0, 114.263908, 0, 14.825736, 0, 1},
            {1.948635, 0, -2.264440, 0, 87.588432, 0, 12.315406, 0, 1},
            {1.800365, 0, -2.077432, 0, 68.310730, 0, 10.325802, 0, 1},
            {1.670523, 0, -1.915280, 0, 54.053909, 0, 8.719241, 0, 1},
            {1.569876, 0, -1.773206, 0, 43.103451, 0, 7.467847, 0, 1},
            {1.490116, 0, -1.647683, 0, 34.827641, 0, 6.471271, 0, 1},
            {1.422787, 0, -1.536024, 0, 28.357239, 0, 5.650585, 0, 1},
            {1.350524, 0, -1.435881, 0, 23.424438, 0, 4.917717, 0, 1},
            {1.300449, 0, -1.345390, 0, 19.401968, 0, 4.356206, 0, 1},
            {1.254408, 0, -1.263086, 0, 16.257393, 0, 3.864878, 0, 1},
            {1.213426, 0, -1.187775, 0, 13.705538, 0, 3.445318, 0, 1},
            {1.187376, 0, -1.118480, 0, 11.611020, 0, 3.109415, 0, 1},
            {1.152678, 0, -1.054393, 0, 9.910876, 0, 2.790627, 0, 1},
            {1.124951, 0, -0.994833, 0, 8.515365, 0, 2.520195, 0, 1},
            {1.108641, 0, -0.939255, 0, 7.359449, 0, 2.299614, 0, 1},
            {1.078992, 0, -0.887192, 0, 6.403783, 0, 2.077591, 0, 1},
            {1.068358, 0, -0.838210, 0, 5.579926, 0, 1.911003, 0, 1},
            {1.045544, 0, -0.791979, 0, 4.909517, 0, 1.737019, 0, 1},
            {1.039163, 0, -0.748193, 0, 4.324389, 0, 1.605678, 0, 1},
            {1.017055, 0, -0.706611, 0, 3.844195, 0, 1.462573, 0, 1},
            {1.004383, 0, -0.666994, 0, 3.423768, 0, 1.342792, 0, 1},
            {0.992540, 0, -0.629166, 0, 3.063540, 0, 1.237080, 0, 1},
            {0.984481, 0, -0.592946, 0, 2.750717, 0, 1.141492, 0, 1},
            {0.967479, 0, -0.558180, 0, 2.481156, 0, 1.043608, 0, 1},
            {0.962412, 0, -0.524746, 0, 2.244889, 0, 0.966517, 0, 1},
            {0.947635, 0, -0.492520, 0, 2.040848, 0, 0.884740, 0, 1},
            {0.927563, 0, -0.461392, 0, 1.857744, 0, 0.802900, 0, 1},
            {0.918131, 0, -0.431266, 0, 1.701805, 0, 0.735842, 0, 1},
            {0.907630, 0, -0.402059, 0, 1.563891, 0, 0.672641, 0, 1},
            {0.883494, 0, -0.373698, 0, 1.434873, 0, 0.602092, 0, 1},
            {0.869519, 0, -0.346105, 0, 1.325065, 0, 0.543472, 0, 1},
            {0.861498, 0, -0.319216, 0, 1.229527, 0, 0.491262, 0, 1},
            {0.832228, 0, -0.292972, 0, 1.130479, 0, 0.429526, 0, 1},
            {0.816181, 0, -0.267321, 0, 1.051445, 0, 0.378898, 0, 1},
            {0.786525, 0, -0.242210, 0, 0.970167, 0, 0.325618, 0, 1},
            {0.780779, 0, -0.217600, 0, 0.918654, 0, 0.284465, 0, 1},
            {0.762468, 0, -0.193452, 0, 0.865830, 0, 0.241828, 0, 1},
            {0.731299, 0, -0.169721, 0, 0.812862, 0, 0.200252, 0, 1},
            {0.713894, 0, -0.146372, 0, 0.774122, 0, 0.165581, 0, 1},
            {0.702714, 0, -0.123373, 0, 0.742843, 0, 0.133586, 0, 1},
            {0.691956, 0, -0.100693, 0, 0.716288, 0, 0.103949, 0, 1},
            {0.668866, 0, -0.078304, 0, 0.686033, 0, 0.074789, 0, 1},
            {0.654494, 0, -0.056178, 0, 0.661872, 0, 0.046786, 0, 1},
            {0.640656, 0, -0.034292, 0, 0.639283, 0, 0.018889, 0, 1},
            {368.624268, 0, -255.918320, 0, 255920.265625, 0, 255920.796875, 0, 1},
            {368.624268, 0, -255.918320, 0, 255920.265625, 0, 255920.796875, 0, 1},
            {364.104523, 0, -253.713470, 0, 253715.421875, 0, 253715.968750, 0, 1},
            {284.967621, 0, -105.050774, 0, 105055.539063, 0, 105057.585938, 0, 1},
            {225.051605, 0, -57.172325, 0, 57181.070313, 0, 57185.875000, 0, 1},
            {11.684321, 0, -36.029091, 0, 36042.972656, 0, 621.735474, 0, 1},
            {25.042456, 0, -24.817822, 0, 24837.957031, 0, 2865.348877, 0, 1},
            {17.127863, 0, -18.154654, 0, 18182.173828, 0, 384.187866, 0, 1},
            {11.650437, 0, -13.869071, 0, 13905.077148, 0, 224.628876, 0, 1},
            {8.216252, 0, -10.950104, 0, 10331.644531, 0, 260.237000, 0, 1},
            {5.907559, 0, -8.873001, 0, 8929.172852, 0, 102.799171, 0, 1},
            {4.817279, 0, -7.343625, 0, 5326.685547, 0, 72.651924, 0, 1},
            {2.978287, 0, -6.185863, 0, 2897.457764, 0, 66.361404, 0, 1},
            {3.631224, 0, -5.289113, 0, 1569.821289, 0, 66.001900, 0, 1},
            {3.187469, 0, -4.581205, 0, 1033.481079, 0, 48.582752, 0, 1},
            {2.768893, 0, -4.013087, 0, 684.398560, 0, 37.436520, 0, 1},
            {2.457926, 0, -3.550626, 0, 470.771790, 0, 29.091085, 0, 1},
            {2.314997, 0, -3.169384, 0, 328.752625, 0, 23.818150, 0, 1},
            {2.093580, 0, -2.851492, 0, 236.043579, 0, 19.236486, 0, 1},
            {1.909406, 0, -2.583620, 0, 173.956696, 0, 15.624541, 0, 1},
            {1.759313, 0, -2.355661, 0, 130.381760, 0, 12.901838, 0, 1},
            {1.632784, 0, -2.159850, 0, 99.546364, 0, 10.774215, 0, 1},
            {1.514441, 0, -1.990140, 0, 77.199669, 0, 9.025685, 0, 1},
            {1.409535, 0, -1.841777, 0, 60.638985, 0, 7.615921, 0, 1},
            {1.393320, 0, -1.711004, 0, 47.528347, 0, 6.799057, 0, 1},
            {1.320484, 0, -1.594821, 0, 38.236202, 0, 5.873020, 0, 1},
            {1.242410, 0, -1.490820, 0, 31.031847, 0, 5.054711, 0, 1},
            {1.237673, 0, -1.397065, 0, 25.284676, 0, 4.582990, 0, 1},
            {1.182925, 0, -1.311984, 0, 20.992647, 0, 4.017620, 0, 1},
            {1.176501, 0, -1.234298, 0, 17.318192, 0, 3.665294, 0, 1},
            {1.133547, 0, -1.162960, 0, 14.591148, 0, 3.253035, 0, 1},
            {1.125217, 0, -1.097106, 0, 12.296440, 0, 2.969493, 0, 1},
            {1.093465, 0, -1.036020, 0, 10.463271, 0, 2.666238, 0, 1},
            {1.083275, 0, -0.979105, 0, 8.956235, 0, 2.440557, 0, 1},
            {1.060562, 0, -0.925860, 0, 7.713723, 0, 2.215227, 0, 1},
            {1.049519, 0, -0.875859, 0, 6.682784, 0, 2.032087, 0, 1},
            {1.032032, 0, -0.828741, 0, 5.827990, 0, 1.857221, 0, 1},
            {1.018987, 0, -0.784196, 0, 5.116087, 0, 1.705405, 0, 1},
            {1.007602, 0, -0.741956, 0, 4.498546, 0, 1.568523, 0, 1},
            {0.992375, 0, -0.701791, 0, 3.980726, 0, 1.437860, 0, 1},
            {0.988607, 0, -0.663498, 0, 3.541646, 0, 1.334776, 0, 1},
            {0.968230, 0, -0.626898, 0, 3.166821, 0, 1.216528, 0, 1},
            {0.944781, 0, -0.591836, 0, 2.831877, 0, 1.106590, 0, 1},
            {0.945987, 0, -0.558172, 0, 2.559725, 0, 1.033804, 0, 1},
            {0.923684, 0, -0.525783, 0, 2.299483, 0, 0.939927, 0, 1},
            {0.931669, 0, -0.494561, 0, 2.097793, 0, 0.884566, 0, 1},
            {0.900607, 0, -0.464405, 0, 1.898084, 0, 0.794077, 0, 1},
            {0.907272, 0, -0.435227, 0, 1.739798, 0, 0.742634, 0, 1},
            {0.893180, 0, -0.406948, 0, 1.591641, 0, 0.678342, 0, 1},
            {0.855697, 0, -0.379493, 0, 1.438521, 0, 0.600044, 0, 1},
            {0.856723, 0, -0.352800, 0, 1.334550, 0, 0.553423, 0, 1},
            {0.824318, 0, -0.326806, 0, 1.209542, 0, 0.488206, 0, 1},
            {0.806548, 0, -0.301457, 0, 1.113896, 0, 0.435934, 0, 1},
            {0.810348, 0, -0.276705, 0, 1.049273, 0, 0.394856, 0, 1},
            {0.767125, 0, -0.252502, 0, 0.951908, 0, 0.337448, 0, 1},
            {0.749976, 0, -0.228807, 0, 0.889436, 0, 0.291562, 0, 1},
            {0.732485, 0, -0.205582, 0, 0.836374, 0, 0.249723, 0, 1},
            {0.707799, 0, -0.182791, 0, 0.785760, 0, 0.210818, 0, 1},
            {0.698760, 0, -0.160400, 0, 0.749314, 0, 0.176389, 0, 1},
            {0.684260, 0, -0.138380, 0, 0.715853, 0, 0.143288, 0, 1},
            {0.662066, 0, -0.116703, 0, 0.682031, 0, 0.113378, 0, 1},
            {0.649300, 0, -0.095341, 0, 0.658064, 0, 0.086197, 0, 1},
            {0.623254, 0, -0.074271, 0, 0.630556, 0, 0.058888, 0, 1},
            {0.609037, 0, -0.053470, 0, 0.607151, 0, 0.031450, 0, 1}
        };
    }
}
