namespace UnityEngine.Rendering.HighDefinition
{
    partial class LTCAreaLight
    {
        // Table contains 3x3 matrix coefficients of M^-1 for the fitting of the GGX BRDF using the LTC technique
        // From "Real-Time Polygonal-Light Shading with Linearly Transformed Cosines" 2016 (https://eheitzresearch.wordpress.com/415-2/)
        //
        // The table is accessed via LTCAreaLight.s_LtcMatrixData_GGX[<roughnessIndex> + 64 * <thetaIndex>]    // Theta values are along the Y axis, Roughness values are along the X axis
        //    • roughness = ( <roughnessIndex> / 63 )^2
        //    • cosTheta = 1 - ( <thetaIndex> / 63 )^2
        //
        public static double[,]	s_LtcMatrixData_GGX = new double[k_LtcLUTResolution * k_LtcLUTResolution, k_LtcLUTMatrixDim * k_LtcLUTMatrixDim] {
            { 249.99972516083, 0, -2.35158682407516E-09, 0, 249.99972516083, 0, 9.40635763724274E-12, 0, 1 }, { 249.99972516083, 0, -6.1932882001426E-09, 0, 249.99972516083, 0, 2.47731800351314E-11, 0, 1 }, { 249.99972516083, 0, -1.84402568106453E-08, 0, 249.99972516083, 0, 7.37611083323486E-11, 0, 1 }, { 220.49964865921, 0, -5.12586846192175E-08, 0, 220.49964865921, 0, 2.32466060290371E-10, 0, 1 }, { 124.030590285527, 0, -4.84301716700758E-08, 0, 124.030590285527, 0, 3.90469573341434E-10, 0, 1 }, { 79.3790316808135, 0, -5.13550351597887E-08, 0, 79.3790316808135, 0, 6.46959708028305E-10, 0, 1 }, { 55.1235929120602, 0, -4.96528441935784E-08, 0, 55.1235929120602, 0, 9.00754859589625E-10, 0, 1 }, { 40.4981603373294, 0, -5.85023023608724E-08, 0, 40.4981603373294, 0, 1.44456691053563E-09, 0, 1 }, { 31.0053811128358, 0, -4.92814208924551E-08, 0, 31.0053811128358, 0, 1.58944735151323E-09, 0, 1 }, { 24.4969875965314, 0, -5.36548203561093E-08, 0, 24.4969875965314, 0, 2.19026197179062E-09, 0, 1 }, { 19.8411972620128, 0, -5.35403051060404E-08, 0, 19.8411972620128, 0, 2.69844124822782E-09, 0, 1 }, { 16.3962591717518, 0, -4.92930039295324E-08, 0, 16.3962591717518, 0, 3.0063567191263E-09, 0, 1 }, { 13.7758684216582, 0, -5.12003824983554E-08, 0, 13.7758684216582, 0, 3.71667185916635E-09, 0, 1 }, { 11.7363174287487, 0, -4.12478507819388E-08, 0, 11.7363174287487, 0, 3.51454798597217E-09, 0, 1 }, { 10.1178181464916, 0, -5.10312181762129E-08, 0, 10.1178181464916, 0, 5.04369790377268E-09, 0, 1 }, { 8.81199517673572, 0, -5.20683220345778E-08, 0, 8.81199517673572, 0, 5.90880055995058E-09, 0, 1 }, { 7.74302105929495, 0, -5.52646155954912E-08, 0, 7.74302105929495, 0, 7.13734538138056E-09, 0, 1 }, { 6.8574249986839, 0, -5.2430241156594E-08, 0, 6.8574249986839, 0, 7.64576224554503E-09, 0, 1 }, { 6.11633555437548, 0, -4.96724877600275E-08, 0, 6.11633555437548, 0, 8.12128231331144E-09, 0, 1 }, { 5.49522486068625, 0, -5.27931845448473E-08, 0, 5.49522486068626, 0, 9.60710178077306E-09, 0, 1 }, { 5.01253186221066, 0, -4.48432561385957E-08, 0, 5.01253186221066, 0, 8.94622864677785E-09, 0, 1 }, { 4.54478340939888, 0, -3.7324833053011E-08, 0, 4.54478340939888, 0, 8.21267587269858E-09, 0, 1 }, { 4.13925586407918, 0, -4.2799673886404E-08, 0, 4.13925586407919, 0, 1.03399440121166E-08, 0, 1 }, { 3.78610359388004, 0, -4.59492519237764E-08, 0, 3.78610359388004, 0, 1.21362901950306E-08, 0, 1 }, { 3.4779130151006, 0, -4.48351305923097E-08, 0, 3.4779130151006, 0, 1.28913892893934E-08, 0, 1 }, { 3.21046137456232, 0, -4.12042777024413E-08, 0, 3.21046137456232, 0, 1.28343788929897E-08, 0, 1 }, { 2.98388474794477, 0, -4.43903154442322E-08, 0, 2.98388474794477, 0, 1.4876685661136E-08, 0, 1 }, { 2.77921482105912, 0, -3.87377627843715E-08, 0, 2.77921482105912, 0, 1.39383837804985E-08, 0, 1 }, { 2.58757430625212, 0, -3.46795153326855E-08, 0, 2.58757430625212, 0, 1.34023263598237E-08, 0, 1 }, { 2.42032542884521, 0, -3.77554589546857E-08, 0, 2.42032542884522, 0, 1.55993316042213E-08, 0, 1 }, { 2.27712916853536, 0, -3.37465231307334E-08, 0, 2.27712916853536, 0, 1.48197667471095E-08, 0, 1 }, { 2.14098188145856, 0, -3.74537571106628E-08, 0, 2.14098188145856, 0, 1.74937291319566E-08, 0, 1 }, { 2.01934552621459, 0, -3.81046066412548E-08, 0, 2.01934552621459, 0, 1.88697804048843E-08, 0, 1 }, { 1.91449371795389, 0, -3.66573289653752E-08, 0, 1.91449371795389, 0, 1.91472704358375E-08, 0, 1 }, { 1.81331445811834, 0, -2.77685481359264E-08, 0, 1.81331445811834, 0, 1.53136969771594E-08, 0, 1 }, { 1.72525193655925, 0, -3.43443950123012E-08, 0, 1.72525193655925, 0, 1.99068868056429E-08, 0, 1 }, { 1.6440674925966, 0, -3.30333649433396E-08, 0, 1.6440674925966, 0, 2.0092462804655E-08, 0, 1 }, { 1.57097191318885, 0, -2.89556532742908E-08, 0, 1.57097191318885, 0, 1.84316810702967E-08, 0, 1 }, { 1.50406410053135, 0, -3.76054021876725E-08, 0, 1.50406410053135, 0, 2.5002526271578E-08, 0, 0.999999999999999 }, { 1.44396733621497, 0, -3.30591007364969E-08, 0, 1.44396733621497, 0, 2.2894631968029E-08, 0, 0.999999999999999 }, { 1.38801010300016, 0, -3.38178907304926E-08, 0, 1.38801010300016, 0, 2.43642972463931E-08, 0, 0.999999999999999 }, { 1.33826618093002, 0, -3.21007233648853E-08, 0, 1.33826618093002, 0, 2.39868001017385E-08, 0, 0.999999999999999 }, { 1.25003209898949, 0, -3.53393174378494E-08, 0, 1.25003209898949, 0, 2.82707279808392E-08, 0, 0.999999999999999 }, { 1.25003209898949, 0, -3.4105499348838E-08, 0, 1.25003209898949, 0, 2.72836988557401E-08, 0, 0.999999999999999 }, { 1.1773249812826, 0, -3.03692379111505E-08, 0, 1.1773249812826, 0, 2.579511892975E-08, 0, 0.999999999999999 }, { 1.1773249812826, 0, -3.27582593940015E-08, 0, 1.1773249812826, 0, 2.78243135198863E-08, 0, 0.999999999999999 }, { 1.09019445871237, 0, -2.96785427238806E-08, 0, 1.09019445871237, 0, 2.7223164167367E-08, 0, 0.999999999999999 }, { 1.09019445871237, 0, -2.93556402478319E-08, 0, 1.09019445871237, 0, 2.69269762043223E-08, 0, 0.999999999999999 }, { 1.09019445871237, 0, -3.34367616099921E-08, 0, 1.09019445871237, 0, 3.06704563968196E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -3.36323999761134E-08, 0, 1, 0, 3.36323999761134E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -2.77374194723734E-08, 0, 1, 0, 2.77374194723734E-08, 0, 0.999999999999999 }, { 0.999999999999998, 0, -4.18260519552404E-08, 0, 1, 0, 4.18260519552404E-08, 0, 0.999999999999998 }, { 1, 0, -2.0792134236558E-08, 0, 1, 0, 2.0792134236558E-08, 0, 1 }, { 0.999999999999999, 0, -3.20445217028009E-08, 0, 1, 0, 3.20445217028009E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -2.52821461543817E-08, 0, 1, 0, 2.52821461543817E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -3.70039501262908E-08, 0, 1, 0, 3.70039501262908E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -3.29134408616482E-08, 0, 1, 0, 3.29134408616482E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -2.87970447487851E-08, 0, 1, 0, 2.87970447487851E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -2.64988049281101E-08, 0, 1, 0, 2.64988049281101E-08, 0, 0.999999999999999 }, { 1, 0, -2.01495424789755E-08, 0, 1, 0, 2.01495424789755E-08, 0, 1 }, { 0.999999999999999, 0, -3.63770311651023E-08, 0, 1, 0, 3.63770311651023E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -3.61919845204283E-08, 0, 1, 0, 3.61919845204283E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -3.43134196612027E-08, 0, 1, 0, 3.43134196612027E-08, 0, 0.999999999999999 }, { 0.999999999999999, 0, -3.18707833457665E-08, 0, 1, 0, 3.18707833457665E-08, 0, 0.999999999999999 },    // Cos(theta) = 1
            { 249.936706690368, 0, 5.61152608121829, 0, 250.062752059257, 0, -0.0224461519228493, 0, 0.999748055622475 }, { 249.936706544073, 0, 5.61152933755871, 0, 250.062752059257, 0, -0.022446164948227, 0, 0.999748055037294 }, { 249.936704370534, 0, 5.61157771747294, 0, 250.062752059257, 0, -0.0224463584681217, 0, 0.999748046343125 }, { 220.444059291464, 0, 4.94940890121771, 0, 220.55518528361, 0, -0.0224463677719627, 0, 0.999748045925135 }, { 123.999381006855, 0, 2.78403345210448, 0, 124.061893662422, 0, -0.0224463034594411, 0, 0.99974810847925 }, { 79.3590373329927, 0, 1.78176881393803, 0, 79.3990383288232, 0, -0.0224463398604398, 0, 0.999748047179106 }, { 55.1097653522054, 0, 1.23732438761666, 0, 55.1375694909148, 0, -0.0224463659111945, 0, 0.999748046008733 }, { 40.4879641911111, 0, 0.909034318512554, 0, 40.5084531907256, 0, -0.0224463156704531, 0, 0.999748048265881 }, { 30.9975744670345, 0, 0.695956765534018, 0, 31.0132100012686, 0, -0.0224463462571149, 0, 0.999748106556496 }, { 24.4907744137122, 0, 0.549866048394318, 0, 24.5031193489786, 0, -0.0224462532186934, 0, 0.999748110736392 }, { 19.8362526228787, 0, 0.445361383836487, 0, 19.8462221151567, 0, -0.0224461641338781, 0, 0.999747995409116 }, { 16.3921917915592, 0, 0.368038724874638, 0, 16.4003896166652, 0, -0.0224461490156599, 0, 0.999748115417855 }, { 13.7724373052482, 0, 0.30921954376937, 0, 13.779389838809, 0, -0.0224459825929371, 0, 0.999748063229807 }, { 11.733403689589, 0, 0.263435441029996, 0, 11.7393112769214, 0, -0.0224456941738468, 0, 0.999748076187218 }, { 10.1153153395902, 0, 0.227107172754874, 0, 10.1204329136075, 0, -0.0224449639384079, 0, 0.999748049328003 }, { 8.80973963162431, 0, 0.197795632671606, 0, 8.8141873233667, 0, -0.0224433339051792, 0, 0.999748122552761 }, { 7.74118526987494, 0, 0.173808537085578, 0, 7.74503411158499, 0, -0.0224391883450253, 0, 0.99974818942717 }, { 6.85573032553224, 0, 0.153921081401336, 0, 6.85910290448169, 0, -0.0224256229862892, 0, 0.999748500170819 }, { 6.11474657092118, 0, 0.137274049356678, 0, 6.11779755999053, 0, -0.0223642777214091, 0, 0.999749937269265 }, { 5.49435024789379, 0, 0.123285065594626, 0, 5.49700308232718, 0, -0.0218898754008676, 0, 0.999760446273529 }, { 5.0050194174198, 0, 0.112158097942443, 0, 5.00747755258788, 0, -0.0206910335732738, 0, 0.999785875541753 }, { 4.54367477693257, 0, 0.101998695262028, 0, 4.54590852465353, 0, -0.022417759600123, 0, 0.999748733728541 }, { 4.13823819345704, 0, 0.0928810651507418, 0, 4.14032029951877, 0, -0.022389730333869, 0, 0.999749274621619 }, { 3.78522535391971, 0, 0.0849383729126612, 0, 3.78712981062427, 0, -0.0223231136171198, 0, 0.99975082353695 }, { 3.47725656052158, 0, 0.077993759377565, 0, 3.47889053653563, 0, -0.0221411031282761, 0, 0.999754865369964 }, { 3.20983892775547, 0, 0.0718809479909394, 0, 3.21141995570889, 0, -0.0215944436926462, 0, 0.999766798982804 }, { 2.98369684332256, 0, 0.0665057644524883, 0, 2.98514342350851, 0, -0.0201261367555525, 0, 0.999797374510434 }, { 2.77858252341236, 0, 0.0622449131695045, 0, 2.77988518324872, 0, -0.0220404495653679, 0, 0.999757048469761 }, { 2.58706944467462, 0, 0.0578343454486483, 0, 2.58833144859269, 0, -0.0216201864485913, 0, 0.999766222682478 }, { 2.420047912587, 0, 0.053872145007143, 0, 2.42120272912127, 0, -0.0207745811004126, 0, 0.999784198634445 }, { 2.27623377097568, 0, 0.050327780296591, 0, 2.27736544320128, 0, -0.0198029615544142, 0, 0.999803903541718 }, { 2.14060704310248, 0, 0.0475008081611562, 0, 2.1415886488846, 0, -0.0209681923672342, 0, 0.999780168128298 }, { 2.01912594996957, 0, 0.0444522909259654, 0, 2.02001765316817, 0, -0.0199234929065781, 0, 0.999801498491073 }, { 1.91305591630472, 0, 0.0418777794141375, 0, 1.91384307127268, 0, -0.0196033939869512, 0, 0.999807835391859 }, { 1.81309518050647, 0, 0.0395544579375008, 0, 1.81382376991663, 0, -0.0196259626555668, 0, 0.999807367079979 }, { 1.72506921426309, 0, 0.0370521970466009, 0, 1.72573950567881, 0, -0.0182659717904212, 0, 0.99983315983851 }, { 1.64380823953779, 0, 0.0352828898368588, 0, 1.64438414430532, 0, -0.0189058212072399, 0, 0.99982129232607 }, { 1.57078581280697, 0, 0.0329943787533442, 0, 1.57146973951907, 0, -0.017441935450815, 0, 0.999847866793313 }, { 1.503901128074, 0, 0.031449743260161, 0, 1.50444637114617, 0, -0.0178363827506599, 0, 0.999840922942999 }, { 1.44347216338998, 0, 0.0294904916314813, 0, 1.44402783562175, 0, -0.0166494390305807, 0, 0.999861417386587 }, { 1.38799258642851, 0, 0.0278967807781863, 0, 1.38845236976742, 0, -0.0164234417514614, 0, 0.999865078050608 }, { 1.33777501104505, 0, 0.0263639893604965, 0, 1.3382797309942, 0, -0.0159714613753992, 0, 0.999872450092889 }, { 1.24994366062863, 0, 0.0234095518112964, 0, 1.25034189884332, 0, -0.0147564648461011, 0, 0.999891132582432 }, { 1.24994663491867, 0, 0.0232533970753101, 0, 1.25034189884332, 0, -0.0146315488693477, 0, 0.999893015892183 }, { 1.17697412860489, 0, 0.021483544389643, 0, 1.17743454426534, 0, -0.0139199010246247, 0, 0.999903144132751 }, { 1.17699648217941, 0, 0.0202188239333476, 0, 1.17743454426534, 0, -0.012845455323585, 0, 0.99991748029418 }, { 1.08978465655143, 0, 0.0176864303886164, 0, 1.09018880636586, 0, -0.0122250819875025, 0, 0.999925226392564 }, { 1.08979163262631, 0, 0.0172572642800218, 0, 1.09018880636586, 0, -0.0118313032168124, 0, 0.999930050834961 }, { 1.08980681519439, 0, 0.016269989284445, 0, 1.09018880636586, 0, -0.0109254381864269, 0, 0.999940355101701 }, { 0.999950127390427, 0, 0.00998795328357067, 0, 1, 0, -0.00998795328357067, 0, 0.999950127390427 }, { 0.999958051655997, 0, 0.0091568907210251, 0, 1, 0, -0.0091568907210251, 0, 0.999958051655997 }, { 0.999963812532784, 0, 0.00851033392978927, 0, 1, 0, -0.00851033392978927, 0, 0.999963812532784 }, { 0.99996874929944, 0, 0.00790459089758978, 0, 1, 0, -0.00790459089758978, 0, 0.99996874929944 }, { 0.999974814484357, 0, 0.00709493062785382, 0, 1, 0, -0.00709493062785382, 0, 0.999974814484357 }, { 0.999980470728288, 0, 0.00625610262324583, 0, 1, 0, -0.00625610262324583, 0, 0.999980470728288 }, { 0.99998518803781, 0, 0.00544000866329519, 0, 1, 0, -0.00544000866329519, 0, 0.99998518803781 }, { 0.999989082750575, 0, 0.00467807497007881, 0, 1, 0, -0.00467807497007881, 0, 0.999989082750575 }, { 0.999992011456293, 0, 0.00400438602058364, 0, 1, 0, -0.00400438602058364, 0, 0.999992011456293 }, { 0.999994328702737, 0, 0.00335769285743845, 0, 1, 0, -0.00335769285743845, 0, 0.999994328702737 }, { 0.999996447134158, 0, 0.00267004344344455, 0, 1, 0, -0.00267004344344455, 0, 0.999996447134158 }, { 0.999998121343996, 0, 0.00194576492993735, 0, 1, 0, -0.00194576492993735, 0, 0.999998121343996 }, { 0.999999266123321, 0, 0.00122830637642442, 0, 1, 0, -0.00122830637642442, 0, 0.999999266123321 }, { 0.999999858260981, 0, 0.000566173947918004, 0, 1, 0, -0.000566173947918004, 0, 0.999999858260981 }, { 0.999999999996448, 0, -1.88474132300384E-06, 0, 1, 0, 1.88474132300384E-06, 0, 0.999999999996448 },    // Cos(theta) = 0.9997481
            { 249.747946032757, 0, 11.2210063718171, 0, 250.252122492123, 0, -0.0448832765388937, 0, 0.998992271371299 }, { 249.747769663881, 0, 11.2210027313826, 0, 250.251953398092, 0, -0.0448839852025519, 0, 0.998992207563527 }, { 249.747769997956, 0, 11.2209990211062, 0, 250.251953398092, 0, -0.0448839703614296, 0, 0.998992208899826 }, { 220.277414669825, 0, 9.89691552735173, 0, 220.722064229233, 0, -0.0448839761470766, 0, 0.998992148533116 }, { 123.905658260305, 0, 5.56699739312793, 0, 124.155725189259, 0, -0.0448839703614296, 0, 0.998992208899826 }, { 79.299046838306, 0, 3.56285242571012, 0, 79.4591080307488, 0, -0.044883896155817, 0, 0.998992215581313 }, { 55.0681388148786, 0, 2.474174486513, 0, 55.1793055485798, 0, -0.0448840313608391, 0, 0.998992263253196 }, { 40.4573117573255, 0, 1.81771918651403, 0, 40.5390104533836, 0, -0.0448840016785911, 0, 0.998992265925795 }, { 30.9741605012835, 0, 1.39164794838302, 0, 31.0367009048871, 0, -0.0448838367913259, 0, 0.998992220926495 }, { 24.4722917031819, 0, 1.09952261341445, 0, 24.5216223911301, 0, -0.0448838738941329, 0, 0.998992217585757 }, { 19.8212569174399, 0, 0.890553883081805, 0, 19.8612142697156, 0, -0.0448836698286894, 0, 0.99899223595978 }, { 16.3798109601023, 0, 0.735933301123757, 0, 16.4128326933238, 0, -0.0448833396136751, 0, 0.998992265692114 }, { 13.7619936175426, 0, 0.618316466010059, 0, 13.7898048937422, 0, -0.0448828874000512, 0, 0.998992186717244 }, { 11.7245587662405, 0, 0.526772223364751, 0, 11.7481859723876, 0, -0.0448822863345144, 0, 0.998992240835665 }, { 10.107799180935, 0, 0.454138764098364, 0, 10.1279886452715, 0, -0.044880609286944, 0, 0.998992391828923 }, { 8.8031049633604, 0, 0.395512495863937, 0, 8.82084002787945, 0, -0.0448771628744438, 0, 0.998992582417967 }, { 7.73543863465769, 0, 0.347537098604611, 0, 7.75080667551585, 0, -0.0448684528901736, 0, 0.998992887705717 }, { 6.85050749890715, 0, 0.307775682422324, 0, 6.86439848427502, 0, -0.0448403666806515, 0, 0.998994218010491 }, { 6.11030852323534, 0, 0.274509709908383, 0, 6.12263078655031, 0, -0.0447121449016421, 0, 0.998999870486422 }, { 5.4913878756896, 0, 0.246589311927804, 0, 5.50232567830171, 0, -0.0436700936418822, 0, 0.9990459850758 }, { 4.99523637934682, 0, 0.224037222564612, 0, 5.0051436589855, 0, -0.041655187302997, 0, 0.99913205489467 }, { 4.54033527837627, 0, 0.203958898428542, 0, 4.54930770397337, 0, -0.0448242559520895, 0, 0.99899482911195 }, { 4.13528571573805, 0, 0.18573366747823, 0, 4.14341537024394, 0, -0.0447673172693832, 0, 0.998997492114421 }, { 3.78251379939504, 0, 0.169864113342979, 0, 3.79002376836072, 0, -0.0446307863721488, 0, 0.999003570528342 }, { 3.4748674733131, 0, 0.155970794837089, 0, 3.48163257664505, 0, -0.0442557015268773, 0, 0.999020254165919 }, { 3.20820219419506, 0, 0.143743045406678, 0, 3.21426062140431, 0, -0.043126460755059, 0, 0.999069671469618 }, { 2.98187786968825, 0, 0.133086329326874, 0, 2.98769035449573, 0, -0.0407093598128861, 0, 0.999171102074752 }, { 2.77672444884535, 0, 0.124435203876184, 0, 2.78201177090984, 0, -0.0440350281077569, 0, 0.99902998134012 }, { 2.58568516803254, 0, 0.115640906644737, 0, 2.59057696104853, 0, -0.0432011729466983, 0, 0.999066374515153 }, { 2.41895900170998, 0, 0.107692466002089, 0, 2.42343539002652, 0, -0.041489775563733, 0, 0.999138965509964 }, { 2.27352927572255, 0, 0.100808588720582, 0, 2.27781123319826, 0, -0.0404520730073813, 0, 0.999181510501091 }, { 2.13959083767267, 0, 0.0950365531517551, 0, 2.14356821475426, 0, -0.041892114795544, 0, 0.999122137278407 }, { 2.01833630420658, 0, 0.0888969574330842, 0, 2.0219971283604, 0, -0.0397911135863967, 0, 0.99920800692091 }, { 1.91091919874902, 0, 0.0837413462286546, 0, 1.91432318138166, 0, -0.0392839037591647, 0, 0.999228118904818 }, { 1.81237203321686, 0, 0.0791038889722267, 0, 1.81554046714707, 0, -0.0392006762813723, 0, 0.999231377728085 }, { 1.72367006422387, 0, 0.0743072893601868, 0, 1.7265982861, 0, -0.037380633806782, 0, 0.999301123886555 }, { 1.64300893469735, 0, 0.0704671622315507, 0, 1.64592287297417, 0, -0.0375986472235243, 0, 0.999292871923989 }, { 1.56978234130597, 0, 0.0662645173776501, 0, 1.57225575429113, 0, -0.0356861977304961, 0, 0.999363084519508 }, { 1.5032788544816, 0, 0.0627842756562273, 0, 1.50561741775558, 0, -0.0353547013736122, 0, 0.999374847419443 }, { 1.44228169921887, 0, 0.0590801851202805, 0, 1.44469535130439, 0, -0.0337691801798827, 0, 0.999429674061797 }, { 1.38747568086987, 0, 0.0557940960544797, 0, 1.38959694510553, 0, -0.0328078360422556, 0, 0.999461645580771 }, { 1.33688954536745, 0, 0.052534056115798, 0, 1.33885657708165, 0, -0.0315281987758624, 0, 0.999502828205237 }, { 1.24912556505835, 0, 0.0480944895477841, 0, 1.2510405351022, 0, -0.0302378918237648, 0, 0.999542747668862 }, { 1.24919027684214, 0, 0.0463835341573287, 0, 1.2510405351022, 0, -0.0288688033093827, 0, 0.999583233802803 }, { 1.17605559257383, 0, 0.0421455410361522, 0, 1.17780282359236, 0, -0.0274792613291253, 0, 0.999622342973359 }, { 1.17610880805696, 0, 0.0406356069630812, 0, 1.17780282359236, 0, -0.0261958556915728, 0, 0.999656862969016 }, { 1.08891398268098, 0, 0.0357955235043003, 0, 1.09037790438744, 0, -0.0247415421216435, 0, 0.999693891853337 }, { 1.08897283555812, 0, 0.0339586683165254, 0, 1.09037790438744, 0, -0.0230552009293867, 0, 0.999734223804911 }, { 1.08902205892995, 0, 0.0323402095740163, 0, 1.09037790438744, 0, -0.0215693801389456, 0, 0.999767344636172 }, { 0.999794922360746, 0, 0.0202517942313681, 0, 1, 0, -0.0202517942313681, 0, 0.999794922360746 }, { 0.999824407738856, 0, 0.0187375851547369, 0, 1, 0, -0.0187375851547369, 0, 0.999824407738856 }, { 0.999853908512309, 0, 0.0170927215281507, 0, 1, 0, -0.0170927215281507, 0, 0.999853908512309 }, { 0.999880184153089, 0, 0.0154792385411265, 0, 1, 0, -0.0154792385411265, 0, 0.999880184153089 }, { 0.999902949450706, 0, 0.0139333090554366, 0, 1, 0, -0.0139333090554366, 0, 0.999902949450706 }, { 0.999922052760882, 0, 0.012483766684855, 0, 1, 0, -0.012483766684855, 0, 0.999922052760882 }, { 0.999939050329947, 0, 0.0110418072965664, 0, 1, 0, -0.0110418072965664, 0, 0.999939050329947 }, { 0.999954423698343, 0, 0.00954839141843103, 0, 1, 0, -0.00954839141843103, 0, 0.999954423698343 }, { 0.999967565252196, 0, 0.00805718491851225, 0, 1, 0, -0.00805718491851225, 0, 0.999967565252196 }, { 0.999978201275882, 0, 0.00660405551785873, 0, 1, 0, -0.00660405551785873, 0, 0.999978201275882 }, { 0.999986433326967, 0, 0.00520545318391351, 0, 1, 0, -0.00520545318391351, 0, 0.999986433326967 }, { 0.999992429700822, 0, 0.00388335250256577, 0, 1, 0, -0.00388335250256577, 0, 0.999992429700822 }, { 0.999996871739639, 0, 0.00250744827360521, 0, 1, 0, -0.00250744827360521, 0, 0.999996871739639 }, { 0.999999236380495, 0, 0.00124035451092836, 0, 1, 0, -0.00124035451092836, 0, 0.999999236380495 }, { 0.999999999581178, 0, -2.04651387235352E-05, 0, 1, 0, 2.04651387235352E-05, 0, 0.999999999581178 },    // Cos(theta) = 0.9989922
            { 249.433006661235, 0, 16.8264463536172, 0, 250.568042713568, 0, -0.0673055211134903, 0, 0.997732363936056 }, { 249.432859599102, 0, 16.8264612830331, 0, 250.567874214921, 0, -0.0673059721033795, 0, 0.997732362961101 }, { 249.43286285125, 0, 16.8264372880556, 0, 250.567874214921, 0, -0.0673058761233811, 0, 0.997732375969709 }, { 219.999624749182, 0, 14.8409064933622, 0, 221.000713922646, 0, -0.0673059942526093, 0, 0.997732359959112 }, { 123.749415283361, 0, 8.34798434726428, 0, 124.312511039388, 0, -0.067305839830206, 0, 0.997732441038296 }, { 79.1990397237029, 0, 5.34266998606053, 0, 79.5594675046464, 0, -0.0673057727603017, 0, 0.997732389978959 }, { 54.9986495410156, 0, 3.71014148167851, 0, 55.248925896009, 0, -0.0673058096756877, 0, 0.997732384975658 }, { 40.4063390939742, 0, 2.72576119846919, 0, 40.5901783648713, 0, -0.0673056398649075, 0, 0.997732407990819 }, { 30.9350634259073, 0, 2.08684035745021, 0, 31.0758477642004, 0, -0.0673053666910189, 0, 0.997732445015089 }, { 24.4414933604875, 0, 1.64879318157861, 0, 24.5526322154781, 0, -0.0673050861340205, 0, 0.997732483039859 }, { 19.7962696870592, 0, 1.33543022005909, 0, 19.8863273239399, 0, -0.0673047901887461, 0, 0.99773246300048 }, { 16.3591672650378, 0, 1.1035651043511, 0, 16.4334978925007, 0, -0.0673039928160488, 0, 0.997732571069546 }, { 13.7447297468074, 0, 0.92719949708692, 0, 13.8071540919723, 0, -0.067303090836154, 0, 0.997732573015461 }, { 11.7098394242124, 0, 0.789929170350928, 0, 11.7628932448223, 0, -0.0673015391449187, 0, 0.997732663012731 }, { 10.0950220666965, 0, 0.680991309553791, 0, 10.1406879269712, 0, -0.0672991014826739, 0, 0.997732873073302 }, { 8.79207456833489, 0, 0.593089721918442, 0, 8.83194726434989, 0, -0.0672932275733542, 0, 0.997733248027848 }, { 7.72569736151716, 0, 0.521148753804064, 0, 7.76067226806679, 0, -0.0672791380523249, 0, 0.997734194688561 }, { 6.84216898162373, 0, 0.461539820622132, 0, 6.87286878117656, 0, -0.0672351176657861, 0, 0.997737088998661 }, { 6.10298409224287, 0, 0.41166459417883, 0, 6.13049920873177, 0, -0.06702664621497, 0, 0.997751195259748 }, { 5.48713638259885, 0, 0.369905747952435, 0, 5.51175836879139, 0, -0.0652040340376442, 0, 0.997871970140709 }, { 4.98457354880123, 0, 0.335728332104408, 0, 5.00689781165877, 0, -0.0630661430380464, 0, 0.998009375042456 }, { 4.53475712197851, 0, 0.305847434636959, 0, 4.55501564362616, 0, -0.0672094806686352, 0, 0.997738875171031 }, { 4.13020679438295, 0, 0.278535818458308, 0, 4.14861391354916, 0, -0.067121181622445, 0, 0.997744802672043 }, { 3.7780792346321, 0, 0.254717570977995, 0, 3.79483409733031, 0, -0.0669088496906279, 0, 0.997759080284121 }, { 3.47097479102623, 0, 0.233891252660511, 0, 3.48634650313542, 0, -0.066317167109719, 0, 0.997798565252649 }, { 3.20541232711742, 0, 0.215611878577559, 0, 3.219342449522, 0, -0.0645333730536463, 0, 0.99791553272148 }, { 2.97757692984541, 0, 0.19972471072136, 0, 2.99050421891363, 0, -0.062167095113211, 0, 0.998065801269459 }, { 2.77210987692884, 0, 0.186324320653772, 0, 2.78398776685699, 0, -0.0650259274424249, 0, 0.997883531258651 }, { 2.58313942808369, 0, 0.173419568846073, 0, 2.5941614149329, 0, -0.0647041588226146, 0, 0.997904501258132 }, { 2.41718170376709, 0, 0.161518006149432, 0, 2.4274284994448, 0, -0.0620879450563736, 0, 0.998070707754465 }, { 2.27026324548458, 0, 0.151241587502172, 0, 2.2796772088259, 0, -0.0612021408268968, 0, 0.998125409618237 }, { 2.13740285917791, 0, 0.142388385026576, 0, 2.14618422207259, 0, -0.0623438306681653, 0, 0.998054719804626 }, { 2.01705522142128, 0, 0.133368341850336, 0, 2.02511754597344, 0, -0.059651606476682, 0, 0.998219263209194 }, { 1.90845537042529, 0, 0.12555312606078, 0, 1.91596939005012, 0, -0.0589953914368972, 0, 0.998258217175051 }, { 1.8111701126341, 0, 0.118571692614573, 0, 1.81819789600911, 0, -0.0585205129794236, 0, 0.998286224950972 }, { 1.72183592311991, 0, 0.111594118460447, 0, 1.72830263244341, 0, -0.0565888040519487, 0, 0.998397550620935 }, { 1.64150977016387, 0, 0.105441339684325, 0, 1.64757340904894, 0, -0.0555229055063126, 0, 0.998457395486145 }, { 1.5682070010939, 0, 0.0995267227950027, 0, 1.57389528001268, 0, -0.0540090030964101, 0, 0.998540496112553 }, { 1.50190764460975, 0, 0.0939097193757087, 0, 1.50717538581269, 0, -0.0523106904301482, 0, 0.99863089561638 }, { 1.44092632905518, 0, 0.0886619110215, 0, 1.4460509413063, 0, -0.0508700918282544, 0, 0.998705289604317 }, { 1.38591481618507, 0, 0.0836030123928626, 0, 1.3906751813159, 0, -0.0490999697125253, 0, 0.998793897953249 }, { 1.33568126636028, 0, 0.0786929422418004, 0, 1.34017070149531, 0, -0.0470545899300044, 0, 0.998892331381983 }, { 1.24785326171131, 0, 0.0723633030570925, 0, 1.25195853682269, 0, -0.0455302041795494, 0, 0.998962926521165 }, { 1.24801307668941, 0, 0.0695540916353368, 0, 1.25195853682269, 0, -0.0432813341087736, 0, 0.999062952337657 }, { 1.17483083909748, 0, 0.0632422426735528, 0, 1.17863922736637, 0, -0.0412313298290328, 0, 0.999149573988156 }, { 1.17495935278079, 0, 0.0608089005995607, 0, 1.17863922736637, 0, -0.0391618900171161, 0, 0.999232869645304 }, { 1.08768545026057, 0, 0.0533902652180259, 0, 1.09086229369746, 0, -0.0369465132337295, 0, 0.999317200485891 }, { 1.08779857955566, 0, 0.0510331886350426, 0, 1.09086229369746, 0, -0.0347809642432635, 0, 0.999394905466376 }, { 1.087907978895, 0, 0.0486457013570297, 0, 1.09086229369746, 0, -0.0325875332432612, 0, 0.999468847899814 }, { 0.999544683753878, 0, 0.0301733129823878, 0, 1, 0, -0.0301733129823878, 0, 0.999544683753878 }, { 0.99961344795165, 0, 0.0278017758618714, 0, 1, 0, -0.0278017758618714, 0, 0.99961344795165 }, { 0.99967311272398, 0, 0.0255654584060281, 0, 1, 0, -0.0255654584060281, 0, 0.99967311272398 }, { 0.999726257106781, 0, 0.0233985409435837, 0, 1, 0, -0.0233985409435837, 0, 0.999726257106781 }, { 0.999777980926191, 0, 0.0210698236128495, 0, 1, 0, -0.0210698236128495, 0, 0.999777980926191 }, { 0.999824370565083, 0, 0.0187401672011997, 0, 1, 0, -0.0187401672011997, 0, 0.999824370565083 }, { 0.999864648628574, 0, 0.0164528174236516, 0, 1, 0, -0.0164528174236516, 0, 0.999864648628574 }, { 0.999898584266111, 0, 0.0142384457001123, 0, 1, 0, -0.0142384457001123, 0, 0.999898584266111 }, { 0.99992679947609, 0, 0.012101622946867, 0, 1, 0, -0.012101622946867, 0, 0.99992679947609 }, { 0.999950931971901, 0, 0.00991158199130606, 0, 1, 0, -0.00991158199130606, 0, 0.999950931971901 }, { 0.999969466661731, 0, 0.0078134488945587, 0, 1, 0, -0.0078134488945587, 0, 0.999969466661731 }, { 0.999983311332376, 0, 0.00577218191185682, 0, 1, 0, -0.00577218191185682, 0, 0.999983311332376 }, { 0.999992884273657, 0, 0.00379307836808589, 0, 1, 0, -0.00379307836808589, 0, 0.999992884273657 }, { 0.999998182636757, 0, 0.00189881521781638, 0, 1, 0, -0.00189881521781638, 0, 0.999998182636757 }, { 0.999999999672164, 0, -1.81062368878642E-05, 0, 1, 0, 1.81062368878642E-05, 0, 0.999999999672164 },    // Cos(theta) = 0.9977324
            { 248.992155658151, 0, 22.4251636811089, 0, 251.011696904755, 0, -0.089700590291808, 0, 0.99596879456788 }, { 248.99207590249, 0, 22.425156452099, 0, 251.011712013074, 0, -0.0897009201725221, 0, 0.995968734661311 }, { 248.992020986025, 0, 22.4251525337653, 0, 251.011455338778, 0, -0.0897006822713215, 0, 0.995968717284845 }, { 219.610796471588, 0, 19.7789691777237, 0, 221.392038396609, 0, -0.0897006635986385, 0, 0.995968781255328 }, { 123.53061165283, 0, 11.1256284766279, 0, 124.532669076351, 0, -0.089700740916776, 0, 0.995968706634794 }, { 79.0590596845887, 0, 7.12035358674139, 0, 79.7003271181831, 0, -0.0897005023236075, 0, 0.995968810542928 }, { 54.9014819212385, 0, 4.94463141788566, 0, 55.3467105889261, 0, -0.0897005389770249, 0, 0.99596880388666 }, { 40.3349373327833, 0, 3.63271313291925, 0, 40.6620395656701, 0, -0.0897002384189804, 0, 0.995968858467981 }, { 30.8804785155844, 0, 2.78120868003416, 0, 31.1308190482234, 0, -0.089699751274478, 0, 0.995968886353486 }, { 24.3982506738885, 0, 2.19739504109018, 0, 24.5960518883142, 0, -0.0896990702129271, 0, 0.995968888873864 }, { 19.761338265484, 0, 1.77977714295545, 0, 19.9214950036819, 0, -0.0896981505578067, 0, 0.995968995300319 }, { 16.3303099302517, 0, 1.47076583760018, 0, 16.4625977536795, 0, -0.0896971616072732, 0, 0.99596905372918 }, { 13.7205027221681, 0, 1.23570917407688, 0, 13.8315848195291, 0, -0.0896950770642868, 0, 0.995969250525376 }, { 11.6892059792231, 0, 1.05276528720627, 0, 11.7838048734902, 0, -0.0896924720404482, 0, 0.995969541823714 }, { 10.0773174190279, 0, 0.907586598175633, 0, 10.1587329375491, 0, -0.0896876805334628, 0, 0.995969927224326 }, { 8.77669927802852, 0, 0.790445608271354, 0, 8.84751690340291, 0, -0.0896789471782718, 0, 0.995970664784051 }, { 7.71219063603365, 0, 0.69457059567557, 0, 7.77432301205431, 0, -0.0896589153571918, 0, 0.995972483890392 }, { 6.83015621653173, 0, 0.615120584559448, 0, 6.88513929253146, 0, -0.0895959324879157, 0, 0.995978217721218 }, { 6.0926909464271, 0, 0.548653319408059, 0, 6.14163115341471, 0, -0.0892842291093821, 0, 0.996006245645342 }, { 5.48160058810477, 0, 0.493292634921361, 0, 5.52562508736872, 0, -0.0862977773415098, 0, 0.996269371018336 }, { 4.97271360880594, 0, 0.447237033233825, 0, 5.01231662350208, 0, -0.0847566449831073, 0, 0.996401695845532 }, { 4.52699233577691, 0, 0.407630676364455, 0, 4.56300255017582, 0, -0.0895602646181244, 0, 0.995981414808934 }, { 4.12323912711632, 0, 0.371227700665625, 0, 4.1559331600727, 0, -0.0894368423906243, 0, 0.995992570221869 }, { 3.77178846075327, 0, 0.339496416300512, 0, 3.80154264959866, 0, -0.0891380378359323, 0, 0.996019320512567 }, { 3.46561797993965, 0, 0.31175680418041, 0, 3.4928603235486, 0, -0.0882923123121164, 0, 0.99609463140169 }, { 3.20138420892633, 0, 0.287437380149178, 0, 3.2264122647246, 0, -0.0857444697433966, 0, 0.996317114100209 }, { 2.97170195593925, 0, 0.266292344333641, 0, 2.99468572850702, 0, -0.0837895984401771, 0, 0.996483492366318 }, { 2.76591590897283, 0, 0.248051114931078, 0, 2.78715862920226, 0, -0.0858548729414885, 0, 0.996307696537167 }, { 2.57975933854442, 0, 0.231202328929576, 0, 2.59941082300423, 0, -0.086084877157664, 0, 0.996287790582849 }, { 2.41434038945082, 0, 0.215403001257066, 0, 2.43244964794563, 0, -0.082747690656697, 0, 0.996570530890536 }, { 2.2661369244878, 0, 0.201621605798503, 0, 2.28292805627022, 0, -0.081973673858863, 0, 0.996634506993384 }, { 2.1338985335706, 0, 0.189525190107887, 0, 2.14950432753565, 0, -0.0821244267185032, 0, 0.996622082629132 }, { 2.01428006787545, 0, 0.177942550383584, 0, 2.02865867468597, 0, -0.0800980759260439, 0, 0.996787023223968 }, { 1.90537733178723, 0, 0.167352541072101, 0, 1.91881832376597, 0, -0.0786827349895637, 0, 0.996899751543066 }, { 1.80859722517386, 0, 0.157848057234872, 0, 1.82114036852441, 0, -0.07731701800175, 0, 0.997006582792552 }, { 1.71938876713321, 0, 0.148829368353507, 0, 1.73104995428124, 0, -0.0757579676240139, 0, 0.997126250330153 }, { 1.63930030340634, 0, 0.140421907018043, 0, 1.65011972758231, 0, -0.0736151555131484, 0, 0.997286770154511 }, { 1.56616165124789, 0, 0.132749802194849, 0, 1.57632624567263, 0, -0.0722763148624954, 0, 0.997384686862533 }, { 1.49978791473843, 0, 0.125145621373042, 0, 1.5090825726712, 0, -0.0697292861685511, 0, 0.997565916999167 }, { 1.43934258348546, 0, 0.118196200241768, 0, 1.44822952204243, 0, -0.0678540308454843, 0, 0.997695251394906 }, { 1.38398016602807, 0, 0.111435383805172, 0, 1.39237033550066, 0, -0.0653467154860328, 0, 0.997862601181667 }, { 1.33403694776631, 0, 0.105025616560511, 0, 1.3419004095895, 0, -0.0630541231890612, 0, 0.998010058946073 }, { 1.24605530691021, 0, 0.0958034146253757, 0, 1.25325159503567, 0, -0.0602634253345785, 0, 0.998182540961797 }, { 1.24629351193488, 0, 0.0926516577459142, 0, 1.25325159503567, 0, -0.057738688926307, 0, 0.998331675107128 }, { 1.1731178680223, 0, 0.0846136001447582, 0, 1.17957769984822, 0, -0.0550978455906698, 0, 0.998481004173804 }, { 1.17336770278109, 0, 0.0810757365971581, 0, 1.17957769984822, 0, -0.0520867247633183, 0, 0.998642626591973 }, { 1.08614117371173, 0, 0.0712587256433931, 0, 1.09146090587448, 0, -0.0492291720001685, 0, 0.998787556005664 }, { 1.08634591756158, 0, 0.0680656224872983, 0, 1.09146090587448, 0, -0.0462929471891904, 0, 0.998927922469384 }, { 1.08654803668647, 0, 0.0647585560137954, 0, 1.09146090587448, 0, -0.0432520755685774, 0, 0.999064175083743 }, { 0.999189660041087, 0, 0.0402493284636116, 0, 1, 0, -0.0402493284636116, 0, 0.999189660041087 }, { 0.999304300563859, 0, 0.0372942517055621, 0, 1, 0, -0.0372942517055621, 0, 0.999304300563859 }, { 0.999416754242743, 0, 0.0341487484751814, 0, 1, 0, -0.0341487484751814, 0, 0.999416754242743 }, { 0.999519165351227, 0, 0.0310070010530288, 0, 1, 0, -0.0310070010530288, 0, 0.999519165351227 }, { 0.999609832661057, 0, 0.0279328971434352, 0, 1, 0, -0.0279328971434352, 0, 0.999609832661057 }, { 0.999688776262196, 0, 0.0249475919174796, 0, 1, 0, -0.0249475919174796, 0, 0.999688776262196 }, { 0.999758733191452, 0, 0.0219669711851112, 0, 1, 0, -0.0219669711851112, 0, 0.999758733191452 }, { 0.999819678023827, 0, 0.0189924389737153, 0, 1, 0, -0.0189924389737153, 0, 0.999819678023827 }, { 0.999870872145038, 0, 0.0160727739706449, 0, 1, 0, -0.0160727739706449, 0, 0.999870872145038 }, { 0.999912564937754, 0, 0.0132237449943218, 0, 1, 0, -0.0132237449943218, 0, 0.999912564937754 }, { 0.999945194029965, 0, 0.0104708758562036, 0, 1, 0, -0.0104708758562036, 0, 0.999945194029965 }, { 0.999969968981747, 0, 0.00775053918446937, 0, 1, 0, -0.00775053918446937, 0, 0.999969968981747 }, { 0.999987422397203, 0, 0.00501537881278638, 0, 1, 0, -0.00501537881278638, 0, 0.999987422397203 }, { 0.999997082642723, 0, 0.00241619046636337, 0, 1, 0, -0.00241619046636337, 0, 0.999997082642723 }, { 0.999999998720993, 0, -3.57632051870558E-05, 0, 1, 0, 3.57632051870558E-05, 0, 0.999999998720993 },    // Cos(theta) = 0.9959688
            { 248.42518470757, 0, 28.0155897562969, 0, 251.584625611888, 0, -0.112062114080682, 0, 0.993701248932704 }, { 248.425159022269, 0, 28.0155621343652, 0, 251.584206149819, 0, -0.112062281140108, 0, 0.993701210767911 }, { 248.425138272848, 0, 28.0155860536151, 0, 251.584206149819, 0, -0.112062376817165, 0, 0.993701127770184 }, { 219.110786904204, 0, 24.7097253091199, 0, 221.897255372021, 0, -0.112062273876655, 0, 0.993701212427251 }, { 123.249359611825, 0, 13.8991676734934, 0, 124.816826954464, 0, -0.112062259349749, 0, 0.993701215745931 }, { 78.8790717311594, 0, 8.89540758696157, 0, 79.8822166321321, 0, -0.112062252086296, 0, 0.993701217405271 }, { 54.7764845639701, 0, 6.17729294247835, 0, 55.4730107073432, 0, -0.112061803004384, 0, 0.99370125885782 }, { 40.2431269615648, 0, 4.53832459161626, 0, 40.7548018320572, 0, -0.112061288551339, 0, 0.993701315243898 }, { 30.8101909804836, 0, 3.47454453728124, 0, 31.2018775485209, 0, -0.112060680925666, 0, 0.993701331774272 }, { 24.3427905646392, 0, 2.7451971512388, 0, 24.6521339815342, 0, -0.112059288846295, 0, 0.993701527508516 }, { 19.7164014890864, 0, 2.22346664491776, 0, 19.9669288297873, 0, -0.112057818120855, 0, 0.993701680064599 }, { 16.2931746730953, 0, 1.83741635385568, 0, 16.5001008969658, 0, -0.112055309971183, 0, 0.993702008462177 }, { 13.689332334228, 0, 1.54377234464225, 0, 13.8630963716843, 0, -0.112052470206054, 0, 0.993702290317692 }, { 11.6627283413845, 0, 1.31522245124055, 0, 11.8106327280404, 0, -0.112047920015778, 0, 0.993702779435822 }, { 10.0544319245942, 0, 1.13384410588385, 0, 10.1818315949612, 0, -0.112040672810591, 0, 0.993703639971581 }, { 8.75685194186762, 0, 0.987507186853715, 0, 8.86760374152129, 0, -0.11202802805816, 0, 0.993705060577835 }, { 7.6947569766555, 0, 0.867726500769722, 0, 7.79196657141918, 0, -0.112000128567881, 0, 0.993708252162503 }, { 6.81480114485407, 0, 0.768468320395584, 0, 6.90084209118349, 0, -0.111914021546847, 0, 0.993717816527631 }, { 6.07948520783426, 0, 0.685497623494054, 0, 6.15612396927321, 0, -0.111459714832678, 0, 0.993768976162898 }, { 5.47412665999213, 0, 0.616767060237599, 0, 5.54266883840413, 0, -0.107293179091147, 0, 0.994227381114197 }, { 4.95901023626925, 0, 0.558535334546549, 0, 5.02101204639553, 0, -0.106613347816735, 0, 0.99430056638872 }, { 4.51561311792484, 0, 0.509054264345128, 0, 4.57198136328139, 0, -0.111397895255796, 0, 0.993775864645448 }, { 4.11420787655075, 0, 0.463803632742092, 0, 4.16537051717124, 0, -0.111703785296493, 0, 0.99374152361646 }, { 3.76382832134056, 0, 0.424186898748423, 0, 3.81037768547087, 0, -0.111303993800627, 0, 0.99378647903034 }, { 3.45886015770144, 0, 0.38956351808982, 0, 3.50140875119595, 0, -0.110146755357464, 0, 0.993915411150993 }, { 3.19662121154664, 0, 0.359299195792114, 0, 3.23558022962424, 0, -0.106711500775222, 0, 0.994289997302334 }, { 2.96465742901918, 0, 0.33277732240134, 0, 3.00064813275538, 0, -0.105467489315733, 0, 0.994422708655098 }, { 2.75877767150489, 0, 0.309637415579144, 0, 2.79199160318242, 0, -0.106716645706289, 0, 0.994289428997642 }, { 2.57541424685341, 0, 0.288935101102184, 0, 2.60613668375025, 0, -0.107302537737064, 0, 0.994226374483542 }, { 2.40983086179003, 0, 0.269289360133499, 0, 2.43812643858129, 0, -0.103941574943957, 0, 0.994583441997543 }, { 2.26123205486647, 0, 0.251979746665243, 0, 2.28737858488311, 0, -0.102721708229455, 0, 0.994710181196071 }, { 2.12954786389554, 0, 0.236550507287281, 0, 2.15395098359619, 0, -0.101744941635675, 0, 0.994810514451358 }, { 2.01068460985436, 0, 0.222496395475542, 0, 2.03337240946982, 0, -0.100652555589903, 0, 0.994921648866042 }, { 1.9018634945508, 0, 0.209149829424113, 0, 1.92295776854149, 0, -0.098294114080124, 0, 0.995157395562231 }, { 1.80496547555678, 0, 0.197158736223628, 0, 1.82440305882368, 0, -0.0964136042140144, 0, 0.995341353330797 }, { 1.71669229532257, 0, 0.186111050661838, 0, 1.7348507202758, 0, -0.0948299495211523, 0, 0.995493500646313 }, { 1.63607575901362, 0, 0.1754304686011, 0, 1.65309234783632, 0, -0.0920538651432542, 0, 0.995754054552248 }, { 1.56361465527429, 0, 0.165758735849791, 0, 1.57946166183412, 0, -0.0899604678509117, 0, 0.995945278953601 }, { 1.49730454611003, 0, 0.156410382881894, 0, 1.51190270925205, 0, -0.0872264660633569, 0, 0.996188555082172 }, { 1.43689371714447, 0, 0.147638402876559, 0, 1.4507128700034, 0, -0.0845599828319288, 0, 0.99641842497305 }, { 1.38192915576111, 0, 0.139150057795433, 0, 1.39474355909022, 0, -0.0815245459653619, 0, 0.996671349585812 }, { 1.33178966157888, 0, 0.131156112659176, 0, 1.34396164122547, 0, -0.078704247622278, 0, 0.996898023765739 }, { 1.24416656625534, 0, 0.119736477818581, 0, 1.2550583534863, 0, -0.0753260055780153, 0, 0.997158976957121 }, { 1.24454157421047, 0, 0.115773100817655, 0, 1.2550583534863, 0, -0.0721495935425447, 0, 0.997393797218061 }, { 1.17127039713589, 0, 0.105241627148282, 0, 1.18087622817165, 0, -0.0685563118499744, 0, 0.997647271021615 }, { 1.17162194012064, 0, 0.101253100203492, 0, 1.18087622817165, 0, -0.0651591457955631, 0, 0.99787491385612 }, { 1.08454641219284, 0, 0.0889949917504083, 0, 1.09233887633971, 0, -0.0615724229515053, 0, 0.998102631431124 }, { 1.08487764374954, 0, 0.0848616249538389, 0, 1.09233887633971, 0, -0.0577686540534515, 0, 0.998329996634211 }, { 1.0851859145925, 0, 0.0808233247035682, 0, 1.09233887633971, 0, -0.0540526566834278, 0, 0.998538036338868 }, { 0.998735335531377, 0, 0.0502767986181785, 0, 1, 0, -0.0502767986181785, 0, 0.998735335531377 }, { 0.998924491846366, 0, 0.0463665573887033, 0, 1, 0, -0.0463665573887033, 0, 0.998924491846366 }, { 0.999095018534816, 0, 0.0425346852608701, 0, 1, 0, -0.0425346852608701, 0, 0.999095018534816 }, { 0.999246322866406, 0, 0.0388176487613246, 0, 1, 0, -0.0388176487613246, 0, 0.999246322866406 }, { 0.999386622998352, 0, 0.0350190310730727, 0, 1, 0, -0.0350190310730727, 0, 0.999386622998352 }, { 0.999514160981746, 0, 0.0311679392567007, 0, 1, 0, -0.0311679392567007, 0, 0.999514160981746 }, { 0.999624471068807, 0, 0.0274025028767569, 0, 1, 0, -0.0274025028767569, 0, 0.999624471068807 }, { 0.999718695010416, 0, 0.0237183428714743, 0, 1, 0, -0.0237183428714743, 0, 0.999718695010416 }, { 0.999797195552924, 0, 0.0201379818498808, 0, 1, 0, -0.0201379818498808, 0, 0.999797195552924 }, { 0.999863725935344, 0, 0.0165061230092481, 0, 1, 0, -0.0165061230092481, 0, 0.999863725935344 }, { 0.999915979165199, 0, 0.0129682514466936, 0, 1, 0, -0.0129682514466936, 0, 0.999915979165199 }, { 0.999954009514317, 0, 0.00958871993841067, 0, 1, 0, -0.00958871993841067, 0, 0.999954009514317 }, { 0.999979930397014, 0, 0.00633687350598863, 0, 1, 0, -0.00633687350598863, 0, 0.999979930397014 }, { 0.999995009308139, 0, 0.00316187558197846, 0, 1, 0, -0.00316187558197846, 0, 0.999995009308139 }, { 0.999999998682063, 0, -3.6303401382059E-05, 0, 1, 0, 3.6303401382059E-05, 0, 0.999999998682063 },    // Cos(theta) = 0.9937012
            { 247.732282475208, 0, 33.5952732355135, 0, 252.288253254026, 0, -0.134381476064411, 0, 0.990929685303237 }, { 247.732367909275, 0, 33.5952844509165, 0, 252.288171904992, 0, -0.13438118880478, 0, 0.990929764674246 }, { 247.732314398685, 0, 33.5952790996265, 0, 252.287884158058, 0, -0.134381460190195, 0, 0.990929627851321 }, { 218.499747216692, 0, 29.6310143581401, 0, 222.517779415323, 0, -0.134381014937786, 0, 0.990929750876294 }, { 122.905692199038, 0, 16.6673874968054, 0, 125.165850927618, 0, -0.134380914396897, 0, 0.990929778656072 }, { 78.6591183639414, 0, 10.6670549174949, 0, 80.1056118953325, 0, -0.13438049484803, 0, 0.990929770902555 }, { 54.6237455404635, 0, 7.40758842878154, 0, 55.6281527129622, 0, -0.13438033685517, 0, 0.990929814556316 }, { 40.1308968671415, 0, 5.44219414272354, 0, 40.8687979146554, 0, -0.134379400238606, 0, 0.990929949668375 }, { 30.7243239796193, 0, 4.1665549851569, 0, 31.289125101762, 0, -0.13437823381369, 0, 0.990930148274086 }, { 24.2749021106991, 0, 3.29193983706474, 0, 24.7210687248711, 0, -0.134376488335531, 0, 0.990930321352321 }, { 19.6615253283462, 0, 2.66631118386041, 0, 20.0227291026331, 0, -0.134373794896579, 0, 0.990930756335217 }, { 16.2478227630496, 0, 2.2033718880312, 0, 16.5462128361089, 0, -0.134369903280606, 0, 0.990931274985065 }, { 13.6513028070225, 0, 1.85125274412461, 0, 13.9018477536475, 0, -0.134364282050467, 0, 0.990932024091995 }, { 11.6302469185309, 0, 1.5771724118779, 0, 11.8435521436217, 0, -0.134357650865331, 0, 0.990932866625013 }, { 10.0264761877959, 0, 1.35967312136502, 0, 10.2102359458714, 0, -0.134347375220204, 0, 0.990934282932834 }, { 8.73251007874819, 0, 1.18418483921011, 0, 8.89229808206239, 0, -0.134329028965019, 0, 0.990936815060998 }, { 7.67347905372282, 0, 1.04055348574871, 0, 7.81373433474065, 0, -0.134291699665315, 0, 0.990941867519383 }, { 6.79618906256743, 0, 0.92156799961864, 0, 6.92014076154772, 0, -0.134176869258134, 0, 0.990957358716845 }, { 6.06379965873997, 0, 0.822161466990821, 0, 6.17408933123775, 0, -0.133512291984928, 0, 0.991047171051547 }, { 5.46089409398472, 0, 0.739917877758531, 0, 5.55991966709286, 0, -0.129067974634756, 0, 0.991635757722639 }, { 4.94342390811982, 0, 0.669600933820247, 0, 5.03283722252669, 0, -0.128554726032612, 0, 0.991702394395263 }, { 4.49959214288843, 0, 0.609811553392173, 0, 4.58079528288191, 0, -0.132390511239692, 0, 0.991197624877073 }, { 4.10318959082262, 0, 0.556203753863457, 0, 4.17691502105859, 0, -0.133907851778626, 0, 0.990993777217271 }, { 3.75401003156747, 0, 0.508732918466427, 0, 3.8211603857381, 0, -0.133384957470093, 0, 0.991064357920948 }, { 3.45067981560052, 0, 0.467265631437296, 0, 3.51194733836025, 0, -0.131836094263577, 0, 0.991271501669152 }, { 3.1891256385251, 0, 0.431060685952265, 0, 3.24544912376837, 0, -0.128201871716345, 0, 0.991748091510631 }, { 2.95643905226885, 0, 0.399155937307912, 0, 3.00822948357398, 0, -0.127135974772092, 0, 0.991885229256092 }, { 2.75065125962766, 0, 0.371146393887054, 0, 2.79838226465131, 0, -0.12760252817721, 0, 0.991825368136375 }, { 2.56941612168704, 0, 0.346394790688068, 0, 2.61359430166533, 0, -0.127775116828234, 0, 0.991803162057336 }, { 2.40407109706402, 0, 0.323126380709031, 0, 2.44496002121781, 0, -0.125209246592744, 0, 0.992130374701715 }, { 2.25572167235145, 0, 0.302258891760458, 0, 2.29344333268283, 0, -0.123390853799789, 0, 0.992358151273052 }, { 2.12448399639172, 0, 0.283563878378957, 0, 2.1596091250478, 0, -0.121392814377993, 0, 0.992604537941431 }, { 2.00591537431444, 0, 0.266883491767844, 0, 2.03846988229552, 0, -0.12072009283906, 0, 0.992686542591546 }, { 1.89795320056506, 0, 0.250876858582063, 0, 1.92825387038806, 0, -0.117774729103435, 0, 0.993040292153491 }, { 1.80067545255209, 0, 0.236391441161193, 0, 1.82896603716241, 0, -0.115548455211248, 0, 0.993301881359971 }, { 1.7132997977439, 0, 0.223162660957941, 0, 1.7392928147706, 0, -0.113421368641976, 0, 0.99354698922124 }, { 1.63265486923097, 0, 0.210460084265819, 0, 1.65720071241846, 0, -0.110509183296057, 0, 0.993875120155191 }, { 1.56031524361264, 0, 0.198697945156458, 0, 1.58295281089598, 0, -0.107590695780189, 0, 0.994195264666092 }, { 1.49452060027869, 0, 0.187656449422655, 0, 1.51541401569273, 0, -0.104666555485908, 0, 0.994507309859303 }, { 1.43415136132043, 0, 0.176996626697741, 0, 1.45376408596455, 0, -0.101254593306534, 0, 0.994860563805492 }, { 1.3795439474688, 0, 0.166984425859367, 0, 1.39772827202591, 0, -0.0979316087864343, 0, 0.995193110032783 }, { 1.32957861381321, 0, 0.157097298132226, 0, 1.34654743021238, 0, -0.0940451356029233, 0, 0.995567951744911 }, { 1.24186531201456, 0, 0.143785269174743, 0, 1.2569821069559, 0, -0.0904562761426759, 0, 0.995900463668752 }, { 1.24244129151244, 0, 0.138720325368912, 0, 1.2569821069559, 0, -0.0863947055175067, 0, 0.996261034315675 }, { 1.16952196368308, 0, 0.126235818738628, 0, 1.18251697016822, 0, -0.0822394181230672, 0, 0.996612595116908 }, { 1.17004068740069, 0, 0.121334221760592, 0, 1.18251697016821, 0, -0.0780627250866284, 0, 0.996948478341698 }, { 1.0828394695983, 0, 0.106312214048353, 0, 1.09343469029532, 0, -0.0735916411100785, 0, 0.997288452332292 }, { 1.08328759887247, 0, 0.101644699553378, 0, 1.09343469029532, 0, -0.0692931143378423, 0, 0.997596363442785 }, { 1.08373296317179, 0, 0.0967808366804856, 0, 1.09343469029532, 0, -0.0648142422811152, 0, 0.997897366064224 }, { 0.998185932476173, 0, 0.0602066777549983, 0, 1, 0, -0.0602066777549983, 0, 0.998185932476173 }, { 0.998449160995026, 0, 0.0556712419288096, 0, 1, 0, -0.0556712419288096, 0, 0.998449160995026 }, { 0.998692438492435, 0, 0.0511214129698466, 0, 1, 0, -0.0511214129698466, 0, 0.998692438492435 }, { 0.99892009460261, 0, 0.0464613405774864, 0, 1, 0, -0.0464613405774864, 0, 0.99892009460261 }, { 0.999124543476082, 0, 0.041834951137903, 0, 1, 0, -0.041834951137903, 0, 0.999124543476082 }, { 0.999302286570963, 0, 0.0373475476729571, 0, 1, 0, -0.0373475476729571, 0, 0.999302286570963 }, { 0.999459368486786, 0, 0.0328796688437217, 0, 1, 0, -0.0328796688437217, 0, 0.999459368486786 }, { 0.999596657933245, 0, 0.0283983165957052, 0, 1, 0, -0.0283983165957052, 0, 0.999596657933245 }, { 0.999710911886906, 0, 0.0240459208698034, 0, 1, 0, -0.0240459208698034, 0, 0.999710911886906 }, { 0.999804173701858, 0, 0.0197901192443663, 0, 1, 0, -0.0197901192443663, 0, 0.999804173701858 }, { 0.999876803190997, 0, 0.0156985363977407, 0, 1, 0, -0.0156985363977407, 0, 0.999876803190997 }, { 0.999932999218513, 0, 0.0115729125171438, 0, 1, 0, -0.0115729125171438, 0, 0.999932999218513 }, { 0.999971659342934, 0, 0.00753467132736322, 0, 1, 0, -0.00753467132736322, 0, 0.999971659342934 }, { 0.999993476742426, 0, 0.00361659040593827, 0, 1, 0, -0.00361659040593827, 0, 0.999993476742426 }, { 0.999999997842743, 0, -4.64462790567565E-05, 0, 1, 0, 4.64462790567565E-05, 0, 0.999999997842743 },    // Cos(theta) = 0.9909297
            { 246.913549844509, 0, 39.1622645478173, 0, 253.124779161325, 0, -0.156649581946376, 0, 0.987654220873836 }, { 246.913509893761, 0, 39.1622567707461, 0, 253.124509399682, 0, -0.156649227700349, 0, 0.987654336145833 }, { 246.913508741043, 0, 39.1622603132059, 0, 253.124509399682, 0, -0.156649241870193, 0, 0.987654331534957 }, { 217.777505004936, 0, 34.5410789052439, 0, 223.2557052627, 0, -0.15664843981153, 0, 0.987654467162826 }, { 122.49943020991, 0, 19.4292885792886, 0, 125.580992606126, 0, -0.156649128511439, 0, 0.987654368421948 }, { 78.3991330619891, 0, 12.4346618150692, 0, 80.3711983222056, 0, -0.156648237160061, 0, 0.987654470424461 }, { 54.4431738505855, 0, 8.6350729318121, 0, 55.8126143510228, 0, -0.156647821960781, 0, 0.987654542848577 }, { 39.9983529057607, 0, 6.34401851977403, 0, 41.004293073747, 0, -0.156646387880932, 0, 0.987654758768908 }, { 30.622812668107, 0, 4.85698659380014, 0, 31.3928506783892, 0, -0.156644283542754, 0, 0.987655130099689 }, { 24.1947374985387, 0, 3.8374444236446, 0, 24.8030343274132, 0, -0.156641071028528, 0, 0.987655611280815 }, { 19.5965566618108, 0, 3.10813538225607, 0, 20.0890931690939, 0, -0.156637145741528, 0, 0.987656261677615 }, { 16.1942450217296, 0, 2.56849980171159, 0, 16.6010529136945, 0, -0.156631782091259, 0, 0.987657066630741 }, { 13.606276565305, 0, 2.15802194881682, 0, 13.9478551298772, 0, -0.156623653715159, 0, 0.98765833225729 }, { 11.5919802191424, 0, 1.83853097994064, 0, 11.8828171654661, 0, -0.156613293425873, 0, 0.987660010437919 }, { 9.99351291727145, 0, 1.5849946153799, 0, 10.2440241639243, 0, -0.156597946357564, 0, 0.987662495719766 }, { 8.70390421177675, 0, 1.38044433220823, 0, 8.92168079544184, 0, -0.156573976114884, 0, 0.987666218165537 }, { 7.64825124011728, 0, 1.21298514377748, 0, 7.83960377438143, 0, -0.156524099326624, 0, 0.98767416357836 }, { 6.77414341378425, 0, 1.07433198166298, 0, 6.94318097138945, 0, -0.156371874938129, 0, 0.9876982464889 }, { 6.04539546296262, 0, 0.958627003014582, 0, 6.19597424797226, 0, -0.155375794114139, 0, 0.987855437837603 }, { 5.44407109118892, 0, 0.862759575865417, 0, 5.57920844664682, 0, -0.151021068229957, 0, 0.98853051077922 }, { 4.92578147098451, 0, 0.780410856901924, 0, 5.04765259347328, 0, -0.150528776587907, 0, 0.988605637670401 }, { 4.48142719204158, 0, 0.710195730190372, 0, 4.59198743668176, 0, -0.15343996384068, 0, 0.988157955499385 }, { 4.09017653523094, 0, 0.648436618231825, 0, 4.19076330000982, 0, -0.156036293200217, 0, 0.987751340895002 }, { 3.74244254322232, 0, 0.593121546716482, 0, 3.83407110767951, 0, -0.155359780275747, 0, 0.987857972452676 }, { 3.44107096099675, 0, 0.544903151301524, 0, 3.52475784669422, 0, -0.15330925768249, 0, 0.988178265060229 }, { 3.1797547433258, 0, 0.502724748662225, 0, 3.25651465590185, 0, -0.149899790135127, 0, 0.98870122662256 }, { 2.9468450630737, 0, 0.465368926369849, 0, 3.01748174439345, 0, -0.14876737873937, 0, 0.988872209000642 }, { 2.74162691804599, 0, 0.432547270325872, 0, 2.80677597575594, 0, -0.1484629405985, 0, 0.988917935914207 }, { 2.5616988253641, 0, 0.403585445115513, 0, 2.6219831954381, 0, -0.147732132502228, 0, 0.989027439653852 }, { 2.39730899024008, 0, 0.376890549153473, 0, 2.45305980503435, 0, -0.146440446782649, 0, 0.989219489454954 }, { 2.24932638967667, 0, 0.352448707843022, 0, 2.30089448522073, 0, -0.143929722503188, 0, 0.989587920749588 }, { 2.11826761144362, 0, 0.330632795791863, 0, 2.16605435320115, 0, -0.141455912488468, 0, 0.989944534793514 }, { 2.00005711325718, 0, 0.310993697934313, 0, 2.04446888703552, 0, -0.140271713922563, 0, 0.990113013565718 }, { 1.89301502983175, 0, 0.292603952472095, 0, 1.93438156363518, 0, -0.137498692000526, 0, 0.990501894834313 }, { 1.79584090581918, 0, 0.275567265053018, 0, 1.83419792176563, 0, -0.134621856473417, 0, 0.99089709388802 }, { 1.70889828861242, 0, 0.260128057513847, 0, 1.74427161981705, 0, -0.131934478041181, 0, 0.991258436107316 }, { 1.62894987698523, 0, 0.245463663304138, 0, 1.66198644388103, 0, -0.128875972406617, 0, 0.991660726200616 }, { 1.55685270204621, 0, 0.231682512640307, 0, 1.5872211748456, 0, -0.125312197619988, 0, 0.992117372186665 }, { 1.49148284615012, 0, 0.218801698151573, 0, 1.51962530566908, 0, -0.121965844988291, 0, 0.99253431668285 }, { 1.43128712018449, 0, 0.206368366688271, 0, 1.45730925061032, 0, -0.117877218427647, 0, 0.993028191546773 }, { 1.37687790921993, 0, 0.194609478552682, 0, 1.40110520489102, 0, -0.114084437167553, 0, 0.993471088498137 }, { 1.28130251937693, 0, 0.177957926307927, 0, 1.30252045427234, 0, -0.109607725964257, 0, 0.993974920720689 }, { 1.28206549112587, 0, 0.172375797103456, 0, 1.30252045427234, 0, -0.105277637998787, 0, 0.994442917768747 }, { 1.20258991835946, 0, 0.156994121845301, 0, 1.22036425552857, 0, -0.100511411841333, 0, 0.994935880761287 }, { 1.20329658218944, 0, 0.151482933655057, 0, 1.22036425552857, 0, -0.0959521610089598, 0, 0.995385948500126 }, { 1.13667290672747, 0, 0.137221500199577, 0, 1.15184827984615, 0, -0.0908694366566509, 0, 0.995862787118779 }, { 1.1373459493967, 0, 0.131526996110336, 0, 1.15184827984615, 0, -0.0858807298901155, 0, 0.996305444542495 }, { 1.05788118150403, 0, 0.11478660313966, 0, 1.06959359810922, 0, -0.080713833277528, 0, 0.996737330854636 }, { 1.05847936322731, 0, 0.109132670697097, 0, 1.06959359810922, 0, -0.0753870814805286, 0, 0.997154335030467 }, { 1.05903523861761, 0, 0.103599294424099, 0, 1.06959359810922, 0, -0.0701746670933107, 0, 0.997534686272308 }, { 0.997897720105196, 0, 0.0648092242277105, 0, 1, 0, -0.0648092242277105, 0, 0.997897720105196 }, { 0.998233942254927, 0, 0.0594050902620108, 0, 1, 0, -0.0594050902620108, 0, 0.998233942254927 }, { 0.998535284659706, 0, 0.0541044776656434, 0, 1, 0, -0.0541044776656434, 0, 0.998535284659706 }, { 0.99880596783087, 0, 0.0488522976572587, 0, 1, 0, -0.0488522976572587, 0, 0.99880596783087 }, { 0.999052185775508, 0, 0.0435287141066394, 0, 1, 0, -0.0435287141066394, 0, 0.999052185775508 }, { 0.999267555172971, 0, 0.0382681265083313, 0, 1, 0, -0.0382681265083313, 0, 0.999267555172971 }, { 0.999451004456215, 0, 0.0331326452406376, 0, 1, 0, -0.0331326452406376, 0, 0.999451004456215 }, { 0.999604857556799, 0, 0.028107754418933, 0, 1, 0, -0.028107754418933, 0, 0.999604857556799 }, { 0.999733649599472, 0, 0.0230766847817498, 0, 1, 0, -0.0230766847817498, 0, 0.999733649599472 }, { 0.999835197937596, 0, 0.018151102372873, 0, 1, 0, -0.018151102372873, 0, 0.999835197937596 }, { 0.999910553712598, 0, 0.0133755321533866, 0, 1, 0, -0.0133755321533866, 0, 0.999910553712598 }, { 0.999960719241303, 0, 0.00885997006724855, 0, 1, 0, -0.00885997006724855, 0, 0.999960719241303 }, { 0.999990418243554, 0, 0.00437246010514481, 0, 1, 0, -0.00437246010514481, 0, 0.999990418243554 }, { 0.999999996050564, 0, -6.28445411412946E-05, 0, 1, 0, 6.28445411412946E-05, 0, 0.999999996050564 },    // Cos(theta) = 0.9876543
            { 245.968780488965, 0, 44.714326894248, 0, 254.097022263666, 0, -0.178858590581617, 0, 0.983874783933302 }, { 245.968626246724, 0, 44.7143151869097, 0, 254.096884465127, 0, -0.178857286295978, 0, 0.98387508331413 }, { 245.96861623225, 0, 44.7142994816669, 0, 254.096884465127, 0, -0.178857223474974, 0, 0.983875043256206 }, { 216.944201364528, 0, 39.4379888794281, 0, 224.113275936066, 0, -0.178857223474974, 0, 0.983875043256206 }, { 122.030645053948, 0, 22.1837797668188, 0, 126.063347297494, 0, -0.17885692354157, 0, 0.98387509235314 }, { 78.0991496377495, 0, 14.197530971559, 0, 80.6799469198826, 0, -0.178856421309254, 0, 0.983875153835766 }, { 54.2349341396528, 0, 9.8592853387897, 0, 56.0269755048273, 0, -0.178855158865792, 0, 0.98387543747779 }, { 39.8453049722158, 0, 7.24341130429178, 0, 41.1617800043716, 0, -0.178852940828701, 0, 0.983875889377898 }, { 30.5056430687859, 0, 5.54556186577028, 0, 31.5133986642846, 0, -0.178850087996381, 0, 0.983876388906508 }, { 24.1022489705767, 0, 4.38149375547224, 0, 24.8982489117716, 0, -0.178846223774696, 0, 0.983877077643346 }, { 19.5216805659014, 0, 3.54879145057339, 0, 20.1662316894759, 0, -0.178839785664404, 0, 0.983878160938873 }, { 16.1324025079372, 0, 2.93265390249609, 0, 16.6647596702742, 0, -0.178831206251593, 0, 0.983879730769484 }, { 13.5543668667925, 0, 2.46398869226942, 0, 14.0012589626632, 0, -0.178820331978306, 0, 0.983881717384626 }, { 11.5478203227547, 0, 2.0992106108845, 0, 11.9283260281461, 0, -0.178805181857616, 0, 0.983884483186009 }, { 9.95546886153952, 0, 1.809727807727, 0, 10.28322294146, 0, -0.178783963194383, 0, 0.983888383132609 }, { 8.67073723052055, 0, 1.57615877556955, 0, 8.9559532528932, 0, -0.178751737252003, 0, 0.983894253401495 }, { 7.61936049980806, 0, 1.3850158071975, 0, 7.86957035974573, 0, -0.178687779455886, 0, 0.98390586525816 }, { 6.74862246611474, 0, 1.22669196406528, 0, 6.9698822793899, 0, -0.178486430557637, 0, 0.983942356148415 }, { 6.0249288662871, 0, 1.09494732984229, 0, 6.22192307173046, 0, -0.176940951620925, 0, 0.984221479849593 }, { 5.42412559525797, 0, 0.985263485462072, 0, 5.60097467270028, 0, -0.173009399471153, 0, 0.984920140896964 }, { 4.905863259536, 0, 0.89089078536294, 0, 5.06540763401553, 0, -0.172496085767128, 0, 0.98501026284165 }, { 4.46156569949896, 0, 0.810288995092645, 0, 4.60610093998131, 0, -0.174644345223109, 0, 0.984631565394773 }, { 4.07522079210618, 0, 0.740443405603624, 0, 4.20683424228094, 0, -0.178075141002803, 0, 0.984016952560125 }, { 3.72917394793985, 0, 0.677322529784596, 0, 3.84905898090013, 0, -0.177201663482474, 0, 0.984174577322611 }, { 3.43027125136432, 0, 0.622440243185635, 0, 3.53987015450157, 0, -0.174505530983489, 0, 0.984656234651181 }, { 3.16860663782838, 0, 0.574218076702554, 0, 3.2691406428574, 0, -0.171629274965504, 0, 0.985161548519996 }, { 2.93604115334211, 0, 0.531471518180415, 0, 3.02844582928009, 0, -0.170313430291791, 0, 0.985389933305952 }, { 2.73166500234746, 0, 0.493846710073467, 0, 2.81679223659088, 0, -0.169236745950648, 0, 0.985575417396057 }, { 2.55219001860942, 0, 0.46063264490267, 0, 2.63097721882001, 0, -0.168042863705003, 0, 0.985779675263534 }, { 2.38943328303289, 0, 0.430582342006221, 0, 2.46259654726779, 0, -0.167554449261342, 0, 0.985862857126391 }, { 2.24230510469931, 0, 0.402607858072433, 0, 2.30985490552072, 0, -0.164287588307564, 0, 0.986412503204949 }, { 2.1111829763206, 0, 0.377575802629757, 0, 2.17345917423345, 0, -0.161593438003444, 0, 0.986857419183879 }, { 1.99356030530321, 0, 0.355038723802361, 0, 2.05151129675822, 0, -0.159606201563935, 0, 0.987180757859331 }, { 1.88729510499255, 0, 0.334330850794802, 0, 1.94144397204594, 0, -0.157338132369585, 0, 0.987544805612027 }, { 1.79084879337984, 0, 0.314831088665637, 0, 1.84041579554804, 0, -0.153584396350284, 0, 0.988135551846902 }, { 1.703701795798, 0, 0.297014024289428, 0, 1.74976170788212, 0, -0.150413536085521, 0, 0.988623194829076 }, { 1.62487663801661, 0, 0.280467257922401, 0, 1.66771529446199, 0, -0.14716067442462, 0, 0.989112584147578 }, { 1.55277463440658, 0, 0.264600448753346, 0, 1.59229924289949, 0, -0.14296246116509, 0, 0.98972813063929 }, { 1.48770427351787, 0, 0.249861904104306, 0, 1.52390792461755, 0, -0.139032981264627, 0, 0.990287720391684 }, { 1.42859084334593, 0, 0.235740296531418, 0, 1.46158901235676, 0, -0.134558530008296, 0, 0.990905652425755 }, { 1.37419383408239, 0, 0.222203170606333, 0, 1.40485629752146, 0, -0.129907660492589, 0, 0.991526126461656 }, { 1.32550037754286, 0, 0.209359143637145, 0, 1.35295738803435, 0, -0.125229282153079, 0, 0.992127819793016 }, { 1.28008029614835, 0, 0.196729346264003, 0, 1.30563603728853, 0, -0.120022655582876, 0, 0.992771157362526 }, { 1.20097692942289, 0, 0.179565085101592, 0, 1.22271273360377, 0, -0.114820246670715, 0, 0.993386240332028 }, { 1.20196140949721, 0, 0.172852876515731, 0, 1.22271273360377, 0, -0.109268777930867, 0, 0.994012244404309 }, { 1.13562034171166, 0, 0.156583860695115, 0, 1.15375494292002, 0, -0.103616761967245, 0, 0.994617310089219 }, { 1.13649451081992, 0, 0.150107538611675, 0, 1.15375494292002, 0, -0.0979451101776073, 0, 0.995191824381591 }, { 1.05658810119714, 0, 0.130619007483671, 0, 1.07089269012237, 0, -0.0919840302130849, 0, 0.995760463933245 }, { 1.0573356231611, 0, 0.124423234507042, 0, 1.07089269012237, 0, -0.0861454813642585, 0, 0.996282559090207 }, { 1.05807628789221, 0, 0.117959240407994, 0, 1.07089269012237, 0, -0.0800553135220532, 0, 0.996790436478952 }, { 0.997263937511932, 0, 0.0739229894933484, 0, 1, 0, -0.0739229894933484, 0, 0.997263937511932 }, { 0.997691505446551, 0, 0.0679095945036246, 0, 1, 0, -0.0679095945036246, 0, 0.997691505446551 }, { 0.998089271396879, 0, 0.0617885414165349, 0, 1, 0, -0.0617885414165349, 0, 0.998089271396879 }, { 0.998450616951065, 0, 0.0556453525789336, 0, 1, 0, -0.0556453525789336, 0, 0.998450616951065 }, { 0.99876766462945, 0, 0.0496294575943331, 0, 1, 0, -0.0496294575943331, 0, 0.99876766462945 }, { 0.999044184525125, 0, 0.0437124883912489, 0, 1, 0, -0.0437124883912489, 0, 0.999044184525125 }, { 0.999286075290913, 0, 0.0377812005770645, 0, 1, 0, -0.0377812005770645, 0, 0.999286075290913 }, { 0.999489406378542, 0, 0.0319516242532532, 0, 1, 0, -0.0319516242532532, 0, 0.999489406378542 }, { 0.999654148187071, 0, 0.0262997640693147, 0, 1, 0, -0.0262997640693147, 0, 0.999654148187071 }, { 0.999782945695024, 0, 0.020833331387389, 0, 1, 0, -0.020833331387389, 0, 0.999782945695024 }, { 0.999881690953258, 0, 0.0153860161748148, 0, 1, 0, -0.0153860161748148, 0, 0.999881690953258 }, { 0.999949890744156, 0, 0.0100117057526498, 0, 1, 0, -0.0100117057526498, 0, 0.999949890744156 }, { 0.999988061717506, 0, 0.00487846936739194, 0, 1, 0, -0.00487846936739194, 0, 0.999988061717506 }, { 0.999999997448337, 0, -5.05139868057802E-05, 0, 1, 0, 5.05139868057802E-05, 0, 0.999999997448337 },    // Cos(theta) = 0.983875
            { 244.897628067498, 0, 50.2491786307386, 0, 255.208382700258, 0, -0.200997328195999, 0, 0.979591727528894 }, { 244.897928685913, 0, 50.2492205951079, 0, 255.207900218947, 0, -0.200996674655251, 0, 0.979591942665012 }, { 244.897919884028, 0, 50.2492411408378, 0, 255.207900218947, 0, -0.200996756838195, 0, 0.979591907457486 }, { 215.999712178112, 0, 44.3197769404274, 0, 225.093294400318, 0, -0.200996972070071, 0, 0.979591880095154 }, { 121.499450149333, 0, 24.9297890728184, 0, 126.614572442001, 0, -0.200996353768748, 0, 0.979591950446047 }, { 77.7591250754905, 0, 15.9549521776609, 0, 81.0327716843996, 0, -0.200995369566646, 0, 0.979592112704693 }, { 53.9988201097334, 0, 11.079704037854, 0, 56.2720513420524, 0, -0.200993393315547, 0, 0.979592570264923 }, { 39.6718938517104, 0, 8.14003715182044, 0, 41.3417688180597, 0, -0.200991147041306, 0, 0.97959307864814 }, { 30.3729271101694, 0, 6.2320268976402, 0, 31.6511959197231, 0, -0.200986891262875, 0, 0.979593929109349 }, { 23.9973929608596, 0, 4.92386074395673, 0, 25.0070665527773, 0, -0.200980173959031, 0, 0.979595315222505 }, { 19.4368263779022, 0, 3.98809442873416, 0, 20.254327133215, 0, -0.200971891287847, 0, 0.979596982698726 }, { 16.0622898164964, 0, 3.29568300731476, 0, 16.7375801841961, 0, -0.200959884956816, 0, 0.97959953167816 }, { 13.4954764351138, 0, 2.76900121731399, 0, 14.0625120767588, 0, -0.200944902438998, 0, 0.979602512049939 }, { 11.4976884395817, 0, 2.35907423462857, 0, 11.9804552499572, 0, -0.200924219824591, 0, 0.979606830631707 }, { 9.91236144523666, 0, 2.03377542893703, 0, 10.3280674254292, 0, -0.200895719835338, 0, 0.979612615107299 }, { 8.63336609031098, 0, 1.771322142535, 0, 8.99498196761519, 0, -0.200853643280792, 0, 0.979621291938775 }, { 7.58654319168909, 0, 1.5565059481029, 0, 7.90389077840743, 0, -0.200771885127065, 0, 0.979638062913269 }, { 6.71983632335966, 0, 1.37862583727111, 0, 7.00045905479886, 0, -0.200501155920592, 0, 0.97969345815227 }, { 6.00305344286264, 0, 1.2312762611684, 0, 6.2530711451886, 0, -0.19802294291651, 0, 0.980197337093486 }, { 5.4013026074962, 0, 1.10740370910759, 0, 5.62565143471554, 0, -0.194959990386061, 0, 0.980811214687011 }, { 4.88383351281721, 0, 1.00105974496134, 0, 5.08600335886087, 0, -0.194425929923262, 0, 0.980917252670851 }, { 4.44001106019375, 0, 0.910076259512114, 0, 4.62326690108571, 0, -0.195974899614195, 0, 0.980608946553352 }, { 4.05752895666941, 0, 0.832010539209973, 0, 4.22442236640414, 0, -0.199734481169544, 0, 0.97985006350371 }, { 3.71439131183924, 0, 0.761376909272025, 0, 3.86644381350362, 0, -0.198876983515646, 0, 0.98002440199391 }, { 3.41794980154485, 0, 0.699884545558193, 0, 3.55708078748749, 0, -0.195575690185775, 0, 0.980688586282951 }, { 3.15587101671024, 0, 0.645520063684264, 0, 3.28331351182357, 0, -0.193312898958858, 0, 0.98113715994093 }, { 2.92418676079685, 0, 0.597423702726256, 0, 3.04129535789563, 0, -0.191735634208392, 0, 0.981446593295475 }, { 2.72079246807991, 0, 0.555018024437636, 0, 2.82882036594018, 0, -0.189859024746029, 0, 0.981811380906559 }, { 2.54133420411008, 0, 0.517538831273412, 0, 2.64121931693628, 0, -0.188476238740314, 0, 0.982077720927096 }, { 2.38026970490939, 0, 0.483978882494731, 0, 2.47289251799725, 0, -0.188104188417276, 0, 0.982149095531963 }, { 2.23447185216587, 0, 0.452746523816166, 0, 2.32007595969048, 0, -0.184605369731438, 0, 0.982812754298863 }, { 2.10334576352483, 0, 0.424473477538558, 0, 2.18246885542469, 0, -0.181703433292299, 0, 0.983353375835821 }, { 1.98624242278156, 0, 0.398951868966396, 0, 2.05984771840494, 0, -0.178808292828488, 0, 0.983883950579756 }, { 1.88074827348379, 0, 0.375786871881628, 0, 1.94913054700722, 0, -0.176567879465101, 0, 0.984288414792896 }, { 1.78526300025597, 0, 0.3540401146413, 0, 1.84799279571805, 0, -0.172565692167062, 0, 0.984998035948435 }, { 1.69830976296145, 0, 0.333855507007928, 0, 1.75654898973329, 0, -0.168796497700739, 0, 0.985650887706241 }, { 1.62014590717723, 0, 0.315257057986557, 0, 1.67365711021324, 0, -0.165121544828396, 0, 0.986273284810716 }, { 1.54869021797892, 0, 0.29753291357038, 0, 1.59798196777706, 0, -0.160536868355352, 0, 0.987029838155451 }, { 1.48422747640349, 0, 0.280871197608006, 0, 1.52926952812101, 0, -0.155935875267462, 0, 0.98776720204127 }, { 1.42550556914245, 0, 0.265211440820543, 0, 1.4665150665358, 0, -0.151338530647053, 0, 0.988481985903128 }, { 1.37155676735783, 0, 0.249870834295685, 0, 1.40911197963689, 0, -0.145789935987834, 0, 0.989315568063632 }, { 1.32321138691092, 0, 0.235322623885375, 0, 1.35689914945458, 0, -0.140539660418241, 0, 0.990075047335004 }, { 1.2785654465994, 0, 0.221110796731927, 0, 1.3089974476866, 0, -0.134682297348257, 0, 0.990888831363192 }, { 1.19974308590345, 0, 0.201629535315016, 0, 1.22565196313979, 0, -0.128933065586804, 0, 0.991653273154834 }, { 1.20099381405003, 0, 0.194040692416802, 0, 1.22565196313979, 0, -0.122661225933826, 0, 0.992448571194819 }, { 1.134388506127, 0, 0.175860030432705, 0, 1.15604244768867, 0, -0.116514159751928, 0, 0.993189024254179 }, { 1.13553747620283, 0, 0.168281283139012, 0, 1.15604244768867, 0, -0.10987958970586, 0, 0.993944867729816 }, { 1.05539223042367, 0, 0.146744661850837, 0, 1.0723699227287, 0, -0.103377840402271, 0, 0.994642116675733 }, { 1.05636489592775, 0, 0.139571420880184, 0, 1.0723699227287, 0, -0.0966183054487544, 0, 0.995321563183235 }, { 1.05729677716551, 0, 0.13232719106673, 0, 1.0723699227287, 0, -0.0897935121223465, 0, 0.99596045283202 }, { 0.99654245325229, 0, 0.0830851271320354, 0, 1, 0, -0.0830851271320354, 0, 0.99654245325229 }, { 0.997097206655359, 0, 0.0761387759210461, 0, 1, 0, -0.0761387759210461, 0, 0.997097206655359 }, { 0.997599039180874, 0, 0.0692545347807393, 0, 1, 0, -0.0692545347807393, 0, 0.997599039180874 }, { 0.998041929931719, 0, 0.0625489243804108, 0, 1, 0, -0.0625489243804108, 0, 0.998041929931719 }, { 0.998443507832571, 0, 0.0557715504068508, 0, 1, 0, -0.0557715504068508, 0, 0.998443507832571 }, { 0.998797683034872, 0, 0.0490232190240006, 0, 1, 0, -0.0490232190240006, 0, 0.998797683034872 }, { 0.99909886701088, 0, 0.0424438876582384, 0, 1, 0, -0.0424438876582384, 0, 0.99909886701088 }, { 0.999351851503434, 0, 0.0359990131220665, 0, 1, 0, -0.0359990131220665, 0, 0.999351851503434 }, { 0.999562504034462, 0, 0.0295780710516592, 0, 1, 0, -0.0295780710516592, 0, 0.999562504034462 }, { 0.999728807679074, 0, 0.0232890431874799, 0, 1, 0, -0.0232890431874799, 0, 0.999728807679074 }, { 0.999852488680821, 0, 0.0171724147994804, 0, 1, 0, -0.0171724147994804, 0, 0.999852488680821 }, { 0.999935667874624, 0, 0.0113446465676037, 0, 1, 0, -0.0113446465676037, 0, 0.999935667874624 }, { 0.999984602213052, 0, 0.00554757135186741, 0, 1, 0, -0.00554757135186741, 0, 0.999984602213052 }, { 0.999999994055611, 0, -7.70998662993234E-05, 0, 1, 0, 7.70998662993234E-05, 0, 0.999999994055611 },    // Cos(theta) = 0.9795918
            { 243.70083794322, 0, 55.7648798385527, 0, 256.461646545094, 0, -0.223059992432608, 0, 0.974804674108833 }, { 243.701011747736, 0, 55.7649190798415, 0, 256.461584852268, 0, -0.22305971064777, 0, 0.974804810193265 }, { 243.701048950497, 0, 55.7649310639694, 0, 256.461188907771, 0, -0.223059497786191, 0, 0.974804780609085 }, { 214.944228565624, 0, 49.1846439657979, 0, 226.198732133474, 0, -0.223059122988776, 0, 0.974804895420852 }, { 120.905667329265, 0, 27.6662502292747, 0, 127.236387368537, 0, -0.223058694517884, 0, 0.974805036153053 }, { 77.3791900999887, 0, 17.7062928740421, 0, 81.4307464571505, 0, -0.223057344760877, 0, 0.974805290846949 }, { 53.7350143762574, 0, 12.2959045554544, 0, 56.548231048157, 0, -0.223055312498706, 0, 0.974805742754545 }, { 39.4780768702103, 0, 9.0335512764605, 0, 41.5447801661102, 0, -0.223051206796572, 0, 0.974806732617941 }, { 30.2245548337481, 0, 6.91610506622152, 0, 31.8065751627343, 0, -0.223045698566203, 0, 0.974807936394136 }, { 23.8802388845581, 0, 5.46435668433875, 0, 25.129851425697, 0, -0.223037408440227, 0, 0.974809821534579 }, { 19.3419552452076, 0, 4.42586907967701, 0, 20.3536824440422, 0, -0.223026000914728, 0, 0.974812549879414 }, { 15.9839610327602, 0, 3.65746829186482, 0, 16.8196893687527, 0, -0.22301028994143, 0, 0.974816098125862 }, { 13.4296926457106, 0, 3.07296994007661, 0, 14.1315139409468, 0, -0.222989537383368, 0, 0.974820822163479 }, { 11.4417264087218, 0, 2.61805790024328, 0, 12.039122565529, 0, -0.222961790330639, 0, 0.974827200634084 }, { 9.86420519054631, 0, 2.25705952031098, 0, 10.3786752262636, 0, -0.222924937463604, 0, 0.974835589299503 }, { 8.59137041814266, 0, 1.96577489765689, 0, 9.03907759348467, 0, -0.222870004038342, 0, 0.974848131990311 }, { 7.54986322836983, 0, 1.72741395659218, 0, 7.94264861112651, 0, -0.22276590842265, 0, 0.974872002073133 }, { 6.68791305116888, 0, 1.5301133819367, 0, 7.03522432720429, 0, -0.222396641383686, 0, 0.974956271463674 }, { 5.97769425729626, 0, 1.36723094034334, 0, 6.28754219431723, 0, -0.219133091380514, 0, 0.975694936197548 }, { 5.3754018924999, 0, 1.22908844856029, 0, 5.65300866695725, 0, -0.216897061128116, 0, 0.97619445915753 }, { 4.8593895178761, 0, 1.11082155579245, 0, 5.10962592912802, 0, -0.216296416232687, 0, 0.976327769811687 }, { 4.4165144592369, 0, 1.00948658213428, 0, 4.64320075153689, 0, -0.217351316291576, 0, 0.976093473361214 }, { 4.03595694653861, 0, 0.922715050237654, 0, 4.24234182547685, 0, -0.2205264197932, 0, 0.975380984720646 }, { 3.6978762063763, 0, 0.845209558539879, 0, 3.88615749589787, 0, -0.220344297832349, 0, 0.975422178000713 }, { 3.40311291946837, 0, 0.7770374132966, 0, 3.57530497894372, 0, -0.216957208441496, 0, 0.976181143188137 }, { 3.1415810272846, 0, 0.71662301302299, 0, 3.29941849073989, 0, -0.214880444623426, 0, 0.976640379865356 }, { 2.91089373471013, 0, 0.663180207931563, 0, 3.05598875640334, 0, -0.212999039230414, 0, 0.97705242856929 }, { 2.70908256583808, 0, 0.616103746729731, 0, 2.84278499061124, 0, -0.210308365215766, 0, 0.977635118785355 }, { 2.52938418102844, 0, 0.574266116222341, 0, 2.65304696724832, 0, -0.208918434505631, 0, 0.977933025686139 }, { 2.36947480209939, 0, 0.537048865862608, 0, 2.4840909233667, 0, -0.208030136112499, 0, 0.978122421024724 }, { 2.22553253782665, 0, 0.502766925839546, 0, 2.33117692946446, 0, -0.20511034589686, 0, 0.978738866279724 }, { 2.0947450424949, 0, 0.471279264931743, 0, 2.19248137378708, 0, -0.201689917803758, 0, 0.979449397714963 }, { 1.97822553733577, 0, 0.442853615933732, 0, 2.06888341998049, 0, -0.198222720895264, 0, 0.980156989581155 }, { 1.87354161253975, 0, 0.417133241639784, 0, 1.95754108412147, 0, -0.195433204080258, 0, 0.980717026803365 }, { 1.77900063259899, 0, 0.393217631579256, 0, 1.85622599920919, 0, -0.191710219902628, 0, 0.98145157669812 }, { 1.69271599139289, 0, 0.370693571984851, 0, 1.76398653639376, 0, -0.187019097198505, 0, 0.982356244087758 }, { 1.6152156977766, 0, 0.350019094069816, 0, 1.6804274680023, 0, -0.182883892552494, 0, 0.983134530009185 }, { 1.54461596159212, 0, 0.330495756128855, 0, 1.60444149011167, 0, -0.1782931037235, 0, 0.983977408229448 }, { 1.48089142436287, 0, 0.311879450104934, 0, 1.53505121480848, 0, -0.172735037165055, 0, 0.984968289223154 }, { 1.42267401995713, 0, 0.29436322424454, 0, 1.47195815960438, 0, -0.167587236313371, 0, 0.985857252679539 }, { 1.36960604146926, 0, 0.277425262223024, 0, 1.41382243559854, 0, -0.161743315138051, 0, 0.986832869724524 }, { 1.32117385168749, 0, 0.261191168866156, 0, 1.36144599366114, 0, -0.15567562092932, 0, 0.987808234447175 }, { 1.27763293525512, 0, 0.245625663441273, 0, 1.31313814804626, 0, -0.14942079269939, 0, 0.988773630656025 }, { 1.19859766592177, 0, 0.223508302927672, 0, 1.22882086432791, 0, -0.14274369282306, 0, 0.989759690688684 }, { 1.20008673068792, 0, 0.215369449362018, 0, 1.22882086432791, 0, -0.13602387979674, 0, 0.99070550622161 }, { 1.13398539337826, 0, 0.194794624313258, 0, 1.15814400221115, 0, -0.128969622858395, 0, 0.99164859608477 }, { 1.13536056316299, 0, 0.186612246095792, 0, 1.15814400221115, 0, -0.121815366180963, 0, 0.99255279880507 }, { 1.05474881395926, 0, 0.162459452942115, 0, 1.07391118379729, 0, -0.114568949376097, 0, 0.993415301543597 }, { 1.05594447091899, 0, 0.154497100960035, 0, 1.07391118379729, 0, -0.107070702247358, 0, 0.994251387900946 }, { 1.05706245418005, 0, 0.146652679109016, 0, 1.07391118379729, 0, -0.0996856463586343, 0, 0.995018941936554 }, { 0.995756839843948, 0, 0.0920233182130712, 0, 1, 0, -0.0920233182130712, 0, 0.995756839843948 }, { 0.996429532307156, 0, 0.0844284121383294, 0, 1, 0, -0.0844284121383294, 0, 0.996429532307156 }, { 0.997036176861337, 0, 0.0769342570348396, 0, 1, 0, -0.0769342570348396, 0, 0.997036176861337 }, { 0.997595177006046, 0, 0.0693106649900276, 0, 1, 0, -0.0693106649900276, 0, 0.997595177006046 }, { 0.998089702288532, 0, 0.0617816914530555, 0, 1, 0, -0.0617816914530555, 0, 0.998089702288532 }, { 0.998516748588997, 0, 0.0544460528394235, 0, 1, 0, -0.0544460528394235, 0, 0.998516748588997 }, { 0.998893011275147, 0, 0.0470391441292166, 0, 1, 0, -0.0470391441292166, 0, 0.998893011275147 }, { 0.999207202505009, 0, 0.0398131844274234, 0, 1, 0, -0.0398131844274234, 0, 0.999207202505009 }, { 0.999463490593284, 0, 0.0327515393694151, 0, 1, 0, -0.0327515393694151, 0, 0.999463490593284 }, { 0.999664185700489, 0, 0.025914739455024, 0, 1, 0, -0.025914739455024, 0, 0.999664185700489 }, { 0.99981713384812, 0, 0.019126395198589, 0, 1, 0, -0.019126395198589, 0, 0.99981713384812 }, { 0.999921782919868, 0, 0.0125064885131967, 0, 1, 0, -0.0125064885131967, 0, 0.999921782919868 }, { 0.999981267542786, 0, 0.00611460208862731, 0, 1, 0, -0.00611460208862731, 0, 0.999981267542786 }, { 0.999999996847754, 0, -5.6144868545203E-05, 0, 1, 0, 5.6144868545203E-05, 0, 0.999999996847754 },    // Cos(theta) = 0.9748048
            { 242.378276420786, 0, 61.2592200676587, 0, 257.861347794794, 0, -0.245036837746067, 0, 0.969513763263905 }, { 242.378163754987, 0, 61.2591923586267, 0, 257.861217138721, 0, -0.245037130397659, 0, 0.96951374071708 }, { 242.378279394653, 0, 61.25922499152, 0, 257.860854836936, 0, -0.24503679841085, 0, 0.969513784504012 }, { 213.777389563173, 0, 54.0305694530613, 0, 227.433232213605, 0, -0.245037141412686, 0, 0.969513667030009 }, { 120.249458099242, 0, 30.3921045340552, 0, 127.930835849459, 0, -0.245035540215331, 0, 0.969514057463539 }, { 76.9592728278906, 0, 19.4508403461219, 0, 81.8751802613651, 0, -0.245033965240292, 0, 0.969514433731865 }, { 53.4432978437328, 0, 13.5073539816594, 0, 56.8569642651666, 0, -0.245031282584027, 0, 0.969515204885587 }, { 39.2637725958219, 0, 9.92357961520104, 0, 41.7714714997274, 0, -0.245026162192872, 0, 0.969516479419215 }, { 30.060587263922, 0, 7.59753443313609, 0, 31.9801333553023, 0, -0.245018461913277, 0, 0.969518401737556 }, { 23.7507589131345, 0, 6.00276339343659, 0, 25.2669479253085, 0, -0.245007867022915, 0, 0.96952114161983 }, { 19.2370987870196, 0, 4.86195661748753, 0, 20.4647635759043, 0, -0.244992481490219, 0, 0.969525045081346 }, { 15.8973363163114, 0, 4.01784016866018, 0, 16.9114088229453, 0, -0.244971217437106, 0, 0.969530292440728 }, { 13.3569402695994, 0, 3.37575270980626, 0, 14.2084612204986, 0, -0.244944017461511, 0, 0.969537184741741 }, { 11.3799035968025, 0, 2.8760510996665, 0, 12.1047528564563, 0, -0.244907993412512, 0, 0.969546331175752 }, { 9.81092272011417, 0, 2.47947705593104, 0, 10.4352194987988, 0, -0.244860798683622, 0, 0.969558182811386 }, { 8.54504350634102, 0, 2.15949862563248, 0, 9.08822115165987, 0, -0.244790239115585, 0, 0.969575994386162 }, { 7.50928107762134, 0, 1.89767532583865, 0, 7.98590695324433, 0, -0.244659728373862, 0, 0.969609047439854 }, { 6.65275709963514, 0, 1.68111562512794, 0, 7.07408011356523, 0, -0.244138871419576, 0, 0.969740290461903 }, { 5.9476725116142, 0, 1.50249868949994, 0, 6.32351266084769, 0, -0.240598386309279, 0, 0.970624768063162 }, { 5.34665879606226, 0, 1.35028997626261, 0, 5.6836958414724, 0, -0.238732382450531, 0, 0.971085429367706 }, { 4.83261844779416, 0, 1.22015915271092, 0, 5.13615531593489, 0, -0.238088526839408, 0, 0.971243475609108 }, { 4.3913019424484, 0, 1.10856639044812, 0, 4.66622732314931, 0, -0.238750071342935, 0, 0.971081083161982 }, { 4.01223951632923, 0, 1.0129384377677, 0, 4.26250010063369, 0, -0.24116651835358, 0, 0.9704837851564 }, { 3.68000632832018, 0, 0.928896015306317, 0, 3.90847490147769, 0, -0.241549066254265, 0, 0.970388557303002 }, { 3.38620211491205, 0, 0.853917869113688, 0, 3.59523546041599, 0, -0.238384638057689, 0, 0.971170797427205 }, { 3.12566274783095, 0, 0.787460276615116, 0, 3.31724389256602, 0, -0.236356421676802, 0, 0.971666391426888 }, { 2.8965898601524, 0, 0.728804877904931, 0, 3.07252519852348, 0, -0.23406145629954, 0, 0.972221883067325 }, { 2.69566670567438, 0, 0.676984915117555, 0, 2.85784370322467, 0, -0.231020084624148, 0, 0.972948996042944 }, { 2.51639209514061, 0, 0.630836271683676, 0, 2.66637796578827, 0, -0.229309830618659, 0, 0.973353456864551 }, { 2.35787148371813, 0, 0.589869960692834, 0, 2.49670494931907, 0, -0.227670642096155, 0, 0.973738203532083 }, { 2.2156542280437, 0, 0.552736716383008, 0, 2.34359359793983, 0, -0.22556898392639, 0, 0.974227207068281 }, { 2.08554983438736, 0, 0.518016032437692, 0, 2.20418530979145, 0, -0.221483808495175, 0, 0.975164041554885 }, { 1.96954446786224, 0, 0.486680548815956, 0, 2.07919404480213, 0, -0.21765264712771, 0, 0.976026289621602 }, { 1.86600465900816, 0, 0.458395065882971, 0, 1.96686232075621, 0, -0.214058509915773, 0, 0.976820855768686 }, { 1.77222036030119, 0, 0.432329976164292, 0, 1.86525076362667, 0, -0.210606405917292, 0, 0.977570926931028 }, { 1.68722088948907, 0, 0.407701488826015, 0, 1.77223040179258, 0, -0.205398438984866, 0, 0.97867846972856 }, { 1.61027172211507, 0, 0.384760381479761, 0, 1.68786066018958, 0, -0.200434173875121, 0, 0.979707160734689 }, { 1.54011297674166, 0, 0.36338282332588, 0, 1.61144696255875, 0, -0.195632110876633, 0, 0.980677345554517 }, { 1.47678706755125, 0, 0.342870308127891, 0, 1.5413686980015, 0, -0.189674962169797, 0, 0.981846947144334 }, { 1.41951246721934, 0, 0.323708814708223, 0, 1.4777047542158, 0, -0.183668467815044, 0, 0.982988256492918 }, { 1.36725519875158, 0, 0.30508485147343, 0, 1.41975063924325, 0, -0.177591438671609, 0, 0.98410433394871 }, { 1.31912441657334, 0, 0.287138821778443, 0, 1.36604250373013, 0, -0.170705489987154, 0, 0.985322075798125 }, { 1.27612882748279, 0, 0.26988549475091, 0, 1.31762709693243, 0, -0.164003452418589, 0, 0.986459736439211 }, { 1.19818998864923, 0, 0.245217335347879, 0, 1.2323262540448, 0, -0.156616157344378, 0, 0.987659517494776 }, { 1.19996997232494, 0, 0.236353277132001, 0, 1.2323262540448, 0, -0.149310820341281, 0, 0.988790287484228 }, { 1.133733140975, 0, 0.213636091109878, 0, 1.16106543632137, 0, -0.141494166148537, 0, 0.989939023175443 }, { 1.13536326259902, 0, 0.204796813911271, 0, 1.16106543632137, 0, -0.133777358616538, 0, 0.991011443592365 }, { 1.05387198818435, 0, 0.177910968189434, 0, 1.0755044617332, 0, -0.12560939337496, 0, 0.992079816847569 }, { 1.05527522110945, 0, 0.169388601224417, 0, 1.0755044617332, 0, -0.117588093027855, 0, 0.993062413508873 }, { 1.0566616990057, 0, 0.160513092636382, 0, 1.0755044617332, 0, -0.10923730710525, 0, 0.994015705359913 }, { 0.994892421814216, 0, 0.100941232281771, 0, 1, 0, -0.100941232281771, 0, 0.994892421814216 }, { 0.995693804341665, 0, 0.0927033406770215, 0, 1, 0, -0.0927033406770215, 0, 0.995693804341665 }, { 0.996440899166486, 0, 0.0842944021002813, 0, 1, 0, -0.0842944021002813, 0, 0.996440899166486 }, { 0.997106193530264, 0, 0.0760212986924948, 0, 1, 0, -0.0760212986924948, 0, 0.997106193530264 }, { 0.997695688913187, 0, 0.0678481875727476, 0, 1, 0, -0.0678481875727476, 0, 0.997695688913187 }, { 0.998219709830947, 0, 0.059643878419135, 0, 1, 0, -0.059643878419135, 0, 0.998219709830947 }, { 0.998666114794347, 0, 0.0516333062167874, 0, 1, 0, -0.0516333062167874, 0, 0.998666114794347 }, { 0.999039863389464, 0, 0.0438101168938021, 0, 1, 0, -0.0438101168938021, 0, 0.999039863389464 }, { 0.999351721114822, 0, 0.0360024772394802, 0, 1, 0, -0.0360024772394802, 0, 0.999351721114822 }, { 0.999597807410718, 0, 0.0283602293687539, 0, 1, 0, -0.0283602293687539, 0, 0.999597807410718 }, { 0.999780092284943, 0, 0.0209728424394647, 0, 1, 0, -0.0209728424394647, 0, 0.999780092284943 }, { 0.999905248335046, 0, 0.0137707405299295, 0, 1, 0, -0.0137707405299295, 0, 0.999905248335046 }, { 0.999977320597615, 0, 0.00672822758114636, 0, 1, 0, -0.00672822758114636, 0, 0.999977320597615 }, { 0.999999991424975, 0, -9.26014319037879E-05, 0, 1, 0, 9.26014319037879E-05, 0, 0.999999991424975 },    // Cos(theta) = 0.9695137
            { 240.929636650498, 0, 66.7298569058888, 0, 259.411655456269, 0, -0.266920091043244, 0, 0.963718609499701 }, { 240.929527649075, 0, 66.7298270026385, 0, 259.411671798888, 0, -0.266919462378585, 0, 0.963718778146543 }, { 240.929202217584, 0, 66.7297403683482, 0, 259.411648994481, 0, -0.266918864378485, 0, 0.963718997904059 }, { 212.49953257, 0, 58.8556205228648, 0, 228.800997927779, 0, -0.266918419712645, 0, 0.963719125666676 }, { 119.530583883398, 0, 33.1061645195175, 0, 128.70015032038, 0, -0.266917371937004, 0, 0.963719406740654 }, { 76.4991630857205, 0, 21.1878186703028, 0, 82.3675405514105, 0, -0.266915383715929, 0, 0.963719973996897 }, { 53.1240031460716, 0, 14.713631124109, 0, 57.1988448662089, 0, -0.266911637270397, 0, 0.963720970496789 }, { 39.0291509633153, 0, 10.8097929214854, 0, 42.0227167468998, 0, -0.26690496213452, 0, 0.963722820348877 }, { 29.8810209907502, 0, 8.27603599106071, 0, 32.1724508769555, 0, -0.266894627373338, 0, 0.963725753370444 }, { 23.6087837032897, 0, 6.53880920767549, 0, 25.4188615275649, 0, -0.26688177273295, 0, 0.963729294121697 }, { 19.1222695958901, 0, 5.29616900804625, 0, 20.5877625106202, 0, -0.26686135333648, 0, 0.963734939210646 }, { 15.8024717110391, 0, 4.3766703129875, 0, 17.0130088630258, 0, -0.266834309410401, 0, 0.963742401651131 }, { 13.277300226059, 0, 3.67725092843752, 0, 14.2937763051046, 0, -0.26679980746707, 0, 0.96375197142742 }, { 11.3121023568711, 0, 3.13292396860998, 0, 12.1774442627766, 0, -0.266754831247856, 0, 0.963764412486752 }, { 9.75250574830724, 0, 2.7009282848167, 0, 10.4978621232823, 0, -0.266693808109593, 0, 0.963781324027879 }, { 8.4943942481209, 0, 2.35243348960831, 0, 9.14276436440157, 0, -0.266607514357459, 0, 0.963805167554448 }, { 7.46497088260975, 0, 2.06725185341943, 0, 8.0338315844629, 0, -0.266441938559003, 0, 0.963850965261119 }, { 6.61459790042524, 0, 1.83161219969256, 0, 7.1176717180026, 0, -0.265672710428986, 0, 0.964063275571494 }, { 5.91389701007335, 0, 1.63711368040956, 0, 6.36279122220305, 0, -0.262103749198883, 0, 0.965039667464843 }, { 5.31524954199955, 0, 1.47100828106155, 0, 5.71755527401898, 0, -0.260455953800935, 0, 0.965485706423701 }, { 4.80345777618426, 0, 1.32902451914359, 0, 5.16588073784758, 0, -0.25978297919188, 0, 0.965667043701557 }, { 4.36423997402263, 0, 1.20726221305535, 0, 4.69229064367787, 0, -0.260121449204439, 0, 0.965575875827802 }, { 3.98676369722366, 0, 1.10277150948292, 0, 4.28524108208315, 0, -0.261752227622772, 0, 0.965135183237933 }, { 3.66074305671744, 0, 1.01239700169846, 0, 3.93361970221201, 0, -0.262428936013953, 0, 0.964951374123271 }, { 3.3675076866087, 0, 0.930510277910275, 0, 3.61704864620216, 0, -0.259756734070719, 0, 0.965674065735464 }, { 3.10835119401633, 0, 0.858066018862224, 0, 3.33713647982583, 0, -0.257654589546411, 0, 0.966237113375573 }, { 2.88115873263645, 0, 0.794262405851988, 0, 3.09130900204002, 0, -0.254888559435409, 0, 0.966970425087856 }, { 2.68087587451701, 0, 0.737706385929362, 0, 2.87459367872908, 0, -0.251776427892996, 0, 0.967785366398278 }, { 2.5025115626136, 0, 0.68729352510275, 0, 2.68154146095922, 0, -0.249613913781334, 0, 0.968345416594275 }, { 2.34523234920957, 0, 0.64253551841272, 0, 2.51067205454605, 0, -0.247256158204714, 0, 0.968950146214463 }, { 2.20437723156613, 0, 0.602347691423836, 0, 2.35698541484676, 0, -0.245470621888985, 0, 0.969404017071522 }, { 2.07589844444151, 0, 0.564737981071883, 0, 2.21709799071911, 0, -0.241171408574581, 0, 0.970482543723267 }, { 1.96059439609638, 0, 0.530545463991109, 0, 2.09082458186022, 0, -0.236993209612183, 0, 0.971511308824706 }, { 1.85781278288898, 0, 0.49956705555197, 0, 1.97732211794657, 0, -0.232763749287389, 0, 0.972533335118125 }, { 1.76468463639526, 0, 0.471114258571074, 0, 1.87520801371893, 0, -0.228836850440913, 0, 0.973464791724272 }, { 1.68049044789366, 0, 0.444426234434691, 0, 1.78134748134333, 0, -0.223749529017628, 0, 0.974646668872768 }, { 1.60385203436388, 0, 0.419361295180088, 0, 1.69614986465676, 0, -0.218020244462235, 0, 0.975944209576072 }, { 1.53506134950133, 0, 0.396049320837523, 0, 1.61891494173753, 0, -0.212539432898172, 0, 0.977152450814061 }, { 1.47239370770943, 0, 0.373894176892693, 0, 1.5486738597912, 0, -0.206553825943739, 0, 0.978435261669667 }, { 1.41605211228318, 0, 0.35270427832278, 0, 1.48390583249136, 0, -0.199772818721521, 0, 0.979842239913009 }, { 1.36400043401971, 0, 0.332373642418746, 0, 1.42540945737446, 0, -0.193146874536257, 0, 0.981169829119325 }, { 1.31725809242185, 0, 0.312693547676744, 0, 1.37115483393508, 0, -0.185742758651165, 0, 0.982598386853628 }, { 1.27454356287771, 0, 0.293664878088727, 0, 1.322114034278, 0, -0.178233656029961, 0, 0.983988158227147 }, { 1.19630578213961, 0, 0.266982807241507, 0, 1.23570123110989, 0, -0.170424660058198, 0, 0.985370724375109 }, { 1.19847682282505, 0, 0.257061378597061, 0, 1.23570123110989, 0, -0.162254298008921, 0, 0.986748958824364 }, { 1.13351233498053, 0, 0.232476878746682, 0, 1.16361678673254, 0, -0.153999484889286, 0, 0.988070951817418 }, { 1.13549915974128, 0, 0.222569568176987, 0, 1.16361678673254, 0, -0.145365242766255, 0, 0.98937802440233 }, { 1.05396735990782, 0, 0.193505463280226, 0, 1.07734110016042, 0, -0.136685973158756, 0, 0.990614504011769 }, { 1.0556529525019, 0, 0.184087425593204, 0, 1.07734110016042, 0, -0.127835849265817, 0, 0.991795317423448 }, { 1.05727711945323, 0, 0.174517808163576, 0, 1.07734110016042, 0, -0.118846958895762, 0, 0.992912578222419 }, { 0.993940174475743, 0, 0.109922379243807, 0, 1, 0, -0.109922379243807, 0, 0.993940174475743 }, { 0.994908790532404, 0, 0.100779656695469, 0, 1, 0, -0.100779656695469, 0, 0.994908790532404 }, { 0.995778772095402, 0, 0.0917860001612037, 0, 1, 0, -0.0917860001612037, 0, 0.995778772095402 }, { 0.996567824071061, 0, 0.0827797733121197, 0, 1, 0, -0.0827797733121197, 0, 0.996567824071061 }, { 0.997275079402945, 0, 0.0737729016520252, 0, 1, 0, -0.0737729016520252, 0, 0.997275079402945 }, { 0.997888118834404, 0, 0.0649559329946793, 0, 1, 0, -0.0649559329946793, 0, 0.997888118834404 }, { 0.998416345973923, 0, 0.0562563938067632, 0, 1, 0, -0.0562563938067632, 0, 0.998416345973923 }, { 0.998867603477284, 0, 0.0475754510111001, 0, 1, 0, -0.0475754510111001, 0, 0.998867603477284 }, { 0.99923360847433, 0, 0.0391433352699298, 0, 1, 0, -0.0391433352699298, 0, 0.99923360847433 }, { 0.999522104937926, 0, 0.0309143331427145, 0, 1, 0, -0.0309143331427145, 0, 0.999522104937926 }, { 0.999739007245564, 0, 0.0228471661497345, 0, 1, 0, -0.0228471661497345, 0, 0.999739007245564 }, { 0.999888195648483, 0, 0.0149536004515407, 0, 1, 0, -0.0149536004515407, 0, 0.999888195648483 }, { 0.999973025599487, 0, 0.00734673925589685, 0, 1, 0, -0.00734673925589685, 0, 0.999973025599487 }, { 0.999999994652925, 0, -7.31236937736806E-05, 0, 1, 0, 7.31236937736806E-05, 0, 0.999999994652925 },    // Cos(theta) = 0.9637188
            { 239.354387235199, 0, 72.1744929041692, 0, 261.118689732291, 0, -0.288698261929676, 0, 0.957420091085147 }, { 239.35459553887, 0, 72.1745570630924, 0, 261.118522750103, 0, -0.288698501671187, 0, 0.957420075097603 }, { 239.354582286135, 0, 72.1745562548215, 0, 261.118234723704, 0, -0.288699014591697, 0, 0.957419877884003 }, { 211.110672042805, 0, 63.6579325665065, 0, 230.306218575675, 0, -0.28869780679342, 0, 0.957420321491893 }, { 118.749349188907, 0, 35.8074511389989, 0, 129.546846867682, 0, -0.288696384086731, 0, 0.95742076460837 }, { 75.9992144173551, 0, 22.9166417459765, 0, 82.9095395127674, 0, -0.288694043476866, 0, 0.95742138747628 }, { 52.7766058042588, 0, 15.9141265967966, 0, 57.5752634287385, 0, -0.288688865553562, 0, 0.957422962669348 }, { 38.7741466058171, 0, 11.6918333548825, 0, 42.2991461618798, 0, -0.288680610543523, 0, 0.957425506074209 }, { 29.6857858524897, 0, 8.95132654293432, 0, 32.3841244828946, 0, -0.28866817041251, 0, 0.957429180263555 }, { 23.4546266864235, 0, 7.07237265878222, 0, 25.586043328687, 0, -0.288650824827844, 0, 0.957434462616842 }, { 18.9973660906703, 0, 5.72831272582365, 0, 20.7231437900112, 0, -0.288625464008496, 0, 0.957442055933443 }, { 15.6993274474614, 0, 4.73379904027927, 0, 17.1248463721274, 0, -0.288591987702049, 0, 0.957452239724616 }, { 13.1907807436001, 0, 3.97734702408975, 0, 14.3878271550519, 0, -0.288548270021317, 0, 0.957465420090032 }, { 11.2384314050655, 0, 3.3886022222808, 0, 12.257412663118, 0, -0.288490273118275, 0, 0.957482839715546 }, { 9.68909275797867, 0, 2.92137225960325, 0, 10.5667461132007, 0, -0.288416109143678, 0, 0.957505099686645 }, { 8.43927432483158, 0, 2.54445143691212, 0, 9.20268821332819, 0, -0.288308392930856, 0, 0.957537627647298 }, { 7.41673330676834, 0, 2.23604223985044, 0, 8.08664223597357, 0, -0.288098847222732, 0, 0.957600631390827 }, { 6.57398022933608, 0, 1.98175191509739, 0, 7.16645224683476, 0, -0.286896379270251, 0, 0.957961623803214 }, { 5.8767325296412, 0, 1.77109228100634, 0, 6.40522366424785, 0, -0.283577340860962, 0, 0.95894934682804 }, { 5.28084313613073, 0, 1.59110817994822, 0, 5.75464359534589, 0, -0.282114195054394, 0, 0.959380863685284 }, { 4.77197548691233, 0, 1.43740643329592, 0, 5.19862188694629, 0, -0.281365763046479, 0, 0.959600562704516 }, { 4.33494050259858, 0, 1.30544551084083, 0, 4.72110271141202, 0, -0.28141382530336, 0, 0.959586507727117 }, { 3.95966841545524, 0, 1.19221468012657, 0, 4.31109331498783, 0, -0.282303515734424, 0, 0.959325147116915 }, { 3.63844310342407, 0, 1.09524322699948, 0, 3.95995970979486, 0, -0.282952314374222, 0, 0.959134043463178 }, { 3.34701903157655, 0, 1.00677340264804, 0, 3.64093663121759, 0, -0.281030462723591, 0, 0.959698768052219 }, { 3.08974567847168, 0, 0.928466736835972, 0, 3.35914511894731, 0, -0.278744333765142, 0, 0.960365333730296 }, { 2.86463715934656, 0, 0.859536010857715, 0, 3.1120831697938, 0, -0.275426659775529, 0, 0.961322037904276 }, { 2.66484456088353, 0, 0.798140869558953, 0, 2.8929148972619, 0, -0.272454619470217, 0, 0.962168634158778 }, { 2.48782533856284, 0, 0.743600010596388, 0, 2.69843035963853, 0, -0.269737507240416, 0, 0.962933881433404 }, { 2.33143127778801, 0, 0.695050831441978, 0, 2.52593542431278, 0, -0.26696368303397, 0, 0.963706633543857 }, { 2.19195377328716, 0, 0.651616928191033, 0, 2.37115416763176, 0, -0.26483833891626, 0, 0.964292827974963 }, { 2.06567653763581, 0, 0.61149166320707, 0, 2.23107128496175, 0, -0.260958569330809, 0, 0.965350035025302 }, { 1.95090636987361, 0, 0.574290924034011, 0, 2.10332921530577, 0, -0.256153596788774, 0, 0.966636058856135 }, { 1.84784198313113, 0, 0.540495841284016, 0, 1.98885605483957, 0, -0.251477324400301, 0, 0.967863176990747 }, { 1.75619095618005, 0, 0.50980328882635, 0, 1.88571625917628, 0, -0.246861440398762, 0, 0.969050813620816 }, { 1.67350470736639, 0, 0.481196260600474, 0, 1.79159524630611, 0, -0.241972498353656, 0, 0.970283060074264 }, { 1.59731081609304, 0, 0.453937328378474, 0, 1.70563998751699, 0, -0.235604719866145, 0, 0.971848971037846 }, { 1.52952582928246, 0, 0.428530710502999, 0, 1.6273423775323, 0, -0.229422073460876, 0, 0.973327023381047 }, { 1.46801159793787, 0, 0.404699634726041, 0, 1.55598808891435, 0, -0.223133386091432, 0, 0.974787889393518 }, { 1.41271698378351, 0, 0.381547940575656, 0, 1.49082509053878, 0, -0.215758305433963, 0, 0.97644679229457 }, { 1.36154015168154, 0, 0.359556054249136, 0, 1.43131684186602, 0, -0.208407917519818, 0, 0.978041978056337 }, { 1.31507554666363, 0, 0.338005314066537, 0, 1.37645024980177, 0, -0.200818585142945, 0, 0.979628452370329 }, { 1.27301118352716, 0, 0.31736777658896, 0, 1.32677049729127, 0, -0.192426533156524, 0, 0.981311384175836 }, { 1.23409346757027, 0, 0.297454377046356, 0, 1.28147129799212, 0, -0.184164314633322, 0, 0.982895509007791 }, { 1.16381325335159, 0, 0.269378277630284, 0, 1.20205326177316, 0, -0.175223814472367, 0, 0.984528588351018 }, { 1.16619813681997, 0, 0.258858939651654, 0, 1.20205326177316, 0, -0.166327118273359, 0, 0.986070629376063 }, { 1.10504033240763, 0, 0.232812304198208, 0, 1.13498117777835, 0, -0.156977949300564, 0, 0.987602100672411 }, { 1.10717865760279, 0, 0.22242104186534, 0, 1.13498117777835, 0, -0.147693273671877, 0, 0.989033203893793 }, { 1.03183041833167, 0, 0.191838463186066, 0, 1.05542950747691, 0, -0.138015149353832, 0, 0.990430057339192 }, { 1.03362972098816, 0, 0.181894669000555, 0, 1.05542950747691, 0, -0.128472469070035, 0, 0.99171304389304 }, { 1.03538411946207, 0, 0.171627133228864, 0, 1.05542950747691, 0, -0.11862357784347, 0, 0.992939299956695 }, { 0.994053073207522, 0, 0.108896992993682, 0, 1, 0, -0.108896992993682, 0, 0.994053073207522 }, { 0.995076045579951, 0, 0.0991146236666823, 0, 1, 0, -0.0991146236666823, 0, 0.995076045579951 }, { 0.996001653519057, 0, 0.0893344223090855, 0, 1, 0, -0.0893344223090855, 0, 0.996001653519057 }, { 0.996814361603939, 0, 0.0797562544649704, 0, 1, 0, -0.0797562544649704, 0, 0.996814361603939 }, { 0.997537153733377, 0, 0.0701393264652657, 0, 1, 0, -0.0701393264652657, 0, 0.997537153733377 }, { 0.998158178617689, 0, 0.0606652474208879, 0, 1, 0, -0.0606652474208879, 0, 0.998158178617689 }, { 0.998673532984704, 0, 0.0514898913929771, 0, 1, 0, -0.0514898913929771, 0, 0.998673532984704 }, { 0.999103114473263, 0, 0.0423446751832898, 0, 1, 0, -0.0423446751832898, 0, 0.999103114473263 }, { 0.999443260694044, 0, 0.0333654909663152, 0, 1, 0, -0.0333654909663152, 0, 0.999443260694044 }, { 0.999695819246167, 0, 0.0246651570075933, 0, 1, 0, -0.0246651570075933, 0, 0.999695819246167 }, { 0.999868801575074, 0, 0.0161978712774584, 0, 1, 0, -0.0161978712774584, 0, 0.999868801575074 }, { 0.999968725077778, 0, 0.00790612273169223, 0, 1, 0, -0.00790612273169223, 0, 0.999968725077778 }, { 0.999999991325403, 0, -9.31375171709725E-05, 0, 1, 0, 9.31375171709725E-05, 0, 0.999999991325403 },    // Cos(theta) = 0.95742
            { 237.653971943464, 0, 77.5912352975548, 0, 262.987167545289, 0, -0.310365157189383, 0, 0.950617392620333 }, { 237.65402195853, 0, 77.5912517026304, 0, 262.987054293875, 0, -0.3103657198587, 0, 0.950617202857222 }, { 237.653758378158, 0, 77.5911704491902, 0, 262.987040707833, 0, -0.310365085006939, 0, 0.950617445377326 }, { 209.610378882963, 0, 68.4353296380773, 0, 231.954507398339, 0, -0.310364235447237, 0, 0.95061769716696 }, { 117.905700805508, 0, 38.4948109305674, 0, 130.474021457642, 0, -0.310362799156002, 0, 0.950618156300971 }, { 75.4591582460715, 0, 24.6364994949529, 0, 83.5028814790447, 0, -0.310359339836826, 0, 0.950619281897599 }, { 52.4016763369711, 0, 17.1084847019095, 0, 57.9872960162122, 0, -0.310352767296949, 0, 0.95062150153269 }, { 38.4987497231832, 0, 12.5693235053707, 0, 42.6019592306798, 0, -0.310343024105505, 0, 0.950624635538211 }, { 29.4749348593899, 0, 9.62313075375998, 0, 32.615873339385, 0, -0.310328133410341, 0, 0.95062946388565 }, { 23.2880953310816, 0, 7.60317095118239, 0, 25.7691232197912, 0, -0.31030487437655, 0, 0.950637084463634 }, { 18.8625165387044, 0, 6.15824341669087, 0, 20.8714243152673, 0, -0.310273953684029, 0, 0.950647200903099 }, { 15.5879975919794, 0, 5.08911691947938, 0, 17.2473603729879, 0, -0.31023311995747, 0, 0.950660570140045 }, { 13.0973717980751, 0, 4.27591548894389, 0, 14.490596819834, 0, -0.31017812406863, 0, 0.950678446919761 }, { 11.1588045214981, 0, 3.64294872948249, 0, 12.344978990173, 0, -0.310107944351368, 0, 0.950701349666279 }, { 9.62068235704974, 0, 3.14071552313222, 0, 10.6422170062077, 0, -0.310017359757471, 0, 0.950730866536625 }, { 8.37978297832112, 0, 2.73551488939348, 0, 9.26853033228885, 0, -0.309885637131046, 0, 0.950773916290342 }, { 7.36473376998959, 0, 2.40402830699334, 0, 8.14459830020353, 0, -0.309617308211011, 0, 0.950861299281366 }, { 6.53144793874476, 0, 2.1317050157524, 0, 7.22178660522225, 0, -0.307626249376151, 0, 0.951507276429933 }, { 5.83605154103468, 0, 1.90429374259175, 0, 6.45137372567232, 0, -0.30500689384183, 0, 0.952350146964281 }, { 5.24371206727958, 0, 1.71059892741966, 0, 5.79518841268641, 0, -0.303635647576824, 0, 0.952788204709726 }, { 4.73810380820372, 0, 1.54522938334075, 0, 5.23466318962982, 0, -0.302822473663033, 0, 0.953046986955509 }, { 4.30381773917658, 0, 1.40320807691864, 0, 4.75332427814053, 0, -0.302606770064826, 0, 0.953115456110144 }, { 3.93138513228752, 0, 1.28140419048925, 0, 4.34030449322608, 0, -0.302781173775577, 0, 0.953060119278415 }, { 3.61226084973238, 0, 1.17698364227078, 0, 3.98619316252657, 0, -0.302997549598822, 0, 0.952991369975792 }, { 3.3248118608319, 0, 1.08270206602851, 0, 3.66703555630431, 0, -0.302128572866614, 0, 0.953267218528246 }, { 3.06966806640443, 0, 0.998557760554868, 0, 3.38324107048024, 0, -0.299642274225005, 0, 0.954051643679732 }, { 2.84645436402431, 0, 0.924524761567162, 0, 3.13450583621641, 0, -0.296010586574462, 0, 0.955184611408804 }, { 2.64779125366485, 0, 0.858442677838165, 0, 2.91309626520126, 0, -0.292978503455367, 0, 0.956118989678809 }, { 2.47238041478918, 0, 0.799763405747736, 0, 2.71719293788841, 0, -0.289651603857034, 0, 0.957132204000804 }, { 2.31710158896997, 0, 0.747489246342193, 0, 2.54259043067706, 0, -0.286644979673047, 0, 0.958036847629858 }, { 2.17864589943665, 0, 0.700614482904412, 0, 2.38677390113687, 0, -0.283839142627588, 0, 0.958871922201605 }, { 2.05331361012487, 0, 0.657714646954969, 0, 2.24632986535431, 0, -0.280604222051531, 0, 0.959823578126293 }, { 1.9403031296284, 0, 0.617878568845295, 0, 2.11748511216075, 0, -0.2751763437165, 0, 0.961393764522585 }, { 1.83786496787707, 0, 0.581368601356511, 0, 2.00152723957768, 0, -0.270022369088637, 0, 0.962854004681425 }, { 1.7472822490228, 0, 0.548271240824888, 0, 1.89693984795557, 0, -0.264879266088062, 0, 0.964281545053695 }, { 1.666164976056, 0, 0.517799753891185, 0, 1.8023993911021, 0, -0.259602947341676, 0, 0.965715406242559 }, { 1.592111645148, 0, 0.488700468624525, 0, 1.71566474992239, 0, -0.253055702159039, 0, 0.967451731540376 }, { 1.52490373550527, 0, 0.461223496559214, 0, 1.63625176416564, 0, -0.246202132758881, 0, 0.969218518543227 }, { 1.46415567299827, 0, 0.435369376201814, 0, 1.56375181387695, 0, -0.239364388365431, 0, 0.970929812661746 }, { 1.40991257096823, 0, 0.410595590448756, 0, 1.49846593001422, 0, -0.231790504918519, 0, 0.972765710654976 }, { 1.35982952131415, 0, 0.38670776132812, 0, 1.43792789762934, 0, -0.223571247354168, 0, 0.974687604423233 }, { 1.31339811281018, 0, 0.363570205636981, 0, 1.38293256165175, 0, -0.215452296189657, 0, 0.976514396413859 }, { 1.27263782454318, 0, 0.341356036337054, 0, 1.33277407511936, 0, -0.206534080108698, 0, 0.978439425488544 }, { 1.23434048005263, 0, 0.319607564513821, 0, 1.28692149100399, 0, -0.197465913473343, 0, 0.98030972019511 }, { 1.16267913709368, 0, 0.289790417045549, 0, 1.20621838515044, 0, -0.188138145290846, 0, 0.982142583622979 }, { 1.16549996863464, 0, 0.278228611134505, 0, 1.20621838515044, 0, -0.17837440703259, 0, 0.983962722686818 }, { 1.10453471061772, 0, 0.249954018458823, 0, 1.13825094510539, 0, -0.168603878628374, 0, 0.985683924666425 }, { 1.10706816050552, 0, 0.238482678551349, 0, 1.13825094510539, 0, -0.158369815303845, 0, 0.987379885833316 }, { 1.03213284218256, 0, 0.206044380274172, 0, 1.05768644083949, 0, -0.148232322616944, 0, 0.988952555133873 }, { 1.03424828043517, 0, 0.19514865278109, 0, 1.05768644083949, 0, -0.137795163575304, 0, 0.990460741898094 }, { 1.03624835862261, 0, 0.184233159694782, 0, 1.05768644083949, 0, -0.127344534111938, 0, 0.991858544386699 }, { 0.993144894275684, 0, 0.116890134872118, 0, 1, 0, -0.116890134872118, 0, 0.993144894275684 }, { 0.994328140280719, 0, 0.106355763872144, 0, 1, 0, -0.106355763872144, 0, 0.994328140280719 }, { 0.995381170856521, 0, 0.0960016617723692, 0, 1, 0, -0.0960016617723692, 0, 0.995381170856521 }, { 0.996333322963335, 0, 0.0855565983978029, 0, 1, 0, -0.0855565983978029, 0, 0.996333322963335 }, { 0.99716026162234, 0, 0.075308423144598, 0, 1, 0, -0.075308423144598, 0, 0.99716026162234 }, { 0.997867247569558, 0, 0.0652757038234384, 0, 1, 0, -0.0652757038234384, 0, 0.997867247569558 }, { 0.998472465412748, 0, 0.0552516884982738, 0, 1, 0, -0.0552516884982738, 0, 0.998472465412748 }, { 0.998967767765722, 0, 0.0454246625760731, 0, 1, 0, -0.0454246625760731, 0, 0.998967767765722 }, { 0.999355862833256, 0, 0.0358877318843533, 0, 1, 0, -0.0358877318843533, 0, 0.999355862833256 }, { 0.999650341374855, 0, 0.0264397041030463, 0, 1, 0, -0.0264397041030463, 0, 0.999650341374855 }, { 0.999849406403121, 0, 0.0173548800028461, 0, 1, 0, -0.0173548800028461, 0, 0.999849406403121 }, { 0.999963088764031, 0, 0.00858405116394479, 0, 1, 0, -0.00858405116394479, 0, 0.999963088764031 }, { 0.999999995609671, 0, -6.62595554605566E-05, 0, 1, 0, 6.62595554605566E-05, 0, 0.999999995609671 },    // Cos(theta) = 0.9506173
            { 235.827482030401, 0, 82.977742730094, 0, 265.023909822948, 0, -0.331910838950051, 0, 0.943310794834245 }, { 235.827486787299, 0, 82.9776892142332, 0, 265.023909822948, 0, -0.331910624886434, 0, 0.943310813861764 }, { 235.827524570958, 0, 82.9777076127297, 0, 265.023704290775, 0, -0.331910024958887, 0, 0.943311066345505 }, { 207.999236441904, 0, 73.1861066827504, 0, 233.751075913095, 0, -0.331910517854631, 0, 0.94331082337549 }, { 116.999262097003, 0, 41.1670560183254, 0, 131.48444785951, 0, -0.331908964519084, 0, 0.943311459339752 }, { 74.8790240369429, 0, 26.346714904254, 0, 84.1497276879547, 0, -0.331904071409595, 0, 0.943313172162519 }, { 51.9987888602081, 0, 18.2961119367331, 0, 58.4366443670989, 0, -0.331896420126467, 0, 0.943315876865226 }, { 38.2027775087584, 0, 13.4418554554252, 0, 42.9319973299324, 0, -0.331884159392139, 0, 0.943320219059873 }, { 29.2484665927029, 0, 10.2911855001115, 0, 32.8685650028316, 0, -0.331865316708925, 0, 0.943326788427944 }, { 23.109191557917, 0, 8.1310013550933, 0, 25.9688129400506, 0, -0.331838268665361, 0, 0.943336275887313 }, { 18.7176995699166, 0, 6.58578478518432, 0, 21.0330690577038, 0, -0.331799312073728, 0, 0.943349970860027 }, { 15.4684158419751, 0, 5.44245291564755, 0, 17.3808400275573, 0, -0.331749590258131, 0, 0.943367486938869 }, { 12.9968979851546, 0, 4.5727813002756, 0, 14.6027622616115, 0, -0.331682626346688, 0, 0.943391036198743 }, { 11.0733456496755, 0, 3.89590775434207, 0, 12.4404730778365, 0, -0.331597733884885, 0, 0.943420854179256 }, { 9.54698633050646, 0, 3.35877939166635, 0, 10.7244944628155, 0, -0.331485794970545, 0, 0.943460189272067 }, { 8.31577320615762, 0, 2.92549195140875, 0, 9.34010091459679, 0, -0.331327859639188, 0, 0.943515644655093 }, { 7.30899480614459, 0, 2.57113983615277, 0, 8.20792383262139, 0, -0.330980120690133, 0, 0.943637724701773 }, { 6.48483932339183, 0, 2.28082213989755, 0, 7.28082143399452, 0, -0.328405138599456, 0, 0.944537000784884 }, { 5.79241051229309, 0, 2.03684134947802, 0, 6.50180996387847, 0, -0.326278974186937, 0, 0.945273601626758 }, { 5.20395021295229, 0, 1.82947056904892, 0, 5.83945865194763, 0, -0.325008875890719, 0, 0.945710976602951 }, { 4.70181577203571, 0, 1.65247146279822, 0, 5.27410066057153, 0, -0.324138434363961, 0, 0.946009613286983 }, { 4.2707256688415, 0, 1.50048902174632, 0, 4.78857800909283, 0, -0.323667795447411, 0, 0.946170837269468 }, { 3.90150956571841, 0, 1.37021797610818, 0, 4.37272216975145, 0, -0.323050523357596, 0, 0.946381759584097 }, { 3.58382121568782, 0, 1.25811603749674, 0, 4.01459984372569, 0, -0.322997537829794, 0, 0.946399800881091 }, { 3.30090847017193, 0, 1.15826114955403, 0, 3.69546082384208, 0, -0.323099435889305, 0, 0.946364975563662 }, { 3.04844221202127, 0, 1.06846908292507, 0, 3.40965025709496, 0, -0.320265865611954, 0, 0.947327663363087 }, { 2.82659436386708, 0, 0.989157404719073, 0, 3.15863183247574, 0, -0.316589516404381, 0, 0.94856265779695 }, { 2.62958589912974, 0, 0.918510160081818, 0, 2.93525947705273, 0, -0.313345739877717, 0, 0.949639080251743 }, { 2.45600302221721, 0, 0.855779087731177, 0, 2.73752686327076, 0, -0.309477393192874, 0, 0.950906858428274 }, { 2.30102573658915, 0, 0.799550231744494, 0, 2.56084228144261, 0, -0.306201525888489, 0, 0.951966728762766 }, { 2.16366884386312, 0, 0.749307929444206, 0, 2.40376930710223, 0, -0.302780993347612, 0, 0.953060173802613 }, { 2.04052362371734, 0, 0.703767573322398, 0, 2.26232305101661, 0, -0.299532232553268, 0, 0.95408617776336 }, { 1.92875797564553, 0, 0.661416988787306, 0, 2.13283720478524, 0, -0.294224861453264, 0, 0.955736230177757 }, { 1.82809242789422, 0, 0.622386534774803, 0, 2.01553094857201, 0, -0.288382545782199, 0, 0.957515252064029 }, { 1.73878985929764, 0, 0.586999953592038, 0, 1.90945153342857, 0, -0.282784028226784, 0, 0.959183577307049 }, { 1.65825094129598, 0, 0.5541171981048, 0, 1.81411688203203, 0, -0.277013429147193, 0, 0.960866062087322 }, { 1.58660361970838, 0, 0.523414426893805, 0, 1.72642640974058, 0, -0.27044348232384, 0, 0.962735878150284 }, { 1.51979636448408, 0, 0.493825675963391, 0, 1.64615965759575, 0, -0.262843376296179, 0, 0.964838526296697 }, { 1.4613197661549, 0, 0.466286125957176, 0, 1.57305717031548, 0, -0.255358793638057, 0, 0.966846378080949 }, { 1.40785354888829, 0, 0.439696634529918, 0, 1.50648597140116, 0, -0.247592718251242, 0, 0.968864205794674 }, { 1.35827039460483, 0, 0.41399050779681, 0, 1.44564413976893, 0, -0.238744670831107, 0, 0.9710824294852 }, { 1.31280510367479, 0, 0.389425303743356, 0, 1.38958038262437, 0, -0.229871903369769, 0, 0.973220903768135 }, { 1.27157793534718, 0, 0.365716430452844, 0, 1.33950601200006, 0, -0.220692380504469, 0, 0.975343462453725 }, { 1.23395327434851, 0, 0.342573453758893, 0, 1.29288492511636, 0, -0.210750755297564, 0, 0.977539821820201 }, { 1.19790192387107, 0, 0.319796430893442, 0, 1.2497623537188, 0, -0.200921272977705, 0, 0.979607444148774 }, { 1.13337382986982, 0, 0.288438266738281, 0, 1.17537779492927, 0, -0.190438800245809, 0, 0.981699091414982 }, { 1.13637859492977, 0, 0.276363122693188, 0, 1.17537779492926, 0, -0.179982984742284, 0, 0.983669750798474 }, { 1.07885342410382, 0, 0.2469914933319, 0, 1.11230544461508, 0, -0.169112732556255, 0, 0.985596775757913 }, { 1.08151212774309, 0, 0.235076467256981, 0, 1.11230544461508, 0, -0.158231088269326, 0, 0.987402135723151 }, { 1.03436389752074, 0, 0.208066380123954, 0, 1.0597048884996, 0, -0.1471037957533, 0, 0.989121041680618 }, { 1.03662082649447, 0, 0.196513394245669, 0, 1.0597048884996, 0, -0.136059363656717, 0, 0.990700649214811 }, { 0.99218489375689, 0, 0.124776171670043, 0, 1, 0, -0.124776171670043, 0, 0.99218489375689 }, { 0.993516526100163, 0, 0.11368761518781, 0, 1, 0, -0.11368761518781, 0, 0.993516526100163 }, { 0.99474020141777, 0, 0.102430195985428, 0, 1, 0, -0.102430195985428, 0, 0.99474020141777 }, { 0.995819526779133, 0, 0.0913430225278038, 0, 1, 0, -0.0913430225278038, 0, 0.995819526779133 }, { 0.996760341124524, 0, 0.0804291915200696, 0, 1, 0, -0.0804291915200696, 0, 0.996760341124524 }, { 0.997574365206921, 0, 0.0696082056993878, 0, 1, 0, -0.0696082056993878, 0, 0.997574365206921 }, { 0.998256836032965, 0, 0.0590186701690794, 0, 1, 0, -0.0590186701690794, 0, 0.998256836032965 }, { 0.998819080596454, 0, 0.0485852999104673, 0, 1, 0, -0.0485852999104673, 0, 0.998819080596454 }, { 0.999265928791548, 0, 0.0383080131370851, 0, 1, 0, -0.0383080131370851, 0, 0.999265928791548 }, { 0.999599146209092, 0, 0.0283124348436488, 0, 1, 0, -0.0283124348436488, 0, 0.999599146209092 }, { 0.999827739571073, 0, 0.0185603927262987, 0, 1, 0, -0.0185603927262987, 0, 0.999827739571073 }, { 0.999959176772993, 0, 0.00903608003424201, 0, 1, 0, -0.00903608003424201, 0, 0.999959176772993 }, { 0.999999992387149, 0, -8.72516532305482E-05, 0, 1, 0, 8.72516532305482E-05, 0, 0.999999992387149 },    // Cos(theta) = 0.9433107
            { 233.87463407516, 0, 88.3314162691579, 0, 267.236855092602, 0, -0.353326641867078, 0, 0.935500008256805 }, { 233.874601978428, 0, 88.3314050005158, 0, 267.236957086068, 0, -0.353326143515681, 0, 0.935500209015035 }, { 233.874497168956, 0, 88.3313688349778, 0, 267.236606, 0, -0.353325925222072, 0, 0.935500321904524 }, { 206.277189549175, 0, 77.9082153513093, 0, 235.702483552228, 0, -0.353324200150561, 0, 0.935500888514143 }, { 116.030850553096, 0, 43.8233203472174, 0, 132.582174967118, 0, -0.353322766856856, 0, 0.935501515800998 }, { 74.2591549447122, 0, 28.0466735838236, 0, 84.8523261655385, 0, -0.353317939847252, 0, 0.935503385410253 }, { 51.5682853858442, 0, 19.4766030471343, 0, 58.9245369946813, 0, -0.353308581798351, 0, 0.935506784245064 }, { 37.8863578956779, 0, 14.3090898277917, 0, 43.2905881510836, 0, -0.35329393229226, 0, 0.935512381833478 }, { 29.0062505622935, 0, 10.955152888671, 0, 33.1430513195667, 0, -0.353271083950448, 0, 0.935521070411369 }, { 22.9179583483341, 0, 8.65564210568642, 0, 26.1856625318359, 0, -0.353238115191156, 0, 0.935533508221307 }, { 18.5628493612964, 0, 7.01072792564102, 0, 21.2087081464687, 0, -0.353192449056666, 0, 0.935550690864445 }, { 15.3404937791428, 0, 5.79363292575086, 0, 17.5259910728044, 0, -0.3531306121348, 0, 0.935574082913665 }, { 12.8895206526658, 0, 4.86787133930261, 0, 14.7246376482751, 0, -0.353051531634485, 0, 0.935603905274026 }, { 10.9820629149937, 0, 4.14737761979153, 0, 12.5442020969738, 0, -0.352949289285605, 0, 0.935642494464846 }, { 9.46835618600338, 0, 3.57559402696822, 0, 10.8139788761974, 0, -0.352815660700239, 0, 0.935692854323276 }, { 8.24749766292395, 0, 3.11439263264843, 0, 9.41796133855524, 0, -0.352625411176644, 0, 0.935764581278812 }, { 7.24950063281181, 0, 2.73733260938229, 0, 8.27668291251651, 0, -0.352159281486075, 0, 0.935940159019651 }, { 6.43346541098063, 0, 2.42874763939423, 0, 7.34338092208188, 0, -0.349319408576094, 0, 0.93700367907431 }, { 5.74530839865305, 0, 2.16848938621633, 0, 6.55598604266557, 0, -0.347488825083779, 0, 0.9376841309743 }, { 5.16142347195102, 0, 1.94762772864958, 0, 5.8877091644474, 0, -0.346222703759807, 0, 0.938152407728746 }, { 4.66313727570004, 0, 1.75907370038531, 0, 5.3170838127951, 0, -0.345297445937809, 0, 0.93849328463401 }, { 4.23565860118642, 0, 1.59725038707646, 0, 4.82749161464447, 0, -0.344558484342482, 0, 0.938764910670264 }, { 3.87045884252601, 0, 1.45878426864971, 0, 4.40888060773662, 0, -0.343081419550534, 0, 0.939305676390083 }, { 3.55359488530606, 0, 1.33875518926196, 0, 4.04558252338602, 0, -0.342993771779499, 0, 0.939337686440961 }, { 3.27548624082152, 0, 1.23348315577751, 0, 3.72642075172415, 0, -0.34382474769143, 0, 0.939033794002855 }, { 3.02591353619787, 0, 1.13811213450786, 0, 3.43882327126968, 0, -0.340570001786844, 0, 0.940219161113441 }, { 2.80556303641123, 0, 1.05358211671382, 0, 3.18469994030316, 0, -0.337049799538948, 0, 0.941486800452865 }, { 2.61030834065398, 0, 0.978351847697635, 0, 2.95935198176505, 0, -0.333435789917898, 0, 0.942772742198922 }, { 2.43767509611047, 0, 0.911344541134908, 0, 2.75938460777814, 0, -0.32934770531672, 0, 0.944208671332455 }, { 2.28458505735058, 0, 0.851595585837599, 0, 2.58124862117117, 0, -0.325570110105972, 0, 0.945517908059894 }, { 2.14819180874749, 0, 0.797885558623877, 0, 2.42236069966988, 0, -0.321747845226502, 0, 0.946825402090063 }, { 2.02731905981407, 0, 0.749605787446168, 0, 2.27935855803828, 0, -0.317984132478313, 0, 0.948096032496768 }, { 1.91677412454279, 0, 0.704734031543218, 0, 2.14906280922598, 0, -0.313133041772244, 0, 0.949709238115901 }, { 1.81780901930828, 0, 0.663247043169783, 0, 2.03039869259023, 0, -0.306742959582266, 0, 0.951792431368876 }, { 1.72955508435763, 0, 0.625415470040692, 0, 1.9232529133386, 0, -0.300420737412809, 0, 0.953806742300383 }, { 1.65129964400468, 0, 0.590462707792335, 0, 1.82568582086305, 0, -0.294171993387954, 0, 0.955752506323969 }, { 1.58132609830162, 0, 0.557935403948823, 0, 1.73758900613891, 0, -0.287566715721567, 0, 0.957760652648643 }, { 1.51634496994184, 0, 0.526737285896185, 0, 1.65619311026684, 0, -0.279510819282045, 0, 0.96014253021415 }, { 1.45746056544356, 0, 0.496915300156528, 0, 1.58239108294457, 0, -0.271228095913563, 0, 0.962515084096646 }, { 1.40551366985463, 0, 0.46913294432779, 0, 1.51505925373005, 0, -0.262935830440513, 0, 0.96481329070658 }, { 1.35645622563252, 0, 0.441822083849568, 0, 1.45392149757848, 0, -0.253798764367044, 0, 0.967257066090594 }, { 1.31165026769347, 0, 0.415612817667916, 0, 1.39775366329653, 0, -0.244098808654187, 0, 0.969750389302639 }, { 1.27049152368255, 0, 0.390080061466903, 0, 1.34681258358601, 0, -0.234404877009768, 0, 0.97213906125032 }, { 1.23296624885911, 0, 0.365538811370911, 0, 1.29942796428613, 0, -0.223955982672381, 0, 0.974599280025179 }, { 1.19843620175715, 0, 0.341240929199748, 0, 1.25651042558443, 0, -0.213300546251375, 0, 0.976986679154581 }, { 1.16513958949925, 0, 0.317341263005069, 0, 1.21644028493309, 0, -0.202456379280871, 0, 0.97929130515349 }, { 1.13575368956914, 0, 0.294535615303467, 0, 1.18063858946914, 0, -0.191074763246791, 0, 0.981575418558205 }, { 1.07893959573331, 0, 0.263351512101279, 0, 1.11640799507611, 0, -0.17979817339373, 0, 0.983703485661312 }, { 1.0820165291652, 0, 0.250409779416202, 0, 1.11640799507611, 0, -0.168003106923666, 0, 0.985786495181112 }, { 1.03430438111345, 0, 0.221553803835096, 0, 1.06242598244473, 0, -0.156423834577327, 0, 0.98769001656914 }, { 1.03690899553953, 0, 0.209025043490739, 0, 1.06242598244473, 0, -0.144463757566346, 0, 0.989510126664054 }, { 0.991157164506216, 0, 0.132693125511895, 0, 1, 0, -0.132693125511895, 0, 0.991157164506216 }, { 0.992684021521247, 0, 0.120740996815693, 0, 1, 0, -0.120740996815693, 0, 0.992684021521247 }, { 0.994053258094894, 0, 0.10889478267865, 0, 1, 0, -0.10889478267865, 0, 0.994053258094894 }, { 0.995270769296534, 0, 0.0971394683883866, 0, 1, 0, -0.0971394683883866, 0, 0.995270769296534 }, { 0.996343071990513, 0, 0.0854431885277326, 0, 1, 0, -0.0854431885277326, 0, 0.996343071990513 }, { 0.997254055526958, 0, 0.0740562663947614, 0, 1, 0, -0.0740562663947614, 0, 0.997254055526958 }, { 0.998033312301743, 0, 0.0626855248696739, 0, 1, 0, -0.0626855248696739, 0, 0.998033312301743 }, { 0.998668053852853, 0, 0.0515960959300171, 0, 1, 0, -0.0515960959300171, 0, 0.998668053852853 }, { 0.999166897891413, 0, 0.0408098334778552, 0, 1, 0, -0.0408098334778552, 0, 0.999166897891413 }, { 0.99954617083891, 0, 0.0301219803860295, 0, 1, 0, -0.0301219803860295, 0, 0.99954617083891 }, { 0.999805175448447, 0, 0.0197376433990566, 0, 1, 0, -0.0197376433990566, 0, 0.999805175448447 }, { 0.999952958983591, 0, 0.00969573412519062, 0, 1, 0, -0.00969573412519062, 0, 0.999952958983591 }, { 0.99999998541826, 0, -0.0001207548758102, 0, 1, 0, 0.0001207548758102, 0, 0.99999998541826 },    // Cos(theta) = 0.9355001
            { 231.796512841694, 0, 93.6505503227269, 0, 269.632917420856, 0, -0.374601502943489, 0, 0.927185853643074 }, { 231.796201711165, 0, 93.6504269294377, 0, 269.63322485518, 0, -0.3746012885612, 0, 0.927186060664998 }, { 231.796489067469, 0, 93.6505466147395, 0, 269.632779154673, 0, -0.374601692943384, 0, 0.927185835884941 }, { 204.444207807939, 0, 82.5996529845859, 0, 237.816188184283, 0, -0.374601139965628, 0, 0.927186121299444 }, { 114.999358443249, 0, 46.4620698401921, 0, 133.771250805656, 0, -0.374597680858, 0, 0.927187473001767 }, { 73.5993463690399, 0, 29.73558973184, 0, 85.6130083790854, 0, -0.374592141388297, 0, 0.927189673524483 }, { 51.1099636432309, 0, 20.6493906021306, 0, 59.4528989047748, 0, -0.374581485250934, 0, 0.927193997469215 }, { 37.549665006506, 0, 15.1707160595646, 0, 43.6787404637163, 0, -0.37456272032971, 0, 0.927201593354622 }, { 28.7484972799219, 0, 11.6148242914741, 0, 33.4404759982264, 0, -0.374535443296475, 0, 0.927212600638028 }, { 22.7143067060663, 0, 9.17684145153267, 0, 26.4205718531335, 0, -0.374496595597753, 0, 0.927228312634659 }, { 18.3980223263158, 0, 7.43291784369669, 0, 21.3990060273246, 0, -0.374442037744321, 0, 0.927250317815042 }, { 15.204375970352, 0, 6.14255286275968, 0, 17.6831059402521, 0, -0.374369387992233, 0, 0.927279663881363 }, { 12.7752121480369, 0, 5.16104430150966, 0, 14.856603754797, 0, -0.374274822738319, 0, 0.927317790466134 }, { 10.8847567571083, 0, 4.39717881388287, 0, 12.6565928628475, 0, -0.374154129843596, 0, 0.927366503573505 }, { 9.38467128382155, 0, 3.79101264312682, 0, 10.9107698599102, 0, -0.373995111357318, 0, 0.927430654775441 }, { 8.17474464783714, 0, 3.30206724543445, 0, 9.50229903127789, 0, -0.373767842363828, 0, 0.927522275817726 }, { 7.18660919065657, 0, 2.90267600246842, 0, 8.35179741699272, 0, -0.373108990757414, 0, 0.927787487426296 }, { 6.37808728947869, 0, 2.57559810275855, 0, 7.41038158894054, 0, -0.370192617086443, 0, 0.928955018290696 }, { 5.69516134692282, 0, 2.29933057725197, 0, 6.61467302897113, 0, -0.368539947124807, 0, 0.929611981614433 }, { 5.11622203865464, 0, 2.06507012158416, 0, 5.94007357663094, 0, -0.367267784792267, 0, 0.930115200313127 }, { 4.62202509119345, 0, 1.86499137172103, 0, 5.36368823980994, 0, -0.366287285882173, 0, 0.930501805528886 }, { 4.1987422183124, 0, 1.69352657334649, 0, 4.86996353217581, 0, -0.365241208925044, 0, 0.930912843009862 }, { 3.8370197742369, 0, 1.54673294349159, 0, 4.44773079763846, 0, -0.36328470638363, 0, 0.931678174167494 }, { 3.52174159302053, 0, 1.41889496261235, 0, 4.07935204258214, 0, -0.362931036897957, 0, 0.931815949518098 }, { 3.24708154860082, 0, 1.30761426849029, 0, 3.75826472156234, 0, -0.363602878906012, 0, 0.93155400844804 }, { 3.0020907130963, 0, 1.20750278368971, 0, 3.47028830341088, 0, -0.360711746752742, 0, 0.932677294026829 }, { 2.78298568150964, 0, 1.11763015562319, 0, 3.21307752233527, 0, -0.357310639919713, 0, 0.933985539145509 }, { 2.58961447470966, 0, 1.03783093197685, 0, 2.98580971295406, 0, -0.353269683608341, 0, 0.935521509586572 }, { 2.41865695612654, 0, 0.966784891345035, 0, 2.78333977720138, 0, -0.349057605633985, 0, 0.937101300319043 }, { 2.26685988435167, 0, 0.903223104432871, 0, 2.60321909217327, 0, -0.344714462567109, 0, 0.938707589585747 }, { 2.13195821693195, 0, 0.846246683515076, 0, 2.4420295622416, 0, -0.340536311618373, 0, 0.940231342669426 }, { 2.0126563299105, 0, 0.795081969273726, 0, 2.29751747462414, 0, -0.336264792545976, 0, 0.941767439924004 }, { 1.90528599994514, 0, 0.748187312583284, 0, 2.16679691399174, 0, -0.331633300246978, 0, 0.94340837188933 }, { 1.80852610926661, 0, 0.704519290511517, 0, 2.04612587343958, 0, -0.324999871660994, 0, 0.945714064613976 }, { 1.72110146489048, 0, 0.664015394905019, 0, 1.93743526015447, 0, -0.318091784484238, 0, 0.948059930018497 }, { 1.64477724955625, 0, 0.627054433187911, 0, 1.83823201771086, 0, -0.311146386792137, 0, 0.950361960938588 }, { 1.57537336495986, 0, 0.592671379428682, 0, 1.74914851569179, 0, -0.304090145038777, 0, 0.952643317756383 }, { 1.51225033265069, 0, 0.560100053612687, 0, 1.66739176218166, 0, -0.295996862193316, 0, 0.955188890092053 }, { 1.45409930508657, 0, 0.528557805885547, 0, 1.59266886898913, 0, -0.287059593561775, 0, 0.957912704516613 }, { 1.40236315973989, 0, 0.498863122353714, 0, 1.5247463640284, 0, -0.278077246377437, 0, 0.96055871807436 }, { 1.35470067788523, 0, 0.470223382416294, 0, 1.46314064994096, 0, -0.268754344329223, 0, 0.963208774669315 }, { 1.30996670857767, 0, 0.442125102805318, 0, 1.40591211381125, 0, -0.258347401418282, 0, 0.966052038432986 }, { 1.2697704153534, 0, 0.414944327667241, 0, 1.35391169681736, 0, -0.247912443372532, 0, 0.968782394053077 }, { 1.23310805932544, 0, 0.389162259219142, 0, 1.30648576546505, 0, -0.237189669071405, 0, 0.971463336099637 }, { 1.19789289751297, 0, 0.363129195790979, 0, 1.26260077686565, 0, -0.225670360267431, 0, 0.974203669931745 }, { 1.16601608746156, 0, 0.337773953986469, 0, 1.22261557573142, 0, -0.214247161319174, 0, 0.976779502440113 }, { 1.13570831066268, 0, 0.312985571529191, 0, 1.18609290608507, 0, -0.202235775430085, 0, 0.979336868567133 }, { 1.10917018886131, 0, 0.289334974531401, 0, 1.15229718248673, 0, -0.190164230143008, 0, 0.981752311679855 }, { 1.08254365208949, 0, 0.265733926842762, 0, 1.12051500384127, 0, -0.177802916039171, 0, 0.984066104919194 }, { 1.01053626227365, 0, 0.226028439754817, 0, 1.0414783026764, 0, -0.165358580965063, 0, 0.986233489877572 }, { 1.01330965125692, 0, 0.213250912285057, 0, 1.04147830267641, 0, -0.152892748022114, 0, 0.98824276971429 }, { 1.01592646639186, 0, 0.200414156488539, 0, 1.0414783026764, 0, -0.140377951033533, 0, 0.990097981128686 }, { 0.991802544151242, 0, 0.12777959158221, 0, 1, 0, -0.12777959158221, 0, 0.991802544151242 }, { 0.993328190518703, 0, 0.115321648410814, 0, 1, 0, -0.115321648410814, 0, 0.993328190518703 }, { 0.994700295063354, 0, 0.102817144866483, 0, 1, 0, -0.102817144866483, 0, 0.994700295063354 }, { 0.995886113888218, 0, 0.0906142074702276, 0, 1, 0, -0.0906142074702276, 0, 0.995886113888218 }, { 0.996926627374735, 0, 0.0783406764263908, 0, 1, 0, -0.0783406764263908, 0, 0.996926627374735 }, { 0.997795384395508, 0, 0.0663657439200666, 0, 1, 0, -0.0663657439200666, 0, 0.997795384395508 }, { 0.99850485511219, 0, 0.0546628969796744, 0, 1, 0, -0.0546628969796744, 0, 0.99850485511219 }, { 0.999072580637694, 0, 0.0430581880154704, 0, 1, 0, -0.0430581880154704, 0, 0.999072580637694 }, { 0.999491471765687, 0, 0.0318884949003494, 0, 1, 0, -0.0318884949003494, 0, 0.999491471765687 }, { 0.99977991856159, 0, 0.0209784019038428, 0, 1, 0, -0.0209784019038428, 0, 0.99977991856159 }, { 0.999947697345016, 0, 0.0102319307503664, 0, 1, 0, -0.0102319307503664, 0, 0.999947697345016 }, { 0.99999998425283, 0, -0.000125487725951899, 0, 1, 0, 0.000125487725951899, 0, 0.99999998425283 },    // Cos(theta) = 0.9271857
            { 229.592153827578, 0, 98.932361122772, 0, 272.22181052048, 0, -0.395730007840157, 0, 0.918366884020347 }, { 229.591894811641, 0, 98.9322507255522, 0, 272.221799916389, 0, -0.395728924398607, 0, 0.918367336355623 }, { 229.591380540687, 0, 98.9320357077786, 0, 272.222072324926, 0, -0.395728717329779, 0, 0.91836746871359 }, { 202.499739457355, 0, 87.2581049805898, 0, 240.099479113734, 0, -0.39572763388689, 0, 0.918367921045821 }, { 113.905584380057, 0, 49.0824269455266, 0, 135.055847416993, 0, -0.395724822933431, 0, 0.918369160173261 }, { 72.8992490845924, 0, 31.4125695704102, 0, 86.4353251992199, 0, -0.395717136440919, 0, 0.918372434687204 }, { 50.6238735073987, 0, 21.8139699454336, 0, 60.0239388205897, 0, -0.395704535752545, 0, 0.918377871924226 }, { 37.1923902348204, 0, 16.0262384818133, 0, 44.0982303767013, 0, -0.395683831645626, 0, 0.918386763194307 }, { 28.4749922834198, 0, 12.2698251241528, 0, 33.7616961053415, 0, -0.395650088785201, 0, 0.91840129132889 }, { 22.498292936684, 0, 9.69438059272964, 0, 26.6743766166426, 0, -0.39560459896383, 0, 0.918420953373349 }, { 18.2230979486158, 0, 7.85211003047699, 0, 21.6045417556261, 0, -0.395540710859586, 0, 0.918448440276273 }, { 15.0599045925367, 0, 6.48899696168465, 0, 17.8530808654275, 0, -0.39545467619843, 0, 0.918485534762904 }, { 12.6539516628553, 0, 5.45216999959772, 0, 14.999225397593, 0, -0.395344214868265, 0, 0.918533066944034 }, { 10.7815679488766, 0, 4.64524655003944, 0, 12.7780427827429, 0, -0.395201109979057, 0, 0.918594573247962 }, { 9.29582911398835, 0, 4.00492114774795, 0, 11.0153869568471, 0, -0.395016183336991, 0, 0.918674147591264 }, { 8.09751842938496, 0, 3.48842948926472, 0, 9.59361344252438, 0, -0.394742298703683, 0, 0.918791863741593 }, { 7.12070079370872, 0, 3.06728859715153, 0, 8.43402342771755, 0, -0.393737767778036, 0, 0.919222772915667 }, { 6.31903572018993, 0, 2.72142276417378, 0, 7.48264364716361, 0, -0.390936276472679, 0, 0.920417775523731 }, { 5.64194351969849, 0, 2.4292899839406, 0, 6.67844224373895, 0, -0.389388037061452, 0, 0.921073823352148 }, { 5.06795962435525, 0, 2.18155383906779, 0, 5.99628015509974, 0, -0.388183859291016, 0, 0.921581988352646 }, { 4.57853925668785, 0, 1.97022938312083, 0, 5.41425277709592, 0, -0.387090658378426, 0, 0.922041666966768 }, { 4.15966493934865, 0, 1.78918678911327, 0, 4.9160031324046, 0, -0.385679031825191, 0, 0.9226330526682 }, { 3.80103803498566, 0, 1.63391406776295, 0, 4.48899786951141, 0, -0.383491384212782, 0, 0.923544435931865 }, { 3.48809754870654, 0, 1.49849800354257, 0, 4.11614136491544, 0, -0.382847050048121, 0, 0.923811755817301 }, { 3.21669599485791, 0, 1.38104678444186, 0, 3.7918810324708, 0, -0.382942831666856, 0, 0.923772051770949 }, { 2.97619667179276, 0, 1.27636358781672, 0, 3.50365256825177, 0, -0.380858726032365, 0, 0.924633208414593 }, { 2.75900657442509, 0, 1.18131882607212, 0, 3.24371499237347, 0, -0.377334924710059, 0, 0.926076907872167 }, { 2.5679974043432, 0, 1.09711060537555, 0, 3.01424061563457, 0, -0.372920847431307, 0, 0.927863211238685 }, { 2.398836594995, 0, 1.02208281910213, 0, 2.80930549870055, 0, -0.368578683063717, 0, 0.929596570184313 }, { 2.24854079173014, 0, 0.95479723960456, 0, 2.62696414557272, 0, -0.363787123832504, 0, 0.931482083528485 }, { 2.11527443913041, 0, 0.894523399296953, 0, 2.46359751132375, 0, -0.359166461634926, 0, 0.933273541761335 }, { 1.99790643003123, 0, 0.840503554115455, 0, 2.3168339925344, 0, -0.35445957507194, 0, 0.935071326226536 }, { 1.89316768058901, 0, 0.791293054831137, 0, 2.18460518322545, 0, -0.349494800363945, 0, 0.936938326827075 }, { 1.79878724404959, 0, 0.745687462922241, 0, 2.06277955298731, 0, -0.343012523531233, 0, 0.939330848585759 }, { 1.71294969887949, 0, 0.702889250728536, 0, 1.95232924863312, 0, -0.335612860011134, 0, 0.942000046278463 }, { 1.63663678507861, 0, 0.663761013388586, 0, 1.85238086941957, 0, -0.328086776542175, 0, 0.94464756158409 }, { 1.56871871246459, 0, 0.627404402664615, 0, 1.76192202302914, 0, -0.320393230720631, 0, 0.947284627733063 }, { 1.50681906706222, 0, 0.593305380179871, 0, 1.6792967344141, 0, -0.312270873594956, 0, 0.949993145893973 }, { 1.44969878191502, 0, 0.560097160792188, 0, 1.6039632755535, 0, -0.302718909619525, 0, 0.953079885658923 }, { 1.39785265104418, 0, 0.528427279337008, 0, 1.53475493028955, 0, -0.293004504180961, 0, 0.956111045411794 }, { 1.35186921616993, 0, 0.498617356882696, 0, 1.47200188687856, 0, -0.283162900449355, 0, 0.959071844089825 }, { 1.30789805512256, 0, 0.46877641758968, 0, 1.41467215314612, 0, -0.272466729454534, 0, 0.962165167618381 }, { 1.26750627961051, 0, 0.440033124666432, 0, 1.36185286999973, 0, -0.26120562424257, 0, 0.965283144192713 }, { 1.23151671917052, 0, 0.412037918626289, 0, 1.31372742472704, 0, -0.249919415035011, 0, 0.968266610198013 }, { 1.1973746406777, 0, 0.384874925488857, 0, 1.27008339661064, 0, -0.237930053258653, 0, 0.971282278128323 }, { 1.16551684461433, 0, 0.357874642772746, 0, 1.2286676755254, 0, -0.225693530070404, 0, 0.974198299037757 }, { 1.13593370570403, 0, 0.331602454670539, 0, 1.19185503303335, 0, -0.213381008507067, 0, 0.976968991899885 }, { 1.10900050153046, 0, 0.30634198601453, 0, 1.15715927485497, 0, -0.200417138859908, 0, 0.9797106760382 }, { 1.05480672542379, 0, 0.271253258586286, 0, 1.09576481477792, 0, -0.187599593278849, 0, 0.982245610633677 }, { 1.05837265786105, 0, 0.256988034753436, 0, 1.09576481477792, 0, -0.174321611220072, 0, 0.984688784070459 }, { 1.01283904794367, 0, 0.225217196496379, 0, 1.04396865337671, 0, -0.16126371716613, 0, 0.986911343995467 }, { 1.01579369460473, 0, 0.211492160860575, 0, 1.04396865337671, 0, -0.14789535488264, 0, 0.989003028257868 }, { 0.99087730365401, 0, 0.134766992282335, 0, 1, 0, -0.134766992282335, 0, 0.99087730365401 }, { 0.992595343481804, 0, 0.121467661188253, 0, 1, 0, -0.121467661188253, 0, 0.992595343481804 }, { 0.99409912175083, 0, 0.108475147614824, 0, 1, 0, -0.108475147614824, 0, 0.99409912175083 }, { 0.995440018709881, 0, 0.0953893169281264, 0, 1, 0, -0.0953893169281264, 0, 0.995440018709881 }, { 0.996582005340161, 0, 0.0826092042903324, 0, 1, 0, -0.0826092042903324, 0, 0.996582005340161 }, { 0.997541467545038, 0, 0.070079385776413, 0, 1, 0, -0.070079385776413, 0, 0.997541467545038 }, { 0.998337102011234, 0, 0.0576463569321278, 0, 1, 0, -0.0576463569321278, 0, 0.998337102011234 }, { 0.998961787998487, 0, 0.0455557658374131, 0, 1, 0, -0.0455557658374131, 0, 0.998961787998487 }, { 0.999433924833769, 0, 0.0336407603094094, 0, 1, 0, -0.0336407603094094, 0, 0.999433924833769 }, { 0.999757501788949, 0, 0.0220234041963603, 0, 1, 0, -0.0220234041963603, 0, 0.999757501788949 }, { 0.999940826830758, 0, 0.0108764641640822, 0, 1, 0, -0.0108764641640822, 0, 0.999940826830758 }, { 0.999999989064833, 0, -0.000104571349532037, 0, 1, 0, 0.000104571349532037, 0, 0.999999989064833 },    // Cos(theta) = 0.9183673
            { 227.259763508684, 0, 104.173724650871, 0, 275.015075930608, 0, -0.416697837317208, 0, 0.9090449862281 }, { 227.260745770264, 0, 104.174178617447, 0, 275.014116191965, 0, -0.416696918188861, 0, 0.909045413808813 }, { 227.260664290936, 0, 104.17414587379, 0, 275.013832575085, 0, -0.416697863020599, 0, 0.909045047711653 }, { 200.443569240515, 0, 91.8814296443713, 0, 242.562151058097, 0, -0.416696555537602, 0, 0.909045652089889 }, { 112.749522842025, 0, 51.6832694029979, 0, 136.440678974787, 0, -0.416691526368183, 0, 0.90904792784901 }, { 72.159377390509, 0, 33.0770936619303, 0, 87.3215916660754, 0, -0.416683888424312, 0, 0.909051496301624 }, { 50.1100820864902, 0, 22.9698674303664, 0, 60.6393407528481, 0, -0.416668515800785, 0, 0.909058470942967 }, { 36.8150635163434, 0, 16.8755099872933, 0, 44.5504462004222, 0, -0.416644527156068, 0, 0.909069508074233 }, { 28.1859886022339, 0, 12.9199687109199, 0, 34.1078759285232, 0, -0.416605843824179, 0, 0.909087275869714 }, { 22.269865220733, 0, 10.2080069269353, 0, 26.9480378238172, 0, -0.416553215220217, 0, 0.909111355736844 }, { 18.0382091214633, 0, 8.26818141590657, 0, 21.8262052783379, 0, -0.416478222725967, 0, 0.909145661063486 }, { 14.9071608939627, 0, 6.83284476835736, 0, 18.0361833165353, 0, -0.41637796672646, 0, 0.909191619545242 }, { 12.5257254857937, 0, 5.74111222110327, 0, 15.1531499910933, 0, -0.416247686930808, 0, 0.909251253556962 }, { 10.6723928170046, 0, 4.89143892497484, 0, 12.9090170836461, 0, -0.416083083723764, 0, 0.909326582934207 }, { 9.20184366005478, 0, 4.21721840488711, 0, 11.1282843761973, 0, -0.415867620841891, 0, 0.909425191860844 }, { 8.01596487537007, 0, 3.67345806573272, 0, 9.69200031688652, 0, -0.415538085826153, 0, 0.90957571848132 }, { 7.0524961794943, 0, 3.23151226255633, 0, 8.52468990746274, 0, -0.413863534746525, 0, 0.910338927349889 }, { 6.25617137012059, 0, 2.86608090179222, 0, 7.55981108136965, 0, -0.411610149433995, 0, 0.911360010208758 }, { 5.58536399118897, 0, 2.55818426943803, 0, 6.74639931469555, 0, -0.410136051576737, 0, 0.912024402235634 }, { 5.01707400535435, 0, 2.2972452776219, 0, 6.05698530563738, 0, -0.408911822589695, 0, 0.912573936854362 }, { 4.53277307460286, 0, 2.07475106754291, 0, 5.46895258824836, 0, -0.407686682351281, 0, 0.913121883123275 }, { 4.11892848269937, 0, 1.88438844124773, 0, 4.96648199635977, 0, -0.405795420188504, 0, 0.913963969806023 }, { 3.76297055406317, 0, 1.72042831804573, 0, 4.53368851123131, 0, -0.403629728799665, 0, 0.914922435678354 }, { 3.45296657586723, 0, 1.57762148952691, 0, 4.15611751279407, 0, -0.402628001604195, 0, 0.91536373045088 }, { 3.18524855000779, 0, 1.45412512238549, 0, 3.82839186666998, 0, -0.401978652685355, 0, 0.915649013461999 }, { 2.94845710419088, 0, 1.34471675978763, 0, 3.53947210750427, 0, -0.400847604268584, 0, 0.916144774963857 }, { 2.73367017263939, 0, 1.24463777910132, 0, 3.27697895488342, 0, -0.397088716825089, 0, 0.917780244387975 }, { 2.54538996933316, 0, 1.15619130002502, 0, 3.04442292847608, 0, -0.392501996946984, 0, 0.919751217085161 }, { 2.37776817530024, 0, 1.07700954234942, 0, 2.83715164769066, 0, -0.387857859492416, 0, 0.921719205640436 }, { 2.22932729049819, 0, 1.00612087841735, 0, 2.65253808664091, 0, -0.382774713246285, 0, 0.923841721112664 }, { 2.09906662886699, 0, 0.9429835022633, 0, 2.48632546073747, 0, -0.377565111532005, 0, 0.925983074615024 }, { 1.98319076349027, 0, 0.885969947678773, 0, 2.33762648013329, 0, -0.372425399217802, 0, 0.928062121122098 }, { 1.88115713779776, 0, 0.83468633232686, 0, 2.20344500149962, 0, -0.367073592868463, 0, 0.930191943296494 }, { 1.78811981529467, 0, 0.786947150805116, 0, 2.0813275900082, 0, -0.360866378353787, 0, 0.9326175897752 }, { 1.70416293396347, 0, 0.742251728488772, 0, 1.96896777560586, 0, -0.352906206318216, 0, 0.935658717198385 }, { 1.62920583889001, 0, 0.701060329883763, 0, 1.86747323596741, 0, -0.344773707474646, 0, 0.938685828147506 }, { 1.56198842104557, 0, 0.663198417141836, 0, 1.77553246081361, 0, -0.336548648537409, 0, 0.941666021353548 }, { 1.50125470395603, 0, 0.627038207718566, 0, 1.69203556421427, 0, -0.32798335677927, 0, 0.944683512972325 }, { 1.44550055617636, 0, 0.592078681326552, 0, 1.61567886103463, 0, -0.318309634884769, 0, 0.947986752328142 }, { 1.39433095265867, 0, 0.558714029699416, 0, 1.54515088296102, 0, -0.307886368707242, 0, 0.951423096580253 }, { 1.34878330249831, 0, 0.527168721740284, 0, 1.48202441283769, 0, -0.297359817511869, 0, 0.954765477226124 }, { 1.30647421458507, 0, 0.495999808709106, 0, 1.42353371482525, 0, -0.286474284845593, 0, 0.958087872165395 }, { 1.26621242708472, 0, 0.465142656351918, 0, 1.37005290758407, 0, -0.274507403819206, 0, 0.961584986816715 }, { 1.22963020647367, 0, 0.435414006776171, 0, 1.32092561051324, 0, -0.262422659618858, 0, 0.964952986831955 }, { 1.19736583973435, 0, 0.407100640669662, 0, 1.27691847296765, 0, -0.250101365839677, 0, 0.968219613618682 }, { 1.16500614606556, 0, 0.378168450234528, 0, 1.23549945445234, 0, -0.23704586847515, 0, 0.971498425210956 }, { 1.13591629935252, 0, 0.35038255072507, 0, 1.19731940177433, 0, -0.224062998079499, 0, 0.97457463749447 }, { 1.10871636009276, 0, 0.322976213100662, 0, 1.16211975701621, 0, -0.21060099673411, 0, 0.9775721283009 }, { 1.08340573823007, 0, 0.297165278162458, 0, 1.13038341865346, 0, -0.196964698263333, 0, 0.980410586885318 }, { 1.05906749103744, 0, 0.271223797051882, 0, 1.10046131218884, 0, -0.183278742953304, 0, 0.983060954458026 }, { 1.01258783531759, 0, 0.237154468670327, 0, 1.04728533645562, 0, -0.169363090309532, 0, 0.985553706267334 }, { 1.01580807358224, 0, 0.222958062649756, 0, 1.04728533645562, 0, -0.155551722266356, 0, 0.987827718675462 }, { 0.989931043154565, 0, 0.141550436071413, 0, 1, 0, -0.141550436071413, 0, 0.989931043154565 }, { 0.991801622495534, 0, 0.127786636276549, 0, 1, 0, -0.127786636276549, 0, 0.991801622495534 }, { 0.993486306891211, 0, 0.113951655728959, 0, 1, 0, -0.113951655728959, 0, 0.993486306891211 }, { 0.994954056409843, 0, 0.100331612619317, 0, 1, 0, -0.100331612619317, 0, 0.994954056409843 }, { 0.996216213810046, 0, 0.0869100177133462, 0, 1, 0, -0.0869100177133462, 0, 0.996216213810046 }, { 0.997289128173389, 0, 0.0735822132176486, 0, 1, 0, -0.0735822132176486, 0, 0.997289128173389 }, { 0.99816102375206, 0, 0.0606182854454458, 0, 1, 0, -0.0606182854454458, 0, 0.99816102375206 }, { 0.998856246323703, 0, 0.0478148377091269, 0, 1, 0, -0.0478148377091269, 0, 0.998856246323703 }, { 0.999372576335887, 0, 0.0354187538011653, 0, 1, 0, -0.0354187538011653, 0, 0.999372576335887 }, { 0.999729252511634, 0, 0.0232666897876044, 0, 1, 0, -0.0232666897876044, 0, 0.999729252511634 }, { 0.999936068134962, 0, 0.0113111967355783, 0, 1, 0, -0.0113111967355783, 0, 0.999936068134962 }, { 0.999999983962655, 0, -0.000126638636872439, 0, 1, 0, 0.000126638636872439, 0, 0.999999983962655 },    // Cos(theta) = 0.9090451
            { 224.804335586077, 0, 109.374524605388, 0, 278.019019607902, 0, -0.437499272399446, 0, 0.899218711056151 }, { 224.804523431126, 0, 109.374621574802, 0, 278.019007602388, 0, -0.437499162037479, 0, 0.899218851749642 }, { 224.803985022578, 0, 109.374365848956, 0, 278.018938716504, 0, -0.437499013060835, 0, 0.899218848521699 }, { 198.277428618671, 0, 96.4683251690567, 0, 245.212712970954, 0, -0.437495872487078, 0, 0.899220437860159 }, { 111.530795752328, 0, 54.2632600595083, 0, 137.931663121721, 0, -0.437491768114745, 0, 0.899222483228455 }, { 71.3792405122271, 0, 34.7281976019442, 0, 88.275878194629, 0, -0.437482556906858, 0, 0.899226885961918 }, { 49.5685339542075, 0, 24.1165437026638, 0, 61.3019052720371, 0, -0.437465673736972, 0, 0.899235080454795 }, { 36.4171534814967, 0, 17.7179181166822, 0, 45.0372114860516, 0, -0.4374375322728, 0, 0.899248835851548 }, { 27.8813975614053, 0, 13.5649335275173, 0, 34.4804947864457, 0, -0.437394302634115, 0, 0.899269842844965 }, { 22.0292448404867, 0, 10.7175978453198, 0, 27.2425496905028, 0, -0.437331442542363, 0, 0.89930040565025 }, { 17.8432064063126, 0, 8.68086515099755, 0, 22.0646894786043, 0, -0.437244879310023, 0, 0.899342512271408 }, { 14.74616178951, 0, 7.17394738118267, 0, 18.2333227386396, 0, -0.437129628162951, 0, 0.899398529195969 }, { 12.3905371548792, 0, 6.02773833972406, 0, 15.3187676995082, 0, -0.436979902601637, 0, 0.899471247821644 }, { 10.5573447940726, 0, 5.13569213037368, 0, 13.050169576054, 0, -0.436787294970164, 0, 0.899564838708673 }, { 9.10288238848071, 0, 4.42788489807806, 0, 11.2499304825862, 0, -0.436537335612564, 0, 0.899686117366303 }, { 7.93008782012221, 0, 3.85709524400167, 0, 9.79801218902968, 0, -0.43613680989797, 0, 0.899880406848514 }, { 6.97951455007792, 0, 3.39424352396185, 0, 8.62129199835785, 0, -0.433985622431867, 0, 0.900919798554568 }, { 6.18983453878412, 0, 3.00963091077531, 0, 7.6432264491393, 0, -0.432068690907203, 0, 0.901840718421684 }, { 5.52554214660656, 0, 2.68599015533785, 0, 6.81981111749945, 0, -0.430701477702666, 0, 0.902494393094614 }, { 4.96335388329515, 0, 2.41197921128887, 0, 6.12234970236547, 0, -0.429440866074496, 0, 0.903095031239507 }, { 4.48455065765741, 0, 2.17846267077108, 0, 5.52812705791335, 0, -0.428053439434375, 0, 0.903753464398468 }, { 4.07638214437164, 0, 1.97909061904328, 0, 5.02129600806669, 0, -0.425609604211868, 0, 0.904906902078695 }, { 3.72330644433038, 0, 1.80645623400408, 0, 4.58201828253239, 0, -0.423612771019357, 0, 0.905843371983229 }, { 3.41663238447088, 0, 1.65641326976859, 0, 4.19983708787655, 0, -0.422267856986624, 0, 0.906471143555854 }, { 3.15158262140238, 0, 1.52647135726277, 0, 3.86871775112312, 0, -0.420849336553635, 0, 0.90713056804399 }, { 2.91820526311259, 0, 1.41201904137222, 0, 3.57698010292864, 0, -0.420227721233398, 0, 0.907418700230769 }, { 2.7078232215683, 0, 1.30788485288995, 0, 3.31256427756278, 0, -0.416517286217323, 0, 0.909127834119745 }, { 2.52152454711223, 0, 1.21495896288431, 0, 3.07688962341483, 0, -0.411909522052234, 0, 0.911224791945794 }, { 2.35649078511493, 0, 1.13197928733728, 0, 2.86718727915045, 0, -0.40679573540128, 0, 0.913519059198406 }, { 2.21009531838169, 0, 1.05753999884461, 0, 2.67935689436036, 0, -0.401551917605538, 0, 0.91583624157377 }, { 2.08188517874572, 0, 0.991274572619067, 0, 2.5110838855601, 0, -0.395876312153781, 0, 0.918303833249805 }, { 1.96841997877247, 0, 0.931710035106494, 0, 2.3599325721406, 0, -0.39017517325392, 0, 0.920740616114558 }, { 1.8673625714508, 0, 0.877693771561342, 0, 2.22340275450564, 0, -0.384417832075725, 0, 0.923159254067831 }, { 1.77690454204172, 0, 0.828483563365359, 0, 2.1002577488094, 0, -0.378164535016437, 0, 0.925738407029112 }, { 1.69501167326954, 0, 0.782093672371855, 0, 1.98636143604611, 0, -0.370069181730661, 0, 0.92900420684212 }, { 1.61922232608905, 0, 0.738035948113898, 0, 1.88359223962706, 0, -0.361367282318684, 0, 0.932423507148121 }, { 1.55323593591078, 0, 0.697848423296306, 0, 1.78986307234457, 0, -0.352467321223789, 0, 0.935824156515603 }, { 1.49347773481912, 0, 0.659594621504844, 0, 1.70560318360634, 0, -0.343367170558453, 0, 0.939201266383878 }, { 1.43713614594127, 0, 0.623073855387216, 0, 1.62822739826771, 0, -0.33369298361419, 0, 0.942681833814207 }, { 1.38740367681006, 0, 0.587881417754814, 0, 1.5565481482019, 0, -0.322596919696479, 0, 0.946536457222324 }, { 1.34215166601925, 0, 0.554223508349962, 0, 1.49191717549881, 0, -0.311333722929868, 0, 0.950300655317102 }, { 1.3017739684419, 0, 0.522073112726477, 0, 1.43334691779471, 0, -0.29990357164369, 0, 0.953969573526912 }, { 1.26308306949008, 0, 0.490154720001002, 0, 1.37903125746077, 0, -0.287678463633678, 0, 0.957727019643274 }, { 1.22719399764904, 0, 0.458309380397669, 0, 1.32912459154599, 0, -0.274836142082439, 0, 0.961491115130528 }, { 1.19574145710704, 0, 0.428876391165351, 0, 1.28364696290509, 0, -0.261896794003039, 0, 0.965095895811231 }, { 1.1647251146544, 0, 0.398676414550485, 0, 1.24224106499046, 0, -0.24835995316802, 0, 0.968667823804301 }, { 1.13524983615116, 0, 0.36907499892973, 0, 1.20318134940493, 0, -0.234540817326293, 0, 0.972106266356203 }, { 1.10837439998387, 0, 0.340556185920305, 0, 1.16812018700377, 0, -0.220722876027398, 0, 0.975336510461933 }, { 1.08387706421697, 0, 0.313002560397657, 0, 1.13514664280131, 0, -0.206248517748702, 0, 0.978499631711911 }, { 1.05962969512277, 0, 0.285686382616491, 0, 1.1047284884588, 0, -0.192005554961841, 0, 0.981393865511217 }, { 1.03629372371299, 0, 0.259032407661107, 0, 1.07636778048564, 0, -0.177395452037879, 0, 0.984139620104238 }, { 0.993464783916134, 0, 0.224710517428117, 0, 1.02631651627153, 0, -0.162891008618184, 0, 0.986644048080813 }, { 0.996679965444575, 0, 0.209990961188333, 0, 1.02631651627153, 0, -0.148279103588554, 0, 0.988945563321258 }, { 0.991005738070645, 0, 0.133819680148373, 0, 1, 0, -0.133819680148373, 0, 0.991005738070645 }, { 0.992851866920076, 0, 0.119352938658868, 0, 1, 0, -0.119352938658868, 0, 0.992851866920076 }, { 0.994452433026394, 0, 0.105187046399686, 0, 1, 0, -0.105187046399686, 0, 0.994452433026394 }, { 0.995847712902797, 0, 0.0910345196882964, 0, 1, 0, -0.0910345196882964, 0, 0.995847712902797 }, { 0.997013811437466, 0, 0.0772230805710765, 0, 1, 0, -0.0772230805710765, 0, 0.997013811437466 }, { 0.997980623891888, 0, 0.0635183768836981, 0, 1, 0, -0.0635183768836981, 0, 0.997980623891888 }, { 0.998738836937327, 0, 0.0502058548783233, 0, 1, 0, -0.0502058548783233, 0, 0.998738836937327 }, { 0.999312150199399, 0, 0.0370846855351022, 0, 1, 0, -0.0370846855351022, 0, 0.999312150199399 }, { 0.999704997441891, 0, 0.0242866072292582, 0, 1, 0, -0.0242866072292582, 0, 0.999704997441891 }, { 0.999927466939257, 0, 0.0120468361731422, 0, 1, 0, -0.0120468361731422, 0, 0.999927466939257 }, { 0.99999998285234, 0, -0.000130949074019626, 0, 1, 0, 0.000130949074019626, 0, 0.99999998285234 },    // Cos(theta) = 0.8992189
            { 222.221953304621, 0, 114.530550042573, 0, 281.250220840497, 0, -0.458122455426905, 0, 0.888889119330526 }, { 222.221944658273, 0, 114.530537906483, 0, 281.250220840497, 0, -0.458122406882494, 0, 0.888889084745069 }, { 222.221956882544, 0, 114.530548173509, 0, 281.249851317069, 0, -0.458121683297501, 0, 0.888889484036842 }, { 195.998858990049, 0, 101.015459844309, 0, 248.062720173642, 0, -0.458120353841072, 0, 0.888890220114055 }, { 110.250049641877, 0, 56.8214976336654, 0, 139.534363517088, 0, -0.458115530821408, 0, 0.888892675301274 }, { 70.5593223440976, 0, 36.3653186276434, 0, 89.3016078280482, 0, -0.458104437502825, 0, 0.88889838404727 }, { 48.9990764674838, 0, 25.2533724158757, 0, 62.014318798905, 0, -0.45808468798593, 0, 0.88890853689599 }, { 35.9986361544888, 0, 18.5530324519403, 0, 45.5606716169632, 0, -0.458050883626338, 0, 0.888925982739965 }, { 27.561090162317, 0, 14.2043484396842, 0, 34.8812121162051, 0, -0.458002773356731, 0, 0.888950760182012 }, { 21.7761760661616, 0, 11.2227854008379, 0, 27.5591720003754, 0, -0.457929408200081, 0, 0.888988565369059 }, { 17.6383396483152, 0, 9.09009356138571, 0, 22.3212311283276, 0, -0.457830345295949, 0, 0.889039586978038 }, { 14.5768751447303, 0, 7.51213081812616, 0, 18.4453578262185, 0, -0.457698207965857, 0, 0.889107665755126 }, { 12.2484439451496, 0, 6.31194401356895, 0, 15.4968620675651, 0, -0.457527063362362, 0, 0.889195723233256 }, { 10.4363447161402, 0, 5.37784236258836, 0, 13.2018505800358, 0, -0.457307985414445, 0, 0.889308375594428 }, { 8.9988416822155, 0, 4.63678246842021, 0, 11.3807304261131, 0, -0.457019056106338, 0, 0.88945686054218 }, { 7.83999514627117, 0, 4.0392935297758, 0, 9.91257360576551, 0, -0.456519289990748, 0, 0.889713495144489 }, { 6.90148546835985, 0, 3.55519459871198, 0, 8.7236122166071, 0, -0.454122623838599, 0, 0.890939217084164 }, { 6.11953203479329, 0, 3.15174840979263, 0, 7.73208041988241, 0, -0.45242998175708, 0, 0.891799930143201 }, { 5.46287147250239, 0, 2.81284902440916, 0, 6.89871778527468, 0, -0.451052675224828, 0, 0.892497378897593 }, { 4.90698601681347, 0, 2.5258061134091, 0, 6.19285922197916, 0, -0.449756660680332, 0, 0.893151180639269 }, { 4.43413318348691, 0, 2.28145177371955, 0, 5.59202720897783, 0, -0.448156079446923, 0, 0.893955390974062 }, { 4.03102181284184, 0, 2.07279951201294, 0, 5.07943126572924, 0, -0.445469365882395, 0, 0.895297202363785 }, { 3.68137734174817, 0, 1.89169094064492, 0, 4.63404809218119, 0, -0.443489178789643, 0, 0.896279782538625 }, { 3.37816333081251, 0, 1.7344101698957, 0, 4.24681951654095, 0, -0.441702851053017, 0, 0.897161380568219 }, { 3.11615345916875, 0, 1.59817341340015, 0, 3.91115343225516, 0, -0.439730727686993, 0, 0.898129690735072 }, { 2.88588596866157, 0, 1.47840907460095, 0, 3.6158951335017, 0, -0.438910216687806, 0, 0.898530962706816 }, { 2.68084255179721, 0, 1.37089079315532, 0, 3.35102629616017, 0, -0.435701651759027, 0, 0.900091200700294 }, { 2.49653207766425, 0, 1.27343420736649, 0, 3.11175375326141, 0, -0.4310804951697, 0, 0.902313480927266 }, { 2.333851748884, 0, 1.18653222683116, 0, 2.89924431111999, 0, -0.425687189043902, 0, 0.904870380632182 }, { 2.19069653946221, 0, 1.10919877669415, 0, 2.70855098529756, 0, -0.420034029314665, 0, 0.907508326534515 }, { 2.06394726634088, 0, 1.03964741003183, 0, 2.53775082500832, 0, -0.414052929748906, 0, 0.910252801378138 }, { 1.95226677232785, 0, 0.977474457595956, 0, 2.38415038946055, 0, -0.407828692618329, 0, 0.913058468706927 }, { 1.85320272780275, 0, 0.921236888763005, 0, 2.24605237264095, 0, -0.401498399691465, 0, 0.915859673913964 }, { 1.76351392084383, 0, 0.869283484109341, 0, 2.12074409519112, 0, -0.394861929536016, 0, 0.918740504313708 }, { 1.68310768025855, 0, 0.821258810968528, 0, 2.00579977807323, 0, -0.387094625570528, 0, 0.922040006333432 }, { 1.6086321090925, 0, 0.774642797221272, 0, 1.90100556106629, 0, -0.377808204822424, 0, 0.925883868584421 }, { 1.54307502242568, 0, 0.732513437102051, 0, 1.80588124802805, 0, -0.368317527536029, 0, 0.929700033860137 }, { 1.48430392058324, 0, 0.692797330775789, 0, 1.71969887949746, 0, -0.358587592280373, 0, 0.933496038551363 }, { 1.4310765672383, 0, 0.65491347785584, 0, 1.64109814932798, 0, -0.348481453527884, 0, 0.937315641169262 }, { 1.38190111223259, 0, 0.617844858962264, 0, 1.56925136569263, 0, -0.337239938978024, 0, 0.941418757297553 }, { 1.33771962945459, 0, 0.582810209931554, 0, 1.5028522163271, 0, -0.325235132759506, 0, 0.945633185656437 }, { 1.29651874421048, 0, 0.5482065329487, 0, 1.44262358218777, 0, -0.313090522144208, 0, 0.949723270333314 }, { 1.2587056570185, 0, 0.514708828142785, 0, 1.38831178031048, 0, -0.300666612135622, 0, 0.953729273976275 }, { 1.22327040647222, 0, 0.481448425852704, 0, 1.33705353648838, 0, -0.287136206006089, 0, 0.957889725626131 }, { 1.19292372717188, 0, 0.450220004703428, 0, 1.29069084076326, 0, -0.273418756394606, 0, 0.961895160694669 }, { 1.16289523981195, 0, 0.419141255570583, 0, 1.24847161249318, 0, -0.259582852373878, 0, 0.965720851012816 }, { 1.13494047990471, 0, 0.388180823005952, 0, 1.20954605077705, 0, -0.245004703915936, 0, 0.969521901050705 }, { 1.10798362055567, 0, 0.357864663813256, 0, 1.17346827383084, 0, -0.230415849204108, 0, 0.973092184651836 }, { 1.08305618392677, 0, 0.328367967595469, 0, 1.14035479607527, 0, -0.215582404725394, 0, 0.976485696368944 }, { 1.05979582038344, 0, 0.299767096655082, 0, 1.10927452195406, 0, -0.200471525545943, 0, 0.979699504268914 }, { 1.03692046730283, 0, 0.272014179331484, 0, 1.08033910913429, 0, -0.185478406413806, 0, 0.982648305622714 }, { 0.992750452372641, 0, 0.234994240393731, 0, 1.02943203312092, 0, -0.17011736512403, 0, 0.985423813700142 }, { 0.996222159110064, 0, 0.219811438543651, 0, 1.02943203312092, 0, -0.15505397559459, 0, 0.987905959090317 }, { 0.990183323282784, 0, 0.139774660981717, 0, 1, 0, -0.139774660981717, 0, 0.990183323282784 }, { 0.992176166676882, 0, 0.124845928431247, 0, 1, 0, -0.124845928431247, 0, 0.992176166676882 }, { 0.993950338453842, 0, 0.109830851443183, 0, 1, 0, -0.109830851443183, 0, 0.993950338453842 }, { 0.995455967116767, 0, 0.0952229189182044, 0, 1, 0, -0.0952229189182044, 0, 0.995455967116767 }, { 0.996745762807911, 0, 0.0806094406093294, 0, 1, 0, -0.0806094406093294, 0, 0.996745762807911 }, { 0.997791398956674, 0, 0.0664252482791287, 0, 1, 0, -0.0664252482791287, 0, 0.997791398956674 }, { 0.998623456769977, 0, 0.0524514821424292, 0, 1, 0, -0.0524514821424292, 0, 0.998623456769977 }, { 0.999247077218875, 0, 0.0387987295294977, 0, 1, 0, -0.0387987295294977, 0, 0.999247077218875 }, { 0.999674202899547, 0, 0.0255254690404256, 0, 1, 0, -0.0255254690404256, 0, 0.999674202899547 }, { 0.999923058709654, 0, 0.0124002318114498, 0, 1, 0, -0.0124002318114498, 0, 0.999923058709654 }, { 0.999999988087322, 0, -0.000109145212782461, 0, 1, 0, 0.000109145212782461, 0, 0.999999988087322 },    // Cos(theta) = 0.8888889
            { 219.513202187379, 0, 119.639652002044, 0, 284.72070199798, 0, -0.478559456320055, 0, 0.878055140789442 }, { 219.513784994195, 0, 119.639972458931, 0, 284.720294191136, 0, -0.478559784264671, 0, 0.878054962193987 }, { 219.513844779903, 0, 119.640010772927, 0, 284.719674450886, 0, -0.478559554867135, 0, 0.878055097954965 }, { 193.654319674457, 0, 105.541705146377, 0, 251.099702957314, 0, -0.478556225322272, 0, 0.878056851592979 }, { 108.906349869239, 0, 59.3563459628117, 0, 141.256006765935, 0, -0.478551241509161, 0, 0.878059630641863 }, { 69.6993709941578, 0, 37.9876013567516, 0, 90.4033047407875, 0, -0.478538254336213, 0, 0.878066681093665 }, { 48.4020571382953, 0, 26.3800155862128, 0, 62.7794439395111, 0, -0.478516756142142, 0, 0.878078348848714 }, { 35.5601456545399, 0, 19.3808096309072, 0, 46.1227051463937, 0, -0.478479548561315, 0, 0.87809864289843 }, { 27.2251920106005, 0, 14.8379853815648, 0, 35.311668970031, 0, -0.478422578684469, 0, 0.878129769029136 }, { 21.5109090572601, 0, 11.7234686188949, 0, 27.8991751974701, 0, -0.478339574163315, 0, 0.878174944974584 }, { 17.4234375798453, 0, 9.49558759916064, 0, 22.5966657502991, 0, -0.478227068370648, 0, 0.878236214824648 }, { 14.3992972113618, 0, 7.84723220399825, 0, 18.6729384069967, 0, -0.478076483438249, 0, 0.878318132698208 }, { 12.0992895520648, 0, 6.59350957364405, 0, 15.6881814537308, 0, -0.477881055668967, 0, 0.878424496477239 }, { 10.3093804979914, 0, 5.61778059169265, 0, 13.3649421926047, 0, -0.47763050967904, 0, 0.878560861413022 }, { 8.88949705323111, 0, 4.84369145801052, 0, 11.5212090284932, 0, -0.477300519832386, 0, 0.878740122872056 }, { 7.74564434583306, 0, 4.21999226594267, 0, 10.0357808003217, 0, -0.476645468602541, 0, 0.879095611995944 }, { 6.81928527796444, 0, 3.71466004394689, 0, 8.83283421106392, 0, -0.474115076154309, 0, 0.880462889496279 }, { 6.04604439901385, 0, 3.2927554790294, 0, 7.82784156829903, 0, -0.472538188868405, 0, 0.88131024973632 }, { 5.39699047306557, 0, 2.93849382710019, 0, 6.98363356330494, 0, -0.471175276101067, 0, 0.882039593294005 }, { 4.84781684893377, 0, 2.6385882183664, 0, 6.26879141603063, 0, -0.46984437665552, 0, 0.882749269946498 }, { 4.38158208291432, 0, 2.38373256792902, 0, 5.66113428872769, 0, -0.46795144875122, 0, 0.883754141237938 }, { 3.98313459676942, 0, 2.16560427488627, 0, 5.14162885593416, 0, -0.46521608317734, 0, 0.885197130207766 }, { 3.63772404553024, 0, 1.97630463469458, 0, 4.6900327769154, 0, -0.46310287417747, 0, 0.886304494616706 }, { 3.33841798228395, 0, 1.81198383078545, 0, 4.29801273191597, 0, -0.460862926945043, 0, 0.887471248350025 }, { 3.07893139129352, 0, 1.66922387211881, 0, 3.95739562445211, 0, -0.458636914710027, 0, 0.888623725970689 }, { 2.85181624477373, 0, 1.5441090285531, 0, 3.65789797705653, 0, -0.457249450349718, 0, 0.889338469511887 }, { 2.6516057267429, 0, 1.43324294665625, 0, 3.39194541242848, 0, -0.454829109019758, 0, 0.890578712379589 }, { 2.47053215832997, 0, 1.33173760303665, 0, 3.14943481564524, 0, -0.449894884611842, 0, 0.893081563894043 }, { 2.31063523203247, 0, 1.24126925105701, 0, 2.93358431656385, 0, -0.444345262606221, 0, 0.89585553894642 }, { 2.17006854298726, 0, 1.16068737313982, 0, 2.74008138474759, 0, -0.438261641070175, 0, 0.898847426120601 }, { 2.04532969013715, 0, 1.08820792269004, 0, 2.56652142365745, 0, -0.431951319193786, 0, 0.90189696660825 }, { 1.93622103294759, 0, 1.02358080513015, 0, 2.409700215569, 0, -0.425309294353957, 0, 0.90504805942403 }, { 1.83686287383947, 0, 0.964023262333178, 0, 2.26941176187442, 0, -0.418427385717564, 0, 0.908250224468142 }, { 1.74841829712539, 0, 0.909752881950882, 0, 2.14272632098746, 0, -0.411364316132758, 0, 0.911471007465145 }, { 1.66964637302624, 0, 0.859877178832185, 0, 2.0265066493505, 0, -0.40359914117126, 0, 0.91493587469469 }, { 1.59859130339185, 0, 0.812492186544304, 0, 1.91953334424571, 0, -0.394029445618736, 0, 0.919097867312151 }, { 1.53457420246003, 0, 0.768351419569547, 0, 1.82216771560389, 0, -0.383922550917948, 0, 0.92336530411105 }, { 1.47505620988817, 0, 0.725505715823749, 0, 1.73533532006783, 0, -0.373573246162313, 0, 0.927600688099393 }, { 1.42330348386995, 0, 0.685917122468802, 0, 1.65486284057344, 0, -0.362889701200049, 0, 0.931832136525395 }, { 1.37560795859211, 0, 0.647798357124132, 0, 1.58221568490545, 0, -0.351641949833926, 0, 0.93613456839149 }, { 1.33154603620068, 0, 0.610294302086899, 0, 1.51491997537232, 0, -0.338970460457682, 0, 0.940797075991629 }, { 1.29161019517998, 0, 0.574366154058359, 0, 1.45321583667712, 0, -0.326040060676597, 0, 0.945355955696081 }, { 1.2558366023241, 0, 0.540045794108117, 0, 1.39762395778296, 0, -0.313006972232501, 0, 0.949750886435835 }, { 1.22099393779485, 0, 0.505023768012306, 0, 1.34638516805775, 0, -0.299278827639286, 0, 0.954165703849837 }, { 1.18917099756218, 0, 0.47125913660614, 0, 1.29887221484318, 0, -0.284785035181786, 0, 0.958591411370247 }, { 1.16007833060459, 0, 0.438588468767972, 0, 1.25559133296038, 0, -0.270293243380924, 0, 0.962778058904574 }, { 1.13310133087619, 0, 0.406575363681554, 0, 1.21567207865151, 0, -0.255394808456021, 0, 0.966836892865391 }, { 1.10740510631109, 0, 0.375056430657341, 0, 1.17931004857912, 0, -0.239945870968522, 0, 0.970786262759549 }, { 1.082456327298, 0, 0.343809667137063, 0, 1.14527714918491, 0, -0.224652930137166, 0, 0.974438841960267 }, { 1.05972498970267, 0, 0.314406345126089, 0, 1.11425564434492, 0, -0.208876036152675, 0, 0.977942144202354 }, { 1.03698389896343, 0, 0.284962530983813, 0, 1.08475362695825, 0, -0.193116200321652, 0, 0.981175886149198 }, { 0.991998607630978, 0, 0.245817748951374, 0, 1.03225903182717, 0, -0.177342474960471, 0, 0.984149243467849 }, { 0.995835098541451, 0, 0.229782426883947, 0, 1.03225903182717, 0, -0.161442696222387, 0, 0.986882085520513 }, { 0.989313565415281, 0, 0.145803401376854, 0, 1, 0, -0.145803401376854, 0, 0.989313565415281 }, { 0.991514247291011, 0, 0.129998227415978, 0, 1, 0, -0.129998227415978, 0, 0.991514247291011 }, { 0.993412547827598, 0, 0.11459329535066, 0, 1, 0, -0.11459329535066, 0, 0.993412547827598 }, { 0.995069045409146, 0, 0.0991844419358963, 0, 1, 0, -0.0991844419358963, 0, 0.995069045409146 }, { 0.996455302632911, 0, 0.0841241968556875, 0, 1, 0, -0.0841241968556875, 0, 0.996455302632911 }, { 0.997600315537991, 0, 0.0692354621824091, 0, 1, 0, -0.0692354621824091, 0, 0.997600315537991 }, { 0.998502364509807, 0, 0.0547079443494326, 0, 1, 0, -0.0547079443494326, 0, 0.998502364509807 }, { 0.999181390804897, 0, 0.0404550234177645, 0, 1, 0, -0.0404550234177645, 0, 0.999181390804897 }, { 0.99964890420129, 0, 0.0264994859639647, 0, 1, 0, -0.0264994859639647, 0, 0.99964890420129 }, { 0.999914063255706, 0, 0.0131057254108011, 0, 1, 0, -0.0131057254108011, 0, 0.999914063255706 }, { 0.999999982303012, 0, -0.000133030026892353, 0, 1, 0, 0.000133030026892353, 0, 0.999999982303012 },    // Cos(theta) = 0.8780549
            { 216.67887561178, 0, 124.699770121542, 0, 288.444965257825, 0, -0.498800018892773, 0, 0.866717116483367 }, { 216.678782037757, 0, 124.699720845335, 0, 288.444979921413, 0, -0.498800115346953, 0, 0.866717069123983 }, { 216.678176212451, 0, 124.699375660647, 0, 288.444965113016, 0, -0.498798720069621, 0, 0.866717809457855 }, { 191.029576174752, 0, 109.938450450508, 0, 254.574781657751, 0, -0.498796662844226, 0, 0.866719095797777 }, { 107.501637105553, 0, 61.867526404294, 0, 143.10223117799, 0, -0.498790404770922, 0, 0.866722628830704 }, { 68.799515922443, 0, 39.5943145083247, 0, 91.5860285957532, 0, -0.498776602841726, 0, 0.866730602033866 }, { 47.7771887788091, 0, 27.4957818403676, 0, 63.6004428995774, 0, -0.498750401950586, 0, 0.866745673930664 }, { 35.1012889531654, 0, 20.2006469867541, 0, 46.7259189224999, 0, -0.498708585757717, 0, 0.866769696269289 }, { 26.8739371742252, 0, 15.4656642800715, 0, 35.7734189689544, 0, -0.498644504713534, 0, 0.866806625027408 }, { 21.2334354683684, 0, 12.2194093919021, 0, 28.2639925190055, 0, -0.498552064483117, 0, 0.866859803814868 }, { 17.1986969705589, 0, 9.89726467823566, 0, 22.892152809118, 0, -0.498423670732018, 0, 0.866933592857953 }, { 14.2136869486394, 0, 8.17922085449503, 0, 18.9169908586805, 0, -0.498253167192353, 0, 0.867031627008843 }, { 11.9433018046108, 0, 6.87241783493117, 0, 15.8933720373171, 0, -0.498032433221226, 0, 0.867158382541709 }, { 10.1766488020478, 0, 5.85548670210077, 0, 13.5398401331778, 0, -0.497749312302259, 0, 0.867320926377934 }, { 8.77514822618627, 0, 5.04866239818541, 0, 11.6722305157816, 0, -0.497369465898334, 0, 0.867538857723292 }, { 7.64782940708918, 0, 4.39956105999175, 0, 10.1692712907943, 0, -0.496431879303416, 0, 0.868075707204593 }, { 6.73252023670631, 0, 3.87230576417757, 0, 8.94914392558992, 0, -0.494015752010747, 0, 0.869452951123792 }, { 5.96889745276473, 0, 3.43233881393248, 0, 7.93016360941129, 0, -0.492470206069002, 0, 0.870329269951273 }, { 5.32819828442673, 0, 3.06303463845903, 0, 7.07486870766456, 0, -0.491072922573488, 0, 0.87111843240192 }, { 4.78608988057271, 0, 2.75039683847374, 0, 6.35029675536759, 0, -0.489688181870373, 0, 0.871897627219342 }, { 4.32694532748871, 0, 2.48528851029518, 0, 5.73599451959794, 0, -0.487371427234911, 0, 0.873194776223736 }, { 3.93306484980604, 0, 2.25754842865412, 0, 5.20802218664565, 0, -0.484777429813077, 0, 0.874637560490163 }, { 3.59169580737947, 0, 2.05996279523688, 0, 4.7499380107362, 0, -0.48254846736978, 0, 0.875869259807951 }, { 3.29742562838769, 0, 1.88918156188779, 0, 4.35368132534093, 0, -0.479697840986541, 0, 0.877433803703938 }, { 3.04046823536559, 0, 1.73980685879115, 0, 4.00654505941719, 0, -0.477366829968936, 0, 0.878704066753536 }, { 2.81633760602635, 0, 1.60925619985942, 0, 3.70311081622541, 0, -0.475278911695216, 0, 0.879835184168935 }, { 2.62082786855372, 0, 1.49488409081009, 0, 3.43443753750991, 0, -0.473306135057128, 0, 0.880898027872078 }, { 2.44321805416245, 0, 1.38976913736363, 0, 3.19032294494892, 0, -0.468400838423166, 0, 0.883516077814753 }, { 2.28625757360027, 0, 1.29580850084455, 0, 2.97052312629472, 0, -0.46268732076192, 0, 0.886521477436416 }, { 2.14867744043042, 0, 1.21233275133216, 0, 2.77363968858029, 0, -0.456378656904831, 0, 0.889785682799127 }, { 2.0268361276498, 0, 1.13729602158094, 0, 2.59689247721671, 0, -0.449600379731906, 0, 0.893229863631648 }, { 1.91679661216459, 0, 1.0686211418997, 0, 2.43794039018692, 0, -0.442531604678573, 0, 0.896752932396645 }, { 1.81895185629938, 0, 1.00639118534396, 0, 2.29536375890774, 0, -0.435238547085755, 0, 0.900315179820009 }, { 1.7337423374287, 0, 0.950627879522789, 0, 2.16558798782041, 0, -0.427573078675308, 0, 0.903980778553805 }, { 1.65602288666016, 0, 0.898416730607152, 0, 2.04801749662822, 0, -0.41955609721793, 0, 0.907729352380497 }, { 1.58640151487627, 0, 0.84968755773649, 0, 1.93996961067075, 0, -0.410121287900198, 0, 0.912030986051058 }, { 1.52422894357019, 0, 0.803444378718141, 0, 1.84044587262366, 0, -0.399401714330846, 0, 0.916776046889481 }, { 1.46716448296673, 0, 0.759333634280307, 0, 1.75122914074738, 0, -0.388392214970944, 0, 0.921494208806546 }, { 1.41573562462235, 0, 0.717723115025058, 0, 1.66978078892624, 0, -0.377107380367573, 0, 0.926169584281281 }, { 1.36901145402466, 0, 0.678086185890824, 0, 1.59560916006683, 0, -0.365457092641407, 0, 0.930828150229749 }, { 1.32622673019249, 0, 0.639286815837067, 0, 1.52685142621624, 0, -0.352675714683593, 0, 0.935745619532565 }, { 1.28762880382411, 0, 0.601469281491299, 0, 1.4643325569788, 0, -0.338999072481197, 0, 0.940786769356854 }, { 1.25111966649634, 0, 0.564051784398772, 0, 1.4076599158079, 0, -0.325211204562982, 0, 0.945641420020544 }, { 1.2173962447585, 0, 0.528328970157001, 0, 1.35478543650968, 0, -0.311191823252361, 0, 0.950347113905802 }, { 1.18662031525008, 0, 0.492942448742995, 0, 1.30720632448617, 0, -0.296116133043524, 0, 0.955151978064938 }, { 1.15754536807504, 0, 0.45841187157302, 0, 1.26291619863541, 0, -0.280858427317944, 0, 0.959749264146245 }, { 1.13059059084815, 0, 0.424868089182943, 0, 1.22257525651525, 0, -0.26553733795443, 0, 0.964100550580832 }, { 1.10587022621918, 0, 0.392028064621128, 0, 1.18518842048797, 0, -0.249484935541525, 0, 0.96837869830466 }, { 1.08191201644382, 0, 0.359654843109861, 0, 1.15067978219462, 0, -0.233411267956857, 0, 0.972378139520944 }, { 1.05829324442746, 0, 0.327934004853181, 0, 1.11862965931846, 0, -0.217303019976298, 0, 0.976104187461838 }, { 1.03744431961021, 0, 0.297786604691091, 0, 1.08928964663497, 0, -0.200723879008738, 0, 0.979647838319942 }, { 1.01558091125077, 0, 0.26795229265373, 0, 1.06111212988358, 0, -0.184412999874497, 0, 0.982848797572323 }, { 0.973206799056843, 0, 0.228428479814732, 0, 1.01194294442498, 0, -0.167875285683852, 0, 0.985808228430146 }, { 0.976847649775885, 0, 0.212319752537188, 0, 1.01194294442498, 0, -0.151566645172171, 0, 0.98844700965691 }, { 0.990815525836957, 0, 0.135220558208733, 0, 1, 0, -0.135220558208733, 0, 0.990815525836957 }, { 0.992881051797305, 0, 0.119110575266548, 0, 1, 0, -0.119110575266548, 0, 0.992881051797305 }, { 0.994665970510581, 0, 0.103148132812915, 0, 1, 0, -0.103148132812915, 0, 0.994665970510581 }, { 0.996167694093285, 0, 0.0874633640036118, 0, 1, 0, -0.0874633640036118, 0, 0.996167694093285 }, { 0.997401291897314, 0, 0.072046634014751, 0, 1, 0, -0.072046634014751, 0, 0.997401291897314 }, { 0.998377546109887, 0, 0.0569413702035747, 0, 1, 0, -0.0569413702035747, 0, 0.998377546109887 }, { 0.999116057156719, 0, 0.0420375786940295, 0, 1, 0, -0.0420375786940295, 0, 0.999116057156719 }, { 0.999615401411572, 0, 0.027732281851725, 0, 1, 0, -0.027732281851725, 0, 0.999615401411572 }, { 0.999908642841668, 0, 0.013517497333989, 0, 1, 0, -0.013517497333989, 0, 0.999908642841668 }, { 0.999999988057629, 0, -0.00010928115676966, 0, 1, 0, 0.00010928115676966, 0, 0.999999988057629 },    // Cos(theta) = 0.866717
            { 213.718523716805, 0, 129.708161488163, 0, 292.439923781121, 0, -0.51883368416596, 0, 0.854875186060869 }, { 213.718516775086, 0, 129.708162879109, 0, 292.440176063117, 0, -0.518833360454973, 0, 0.854875420759218 }, { 213.718666328549, 0, 129.708259410218, 0, 292.439796520566, 0, -0.518832903481177, 0, 0.854875653301179 }, { 188.500129291247, 0, 114.402822762641, 0, 257.932240387494, 0, -0.518830398486993, 0, 0.854877238992868 }, { 106.031191201694, 0, 64.351418182603, 0, 145.085997221468, 0, -0.518822483658647, 0, 0.854881989501799 }, { 67.8593150011672, 0, 41.1844016291193, 0, 92.8544032043262, 0, -0.518807191119295, 0, 0.85489123221211 }, { 47.1242347048981, 0, 28.5999595401779, 0, 64.481658831765, 0, -0.518777599453217, 0, 0.854909225678887 }, { 34.6217855923578, 0, 21.0119814399989, 0, 47.3731368972009, 0, -0.518730046232853, 0, 0.854938092926159 }, { 26.5069479064251, 0, 16.0868744426116, 0, 36.2689202383795, 0, -0.51865841410899, 0, 0.854981565580746 }, { 20.943415856161, 0, 12.7101646463442, 0, 28.6554052572614, 0, -0.518554454071836, 0, 0.855044611576475 }, { 16.9639327514695, 0, 10.2948219011003, 0, 23.2091656861864, 0, -0.518409664967494, 0, 0.855132393679199 }, { 14.019530733764, 0, 8.50765445636784, 0, 19.1790710040836, 0, -0.518218092540724, 0, 0.855248498409936 }, { 11.7803386934299, 0, 7.14845728199878, 0, 16.1136201909526, 0, -0.517968052391872, 0, 0.855399956010418 }, { 10.037875656861, 0, 6.09068943815968, 0, 13.7274258414715, 0, -0.517650822971781, 0, 0.855592018765112 }, { 8.65569769866318, 0, 5.25154759051989, 0, 11.833935888166, 0, -0.51721558188318, 0, 0.855855121130015 }, { 7.54734617063923, 0, 4.57847735186664, 0, 10.3151220359062, 0, -0.51570474846243, 0, 0.856766299456973 }, { 6.64207123845448, 0, 4.02852756648851, 0, 9.07376384410467, 0, -0.513673770023604, 0, 0.857985635096447 }, { 5.88805289356855, 0, 3.57036066802912, 0, 8.0395781703402, 0, -0.512226793826323, 0, 0.858850196835321 }, { 5.25618695129988, 0, 3.18624827732069, 0, 7.17185668154973, 0, -0.510801662239374, 0, 0.859698575614523 }, { 4.72178832937639, 0, 2.8611942234178, 0, 6.43776676617183, 0, -0.50926196399141, 0, 0.86061155498585 }, { 4.27012064110703, 0, 2.58605372950134, 0, 5.81627553143292, 0, -0.506536097851142, 0, 0.862218790913017 }, { 3.88063377939437, 0, 2.34856179312227, 0, 5.27938934354809, 0, -0.504129521920621, 0, 0.863628119805887 }, { 3.5441599561882, 0, 2.14307964947377, 0, 4.81446111363822, 0, -0.501686310108822, 0, 0.865049661129566 }, { 3.25422474057009, 0, 1.96551068162207, 0, 4.41258376435874, 0, -0.498530801774763, 0, 0.866872050853198 }, { 3.00018250570613, 0, 1.80973185611981, 0, 4.0601156114808, 0, -0.495905957406274, 0, 0.868376188559307 }, { 2.78004467844842, 0, 1.67416371163287, 0, 3.7518021164621, 0, -0.493239897107656, 0, 0.869893245240623 }, { 2.58740450265945, 0, 1.55525759007083, 0, 3.47924419621549, 0, -0.491038687297147, 0, 0.871137704899359 }, { 2.41490733991571, 0, 1.44767341589934, 0, 3.23329947913431, 0, -0.486738645644865, 0, 0.873547709203767 }, { 2.26166827149674, 0, 1.35074155042175, 0, 3.00973884852499, 0, -0.480738246452144, 0, 0.876864178773312 }, { 2.12435612645078, 0, 1.26289841029333, 0, 2.80993455008803, 0, -0.474210360248264, 0, 0.88041158116407 }, { 2.00260893520185, 0, 1.18371880911567, 0, 2.63074761239246, 0, -0.46712107010752, 0, 0.884193371111335 }, { 1.89674046771642, 0, 1.11361355390951, 0, 2.46860546352927, 0, -0.459593249431899, 0, 0.888129499839976 }, { 1.80266801735137, 0, 1.04997307173545, 0, 2.32197810825806, 0, -0.451700033007606, 0, 0.892169836393656 }, { 1.71709529812997, 0, 0.990706681739207, 0, 2.19041015044871, 0, -0.443565793551323, 0, 0.896241859802901 }, { 1.6425889789855, 0, 0.937489771339623, 0, 2.07006167499191, 0, -0.435051814253883, 0, 0.900405438893631 }, { 1.57543956221477, 0, 0.887556623466911, 0, 1.96085187897036, 0, -0.42577896181533, 0, 0.904827254871094 }, { 1.51377442557241, 0, 0.838877209717771, 0, 1.86002805821029, 0, -0.414658834674753, 0, 0.909976937730509 }, { 1.45883356350286, 0, 0.793551001506076, 0, 1.76806055685033, 0, -0.403030920196354, 0, 0.915186386562321 }, { 1.40862255649137, 0, 0.749797460308924, 0, 1.68510183995166, 0, -0.391041068184094, 0, 0.92037318603217 }, { 1.36324023382345, 0, 0.708194158839045, 0, 1.6095223874731, 0, -0.378817265721921, 0, 0.925471497991806 }, { 1.32118801561871, 0, 0.667579886029623, 0, 1.53984179689733, 0, -0.366015907391302, 0, 0.930608544971555 }, { 1.28305215329206, 0, 0.628050760097224, 0, 1.47576266666678, 0, -0.351743312752093, 0, 0.936096494917532 }, { 1.24710902420678, 0, 0.589050717724201, 0, 1.41793347368511, 0, -0.337247383109709, 0, 0.941416033497693 }, { 1.21404643698315, 0, 0.551530274932444, 0, 1.36494479399567, 0, -0.322595210527773, 0, 0.94653702264741 }, { 1.18351120243104, 0, 0.514400074846698, 0, 1.31561419124107, 0, -0.30730873379347, 0, 0.951609818271256 }, { 1.15454069848877, 0, 0.477760197671403, 0, 1.27025988625113, 0, -0.291245283661052, 0, 0.95664841582013 }, { 1.12898411717155, 0, 0.443134946122748, 0, 1.22953780382187, 0, -0.275202002617153, 0, 0.961386474518237 }, { 1.10337720907368, 0, 0.408347688183296, 0, 1.19149654744621, 0, -0.258932791132597, 0, 0.965895325023755 }, { 1.08046534965711, 0, 0.374688426716902, 0, 1.15565912567654, 0, -0.242021058809489, 0, 0.970271070362596 }, { 1.05805905937455, 0, 0.341984077036603, 0, 1.12337809128332, 0, -0.225260645822262, 0, 0.974298539680246 }, { 1.0361864027404, 0, 0.310059022450354, 0, 1.09379693988124, 0, -0.208318268502206, 0, 0.978061104439565 }, { 1.01629830545782, 0, 0.279328594781696, 0, 1.06558143342276, 0, -0.191163970170713, 0, 0.981558151503822 }, { 0.973178843521712, 0, 0.238013875134233, 0, 1.01430721457209, 0, -0.174280983144317, 0, 0.984695953804754 }, { 0.977173032849592, 0, 0.22104411860461, 0, 1.01430721457209, 0, -0.157120474046023, 0, 0.987579420364384 }, { 0.990101997744578, 0, 0.1403497017076, 0, 1, 0, -0.1403497017076, 0, 0.990101997744578 }, { 0.992335786039445, 0, 0.12357102200372, 0, 1, 0, -0.12357102200372, 0, 0.992335786039445 }, { 0.994245311393178, 0, 0.107127407926647, 0, 1, 0, -0.107127407926647, 0, 0.994245311393178 }, { 0.995867420078076, 0, 0.0908188884281361, 0, 1, 0, -0.0908188884281361, 0, 0.995867420078076 }, { 0.997197605004392, 0, 0.0748125222938843, 0, 1, 0, -0.0748125222938843, 0, 0.997197605004392 }, { 0.998257670772305, 0, 0.0590050577735399, 0, 1, 0, -0.0590050577735399, 0, 0.998257670772305 }, { 0.999040819592644, 0, 0.043788335232814, 0, 1, 0, -0.043788335232814, 0, 0.999040819592644 }, { 0.999589306201984, 0, 0.0286566069835896, 0, 1, 0, -0.0286566069835896, 0, 0.999589306201984 }, { 0.999899870572632, 0, 0.0141532616715903, 0, 1, 0, -0.0141532616715903, 0, 0.999899870572632 }, { 0.999999981641166, 0, -0.000135494771952777, 0, 1, 0, 0.000135494771952777, 0, 0.999999981641166 },    // Cos(theta) = 0.8548753
            { 210.633215179566, 0, 134.662988153952, 0, 296.724302027256, 0, -0.538650071966103, 0, 0.842529558145865 }, { 210.632501357527, 0, 134.6625349284, 0, 296.724826743176, 0, -0.538650463485861, 0, 0.842529279508759 }, { 210.631251170023, 0, 134.661739866026, 0, 296.726334584597, 0, -0.538649626345498, 0, 0.842529811765761 }, { 185.779188874398, 0, 118.773173587711, 0, 261.711060774021, 0, -0.538646619261291, 0, 0.842531770344316 }, { 104.500410135462, 0, 66.8095634837161, 0, 147.211782054079, 0, -0.53863733555001, 0, 0.84253778729531 }, { 66.8797505909463, 0, 42.7576616677358, 0, 94.2147851728731, 0, -0.538620617227205, 0, 0.842548377498656 }, { 46.4439959981361, 0, 29.6924791836404, 0, 65.4261122721911, 0, -0.538587553963281, 0, 0.842569597870238 }, { 34.1219678636851, 0, 21.8145860711733, 0, 48.0672102745766, 0, -0.538534157073965, 0, 0.842603671964265 }, { 26.1244899126155, 0, 16.701459050302, 0, 36.8000161283572, 0, -0.538453180708211, 0, 0.842655450024595 }, { 20.6413356011889, 0, 13.1957923657201, 0, 29.0751483109958, 0, -0.538336131172653, 0, 0.842730182451089 }, { 16.7192908133809, 0, 10.6881525092524, 0, 23.5491014459789, 0, -0.538177208284192, 0, 0.842831662668365 }, { 13.8176056973589, 0, 8.83282816101445, 0, 19.4599842299818, 0, -0.537962139644112, 0, 0.842969001892859 }, { 11.6105140583534, 0, 7.42154556459581, 0, 16.3495863635328, 0, -0.537682749461974, 0, 0.843147276849532 }, { 9.8932536668353, 0, 6.32338059438037, 0, 13.928448966154, 0, -0.537325301486507, 0, 0.843375053601064 }, { 8.53140527526471, 0, 5.45239596931032, 0, 12.0077508065527, 0, -0.536823378357522, 0, 0.843694699655704 }, { 7.44150999326627, 0, 4.75512273070339, 0, 10.4694497798938, 0, -0.534913929805673, 0, 0.844906525385332 }, { 6.54736636174061, 0, 4.18290380720741, 0, 9.20678990533764, 0, -0.533175482744379, 0, 0.846004687587428 }, { 5.80421053961793, 0, 3.7071863322488, 0, 8.15684542974367, 0, -0.531719769422296, 0, 0.846920316282867 }, { 5.18100950864192, 0, 3.30807757824698, 0, 7.27611089151059, 0, -0.530280421102842, 0, 0.847822324303744 }, { 4.65495527369304, 0, 2.97093233067891, 0, 6.53183950273797, 0, -0.528534488191546, 0, 0.848911847866619 }, { 4.21048241947698, 0, 2.68564267030892, 0, 5.90117998152978, 0, -0.525646694805264, 0, 0.850702917912461 }, { 3.82604528387991, 0, 2.4386624454205, 0, 5.35553789307552, 0, -0.523256787018819, 0, 0.852175070454618 }, { 3.49511996620136, 0, 2.2256107407361, 0, 4.88417079946651, 0, -0.520469659103286, 0, 0.853880156468166 }, { 3.20904313661231, 0, 2.04096754387382, 0, 4.47522000108803, 0, -0.51721833429805, 0, 0.855853469742367 }, { 2.95905346796349, 0, 1.87929215959505, 0, 4.11748005211541, 0, -0.514225060998074, 0, 0.857655278933177 }, { 2.74217601152319, 0, 1.73840321690268, 0, 3.80357907421459, 0, -0.511061049474216, 0, 0.859544458174826 }, { 2.55276539925334, 0, 1.61505462169132, 0, 3.52663369276037, 0, -0.508321378586142, 0, 0.86116748802728 }, { 2.38582560842534, 0, 1.5055683917965, 0, 3.27916345808936, 0, -0.504887412310349, 0, 0.863185286744859 }, { 2.23422968334464, 0, 1.40439568923371, 0, 3.05222707739471, 0, -0.498562060997376, 0, 0.866854000276652 }, { 2.09880243429252, 0, 1.3129840737818, 0, 2.84949166642959, 0, -0.491692604085075, 0, 0.870768847650366 }, { 1.9812932707159, 0, 1.23221738193106, 0, 2.66595088545888, 0, -0.484324914837971, 0, 0.87488825817734 }, { 1.87583931792967, 0, 1.15851447657796, 0, 2.50120400222371, 0, -0.476385846551982, 0, 0.879236312684575 }, { 1.78371700719017, 0, 1.09241358454505, 0, 2.35157413711756, 0, -0.468064819136937, 0, 0.883694176743606 }, { 1.70152902485411, 0, 1.03193635845865, 0, 2.2166363465117, 0, -0.459354608299168, 0, 0.888252971715919 }, { 1.62857433845974, 0, 0.976342486009348, 0, 2.09394673983097, 0, -0.450332479889709, 0, 0.892860923859065 }, { 1.56375395298091, 0, 0.924894533710941, 0, 1.98232608564119, 0, -0.440761605111126, 0, 0.897624213249557 }, { 1.50401149498681, 0, 0.875102569800883, 0, 1.87966616780049, 0, -0.429737206888635, 0, 0.902954037860461 }, { 1.44915020275129, 0, 0.82685947959058, 0, 1.78646145048147, 0, -0.417527168898826, 0, 0.908664399895124 }, { 1.3999297241711, 0, 0.781448686433352, 0, 1.70103813538071, 0, -0.404931429144975, 0, 0.914347059566588 }, { 1.35525679195305, 0, 0.738117947528396, 0, 1.62377354099135, 0, -0.391980961666049, 0, 0.919973350426224 }, { 1.31489733150294, 0, 0.695748619631966, 0, 1.55297602919788, 0, -0.37869520185525, 0, 0.925521376375004 }, { 1.27793541974561, 0, 0.654882957158713, 0, 1.48812354640989, 0, -0.364343706314186, 0, 0.931264512121074 }, { 1.24318132805564, 0, 0.614251470218492, 0, 1.42912103967907, 0, -0.349118471004308, 0, 0.937078594782112 }, { 1.21061093764153, 0, 0.575009584417033, 0, 1.37342186391284, 0, -0.333747464053834, 0, 0.942662502397783 }, { 1.180375635783, 0, 0.535800722886151, 0, 1.32475671883564, 0, -0.318104927899566, 0, 0.948055521035994 }, { 1.15207377310287, 0, 0.497741831474159, 0, 1.27876952094423, 0, -0.301658900295462, 0, 0.953415970242953 }, { 1.12596786158345, 0, 0.460978856124346, 0, 1.23590560464403, 0, -0.284771926220322, 0, 0.958595258625148 }, { 1.10228797295616, 0, 0.425248739484943, 0, 1.19750617812618, 0, -0.267953125122435, 0, 0.963431945394432 }, { 1.07810065759885, 0, 0.389727577178791, 0, 1.16170450119319, 0, -0.250652732399618, 0, 0.968077071032666 }, { 1.05765415373724, 0, 0.356127669769481, 0, 1.1286512691116, 0, -0.23307405415564, 0, 0.972458956198538 }, { 1.03550893638951, 0, 0.322453677945439, 0, 1.09755937034709, 0, -0.215682770534073, 0, 0.976463477452513 }, { 1.01574512569517, 0, 0.29033150823777, 0, 1.06938875088489, 0, -0.19792664451337, 0, 0.980216806797918 }, { 0.972271690073981, 0, 0.24686508338334, 0, 1.01751457866351, 0, -0.180324056787323, 0, 0.983607281572325 }, { 0.976497680085876, 0, 0.229579636120047, 0, 1.01751457866351, 0, -0.162848005796192, 0, 0.986651152710947 }, { 0.989392961628385, 0, 0.145263666852846, 0, 1, 0, -0.145263666852846, 0, 0.989392961628385 }, { 0.991760013555431, 0, 0.128109849988623, 0, 1, 0, -0.128109849988623, 0, 0.991760013555431 }, { 0.993835176234247, 0, 0.110867793671026, 0, 1, 0, -0.110867793671026, 0, 0.993835176234247 }, { 0.99556153680911, 0, 0.0941131391686723, 0, 1, 0, -0.0941131391686723, 0, 0.99556153680911 }, { 0.996999989706645, 0, 0.077401366012456, 0, 1, 0, -0.077401366012456, 0, 0.996999989706645 }, { 0.998117364905389, 0, 0.061332727337959, 0, 1, 0, -0.061332727337959, 0, 0.998117364905389 }, { 0.998977744444776, 0, 0.0452049757837267, 0, 1, 0, -0.0452049757837267, 0, 0.998977744444776 }, { 0.999555885448863, 0, 0.0298008582527979, 0, 1, 0, -0.0298008582527979, 0, 0.999555885448863 }, { 0.99989297578022, 0, 0.0146288447712843, 0, 1, 0, -0.0146288447712843, 0, 0.99989297578022 }, { 0.999999992572261, 0, -8.61843284802876E-05, 0, 1, 0, 8.61843284802876E-05, 0, 0.999999992572261 },    // Cos(theta) = 0.8425296
            { 207.420574105007, 0, 139.56013167897, 0, 301.321270225028, 0, -0.55823949191313, 0, 0.829679894206997 }, { 207.419301055622, 0, 139.559280201508, 0, 301.321081717072, 0, -0.55823923645294, 0, 0.82968004769296 }, { 207.420097214774, 0, 139.559816319724, 0, 301.320577875032, 0, -0.558238747987702, 0, 0.829680299451478 }, { 182.943373027183, 0, 123.09095231433, 0, 265.76506924811, 0, -0.558235780728248, 0, 0.829682374272884 }, { 102.905979227047, 0, 69.2387670936891, 0, 149.491855694644, 0, -0.558225080303016, 0, 0.829689540072223 }, { 65.8596478967837, 0, 44.3125434291574, 0, 95.6739833268956, 0, -0.558204800924249, 0, 0.829703169023369 }, { 45.7358382874381, 0, 30.7723884490594, 0, 66.4394243296966, 0, -0.558169740186071, 0, 0.829726870427912 }, { 33.6014342320969, 0, 22.6077853368934, 0, 48.8116839926139, 0, -0.558109961564122, 0, 0.829767022155128 }, { 25.7261477652329, 0, 17.3088393543673, 0, 37.3698909772858, 0, -0.558021054541109, 0, 0.829826839983716 }, { 20.3267799596465, 0, 13.6757721083394, 0, 29.5253375992358, 0, -0.557890922155851, 0, 0.829914316648272 }, { 16.4645498058279, 0, 11.0769101556416, 0, 23.9134959253079, 0, -0.557711097302922, 0, 0.830035109692829 }, { 13.606982886457, 0, 9.15399975004272, 0, 19.7611865510737, 0, -0.557473124951811, 0, 0.830194923741616 }, { 11.4338766507181, 0, 7.69158840939674, 0, 16.6026345941025, 0, -0.557163000792314, 0, 0.830403150149642 }, { 9.74286780203384, 0, 6.5535038324576, 0, 14.1441577321762, 0, -0.556763886429734, 0, 0.830670861455249 }, { 8.40216288858843, 0, 5.65106609997528, 0, 12.1939132546621, 0, -0.556174607575217, 0, 0.831065433635527 }, { 7.33055965333137, 0, 4.92947698943173, 0, 10.6332844561545, 0, -0.554039643194457, 0, 0.832490334012145 }, { 6.44927014206207, 0, 4.33590081548368, 0, 9.34977229108953, 0, -0.552375667881081, 0, 0.833595356220853 }, { 5.71695768898269, 0, 3.84250939361947, 0, 8.28285371263756, 0, -0.550930372415918, 0, 0.834551202439421 }, { 5.10304929294077, 0, 3.42870520938809, 0, 7.38788066484394, 0, -0.549491167574675, 0, 0.835499525839856 }, { 4.58607797217613, 0, 3.07992272960191, 0, 6.63317697945317, 0, -0.5474560145649, 0, 0.836834381590649 }, { 4.14786748800738, 0, 2.78382373676919, 0, 5.99199249634404, 0, -0.54458058521749, 0, 0.838708529812998 }, { 3.76932571876299, 0, 2.52782324562409, 0, 5.43734808841492, 0, -0.542103268058218, 0, 0.840311850003469 }, { 3.44427980065872, 0, 2.3074532982919, 0, 4.95910375720713, 0, -0.538940125839562, 0, 0.842344002979952 }, { 3.16188658415689, 0, 2.11557320747692, 0, 4.54286198899444, 0, -0.535658302495677, 0, 0.844434767460914 }, { 2.91627052518924, 0, 1.94813756972777, 0, 4.17912803348605, 0, -0.532181672631452, 0, 0.846630108777288 }, { 2.70307076919924, 0, 1.80224118296303, 0, 3.85952276945972, 0, -0.52877860273509, 0, 0.848759850210293 }, { 2.5168471937046, 0, 1.67432107181724, 0, 3.57798359157095, 0, -0.525442001088458, 0, 0.850829417429352 }, { 2.35515618684798, 0, 1.56264920690152, 0, 3.32635446367561, 0, -0.522108790012169, 0, 0.852878825515467 }, { 2.20462689106584, 0, 1.45720314655398, 0, 3.09806812472968, 0, -0.51613734368805, 0, 0.85650588052352 }, { 2.07415338698291, 0, 1.36416750266524, 0, 2.89086450822001, 0, -0.508940812137489, 0, 0.860801511556358 }, { 1.95741300195368, 0, 1.27950884572575, 0, 2.70401960684836, 0, -0.501182695930139, 0, 0.865341520060222 }, { 1.85593008396236, 0, 1.20432430508237, 0, 2.53513700743185, 0, -0.49290889326101, 0, 0.870080892171629 }, { 1.76565639164686, 0, 1.13584497520739, 0, 2.38221854516667, 0, -0.484119865016898, 0, 0.875001727672923 }, { 1.68618723674995, 0, 1.0735297907499, 0, 2.24395296098782, 0, -0.474889689583507, 0, 0.880045393986702 }, { 1.6141588151949, 0, 1.01529790623769, 0, 2.11894921414809, 0, -0.465344826938079, 0, 0.885129417939077 }, { 1.54803714330811, 0, 0.960171175243211, 0, 2.00574220968627, 0, -0.455298590823611, 0, 0.890338756830156 }, { 1.49066897875537, 0, 0.90948447460852, 0, 1.90239821128151, 0, -0.44438411675141, 0, 0.895836330917609 }, { 1.43790710398968, 0, 0.859696158604792, 0, 1.8057723809204, 0, -0.431769533529027, 0, 0.901983942275965 }, { 1.38965302278922, 0, 0.812045783097483, 0, 1.71880227849783, 0, -0.418588536709, 0, 0.908175978439678 }, { 1.34655990131523, 0, 0.766797573442631, 0, 1.63950330586694, 0, -0.404955552856841, 0, 0.914336353826595 }, { 1.30681930348578, 0, 0.723060478022194, 0, 1.56762460933501, 0, -0.391114334823642, 0, 0.920342112435529 }, { 1.27062158363956, 0, 0.680199318000136, 0, 1.50149336885303, 0, -0.376611090752468, 0, 0.926371472426877 }, { 1.23866338822374, 0, 0.639199790536574, 0, 1.44063391973381, 0, -0.360840144106895, 0, 0.93262768394909 }, { 1.20744618731427, 0, 0.59784465129855, 0, 1.38458627510787, 0, -0.344707160388834, 0, 0.938710270135526 }, { 1.1780810671908, 0, 0.557919653019231, 0, 1.33394076389703, 0, -0.328427723319418, 0, 0.94452909121555 }, { 1.14919607069721, 0, 0.517713581746729, 0, 1.28707263574705, 0, -0.311829364903666, 0, 0.950138080840025 }, { 1.12373340410347, 0, 0.478952415001193, 0, 1.24357013127648, 0, -0.294218309236887, 0, 0.955738307891507 }, { 1.1010329636433, 0, 0.442142677706061, 0, 1.20391574950627, 0, -0.276674471801595, 0, 0.960963744093544 }, { 1.07700266226913, 0, 0.404968952687056, 0, 1.16765723386878, 0, -0.2590659505733, 0, 0.965859683296484 }, { 1.05550768329929, 0, 0.369487860266006, 0, 1.13388961558195, 0, -0.240895277857273, 0, 0.970551160000676 }, { 1.03505940829878, 0, 0.334873519547207, 0, 1.10195501494469, 0, -0.222724531639201, 0, 0.974881430377043 }, { 1.01398100097522, 0, 0.300886236965179, 0, 1.07316820430584, 0, -0.204720188211514, 0, 0.978820510263143 }, { 0.995202875064683, 0, 0.268745679445758, 0, 1.04597540670808, 0, -0.186277151532535, 0, 0.982497198521474 }, { 0.954236824844837, 0, 0.226375758131032, 0, 0.996284895223873, 0, -0.168248833301698, 0, 0.985744514527524 }, { 0.95823529379302, 0, 0.208804094977247, 0, 0.996284895223873, 0, -0.150108046801197, 0, 0.988669623145382 }, { 0.991218593070747, 0, 0.132233608280821, 0, 1, 0, -0.132233608280821, 0, 0.991218593070747 }, { 0.993398533396847, 0, 0.114714166421373, 0, 1, 0, -0.114714166421373, 0, 0.993398533396847 }, { 0.995264266973098, 0, 0.0972060387956261, 0, 1, 0, -0.0972060387956261, 0, 0.995264266973098 }, { 0.996773748978099, 0, 0.080262834694074, 0, 1, 0, -0.080262834694074, 0, 0.996773748978099 }, { 0.997998643389123, 0, 0.0632357180826178, 0, 1, 0, -0.0632357180826178, 0, 0.997998643389123 }, { 0.998899825754969, 0, 0.0468950573520722, 0, 1, 0, -0.0468950573520722, 0, 0.998899825754969 }, { 0.999526816484472, 0, 0.0307616670860237, 0, 1, 0, -0.0307616670860237, 0, 0.999526816484472 }, { 0.999884965733548, 0, 0.0151676629147907, 0, 1, 0, -0.0151676629147907, 0, 0.999884965733548 }, { 0.999999986950032, 0, -0.000114236454793052, 0, 1, 0, 0.000114236454793052, 0, 0.999999986950032 },    // Cos(theta) = 0.82968
            { 204.080607296614, 0, 144.396892264057, 0, 306.250686903773, 0, -0.57759066262885, 0, 0.816326500169378 }, { 204.080378809462, 0, 144.396733589141, 0, 306.251212409389, 0, -0.577591598272204, 0, 0.816325819034782 }, { 204.080795178901, 0, 144.397034133901, 0, 306.249491424113, 0, -0.577589459185262, 0, 0.816327402833218 }, { 179.464223860503, 0, 126.949665290613, 0, 270.484771439768, 0, -0.577586272024267, 0, 0.81632962807381 }, { 101.250457353704, 0, 71.6394456853176, 0, 151.937158826598, 0, -0.577576422795713, 0, 0.816336581375906 }, { 64.8002005944168, 0, 45.8490089383741, 0, 97.2390885691752, 0, -0.577554528408423, 0, 0.816352051042664 }, { 45.0000047158898, 0, 31.8392788369725, 0, 67.5261146952129, 0, -0.577513408886255, 0, 0.816381148961398 }, { 33.0613272459456, 0, 23.3919203994413, 0, 49.6097979321554, 0, -0.577448248464922, 0, 0.81642728987647 }, { 25.3123045709826, 0, 17.9089355341012, 0, 37.9809507201004, 0, -0.577348593819986, 0, 0.816497832971546 }, { 19.9999523288308, 0, 14.1499762646455, 0, 30.0080013762247, 0, -0.577203866921275, 0, 0.816600080204341 }, { 16.1999082726956, 0, 11.461030712753, 0, 24.304520355392, 0, -0.577006100966829, 0, 0.816739771919756 }, { 13.3885966274537, 0, 9.47161752154201, 0, 20.0842275733929, 0, -0.576741073518609, 0, 0.816926979181663 }, { 11.2504590468952, 0, 7.95847407012956, 0, 16.8737772669979, 0, -0.576399319673331, 0, 0.817168166744775 }, { 9.58672665806461, 0, 6.78095127133741, 0, 14.3751654943282, 0, -0.575954875385362, 0, 0.8174815724471 }, { 8.26832411041738, 0, 5.8476863124661, 0, 12.3940796851929, 0, -0.575231746652843, 0, 0.817990504200351 }, { 7.21469251122966, 0, 5.10154586926306, 0, 10.8081482187725, 0, -0.572998432553194, 0, 0.819556429553704 }, { 6.34658614467898, 0, 4.4866588595776, 0, 9.50178323137878, 0, -0.571448511554376, 0, 0.820637865284808 }, { 5.62609534382313, 0, 3.97613504648595, 0, 8.41753669882928, 0, -0.569953285638696, 0, 0.821677121654491 }, { 5.02215744318093, 0, 3.54797486143884, 0, 7.50788295728476, 0, -0.568417875753665, 0, 0.822739973486855 }, { 4.51537692586333, 0, 3.18831352331703, 0, 6.74250373185564, 0, -0.565949194248694, 0, 0.824440110965272 }, { 4.08296242030992, 0, 2.88103821511137, 0, 6.08895707477163, 0, -0.563268576056729, 0, 0.826273908080929 }, { 3.71069760285658, 0, 2.61618276522331, 0, 5.52549167887462, 0, -0.560637848517903, 0, 0.828061128678646 }, { 3.39143399670798, 0, 2.38843503720257, 0, 5.03949787139762, 0, -0.557204964206263, 0, 0.830374930530386 }, { 3.11318332682506, 0, 2.18952479425265, 0, 4.61542861730537, 0, -0.553843131050707, 0, 0.832621023600932 }, { 2.87239144519161, 0, 2.0166451109383, 0, 4.24564223564739, 0, -0.549929536174041, 0, 0.835211094096945 }, { 2.66249820537273, 0, 1.86541352471954, 0, 3.91943583065947, 0, -0.546218896814916, 0, 0.837642437404921 }, { 2.4805566024096, 0, 1.73370343997618, 0, 3.63239858917036, 0, -0.542433036262005, 0, 0.840099056532033 }, { 2.31891453996387, 0, 1.61626816508992, 0, 3.37797347811891, 0, -0.538661187981654, 0, 0.842522418188137 }, { 2.17581945884603, 0, 1.51081320526921, 0, 3.1464067850566, 0, -0.533354395089713, 0, 0.845891882603122 }, { 2.04720431782381, 0, 1.41416206704944, 0, 2.93523662112293, 0, -0.525913235914366, 0, 0.850538153165301 }, { 1.93438550555972, 0, 1.32784650811996, 0, 2.74403884580915, 0, -0.517867492272377, 0, 0.855460899108822 }, { 1.8354912089133, 0, 1.25022146391661, 0, 2.57041186953154, 0, -0.509180694681773, 0, 0.860659608303376 }, { 1.74738787655632, 0, 1.17942559152388, 0, 2.4148065235098, 0, -0.499933137978653, 0, 0.866063985351102 }, { 1.66674702771887, 0, 1.11275880143064, 0, 2.27465039747156, 0, -0.490190562904663, 0, 0.871615285873898 }, { 1.59706024558774, 0, 1.0530240538603, 0, 2.14576532322702, 0, -0.480132006081534, 0, 0.877196238684161 }, { 1.53330884599512, 0, 0.996696072832401, 0, 2.03011041373672, 0, -0.469620245996388, 0, 0.882868506521572 }, { 1.47720780922366, 0, 0.943053169097981, 0, 1.92524591569905, 0, -0.458326954954021, 0, 0.88878361493391 }, { 1.42605769220059, 0, 0.892488812159469, 0, 1.82730218235929, 0, -0.445748225456905, 0, 0.895158321507936 }, { 1.37983182472854, 0, 0.8431408683323, 0, 1.73736425511618, 0, -0.431959475147363, 0, 0.90189300944573 }, { 1.33719970852636, 0, 0.79546022343274, 0, 1.65666130391712, 0, -0.4176844513355, 0, 0.908592133385092 }, { 1.29845300746011, 0, 0.74987540378345, 0, 1.58256410595703, 0, -0.403237762542112, 0, 0.915095207664534 }, { 1.26304355851212, 0, 0.70521463863879, 0, 1.51502814198047, 0, -0.388226719435849, 0, 0.921563856710441 }, { 1.23222400652739, 0, 0.663192895463942, 0, 1.45289371398139, 0, -0.372488815935595, 0, 0.928036752301782 }, { 1.20090772276124, 0, 0.619765012939975, 0, 1.39554637272394, 0, -0.355612568029205, 0, 0.934633491176595 }, { 1.17404188787954, 0, 0.57852723209301, 0, 1.34336301094534, 0, -0.338586776850171, 0, 0.940935216045384 }, { 1.14714229782897, 0, 0.537521948404366, 0, 1.29558284927505, 0, -0.321400133632946, 0, 0.946943427439035 }, { 1.12130347071959, 0, 0.497283415628707, 0, 1.25160009207572, 0, -0.3036575481451, 0, 0.952781217982731 }, { 1.09749971549117, 0, 0.457631587550413, 0, 1.2106846560907, 0, -0.285281414426847, 0, 0.958443843099636 }, { 1.07586437196729, 0, 0.42012493989798, 0, 1.17339904333125, 0, -0.266979992058219, 0, 0.963702129408585 }, { 1.05379992811945, 0, 0.382908012854779, 0, 1.13850626468217, 0, -0.248606861769905, 0, 0.968604507925665 }, { 1.03440318660253, 0, 0.347110396840432, 0, 1.10716676315458, 0, -0.229648713414629, 0, 0.973273592756087 }, { 1.01394845103392, 0, 0.312064152705684, 0, 1.07690742224486, 0, -0.210994851350595, 0, 0.977487200975719 }, { 0.994181133896184, 0, 0.278050255765342, 0, 1.0493373009722, 0, -0.192344929368928, 0, 0.98132740858954 }, { 0.954586454682427, 0, 0.234212182546384, 0, 0.998825340947013, 0, -0.173479437976416, 0, 0.984837448292212 }, { 0.958806172803475, 0, 0.216290138498136, 0, 0.998825340947013, 0, -0.155001397560375, 0, 0.987914236535221 }, { 0.990642090321091, 0, 0.136485415410475, 0, 1, 0, -0.136485415410475, 0, 0.990642090321091 }, { 0.992976190491703, 0, 0.118314102858977, 0, 1, 0, -0.118314102858977, 0, 0.992976190491703 }, { 0.994949790953847, 0, 0.100373734820072, 0, 1, 0, -0.100373734820072, 0, 0.994949790953847 }, { 0.996576430110667, 0, 0.0826758793856224, 0, 1, 0, -0.0826758793856224, 0, 0.996576430110667 }, { 0.997856484400421, 0, 0.0654411385333015, 0, 1, 0, -0.0654411385333015, 0, 0.997856484400421 }, { 0.998828592862378, 0, 0.0483878637224386, 0, 1, 0, -0.0483878637224386, 0, 0.998828592862378 }, { 0.999493464244964, 0, 0.0318245100515265, 0, 1, 0, -0.0318245100515265, 0, 0.999493464244964 }, { 0.999877572816258, 0, 0.0156492730736653, 0, 1, 0, -0.0156492730736653, 0, 0.999877572816258 }, { 0.999999987826352, 0, -0.00011033425700877, 0, 1, 0, 0.00011033425700877, 0, 0.999999987826352 },    // Cos(theta) = 0.8163265
            { 200.617540842516, 0, 149.17350478394, 0, 311.536471180824, 0, -0.596694499794456, 0, 0.802468519486038 }, { 200.61509920875, 0, 149.17169762201, 0, 311.540218334611, 0, -0.596693740216582, 0, 0.802468975765688 }, { 200.614081507058, 0, 149.17184856675, 0, 311.540897534372, 0, -0.596691729721024, 0, 0.802470487483017 }, { 176.944700980285, 0, 131.571023381807, 0, 274.776323026732, 0, -0.596687691545109, 0, 0.80247356796797 }, { 99.5312717472269, 0, 74.0084647383882, 0, 154.560959959952, 0, -0.596676176759407, 0, 0.802482055959816 }, { 63.6998550498728, 0, 47.3650976615469, 0, 98.9181348597622, 0, -0.596651935353961, 0, 0.802500160512947 }, { 44.2362464025376, 0, 32.8923565499766, 0, 68.6919617992118, 0, -0.596608499287053, 0, 0.802532407201079 }, { 32.5002548076898, 0, 24.1656235874413, 0, 50.4664867229252, 0, -0.596536882606819, 0, 0.802585671953502 }, { 24.8831534971978, 0, 18.5015556403537, 0, 38.6367347237998, 0, -0.596426919723528, 0, 0.802667400268705 }, { 19.6605210227591, 0, 14.617924004307, 0, 30.5260584427744, 0, -0.59626872710122, 0, 0.802784857836815 }, { 15.9253962270405, 0, 11.8403066106256, 0, 24.7239295612698, 0, -0.596048989622664, 0, 0.80294810948009 }, { 13.1614626094195, 0, 9.78483409161583, 0, 20.4306933944652, 0, -0.595758255343966, 0, 0.803163740781935 }, { 11.0597860482447, 0, 8.22172676219554, 0, 17.1652470611008, 0, -0.595380909616801, 0, 0.803443641384486 }, { 9.42446058841461, 0, 7.00535623372199, 0, 14.6233834984771, 0, -0.594885873066444, 0, 0.80381016214216 }, { 8.1304605936229, 0, 6.04265383536658, 0, 12.6101612384446, 0, -0.593916476180075, 0, 0.804526767961223 }, { 7.09407573249858, 0, 5.27132629914386, 0, 10.9951428183282, 0, -0.59175433690292, 0, 0.806118314632362 }, { 6.24000397381103, 0, 4.63554226400699, 0, 9.66562917664085, 0, -0.590223167881961, 0, 0.807240093932909 }, { 5.53151156306962, 0, 4.10790641202299, 0, 8.5616371914414, 0, -0.588726054060239, 0, 0.808332636274446 }, { 4.93843120682663, 0, 3.66593889530798, 0, 7.63693739278474, 0, -0.587035566051299, 0, 0.809561173771012 }, { 4.44149942845227, 0, 3.29518120277259, 0, 6.85932065613809, 0, -0.584263759762886, 0, 0.811563791371004 }, { 4.01538929557235, 0, 2.97696151094912, 0, 6.1928767667977, 0, -0.581706076345608, 0, 0.813399034069361 }, { 3.6500947796806, 0, 2.7036901024307, 0, 5.61975934858956, 0, -0.578866145323094, 0, 0.815422540406067 }, { 3.33635829133756, 0, 2.46840510823199, 0, 5.12529256201239, 0, -0.575272092907089, 0, 0.817962123727528 }, { 3.06328469435394, 0, 2.26303604489125, 0, 4.69392081624438, 0, -0.571642514584409, 0, 0.820502727112689 }, { 2.82679297899109, 0, 2.08447266537819, 0, 4.31626595863398, 0, -0.567545225873752, 0, 0.823342277095556 }, { 2.62128818132584, 0, 1.92859145690319, 0, 3.98409230181858, 0, -0.563341351191427, 0, 0.826224226454383 }, { 2.44133784444993, 0, 1.79150754926591, 0, 3.69115382423582, 0, -0.559173764152631, 0, 0.829050483327393 }, { 2.28376283063852, 0, 1.67079903796379, 0, 3.4312246494783, 0, -0.554954959097186, 0, 0.831880410215205 }, { 2.14444654774455, 0, 1.56307155639978, 0, 3.19819580706349, 0, -0.550136829365036, 0, 0.835074491097833 }, { 2.01997019527531, 0, 1.46449584050789, 0, 2.98233568336108, 0, -0.542569149327936, 0, 0.840011194886075 }, { 1.9107486724701, 0, 1.37618978671297, 0, 2.78639096845784, 0, -0.534197285647817, 0, 0.845359790912575 }, { 1.81322498256843, 0, 1.29549653749518, 0, 2.60998453370584, 0, -0.525166793774676, 0, 0.850999366719772 }, { 1.72557466003304, 0, 1.22087581530891, 0, 2.45072503802506, 0, -0.515484504958529, 0, 0.856898892387164 }, { 1.64742390054381, 0, 1.15252913983191, 0, 2.30696390532018, 0, -0.505235125446389, 0, 0.862981719393237 }, { 1.57953222470136, 0, 1.09035400434538, 0, 2.17540710263111, 0, -0.494617582627389, 0, 0.86911075804889 }, { 1.51879278809568, 0, 1.0323480542929, 0, 2.05678213564151, 0, -0.483578609626595, 0, 0.875300920837493 }, { 1.46501961757264, 0, 0.97800858879195, 0, 1.94825916415383, 0, -0.471929087953079, 0, 0.881636527669768 }, { 1.41576602684852, 0, 0.926124437520323, 0, 1.84884009250031, 0, -0.459410947386297, 0, 0.888223849594834 }, { 1.37064945993238, 0, 0.874788016462198, 0, 1.75710637293924, 0, -0.445203819197506, 0, 0.895429270205943 }, { 1.32915250985556, 0, 0.825360735643866, 0, 1.67383799857329, 0, -0.430280428039009, 0, 0.902695323844447 }, { 1.29182571028911, 0, 0.77779799819729, 0, 1.59820638152207, 0, -0.41512004222119, 0, 0.909766694678519 }, { 1.25708483484353, 0, 0.731522755186881, 0, 1.52881067571408, 0, -0.399498154760719, 0, 0.916734025864899 }, { 1.22501265933631, 0, 0.686182902310893, 0, 1.46583790285306, 0, -0.383534805366336, 0, 0.923526445491593 }, { 1.19542143089317, 0, 0.642035862785391, 0, 1.40711801081854, 0, -0.366311685703456, 0, 0.930492188147608 }, { 1.16858856498002, 0, 0.598494054175263, 0, 1.35301109210909, 0, -0.348580386887662, 0, 0.937278837292201 }, { 1.1439399765739, 0, 0.557014777942092, 0, 1.30434791102866, 0, -0.330729586449992, 0, 0.943725536522884 }, { 1.11927318117833, 0, 0.515682376515056, 0, 1.25895079518102, 0, -0.312675008520078, 0, 0.949860183782856 }, { 1.09507358615295, 0, 0.473661154493829, 0, 1.21757034140545, 0, -0.2938307316199, 0, 0.955857485169203 }, { 1.07259465079206, 0, 0.433985431340023, 0, 1.17954670063721, 0, -0.274779685893693, 0, 0.961507230947146 }, { 1.05293135738671, 0, 0.396570138811858, 0, 1.14416580231622, 0, -0.255886320594489, 0, 0.966706888212559 }, { 1.03273577646246, 0, 0.35904453790016, 0, 1.11193408768406, 0, -0.236687426033444, 0, 0.971585826004179 }, { 1.01324521790457, 0, 0.322906048263028, 0, 1.0808726145675, 0, -0.217200024731393, 0, 0.976127149713573 }, { 0.993357174012506, 0, 0.287633307150796, 0, 1.05207402077939, 0, -0.198077873570594, 0, 0.980186289403274 }, { 0.974470655529607, 0, 0.254227891608927, 0, 1.02558638228836, 0, -0.178752546373403, 0, 0.983894076714141 }, { 0.937392967405579, 0, 0.211323896802006, 0, 0.978154404010242, 0, -0.159538931373508, 0, 0.987191658819801 }, { 0.941239362309717, 0, 0.193472990529849, 0, 0.978154404010243, 0, -0.140751080124711, 0, 0.990045020890108 }, { 0.992549379662167, 0, 0.121842886099365, 0, 1, 0, -0.121842886099365, 0, 0.992549379662167 }, { 0.994632990494427, 0, 0.10346615638297, 0, 1, 0, -0.10346615638297, 0, 0.994632990494427 }, { 0.996362575551717, 0, 0.0852155296726333, 0, 1, 0, -0.0852155296726333, 0, 0.996362575551717 }, { 0.997728853425832, 0, 0.0673580297899702, 0, 1, 0, -0.0673580297899702, 0, 0.997728853425832 }, { 0.998754400634207, 0, 0.0498965503577433, 0, 1, 0, -0.0498965503577433, 0, 0.998754400634207 }, { 0.999459862003385, 0, 0.0328621956247555, 0, 1, 0, -0.0328621956247555, 0, 0.999459862003385 }, { 0.999869880217769, 0, 0.0161331770787088, 0, 1, 0, -0.0161331770787088, 0, 0.999869880217769 }, { 0.999999964851516, 0, -0.000187479287664831, 0, 1, 0, 0.000187479287664831, 0, 0.999999964851516 },    // Cos(theta) = 0.8024691
            { 197.027113177039, 0, 153.884319827836, 0, 317.214875427809, 0, -0.615536849925236, 0, 0.788108086553005 }, { 197.028373475042, 0, 153.885316673044, 0, 317.213224678, 0, -0.61553737023566, 0, 0.788107724981834 }, { 197.027073622596, 0, 153.884305763669, 0, 317.2151613725, 0, -0.615535693721133, 0, 0.788109026573279 }, { 173.77800178282, 0, 135.726004899765, 0, 279.783393342083, 0, -0.615530982094958, 0, 0.788112642084113 }, { 97.7491064339259, 0, 76.3449059297554, 0, 157.378293218143, 0, -0.615518292354312, 0, 0.788122620517136 }, { 62.5602416918736, 0, 48.8611537187719, 0, 100.720512614357, 0, -0.615491437564288, 0, 0.788143559481384 }, { 43.4448838093207, 0, 33.9312891024236, 0, 69.9433257772588, 0, -0.615444315395956, 0, 0.788180444031164 }, { 31.9185848159555, 0, 24.9286863749813, 0, 51.3859747868664, 0, -0.615364732530399, 0, 0.788242445334672 }, { 24.4376807415601, 0, 19.0856212197038, 0, 39.340615320092, 0, -0.615243924761476, 0, 0.78833675375692 }, { 19.3092251639823, 0, 15.0798674429464, 0, 31.0818187652889, 0, -0.615071635046932, 0, 0.788471273625897 }, { 15.6406647675529, 0, 12.2142969413809, 0, 25.1742956774128, 0, -0.614829445067954, 0, 0.788660063403484 }, { 12.9268225874027, 0, 10.0943550522993, 0, 20.8026890901784, 0, -0.61450969424127, 0, 0.788909323366358 }, { 10.8624905856681, 0, 8.48165055496066, 0, 17.477307999569, 0, -0.614095060903559, 0, 0.789232035481028 }, { 9.25683026715751, 0, 7.22710364065078, 0, 14.8892684052499, 0, -0.613545570318011, 0, 0.789659287482639 }, { 7.98980627882198, 0, 6.23691103448374, 0, 12.8447597258533, 0, -0.612079892923137, 0, 0.790795966391782 }, { 6.96910199552949, 0, 5.43896932728255, 0, 11.1963154314448, 0, -0.610205776364097, 0, 0.792243030487862 }, { 6.13025292358717, 0, 4.78299313081474, 0, 9.84163948922676, 0, -0.608671888347073, 0, 0.793422023427535 }, { 5.43369889468862, 0, 4.23805619870598, 0, 8.71672918023073, 0, -0.607204514340356, 0, 0.794545535755963 }, { 4.85213102723734, 0, 3.78274487552197, 0, 7.77572086998347, 0, -0.60530720434194, 0, 0.795991934739292 }, { 4.3640588548565, 0, 3.40015435570032, 0, 6.98384470383713, 0, -0.602418837501447, 0, 0.79818008071325 }, { 3.94554305784609, 0, 3.07175788065483, 0, 6.30455115641212, 0, -0.59985461400773, 0, 0.800108983324977 }, { 3.58790653298288, 0, 2.7905945214865, 0, 5.72168034883988, 0, -0.59666584406058, 0, 0.802489716584813 }, { 3.27921923146994, 0, 2.54729199197016, 0, 5.2173337951882, 0, -0.593075948135795, 0, 0.805146538534519 }, { 3.01165480178885, 0, 2.33579801015298, 0, 4.77800027458328, 0, -0.589131222778044, 0, 0.808037300253839 }, { 2.78013282665121, 0, 2.15194381217269, 0, 4.39266754788077, 0, -0.584867241135189, 0, 0.81112903652893 }, { 2.57793658134338, 0, 1.99066258652225, 0, 4.05405971346133, 0, -0.580257147714652, 0, 0.814433294658481 }, { 2.40111578193322, 0, 1.84879849417522, 0, 3.75466024997716, 0, -0.575629947212011, 0, 0.817710252002538 }, { 2.24632240283829, 0, 1.72377669333028, 0, 3.48943591310717, 0, -0.570984436364289, 0, 0.820960898310185 }, { 2.11247110933274, 0, 1.61492952138834, 0, 3.25075983786192, 0, -0.565987376858186, 0, 0.82441393683104 }, { 1.99271085410439, 0, 1.5153558130752, 0, 3.03214716007415, 0, -0.558949333705648, 0, 0.82920179139536 }, { 1.88611432898067, 0, 1.424400506363, 0, 2.8316095733407, 0, -0.550226635010161, 0, 0.835015365994921 }, { 1.78888458240131, 0, 1.3395657201384, 0, 2.65181489123232, 0, -0.540857093352067, 0, 0.841114454314559 }, { 1.70346765444617, 0, 1.26261591098023, 0, 2.48922352699458, 0, -0.530770550401053, 0, 0.847515504092674 }, { 1.62942459140311, 0, 1.19339362264421, 0, 2.34065711508369, 0, -0.520089643630774, 0, 0.854111699888907 }, { 1.56367266121992, 0, 1.1291711840006, 0, 2.20644777018771, 0, -0.508838362435317, 0, 0.860862087946045 }, { 1.50369900360017, 0, 1.06852388210855, 0, 2.08497136372504, 0, -0.497234909265013, 0, 0.867615987637962 }, { 1.45075407835953, 0, 1.01168934110209, 0, 1.97331426737439, 0, -0.485114066796129, 0, 0.874450914331653 }, { 1.40362835095085, 0, 0.958578244484776, 0, 1.87166896026498, 0, -0.472216675015096, 0, 0.881482554893017 }, { 1.36010814114779, 0, 0.906014099646554, 0, 1.77826109879932, 0, -0.458157215952946, 0, 0.888871143670051 }, { 1.31981375587274, 0, 0.854770240455844, 0, 1.69350701973124, 0, -0.44265427126191, 0, 0.896692313381341 }, { 1.28320494683316, 0, 0.804831862372975, 0, 1.6147773409008, 0, -0.426853552545164, 0, 0.904320745072352 }, { 1.25094819597936, 0, 0.757457082953419, 0, 1.54335584209533, 0, -0.410593686408871, 0, 0.91181837392869 }, { 1.21968298876702, 0, 0.710248403655126, 0, 1.47814453248725, 0, -0.394073894903399, 0, 0.919078747108809 }, { 1.19090150809673, 0, 0.664584961517736, 0, 1.41870992629826, 0, -0.37683055956201, 0, 0.926282182085032 }, { 1.16360193983913, 0, 0.619128238626181, 0, 1.36369428690228, 0, -0.358475900504455, 0, 0.933538990958084 }, { 1.13884219253499, 0, 0.575412264305461, 0, 1.31355478997725, 0, -0.339865844401782, 0, 0.940473944255938 }, { 1.11586946451702, 0, 0.532861615509416, 0, 1.26746125604246, 0, -0.321203367793601, 0, 0.94701026854868 }, { 1.09277775183068, 0, 0.490212952674622, 0, 1.22517685828027, 0, -0.302291963871694, 0, 0.953215339979717 }, { 1.07059709130854, 0, 0.448445796616925, 0, 1.18638872392812, 0, -0.282523421263053, 0, 0.959260396741235 }, { 1.05096914705851, 0, 0.409591742683358, 0, 1.14990109560741, 0, -0.262836921496847, 0, 0.96484025020483 }, { 1.03054683659228, 0, 0.37077253841258, 0, 1.11588447943923, 0, -0.243302767970357, 0, 0.969950340510554 }, { 1.01291779629948, 0, 0.333857620587993, 0, 1.08477835706552, 0, -0.223386720726817, 0, 0.974729899535977 }, { 0.992637058132002, 0, 0.297330224289674, 0, 1.05649066789482, 0, -0.203478024755337, 0, 0.979079479318129 }, { 0.974174950608035, 0, 0.262452548136589, 0, 1.02894752637528, 0, -0.18384085879363, 0, 0.982955987325059 }, { 0.935443574420297, 0, 0.21724885973161, 0, 0.97998441988173, 0, -0.164020809275482, 0, 0.986456887418466 }, { 0.939533631209773, 0, 0.198817060301941, 0, 0.97998441988173, 0, -0.144596432386241, 0, 0.989490677693142 }, { 0.992090330230547, 0, 0.12552570362887, 0, 1, 0, -0.12552570362887, 0, 0.992090330230547 }, { 0.994332363928742, 0, 0.106315948161506, 0, 1, 0, -0.106315948161506, 0, 0.994332363928742 }, { 0.996144053446671, 0, 0.0877323319126457, 0, 1, 0, -0.0877323319126457, 0, 0.996144053446671 }, { 0.997596490850662, 0, 0.0692917704922254, 0, 1, 0, -0.0692917704922254, 0, 0.997596490850662 }, { 0.998678744205745, 0, 0.0513895476300395, 0, 1, 0, -0.0513895476300395, 0, 0.998678744205745 }, { 0.999431024159485, 0, 0.0337288904617886, 0, 1, 0, -0.0337288904617886, 0, 0.999431024159485 }, { 0.999861781290208, 0, 0.0166241740952747, 0, 1, 0, -0.0166241740952747, 0, 0.999861781290208 }, { 0.999999979927592, 0, -0.000141677123677444, 0, 1, 0, 0.000141677123677444, 0, 0.999999979927592 },    // Cos(theta) = 0.7881078
            { 193.311065553206, 0, 158.527797356014, 0, 323.312723972696, 0, -0.634110178674086, 0, 0.773242670985207 }, { 193.308141232089, 0, 158.525414759215, 0, 323.31717874594, 0, -0.634110459161715, 0, 0.773242483866198 }, { 193.312728773199, 0, 158.529014927323, 0, 323.310835082506, 0, -0.634109535905345, 0, 0.773243150453043 }, { 170.501211061696, 0, 139.822181323489, 0, 285.161249579096, 0, -0.634104230231183, 0, 0.77324750054108 }, { 95.9064752296535, 0, 78.6494046284697, 0, 160.403717851123, 0, -0.634090486628856, 0, 0.773258796388389 }, { 61.3804934786689, 0, 50.3356528842939, 0, 102.65703426977, 0, -0.634061911266517, 0, 0.773282263531521 }, { 42.6250952905859, 0, 34.9547846571668, 0, 71.2882044989237, 0, -0.634007689266265, 0, 0.773326678122084 }, { 31.3167833218596, 0, 25.6809994062843, 0, 52.3735146833841, 0, -0.633921861054353, 0, 0.773397160044739 }, { 23.9773814745373, 0, 19.6619293121403, 0, 40.0963221268813, 0, -0.633790236064671, 0, 0.773504949845241 }, { 18.9454452283326, 0, 15.5351085406389, 0, 31.6790772345727, 0, -0.633600176173201, 0, 0.773660660757718 }, { 15.3461486191822, 0, 12.5830933088215, 0, 25.6578554343885, 0, -0.633337938956929, 0, 0.773875312231394 }, { 12.6833727238448, 0, 10.3990430561207, 0, 21.2021001031338, 0, -0.632987015943437, 0, 0.774162403793304 }, { 10.6583231615455, 0, 8.73791734843318, 0, 17.8129020852876, 0, -0.632531919506652, 0, 0.774534331812826 }, { 9.08319537296748, 0, 7.44567410286447, 0, 15.1753506097743, 0, -0.631919940797218, 0, 0.775033750848128 }, { 7.84268487840814, 0, 6.42766886750898, 0, 13.0945250494786, 0, -0.63015340665768, 0, 0.776470647695953 }, { 6.83906222931734, 0, 5.60382205454904, 0, 11.4110048037865, 0, -0.628487318683198, 0, 0.777819922860587 }, { 6.01572462686271, 0, 4.92773846977164, 0, 10.0293567946123, 0, -0.626952913318896, 0, 0.779057178342934 }, { 5.33265822003143, 0, 4.36656386181453, 0, 8.88327944788794, 0, -0.625370861795567, 0, 0.780327679842706 }, { 4.76343054541368, 0, 3.89852255266503, 0, 7.92562988882151, 0, -0.623170664260644, 0, 0.782085808702639 }, { 4.28373088841256, 0, 3.50364517857789, 0, 7.11717501784238, 0, -0.620366550894764, 0, 0.784312056798916 }, { 3.87321713598497, 0, 3.16530203908511, 0, 6.4244419056686, 0, -0.617692622428184, 0, 0.78641959575654 }, { 3.52315615798061, 0, 2.8761280437961, 0, 5.83136183473528, 0, -0.614183466702201, 0, 0.789163190704927 }, { 3.21981961454282, 0, 2.62501651826377, 0, 5.31585576461067, 0, -0.610635005930825, 0, 0.791912073743421 }, { 2.95828527129109, 0, 2.40770117035825, 0, 4.86784289678842, 0, -0.606369982755262, 0, 0.795182659124838 }, { 2.73210306778991, 0, 2.21888935496214, 0, 4.47373098629606, 0, -0.601879507427329, 0, 0.798586944709617 }, { 2.53212477913538, 0, 2.05120843552627, 0, 4.12872672531067, 0, -0.596968883272404, 0, 0.802264384360886 }, { 2.36081994317908, 0, 1.90650321024671, 0, 3.82227507561948, 0, -0.591851139296993, 0, 0.806047374718847 }, { 2.20966863908595, 0, 1.7780415193563, 0, 3.55078367444618, 0, -0.586658408355306, 0, 0.809834549004837 }, { 2.08002805987754, 0, 1.66671721863504, 0, 3.30634847192047, 0, -0.581324325208062, 0, 0.813671927343005 }, { 1.96192134932299, 0, 1.56374443777769, 0, 3.08654421888361, 0, -0.57496238002891, 0, 0.818179849339997 }, { 1.85577790546793, 0, 1.4683029985536, 0, 2.88313515380006, 0, -0.565969668471348, 0, 0.824426087721145 }, { 1.76388145100659, 0, 1.38327703848876, 0, 2.69714104595473, 0, -0.556223594720677, 0, 0.831032639324223 }, { 1.68294752328422, 0, 1.30597006144595, 0, 2.52932937073105, 0, -0.545722955906706, 0, 0.83796565877315 }, { 1.60988798112748, 0, 1.23339539072351, 0, 2.37715954653898, 0, -0.534637209054296, 0, 0.845081681126696 }, { 1.54579903363632, 0, 1.16684411785043, 0, 2.23897253299722, 0, -0.522916365476994, 0, 0.852383915543891 }, { 1.48927209255761, 0, 1.1052046542434, 0, 2.11332845812417, 0, -0.510662572350037, 0, 0.859781233696241 }, { 1.43812009293417, 0, 1.04673738649011, 0, 1.99917653369394, 0, -0.498014566962756, 0, 0.867168660892938 }, { 1.392438936123, 0, 0.99119476744405, 0, 1.89540850118211, 0, -0.48467376343958, 0, 0.874694994293642 }, { 1.35067135133521, 0, 0.937794231195167, 0, 1.7995452363034, 0, -0.470629108222386, 0, 0.882331155744738 }, { 1.31161570634178, 0, 0.884531493708581, 0, 1.71181745058776, 0, -0.454788454982022, 0, 0.890599505966288 }, { 1.27618736634808, 0, 0.832766388846489, 0, 1.63193462632083, 0, -0.438317560624183, 0, 0.898820209632488 }, { 1.2425178359565, 0, 0.782148192080206, 0, 1.55929589219282, 0, -0.421410369774826, 0, 0.906870041254532 }, { 1.21253978312779, 0, 0.733620200226065, 0, 1.4920951922016, 0, -0.404271016234238, 0, 0.91463925637556 }, { 1.18636203503249, 0, 0.687090669576797, 0, 1.4309180800336, 0, -0.386649797382229, 0, 0.92222663154687 }, { 1.15934456983446, 0, 0.639941768357192, 0, 1.37495618658593, 0, -0.368244820889302, 0, 0.929728850716376 }, { 1.13476609770205, 0, 0.594178564768716, 0, 1.32326874164426, 0, -0.348896196495609, 0, 0.937161362027312 }, { 1.11138425024475, 0, 0.549261959850929, 0, 1.27622795797038, 0, -0.329547645209823, 0, 0.944138948584896 }, { 1.09039590716472, 0, 0.506185373186637, 0, 1.23256944127327, 0, -0.310084418933064, 0, 0.950709003755998 }, { 1.06811856325749, 0, 0.463538640823086, 0, 1.19303703256212, 0, -0.290264238061525, 0, 0.956946516238925 }, { 1.04772529653216, 0, 0.421833884522647, 0, 1.15488450275305, 0, -0.269792719096721, 0, 0.962918448313554 }, { 1.02915747960549, 0, 0.38239573360899, 0, 1.12127469537536, 0, -0.24957944874052, 0, 0.968354302898103 }, { 1.01066227735789, 0, 0.343997692705604, 0, 1.08925257777537, 0, -0.229477032920519, 0, 0.973314042843959 }, { 0.992597718681431, 0, 0.306561140051715, 0, 1.05946486850709, 0, -0.208896242901381, 0, 0.97793786644286 }, { 0.973395349126744, 0, 0.270741708672757, 0, 1.03179408428101, 0, -0.188610086870329, 0, 0.982052080070149 }, { 0.915145709709302, 0, 0.212462648447618, 0, 0.960091168509347, 0, -0.168691948495472, 0, 0.985668868053688 }, { 0.919294767980893, 0, 0.193724336486832, 0, 0.960091168509348, 0, -0.148522172144289, 0, 0.988909090668076 }, { 0.922978637200821, 0, 0.175335388219022, 0, 0.960091168509347, 0, -0.128752633086005, 0, 0.991676796470944 }, { 0.994006400318488, 0, 0.10932191516079, 0, 1, 0, -0.10932191516079, 0, 0.994006400318488 }, { 0.995941403581293, 0, 0.0900043529272397, 0, 1, 0, -0.0900043529272397, 0, 0.995941403581293 }, { 0.997449200173015, 0, 0.0713797868563929, 0, 1, 0, -0.0713797868563929, 0, 0.997449200173015 }, { 0.998610836119943, 0, 0.0526919312360919, 0, 1, 0, -0.0526919312360919, 0, 0.998610836119943 }, { 0.999396337877461, 0, 0.0347415250838759, 0, 1, 0, -0.0347415250838759, 0, 0.999396337877461 }, { 0.999855278628759, 0, 0.0170123632777149, 0, 1, 0, -0.0170123632777149, 0, 0.999855278628759 }, { 0.999999977642913, 0, -0.000149522861033299, 0, 1, 0, 0.000149522861033299, 0, 0.999999977642913 },    // Cos(theta) = 0.7732426
            { 189.469669449986, 0, 163.10134218891, 0, 329.867432967141, 0, -0.65240142506889, 0, 0.757873568940216 }, { 189.467670952271, 0, 163.09963845219, 0, 329.87158309496, 0, -0.652401348395541, 0, 0.75787367795749 }, { 189.469515533566, 0, 163.100997230956, 0, 329.867838895886, 0, -0.65239963547408, 0, 0.757875047728976 }, { 167.112049200484, 0, 143.85516712248, 0, 290.944367481276, 0, -0.652394629164868, 0, 0.757879478304891 }, { 94.0008122921779, 0, 80.9185609109494, 0, 163.655620108316, 0, -0.652379613020265, 0, 0.757892348179041 }, { 60.160134294593, 0, 51.7872610215873, 0, 104.738567514955, 0, -0.652348169675712, 0, 0.757919441110215 }, { 41.7782562333549, 0, 35.9633441562587, 0, 72.7339988055647, 0, -0.652290894223, 0, 0.757968739510964 }, { 30.6944282842877, 0, 26.4217724611861, 0, 53.4354727441017, 0, -0.65219524065323, 0, 0.758050998064655 }, { 23.5010080863045, 0, 20.2291447474028, 0, 40.9095982456439, 0, -0.652052972237372, 0, 0.758173444842737 }, { 18.5692965348962, 0, 15.9834246277928, 0, 32.3212699198935, 0, -0.651846190640106, 0, 0.758351160953612 }, { 15.0415857650375, 0, 12.9462592421146, 0, 26.1778092550723, 0, -0.651558788631678, 0, 0.758598116454263 }, { 12.4318440273735, 0, 10.6992697512503, 0, 21.6313107286998, 0, -0.651178859610707, 0, 0.758924262530823 }, { 10.447129694495, 0, 8.99024908896167, 0, 18.1738896672913, 0, -0.65068182878493, 0, 0.7593505196055 }, { 8.9037671918012, 0, 7.66106305163428, 0, 15.4833840499798, 0, -0.649988790164195, 0, 0.75994387597918 }, { 7.68957706805113, 0, 6.61503737249406, 0, 13.3618873104281, 0, -0.648033307539499, 0, 0.761611982374614 }, { 6.70482906152854, 0, 5.76647809213705, 0, 11.6420685561522, 0, -0.646443004415286, 0, 0.762962275848461 }, { 5.89724774055499, 0, 5.07028348966034, 0, 10.2318867347402, 0, -0.644923287631158, 0, 0.76424739006449 }, { 5.2282780032811, 0, 4.49328503317961, 0, 9.06283567571132, 0, -0.643200670897994, 0, 0.765697628757072 }, { 4.67200066623863, 0, 4.01299608636731, 0, 8.08764848224875, 0, -0.640630411618617, 0, 0.767849370871067 }, { 4.20055876264274, 0, 3.60557085631607, 0, 7.26030536721939, 0, -0.638024571476969, 0, 0.770015946163745 }, { 3.79898528787588, 0, 3.25798461439924, 0, 6.55387626400134, 0, -0.635131446994556, 0, 0.772404036585601 }, { 3.45567982705965, 0, 2.96014464531022, 0, 5.94784270061824, 0, -0.631569983503019, 0, 0.775318936545527 }, { 3.15902318391829, 0, 2.70217072340747, 0, 5.42151400185046, 0, -0.627809987988986, 0, 0.778366682613546 }, { 2.903459651555, 0, 2.47905973554246, 0, 4.96346799752615, 0, -0.623393946826391, 0, 0.781907908518121 }, { 2.68066576850476, 0, 2.28362985156775, 0, 4.56198844859133, 0, -0.618553462228424, 0, 0.785742779097745 }, { 2.48660051872843, 0, 2.11240321654285, 0, 4.20876341200723, 0, -0.613367228154258, 0, 0.789797878886862 }, { 2.31776283385872, 0, 1.96244730292196, 0, 3.89547817236307, 0, -0.607867642838209, 0, 0.794038413224174 }, { 2.17198565727128, 0, 1.83170962223505, 0, 3.6165722133544, 0, -0.602170005676763, 0, 0.798367779557066 }, { 2.0458755405386, 0, 1.71762777033156, 0, 3.36631333544757, 0, -0.596368903716868, 0, 0.802710546812657 }, { 1.93005984759204, 0, 1.61137636222081, 0, 3.14266324527331, 0, -0.590021910695791, 0, 0.807387236081805 }, { 1.82940024609852, 0, 1.5158771330615, 0, 2.93518033119, 0, -0.581360542085551, 0, 0.813646027093953 }, { 1.74044936616576, 0, 1.42874831208536, 0, 2.74514580947513, 0, -0.571271850543616, 0, 0.820760925549283 }, { 1.66091755620899, 0, 1.34815542891474, 0, 2.57242826432283, 0, -0.560329002630792, 0, 0.82827011160061 }, { 1.59147166668784, 0, 1.27448683506198, 0, 2.41568752274155, 0, -0.548843905566291, 0, 0.835924841480211 }, { 1.52916598533026, 0, 1.20590013414721, 0, 2.27357768992116, 0, -0.536671605438941, 0, 0.84379122856081 }, { 1.4713495266685, 0, 1.13958113564646, 0, 2.14530628931168, 0, -0.523829388394727, 0, 0.851823190967236 }, { 1.42207147311889, 0, 1.07943147868395, 0, 2.02711835142531, 0, -0.510607784984739, 0, 0.859813759824075 }, { 1.3780817196851, 0, 1.02236937178731, 0, 1.92002078305015, 0, -0.496743908554161, 0, 0.86789718940135 }, { 1.33755943025505, 0, 0.966478549480139, 0, 1.82294757283969, 0, -0.482323597635761, 0, 0.875993097888641 }, { 1.30050242104809, 0, 0.912846117012522, 0, 1.7328781592228, 0, -0.466749482896004, 0, 0.884389567147893 }, { 1.26617246763241, 0, 0.859022109896247, 0, 1.65050318605642, 0, -0.449647880899018, 0, 0.893205836741002 }, { 1.23667548269497, 0, 0.808416896959289, 0, 1.57457954763875, 0, -0.432076081578826, 0, 0.901837138907818 }, { 1.20690781217367, 0, 0.757135479481668, 0, 1.50639133736298, 0, -0.414235124814288, 0, 0.910169920915252 }, { 1.17928542883314, 0, 0.707684165606487, 0, 1.44432504440567, 0, -0.396040297283379, 0, 0.91823318120662 }, { 1.15519772632109, 0, 0.660639536772879, 0, 1.3863738718943, 0, -0.377448076735554, 0, 0.926030742200319 }, { 1.13067640318211, 0, 0.612771471629147, 0, 1.33248081270823, 0, -0.357846862356724, 0, 0.93378025105229 }, { 1.1070764430833, 0, 0.565672173220241, 0, 1.28436393260004, 0, -0.337709247505478, 0, 0.941250524960348 }, { 1.08748171003998, 0, 0.521551206987684, 0, 1.23993321652603, 0, -0.317611668938294, 0, 0.948220832817854 }, { 1.06653017199407, 0, 0.477925605231568, 0, 1.19931167912561, 0, -0.297438851905375, 0, 0.9547408561311 }, { 1.04518928452186, 0, 0.434340789342311, 0, 1.16096719174285, 0, -0.276707268103549, 0, 0.960954270793606 }, { 1.02706765997857, 0, 0.393315337140537, 0, 1.12665296256358, 0, -0.255717819450467, 0, 0.966751476984877 }, { 1.00811244485538, 0, 0.353412611341924, 0, 1.09375674691981, 0, -0.235043770405381, 0, 0.971984768070708 }, { 0.991837261719423, 0, 0.31632092380495, 0, 1.06391748080326, 0, -0.214401676460829, 0, 0.976745610149903 }, { 0.97293217859108, 0, 0.278715096596, 0, 1.03497972365612, 0, -0.193329868969059, 0, 0.981133809837769 }, { 0.954155394043728, 0, 0.24330901487904, 0, 1.0080732340819, 0, -0.172764439367746, 0, 0.984963226545402 }, { 0.917064464773256, 0, 0.198413958993391, 0, 0.96074406269687, 0, -0.152451790495712, 0, 0.988310882391176 }, { 0.92095989695766, 0, 0.179466753636378, 0, 0.96074406269687, 0, -0.132045622329693, 0, 0.99124368034665 }, { 0.860331441067871, 0, 0.097173152934604, 0, 0.865743580487994, 0, -0.112136961091128, 0, 0.993692765105785 }, { 0.862083915320668, 0, 0.080150789284741, 0, 0.865743580487994, 0, -0.0924759535593287, 0, 0.995714933471999 }, { 0.863484972897223, 0, 0.0632971530157121, 0, 0.865743580487994, 0, -0.0730098659262779, 0, 0.997331235230694 }, { 0.864520951735526, 0, 0.0470776161042127, 0, 0.865743580487994, 0, -0.0542762037806712, 0, 0.998525943677021 }, { 0.865251281108052, 0, 0.0308714954727294, 0, 0.865743580487994, 0, -0.0355580722040236, 0, 0.999367628910642 }, { 0.865667031469652, 0, 0.015280263983595, 0, 0.865743580487994, 0, -0.0175501725941648, 0, 0.999846045765827 }, { 0.865801806496746, 0, -8.23941925170413E-05, 0, 0.865743580487994, 0, 0.000193693158516976, 0, 0.999999962482959 },    // Cos(theta) = 0.7578735
            { 185.500537919666, 0, 167.600059610601, 0, 336.926635350563, 0, -0.670399893154784, 0, 0.74200003747666 }, { 185.501332142924, 0, 167.600782298174, 0, 336.924197698335, 0, -0.670399239886544, 0, 0.74200057018989 }, { 185.502683851157, 0, 167.602377704142, 0, 336.924513958008, 0, -0.670398313253706, 0, 0.742001434584585 }, { 163.610778563914, 0, 147.82257105226, 0, 297.168886186864, 0, -0.670392052890121, 0, 0.742007028977964 }, { 92.0311672860224, 0, 83.150045844454, 0, 167.156976416618, 0, -0.67037529045082, 0, 0.742022219549917 }, { 58.9002434284291, 0, 53.2159726781, 0, 106.9796408688, 0, -0.670340052716217, 0, 0.742054101803768 }, { 40.9032693683354, 0, 36.955410949821, 0, 74.2898235567545, 0, -0.670280399590254, 0, 0.742107996727247 }, { 30.0521988120693, 0, 27.1511451989997, 0, 54.5780581546851, 0, -0.670176858172705, 0, 0.742201375387986 }, { 23.0090040333124, 0, 20.7872680926721, 0, 41.7843214744064, 0, -0.67002017363654, 0, 0.742342901027961 }, { 18.1805610697193, 0, 16.4243629928784, 0, 33.0124934949149, 0, -0.669796961475348, 0, 0.742544313148872 }, { 14.7270834156272, 0, 13.3036948886915, 0, 26.7373855130462, 0, -0.669486659335748, 0, 0.742824096969829 }, { 12.1719565789244, 0, 10.9945963081073, 0, 22.0943985898604, 0, -0.669073618447123, 0, 0.743196170621936 }, { 10.2291064063385, 0, 9.23866071755792, 0, 18.5620362829745, 0, -0.668531377657805, 0, 0.743683955810114 }, { 8.71897155400768, 0, 7.87356749325877, 0, 15.8150858380742, 0, -0.667716723498751, 0, 0.744415441879059 }, { 7.53080574954031, 0, 6.79914763527945, 0, 13.6486295378279, 0, -0.665680113416652, 0, 0.746237221700524 }, { 6.56604459886, 0, 5.92650371469014, 0, 11.8911974792735, 0, -0.664101202032247, 0, 0.747642649760927 }, { 5.77502965687479, 0, 5.21073231707319, 0, 10.450077610304, 0, -0.662555017771538, 0, 0.74901328857 }, { 5.12090777068585, 0, 4.61843868073204, 0, 9.25618526754355, 0, -0.66069439440772, 0, 0.75065496598084 }, { 4.57667069368989, 0, 4.12516669065896, 0, 8.26024915050511, 0, -0.657991707457618, 0, 0.753025174292723 }, { 4.11481940437035, 0, 3.70608422889248, 0, 7.41414575385296, 0, -0.655368241228635, 0, 0.755309490733512 }, { 3.72244493575693, 0, 3.34944279335648, 0, 6.69346020570379, 0, -0.652222034643054, 0, 0.758028036958978 }, { 3.38610357002037, 0, 3.04307450759167, 0, 6.07303573553912, 0, -0.648644926608261, 0, 0.761091105625921 }, { 3.09646587478877, 0, 2.77846978125311, 0, 5.53613791174635, 0, -0.644562273894632, 0, 0.764551782637501 }, { 2.84598959156624, 0, 2.54870232963083, 0, 5.06711651777725, 0, -0.640087770525845, 0, 0.768301841159205 }, { 2.62809530261805, 0, 2.34782150336284, 0, 4.65716391350082, 0, -0.634966413248767, 0, 0.772539783269841 }, { 2.43909171941036, 0, 2.17239684459492, 0, 4.29531348600961, 0, -0.629424576118239, 0, 0.777061586706993 }, { 2.27519023555288, 0, 2.01923958120534, 0, 3.97372154040953, 0, -0.623614511015899, 0, 0.781731974349016 }, { 2.13444461549974, 0, 1.88617628963544, 0, 3.68674541809279, 0, -0.617407326354558, 0, 0.786643629943178 }, { 2.00661510553765, 0, 1.76432293991378, 0, 3.43263300852038, 0, -0.611062746627314, 0, 0.791582143190927 }, { 1.89845891304065, 0, 1.65928073847208, 0, 3.20188548982154, 0, -0.604453765078191, 0, 0.796640247055742 }, { 1.80131787611207, 0, 1.56265361462729, 0, 2.99179359361203, 0, -0.596392106336645, 0, 0.802693262933538 }, { 1.71522489355284, 0, 1.47333205659843, 0, 2.79514946185021, 0, -0.586008801358497, 0, 0.810304638549557 }, { 1.63900285075441, 0, 1.39097777128002, 0, 2.61749519053193, 0, -0.574729912558339, 0, 0.818343152747123 }, { 1.56946575159661, 0, 1.31353921899557, 0, 2.45712419175073, 0, -0.562706388890613, 0, 0.826656873642324 }, { 1.50999806877559, 0, 1.24329324799151, 0, 2.31063829234828, 0, -0.550101597326732, 0, 0.835097759141569 }, { 1.45405332906296, 0, 1.17490822997463, 0, 2.17823584549358, 0, -0.536734142807828, 0, 0.843751397572661 }, { 1.4062468800861, 0, 1.11230995947819, 0, 2.05689250479629, 0, -0.522929399238934, 0, 0.852376031194055 }, { 1.36316644648249, 0, 1.05244862420175, 0, 1.94724377523914, 0, -0.508476159014668, 0, 0.86107609234979 }, { 1.32514335946933, 0, 0.995868184620251, 0, 1.84642541752693, 0, -0.493573076451784, 0, 0.869704370760848 }, { 1.28883500296868, 0, 0.940061874560387, 0, 1.75542488026326, 0, -0.477875690794426, 0, 0.878427521006953 }, { 1.25589799336182, 0, 0.884796923777134, 0, 1.67009573407572, 0, -0.460722692964718, 0, 0.88754411332177 }, { 1.22684707405848, 0, 0.831847821725088, 0, 1.59259254387027, 0, -0.442537614087362, 0, 0.896749990952728 }, { 1.19807723610592, 0, 0.779138780062227, 0, 1.52133781525572, 0, -0.42402265817274, 0, 0.905651598017937 }, { 1.17408803963325, 0, 0.729275419528244, 0, 1.45633101645684, 0, -0.405224090194819, 0, 0.914217357284416 }, { 1.14868734907942, 0, 0.679312450470532, 0, 1.3979709252426, 0, -0.386065275457062, 0, 0.922471466022035 }, { 1.12663794226122, 0, 0.631413198476593, 0, 1.34385402733997, 0, -0.366525934293211, 0, 0.930407771170124 }, { 1.10408422434425, 0, 0.582850381143759, 0, 1.29356745745477, 0, -0.345805629048097, 0, 0.938306190432012 }, { 1.0830108034717, 0, 0.536047509882401, 0, 1.24780298804848, 0, -0.325037333128476, 0, 0.945701189859063 }, { 1.06423412153844, 0, 0.491773030432385, 0, 1.20642192920025, 0, -0.304215239179666, 0, 0.952603298753218 }, { 1.04389607064244, 0, 0.447592811579011, 0, 1.16730358429682, 0, -0.283376586540727, 0, 0.959008734388387 }, { 1.02393780670498, 0, 0.404079541659813, 0, 1.13102821602521, 0, -0.261962449942343, 0, 0.965078079260242 }, { 1.00594897718487, 0, 0.363144516312517, 0, 1.09768527078571, 0, -0.240468056121208, 0, 0.970657055095653 }, { 0.990141579784145, 0, 0.324606872954441, 0, 1.06710265627802, 0, -0.219315130821977, 0, 0.975654084665621 }, { 0.971579628098498, 0, 0.286763958340678, 0, 1.03803297358403, 0, -0.198233436088445, 0, 0.9801548641104 }, { 0.95415768759, 0, 0.250112713554127, 0, 1.01016827184593, 0, -0.176842168720028, 0, 0.984239224774003 }, { 0.8994958337857, 0, 0.192735019048154, 0, 0.942347419150853, 0, -0.155984025229252, 0, 0.987759565169985 }, { 0.903308094294564, 0, 0.173994584724964, 0, 0.942347419150853, 0, -0.135416696898887, 0, 0.990788774025612 }, { 0.906741561294829, 0, 0.155110691705706, 0, 0.942347419150853, 0, -0.114716063400634, 0, 0.993398334222102 }, { 0.861897041135729, 0, 0.0821364026961635, 0, 0.865743580487994, 0, -0.0947693557594408, 0, 0.995499319991158 }, { 0.863360678736835, 0, 0.0649710785120195, 0, 0.865743580487994, 0, -0.074943261864116, 0, 0.997187866127656 }, { 0.864465069863996, 0, 0.048092407156849, 0, 0.865743580487994, 0, -0.0554482924993505, 0, 0.998461515670249 }, { 0.865218177388333, 0, 0.0317852426998488, 0, 0.865743580487994, 0, -0.0366134528421694, 0, 0.999329498141131 }, { 0.86566162709572, 0, 0.0155803428389066, 0, 0.865743580487994, 0, -0.0178967639007404, 0, 0.999839837869772 }, { 0.865801818874755, 0, -2.74888637848912E-05, 0, 0.865743580487994, 0, 0.00013027757592578, 0, 0.999999983027753 },    // Cos(theta) = 0.7420005
            { 181.40609346, 0, 172.022965725421, 0, 344.529835602281, 0, -0.688092597011358, 0, 0.725622837573458 }, { 181.40520124079, 0, 172.022143149792, 0, 344.532652804107, 0, -0.68809177896725, 0, 0.72562362975031 }, { 181.404183988664, 0, 172.021097480571, 0, 344.532268895183, 0, -0.6880913965422, 0, 0.725624086940052 }, { 159.999931750247, 0, 151.723971590265, 0, 303.875794122596, 0, -0.688084990138861, 0, 0.725630073485263 }, { 90.000533852224, 0, 85.3449998448259, 0, 170.928896914848, 0, -0.688065879844316, 0, 0.72564821733721 }, { 57.6010300501377, 0, 54.6210804163541, 0, 109.393358452044, 0, -0.688028223796582, 0, 0.725683935377487 }, { 40.001225281846, 0, 37.9313210576044, 0, 75.9659815944909, 0, -0.687962206263909, 0, 0.725746546010523 }, { 29.3888938333698, 0, 27.8675739818732, 0, 55.8098792398871, 0, -0.687850269038294, 0, 0.725852579704618 }, { 22.5015180463927, 0, 21.336040215553, 0, 42.7271596896274, 0, -0.687681791880676, 0, 0.726012164579213 }, { 17.7798869366106, 0, 16.8581859905153, 0, 33.7570415918833, 0, -0.687440188985549, 0, 0.726241089372793 }, { 14.4025640448909, 0, 13.655044106252, 0, 27.3406182784709, 0, -0.687104096671705, 0, 0.726559036542783 }, { 11.9043197702838, 0, 11.2854360946728, 0, 22.5921954506748, 0, -0.686655758395696, 0, 0.726982774352019 }, { 10.0042970887352, 0, 9.4830131132829, 0, 18.9804028825054, 0, -0.686067901585721, 0, 0.727537536518089 }, { 8.52986480059335, 0, 8.08405873844461, 0, 16.1749772968042, 0, -0.685002947345533, 0, 0.728540200417325 }, { 7.36655226094573, 0, 6.97993544450217, 0, 13.9566343068578, 0, -0.683063274824148, 0, 0.73035926698399 }, { 6.42233363873124, 0, 6.08347131769842, 0, 12.1584974643014, 0, -0.681512580990876, 0, 0.731806383229406 }, { 5.64963928551837, 0, 5.34951271521582, 0, 10.6851128065396, 0, -0.67982842232299, 0, 0.733371216454477 }, { 5.00994028746957, 0, 4.74146531640318, 0, 9.46469284399114, 0, -0.677859633303206, 0, 0.735191376607436 }, { 4.47780427934466, 0, 4.23509110672969, 0, 8.44578212253398, 0, -0.675078852319743, 0, 0.737745564975214 }, { 4.0261652688519, 0, 3.80486896103165, 0, 7.58032031862887, 0, -0.672385338367463, 0, 0.740201298163854 }, { 3.64369803882174, 0, 3.43981545122971, 0, 6.84405658090655, 0, -0.668939933567408, 0, 0.743316389216499 }, { 3.31443938804656, 0, 3.12486873255544, 0, 6.20879587984926, 0, -0.66533444127129, 0, 0.74654540948309 }, { 3.03236726033251, 0, 2.85409597132475, 0, 5.65886252089574, 0, -0.661039669713363, 0, 0.750350974025528 }, { 2.78675328723795, 0, 2.61745588819977, 0, 5.17969660214127, 0, -0.656333178060418, 0, 0.754471148310212 }, { 2.57437245107257, 0, 2.41164541091048, 0, 4.75910510021248, 0, -0.651044907155945, 0, 0.759039155999424 }, { 2.39105631958018, 0, 2.23269256006634, 0, 4.38771686593904, 0, -0.645216890112677, 0, 0.763999400885217 }, { 2.23277827819044, 0, 2.07674761378121, 0, 4.05742923024119, 0, -0.638999613595049, 0, 0.769207027418151 }, { 2.09232201305961, 0, 1.93715748305317, 0, 3.76470601309294, 0, -0.632392963360847, 0, 0.774647651343942 }, { 1.97094188604494, 0, 1.81482337512519, 0, 3.50117551837031, 0, -0.625532598652314, 0, 0.780198002135746 }, { 1.8646990627044, 0, 1.7058561096574, 0, 3.26436458499365, 0, -0.618410595697107, 0, 0.78585510897813 }, { 1.77343381524725, 0, 1.60945766943021, 0, 3.04932510259999, 0, -0.610474378557311, 0, 0.792036036470763 }, { 1.68824554533305, 0, 1.51662566454512, 0, 2.85062857230777, 0, -0.600358060812803, 0, 0.799731382750882 }, { 1.61522330536881, 0, 1.43271995618732, 0, 2.66718564692605, 0, -0.588776861562545, 0, 0.808295655209861 }, { 1.54792780382455, 0, 1.35256357131905, 0, 2.50221820082477, 0, -0.576294085880045, 0, 0.817242414245044 }, { 1.48913974810347, 0, 1.27940244282171, 0, 2.3510536405449, 0, -0.563198205351079, 0, 0.826321835212957 }, { 1.43786661237688, 0, 1.21116314399463, 0, 2.21364348924139, 0, -0.549320391144138, 0, 0.835611807112898 }, { 1.39163979332386, 0, 1.14623057034403, 0, 2.0889262757553, 0, -0.534982969545226, 0, 0.844862897446261 }, { 1.35024398008723, 0, 1.08451950515455, 0, 1.97471012575089, 0, -0.519977378191286, 0, 0.854180017318273 }, { 1.31260806324488, 0, 1.02499413568444, 0, 1.87226976192327, 0, -0.504512762888871, 0, 0.86340427535508 }, { 1.2788291716066, 0, 0.968154183329449, 0, 1.77679595923084, 0, -0.488380586339031, 0, 0.872630777909122 }, { 1.24678392300274, 0, 0.911372726053159, 0, 1.69048297255037, 0, -0.471395229803401, 0, 0.881922076446499 }, { 1.21811505986887, 0, 0.856061771334768, 0, 1.61020049757626, 0, -0.452820539566501, 0, 0.891601681890464 }, { 1.19151841674672, 0, 0.802566861348365, 0, 1.53675710309268, 0, -0.433606958000765, 0, 0.901102075290231 }, { 1.16606532457934, 0, 0.749504126189917, 0, 1.47065846380636, 0, -0.414182856414802, 0, 0.910193713882677 }, { 1.14376700132678, 0, 0.698532790224435, 0, 1.41023028534718, 0, -0.3943801009169, 0, 0.918947417993243 }, { 1.12103094002361, 0, 0.648821247097351, 0, 1.3540371707829, 0, -0.374399557128437, 0, 0.927267453472498 }, { 1.10053433313309, 0, 0.600337337185703, 0, 1.30308602828694, 0, -0.353842899437374, 0, 0.935304939319995 }, { 1.07900962015227, 0, 0.551208841614441, 0, 1.25596380132216, 0, -0.332272259483912, 0, 0.943183560904267 }, { 1.05965773695507, 0, 0.504588163075535, 0, 1.21270800355417, 0, -0.310783534648425, 0, 0.950480666182696 }, { 1.04135091749682, 0, 0.459518450762342, 0, 1.17296690257814, 0, -0.289392845369549, 0, 0.957210338354269 }, { 1.02258371562905, 0, 0.415629964940214, 0, 1.13648575049148, 0, -0.267999122658322, 0, 0.963419175521734 }, { 1.00401914447967, 0, 0.372942862625958, 0, 1.1024464857541, 0, -0.245925725298512, 0, 0.969288709028199 }, { 0.986404018499094, 0, 0.332209784205428, 0, 1.07035896145565, 0, -0.224047828558429, 0, 0.974578158774012 }, { 0.969725399108416, 0, 0.293750950508572, 0, 1.04139593313637, 0, -0.202585511660379, 0, 0.979264597005815 }, { 0.952363435313991, 0, 0.256645251532913, 0, 1.01326277309858, 0, -0.181054336060367, 0, 0.983473128506057 }, { 0.89752141834594, 0, 0.19699535673622, 0, 0.942516356038899, 0, -0.159470707744107, 0, 0.98720261521099 }, { 0.901518662633478, 0, 0.177809060213208, 0, 0.942516356038899, 0, -0.138380306946036, 0, 0.990379175917625 }, { 0.905041530851498, 0, 0.15890835018392, 0, 0.942516356038899, 0, -0.117629064228425, 0, 0.99305765891769 }, { 0.86172931874538, 0, 0.0838770301611317, 0, 0.865743580487994, 0, -0.096779797327328, 0, 0.995305798929089 }, { 0.863244083753138, 0, 0.0665018125129936, 0, 0.865743580487994, 0, -0.0767112709330269, 0, 0.997053373268638 }, { 0.864396925584078, 0, 0.0493024235765135, 0, 0.865743580487994, 0, -0.0568458676610698, 0, 0.99838294681416 }, { 0.865194738024802, 0, 0.0324176876627745, 0, 0.865743580487994, 0, -0.037343928627523, 0, 0.999302497678466 }, { 0.865652480259577, 0, 0.016084296232799, 0, 0.865743580487994, 0, -0.0184788304627971, 0, 0.999829330635539 }, { 0.865801808081375, 0, -7.67824390439054E-05, 0, 0.865743580487994, 0, 0.000187211590660478, 0, 0.999999964951819 },    // Cos(theta) = 0.7256235
            { 177.183879131374, 0, 176.36472966464, 0, 352.73955938818, 0, -0.705466791425927, 0, 0.708742960654199 }, { 177.184605654531, 0, 176.36548268151, 0, 352.73807612864, 0, -0.705466432420985, 0, 0.70874325701708 }, { 177.186923621398, 0, 176.368087777429, 0, 352.734909631307, 0, -0.705464096531857, 0, 0.708745690000939 }, { 156.278206247894, 0, 155.555640582815, 0, 311.113723312677, 0, -0.705457689803507, 0, 0.708751918765616 }, { 87.9061568593829, 0, 87.4994034655083, 0, 175.00024363163, 0, -0.705439005394337, 0, 0.708770606892542 }, { 56.2600527200071, 0, 55.9993189078667, 0, 111.999462627909, 0, -0.705399058566898, 0, 0.708810471201395 }, { 39.0703169306421, 0, 38.8887182155773, 0, 77.7752987325129, 0, -0.705327000654718, 0, 0.708882059919648 }, { 28.7055047309787, 0, 28.5714376860917, 0, 57.1390132881856, 0, -0.705207229685596, 0, 0.709001304070322 }, { 21.9783166017423, 0, 21.8749127381786, 0, 43.7446541864491, 0, -0.705026868838615, 0, 0.709180597346306 }, { 17.3667080003269, 0, 17.2841079617246, 0, 34.5610183226757, 0, -0.704764105280543, 0, 0.709441698839573 }, { 14.0679060908333, 0, 13.999970238185, 0, 27.9914631189549, 0, -0.704401458607164, 0, 0.709801758368875 }, { 11.6279569182375, 0, 11.5706523124226, 0, 23.1299122798701, 0, -0.703919196334295, 0, 0.710280085032735 }, { 9.7725412681509, 0, 9.7230621795229, 0, 19.4323066909201, 0, -0.703279297324493, 0, 0.71091369908559 }, { 8.33678118879407, 0, 8.29300680075484, 0, 16.5657058267182, 0, -0.701816333671519, 0, 0.712358012240845 }, { 7.19734670647825, 0, 7.15778309145442, 0, 14.2898969952727, 0, -0.70009538066201, 0, 0.714049304154382 }, { 6.27445979889027, 0, 6.23797752400871, 0, 12.4472915023977, 0, -0.698557242647851, 0, 0.71555410133666 }, { 5.51946680543182, 0, 5.48510305729402, 0, 10.9382312575433, 0, -0.696853425974785, 0, 0.717213475857475 }, { 4.8967039876707, 0, 4.86356692127332, 0, 9.69079052127947, 0, -0.694556033807127, 0, 0.71943858796794 }, { 4.37590710542299, 0, 4.34323557464576, 0, 8.64589533758616, 0, -0.691854737817763, 0, 0.722036680568067 }, { 3.93509414483449, 0, 3.90227390664661, 0, 7.75973799503722, 0, -0.689021535777484, 0, 0.724740933966532 }, { 3.56204835535415, 0, 3.52832250251241, 0, 7.00601855813808, 0, -0.68539849015779, 0, 0.728168158842009 }, { 3.24105847753334, 0, 3.2057523443268, 0, 6.35487697778157, 0, -0.681637622701401, 0, 0.731689906275477 }, { 2.96572526775007, 0, 2.92807558670131, 0, 5.79137250826191, 0, -0.677183531326811, 0, 0.735814113780762 }, { 2.72675119261591, 0, 2.6859811299625, 0, 5.3003093454882, 0, -0.672222383015408, 0, 0.740349234979646 }, { 2.52021163587559, 0, 2.47565535439741, 0, 4.86909456928677, 0, -0.666685099144782, 0, 0.745339440346504 }, { 2.34223602629911, 0, 2.29274679196533, 0, 4.4875972965827, 0, -0.66063012449984, 0, 0.750711512487379 }, { 2.18602424038239, 0, 2.13080226843032, 0, 4.14805448144602, 0, -0.654118462050836, 0, 0.756392102527323 }, { 2.05005045569945, 0, 1.98823815710692, 0, 3.84625031624878, 0, -0.647086482573603, 0, 0.762416649555293 }, { 1.93356969965199, 0, 1.86412796069635, 0, 3.57466442929195, 0, -0.639686915344862, 0, 0.768635610473671 }, { 1.83281099239777, 0, 1.75442430924268, 0, 3.32988008993741, 0, -0.632081208664013, 0, 0.774902089473876 }, { 1.74159747407261, 0, 1.65313851557869, 0, 3.1108106777791, 0, -0.623870617962329, 0, 0.781527646918116 }, { 1.66077947962932, 0, 1.56000119209917, 0, 2.90903006942828, 0, -0.614272668155268, 0, 0.789093793586305 }, { 1.58918360483344, 0, 1.4728480961049, 0, 2.72067788991402, 0, -0.602392599383037, 0, 0.798199932429202 }, { 1.52712928981298, 0, 1.39356932280436, 0, 2.54854677260058, 0, -0.589543239321688, 0, 0.807736835862441 }, { 1.47180209084656, 0, 1.31876038457021, 0, 2.3922156662974, 0, -0.576022926635079, 0, 0.817433541221591 }, { 1.42165693732899, 0, 1.24769525644854, 0, 2.25026408833852, 0, -0.561654054873604, 0, 0.827372140293508 }, { 1.37729648598957, 0, 1.18070295779718, 0, 2.12159543523713, 0, -0.546722102908004, 0, 0.837314111756212 }, { 1.33721149034139, 0, 1.11621794274342, 0, 2.00358105619786, 0, -0.53114595904472, 0, 0.847280369374379 }, { 1.30156247049017, 0, 1.05542338383081, 0, 1.89609485873481, 0, -0.515074265229696, 0, 0.85714556808159 }, { 1.26885018264385, 0, 0.996092675282248, 0, 1.79947633907648, 0, -0.498447959658702, 0, 0.866919593596211 }, { 1.23829474939404, 0, 0.938080419468719, 0, 1.71067298126543, 0, -0.481091570528373, 0, 0.876670327387056 }, { 1.20976925450633, 0, 0.880927623668591, 0, 1.6295920701762, 0, -0.462819967061542, 0, 0.886452266607296 }, { 1.1834909495532, 0, 0.824397865260256, 0, 1.55387489708337, 0, -0.442988105304028, 0, 0.8965274235884 }, { 1.16037742972394, 0, 0.770665397037575, 0, 1.48529790906896, 0, -0.422943109546976, 0, 0.906156229708508 }, { 1.13667691129294, 0, 0.716680694307136, 0, 1.4219287154729, 0, -0.402544563023408, 0, 0.915400397170315 }, { 1.11607626008814, 0, 0.665959676921232, 0, 1.3649820406251, 0, -0.381954132206196, 0, 0.924181363979723 }, { 1.09657068280645, 0, 0.616218764111532, 0, 1.31204483343533, 0, -0.361168757223048, 0, 0.932500537787346 }, { 1.07605516977024, 0, 0.56653579690078, 0, 1.26438761501668, 0, -0.339569271875528, 0, 0.940581004250743 }, { 1.05703693966194, 0, 0.518148963440067, 0, 1.21992839147006, 0, -0.317330962094698, 0, 0.94831486240362 }, { 1.03928259509153, 0, 0.471442933084721, 0, 1.17916186811972, 0, -0.295272049266604, 0, 0.955413212536402 }, { 1.01989511553864, 0, 0.426146025553419, 0, 1.14094740802023, 0, -0.27337579849684, 0, 0.961907289540553 }, { 1.00253890463914, 0, 0.382680525028544, 0, 1.10659866414334, 0, -0.251371951280357, 0, 0.967890565899147 }, { 0.983824974932336, 0, 0.340061890661542, 0, 1.07380474378454, 0, -0.228860384666691, 0, 0.973459271002433 }, { 0.967969596542419, 0, 0.300734619732236, 0, 1.04385128034086, 0, -0.206705617424875, 0, 0.978403151943431 }, { 0.950322212324303, 0, 0.262542923013679, 0, 1.01552105876617, 0, -0.184834346524048, 0, 0.982769650331866 }, { 0.895312744351749, 0, 0.20134236684556, 0, 0.942349980661761, 0, -0.163018874500806, 0, 0.986622972709149 }, { 0.899519970931404, 0, 0.181624319758587, 0, 0.942349980661761, 0, -0.141304052354031, 0, 0.989966214018484 }, { 0.903209433921789, 0, 0.162284809942125, 0, 0.942349980661761, 0, -0.120033445681728, 0, 0.992769859773718 }, { 0.861524343652951, 0, 0.0859568596860825, 0, 0.865743580487994, 0, -0.0991820210771478, 0, 0.995069289645164 }, { 0.86313853510013, 0, 0.0678574412384809, 0, 0.865743580487994, 0, -0.0782770323771143, 0, 0.99693161898042 }, { 0.864333170665236, 0, 0.0504080834915148, 0, 0.865743580487994, 0, -0.0581229106947452, 0, 0.998309435788726 }, { 0.865165403451721, 0, 0.033189356775046, 0, 0.865743580487994, 0, -0.0382352087970051, 0, 0.999268704100024 }, { 0.865647181651144, 0, 0.0163640584527628, 0, 0.865743580487994, 0, -0.0188019560696658, 0, 0.999823242586473 }, { 0.865801824481064, 0, 3.45344717408864E-05, 0, 0.865743580487994, 0, 5.86407038811411E-05, 0, 0.999999996561268 },    // Cos(theta) = 0.7087427
            { 172.84152307779, 0, 180.629960823665, 0, 361.604307911167, 0, -0.722511420587319, 0, 0.6913589359304 }, { 172.838546111695, 0, 180.626290806646, 0, 361.609190277088, 0, -0.722511710445293, 0, 0.691358744163296 }, { 172.827174004171, 0, 180.613916437895, 0, 361.617163361926, 0, -0.722510737528851, 0, 0.691359681995125 }, { 152.443667748359, 0, 159.3128816509, 0, 318.938492327757, 0, -0.722503495279343, 0, 0.691367280029774 }, { 85.7510905716271, 0, 89.614749503047, 0, 179.400410317373, 0, -0.722483648772227, 0, 0.691388081246506 }, { 54.8808077538297, 0, 57.3530755808617, 0, 114.815026708817, 0, -0.722439837236714, 0, 0.691433798545552 }, { 38.1127672389136, 0, 39.8290834170517, 0, 79.7302346446074, 0, -0.722361901567481, 0, 0.69151518747783 }, { 28.0017366717597, 0, 29.2619957412495, 0, 58.5758739649328, 0, -0.722233552845372, 0, 0.691649276318867 }, { 21.439557681344, 0, 22.4036201865849, 0, 44.8445566241026, 0, -0.722039538525752, 0, 0.691851811761356 }, { 16.9410401757577, 0, 17.7018272218961, 0, 35.429229931622, 0, -0.721756539170252, 0, 0.692146922616475 }, { 13.7235379901399, 0, 14.3386814392277, 0, 28.6945981920084, 0, -0.721368611022638, 0, 0.692551257764412 }, { 11.3436531983656, 0, 11.8508037301545, 0, 23.7108787478814, 0, -0.720849320206395, 0, 0.693091795339473 }, { 9.53376562562433, 0, 9.95850521333452, 0, 19.9204916673904, 0, -0.720150128371599, 0, 0.693818285867766 }, { 8.13546021104249, 0, 8.49616215848068, 0, 16.985095541619, 0, -0.718481592410137, 0, 0.695545906068598 }, { 7.02221030542214, 0, 7.33156284077433, 0, 14.6486418797736, 0, -0.716879105365362, 0, 0.69719753147495 }, { 6.12228108687319, 0, 6.38973637199712, 0, 12.7597660512034, 0, -0.715252670678207, 0, 0.698865923931738 }, { 5.38561660343498, 0, 5.61834668479291, 0, 11.2122573106594, 0, -0.713518091878303, 0, 0.700636754199461 }, { 4.77969263215439, 0, 4.9832605483672, 0, 9.9350721647883, 0, -0.710940114328939, 0, 0.703252604714002 }, { 4.27056939105673, 0, 4.44910543716345, 0, 8.8613271499946, 0, -0.70832759042439, 0, 0.705883859596676 }, { 3.84227483288884, 0, 3.99902021612048, 0, 7.95391370731604, 0, -0.705194585582579, 0, 0.709013812763873 }, { 3.47765110361356, 0, 3.61506903543209, 0, 7.17990156557683, 0, -0.701598710436875, 0, 0.712572283270742 }, { 3.1660578406584, 0, 3.28598827054355, 0, 6.51280256579625, 0, -0.697537575632946, 0, 0.716548239598749 }, { 2.8966229893408, 0, 3.00045305159516, 0, 5.93446064256274, 0, -0.69302174107887, 0, 0.720916591888451 }, { 2.66431379121853, 0, 2.75310851221956, 0, 5.43093610848792, 0, -0.687835801360709, 0, 0.725866305921379 }, { 2.46470793010249, 0, 2.53898776319126, 0, 4.98689382864985, 0, -0.682085411013902, 0, 0.731272472051435 }, { 2.29007269976925, 0, 2.35026100503337, 0, 4.59560122006708, 0, -0.675693885070261, 0, 0.73718233605242 }, { 2.13870357351109, 0, 2.18477600619915, 0, 4.24679264579843, 0, -0.668824926693096, 0, 0.743419962552726 }, { 2.00943120387409, 0, 2.04165247306837, 0, 3.93343856610949, 0, -0.661412689023235, 0, 0.750022142436956 }, { 1.89666934638311, 0, 1.91461000336265, 0, 3.65370858860867, 0, -0.653540912467799, 0, 0.756891194685676 }, { 1.79670222039068, 0, 1.79951468202379, 0, 3.4029620436195, 0, -0.645394623015443, 0, 0.76384931771489 }, { 1.70924594571873, 0, 1.69614176939488, 0, 3.17606006401918, 0, -0.63678012326555, 0, 0.771045422761809 }, { 1.63424684408563, 0, 1.60403402427814, 0, 2.96814447457002, 0, -0.627319064022142, 0, 0.778762372956312 }, { 1.56655894261589, 0, 1.51646155907293, 0, 2.77548615316138, 0, -0.615668930129039, 0, 0.788004906199509 }, { 1.50530788127036, 0, 1.43308873359252, 0, 2.59877410779616, 0, -0.602430360278801, 0, 0.798171403718241 }, { 1.45208480997455, 0, 1.35624869462713, 0, 2.43630964053105, 0, -0.588476030494781, 0, 0.808514693488494 }, { 1.40172180707304, 0, 1.28135914698591, 0, 2.29050496673623, 0, -0.57363507682421, 0, 0.819110954594677 }, { 1.35880232621361, 0, 1.21164673817573, 0, 2.15660074580681, 0, -0.558199667106868, 0, 0.829706614471643 }, { 1.32084408612901, 0, 1.14543243798443, 0, 2.03552996863655, 0, -0.542063368867522, 0, 0.840337562491112 }, { 1.28583750623168, 0, 1.08170130348799, 0, 1.92481629797839, 0, -0.525399705578451, 0, 0.850855562786193 }, { 1.25704677761306, 0, 1.02248489154101, 0, 1.82347641028075, 0, -0.508226848270728, 0, 0.861223282481753 }, { 1.22819191395647, 0, 0.962923966502866, 0, 1.73216286423586, 0, -0.49042247146995, 0, 0.871484840976231 }, { 1.20187564654801, 0, 0.904901255839702, 0, 1.64902655577488, 0, -0.472027550824594, 0, 0.881583774022351 }, { 1.17593915272899, 0, 0.846837337068047, 0, 1.57128812407918, 0, -0.452223623081293, 0, 0.89190458131534 }, { 1.15213253562036, 0, 0.790015798410661, 0, 1.50011967442467, 0, -0.431464377183815, 0, 0.902130016971724 }, { 1.13106347243281, 0, 0.735648706916952, 0, 1.43535557021792, 0, -0.410450702132942, 0, 0.91188283587669 }, { 1.11136991430271, 0, 0.682908564851782, 0, 1.37682980158878, 0, -0.389236872494615, 0, 0.921137621083737 }, { 1.09066684195669, 0, 0.630237120113379, 0, 1.32249934970281, 0, -0.367969812408985, 0, 0.92983778266826 }, { 1.07197867856727, 0, 0.580112618839792, 0, 1.27311756847134, 0, -0.346286483755295, 0, 0.938128872070917 }, { 1.05260668484208, 0, 0.530670426742152, 0, 1.22676019388726, 0, -0.323864860761929, 0, 0.946103373397723 }, { 1.03637208564037, 0, 0.483533917098907, 0, 1.18576144724345, 0, -0.301141244964937, 0, 0.95357962004284 }, { 1.01796035264667, 0, 0.436841211651075, 0, 1.14710337228341, 0, -0.278524170393119, 0, 0.960429182937599 }, { 0.999636364646137, 0, 0.391921746741195, 0, 1.11109026109157, 0, -0.256185965003484, 0, 0.966627486709923 }, { 0.982762430204127, 0, 0.349061336198984, 0, 1.07752076155372, 0, -0.233736120873396, 0, 0.972300022217579 }, { 0.96652634396735, 0, 0.307832287407601, 0, 1.04666716239049, 0, -0.210754710727913, 0, 0.97753894895736 }, { 0.949044975926191, 0, 0.268299347357564, 0, 1.01734786013716, 0, -0.18836603233897, 0, 0.982098912115702 }, { 0.930712452905865, 0, 0.230982539752479, 0, 0.989477428458071, 0, -0.166303327750161, 0, 0.986074662205773 }, { 0.896636571880605, 0, 0.185293741758037, 0, 0.942769321744937, 0, -0.144238256512436, 0, 0.989543016313067 }, { 0.900495582572551, 0, 0.165525205972938, 0, 0.942769321744937, 0, -0.122435952960783, 0, 0.992476429798525 }, { 0.861355047993109, 0, 0.0876369908552637, 0, 0.865743580487994, 0, -0.101122589680322, 0, 0.994873944574396 }, { 0.863011104924976, 0, 0.0694592332542383, 0, 0.865743580487994, 0, -0.0801271145946602, 0, 0.996784619575598 }, { 0.864277113591047, 0, 0.0513591913946511, 0, 0.865743580487994, 0, -0.0592214454776765, 0, 0.998244798175985 }, { 0.865136448667825, 0, 0.0339372815898102, 0, 0.865743580487994, 0, -0.0390990642902149, 0, 0.999235346475509 }, { 0.865639797924563, 0, 0.0167483019767064, 0, 0.865743580487994, 0, -0.0192457576854064, 0, 0.999814758118569 }, { 0.865801811559416, 0, -6.34296380917968E-05, 0, 0.865743580487994, 0, 0.000171789123147159, 0, 0.999999970488496 },    // Cos(theta) = 0.691358
            { 168.365279188349, 0, 184.801250099103, 0, 371.214814328769, 0, -0.739214913482078, 0, 0.673469563632497 }, { 168.368853445685, 0, 184.805202187477, 0, 371.210591870387, 0, -0.739214972829083, 0, 0.673469558096568 }, { 168.36962409963, 0, 184.806427170388, 0, 371.209521112778, 0, -0.739213616477282, 0, 0.673471061473312 }, { 148.502377452955, 0, 162.99924448967, 0, 327.407610118377, 0, -0.739205359543727, 0, 0.67348009268754 }, { 83.307344164418, 0, 91.4725725539978, 0, 184.322129739017, 0, -0.73918352673974, 0, 0.673504037805991 }, { 53.4607379228053, 0, 58.6787961679568, 0, 117.863714293823, 0, -0.739138015358662, 0, 0.673554010706223 }, { 37.1265966727386, 0, 40.7496926370322, 0, 81.8471526263894, 0, -0.739053709410468, 0, 0.673646548676674 }, { 27.2774734241318, 0, 29.9385946584882, 0, 60.1313616514312, 0, -0.738916655294825, 0, 0.673796796247932 }, { 20.8854576423499, 0, 22.9220230126322, 0, 46.0349045089965, 0, -0.738708150929846, 0, 0.67402537336126 }, { 16.5032570025245, 0, 18.1113676353334, 0, 36.3703667107127, 0, -0.738406179127264, 0, 0.674356220136064 }, { 13.3691871043199, 0, 14.6706240268641, 0, 29.4562979452659, 0, -0.737990211420634, 0, 0.674811487294641 }, { 11.0507393782849, 0, 12.1250070488967, 0, 24.3400769339963, 0, -0.737432518645293, 0, 0.675420856238297 }, { 9.28843545048274, 0, 10.1897003795535, 0, 20.4498535382905, 0, -0.736658708622845, 0, 0.6762647182034 }, { 7.92786099231378, 0, 8.69512416328321, 0, 17.4382404042953, 0, -0.7348618050522, 0, 0.678216887444918 }, { 6.84237122781797, 0, 7.50234719833097, 0, 15.036927859505, 0, -0.733292466820875, 0, 0.679913292648174 }, { 5.9650559674134, 0, 6.53787644384857, 0, 13.0972875548055, 0, -0.731673687568702, 0, 0.681654965910092 }, { 5.24817574812569, 0, 5.74928528383177, 0, 11.5087548699775, 0, -0.729781315163255, 0, 0.683680695856909 }, { 4.65836296273513, 0, 5.09982669981638, 0, 10.1983885908238, 0, -0.727075486530806, 0, 0.686557614983985 }, { 4.16293241198101, 0, 4.55368156865169, 0, 9.09600138095223, 0, -0.724384992610032, 0, 0.689395693814573 }, { 3.74617730898788, 0, 4.09351653570805, 0, 8.16487011926239, 0, -0.721042285672435, 0, 0.692891071149726 }, { 3.39123977352368, 0, 3.70067208614494, 0, 7.36859438215752, 0, -0.717390703570765, 0, 0.696671056524406 }, { 3.08798378453691, 0, 3.36402309523843, 0, 6.68332531652845, 0, -0.713183559914261, 0, 0.700977362484223 }, { 2.82653469528464, 0, 3.07259550061342, 0, 6.09000348798936, 0, -0.708394348382122, 0, 0.705816805341201 }, { 2.60112587060983, 0, 2.82010120994674, 0, 5.57166893440101, 0, -0.703034530648895, 0, 0.711155783518656 }, { 2.40786885946881, 0, 2.60194085103929, 0, 5.11403258590359, 0, -0.69710393412674, 0, 0.716970103096751 }, { 2.23745337716482, 0, 2.40786525136626, 0, 4.71106856360357, 0, -0.690453968325291, 0, 0.723376294038042 }, { 2.09225605323238, 0, 2.24046773247984, 0, 4.35167229247278, 0, -0.683226587209866, 0, 0.730206431905288 }, { 1.96693633098774, 0, 2.09364949357687, 0, 4.0290482068807, 0, -0.675435505317861, 0, 0.737419027607325 }, { 1.85675214754776, 0, 1.96232764860343, 0, 3.73966651202239, 0, -0.667128362242002, 0, 0.74494275988699 }, { 1.76044160241429, 0, 1.84490194909179, 0, 3.48006274293166, 0, -0.658320412147068, 0, 0.752737871386105 }, { 1.67809498824552, 0, 1.74108290850024, 0, 3.24458736280428, 0, -0.649240106813083, 0, 0.760583485571515 }, { 1.60562027299261, 0, 1.64611515802447, 0, 3.03107469278701, 0, -0.639525229957042, 0, 0.768770164636088 }, { 1.53962764475031, 0, 1.55635162019181, 0, 2.83534082281334, 0, -0.628514412952147, 0, 0.777797942203297 }, { 1.48234521647517, 0, 1.47236578934374, 0, 2.65190234318813, 0, -0.614963576873364, 0, 0.788555561080415 }, { 1.43105013293198, 0, 1.39271334278152, 0, 2.48453834649738, 0, -0.600589621577397, 0, 0.799557432242712 }, { 1.38308797381429, 0, 1.31584750568803, 0, 2.33307913419691, 0, -0.585283224682924, 0, 0.810828930923881 }, { 1.34223351140318, 0, 1.24452202385517, 0, 2.1943809568116, 0, -0.569334373812898, 0, 0.822106043198858 }, { 1.30570898513118, 0, 1.17592106272578, 0, 2.06840796156217, 0, -0.552650654758394, 0, 0.833413041496609 }, { 1.27447941090195, 0, 1.11181162101491, 0, 1.95295469661207, 0, -0.535346348273276, 0, 0.844632655653107 }, { 1.24343522639237, 0, 1.04746213765927, 0, 1.84953583778969, 0, -0.517629193885623, 0, 0.855605045499904 }, { 1.21588669701081, 0, 0.986170650132321, 0, 1.75500988312245, 0, -0.499326105783283, 0, 0.866414122614847 }, { 1.19242871004026, 0, 0.927864164919609, 0, 1.66795031946195, 0, -0.480508151177443, 0, 0.876990263269748 }, { 1.16922889877749, 0, 0.869614684656207, 0, 1.58827845206413, 0, -0.460901084886116, 0, 0.887451591065636 }, { 1.1455493728648, 0, 0.810250603956336, 0, 1.51573497124968, 0, -0.439857996661875, 0, 0.898067308829123 }, { 1.12445426661926, 0, 0.753418503660808, 0, 1.4487730350145, 0, -0.418223400909794, 0, 0.908344187616225 }, { 1.10466339043194, 0, 0.698588670201301, 0, 1.38821926639726, 0, -0.39632838985046, 0, 0.918108821392052 }, { 1.08627926996165, 0, 0.645846304252633, 0, 1.33251477829787, 0, -0.374400427412315, 0, 0.927267110745702 }, { 1.06643621057217, 0, 0.593207984924567, 0, 1.28182033960104, 0, -0.352317572972025, 0, 0.935880466174204 }, { 1.04908574920837, 0, 0.542955180744862, 0, 1.23538533977394, 0, -0.330007742141827, 0, 0.943978194032902 }, { 1.03205481800698, 0, 0.494278502052318, 0, 1.19133207480926, 0, -0.306899535024912, 0, 0.951741894897006 }, { 1.01593548345371, 0, 0.447066272424277, 0, 1.15243789960695, 0, -0.283659282796685, 0, 0.958925139646741 }, { 0.997872229504801, 0, 0.40110832936995, 0, 1.11576074033001, 0, -0.260665577947068, 0, 0.965429121693523 }, { 0.981033465532762, 0, 0.357319745014216, 0, 1.08159682205161, 0, -0.237921530602206, 0, 0.971284367587492 }, { 0.965639612231838, 0, 0.315228147703386, 0, 1.04972389069798, 0, -0.215123452430096, 0, 0.976586845311502 }, { 0.9472921127062, 0, 0.274639345558962, 0, 1.01990280666091, 0, -0.191908818073834, 0, 0.981412751028926 }, { 0.929852789290578, 0, 0.236585757301218, 0, 0.991386677454545, 0, -0.169252916231723, 0, 0.985572603494807 }, { 0.894590427805301, 0, 0.18872742063916, 0, 0.942894633129813, 0, -0.147089068765251, 0, 0.989123215840905 }, { 0.898588508495892, 0, 0.168667826143988, 0, 0.942894633129813, 0, -0.124925153270176, 0, 0.992166175855581 }, { 0.861195599480308, 0, 0.0891903047117415, 0, 0.865743580487994, 0, -0.102916683329988, 0, 0.994689958514014 }, { 0.862906217402247, 0, 0.0707503485643937, 0, 0.865743580487994, 0, -0.0816183630518582, 0, 0.996663621550395 }, { 0.864201621379186, 0, 0.0526152707080323, 0, 0.865743580487994, 0, -0.060672224058529, 0, 0.998157747709905 }, { 0.865114087434965, 0, 0.0345031032134517, 0, 0.865743580487994, 0, -0.0397525900817761, 0, 0.999209583670666 }, { 0.865632515461989, 0, 0.0171239522526856, 0, 0.865743580487994, 0, -0.0196796340992873, 0, 0.999806389632555 }, { 0.865801821667127, 0, -7.36934504290505E-06, 0, 0.865743580487994, 0, 0.000107039557998684, 0, 0.999999988542533 },    // Cos(theta) = 0.6734694
            { 163.769509206966, 0, 188.890625251676, 0, 381.63279971148, 0, -0.755563070347054, 0, 0.655075899068592 }, { 163.771093358868, 0, 188.892487734378, 0, 381.631122587536, 0, -0.755562817578151, 0, 0.655076236327501 }, { 136.394261717676, 0, 157.31646555646, 0, 499.999976251275, 0, -0.755560323393324, 0, 0.655079001980322 }, { 114.477730139735, 0, 132.0380812493, 0, 499.999976251275, 0, -0.755552124614534, 0, 0.65508860559257 }, { 81.1225192229889, 0, 93.5909094827076, 0, 189.442191301136, 0, -0.755527366593178, 0, 0.655117137064634 }, { 52.0006628928757, 0, 59.9762918425016, 0, 121.172571495164, 0, -0.755478889245451, 0, 0.655173081639457 }, { 36.1126358624746, 0, 41.6506713672698, 0, 84.146652205228, 0, -0.755389809931231, 0, 0.65527575446156 }, { 26.5327030086942, 0, 30.6006905087824, 0, 61.8202604258111, 0, -0.755243641588058, 0, 0.655444078346294 }, { 20.3153037249565, 0, 23.4289447824687, 0, 47.3275433278466, 0, -0.755020313851732, 0, 0.655701393149151 }, { 16.0530611301588, 0, 18.5121635742894, 0, 37.3912424834186, 0, -0.754697932941749, 0, 0.656072501792385 }, { 13.0044666483913, 0, 14.9951098681612, 0, 30.2830085672631, 0, -0.754254171733363, 0, 0.656582438742591 }, { 10.749478669932, 0, 12.3932457271507, 0, 25.023717450496, 0, -0.753656788123172, 0, 0.657268152205999 }, { 9.03696970944309, 0, 10.4169816070057, 0, 21.0258495624125, 0, -0.752753614656257, 0, 0.658302418226998 }, { 7.71382107962582, 0, 8.88953611115373, 0, 17.9293082360798, 0, -0.750891386936035, 0, 0.660425774559508 }, { 6.65701815198292, 0, 7.66916749853399, 0, 15.4594298761153, 0, -0.74934290930134, 0, 0.662182144234472 }, { 5.8035288405408, 0, 6.6830635427799, 0, 13.4635157047322, 0, -0.747709510098082, 0, 0.664025907098956 }, { 5.10808110458972, 0, 5.87900775096635, 0, 11.832571557001, 0, -0.745570434145196, 0, 0.666426848998478 }, { 4.53383422579143, 0, 5.21437744098184, 0, 10.4832793285262, 0, -0.742890859102441, 0, 0.66941252149236 }, { 4.0517344654469, 0, 4.65572672358002, 0, 9.34955934031144, 0, -0.740096245395421, 0, 0.672500998839588 }, { 3.64712458025013, 0, 4.18590356106169, 0, 8.39243296533095, 0, -0.736595614989714, 0, 0.676333467782296 }, { 3.3030552444462, 0, 3.7854667656169, 0, 7.5738603393267, 0, -0.732750869926803, 0, 0.680496914233886 }, { 3.00768134064529, 0, 3.44060072274804, 0, 6.86878573604988, 0, -0.728411843834635, 0, 0.685139527941896 }, { 2.75399678943258, 0, 3.14310362659057, 0, 6.25800821941888, 0, -0.723410318605127, 0, 0.690418429280686 }, { 2.53734420627144, 0, 2.88740476025755, 0, 5.7242169872879, 0, -0.717756564483639, 0, 0.696294124139493 }, { 2.3478730958812, 0, 2.66223449808394, 0, 5.25310974553881, 0, -0.71167140127797, 0, 0.702512492095013 }, { 2.18496451178938, 0, 2.46651529651482, 0, 4.83658262172798, 0, -0.704767164752865, 0, 0.709438738768211 }, { 2.04496557209781, 0, 2.29602090182319, 0, 4.46400698063753, 0, -0.697205684654804, 0, 0.716871103647469 }, { 1.92217642329312, 0, 2.1442033261879, 0, 4.13177374897825, 0, -0.689056330378754, 0, 0.724707838119756 }, { 1.81604658002605, 0, 2.00995453398291, 0, 3.83235926569429, 0, -0.680353687317841, 0, 0.732883979550965 }, { 1.72598496041697, 0, 1.89261003458493, 0, 3.56055680925313, 0, -0.671117096064648, 0, 0.741351331934692 }, { 1.64721168717378, 0, 1.78663631095965, 0, 3.31675347536738, 0, -0.661418631007141, 0, 0.750016943861425 }, { 1.57551361742034, 0, 1.68689158373252, 0, 3.09698602080944, 0, -0.651207758435843, 0, 0.758899456015262 }, { 1.51565346695025, 0, 1.59867287399561, 0, 2.89522163560079, 0, -0.640192021307612, 0, 0.768214856837625 }, { 1.45888894053791, 0, 1.5113581849815, 0, 2.70850966815661, 0, -0.627095989800013, 0, 0.778941979587317 }, { 1.40999178224648, 0, 1.42970144782418, 0, 2.53444187321987, 0, -0.612350282135044, 0, 0.790586510045584 }, { 1.36642811416546, 0, 1.35238174166489, 0, 2.37683750840728, 0, -0.596581798400533, 0, 0.802552258228781 }, { 1.32766234318169, 0, 1.27862648712797, 0, 2.23290841858031, 0, -0.580161749911726, 0, 0.814501284984539 }, { 1.29203017313553, 0, 1.20759278668841, 0, 2.1025855292091, 0, -0.562946105443287, 0, 0.826493569012979 }, { 1.2598424642507, 0, 1.13875447673767, 0, 1.983900704166, 0, -0.545053578324183, 0, 0.838401254783507 }, { 1.23094637607536, 0, 1.07321288501746, 0, 1.87593052119329, 0, -0.526757462876669, 0, 0.850015614702493 }, { 1.20666463830509, 0, 1.01138717294466, 0, 1.77725913854924, 0, -0.50786222496794, 0, 0.861438257810881 }, { 1.1813733777676, 0, 0.948818068899285, 0, 1.68824846385479, 0, -0.488489548199128, 0, 0.872569757266698 }, { 1.16004063458207, 0, 0.889338994950707, 0, 1.60600862429714, 0, -0.468623193176874, 0, 0.88339812294014 }, { 1.13952923464779, 0, 0.831252764668083, 0, 1.53137358621975, 0, -0.447956353627259, 0, 0.894055426522483 }, { 1.11731796658011, 0, 0.771003290342128, 0, 1.46289267401179, 0, -0.425814277752259, 0, 0.904810558511294 }, { 1.09769378707492, 0, 0.714113908438992, 0, 1.3998138298588, 0, -0.403358753844193, 0, 0.915041915238893 }, { 1.0798171501139, 0, 0.659175869546096, 0, 1.3427015401895, 0, -0.38070393113572, 0, 0.924696909001309 }, { 1.0623132892166, 0, 0.606273038232869, 0, 1.29051859055268, 0, -0.358059149382124, 0, 0.933698922118712 }, { 1.04515788513008, 0, 0.55468701046806, 0, 1.24239131618155, 0, -0.335356618702324, 0, 0.94209129841043 }, { 1.02872146624488, 0, 0.50530189727211, 0, 1.19796761852007, 0, -0.312485314644816, 0, 0.949922552510315 }, { 1.0127490127481, 0, 0.456699070929722, 0, 1.15743965823761, 0, -0.288752446523335, 0, 0.957403811806621 }, { 0.995239584712537, 0, 0.409608805768452, 0, 1.12006889349684, 0, -0.265118678111083, 0, 0.964215826631564 }, { 0.979841560925967, 0, 0.364778524745679, 0, 1.08507012113385, 0, -0.241785148353057, 0, 0.97032979946444 }, { 0.963004092357196, 0, 0.321862862533872, 0, 1.05339369778405, 0, -0.218758898370675, 0, 0.975778947944418 }, { 0.946284572806951, 0, 0.280789680832142, 0, 1.02217307311729, 0, -0.1956219072674, 0, 0.980679390590665 }, { 0.928885294662579, 0, 0.241391986177124, 0, 0.993092552479443, 0, -0.172252920106353, 0, 0.985052746437216 }, { 0.89291126806551, 0, 0.191887580004462, 0, 0.94239748329537, 0, -0.149515877770834, 0, 0.988759309998916 }, { 0.897010996044736, 0, 0.171705302209346, 0, 0.942397483295369, 0, -0.127183174842921, 0, 0.9918792693585 }, { 0.86100332560562, 0, 0.0910278820537338, 0, 0.865743580487994, 0, -0.105039104674975, 0, 0.994468091552006 }, { 0.862809693523147, 0, 0.0719184701315622, 0, 0.865743580487994, 0, -0.0829675529424702, 0, 0.996552269526165 }, { 0.864147898834312, 0, 0.0534910471076919, 0, 0.865743580487994, 0, -0.0616837507862588, 0, 0.998095797902816 }, { 0.865077981846, 0, 0.035396844752476, 0, 0.865743580487994, 0, -0.0407848645175394, 0, 0.999167983469399 }, { 0.865629017968215, 0, 0.0172992838305557, 0, 0.865743580487994, 0, -0.0198821422440168, 0, 0.999802369984427 }, { 0.86580182148074, 0, -8.9571686115264E-06, 0, 0.865743580487994, 0, 0.000108873492155046, 0, 0.999999988146563 },    // Cos(theta) = 0.6550768
            { 159.046706705647, 0, 192.886700177029, 0, 392.967829429427, 0, -0.771539846043599, 0, 0.636180979677455 }, { 159.043985294812, 0, 192.883415806885, 0, 392.973067299994, 0, -0.771540234641189, 0, 0.636180479229134 }, { 159.024663504116, 0, 192.857715729619, 0, 392.999622582135, 0, -0.771537197439612, 0, 0.636184226037728 }, { 140.277165872629, 0, 170.123489051683, 0, 346.599001559497, 0, -0.771528393009139, 0, 0.636194860185023 }, { 78.9075875823879, 0, 95.6960023376052, 0, 194.959317909169, 0, -0.771503683663255, 0, 0.636224912393454 }, { 50.5011391559003, 0, 61.2451148043506, 0, 124.772084701223, 0, -0.771451515929573, 0, 0.636288092493288 }, { 35.0704880318522, 0, 42.5307608591341, 0, 86.6462318413992, 0, -0.771356924558871, 0, 0.636402821992531 }, { 25.7674297897244, 0, 31.2476858279183, 0, 63.6550919783362, 0, -0.771202021681978, 0, 0.636590475756208 }, { 19.7297888767222, 0, 23.9247282372189, 0, 48.732758423653, 0, -0.770963295781604, 0, 0.636879501360184 }, { 15.5905659517654, 0, 18.9039878878807, 0, 38.5013837665533, 0, -0.770620660356041, 0, 0.637294077793393 }, { 12.630262199601, 0, 15.3128847638884, 0, 31.1819087009766, 0, -0.770145970182276, 0, 0.637867703610957 }, { 10.4402632186348, 0, 12.6558409308998, 0, 25.7660048890045, 0, -0.769507986721849, 0, 0.638637170600625 }, { 8.78193043902042, 0, 10.6434153546095, 0, 21.6574313883876, 0, -0.768283251406542, 0, 0.640109969090191 }, { 7.49288499593325, 0, 9.07863137143468, 0, 18.4617200567406, 0, -0.766644162107458, 0, 0.642072136020382 }, { 6.46629358866087, 0, 7.83196784248225, 0, 15.9166120033876, 0, -0.765084251286285, 0, 0.643930233986691 }, { 5.63782126992068, 0, 6.82532740533192, 0, 13.8627359292611, 0, -0.763331524665756, 0, 0.646006884740207 }, { 4.96455959229928, 0, 6.00661561178865, 0, 12.1865927132667, 0, -0.760888922324948, 0, 0.6488821405781 }, { 4.4054813360385, 0, 5.32600513538128, 0, 10.7937512610518, 0, -0.758320430432194, 0, 0.65188202656126 }, { 3.93880715304897, 0, 4.75712260573355, 0, 9.62679951473107, 0, -0.755295945938305, 0, 0.6553838967471 }, { 3.54528860060047, 0, 4.27641492754438, 0, 8.64043224449594, 0, -0.751763501203936, 0, 0.659432914204394 }, { 3.21170019983473, 0, 3.86784126465104, 0, 7.79835418346372, 0, -0.747651448609071, 0, 0.664091393439318 }, { 2.92522068929128, 0, 3.51571775683505, 0, 7.0705572861695, 0, -0.743243754118015, 0, 0.669020658910522 }, { 2.680140495888, 0, 3.21296860452638, 0, 6.4400515125272, 0, -0.738101804122889, 0, 0.674689319699982 }, { 2.46945371658161, 0, 2.95100107877401, 0, 5.88872202782622, 0, -0.73228568978093, 0, 0.680997505653699 }, { 2.28679648663025, 0, 2.72194092726932, 0, 5.40326853088155, 0, -0.725883645089223, 0, 0.687817497254851 }, { 2.13059644105304, 0, 2.52375642890682, 0, 4.97172514908147, 0, -0.718691394549123, 0, 0.695329233340435 }, { 1.99453632248719, 0, 2.3486701683256, 0, 4.58704647588586, 0, -0.710869885643781, 0, 0.703323579595466 }, { 1.87716050172064, 0, 2.19462011925728, 0, 4.24137892671928, 0, -0.702326408926899, 0, 0.711854924923549 }, { 1.77786440396649, 0, 2.06091568950236, 0, 3.93065884965667, 0, -0.693107416716875, 0, 0.720834304995469 }, { 1.69052284236326, 0, 1.93973503807584, 0, 3.64841588816836, 0, -0.683459858677537, 0, 0.729988077541 }, { 1.61281764538154, 0, 1.82856617636793, 0, 3.39656457284459, 0, -0.673198285646267, 0, 0.739461955757179 }, { 1.54506784068443, 0, 1.72768307043033, 0, 3.16854379340617, 0, -0.662480281814157, 0, 0.749079399477644 }, { 1.48856651552203, 0, 1.63771170074476, 0, 2.95852379243512, 0, -0.651141892822276, 0, 0.758956027790942 }, { 1.43786071719844, 0, 1.5524351642661, 0, 2.76708411487129, 0, -0.638516860948384, 0, 0.769607791375603 }, { 1.39133432247321, 0, 1.46911221111705, 0, 2.58641947343137, 0, -0.623715579292089, 0, 0.781651377405159 }, { 1.3502122293472, 0, 1.38932345730801, 0, 2.42325822110488, 0, -0.607510286560089, 0, 0.794311766895687 }, { 1.31234859386429, 0, 1.31227360802351, 0, 2.27419178208569, 0, -0.59061752085129, 0, 0.806951619291647 }, { 1.2785082834882, 0, 1.23897270294386, 0, 2.13715795993246, 0, -0.572925535391844, 0, 0.819607390542524 }, { 1.24800680537894, 0, 1.16850886451172, 0, 2.0142877418569, 0, -0.554480501120111, 0, 0.832196724577932 }, { 1.21953935563688, 0, 1.09937884362951, 0, 1.90413617832516, 0, -0.535570151538928, 0, 0.844490683397529 }, { 1.19385943044334, 0, 1.03326394669716, 0, 1.80223421719534, 0, -0.516147236255207, 0, 0.856499917063861 }, { 1.17050772716111, 0, 0.969332795029318, 0, 1.70868528278352, 0, -0.496151839685213, 0, 0.868235775565405 }, { 1.1503137084646, 0, 0.908701617661782, 0, 1.62439764930425, 0, -0.475836908923294, 0, 0.879533540494831 }, { 1.13131817553566, 0, 0.849500595389876, 0, 1.54741088126375, 0, -0.454971182334881, 0, 0.890506183314783 }, { 1.11206740656379, 0, 0.789546154664846, 0, 1.47884515190283, 0, -0.433250582621625, 0, 0.901273437848558 }, { 1.09257789628287, 0, 0.730888173636102, 0, 1.41245604023882, 0, -0.410223703633775, 0, 0.911984944907817 }, { 1.07528434661516, 0, 0.674037151679684, 0, 1.35321087108696, 0, -0.386973232802509, 0, 0.922090949466709 }, { 1.05851694623423, 0, 0.619624625423303, 0, 1.29959880232194, 0, -0.363690822288366, 0, 0.931519760874767 }, { 1.04111316217458, 0, 0.565890774972417, 0, 1.25024411125088, 0, -0.340454085641837, 0, 0.940261163902741 }, { 1.02354642754822, 0, 0.513987833619076, 0, 1.20465275170173, 0, -0.317145961569877, 0, 0.948376768794857 }, { 1.00904497480032, 0, 0.465810752688405, 0, 1.16303924203974, 0, -0.293864855354789, 0, 0.955846994994387 }, { 0.991881812936826, 0, 0.417139378454712, 0, 1.12447276334333, 0, -0.269651216570285, 0, 0.962958081501935 }, { 0.974885152035057, 0, 0.371200035025041, 0, 1.08853674149398, 0, -0.245640959864392, 0, 0.969360874383537 }, { 0.960537811930174, 0, 0.327874182029296, 0, 1.05589011603954, 0, -0.222013769236232, 0, 0.975043525141318 }, { 0.944816481284554, 0, 0.286421605741676, 0, 1.0250041121216, 0, -0.198740758080466, 0, 0.980052077179812 }, { 0.92787445535322, 0, 0.246468007454432, 0, 0.995199762953882, 0, -0.175574598526509, 0, 0.984466123334128 }, { 0.890735213207711, 0, 0.195390467418581, 0, 0.942458931855383, 0, -0.151979031570276, 0, 0.988383725938319 }, { 0.895006065419247, 0, 0.174787938394937, 0, 0.942458931855382, 0, -0.129135167667433, 0, 0.99162702421846 }, { 0.860845202894552, 0, 0.0925114798133296, 0, 0.865743580487994, 0, -0.10675267617162, 0, 0.994285628857249 }, { 0.862680665994974, 0, 0.0734498971748989, 0, 0.865743580487994, 0, -0.0847363638892372, 0, 0.996403417173151 }, { 0.864095629998021, 0, 0.0543283487278561, 0, 0.865743580487994, 0, -0.0626508390277726, 0, 0.998035522748851 }, { 0.865060534032126, 0, 0.0358192865668769, 0, 0.865743580487994, 0, -0.0412727862548712, 0, 0.999147879340582 }, { 0.865617441982506, 0, 0.0178663459790512, 0, 0.865743580487994, 0, -0.0205370996128296, 0, 0.999789064267329 }, { 0.865801809606744, 0, -7.11193821079991E-05, 0, 0.865743580487994, 0, 0.000180670767363784, 0, 0.999999967358073 },    // Cos(theta) = 0.6361804
            { 154.196141061846, 0, 196.784946223858, 0, 405.330139507783, 0, -0.787133697086491, 0, 0.616782476196585 }, { 154.194679709819, 0, 196.783149898095, 0, 405.331277221925, 0, -0.787136122117513, 0, 0.616779362055268 }, { 134.064349993434, 0, 171.093393117249, 0, 499.999976251276, 0, -0.787132709790267, 0, 0.616783701548735 }, { 136.000038403788, 0, 173.563008941608, 0, 357.500607102862, 0, -0.787123532849815, 0, 0.616795292350833 }, { 76.5010870060479, 0, 97.6299790676611, 0, 201.093449560127, 0, -0.787097392557305, 0, 0.616828738146987 }, { 48.9609178449304, 0, 62.4827018613377, 0, 128.698370817716, 0, -0.787040964025041, 0, 0.61690075393458 }, { 34.0019431135284, 0, 43.3914616520339, 0, 89.3709096453499, 0, -0.786940870902195, 0, 0.617028413817597 }, { 24.9824305250767, 0, 31.8800735739972, 0, 65.656538744908, 0, -0.786775275312875, 0, 0.617239475813776 }, { 19.1286302321848, 0, 24.4086376574363, 0, 50.2651164375266, 0, -0.78652265736432, 0, 0.617561330274153 }, { 15.1155818173117, 0, 19.2862623756062, 0, 39.7116980747861, 0, -0.786158555705734, 0, 0.618024974651342 }, { 12.2459165570125, 0, 15.6229172814333, 0, 32.163033654925, 0, -0.785654945680259, 0, 0.618664860493826 }, { 10.1231303748765, 0, 12.9125985974292, 0, 26.5760653047463, 0, -0.784970382462648, 0, 0.619533331456305 }, { 8.5185752856578, 0, 10.863455867998, 0, 22.3439582219705, 0, -0.7835175036986, 0, 0.621369738381565 }, { 7.26671536333209, 0, 9.26420841958522, 0, 19.0431134667754, 0, -0.781966213518367, 0, 0.623320821220957 }, { 6.27084706306517, 0, 7.99140369016576, 0, 16.4167453803918, 0, -0.78040038271681, 0, 0.625280179430631 }, { 5.46883402248261, 0, 6.96575380402095, 0, 14.2980628509094, 0, -0.778533928616347, 0, 0.627602512017895 }, { 4.81621689431789, 0, 6.13036504799935, 0, 12.5698479593299, 0, -0.775967795011442, 0, 0.630772545856399 }, { 4.27388162981529, 0, 5.43540629349623, 0, 11.1323986568587, 0, -0.773344832253836, 0, 0.633985701809322 }, { 3.82232714766275, 0, 4.85580803268241, 0, 9.92978760141573, 0, -0.77012090440286, 0, 0.637898055149864 }, { 3.44159837509726, 0, 4.36599572182056, 0, 8.90953562323799, 0, -0.766553563032372, 0, 0.642180418287094 }, { 3.11809612585884, 0, 3.94872488466922, 0, 8.04063193361538, 0, -0.762313927175057, 0, 0.647207409393927 }, { 2.84151916857977, 0, 3.59041153115128, 0, 7.29044080743638, 0, -0.757626582493001, 0, 0.652688307046669 }, { 2.60558626227895, 0, 3.28311370478798, 0, 6.63825089378168, 0, -0.752307888132088, 0, 0.658811685171067 }, { 2.40021175168019, 0, 3.01386040921646, 0, 6.0690452246909, 0, -0.746321700385573, 0, 0.6655854184938 }, { 2.22562631063368, 0, 2.7827009087687, 0, 5.56550507421241, 0, -0.739625962004326, 0, 0.673018185888954 }, { 2.07466064412027, 0, 2.58017648043476, 0, 5.11884070292921, 0, -0.732202152386716, 0, 0.681087411626918 }, { 1.94376211006788, 0, 2.40180703436468, 0, 4.71965898987197, 0, -0.724095282248272, 0, 0.689699888497926 }, { 1.83316942820175, 0, 2.24742273690517, 0, 4.35908266506364, 0, -0.715260826529635, 0, 0.698857686001607 }, { 1.73818701603482, 0, 2.11087933731978, 0, 4.03575226503926, 0, -0.70560227746721, 0, 0.708608020194122 }, { 1.6526707201622, 0, 1.98471381626452, 0, 3.74321400251823, 0, -0.695454891833348, 0, 0.71856975176943 }, { 1.578887236775, 0, 1.8714908820175, 0, 3.48064508927914, 0, -0.684625241532757, 0, 0.728895218822528 }, { 1.51680209110517, 0, 1.77059847603193, 0, 3.24204666420873, 0, -0.673355775155739, 0, 0.739318562421633 }, { 1.46335407592069, 0, 1.67871865571734, 0, 3.02400467031292, 0, -0.661535545516421, 0, 0.749913794035469 }, { 1.41001376190054, 0, 1.58602089647216, 0, 2.82887608355676, 0, -0.648737499801186, 0, 0.761012267435107 }, { 1.36724714028014, 0, 1.50276371413848, 0, 2.64492745475351, 0, -0.634665202618626, 0, 0.772787227261361 }, { 1.32724280601981, 0, 1.42023750800502, 0, 2.47393192878113, 0, -0.618073049596205, 0, 0.786120733273149 }, { 1.29168016813952, 0, 1.34108991163329, 0, 2.31887365001887, 0, -0.600682370148302, 0, 0.799487759399288 }, { 1.25966460285876, 0, 1.26536436091032, 0, 2.17788011347215, 0, -0.582572345231173, 0, 0.812778919637594 }, { 1.23472080973866, 0, 1.19640539143145, 0, 2.04794952353301, 0, -0.563583440262953, 0, 0.826059084977538 }, { 1.20905718386805, 0, 1.12622675008394, 0, 1.93222138960692, 0, -0.544096677260957, 0, 0.839022561257281 }, { 1.18385201430134, 0, 1.05720177570296, 0, 1.82763479819433, 0, -0.5240945763241, 0, 0.851660064223589 }, { 1.16072888773535, 0, 0.990582284183873, 0, 1.73106213051935, 0, -0.503557797163641, 0, 0.863961468145641 }, { 1.1398600719673, 0, 0.926710515098763, 0, 1.64412125763583, 0, -0.482674265522574, 0, 0.875799944237847 }, { 1.12226194218104, 0, 0.865738944445759, 0, 1.56505374485658, 0, -0.461362476223787, 0, 0.887211730606686 }, { 1.104507576944, 0, 0.805674138499401, 0, 1.49263898770028, 0, -0.439544889583246, 0, 0.898220666205358 }, { 1.08693875301172, 0, 0.746625396660731, 0, 1.425612747221, 0, -0.416957400366979, 0, 0.908926058045042 }, { 1.06894702467887, 0, 0.687579901995243, 0, 1.3644127634904, 0, -0.393085711258103, 0, 0.919501824935339 }, { 1.05419773906448, 0, 0.632072809955278, 0, 1.30842586500081, 0, -0.369173764126672, 0, 0.929360387051536 }, { 1.03630257292735, 0, 0.57690928857993, 0, 1.25796646291873, 0, -0.345360420936936, 0, 0.938470208110575 }, { 1.02013465670135, 0, 0.52441419452145, 0, 1.21155023356808, 0, -0.321552384729841, 0, 0.946891723852617 }, { 1.00458368466992, 0, 0.473702509100586, 0, 1.16918135707037, 0, -0.297850814931918, 0, 0.954612425865744 }, { 0.98893796221863, 0, 0.425335996045647, 0, 1.12991693225895, 0, -0.27414527470627, 0, 0.961688232891587 }, { 0.972205128770095, 0, 0.377910248256656, 0, 1.09261927116111, 0, -0.249580411893386, 0, 0.968354043440349 }, { 0.955850148418406, 0, 0.332744598195576, 0, 1.05748580949072, 0, -0.225288575466498, 0, 0.974292058989103 }, { 0.941000496046838, 0, 0.290750990186104, 0, 1.02628044089597, 0, -0.201531098212058, 0, 0.979482118782326 }, { 0.924030704436579, 0, 0.250184400897803, 0, 0.995784557050979, 0, -0.178034973617399, 0, 0.9840241532023 }, { 0.887818243541587, 0, 0.198829110569393, 0, 0.942574048258179, 0, -0.154803303495319, 0, 0.987945303103137 }, { 0.892306818648894, 0, 0.177603038104109, 0, 0.942574048258178, 0, -0.131202271375284, 0, 0.991355641457666 }, { 0.860694826613232, 0, 0.093899918589104, 0, 0.865743580487994, 0, -0.108356338282919, 0, 0.994112102449815 }, { 0.862590856781385, 0, 0.0744968096676381, 0, 0.865743580487994, 0, -0.0859455566908025, 0, 0.996299806785389 }, { 0.864023560292255, 0, 0.0554621748218095, 0, 0.865743580487994, 0, -0.0639604149080963, 0, 0.997952411360527 }, { 0.865036184562998, 0, 0.0364046011140374, 0, 0.865743580487994, 0, -0.041948826574262, 0, 0.999119822343698 }, { 0.865616089899808, 0, 0.0179316400137302, 0, 0.865743580487994, 0, -0.02061251429269, 0, 0.999787510043995 }, { 0.865801823627929, 0, 7.10174991296488E-05, 0, 0.865743580487994, 0, 1.65028541187515E-05, 0, 0.999999999727656 },    // Cos(theta) = 0.61678
            { 149.222165054621, 0, 200.587324255303, 0, 418.843164954473, 0, -0.802337001422774, 0, 0.596871176024324 }, { 149.222322420806, 0, 200.587550597185, 0, 418.844811101549, 0, -0.80233286884757, 0, 0.59687689711376 }, { 149.243686466437, 0, 200.601969188828, 0, 417.499494344657, 0, -0.802332121093669, 0, 0.596877930558112 }, { 110.884061001985, 0, 149.053947014372, 0, 499.999976251275, 0, -0.802320550488894, 0, 0.596893289304257 }, { 74.0326378976712, 0, 99.5153861031845, 0, 207.79608076824, 0, -0.802293085787565, 0, 0.596930342573641 }, { 47.3812834856652, 0, 63.6894955510115, 0, 132.988514624942, 0, -0.802234160186356, 0, 0.597009618915272 }, { 32.9043094145628, 0, 44.228609231802, 0, 92.3498461259012, 0, -0.80212766053291, 0, 0.597152591653993 }, { 24.1761569984728, 0, 32.4952442302529, 0, 67.8464880949398, 0, -0.801952203161611, 0, 0.597388222747476 }, { 18.5117116384637, 0, 24.8800485010715, 0, 51.9415254060404, 0, -0.801683713736395, 0, 0.597748450787526 }, { 14.6286615664201, 0, 19.6593284054014, 0, 41.0353429414774, 0, -0.801297885082159, 0, 0.598265619362292 }, { 11.8513196033742, 0, 15.9247949247471, 0, 33.2338091641056, 0, -0.800764953233171, 0, 0.598978679778725 }, { 9.7976850138625, 0, 13.1628468992747, 0, 27.4614552135219, 0, -0.800026038568579, 0, 0.599965258898762 }, { 8.2468543593525, 0, 11.0765905952391, 0, 23.091451202238, 0, -0.798444229901247, 0, 0.602068795741045 }, { 7.03352140723744, 0, 9.44376035956554, 0, 19.6764841211614, 0, -0.796964417872755, 0, 0.604026266257233 }, { 6.07036553475294, 0, 8.14699004838909, 0, 16.9637838957278, 0, -0.795313144869073, 0, 0.606198715866921 }, { 5.29469899621388, 0, 7.10189617809486, 0, 14.7742889146657, 0, -0.793332290415174, 0, 0.608788811151908 }, { 4.66313193826929, 0, 6.25014328253332, 0, 12.9871738338698, 0, -0.790729286445337, 0, 0.612165989162935 }, { 4.13959353906606, 0, 5.5431758749551, 0, 11.5025128857961, 0, -0.787951034557495, 0, 0.615737947838732 }, { 3.70256097867197, 0, 4.95195016746183, 0, 10.2588077019775, 0, -0.784634598836371, 0, 0.619958573894822 }, { 3.33427085272777, 0, 4.45254484384277, 0, 9.20617939363389, 0, -0.780851250215108, 0, 0.624717001377775 }, { 3.02199902870559, 0, 4.02772335930773, 0, 8.305804451198, 0, -0.77650813338525, 0, 0.630107208488935 }, { 2.7558921009036, 0, 3.66409908076003, 0, 7.52989830565537, 0, -0.77162801637663, 0, 0.636074110500509 }, { 2.52785971811885, 0, 3.35069289288065, 0, 6.85488343644734, 0, -0.766111433604426, 0, 0.642707765184948 }, { 2.33168518994796, 0, 3.07873643214415, 0, 6.26471410332944, 0, -0.759932193184761, 0, 0.65000238840538 }, { 2.16425987386947, 0, 2.84421343176173, 0, 5.7413916516919, 0, -0.75299403107299, 0, 0.658027377259932 }, { 2.01715892991808, 0, 2.63530596500403, 0, 5.27891196802865, 0, -0.745357094066903, 0, 0.666665432933723 }, { 1.89492685130036, 0, 2.45813098981502, 0, 4.86194694234216, 0, -0.736800947219399, 0, 0.676109766229709 }, { 1.78591501144616, 0, 2.29661528559164, 0, 4.48896711257047, 0, -0.727652800744894, 0, 0.685945698123273 }, { 1.69287843767767, 0, 2.15454257612812, 0, 4.15208728884459, 0, -0.7176518900559, 0, 0.696402000130358 }, { 1.6149059015818, 0, 2.03037292066874, 0, 3.84715614555912, 0, -0.707030252652114, 0, 0.707183257765801 }, { 1.54816870507437, 0, 1.91869588954021, 0, 3.5687429255386, 0, -0.695707304981726, 0, 0.718325359799157 }, { 1.48338811715304, 0, 1.80833447200673, 0, 3.32309330857939, 0, -0.683852441969397, 0, 0.729620345820107 }, { 1.43243724001741, 0, 1.71382918414981, 0, 3.09500007780554, 0, -0.671465102796033, 0, 0.741036181027707 }, { 1.38735830691709, 0, 1.6249372254632, 0, 2.88952263267761, 0, -0.658301748058814, 0, 0.752754125946166 }, { 1.34481960995183, 0, 1.53708809211117, 0, 2.70287561977199, 0, -0.644365177029849, 0, 0.764717919390842 }, { 1.30751249548981, 0, 1.45367102492614, 0, 2.5280698492971, 0, -0.628269230883889, 0, 0.777995973564683 }, { 1.27406595763517, 0, 1.37256588350693, 0, 2.36638165416155, 0, -0.610360982631697, 0, 0.792123458049204 }, { 1.2460693813381, 0, 1.29673175697249, 0, 2.2179566475561, 0, -0.591838092408147, 0, 0.806056898782998 }, { 1.21818296082351, 0, 1.22135134395924, 0, 2.08473895568722, 0, -0.572380030315702, 0, 0.819988438147393 }, { 1.19290570989137, 0, 1.14871714184406, 0, 1.96323888944029, 0, -0.55228732956916, 0, 0.833653881617981 }, { 1.17378698377749, 0, 1.08127732023624, 0, 1.85209286484388, 0, -0.531786699419543, 0, 0.846878285432826 }, { 1.15172749640908, 0, 1.01169015116187, 0, 1.75388512325117, 0, -0.51065530086804, 0, 0.859785484959361 }, { 1.13149270802519, 0, 0.945525994687031, 0, 1.66415559544548, 0, -0.489174176973712, 0, 0.872186106121199 }, { 1.1138821962314, 0, 0.882637772356514, 0, 1.58118567552186, 0, -0.467430282669263, 0, 0.884029960636118 }, { 1.09761150984011, 0, 0.821059345657214, 0, 1.50697680449763, 0, -0.445193580198257, 0, 0.895434302467526 }, { 1.08091921345482, 0, 0.761529797726478, 0, 1.43833124423829, 0, -0.422641844044039, 0, 0.90629679068977 }, { 1.0638515533887, 0, 0.701465213561825, 0, 1.37625499612441, 0, -0.399151378540925, 0, 0.916885072359556 }, { 1.04789832964786, 0, 0.643680344486851, 0, 1.31857599659474, 0, -0.374660127942027, 0, 0.927162214242548 }, { 1.0327752004494, 0, 0.587888297050438, 0, 1.26628110722028, 0, -0.350110926423545, 0, 0.936708213546965 }, { 1.01649236822538, 0, 0.533982178809256, 0, 1.21857080603956, 0, -0.325834226407284, 0, 0.945426888450877 }, { 1.00089074899747, 0, 0.481981644268078, 0, 1.17485556557822, 0, -0.301574874033719, 0, 0.953442476600241 }, { 0.986557731961474, 0, 0.433543032922126, 0, 1.13382579030323, 0, -0.277506267973377, 0, 0.96072383780675 }, { 0.969345052448787, 0, 0.38500228087469, 0, 1.09685330384986, 0, -0.253514153658649, 0, 0.967331642656543 }, { 0.953427882191793, 0, 0.338830991436104, 0, 1.06106170979153, 0, -0.228802435323604, 0, 0.973472862489524 }, { 0.938300911538714, 0, 0.295488502258753, 0, 1.02787373046262, 0, -0.204264038417489, 0, 0.978915851593588 }, { 0.920812185494997, 0, 0.253715014806281, 0, 0.996781966307029, 0, -0.180318005830131, 0, 0.983608429818698 }, { 0.884399443523397, 0, 0.200996940979324, 0, 0.941996620406913, 0, -0.156765609491421, 0, 0.987635882104481 }, { 0.888863998354906, 0, 0.180229937296042, 0, 0.941996620406913, 0, -0.133593032447379, 0, 0.991036256743457 }, { 0.86053730761737, 0, 0.0953327792609863, 0, 0.865743580487994, 0, -0.110011308439872, 0, 0.993930331271479 }, { 0.862503049980171, 0, 0.0755073440454642, 0, 0.865743580487994, 0, -0.087112732588603, 0, 0.996198505041523 }, { 0.86398126439321, 0, 0.0561174633978623, 0, 0.865743580487994, 0, -0.0647172771830703, 0, 0.997903634223214 }, { 0.865000827753233, 0, 0.0372349178859404, 0, 0.865743580487994, 0, -0.0429078454004433, 0, 0.999079079763724 }, { 0.865609015604287, 0, 0.0182706352523742, 0, 0.865743580487994, 0, -0.0210040541619496, 0, 0.999779377819327 }, { 0.86580178424937, 0, -0.000144158768096212, 0, 0.865743580487994, 0, 0.000265031161262667, 0, 0.999999929758478 },    // Cos(theta) = 0.5968758
            { 144.119323540569, 0, 204.28290221776, 0, 433.667639205942, 0, -0.817125417605029, 0, 0.576459970749869 }, { 128.505769591781, 0, 182.151517883911, 0, 499.999976251276, 0, -0.817125562251645, 0, 0.576459666177724 }, { 131.186466384388, 0, 185.951429639869, 0, 499.999976251275, 0, -0.817122594939536, 0, 0.576463949271869 }, { 109.516803250909, 0, 155.235499805733, 0, 499.999976251275, 0, -0.81710936425128, 0, 0.576482767876024 }, { 71.5005670317862, 0, 101.348138850883, 0, 215.156580714826, 0, -0.817077085260699, 0, 0.576528419389603 }, { 45.7618067171957, 0, 64.8638896453767, 0, 137.697499136728, 0, -0.817014901870224, 0, 0.576616647677094 }, { 31.7802914704805, 0, 45.0449061893634, 0, 95.6198543771502, 0, -0.816901480397471, 0, 0.576777202406238 }, { 23.3502370508868, 0, 33.0947717985535, 0, 70.2483685549117, 0, -0.81671711426133, 0, 0.577038162683738 }, { 17.878677655882, 0, 25.3380271589267, 0, 53.7797767469684, 0, -0.816433578918193, 0, 0.577439388982818 }, { 14.1290574190682, 0, 20.0219005747667, 0, 42.4876693750904, 0, -0.816026587466176, 0, 0.578014387275348 }, { 11.4472534920932, 0, 16.2191906245974, 0, 34.4094189867755, 0, -0.815460985637852, 0, 0.57881192256664 }, { 9.46483925634414, 0, 13.4076631025529, 0, 28.4354889528446, 0, -0.814640572950116, 0, 0.579966079274536 }, { 7.96750328863995, 0, 11.2834243126363, 0, 23.9115980929549, 0, -0.812997840738955, 0, 0.58226666194866 }, { 6.79529683784012, 0, 9.61979228889337, 0, 20.3744459299652, 0, -0.811486841630404, 0, 0.584370630775516 }, { 5.86428369727296, 0, 8.29775625649959, 0, 17.5613358581562, 0, -0.809861985250261, 0, 0.586620426564588 }, { 5.11767945713495, 0, 7.23671744352902, 0, 15.3000665450939, 0, -0.80759672327875, 0, 0.58973517938344 }, { 4.50642822402075, 0, 6.36714091473976, 0, 13.4458199781807, 0, -0.805077238776611, 0, 0.593169975416368 }, { 4.00194782183378, 0, 5.64848935308824, 0, 11.9094737214518, 0, -0.802075222974456, 0, 0.597223099543961 }, { 3.58024989624192, 0, 5.04645840555083, 0, 10.6199462600969, 0, -0.798709339306403, 0, 0.601717104541738 }, { 3.22508653555971, 0, 4.53815351744704, 0, 9.52985825880055, 0, -0.79475800729993, 0, 0.60692643009541 }, { 2.92405610223098, 0, 4.10569017594672, 0, 8.59709166468939, 0, -0.79024751706058, 0, 0.612787796419694 }, { 2.66743114664156, 0, 3.73527356384965, 0, 7.79179625118465, 0, -0.78524883656902, 0, 0.619180337901881 }, { 2.4481291997473, 0, 3.41649355277948, 0, 7.09368279744991, 0, -0.779446626238653, 0, 0.626468725941433 }, { 2.260885285042, 0, 3.14203168336371, 0, 6.47685464535208, 0, -0.773102212601372, 0, 0.634281447222718 }, { 2.1000555253552, 0, 2.90310397676673, 0, 5.9347817305959, 0, -0.76586787954291, 0, 0.642998022280973 }, { 1.96111641819421, 0, 2.69352854034069, 0, 5.44959301204669, 0, -0.758041986434757, 0, 0.652205823888428 }, { 1.84164433049682, 0, 2.50954940277056, 0, 5.018520872686, 0, -0.749238869592741, 0, 0.662299889925307 }, { 1.73921241223635, 0, 2.34757629528445, 0, 4.62662662959479, 0, -0.739695095991696, 0, 0.672942074776916 }, { 1.65377272732963, 0, 2.20669757632119, 0, 4.27239068980167, 0, -0.729306741190494, 0, 0.684186916483579 }, { 1.58024705068678, 0, 2.08048373854842, 0, 3.95217869964226, 0, -0.718187362447057, 0, 0.695849747868748 }, { 1.51089937476567, 0, 1.95829381693113, 0, 3.66816918394077, 0, -0.706378868079137, 0, 0.707833936648683 }, { 1.45246086638741, 0, 1.84865425945535, 0, 3.4086900006579, 0, -0.693976507363418, 0, 0.719997629766091 }, { 1.40442934089675, 0, 1.7520704360928, 0, 3.17074277466788, 0, -0.680998594033405, 0, 0.732284693165225 }, { 1.36141058333479, 0, 1.65894092115907, 0, 2.95593440130714, 0, -0.667294250556012, 0, 0.744794175103475 }, { 1.32431944974354, 0, 1.57379801751118, 0, 2.75976468613935, 0, -0.653016184242182, 0, 0.75734398760289 }, { 1.29077841479253, 0, 1.48921612927721, 0, 2.58014942128428, 0, -0.637540060928862, 0, 0.770417163802644 }, { 1.25838952379809, 0, 1.40571103671158, 0, 2.41426390516982, 0, -0.619696333797453, 0, 0.784841750783939 }, { 1.2288793029595, 0, 1.324479446557, 0, 2.2607303675371, 0, -0.600708947717608, 0, 0.799467783722651 }, { 1.20250074681481, 0, 1.24598178620731, 0, 2.12236845777738, 0, -0.580839632349278, 0, 0.814018008861508 }, { 1.18069065527481, 0, 1.17249672037547, 0, 1.9957102552031, 0, -0.560183155275302, 0, 0.828368764982632 }, { 1.15876585310448, 0, 1.09941137697401, 0, 1.88159742374732, 0, -0.539138998185973, 0, 0.842216829442843 }, { 1.1421945952689, 0, 1.03269848416691, 0, 1.77708545387738, 0, -0.517471504293325, 0, 0.855700453102341 }, { 1.12234053429306, 0, 0.96374311472004, 0, 1.68395145673256, 0, -0.495394267275154, 0, 0.868668219230431 }, { 1.10424512219223, 0, 0.89725632286891, 0, 1.59927779490034, 0, -0.47304989692795, 0, 0.881035659186656 }, { 1.08840000397102, 0, 0.834720557472582, 0, 1.52082798411302, 0, -0.450427046521468, 0, 0.892813188733944 }, { 1.07299638725449, 0, 0.773819683457949, 0, 1.45207853735019, 0, -0.427485263779742, 0, 0.904022286500532 }, { 1.05755282388285, 0, 0.713542379619596, 0, 1.387737245999, 0, -0.40423081782023, 0, 0.914657029692326 }, { 1.04394698436418, 0, 0.656233653491242, 0, 1.32837222117495, 0, -0.380107326568611, 0, 0.924942406286828 }, { 1.02859884509827, 0, 0.598734302460293, 0, 1.27486499298559, 0, -0.354956286650615, 0, 0.934882925049441 }, { 1.01259441477222, 0, 0.542762548370768, 0, 1.22561359952531, 0, -0.330009479368943, 0, 0.943977648494652 }, { 0.996975341245545, 0, 0.49055391166518, 0, 1.17997126802188, 0, -0.305276403335905, 0, 0.952263801951532 }, { 0.983527170975295, 0, 0.440676792719637, 0, 1.13856495924599, 0, -0.28069228726195, 0, 0.959797826679503 }, { 0.966567207693064, 0, 0.391276034823349, 0, 1.09987929434042, 0, -0.256347771580172, 0, 0.966584608233357 }, { 0.951652025764172, 0, 0.344949917150971, 0, 1.0639666279594, 0, -0.232155631880148, 0, 0.972678644282333 }, { 0.936725223330015, 0, 0.300801393341547, 0, 1.03053693839447, 0, -0.207357973111548, 0, 0.97826509716771 }, { 0.918245090662709, 0, 0.258012076508121, 0, 0.997715296429719, 0, -0.182695051137916, 0, 0.983169642556455 }, { 0.90146158753679, 0, 0.218437753056497, 0, 0.967327773263471, 0, -0.158604446892767, 0, 0.987342169440769 }, { 0.885914884646153, 0, 0.182753133618744, 0, 0.941117926817707, 0, -0.135000605451264, 0, 0.990845531077642 }, { 0.860360083159626, 0, 0.0969193550184416, 0, 0.865743580487994, 0, -0.111843821565242, 0, 0.993725817802766 }, { 0.862394008799714, 0, 0.0767425350666735, 0, 0.865743580487994, 0, -0.088539389036751, 0, 0.996072703182825 }, { 0.863936407350028, 0, 0.0568035035170446, 0, 0.865743580487994, 0, -0.0655096577422265, 0, 0.997851902467238 }, { 0.864990709114699, 0, 0.0374682715248123, 0, 0.865743580487994, 0, -0.0431773697044158, 0, 0.999067419304815 }, { 0.865598583419169, 0, 0.0187581056785181, 0, 0.865743580487994, 0, -0.0215670830637495, 0, 0.999767384132927 }, { 0.865801824228073, 0, 2.57724452203252E-05, 0, 0.865743580487994, 0, 6.87608332032537E-05, 0, 0.999999995271947 },    // Cos(theta) = 0.5764676
            { 136.74341409921, 0, 204.618568232853, 0, 455.590134282123, 0, -0.831478976833936, 0, 0.555556114125975 }, { 127.615227792819, 0, 190.99694242099, 0, 499.999976251275, 0, -0.831479749361527, 0, 0.555555019904224 }, { 129.647602077861, 0, 194.038382409779, 0, 499.999976251275, 0, -0.83147642399829, 0, 0.555560074869465 }, { 107.967537739685, 0, 161.590670979463, 0, 499.999976251275, 0, -0.831463964584828, 0, 0.55557859049996 }, { 68.9079033521661, 0, 103.130720474848, 0, 223.254023610664, 0, -0.831433577622907, 0, 0.555624076459917 }, { 44.1013209821058, 0, 66.0029179678794, 0, 142.880645429427, 0, -0.831368113048161, 0, 0.555722133684508 }, { 30.6275447552194, 0, 45.8364256441188, 0, 99.217841712213, 0, -0.831249640485013, 0, 0.555899352659467 }, { 22.5039487144683, 0, 33.6771286475777, 0, 72.8909787334792, 0, -0.83105412606823, 0, 0.556191586772494 }, { 17.2311659472416, 0, 25.7843726442454, 0, 55.8031769389377, 0, -0.830756016261372, 0, 0.556636795752 }, { 13.6171734064906, 0, 20.3740925212649, 0, 44.0866141795907, 0, -0.830326487324524, 0, 0.557277295348686 }, { 11.0326954463836, 0, 16.5044827119905, 0, 35.7049203984073, 0, -0.829729030801832, 0, 0.558166351466227 }, { 9.12717384760367, 0, 13.6507546862844, 0, 29.5140995491608, 0, -0.828680581079958, 0, 0.559721871944487 }, { 7.68008074242702, 0, 11.4828921767839, 0, 24.8113569018197, 0, -0.827176879295788, 0, 0.561941590247199 }, { 6.54983112408222, 0, 9.7889843555745, 0, 21.1388690391438, 0, -0.825675307712064, 0, 0.564145623959603 }, { 5.65383497179096, 0, 8.44527390405396, 0, 18.2208945286983, 0, -0.823947587837795, 0, 0.566665992851601 }, { 4.93509730636857, 0, 7.36653413441034, 0, 15.876228473437, 0, -0.821546410499374, 0, 0.570141554868408 }, { 4.3455806180137, 0, 6.48064210054346, 0, 13.9498179437683, 0, -0.819002929603364, 0, 0.5737894021773 }, { 3.86081597278855, 0, 5.7510074618946, 0, 12.3574681435235, 0, -0.81581743595603, 0, 0.578309550329031 }, { 3.45435988010564, 0, 5.13791618841667, 0, 11.018880311573, 0, -0.812327676294434, 0, 0.583201284382892 }, { 3.11304955048316, 0, 4.62148089139568, 0, 9.88509691614519, 0, -0.808262185153685, 0, 0.588822836966872 }, { 2.82450265142616, 0, 4.18315419295624, 0, 8.91611003034347, 0, -0.803582365849133, 0, 0.595193561609078 }, { 2.57728133514538, 0, 3.80549429965678, 0, 8.08038502351744, 0, -0.798381745541117, 0, 0.602151632102184 }, { 2.36790576393297, 0, 3.4831647663498, 0, 7.35261010334611, 0, -0.792370738268365, 0, 0.610039785603948 }, { 2.18771857505494, 0, 3.20305628017274, 0, 6.7111428508521, 0, -0.785832334089224, 0, 0.618439652711998 }, { 2.034362715024, 0, 2.96141598518794, 0, 6.14531479037371, 0, -0.778325293007237, 0, 0.627861336329864 }, { 1.90549789344847, 0, 2.75380570375833, 0, 5.63678628852328, 0, -0.770147792817573, 0, 0.63786547744305 }, { 1.7897020488211, 0, 2.56394052866882, 0, 5.18614859223025, 0, -0.761108955552363, 0, 0.648624130951553 }, { 1.69532013793479, 0, 2.40310206357179, 0, 4.7741604175773, 0, -0.75123017545611, 0, 0.660040314742062 }, { 1.60918327532484, 0, 2.25257229821758, 0, 4.40843257421712, 0, -0.74048678282098, 0, 0.672070904266917 }, { 1.53897391945451, 0, 2.12245227593767, 0, 4.07324450173071, 0, -0.728930601384584, 0, 0.684587606156414 }, { 1.47606427140162, 0, 2.00089106143648, 0, 3.77174108535528, 0, -0.716614379301806, 0, 0.697469605451882 }, { 1.42376453979409, 0, 1.89257753647567, 0, 3.49601774088145, 0, -0.703696597457949, 0, 0.710500526580213 }, { 1.37863591440375, 0, 1.79223698290228, 0, 3.24747723488594, 0, -0.690081342897571, 0, 0.723731800022319 }, { 1.33869009145226, 0, 1.69746999485327, 0, 3.0246806380537, 0, -0.675829185094753, 0, 0.73705829603304 }, { 1.3008257730551, 0, 1.60509327139191, 0, 2.82044806922337, 0, -0.661051104959667, 0, 0.750340890799614 }, { 1.26850618794326, 0, 1.51901056927866, 0, 2.63582702198069, 0, -0.645408302386263, 0, 0.76383778980881 }, { 1.24280919384733, 0, 1.4391139424541, 0, 2.46317704347016, 0, -0.628454891956835, 0, 0.77784599913957 }, { 1.21542853365034, 0, 1.35516111241613, 0, 2.30441609368751, 0, -0.609175098654843, 0, 0.793035762067154 }, { 1.19001342499557, 0, 1.27291052481665, 0, 2.1610837053133, 0, -0.588912268778032, 0, 0.80819698955545 }, { 1.16675892686513, 0, 1.19513475831069, 0, 2.03011115301563, 0, -0.567788647457078, 0, 0.823174424880881 }, { 1.14580515538931, 0, 1.11953745289868, 0, 1.91182839582272, 0, -0.54618392628843, 0, 0.83766532447397 }, { 1.12801146405007, 0, 1.04846643065627, 0, 1.80218822823342, 0, -0.524019383607044, 0, 0.851706363495753 }, { 1.11369614646118, 0, 0.981586683382573, 0, 1.70538245610387, 0, -0.50138481878103, 0, 0.865224359701491 }, { 1.09602927457249, 0, 0.913276241597648, 0, 1.61751120972216, 0, -0.478428547306401, 0, 0.878126455949348 }, { 1.08054069440949, 0, 0.847710599259941, 0, 1.5378061467955, 0, -0.455291976652137, 0, 0.890342215049864 }, { 1.06678946259696, 0, 0.786484541029479, 0, 1.46431680718501, 0, -0.431868247180388, 0, 0.901936693260897 }, { 1.05174073635165, 0, 0.725114828587995, 0, 1.39870042327966, 0, -0.408281424949852, 0, 0.912856122668991 }, { 1.03699973579983, 0, 0.665866842154855, 0, 1.33853453913933, 0, -0.384439924443174, 0, 0.92315002462691 }, { 1.02441900541559, 0, 0.609300267930987, 0, 1.28278107500485, 0, -0.359851914057795, 0, 0.933009413238654 }, { 1.00842364037475, 0, 0.552368266397826, 0, 1.23231360897799, 0, -0.334245431368023, 0, 0.94248609801013 }, { 0.993017968240879, 0, 0.497692947687286, 0, 1.18580121849099, 0, -0.308915201619477, 0, 0.951089540442401 }, { 0.979645862231122, 0, 0.447088093827214, 0, 1.14293921351078, 0, -0.283799707608138, 0, 0.958883582594844 }, { 0.963952903304821, 0, 0.397252703587043, 0, 1.103217306008, 0, -0.258925145267005, 0, 0.965897401311829 }, { 0.948636658859508, 0, 0.350305048428904, 0, 1.06701103622632, 0, -0.234391139915068, 0, 0.972142344673254 }, { 0.933559074272304, 0, 0.305221178414237, 0, 1.03221234245571, 0, -0.210096816142915, 0, 0.977680609787404 }, { 0.917242954591268, 0, 0.262652041909814, 0, 0.999610976257444, 0, -0.185437436739761, 0, 0.982656020392595 }, { 0.899503440310904, 0, 0.221640090556841, 0, 0.967742603792037, 0, -0.160697784518909, 0, 0.987003694580504 }, { 0.88387394923345, 0, 0.185210407444101, 0, 0.940674638369407, 0, -0.136455381608847, 0, 0.990646253424558 }, { 0.860256209864435, 0, 0.0978367995494451, 0, 0.865743580487994, 0, -0.112903480638169, 0, 0.993605948685446 }, { 0.862302837731413, 0, 0.0777600538200915, 0, 0.865743580487994, 0, -0.0897146322622209, 0, 0.995967516509624 }, { 0.863859831384727, 0, 0.0579569290958858, 0, 0.865743580487994, 0, -0.0668418715151737, 0, 0.997763588585367 }, { 0.864967513050308, 0, 0.0379991284289392, 0, 0.865743580487994, 0, -0.0437905113849552, 0, 0.999040688291654 }, { 0.865600854026225, 0, 0.0186539920693569, 0, 0.865743580487994, 0, -0.0214468317208112, 0, 0.999769994833058 }, { 0.865801823559902, 0, 1.32683045534335E-05, 0, 0.865743580487994, 0, 8.32030994994849E-05, 0, 0.999999993077244 },    // Cos(theta) = 0.5555555
            { 133.534073396609, 0, 211.347181363994, 0, 468.041218302351, 0, -0.845396510883806, 0, 0.534139308267279 }, { 126.654832675525, 0, 200.459647925908, 0, 499.999976251275, 0, -0.845395959368138, 0, 0.534140230472579 }, { 127.924135314665, 0, 202.468412095211, 0, 499.999976251276, 0, -0.845392794064508, 0, 0.534145233309883 }, { 106.239056354065, 0, 168.146798908207, 0, 499.999976251275, 0, -0.845381068600874, 0, 0.53416374321666 }, { 61.7182301725376, 0, 97.8758731547781, 0, 237.845697802347, 0, -0.845347921915466, 0, 0.534216191198647 }, { 42.4016192396568, 0, 67.1079887884854, 0, 148.607616098398, 0, -0.845279293679221, 0, 0.534324813824167 }, { 29.4474818013825, 0, 46.6041909792416, 0, 103.197007906487, 0, -0.845154718041615, 0, 0.534521768282371 }, { 21.6365076794172, 0, 34.2404530520449, 0, 75.8136826220533, 0, -0.844949722234934, 0, 0.534845807099705 }, { 16.567509278587, 0, 26.2162621358941, 0, 58.0398418120045, 0, -0.844636664857397, 0, 0.535340040127068 }, { 13.0930531828608, 0, 20.7156401215859, 0, 45.8531950687551, 0, -0.844184211771094, 0, 0.536053175572646 }, { 10.6087630754982, 0, 16.7819534146524, 0, 37.1358378215338, 0, -0.843551448733395, 0, 0.537048296679095 }, { 8.78006909281701, 0, 13.8855668532256, 0, 30.7080294383028, 0, -0.842298910197393, 0, 0.539010694140398 }, { 7.38665251460396, 0, 11.6779184155516, 0, 25.8083081149605, 0, -0.840885513590767, 0, 0.54121303147035 }, { 6.29955253737346, 0, 9.95462647870901, 0, 21.9844474435998, 0, -0.839393691797016, 0, 0.543523918325902 }, { 5.43914884181275, 0, 8.5898379258011, 0, 18.9528226385896, 0, -0.837499834482982, 0, 0.546437684238143 }, { 4.74815586729608, 0, 7.49266236331278, 0, 16.5112981596583, 0, -0.835074287848539, 0, 0.550137111290506 }, { 4.18196265048887, 0, 6.59243024248805, 0, 14.5079476911274, 0, -0.832427484725564, 0, 0.554134039661218 }, { 3.71585628354658, 0, 5.8500422149313, 0, 12.8497475731072, 0, -0.829193517583604, 0, 0.558961619834691 }, { 3.32650325902218, 0, 5.22837102355641, 0, 11.4600300000814, 0, -0.825459505268094, 0, 0.564461367524346 }, { 2.99857553759672, 0, 4.70299908957433, 0, 10.2787197989507, 0, -0.821277022440907, 0, 0.570529497358255 }, { 2.72235244205239, 0, 4.25851411293621, 0, 9.26979875405004, 0, -0.816411439206008, 0, 0.577470662757389 }, { 2.48584121052837, 0, 3.87548068032807, 0, 8.39711503248996, 0, -0.811062737474637, 0, 0.584959283600185 }, { 2.28765840227594, 0, 3.55161621629556, 0, 7.63555723615387, 0, -0.804847116467468, 0, 0.593482192812783 }, { 2.11393161277343, 0, 3.2645856333159, 0, 6.96690380674857, 0, -0.798050825708048, 0, 0.602590147365776 }, { 1.97025227611125, 0, 3.02310274005798, 0, 6.3727310242552, 0, -0.790385996908984, 0, 0.612609129246777 }, { 1.84247403926802, 0, 2.80461226590895, 0, 5.84542659246026, 0, -0.781879151904284, 0, 0.623429985967928 }, { 1.73914935027626, 0, 2.62144863000637, 0, 5.36581933485458, 0, -0.772560020708913, 0, 0.634941822387529 }, { 1.64589261831402, 0, 2.45182314347725, 0, 4.93843521745468, 0, -0.762271473290219, 0, 0.647257455240752 }, { 1.56685282558952, 0, 2.30181995346644, 0, 4.55076902955275, 0, -0.75122300559281, 0, 0.660048517743307 }, { 1.50143948071125, 0, 2.16986037528214, 0, 4.19765242333782, 0, -0.7391993364408, 0, 0.67348676034496 }, { 1.44538168343886, 0, 2.04952981678758, 0, 3.8774133489103, 0, -0.72641323130954, 0, 0.687258109910176 }, { 1.39245958959308, 0, 1.93273643355343, 0, 3.59367926804515, 0, -0.712937418004033, 0, 0.701227668250242 }, { 1.34813570544568, 0, 1.82668743466128, 0, 3.33482624413272, 0, -0.69872778614321, 0, 0.715387703002128 }, { 1.31091286079195, 0, 1.72931045812301, 0, 3.09905992902816, 0, -0.683909350781837, 0, 0.729567048712762 }, { 1.27695652345351, 0, 1.63569402500708, 0, 2.88707385821358, 0, -0.668551407948223, 0, 0.743665892386166 }, { 1.24815302139671, 0, 1.54892710208757, 0, 2.69067162485007, 0, -0.652439709991539, 0, 0.757840629342537 }, { 1.22135002799552, 0, 1.46367865338797, 0, 2.51472249950841, 0, -0.635507181990947, 0, 0.772094911525077 }, { 1.19867881734852, 0, 1.38221553986866, 0, 2.35216883304275, 0, -0.617180258056339, 0, 0.786821820609274 }, { 1.17732408501559, 0, 1.30102827148503, 0, 2.20091241758255, 0, -0.596575211494954, 0, 0.802557185104675 }, { 1.15546946949468, 0, 1.21990975921451, 0, 2.06424569745507, 0, -0.575060477686242, 0, 0.818110955076115 }, { 1.13498278257903, 0, 1.14177240050039, 0, 1.94098133927759, 0, -0.55290278748031, 0, 0.833245798486815 }, { 1.11809772782138, 0, 1.0672698153079, 0, 1.828650489795, 0, -0.530276502216628, 0, 0.847824792109394 }, { 1.10021986298825, 0, 0.994874684019653, 0, 1.72856091001822, 0, -0.507175024046063, 0, 0.861843143542741 }, { 1.08777938718842, 0, 0.927971595097709, 0, 1.63562926450484, 0, -0.483592315124897, 0, 0.87529334458683 }, { 1.07128148566143, 0, 0.859482697503177, 0, 1.55371040731893, 0, -0.459942702659318, 0, 0.887948638241881 }, { 1.05740320901642, 0, 0.79604891406017, 0, 1.47754917655788, 0, -0.435991287754627, 0, 0.899950924527201 }, { 1.04459451730196, 0, 0.734569041418724, 0, 1.4100021474364, 0, -0.411984062275893, 0, 0.91119105960009 }, { 1.03080222437153, 0, 0.674438088341274, 0, 1.34835623821283, 0, -0.387798370595292, 0, 0.921744231365595 }, { 1.01807328328342, 0, 0.617377039527141, 0, 1.29058821679682, 0, -0.363516337885219, 0, 0.931587833649702 }, { 1.00411568669635, 0, 0.561351104526553, 0, 1.2394803183385, 0, -0.338616673732799, 0, 0.940924418708168 }, { 0.989881111925059, 0, 0.505870810305119, 0, 1.19128788490544, 0, -0.312691835537409, 0, 0.949854575314306 }, { 0.975126214704931, 0, 0.452861041889994, 0, 1.14682241741329, 0, -0.286983002333869, 0, 0.95793565476582 }, { 0.960519202990362, 0, 0.40307712654066, 0, 1.10686158892042, 0, -0.261610055374606, 0, 0.965173641212053 }, { 0.946241695336816, 0, 0.355090463189798, 0, 1.06928752836998, 0, -0.236508692953443, 0, 0.971629363440918 }, { 0.930848913600786, 0, 0.30988020082388, 0, 1.03410376042692, 0, -0.211869482088123, 0, 0.977297979528186 }, { 0.914748004129774, 0, 0.266222097599559, 0, 1.00088755537982, 0, -0.187563361825282, 0, 0.982252471102221 }, { 0.897836803470719, 0, 0.225475425607032, 0, 0.968867961031446, 0, -0.163110241342317, 0, 0.986607849890746 }, { 0.86463047845043, 0, 0.174861899332624, 0, 0.916793064795911, 0, -0.138309510132845, 0, 0.99038906030087 }, { 0.868659259825069, 0, 0.153602147989781, 0, 0.916793064795911, 0, -0.113976223833355, 0, 0.993483471382727 }, { 0.862236817129521, 0, 0.078488465404969, 0, 0.865743580487994, 0, -0.0905559542181116, 0, 0.995891345692443 }, { 0.863824517737899, 0, 0.0584804104436865, 0, 0.865743580487994, 0, -0.0674464958166288, 0, 0.997722860940756 }, { 0.864929775885495, 0, 0.0388499809055207, 0, 0.865743580487994, 0, -0.0447732491944859, 0, 0.998997198741622 }, { 0.865591563207624, 0, 0.019078808805289, 0, 0.865743580487994, 0, -0.0219374955611905, 0, 0.999759312293544 }, { 0.865801793353744, 0, -0.000121712587309621, 0, 0.865743580487994, 0, 0.000239105852387731, 0, 0.999999942828388 },    // Cos(theta) = 0.5341395
            { 128.043088604041, 0, 214.692805016917, 0, 488.104642372103, 0, -0.858853975390912, 0, 0.512220620428806 }, { 128.056935383079, 0, 214.716336468728, 0, 488.064160085059, 0, -0.858854273197377, 0, 0.512219917608512 }, { 126.075751288754, 0, 211.394801422338, 0, 499.999976251275, 0, -0.858851135453529, 0, 0.512225270674747 }, { 104.310038127319, 0, 174.899241162744, 0, 499.999976251275, 0, -0.858839030584113, 0, 0.512245628351546 }, { 63.5317382630482, 0, 106.524039490436, 0, 242.140527994727, 0, -0.858804374003214, 0, 0.512303632046374 }, { 40.6625830217312, 0, 68.177748971392, 0, 154.965282038811, 0, -0.858731748034791, 0, 0.51242532830859 }, { 28.2385053490704, 0, 47.3448554503338, 0, 107.611599807964, 0, -0.858601140251099, 0, 0.512644259357116 }, { 20.74839218364, 0, 34.7846497053484, 0, 79.0578182950866, 0, -0.858385503432368, 0, 0.513005327980885 }, { 15.8883313199447, 0, 26.6341392195572, 0, 60.5223372314828, 0, -0.858057988207808, 0, 0.513552756690682 }, { 12.5568779356022, 0, 21.0464401591482, 0, 47.814169483559, 0, -0.857582459471995, 0, 0.514346581456018 }, { 10.1743828627515, 0, 17.0496435090732, 0, 38.7244109934652, 0, -0.85691027471514, 0, 0.515465513528448 }, { 8.42298485719526, 0, 14.1106776425573, 0, 32.0256553577928, 0, -0.855559002096582, 0, 0.517705327765056 }, { 7.08478109074982, 0, 11.8642461489744, 0, 26.9105917023717, 0, -0.854204113708445, 0, 0.519937810516559 }, { 6.04314808423162, 0, 10.1147009471652, 0, 22.9243158024294, 0, -0.852624333071714, 0, 0.522524438465924 }, { 5.22045877356153, 0, 8.73180304964688, 0, 19.7682845464516, 0, -0.850538073094481, 0, 0.525913475784128 }, { 4.55671052864965, 0, 7.61482200391583, 0, 17.2177205190895, 0, -0.84815426114054, 0, 0.529749342811026 }, { 4.0150446498225, 0, 6.70204210172328, 0, 15.1293208252073, 0, -0.845315402616696, 0, 0.534267608036406 }, { 3.56775841146713, 0, 5.94663271934583, 0, 13.3974395244465, 0, -0.842048676970308, 0, 0.539401513504903 }, { 3.19501127488468, 0, 5.31550331049303, 0, 11.9469584884208, 0, -0.838197039822807, 0, 0.545367432308435 }, { 2.88269696744091, 0, 4.78444860864485, 0, 10.7129168868502, 0, -0.833888401022492, 0, 0.551933142261997 }, { 2.61719531912181, 0, 4.33084627578522, 0, 9.66140402379162, 0, -0.828829109582788, 0, 0.559501966782138 }, { 2.393775459755, 0, 3.94628545044189, 0, 8.74702039918008, 0, -0.823259982900111, 0, 0.567664485855359 }, { 2.20178006036569, 0, 3.61265732395718, 0, 7.95104459684726, 0, -0.816894269214327, 0, 0.576787353405936 }, { 2.04147168775292, 0, 3.32983911002218, 0, 7.24715420892299, 0, -0.809783956773813, 0, 0.586728127806418 }, { 1.90337775731528, 0, 3.08188553082969, 0, 6.62479671386475, 0, -0.801859074175542, 0, 0.597513193922613 }, { 1.78660311460106, 0, 2.86681041502654, 0, 6.06485373679674, 0, -0.793110409061699, 0, 0.609077808807163 }, { 1.68430409298631, 0, 2.67341515607286, 0, 5.56609660647773, 0, -0.783481566458303, 0, 0.621414994097185 }, { 1.59851991956385, 0, 2.50400536283158, 0, 5.11419587428166, 0, -0.772812400169029, 0, 0.63463463099444 }, { 1.52725776819549, 0, 2.35542188951792, 0, 4.700585881793, 0, -0.761434576842351, 0, 0.64824172615218 }, { 1.46299338907018, 0, 2.21596191777872, 0, 4.33453165401926, 0, -0.74897489558325, 0, 0.662598350507209 }, { 1.40807366410745, 0, 2.08898355017113, 0, 3.99900915390625, 0, -0.735742682779478, 0, 0.677261113887897 }, { 1.35914915193842, 0, 1.96948577058706, 0, 3.69904653067328, 0, -0.721744254211468, 0, 0.69215984579509 }, { 1.31916200042292, 0, 1.86286403999339, 0, 3.42325638359591, 0, -0.706961328067955, 0, 0.707252139102958 }, { 1.28396408998401, 0, 1.76120609913616, 0, 3.17669180853018, 0, -0.691504852656159, 0, 0.722371771683401 }, { 1.25318235548969, 0, 1.66547662783953, 0, 2.95429532295641, 0, -0.675566857341936, 0, 0.737298797815574 }, { 1.22556242181561, 0, 1.5742048243821, 0, 2.75022605677794, 0, -0.658910434609526, 0, 0.752221384146509 }, { 1.20086478834583, 0, 1.48713146333171, 0, 2.56661202652389, 0, -0.641607470574453, 0, 0.767033097101249 }, { 1.17836454297696, 0, 1.40255390963343, 0, 2.40001826480666, 0, -0.623370839543637, 0, 0.781926350586247 }, { 1.16077788827493, 0, 1.32361249347503, 0, 2.2447277769713, 0, -0.603825189666783, 0, 0.797116806268765 }, { 1.14134043762338, 0, 1.24091513714674, 0, 2.10099539127069, 0, -0.581963767037698, 0, 0.813214704617018 }, { 1.12409801696851, 0, 1.16227222804054, 0, 1.97331180296897, 0, -0.559396593138675, 0, 0.828900111838365 }, { 1.1061289430202, 0, 1.08363929810239, 0, 1.85635527234876, 0, -0.53621873570043, 0, 0.844079035218675 }, { 1.0912038503307, 0, 1.01125377556693, 0, 1.7511344028102, 0, -0.512645264755571, 0, 0.858600531005912 }, { 1.07965184460738, 0, 0.942297664762464, 0, 1.65557594050219, 0, -0.488612003357119, 0, 0.872501154086837 }, { 1.0635569783732, 0, 0.872024047762664, 0, 1.56994360986191, 0, -0.464285707459273, 0, 0.885685457973743 }, { 1.05070723365386, 0, 0.807069128267494, 0, 1.49170647244511, 0, -0.439926990032248, 0, 0.898033515033713 }, { 1.03740539545409, 0, 0.743094568377539, 0, 1.42156420344863, 0, -0.415366772552747, 0, 0.909654029400671 }, { 1.02384476835221, 0, 0.68217946436226, 0, 1.35825431079352, 0, -0.390768942868699, 0, 0.920488839446384 }, { 1.01149157295799, 0, 0.623601883302345, 0, 1.29941292391518, 0, -0.36611012105042, 0, 0.930571584456113 }, { 0.998946024824728, 0, 0.567693782562527, 0, 1.24574257851283, 0, -0.341489302719848, 0, 0.939885642017593 }, { 0.984938096380518, 0, 0.512622985722864, 0, 1.19708859627786, 0, -0.316418496201669, 0, 0.948619745409083 }, { 0.971242181175591, 0, 0.459217711959315, 0, 1.15164966690544, 0, -0.290349561273589, 0, 0.956920683692654 }, { 0.95743414362444, 0, 0.408342444443756, 0, 1.1099810683438, 0, -0.264385693299559, 0, 0.964417015082641 }, { 0.941103578577826, 0, 0.35886532956233, 0, 1.07055393539993, 0, -0.238776450706198, 0, 0.971074542170273 }, { 0.927131800350633, 0, 0.313104808498155, 0, 1.03500606209984, 0, -0.213561820824931, 0, 0.976929558308339 }, { 0.911665283702085, 0, 0.26913354547074, 0, 1.00126550897331, 0, -0.188836119167234, 0, 0.98200859256274 }, { 0.894826694442799, 0, 0.228064480490303, 0, 0.969178386161059, 0, -0.164467189292801, 0, 0.986382565374176 }, { 0.879487164178985, 0, 0.189962658543044, 0, 0.940117525782772, 0, -0.140274091549594, 0, 0.990112760397052 }, { 0.864416044329232, 0, 0.155580178102448, 0, 0.91548607907744, 0, -0.115761762251855, 0, 0.993277063572631 }, { 0.862171104994756, 0, 0.0792070376704811, 0, 0.865743580487994, 0, -0.0913859117376991, 0, 0.995815530034685 }, { 0.863801338854259, 0, 0.0588223599544801, 0, 0.865743580487994, 0, -0.067841449699115, 0, 0.997696128273739 }, { 0.864925411623178, 0, 0.0389456521193838, 0, 0.865743580487994, 0, -0.044883749819981, 0, 0.998992168911618 }, { 0.865582177370137, 0, 0.0195010525109377, 0, 0.865743580487994, 0, -0.022425187565718, 0, 0.999748519714531 }, { 0.865801803316267, 0, 0.000178264159907551, 0, 0.865743580487994, 0, -0.00010736690332046, 0, 0.999999988472348 },    // Cos(theta) = 0.5122197
            { 124.529199179104, 0, 221.661681085403, 0, 499.999976251275, 0, -0.871837520401486, 0, 0.489795157972401 }, { 124.473945248694, 0, 221.563208413648, 0, 499.999976251276, 0, -0.87183666751953, 0, 0.489796794120427 }, { 124.072959164849, 0, 220.849685695303, 0, 499.999976251275, 0, -0.871833404024865, 0, 0.489802550577925 }, { 102.251544262079, 0, 182.007005632293, 0, 499.999976251276, 0, -0.871820643630116, 0, 0.48982525713863 }, { 60.7497490758834, 0, 108.132815994837, 0, 253.229867393488, 0, -0.871784653912056, 0, 0.489889182193179 }, { 38.8826526637611, 0, 69.2083601664047, 0, 162.059286816832, 0, -0.871709180538457, 0, 0.490023590246134 }, { 27.003524703684, 0, 48.0622505924948, 0, 112.535987079128, 0, -0.871571708881084, 0, 0.490268172229778 }, { 19.8415171090811, 0, 35.3124136351248, 0, 82.6755519757153, 0, -0.871347085343999, 0, 0.490667173112368 }, { 15.1942589947141, 0, 27.03853950695, 0, 63.2926462488136, 0, -0.871002313791411, 0, 0.491278978505413 }, { 12.0082109659979, 0, 21.3653873726448, 0, 50.0018596621902, 0, -0.870505036076182, 0, 0.49215957977209 }, { 9.73104247626197, 0, 17.3097696344207, 0, 40.4992814372863, 0, -0.869770896554235, 0, 0.493455774462519 }, { 8.05730135471843, 0, 14.3278494552892, 0, 33.4951125464392, 0, -0.868366711789177, 0, 0.495922621350965 }, { 6.77715666836304, 0, 12.0461448221683, 0, 28.1415094304374, 0, -0.867004032727007, 0, 0.498301116211964 }, { 5.78063810953549, 0, 10.2688737445369, 0, 23.9717091237942, 0, -0.865426293243648, 0, 0.501036315817924 }, { 4.99514850276777, 0, 8.86671594299535, 0, 20.6727067955477, 0, -0.863223958279674, 0, 0.504821209337697 }, { 4.36024136620818, 0, 7.73199145500818, 0, 18.004179116733, 0, -0.860794234171701, 0, 0.50895318221898 }, { 3.84382705437559, 0, 6.80742967826944, 0, 15.8216083747765, 0, -0.857806966269762, 0, 0.513971975794271 }, { 3.41660029356604, 0, 6.04095224333762, 0, 14.0106457334415, 0, -0.854408263418381, 0, 0.519602202432689 }, { 3.06153779829706, 0, 5.40175595469256, 0, 12.4906834741536, 0, -0.850413108441797, 0, 0.526115418437732 }, { 2.76218289257563, 0, 4.86057193841327, 0, 11.2003004785288, 0, -0.845959183182756, 0, 0.533247782292478 }, { 2.51089578468776, 0, 4.40334884519905, 0, 10.0957014617163, 0, -0.840757396030336, 0, 0.541412072257977 }, { 2.29885107305447, 0, 4.01438153702518, 0, 9.13488012089638, 0, -0.834960476384301, 0, 0.55030986754637 }, { 2.11886203946579, 0, 3.68034316463716, 0, 8.29770906781297, 0, -0.828403991422022, 0, 0.5601310608812 }, { 1.96568842123206, 0, 3.39136135036742, 0, 7.55740738249267, 0, -0.8210974408239, 0, 0.570787989466316 }, { 1.83673055918811, 0, 3.14301065531485, 0, 6.89961886198715, 0, -0.812855379284701, 0, 0.582465643503589 }, { 1.72453091737806, 0, 2.9207361161619, 0, 6.31282471992249, 0, -0.803809379936406, 0, 0.5948869846263 }, { 1.63096920760719, 0, 2.72864358332884, 0, 5.7799369067053, 0, -0.793857105779096, 0, 0.608104354428256 }, { 1.55434437233899, 0, 2.56233114125874, 0, 5.30082740956001, 0, -0.782860964570072, 0, 0.622196650687397 }, { 1.48306020420373, 0, 2.4028428865784, 0, 4.86858556139818, 0, -0.771109262078676, 0, 0.636702818309582 }, { 1.42281737363356, 0, 2.26010953756292, 0, 4.48062790950455, 0, -0.758271234890702, 0, 0.651939228360162 }, { 1.37373570575154, 0, 2.13270878219821, 0, 4.1253237529638, 0, -0.744503478741481, 0, 0.667618501923591 }, { 1.33117436781185, 0, 2.01397777390758, 0, 3.80563659634841, 0, -0.730050016681132, 0, 0.68339370680595 }, { 1.29340581241868, 0, 1.90251503709502, 0, 3.51735530018178, 0, -0.714708061823033, 0, 0.699422926831745 }, { 1.26087342396892, 0, 1.79779765643973, 0, 3.25716391453096, 0, -0.698622686116884, 0, 0.715490263725556 }, { 1.23197200724486, 0, 1.69846258021389, 0, 3.02182448637789, 0, -0.682028080464998, 0, 0.731326011101954 }, { 1.20630447872535, 0, 1.6037934952963, 0, 2.81057061289821, 0, -0.664845964707018, 0, 0.746980445214222 }, { 1.18353879676452, 0, 1.51393996987083, 0, 2.61896200589181, 0, -0.646980299717975, 0, 0.762506669742568 }, { 1.16268210073648, 0, 1.42638859728929, 0, 2.44547005312619, 0, -0.628453625800202, 0, 0.777847068295768 }, { 1.1431757579314, 0, 1.34184442417595, 0, 2.28681848009782, 0, -0.609177030130765, 0, 0.79303430336016 }, { 1.128156834484, 0, 1.2623379136477, 0, 2.14187459187459, 0, -0.58844530595774, 0, 0.808537088459674 }, { 1.11104890510789, 0, 1.18016667712545, 0, 2.00688901353467, 0, -0.565533908347952, 0, 0.824725078415009 }, { 1.09678195281968, 0, 1.1022353135501, 0, 1.88562002835062, 0, -0.541871289631485, 0, 0.8404614620623 }, { 1.0805271533163, 0, 1.02534943136929, 0, 1.77552208453735, 0, -0.517855117609929, 0, 0.855468348998936 }, { 1.0673840158235, 0, 0.9531117049167, 0, 1.67650048813845, 0, -0.493428594562922, 0, 0.869786281304288 }, { 1.0561536528962, 0, 0.884893286534898, 0, 1.58754631420224, 0, -0.468567791927939, 0, 0.883427619374792 }, { 1.0416114659327, 0, 0.8159533557379, 0, 1.5071365626178, 0, -0.44360629802789, 0, 0.896221778728006 }, { 1.0313158345429, 0, 0.753006809536177, 0, 1.43273932574683, 0, -0.418629933209661, 0, 0.908156976987275 }, { 1.01721698636208, 0, 0.689816864962418, 0, 1.36769970481453, 0, -0.393534523949547, 0, 0.91930981437318 }, { 1.00432362742189, 0, 0.629665954771597, 0, 1.30759968827147, 0, -0.36846740622854, 0, 0.92964069033819 }, { 0.993228049018098, 0, 0.572723884296125, 0, 1.25311909746748, 0, -0.343446128398281, 0, 0.939172367645818 }, { 0.9797310750588, 0, 0.517784236122019, 0, 1.20314024977793, 0, -0.318509373891072, 0, 0.947919766778842 }, { 0.966668559186596, 0, 0.46438568584706, 0, 1.15755443526956, 0, -0.293396885972318, 0, 0.95599071806006 }, { 0.95280399798712, 0, 0.412920449233056, 0, 1.11368251809741, 0, -0.267457649218644, 0, 0.963569587813989 }, { 0.936565557258604, 0, 0.362170189979407, 0, 1.07293872069094, 0, -0.241337080350123, 0, 0.970441359578015 }, { 0.920498871162706, 0, 0.315104488409149, 0, 1.0353117858128, 0, -0.215524390428599, 0, 0.976498492923188 }, { 0.905699532113826, 0, 0.27081838243887, 0, 1.00048491053466, 0, -0.190241489661518, 0, 0.981737335405957 }, { 0.888393095700597, 0, 0.228804413163838, 0, 0.967081885718978, 0, -0.165356539855466, 0, 0.986233878859495 }, { 0.872983012471065, 0, 0.191305798101004, 0, 0.937946008551554, 0, -0.141060390793827, 0, 0.990001024031915 }, { 0.859120000532775, 0, 0.156859957648575, 0, 0.913092703464941, 0, -0.117006528561955, 0, 0.993131191231716 }, { 0.8620371944316, 0, 0.080651065717406, 0, 0.865743580487994, 0, -0.093053777511817, 0, 0.995661027836574 }, { 0.863744129612637, 0, 0.059656158801331, 0, 0.865743580487994, 0, -0.0688044928041781, 0, 0.997630146559363 }, { 0.864916574659741, 0, 0.03914263558741, 0, 0.865743580487994, 0, -0.0451112664775959, 0, 0.998981984646882 }, { 0.865585740113795, 0, 0.019344276406701, 0, 0.865743580487994, 0, -0.0222441109617211, 0, 0.999752616837797 }, { 0.865801824387426, 0, 3.05293266749804E-05, 0, 0.865743580487994, 0, 6.32666412653314E-05, 0, 0.999999995997332 },    // Cos(theta) = 0.4897959
            { 123.419199202373, 0, 233.776053757296, 0, 499.999976251275, 0, -0.884326813291394, 0, 0.466868308280101 }, { 123.246868800292, 0, 233.449679287605, 0, 499.999976251275, 0, -0.884326596670847, 0, 0.466868889362541 }, { 121.893600071405, 0, 230.900177184144, 0, 499.999976251275, 0, -0.884323537227362, 0, 0.466874660662527 }, { 99.9867746823081, 0, 189.39131699035, 0, 499.999976251275, 0, -0.88430920220952, 0, 0.466901703717191 }, { 37.9285589029667, 0, 71.8427271235275, 0, 499.999976251275, 0, -0.884271931199258, 0, 0.466972266051328 }, { 37.0625930867769, 0, 70.1995277726767, 0, 170.021277867594, 0, -0.884193346493106, 0, 0.467121086903984 }, { 25.7399901833537, 0, 48.7512365675362, 0, 118.064132842604, 0, -0.884050433783659, 0, 0.467391523337826 }, { 18.9129410775827, 0, 35.8179629998172, 0, 86.7339007759638, 0, -0.883814841686679, 0, 0.467836750005018 }, { 14.4832313864345, 0, 27.4253617417738, 0, 66.400169041755, 0, -0.88345616034428, 0, 0.468513749766244 }, { 11.4466386570443, 0, 21.6712456133921, 0, 52.4569133414329, 0, -0.882934973520664, 0, 0.469495350517641 }, { 9.28239136092142, 0, 17.5692018553174, 0, 42.5042396174966, 0, -0.882001081810466, 0, 0.471247425888673 }, { 7.68254654856851, 0, 14.5357167210323, 0, 35.1389367205871, 0, -0.880740580274229, 0, 0.473599015231359 }, { 6.46175602382617, 0, 12.219894869859, 0, 29.5205096978346, 0, -0.87937796848426, 0, 0.476124350222528 }, { 5.51347816217397, 0, 10.4196986475639, 0, 25.1509273449364, 0, -0.877663659103745, 0, 0.479276975157052 }, { 4.76418137459411, 0, 8.99580888956105, 0, 21.6864194643352, 0, -0.875447481883303, 0, 0.483313153505555 }, { 4.160798902915, 0, 7.847606043385, 0, 18.8888129548223, 0, -0.87287859492262, 0, 0.487937504493838 }, { 3.66828477981774, 0, 6.90863084820797, 0, 16.5975001731414, 0, -0.869839732378811, 0, 0.493334415127104 }, { 3.26183064690349, 0, 6.13171410197692, 0, 14.6949909064263, 0, -0.866330374842794, 0, 0.499471390231811 }, { 2.92488865377883, 0, 5.48506052636961, 0, 13.0978007799163, 0, -0.862202034379287, 0, 0.506564679015587 }, { 2.6411313398383, 0, 4.93796689031462, 0, 11.7428542974236, 0, -0.857532871668139, 0, 0.514429255063403 }, { 2.4033608810091, 0, 4.47623132552733, 0, 10.5804665883005, 0, -0.852168283511261, 0, 0.523267782182377 }, { 2.20216821662262, 0, 4.08157917162286, 0, 9.56992955618266, 0, -0.846173916650976, 0, 0.532906814290309 }, { 2.0325957871327, 0, 3.74427208186908, 0, 8.68443530335447, 0, -0.839350135611823, 0, 0.543591260165234 }, { 1.88949927545816, 0, 3.4541339891626, 0, 7.90120968239916, 0, -0.831792267706738, 0, 0.555087011734035 }, { 1.76774956912444, 0, 3.20116005319325, 0, 7.20340353747773, 0, -0.823318497361265, 0, 0.567579596918922 }, { 1.66557432998741, 0, 2.98175040252376, 0, 6.57902411705938, 0, -0.813964579289966, 0, 0.580914478790087 }, { 1.57845972630768, 0, 2.78631272802085, 0, 6.01464758706134, 0, -0.803678427443917, 0, 0.595063698415472 }, { 1.50467101821131, 0, 2.61246945825154, 0, 5.50807739317833, 0, -0.79238451935233, 0, 0.610021959654287 }, { 1.44069763989303, 0, 2.4538212112623, 0, 5.04815664514438, 0, -0.780167187722105, 0, 0.625571092391203 }, { 1.38866603123494, 0, 2.31299579309036, 0, 4.63099719320497, 0, -0.766996065746977, 0, 0.641651842434252 }, { 1.33892567327527, 0, 2.17488737396622, 0, 4.26335963996671, 0, -0.752732084473261, 0, 0.658327023661112 }, { 1.29880683313019, 0, 2.05205028356045, 0, 3.92562950704849, 0, -0.737788541117883, 0, 0.675031884954016 }, { 1.26460099043584, 0, 1.93686465757947, 0, 3.6196103255876, 0, -0.721938604822211, 0, 0.691957111090544 }, { 1.23396098712134, 0, 1.82821314282536, 0, 3.3453586766166, 0, -0.705240906435391, 0, 0.708967746460697 }, { 1.20704018635793, 0, 1.72460142377335, 0, 3.09951327497371, 0, -0.688010935196809, 0, 0.725700323224198 }, { 1.18278704719462, 0, 1.62565198033412, 0, 2.87681931893097, 0, -0.670178569624072, 0, 0.742199872758454 }, { 1.16185994334456, 0, 1.53266085291116, 0, 2.67608848908293, 0, -0.651791329780666, 0, 0.758398348966929 }, { 1.1463565264195, 0, 1.44789328564522, 0, 2.49138971003973, 0, -0.632744995647527, 0, 0.774360200472825 }, { 1.12795177539997, 0, 1.36064037112059, 0, 2.32912050595275, 0, -0.613170469758436, 0, 0.789950641148196 }, { 1.11195886601688, 0, 1.27717731986011, 0, 2.17864156096191, 0, -0.592820151304584, 0, 0.805334924961136 }, { 1.09914499340707, 0, 1.19862818542635, 0, 2.04175759829715, 0, -0.571158984642317, 0, 0.820839435170202 }, { 1.08655836813, 0, 1.11947985098193, 0, 1.91467840937366, 0, -0.547291830763263, 0, 0.83694186194073 }, { 1.07112073203016, 0, 1.04060684179242, 0, 1.80042039738962, 0, -0.522778510680422, 0, 0.852468549606878 }, { 1.05854190494773, 0, 0.966044233909875, 0, 1.69818503658851, 0, -0.497975614989708, 0, 0.86719106394499 }, { 1.04904530929945, 0, 0.897010722001965, 0, 1.60428090513937, 0, -0.472720540510439, 0, 0.881212370620062 }, { 1.03498107688549, 0, 0.826229865127033, 0, 1.52199481804517, 0, -0.447276612658331, 0, 0.894395630649688 }, { 1.0226105122148, 0, 0.760594564048576, 0, 1.44589059892831, 0, -0.421694681954024, 0, 0.906737829446958 }, { 1.0116606444744, 0, 0.697617925331999, 0, 1.37675383541713, 0, -0.396171320143242, 0, 0.91817663436493 }, { 0.998219083809844, 0, 0.6354475732849, 0, 1.31596468791118, 0, -0.370664812809742, 0, 0.928766761650926 }, { 0.988237949688806, 0, 0.57854100227771, 0, 1.25927073629796, 0, -0.345147787422054, 0, 0.938548302058353 }, { 0.975149328244035, 0, 0.522351403167617, 0, 1.20826131466864, 0, -0.319906282321637, 0, 0.947449171694429 }, { 0.960359965082335, 0, 0.467475418769876, 0, 1.16042516302418, 0, -0.294804777903828, 0, 0.955557549927558 }, { 0.948825470858787, 0, 0.417103598024662, 0, 1.11718828551085, 0, -0.269698296822081, 0, 0.962944882383117 }, { 0.933039220491027, 0, 0.366119671561408, 0, 1.07545395997232, 0, -0.244167656476268, 0, 0.969733003282605 }, { 0.918073002002356, 0, 0.318824500967976, 0, 1.03682186342121, 0, -0.217874241566641, 0, 0.975976881257882 }, { 0.902192267421468, 0, 0.273303781797015, 0, 1.0001871906034, 0, -0.191988382732931, 0, 0.981397248410375 }, { 0.884849388003614, 0, 0.230959062995519, 0, 0.966063003057071, 0, -0.166596257301435, 0, 0.986025176637593 }, { 0.868627841099774, 0, 0.19248496462893, 0, 0.935915319741162, 0, -0.1416691978252, 0, 0.989914052333832 }, { 0.855812985952064, 0, 0.158005092213614, 0, 0.911060181328744, 0, -0.117460462394583, 0, 0.993077604266992 }, { 0.861999184351449, 0, 0.0810572024064613, 0, 0.865743580487994, 0, -0.0935228691903453, 0, 0.995617172461161 }, { 0.863676973772027, 0, 0.0606204759378656, 0, 0.865743580487994, 0, -0.0699182854977147, 0, 0.997552691388902 }, { 0.864876179536137, 0, 0.0400246530008264, 0, 0.865743580487994, 0, -0.0461300000515237, 0, 0.998935428704428 }, { 0.865580743948236, 0, 0.0195638236246007, 0, 0.865743580487994, 0, -0.0224976882843094, 0, 0.999746871257414 }, { 0.865801771964141, 0, -0.000257706195865125, 0, 0.865743580487994, 0, 0.000396178292755291, 0, 0.999999902647393 },    // Cos(theta) = 0.4668682
            { 122.203307518463, 0, 247.00517110186, 0, 499.999976251276, 0, -0.896305689178754, 0, 0.443436716431642 }, { 121.916791157983, 0, 246.426186125226, 0, 499.999976251275, 0, -0.896305431101011, 0, 0.443437213344975 }, { 119.560123971543, 0, 241.664050608954, 0, 499.999976251275, 0, -0.896302172056763, 0, 0.443443749871231 }, { 97.5068502000722, 0, 197.08713727279, 0, 499.999976251276, 0, -0.896287471507845, 0, 0.443473414276069 }, { 55.0040022889313, 0, 111.175638156813, 0, 279.694597891939, 0, -0.896248427527195, 0, 0.443552537065952 }, { 35.202496673554, 0, 71.1501062600091, 0, 179.007050035664, 0, -0.896166561760865, 0, 0.443717806900963 }, { 24.4484947116988, 0, 49.4117013451411, 0, 124.300774874151, 0, -0.89601738919016, 0, 0.444019057357808 }, { 17.9646147857162, 0, 36.3040470338964, 0, 91.3193272156877, 0, -0.895772560122517, 0, 0.444512657228019 }, { 13.7572947979074, 0, 27.7976474951564, 0, 69.9087708613754, 0, -0.89539865488001, 0, 0.445265342026765 }, { 10.8736882869957, 0, 21.9664346947941, 0, 55.2285890059251, 0, -0.894852588093005, 0, 0.44636187421796 }, { 8.8214924539854, 0, 17.8153575815609, 0, 44.7589411412787, 0, -0.893802018041087, 0, 0.44846172679149 }, { 7.29875864288369, 0, 14.7340092887568, 0, 36.9967721685674, 0, -0.89259824791439, 0, 0.450852978607105 }, { 6.13959887473453, 0, 12.3869323786649, 0, 31.0822413731008, 0, -0.89120297347258, 0, 0.453604871567074 }, { 5.24247790635463, 0, 10.5690164488554, 0, 26.4874461759123, 0, -0.889296288120983, 0, 0.457331505755939 }, { 4.52900955345461, 0, 9.1216753869161, 0, 22.8292856928711, 0, -0.887151371328755, 0, 0.461478627597207 }, { 3.95675885926734, 0, 7.95884682458961, 0, 19.8858609429211, 0, -0.884457309843157, 0, 0.466621141082665 }, { 3.48984665625273, 0, 7.00803135014364, 0, 17.4724922195308, 0, -0.881303012912526, 0, 0.472551584534105 }, { 3.10526787570621, 0, 6.22228204211879, 0, 15.4663867244435, 0, -0.87769297243148, 0, 0.479223419235474 }, { 2.78542646517619, 0, 5.56619377293192, 0, 13.7840094676414, 0, -0.873448344268862, 0, 0.486916857907688 }, { 2.5187731488085, 0, 5.01588730356203, 0, 12.3515236317293, 0, -0.868614882106314, 0, 0.495487792109957 }, { 2.29382958361849, 0, 4.54760016948186, 0, 11.1249387401423, 0, -0.863053783093224, 0, 0.505111948355147 }, { 2.10484537777532, 0, 4.14968350239248, 0, 10.0546739368764, 0, -0.856855478192454, 0, 0.515556708800161 }, { 1.94680556187179, 0, 3.81089829585637, 0, 9.11348110637779, 0, -0.849852402011913, 0, 0.527020727172305 }, { 1.8133028929354, 0, 3.51906934479177, 0, 8.28145933246232, 0, -0.841932414519294, 0, 0.539582928633629 }, { 1.70102440962743, 0, 3.26504973334889, 0, 7.5358421175769, 0, -0.833242664199541, 0, 0.552907473125323 }, { 1.60626954302002, 0, 3.04262791781624, 0, 6.87038125656975, 0, -0.823576513201028, 0, 0.567205192895831 }, { 1.52406160376699, 0, 2.84199350426628, 0, 6.27283348406713, 0, -0.812912682207947, 0, 0.582385627734165 }, { 1.45838171017262, 0, 2.66875742400003, 0, 5.7289017026996, 0, -0.801335249480209, 0, 0.598215501201519 }, { 1.39795153680229, 0, 2.50343883221149, 0, 5.24445386481479, 0, -0.78869130005294, 0, 0.614789440186834 }, { 1.34824409265071, 0, 2.35615097572075, 0, 4.80235475837064, 0, -0.775069796130516, 0, 0.631875652889827 }, { 1.30271692524868, 0, 2.21471349161545, 0, 4.4098924458249, 0, -0.760427819937003, 0, 0.649422506841189 }, { 1.26644314319568, 0, 2.08768473333253, 0, 4.05107747386237, 0, -0.744918053530601, 0, 0.66715603905767 }, { 1.23373140803736, 0, 1.96735097658118, 0, 3.72845145352311, 0, -0.728589407767988, 0, 0.684950702026828 }, { 1.20600142301359, 0, 1.85511388515588, 0, 3.43962348722374, 0, -0.711324676962239, 0, 0.702863559393959 }, { 1.18142095822884, 0, 1.74754951575632, 0, 3.18045723051901, 0, -0.693448070804111, 0, 0.720506612738559 }, { 1.15991737172963, 0, 1.64782908727506, 0, 2.94429670407517, 0, -0.675016633918666, 0, 0.737802562227679 }, { 1.14230316802281, 0, 1.55328730619027, 0, 2.72990167136975, 0, -0.655995848382983, 0, 0.754764500258129 }, { 1.12575198532968, 0, 1.46272465511885, 0, 2.54025630625059, 0, -0.63640384508816, 0, 0.771356029747989 }, { 1.11253215146856, 0, 1.3767384170748, 0, 2.36915490958144, 0, -0.616327499868702, 0, 0.7874899195874 }, { 1.09721397121163, 0, 1.29075613853456, 0, 2.21439921867168, 0, -0.595732439116747, 0, 0.803182944229277 }, { 1.08358040169687, 0, 1.2086565662547, 0, 2.07538906359619, 0, -0.574438196163394, 0, 0.818547938249303 }, { 1.07434221212368, 0, 1.13351258592219, 0, 1.94555975289572, 0, -0.552113051328791, 0, 0.833769254506669 }, { 1.06199213520879, 0, 1.05422649931734, 0, 1.82790019062187, 0, -0.527516778497742, 0, 0.849544674644758 }, { 1.04803603662008, 0, 0.976638199310918, 0, 1.72019502565147, 0, -0.502300166523242, 0, 0.864693281110028 }, { 1.03640210377528, 0, 0.904000662473924, 0, 1.62485010251756, 0, -0.476712998503479, 0, 0.87905895580294 }, { 1.02713234145813, 0, 0.835524770157312, 0, 1.53757042393604, 0, -0.45084933365927, 0, 0.892600077712668 }, { 1.0162616526747, 0, 0.76827750572085, 0, 1.45980456360183, 0, -0.424824214760425, 0, 0.905275832144386 }, { 1.00603762083747, 0, 0.70504944886397, 0, 1.38769216504477, 0, -0.398762306103793, 0, 0.917054264970703 }, { 0.993338783547214, 0, 0.641950671689526, 0, 1.32396328029134, 0, -0.372806620495908, 0, 0.927909120203924 }, { 0.980939024744087, 0, 0.582438158958333, 0, 1.26638782154658, 0, -0.346922400590256, 0, 0.937893794970532 }, { 0.968739999280401, 0, 0.525578977789305, 0, 1.21285334917799, 0, -0.321084890026306, 0, 0.947050373877028 }, { 0.955642502749483, 0, 0.471175860106859, 0, 1.16421075146007, 0, -0.295667606833274, 0, 0.955290912530285 }, { 0.944718022745624, 0, 0.420612059156805, 0, 1.12017336582661, 0, -0.270412775394384, 0, 0.962744483313409 }, { 0.929312823045049, 0, 0.370028225492048, 0, 1.07805930981804, 0, -0.24526044005085, 0, 0.96945718130332 }, { 0.914980774462453, 0, 0.322712353901457, 0, 1.03862164044388, 0, -0.220097458617266, 0, 0.975477901824742 }, { 0.899865871747118, 0, 0.276991795474424, 0, 1.00144791212582, 0, -0.194257268968088, 0, 0.98095064242188 }, { 0.882249232569907, 0, 0.233238635377489, 0, 0.965996240004047, 0, -0.168353573020927, 0, 0.985726630007789 }, { 0.865531390242498, 0, 0.194223398746902, 0, 0.934396523638738, 0, -0.14284451345657, 0, 0.989745142832717 }, { 0.852482325623348, 0, 0.158705902088688, 0, 0.908316100287081, 0, -0.117967767025998, 0, 0.993017414218197 }, { 0.861994693413426, 0, 0.0811044119050243, 0, 0.865743580487994, 0, -0.0935773966114748, 0, 0.995611990805953 }, { 0.863682226233686, 0, 0.0605462022660235, 0, 0.865743580487994, 0, -0.0698324989046295, 0, 0.997558749523035 }, { 0.864857617685957, 0, 0.0404249043790808, 0, 0.865743580487994, 0, -0.0465922919904514, 0, 0.998914035339847 }, { 0.865560884820869, 0, 0.0204255618515228, 0, 0.865743580487994, 0, -0.0234929970869541, 0, 0.99972403205641 }, { 0.865801809771726, 0, 0.00015579558842002, 0, 0.865743580487994, 0, -8.14157314440591E-05, 0, 0.999999993371479 },    // Cos(theta) = 0.4434366
            { 120.798511772357, 0, 261.389610253781, 0, 499.999976251275, 0, -0.907754921218194, 0, 0.419500927893157 }, { 120.465585909963, 0, 260.673164837542, 0, 499.999976251275, 0, -0.90775512310744, 0, 0.419500521324415 }, { 117.005886798496, 0, 253.187422866038, 0, 499.999976251275, 0, -0.907751246525258, 0, 0.419508750225285 }, { 94.8026567234859, 0, 205.141902785715, 0, 499.999976251276, 0, -0.907735940960189, 0, 0.419542040837365 }, { 52.0327071965632, 0, 112.590325721432, 0, 295.661916424419, 0, -0.907695674673195, 0, 0.419629107903877 }, { 33.3031647656411, 0, 72.060096082976, 0, 189.215031793796, 0, -0.90761035346367, 0, 0.419813658988338 }, { 23.1295990135439, 0, 50.0437478899447, 0, 131.395009541797, 0, -0.907455140815241, 0, 0.4201490533527 }, { 16.9957942901132, 0, 36.7685907384262, 0, 96.5285525781275, 0, -0.90720095317866, 0, 0.420697579435177 }, { 13.0156577301487, 0, 28.1533417610195, 0, 73.8955415074517, 0, -0.906812046273055, 0, 0.421535152251404 }, { 10.2884432220823, 0, 22.2488482979059, 0, 58.38093829998, 0, -0.906235137065455, 0, 0.42277391947274 }, { 8.34835796676649, 0, 18.0472026851733, 0, 47.3206072270609, 0, -0.905125137793565, 0, 0.425145324665766 }, { 6.90774955498041, 0, 14.9257604189792, 0, 39.1058592292811, 0, -0.903936095611646, 0, 0.427667561754109 }, { 5.81066050551463, 0, 12.547131546885, 0, 32.8512985882147, 0, -0.90251177072443, 0, 0.430665104665375 }, { 4.96247909633932, 0, 10.706316999322, 0, 27.9972732533575, 0, -0.900546528079258, 0, 0.434759694286795 }, { 4.28966576956887, 0, 9.24430392842547, 0, 24.1340900474891, 0, -0.898284820981965, 0, 0.439413562543762 }, { 3.74790163574196, 0, 8.0647330971255, 0, 21.0164607332118, 0, -0.895576733345878, 0, 0.444907107889306 }, { 3.30745171799924, 0, 7.10343943245355, 0, 18.4657036808569, 0, -0.892315003502093, 0, 0.451413230554434 }, { 2.94485341735467, 0, 6.30920467634081, 0, 16.343409400935, 0, -0.888539587029754, 0, 0.458799854802526 }, { 2.64378626320404, 0, 5.64613146616411, 0, 14.5624007422037, 0, -0.884159153296786, 0, 0.467185828045975 }, { 2.39228675233049, 0, 5.0883853818059, 0, 13.0443630316935, 0, -0.87917081596942, 0, 0.476506791638262 }, { 2.18463752972048, 0, 4.62296425715508, 0, 11.7345888749806, 0, -0.873416098510426, 0, 0.486974767450814 }, { 2.00792479461592, 0, 4.22133065905887, 0, 10.5964951603305, 0, -0.866957248560783, 0, 0.498382445437212 }, { 1.85912281833808, 0, 3.87663788608182, 0, 9.595439702879, 0, -0.859738876946239, 0, 0.510733837259587 }, { 1.73718623863244, 0, 3.58546642151848, 0, 8.70396951637841, 0, -0.851503746746769, 0, 0.524348471109934 }, { 1.63434153003011, 0, 3.33103715765215, 0, 7.90227047204422, 0, -0.842559299730172, 0, 0.538603481914761 }, { 1.54555938334964, 0, 3.10303043815855, 0, 7.19084444630756, 0, -0.832584695573621, 0, 0.553897709744949 }, { 1.47104249077962, 0, 2.9004116672365, 0, 6.55383778572039, 0, -0.821518016539251, 0, 0.570182570618618 }, { 1.40967046854882, 0, 2.72079912982843, 0, 5.9729759361798, 0, -0.809588188985062, 0, 0.586998323521034 }, { 1.35471187671547, 0, 2.55291391272132, 0, 5.45320142311667, 0, -0.796629795418494, 0, 0.604467517950776 }, { 1.31020442191448, 0, 2.40186915223885, 0, 4.9841536088748, 0, -0.782521209001274, 0, 0.622623889519188 }, { 1.27213651910331, 0, 2.26203143323191, 0, 4.56045257851137, 0, -0.7674794193307, 0, 0.641073584241212 }, { 1.23423248709161, 0, 2.12319392204573, 0, 4.1843372225368, 0, -0.751489142616208, 0, 0.659745437380106 }, { 1.20507743219221, 0, 1.9992200833594, 0, 3.84234497013981, 0, -0.734628483672458, 0, 0.678469639597327 }, { 1.17935951203044, 0, 1.8820990709024, 0, 3.53653348853862, 0, -0.716870871951064, 0, 0.697205929611132 }, { 1.15978329604546, 0, 1.77534124970263, 0, 3.25981809799164, 0, -0.698322955841577, 0, 0.715782886422471 }, { 1.13953504770107, 0, 1.6691708782602, 0, 3.0135116779602, 0, -0.679253203666343, 0, 0.733903985846093 }, { 1.12185308882688, 0, 1.56982412609379, 0, 2.7924936047133, 0, -0.659641070724852, 0, 0.751580756177636 }, { 1.10795961452283, 0, 1.47726637416374, 0, 2.59237169860775, 0, -0.639436947956177, 0, 0.768843588529641 }, { 1.09409343272756, 0, 1.38795972117575, 0, 2.41284486460131, 0, -0.618761717375997, 0, 0.785578726583128 }, { 1.08277506851488, 0, 1.30326986131558, 0, 2.25002204599564, 0, -0.597698324561851, 0, 0.801721087565044 }, { 1.07082475862551, 0, 1.22018370524368, 0, 2.10536846500144, 0, -0.57626171442118, 0, 0.817265234123282 }, { 1.06091178879641, 0, 1.14188332297763, 0, 1.9724512519031, 0, -0.554206947621423, 0, 0.832378894256336 }, { 1.05260266204392, 0, 1.06721815984508, 0, 1.85318611862818, 0, -0.531238066910904, 0, 0.847222642269481 }, { 1.03993018093067, 0, 0.988615007551397, 0, 1.74406344659484, 0, -0.506405692415564, 0, 0.862295399122691 }, { 1.02908677684814, 0, 0.914481913210739, 0, 1.64299261403592, 0, -0.480521760851537, 0, 0.876982794461639 }, { 1.02057114847568, 0, 0.845044924809343, 0, 1.55269904499389, 0, -0.454315834733377, 0, 0.890840638095831 }, { 1.00809527722375, 0, 0.775196713491781, 0, 1.4728754434996, 0, -0.427939112305928, 0, 0.903807636933009 }, { 0.998724577352677, 0, 0.710687745922917, 0, 1.39939120850325, 0, -0.401466204185715, 0, 0.915873856053056 }, { 0.986573279840558, 0, 0.647341743027272, 0, 1.33259845830835, 0, -0.374968595735411, 0, 0.927037481670998 }, { 0.975596507636339, 0, 0.587325925267294, 0, 1.27221462888595, 0, -0.348697764678385, 0, 0.93723529138735 }, { 0.963979322441197, 0, 0.530485483481511, 0, 1.21804300010653, 0, -0.322521072266676, 0, 0.946562351985054 }, { 0.951055216556688, 0, 0.474736654667227, 0, 1.16771373855854, 0, -0.296478572172683, 0, 0.955039509775159 }, { 0.939114986268115, 0, 0.42277009966485, 0, 1.12211528104049, 0, -0.270866797657624, 0, 0.962616812470878 }, { 0.925218790222118, 0, 0.372490162138285, 0, 1.07934359213536, 0, -0.245464152963629, 0, 0.969405619958888 }, { 0.91090987963116, 0, 0.32479225062208, 0, 1.03975644381857, 0, -0.220437336134461, 0, 0.975401111089416 }, { 0.896561550769218, 0, 0.279806061246915, 0, 1.00174587015042, 0, -0.195524730250109, 0, 0.980698714134883 }, { 0.879695757612233, 0, 0.236195071202334, 0, 0.965355900451282, 0, -0.170431083756846, 0, 0.985369572842934 }, { 0.862577025250371, 0, 0.196304992561065, 0, 0.933073938123993, 0, -0.144688455559164, 0, 0.989477307534468 }, { 0.849404183873381, 0, 0.160406425469036, 0, 0.906129236660516, 0, -0.119195316654627, 0, 0.992870844240812 }, { 0.86194718910124, 0, 0.0816075675682449, 0, 0.865743580487994, 0, -0.0941585461607013, 0, 0.995557180645491 }, { 0.863678241078179, 0, 0.0606029807541716, 0, 0.865743580487994, 0, -0.0698980784388526, 0, 0.997554153134929 }, { 0.864877335240091, 0, 0.0399993066553049, 0, 0.865743580487994, 0, -0.0461007249235588, 0, 0.998936760656601 }, { 0.865572916828257, 0, 0.0199070949941753, 0, 0.865743580487994, 0, -0.0228941671649599, 0, 0.999737870008088 }, { 0.86580174517284, 0, 0.000304819032087209, 0, 0.865743580487994, 0, -0.000253537624376303, 0, 0.999999935718669 },    // Cos(theta) = 0.4195011
            { 119.454728703543, 0, 277.771788425491, 0, 499.999976251276, 0, -0.918654745325903, 0, 0.395061261023076 }, { 118.893055284272, 0, 276.466769963679, 0, 499.999976251275, 0, -0.918654249037095, 0, 0.395062470383474 }, { 114.210376703897, 0, 265.578028496221, 0, 499.999976251275, 0, -0.918650783992375, 0, 0.395070598818478 }, { 91.8446864287919, 0, 213.569541678106, 0, 499.999976251275, 0, -0.918635420626867, 0, 0.395106423339056 }, { 49.0032875761342, 0, 113.946326428276, 0, 313.948357965519, 0, -0.918593378312705, 0, 0.395203965620057 }, { 31.362480097402, 0, 72.9234902986685, 0, 200.921998774099, 0, -0.918504773820039, 0, 0.395410052273658 }, { 21.7825847647057, 0, 50.6447311788474, 0, 139.518588195908, 0, -0.918344068842117, 0, 0.395782887047973 }, { 16.0067179251789, 0, 37.2112066548982, 0, 102.498869962175, 0, -0.918080674225018, 0, 0.39639373226166 }, { 12.2582550228896, 0, 28.4916032373796, 0, 78.4665140088414, 0, -0.917675654744144, 0, 0.397330305600286 }, { 9.69338516201321, 0, 22.5238363845493, 0, 62.0006154278906, 0, -0.917020498456767, 0, 0.398840154755887 }, { 7.86506282899264, 0, 18.2681821260844, 0, 50.2502227870284, 0, -0.915931516988505, 0, 0.4013346669143 }, { 6.50716099922164, 0, 15.1058202895058, 0, 41.5223649877351, 0, -0.914756342044497, 0, 0.404005881700901 }, { 5.47749346362022, 0, 12.7059481106512, 0, 34.8891198774923, 0, -0.913200843445117, 0, 0.4075096824967 }, { 4.67769902900748, 0, 10.8398523826248, 0, 29.722203579762, 0, -0.911272697009124, 0, 0.411803507467417 }, { 4.04504472581956, 0, 9.36157593087187, 0, 25.6282231981992, 0, -0.908886013128502, 0, 0.417044695690216 }, { 3.53593805555225, 0, 8.16914149801509, 0, 22.318604649312, 0, -0.906063049598635, 0, 0.423142744905555 }, { 3.12248506288491, 0, 7.19790836768867, 0, 19.6030123860453, 0, -0.902749764790258, 0, 0.430166147957668 }, { 2.7820851028146, 0, 6.394854934278, 0, 17.3464908485418, 0, -0.898837185902568, 0, 0.438282657450934 }, { 2.50063599276109, 0, 5.72660588208852, 0, 15.4479750869158, 0, -0.894301257720721, 0, 0.447465400997179 }, { 2.26681076889599, 0, 5.16658890556666, 0, 13.8276401485441, 0, -0.88913331992101, 0, 0.457648179669893 }, { 2.07108389885651, 0, 4.69194035419592, 0, 12.4353488015384, 0, -0.883149227662516, 0, 0.469092171630504 }, { 1.90780712697054, 0, 4.28906169444915, 0, 11.2099068509638, 0, -0.876528840636223, 0, 0.481349463930238 }, { 1.77452925525972, 0, 3.95115047829919, 0, 10.126957143118, 0, -0.869018741042838, 0, 0.494779110114753 }, { 1.66091519392975, 0, 3.6542210707189, 0, 9.17345751066763, 0, -0.860505628263499, 0, 0.509440986539049 }, { 1.56706406590377, 0, 3.39796355254693, 0, 8.31071924519477, 0, -0.851234117674958, 0, 0.524786102154937 }, { 1.48682095487833, 0, 3.16746531157553, 0, 7.54385844865103, 0, -0.84092547462668, 0, 0.541150901756995 }, { 1.41841952785151, 0, 2.96053935828362, 0, 6.85711875847004, 0, -0.829542136514033, 0, 0.558444166633541 }, { 1.36331045109358, 0, 2.77777081092748, 0, 6.23321392664236, 0, -0.817190280487079, 0, 0.576367967926309 }, { 1.31225360693057, 0, 2.60181575495074, 0, 5.67924436303791, 0, -0.803842111454851, 0, 0.594842764317541 }, { 1.2723552464974, 0, 2.44797848718539, 0, 5.17640599299144, 0, -0.789351164036234, 0, 0.613941966508566 }, { 1.23706459547005, 0, 2.30129603933356, 0, 4.72884743847029, 0, -0.773816721679041, 0, 0.633409524794448 }, { 1.20210851900549, 0, 2.15675718959671, 0, 4.32965293594975, 0, -0.757380627086956, 0, 0.652973671148942 }, { 1.1759964118057, 0, 2.02848019339591, 0, 3.96614082495378, 0, -0.739998522405665, 0, 0.672608497471806 }, { 1.15561115749365, 0, 1.91204978300652, 0, 3.63720173953687, 0, -0.721735737315223, 0, 0.692168733186404 }, { 1.1345524956051, 0, 1.79517925188845, 0, 3.3489770077713, 0, -0.702692323759296, 0, 0.711493843553345 }, { 1.1167195970149, 0, 1.68666872621701, 0, 3.08926345178427, 0, -0.682871337385757, 0, 0.730538597861935 }, { 1.1026989635332, 0, 1.58595828903161, 0, 2.85337069519274, 0, -0.66270606574511, 0, 0.748879598662062 }, { 1.08781868286862, 0, 1.48787675317966, 0, 2.64498855381316, 0, -0.641933307708982, 0, 0.76676052266442 }, { 1.07663688015541, 0, 1.39675966421572, 0, 2.4575842079336, 0, -0.62064633893284, 0, 0.784090614658092 }, { 1.06549725849609, 0, 1.309648643639, 0, 2.28840916732917, 0, -0.599005779552378, 0, 0.800744660465766 }, { 1.05637434614095, 0, 1.22658885057708, 0, 2.13555876205595, 0, -0.577070086811926, 0, 0.81669465890761 }, { 1.04545730091937, 0, 1.14507043784228, 0, 2.00179147980132, 0, -0.554837382294206, 0, 0.831958795288022 }, { 1.03895374842186, 0, 1.07083137818931, 0, 1.87760697848858, 0, -0.53217763362152, 0, 0.846632729436153 }, { 1.03080148237337, 0, 0.997675803056954, 0, 1.7647191025951, 0, -0.508746088173507, 0, 0.860916615585699 }, { 1.02065113142258, 0, 0.923782810848344, 0, 1.66443112572696, 0, -0.484175299318404, 0, 0.874970986744475 }, { 1.01409638911462, 0, 0.854487987891705, 0, 1.57044563030044, 0, -0.457718239911412, 0, 0.889097249377173 }, { 1.00091502344979, 0, 0.782788995767953, 0, 1.487560099344, 0, -0.431029628828459, 0, 0.902337750261888 }, { 0.990872521758406, 0, 0.716467445812308, 0, 1.41062835747715, 0, -0.40424396476229, 0, 0.914651265184469 }, { 0.980946539598517, 0, 0.653173862209284, 0, 1.34084737401609, 0, -0.377398871350241, 0, 0.926050751538875 }, { 0.970296743140866, 0, 0.592319488593184, 0, 1.27928499229793, 0, -0.35053895152485, 0, 0.936548126631917 }, { 0.958525444232776, 0, 0.534207831406058, 0, 1.22303886342894, 0, -0.324036801371468, 0, 0.946044516134843 }, { 0.946188153994288, 0, 0.47790815408764, 0, 1.17147590118379, 0, -0.297651653011381, 0, 0.954674556351115 }, { 0.935289419645251, 0, 0.425877042969427, 0, 1.1248384847408, 0, -0.271453000140923, 0, 0.962451767227689 }, { 0.920592373777508, 0, 0.374896730482878, 0, 1.08027759075352, 0, -0.245652824297361, 0, 0.969357905614971 }, { 0.906862847768738, 0, 0.326542273858261, 0, 1.03943733180264, 0, -0.220252488206174, 0, 0.975442904612263 }, { 0.892543102116061, 0, 0.281162232507964, 0, 1.00138856631357, 0, -0.195101343554361, 0, 0.980783069749855 }, { 0.875673934541054, 0, 0.237528956224251, 0, 0.964360973258573, 0, -0.170391607157986, 0, 0.985376434139688 }, { 0.859139873400129, 0, 0.197680313332186, 0, 0.931460753231636, 0, -0.145829053400374, 0, 0.989309757576266 }, { 0.845195003694477, 0, 0.161429344028695, 0, 0.903572596198535, 0, -0.121119094622197, 0, 0.992637973440683 }, { 0.833603636527676, 0, 0.127993132186661, 0, 0.880707165171568, 0, -0.0958119951189532, 0, 0.995399420915336 }, { 0.863630576870476, 0, 0.0612787243610066, 0, 0.865743580487994, 0, -0.0706785668589578, 0, 0.997499177935805 }, { 0.864869159743712, 0, 0.0401767570021018, 0, 0.865743580487994, 0, -0.0463056807760262, 0, 0.998927338162601 }, { 0.865578682292962, 0, 0.0196562218264808, 0, 0.865743580487994, 0, -0.022604408323142, 0, 0.999744500563113 }, { 0.865801757091624, 0, -0.000396041832831113, 0, 0.865743580487994, 0, 0.000555955773663447, 0, 0.999999869727104 },    // Cos(theta) = 0.3950617
            { 117.842520467806, 0, 295.777580036145, 0, 499.999976251275, 0, -0.92898454946695, 0, 0.370118455869318 }, { 117.187897269009, 0, 294.137236802186, 0, 499.999976251275, 0, -0.928984194289038, 0, 0.370119350915048 }, { 111.162988443856, 0, 279.015282699672, 0, 499.999976251275, 0, -0.928980405617331, 0, 0.370128898027078 }, { 88.7036361574889, 0, 222.645319082453, 0, 499.999976251275, 0, -0.928964297019511, 0, 0.370169303861913 }, { 45.9091414284406, 0, 115.226573943238, 0, 335.109907432214, 0, -0.928920810851237, 0, 0.370278366654006 }, { 29.3739160387284, 0, 73.7154190583074, 0, 214.484739777706, 0, -0.928829355984492, 0, 0.370507686996135 }, { 20.4082911082126, 0, 51.2155540578944, 0, 148.92295942083, 0, -0.928663371867135, 0, 0.370923804717423 }, { 14.9964910023724, 0, 37.6290341109034, 0, 109.40476890628, 0, -0.92839024020531, 0, 0.371606781306652 }, { 11.4856380368498, 0, 28.8132092367948, 0, 83.7520899753194, 0, -0.927970618548215, 0, 0.372653323581199 }, { 9.08898775715708, 0, 22.7934403770206, 0, 66.2111998490686, 0, -0.927171428601873, 0, 0.374637289520265 }, { 7.37099182055499, 0, 18.4763274526268, 0, 53.6391638040459, 0, -0.926181352422177, 0, 0.377078428638993 }, { 6.0991133052063, 0, 15.2784440625826, 0, 44.3174466685677, 0, -0.924991853665738, 0, 0.379986860838512 }, { 5.136919250874, 0, 12.8569380382505, 0, 37.2480880238651, 0, -0.923329641791867, 0, 0.384008200011996 }, { 4.38704634448021, 0, 10.9670924906399, 0, 31.7302123061628, 0, -0.921397487300492, 0, 0.388621555628004 }, { 3.79486702324029, 0, 9.47205832336012, 0, 27.3517834151765, 0, -0.918978738894451, 0, 0.394306986683869 }, { 3.31998594923152, 0, 8.27007794691631, 0, 23.8174696825061, 0, -0.916036702092292, 0, 0.401094340892763 }, { 2.93309541066102, 0, 7.28723659998481, 0, 20.9165876598456, 0, -0.912616183731141, 0, 0.408817349682086 }, { 2.61771558840813, 0, 6.48182006992824, 0, 18.5014583559257, 0, -0.908563318810566, 0, 0.417747171085833 }, { 2.35558412914474, 0, 5.80690356694181, 0, 16.4688873906678, 0, -0.903887978119708, 0, 0.427769151636976 }, { 2.13915458094154, 0, 5.24379062117681, 0, 14.7256213561789, 0, -0.898557976433602, 0, 0.438854850922128 }, { 1.963081607368, 0, 4.77732209845843, 0, 13.2143961298532, 0, -0.892334097069297, 0, 0.451375510973351 }, { 1.81177121725828, 0, 4.36901187774503, 0, 11.8977031211401, 0, -0.885469418605238, 0, 0.464697558662678 }, { 1.68846137980755, 0, 4.02504295470169, 0, 10.7269311341396, 0, -0.877654444243217, 0, 0.479293948454726 }, { 1.58714748937563, 0, 3.73048331080198, 0, 9.68925247338915, 0, -0.868908737898099, 0, 0.494972367906461 }, { 1.5018236667697, 0, 3.46918004619463, 0, 8.76008347695172, 0, -0.859273225760468, 0, 0.511516851738715 }, { 1.42790049581544, 0, 3.23174818598532, 0, 7.93396230318951, 0, -0.848610708678693, 0, 0.529017774819476 }, { 1.36621294691222, 0, 3.02005789279701, 0, 7.19000818062692, 0, -0.836851814079877, 0, 0.547429527151863 }, { 1.3168142524811, 0, 2.83329605703436, 0, 6.5186461849867, 0, -0.824072340580263, 0, 0.566484556471483 }, { 1.2697098942337, 0, 2.6496706956614, 0, 5.92678419063968, 0, -0.810303142686394, 0, 0.586010926470613 }, { 1.23338769891927, 0, 2.48963594548639, 0, 5.38704367541157, 0, -0.795448247443542, 0, 0.606021526390172 }, { 1.20240140799452, 0, 2.33915652415966, 0, 4.9048301889838, 0, -0.779430573876015, 0, 0.62648867845973 }, { 1.17423600461548, 0, 2.1949150092032, 0, 4.47820380190525, 0, -0.762514219002685, 0, 0.646971502353724 }, { 1.14952442144686, 0, 2.05942381215492, 0, 4.08965176581042, 0, -0.744697773472577, 0, 0.667401871605076 }, { 1.12827009798383, 0, 1.93306997252914, 0, 3.74738711503837, 0, -0.725892683545141, 0, 0.687807996664866 }, { 1.10957832781557, 0, 1.8127587432552, 0, 3.44196782982337, 0, -0.706348346059203, 0, 0.707864390170035 }, { 1.09702098315416, 0, 1.70709211827138, 0, 3.1613087236683, 0, -0.686010126496127, 0, 0.727591995875886 }, { 1.08144140986621, 0, 1.59789328311614, 0, 2.91753339716963, 0, -0.665118959591972, 0, 0.746737383805058 }, { 1.07077255942062, 0, 1.50027855891924, 0, 2.70019513389453, 0, -0.643811184455173, 0, 0.765184353218255 }, { 1.05884685840932, 0, 1.4034899454875, 0, 2.50327134745048, 0, -0.62198186776541, 0, 0.783031653211228 }, { 1.05052825410998, 0, 1.31649492993007, 0, 2.32468141325063, 0, -0.599726738082898, 0, 0.800204875136261 }, { 1.04247906630932, 0, 1.23189807074048, 0, 2.16923884547762, 0, -0.577184899659931, 0, 0.816613472878742 }, { 1.03239480647195, 0, 1.14854090851364, 0, 2.02741790616461, 0, -0.554456150436781, 0, 0.832212978492989 }, { 1.02471910018498, 0, 1.07131658714175, 0, 1.90101031204693, 0, -0.531594850324701, 0, 0.846998810840633 }, { 1.01943578627848, 0, 0.999992083645997, 0, 1.78479465407157, 0, -0.508275374898494, 0, 0.861194585565407 }, { 1.01002940693755, 0, 0.927173668649846, 0, 1.68118990868962, 0, -0.484520339765566, 0, 0.874779988133229 }, { 1.00208157454551, 0, 0.857723201291078, 0, 1.58678020653928, 0, -0.460219015866105, 0, 0.887805440969856 }, { 0.995030977552564, 0, 0.790641872501346, 0, 1.50128034171361, 0, -0.434132925836311, 0, 0.900848851601196 }, { 0.984977190368022, 0, 0.722983710611502, 0, 1.42232512574825, 0, -0.407098687998362, 0, 0.913384148573894 }, { 0.975336566236942, 0, 0.65944836153233, 0, 1.35142928836377, 0, -0.3799694537124, 0, 0.924999085461428 }, { 0.965237815192243, 0, 0.597855643820502, 0, 1.28615676268428, 0, -0.352883272061488, 0, 0.935667297315729 }, { 0.953816002565657, 0, 0.538750251594778, 0, 1.22785491110427, 0, -0.325762033101267, 0, 0.94545179500637 }, { 0.941151701983504, 0, 0.481819494860074, 0, 1.17455708093174, 0, -0.299057583814147, 0, 0.954234980572422 }, { 0.929175117295588, 0, 0.428383747196063, 0, 1.12538914266447, 0, -0.27253079600808, 0, 0.962147063638546 }, { 0.915936312077624, 0, 0.376972998461422, 0, 1.0806806001531, 0, -0.246213251420666, 0, 0.969215667895411 }, { 0.901712056939294, 0, 0.328035013893937, 0, 1.03850918701425, 0, -0.220297623734436, 0, 0.975432711820027 }, { 0.887598476783472, 0, 0.281998814885125, 0, 0.999219728972014, 0, -0.194730847732136, 0, 0.980856714911082 }, { 0.870208119026092, 0, 0.238134107728766, 0, 0.961620611257638, 0, -0.169743004058014, 0, 0.985488370237251 }, { 0.852355673335071, 0, 0.197717426250723, 0, 0.927319720477414, 0, -0.145023851612884, 0, 0.989428155930576 }, { 0.837572104972474, 0, 0.161750032752352, 0, 0.899182091427844, 0, -0.120695088648717, 0, 0.992689645019929 }, { 0.825566168283534, 0, 0.128766860285259, 0, 0.876102440633718, 0, -0.0965671155423797, 0, 0.995326430516125 }, { 0.863514072673204, 0, 0.0628989659059247, 0, 0.865743580487994, 0, -0.0725499570155594, 0, 0.997364800120921 }, { 0.864807451187076, 0, 0.0414836771344129, 0, 0.865743580487994, 0, -0.0478151788687141, 0, 0.998856213586229 }, { 0.865565267861903, 0, 0.0202385036005293, 0, 0.865743580487994, 0, -0.0232769445490891, 0, 0.999729073175991 }, { 0.865801787656063, 0, -0.000364766204768749, 0, 0.865743580487994, 0, 0.000519832466994285, 0, 0.999999908588148 },    // Cos(theta) = 0.3701184
            { 116.097575016365, 0, 316.192415508602, 0, 499.999976251275, 0, -0.938723454836344, 0, 0.344671364315806 }, { 115.297297473033, 0, 314.015022535174, 0, 499.999976251275, 0, -0.938723268857252, 0, 0.344671675542709 }, { 107.809155747047, 0, 293.618815472454, 0, 499.999976251275, 0, -0.938719516828652, 0, 0.344681898863642 }, { 85.18252713568, 0, 231.996107013248, 0, 499.999976251276, 0, -0.938702873174609, 0, 0.344727386054545 }, { 42.7506009346448, 0, 116.428176865787, 0, 359.849954448254, 0, -0.938658381021921, 0, 0.344848381443885 }, { 27.3644013910876, 0, 74.5208124148077, 0, 230.287794880909, 0, -0.93856315743943, 0, 0.345107410362569 }, { 19.0063866909051, 0, 51.7544008796268, 0, 159.914468303092, 0, -0.938392465876748, 0, 0.345571482326305 }, { 13.967042331245, 0, 38.0258016962957, 0, 117.476038592083, 0, -0.938109991995313, 0, 0.346337466716052 }, { 10.6981216692451, 0, 29.1183979765729, 0, 89.935432657312, 0, -0.937672482281107, 0, 0.347520308870017 }, { 8.46842792994918, 0, 23.0406997121346, 0, 71.1085253218449, 0, -0.936826921598622, 0, 0.349793217031435 }, { 6.86764278791624, 0, 18.6750209210385, 0, 57.5978874937389, 0, -0.935850835558386, 0, 0.352396442319662 }, { 5.68363519733557, 0, 15.4437536505775, 0, 47.5934844556233, 0, -0.934623637272394, 0, 0.355638346879516 }, { 4.78791264289835, 0, 12.9961947340281, 0, 39.9951071966012, 0, -0.932957006520359, 0, 0.359987830148436 }, { 4.09207556636357, 0, 11.092208386206, 0, 34.0742921254685, 0, -0.930899015299604, 0, 0.365276714268369 }, { 3.54136385808945, 0, 9.58182932548564, 0, 29.3707331729524, 0, -0.928429906744414, 0, 0.371507449999159 }, { 3.10072226046235, 0, 8.36950741747037, 0, 25.568381658242, 0, -0.925420613885297, 0, 0.378941410664717 }, { 2.74146418717111, 0, 7.37660236724945, 0, 22.4470315815042, 0, -0.92189162965705, 0, 0.387447749343598 }, { 2.4490721229639, 0, 6.56308760787629, 0, 19.8514678885481, 0, -0.917682957859209, 0, 0.397313480860937 }, { 2.20938063433849, 0, 5.88954419928939, 0, 17.6476080952861, 0, -0.912873241415563, 0, 0.408243164228837 }, { 2.01391062867618, 0, 5.33165710589209, 0, 15.7548068942564, 0, -0.907296974762853, 0, 0.420490452594344 }, { 1.84911797742674, 0, 4.85328166800971, 0, 14.1209424350541, 0, -0.900905928047411, 0, 0.434014361328877 }, { 1.71472510415404, 0, 4.45021514217299, 0, 12.6803212832791, 0, -0.893749224029831, 0, 0.448566877149525 }, { 1.60582276305533, 0, 4.11107339533106, 0, 11.3973826362493, 0, -0.885636233896681, 0, 0.464379680534359 }, { 1.50896044865735, 0, 3.79748767478296, 0, 10.2788512665953, 0, -0.876600095575386, 0, 0.48121971963448 }, { 1.437034485689, 0, 3.54430552818128, 0, 9.25830832215481, 0, -0.866547280527336, 0, 0.499095053562128 }, { 1.37166725386458, 0, 3.30386141400391, 0, 8.35518939583149, 0, -0.855542091307233, 0, 0.51773329258902 }, { 1.31519245503615, 0, 3.08223659255752, 0, 7.55455216623348, 0, -0.843423526809107, 0, 0.537249293251608 }, { 1.26675256200271, 0, 2.87943853603007, 0, 6.83814542620475, 0, -0.830222656327311, 0, 0.557431969612611 }, { 1.22787641985973, 0, 2.69691190822841, 0, 6.19095444021308, 0, -0.815997495322755, 0, 0.578055451280636 }, { 1.1958109086995, 0, 2.53071337490707, 0, 5.61181206909607, 0, -0.800737289414155, 0, 0.599015778005531 }, { 1.16716924572851, 0, 2.37217318174607, 0, 5.09607776182716, 0, -0.78431492234596, 0, 0.620362871444485 }, { 1.14244534131836, 0, 2.22392263092248, 0, 4.63973350311065, 0, -0.766856716113511, 0, 0.641818382869873 }, { 1.12067761279572, 0, 2.08395412582984, 0, 4.22776483335979, 0, -0.748578435391816, 0, 0.663046193477096 }, { 1.10068066267799, 0, 1.95066993336081, 0, 3.8650548402053, 0, -0.729363886324929, 0, 0.684126041692661 }, { 1.08373005255497, 0, 1.82620814387675, 0, 3.53985803556012, 0, -0.709279244014753, 0, 0.704927628079315 }, { 1.07224100274592, 0, 1.71481778028182, 0, 3.24567459330181, 0, -0.688444854222347, 0, 0.725288690604442 }, { 1.05860008167388, 0, 1.60389681123306, 0, 2.98734491227402, 0, -0.666980848964407, 0, 0.745074786367045 }, { 1.05022472255823, 0, 1.50437753503503, 0, 2.75586297053313, 0, -0.64503432016696, 0, 0.764153607990376 }, { 1.04217692679416, 0, 1.40929637978239, 0, 2.54915122255917, 0, -0.622699539561359, 0, 0.782461023079797 }, { 1.03214905329909, 0, 1.31563459160926, 0, 2.36899442783356, 0, -0.599915151985614, 0, 0.800063696446075 }, { 1.02566825726126, 0, 1.23105427526984, 0, 2.20312434190615, 0, -0.576847427437562, 0, 0.816851904574022 }, { 1.01868481510631, 0, 1.14963497977671, 0, 2.05626526700744, 0, -0.553460308223656, 0, 0.832875562215697 }, { 1.01203037868711, 0, 1.07207168710217, 0, 1.92154892796411, 0, -0.530124885619132, 0, 0.847919555959921 }, { 1.00704357566911, 0, 0.998851188551858, 0, 1.80329612244507, 0, -0.506588056561961, 0, 0.862188245178238 }, { 0.998863796905814, 0, 0.925851566189634, 0, 1.69797344102148, 0, -0.482911106572696, 0, 0.875669305606017 }, { 0.992314584457012, 0, 0.85814175530295, 0, 1.60113589360123, 0, -0.458922643685783, 0, 0.888476287622 }, { 0.986559413077098, 0, 0.793126053196171, 0, 1.51476570291778, 0, -0.434609970739238, 0, 0.900618837562266 }, { 0.978415322482114, 0, 0.728782719199443, 0, 1.43430420180647, 0, -0.409656252720923, 0, 0.912239960500913 }, { 0.969576687210532, 0, 0.664563582199608, 0, 1.36010841008865, 0, -0.382746624319811, 0, 0.923853379412998 }, { 0.958221603304542, 0, 0.601226344053013, 0, 1.29355359236874, 0, -0.355433674759917, 0, 0.934701507828181 }, { 0.94880620900177, 0, 0.542637581279438, 0, 1.23350265426044, 0, -0.328152622859056, 0, 0.944624710795197 }, { 0.93605967286036, 0, 0.485428820120081, 0, 1.17780940614148, 0, -0.300909190545983, 0, 0.953652796517949 }, { 0.922748228924493, 0, 0.42957655303522, 0, 1.12709265272159, 0, -0.273951910690402, 0, 0.961743434158603 }, { 0.908347508245349, 0, 0.377035789055296, 0, 1.08026480767126, 0, -0.247372183476292, 0, 0.968920541629549 }, { 0.893354467027573, 0, 0.327057413861457, 0, 1.03670777124673, 0, -0.221008936737128, 0, 0.975271806018197 }, { 0.877647851975281, 0, 0.280074538150185, 0, 0.995047423610799, 0, -0.194982678203182, 0, 0.980806726227921 }, { 0.860136406342491, 0, 0.23622736039621, 0, 0.955736979584655, 0, -0.169356208794857, 0, 0.98555494189145 }, { 0.843519458156191, 0, 0.196341371561159, 0, 0.922104510678855, 0, -0.144222066573215, 0, 0.989545350567791 }, { 0.830255103404416, 0, 0.161144193603336, 0, 0.894067865759923, 0, -0.119665878161756, 0, 0.992814198704258 }, { 0.807950979263559, 0, 0.115553100098699, 0, 0.850200137519901, 0, -0.0954668145230432, 0, 0.995432610982515 }, { 0.810480531319973, 0, 0.0962219826222662, 0, 0.850200137519901, 0, -0.0716633706717378, 0, 0.997428916607646 }, { 0.864795083851831, 0, 0.0417395418347722, 0, 0.865743580487994, 0, -0.0481107036756244, 0, 0.998841958447265 }, { 0.86553322407358, 0, 0.0215650192747088, 0, 0.865743580487994, 0, -0.0248090720915661, 0, 0.999692213598797 }, { 0.865801324867423, 0, 0.000931514650255438, 0, 0.865743580487994, 0, -0.000977370304375255, 0, 0.999999521584217 },    // Cos(theta) = 0.3446712
            { 114.187990509162, 0, 339.583017988622, 0, 499.999976251275, 0, -0.947848714353661, 0, 0.318720651098821 }, { 113.201619871648, 0, 336.65125180988, 0, 499.999976251275, 0, -0.947848720878126, 0, 0.31872054384328 }, { 104.231628402506, 0, 309.988432061758, 0, 499.999976251275, 0, -0.947844337005724, 0, 0.318733526648288 }, { 81.4351408819731, 0, 242.179738356487, 0, 499.999976251276, 0, -0.947827511698082, 0, 0.31878352929275 }, { 34.4345338783198, 0, 102.403740720239, 0, 499.999976251275, 0, -0.947781573638918, 0, 0.318920308211567 }, { 25.3044324071857, 0, 75.2450346171314, 0, 249.042551298943, 0, -0.947683812067181, 0, 0.319210479744526 }, { 17.5750532560423, 0, 52.2546541544138, 0, 172.939174050398, 0, -0.947507560341877, 0, 0.319733461019351 }, { 12.9167742640981, 0, 38.3966968182904, 0, 127.043471083202, 0, -0.947216876040194, 0, 0.320593508683487 }, { 9.89666763175217, 0, 29.4098545235934, 0, 97.268962421946, 0, -0.94673453494478, 0, 0.322015072566117 }, { 7.83446503404009, 0, 23.2710166447094, 0, 76.9043360456324, 0, -0.945895616897717, 0, 0.324471087861451 }, { 6.35288851471537, 0, 18.8578402503339, 0, 62.2819514018182, 0, -0.944943987307314, 0, 0.327232350421743 }, { 5.26227407821534, 0, 15.6060772746725, 0, 51.4799911681241, 0, -0.943600651703575, 0, 0.33108580010757 }, { 4.43246762769177, 0, 13.1289075733858, 0, 43.2496893200201, 0, -0.941961766685806, 0, 0.335720262810931 }, { 3.78993849583364, 0, 11.2072785634629, 0, 36.8417349697591, 0, -0.939865410661972, 0, 0.341545126762069 }, { 3.28366909016382, 0, 9.68864431319389, 0, 31.7523259645207, 0, -0.937294745711152, 0, 0.348537781858497 }, { 2.87681321723498, 0, 8.4635022867895, 0, 27.6371147047808, 0, -0.934204165537828, 0, 0.35673872507438 }, { 2.54867169314975, 0, 7.46971299374863, 0, 24.250648553095, 0, -0.930540977764596, 0, 0.366187863705692 }, { 2.28263379852499, 0, 6.65672232963707, 0, 21.426470297538, 0, -0.926187818821753, 0, 0.37706250177846 }, { 2.06386593450293, 0, 5.97942968170984, 0, 19.0228474225609, 0, -0.921210164712373, 0, 0.389065407892918 }, { 1.88343320237432, 0, 5.41149310340286, 0, 16.9608550865671, 0, -0.915412936778414, 0, 0.402515996141213 }, { 1.73870476269843, 0, 4.94171690042136, 0, 15.1561955943165, 0, -0.908793722888617, 0, 0.417245818927432 }, { 1.61739869051242, 0, 4.53459688631415, 0, 13.5775333904045, 0, -0.90132144071488, 0, 0.433150813456632 }, { 1.51924029845238, 0, 4.18836813712769, 0, 12.1702596075974, 0, -0.892896336558369, 0, 0.450262418943854 }, { 1.43732992628698, 0, 3.88238512304307, 0, 10.9244758175577, 0, -0.883531366386621, 0, 0.468372035365496 }, { 1.36908360690734, 0, 3.61049805870493, 0, 9.81963880377378, 0, -0.873098449426268, 0, 0.487543823534878 }, { 1.30949489913414, 0, 3.35980696434381, 0, 8.83871643611888, 0, -0.861667081259978, 0, 0.507474031282985 }, { 1.26445708151486, 0, 3.14412399727295, 0, 7.94902910370581, 0, -0.849163159168238, 0, 0.528130581299845 }, { 1.22041697270372, 0, 2.93025363564839, 0, 7.1796487280463, 0, -0.8355612764836, 0, 0.549397329602595 }, { 1.18680172204612, 0, 2.74188948537706, 0, 6.47780450377622, 0, -0.820841307968403, 0, 0.571156319866622 }, { 1.15838435048812, 0, 2.5683309121571, 0, 5.85392676200818, 0, -0.805120504628493, 0, 0.593111303506969 }, { 1.13260232189564, 0, 2.40160327840288, 0, 5.29782598884439, 0, -0.788323605434967, 0, 0.615260858362271 }, { 1.10999245027344, 0, 2.24582295187337, 0, 4.80922522729983, 0, -0.770469502989685, 0, 0.637476874943686 }, { 1.09081038767191, 0, 2.10080587825004, 0, 4.37654969360892, 0, -0.751591898263573, 0, 0.659628371440744 }, { 1.07560272380925, 0, 1.96830812599991, 0, 3.98337091905694, 0, -0.731960161786059, 0, 0.681347415197986 }, { 1.06278046211007, 0, 1.84366686342077, 0, 3.63445911758105, 0, -0.711500789484349, 0, 0.702685262943496 }, { 1.04919984818771, 0, 1.72293844344079, 0, 3.33221432834687, 0, -0.690185156900469, 0, 0.723632841078956 }, { 1.04075745402809, 0, 1.61389031524076, 0, 3.05679463221954, 0, -0.668189955805394, 0, 0.743990667391902 }, { 1.03279640016347, 0, 1.5102871918745, 0, 2.81446850825268, 0, -0.645717005760761, 0, 0.763576853557474 }, { 1.02332493974852, 0, 1.40948206099773, 0, 2.59836181477639, 0, -0.622823014827628, 0, 0.782362777796626 }, { 1.01577171354189, 0, 1.31537606464739, 0, 2.40649105116421, 0, -0.599515463691803, 0, 0.800363137640757 }, { 1.01226196908622, 0, 1.23298898170579, 0, 2.23303829611929, 0, -0.575958917572251, 0, 0.817478586317825 }, { 1.00600996541861, 0, 1.15020218845856, 0, 2.08196463513386, 0, -0.552126025401804, 0, 0.833760641629552 }, { 0.997504458745403, 0, 1.06770244203845, 0, 1.94533431849887, 0, -0.528077267190471, 0, 0.849196350884189 }, { 0.995497571646046, 0, 0.996708460368606, 0, 1.82267046405121, 0, -0.504047320977323, 0, 0.863676091046989 }, { 0.986771195645125, 0, 0.922962072506903, 0, 1.71341116594227, 0, -0.480087638279668, 0, 0.877220566582888 }, { 0.980989671292806, 0, 0.853757385411865, 0, 1.61413512266666, 0, -0.455985654803168, 0, 0.88998714873016 }, { 0.976401846098177, 0, 0.790053966133011, 0, 1.52462577933124, 0, -0.431825561740841, 0, 0.901957119869018 }, { 0.968739794670933, 0, 0.726757158988529, 0, 1.44411077253564, 0, -0.407531135674847, 0, 0.913191303812487 }, { 0.960613099124144, 0, 0.664738463796382, 0, 1.37059221734329, 0, -0.38301311405413, 0, 0.923742925623336 }, { 0.951628104710365, 0, 0.603952123506673, 0, 1.30321721962297, 0, -0.357846986363757, 0, 0.933780299897198 }, { 0.941949243408993, 0, 0.545400247271502, 0, 1.24064765586105, 0, -0.330859342034816, 0, 0.943680047570921 }, { 0.92909375897195, 0, 0.486920892799743, 0, 1.18320647358857, 0, -0.303477801594071, 0, 0.952838470562912 }, { 0.916094461390704, 0, 0.431123461012781, 0, 1.13061329015139, 0, -0.276239243401264, 0, 0.961088842220674 }, { 0.902614008191886, 0, 0.378758711672942, 0, 1.08159675048102, 0, -0.249118675361209, 0, 0.968472975260849 }, { 0.887794900706086, 0, 0.328535757979048, 0, 1.03641685940871, 0, -0.222396319132478, 0, 0.97495642655033 }, { 0.871329688603984, 0, 0.280667220790322, 0, 0.992336990769131, 0, -0.19603040328306, 0, 0.980597844279891 }, { 0.854125578021845, 0, 0.236890610736653, 0, 0.952701299278467, 0, -0.170032986713408, 0, 0.985438397026634 }, { 0.838284763973189, 0, 0.196887224161541, 0, 0.918076860879943, 0, -0.14439321107462, 0, 0.989520408184947 }, { 0.824614828698782, 0, 0.160771165804165, 0, 0.888958149437224, 0, -0.119204481637729, 0, 0.992869715702324 }, { 0.802483812997335, 0, 0.115149791534056, 0, 0.84459448671752, 0, -0.0944151365138964, 0, 0.995532957628744 }, { 0.805038443383721, 0, 0.0956700442006389, 0, 0.84459448671752, 0, -0.0702634789663665, 0, 0.997528441388307 }, { 0.864858194081125, 0, 0.040412097684951, 0, 0.865743580487994, 0, -0.0465775002096254, 0, 0.998914699618126 }, { 0.865564419594648, 0, 0.0202743433095089, 0, 0.865743580487994, 0, -0.0233183394633526, 0, 0.999728097506951 }, { 0.865801742145569, 0, 0.000383288326909018, 0, 0.865743580487994, 0, -0.000344169559217618, 0, 0.999999941151956 },    // Cos(theta) = 0.31872
            { 112.171309581272, 0, 367.038846932407, 0, 499.999976251275, 0, -0.956337323625338, 0, 0.292265036566985 }, { 110.903423274908, 0, 362.931281458825, 0, 499.999976251275, 0, -0.956337002630277, 0, 0.292266365693684 }, { 100.050635098151, 0, 327.40022080393, 0, 499.999976251275, 0, -0.956333085604383, 0, 0.292278892784194 }, { 77.3897950949414, 0, 253.228050864871, 0, 499.999976251275, 0, -0.956315388866057, 0, 0.292336800477234 }, { 33.2092426152464, 0, 108.663825693815, 0, 499.999976251275, 0, -0.95626818429291, 0, 0.292491392476382 }, { 23.2041475931487, 0, 75.9173478410279, 0, 271.596572315411, 0, -0.956168006993663, 0, 0.292818423769595 }, { 16.1172440724565, 0, 52.7231266806314, 0, 188.591663973162, 0, -0.955986649502937, 0, 0.293410221164782 }, { 11.8457761557961, 0, 38.7407845377866, 0, 138.537889054545, 0, -0.955686581827923, 0, 0.294385984966348 }, { 9.08363133665719, 0, 29.6961565340537, 0, 106.128207554534, 0, -0.955103059075694, 0, 0.296273803747952 }, { 7.18705012429086, 0, 23.4827864648965, 0, 83.8637148364775, 0, -0.954347061829243, 0, 0.29869997119446 }, { 5.83071484516717, 0, 19.0358705560662, 0, 67.9174405974181, 0, -0.953365187880399, 0, 0.301819356269253 }, { 4.83056123047713, 0, 15.7532144482768, 0, 56.144617370738, 0, -0.952003500644013, 0, 0.306087173028643 }, { 4.07278707423648, 0, 13.261717799572, 0, 47.1709189199185, 0, -0.950280049613027, 0, 0.311396641369551 }, { 3.48379820108518, 0, 11.3209515198622, 0, 40.1804749121385, 0, -0.948154162360559, 0, 0.317810588540825 }, { 3.02053802600375, 0, 9.78899912665853, 0, 34.6247709022595, 0, -0.945510636978768, 0, 0.32559113025676 }, { 2.65047916568599, 0, 8.559106253444, 0, 30.1177738283808, 0, -0.94235095657183, 0, 0.334626128605679 }, { 2.35365421604733, 0, 7.56429161177267, 0, 26.4072083107762, 0, -0.938539779201884, 0, 0.345171055375734 }, { 2.11248982436459, 0, 6.74746778419167, 0, 23.2983699866849, 0, -0.934076254714456, 0, 0.357073689405903 }, { 1.91622444313058, 0, 6.07062716955518, 0, 20.6515863584832, 0, -0.928851125853963, 0, 0.370453041225328 }, { 1.75879797652612, 0, 5.51294439176138, 0, 18.3496120792719, 0, -0.922845205718944, 0, 0.385171064523518 }, { 1.62968038432679, 0, 5.03906059717803, 0, 16.3536868450767, 0, -0.91593879493258, 0, 0.401317984005812 }, { 1.52541158316798, 0, 4.63716604452041, 0, 14.5867642854892, 0, -0.908147324240298, 0, 0.418650798640888 }, { 1.43956432607225, 0, 4.28622071927722, 0, 13.0264520385433, 0, -0.89940836065969, 0, 0.437109243438053 }, { 1.3680252419215, 0, 3.9748541874038, 0, 11.6426550134548, 0, -0.889656468847674, 0, 0.456630430723826 }, { 1.30628077269193, 0, 3.68949867215466, 0, 10.4297616794323, 0, -0.878825918637369, 0, 0.477142488960284 }, { 1.25467149592447, 0, 3.4299979811333, 0, 9.35505967510066, 0, -0.866933545582341, 0, 0.498423767227284 }, { 1.21015502957875, 0, 3.19306349968609, 0, 8.39618275685337, 0, -0.853994977722811, 0, 0.520281262659277 }, { 1.17684508510539, 0, 2.98360164546502, 0, 7.53984972584571, 0, -0.839948097678707, 0, 0.54266672030841 }, { 1.14629023999815, 0, 2.78445580981107, 0, 6.77951272613386, 0, -0.824828894871612, 0, 0.565382401908319 }, { 1.12088150576885, 0, 2.60152383685784, 0, 6.11106745018163, 0, -0.808560016765793, 0, 0.588413717541909 }, { 1.09831000197002, 0, 2.42707591031578, 0, 5.51964793870675, 0, -0.791352461775983, 0, 0.611360200741603 }, { 1.07873739847348, 0, 2.26651546908538, 0, 4.99180892755938, 0, -0.773115807905643, 0, 0.634264881599172 }, { 1.06290293782353, 0, 2.11719093126896, 0, 4.52371831954094, 0, -0.753847976369957, 0, 0.65704889823525 }, { 1.05082762180871, 0, 1.98203569373551, 0, 4.10647044911558, 0, -0.733660780052438, 0, 0.679515863871393 }, { 1.0369550568697, 0, 1.84826080664071, 0, 3.74339182391508, 0, -0.712802259252048, 0, 0.701365022497392 }, { 1.02953579143764, 0, 1.73124744668325, 0, 3.41524253204397, 0, -0.6911571179338, 0, 0.722704545811823 }, { 1.01976741734955, 0, 1.61538271578985, 0, 3.13080041612665, 0, -0.668780211945537, 0, 0.743460116907816 }, { 1.01291175834258, 0, 1.51050399775288, 0, 2.87399936303823, 0, -0.645726171279619, 0, 0.763569088874741 }, { 1.00720232649229, 0, 1.41137832615332, 0, 2.64756993862312, 0, -0.622362354573172, 0, 0.782729242057496 }, { 1.00132523005582, 0, 1.31651029335652, 0, 2.44830816969609, 0, -0.598638589700032, 0, 0.801019245391501 }, { 0.995370710860692, 0, 1.22820276665052, 0, 2.26951603604462, 0, -0.574567781127044, 0, 0.818456987931647 }, { 0.992733336753522, 0, 1.14791184451266, 0, 2.10747432894309, 0, -0.550272867962087, 0, 0.83498487728925 }, { 0.98458380101409, 0, 1.06422604854139, 0, 1.96864118554246, 0, -0.525853113283224, 0, 0.850575413106452 }, { 0.980886082478241, 0, 0.990010962690183, 0, 1.84101865724413, 0, -0.501219978425544, 0, 0.865319891361358 }, { 0.974741641971837, 0, 0.916845514516951, 0, 1.72867678409261, 0, -0.47657510560616, 0, 0.879133759497241 }, { 0.968954299313463, 0, 0.848864462602241, 0, 1.62467002019066, 0, -0.452203731660198, 0, 0.891914687103536 }, { 0.965611467786556, 0, 0.785206195715716, 0, 1.5327131662807, 0, -0.427832992725349, 0, 0.903857768113419 }, { 0.957892796701777, 0, 0.720689650136435, 0, 1.45109450425265, 0, -0.403439481856203, 0, 0.915006316572712 }, { 0.95076400644589, 0, 0.660124941472273, 0, 1.37606583060842, 0, -0.379103363357001, 0, 0.925354290734296 }, { 0.941319941652742, 0, 0.600439487631405, 0, 1.3075324980987, 0, -0.354770352191895, 0, 0.934953502854933 }, { 0.932969171098124, 0, 0.544629771000822, 0, 1.2447397032224, 0, -0.330304024658297, 0, 0.943874591990271 }, { 0.923450099607048, 0, 0.4893732009966, 0, 1.18772221936656, 0, -0.305498768743406, 0, 0.952192453925186 }, { 0.910433928248651, 0, 0.434428938816368, 0, 1.1335586287038, 0, -0.279193091167583, 0, 0.960234957883142 }, { 0.898732419596032, 0, 0.381383970256299, 0, 1.08354756011157, 0, -0.251971098979303, 0, 0.967734766294622 }, { 0.882057993520371, 0, 0.330619805809777, 0, 1.03461719458663, 0, -0.224901443640097, 0, 0.974381462407659 }, { 0.86730196140524, 0, 0.283366968609817, 0, 0.991411603812373, 0, -0.198097279951784, 0, 0.980182380579025 }, { 0.849187916636565, 0, 0.237711931775421, 0, 0.94982888994041, 0, -0.171663626320864, 0, 0.98515566388301 }, { 0.833008356175128, 0, 0.197811882036883, 0, 0.914058536239094, 0, -0.145618879472873, 0, 0.989340739480835 }, { 0.819448849474562, 0, 0.161201387901762, 0, 0.884363175370113, 0, -0.119963005620297, 0, 0.992778364444994 }, { 0.807638910214288, 0, 0.127768483667078, 0, 0.859409899769043, 0, -0.0946666303575768, 0, 0.995509031882915 }, { 0.798588199365508, 0, 0.095303325149247, 0, 0.838335972840248, 0, -0.0699377409098943, 0, 0.997551394925321 }, { 0.785554367730006, 0, 0.0360780987615136, 0, 0.786426595833393, 0, -0.0455859661453518, 0, 0.998960403506072 }, { 0.786188826269813, 0, 0.0174472480825095, 0, 0.786426595833393, 0, -0.0218938855538246, 0, 0.999760270567616 }, { 0.786382096049721, 0, -0.000690125744641073, 0, 0.786426595833393, 0, 0.00117050290678623, 0, 0.999999285573489 },    // Cos(theta) = 0.2922651
            { 109.87342328449, 0, 399.313746759988, 0, 499.999976251275, 0, -0.964164259548537, 0, 0.26530578501245 }, { 108.423649775941, 0, 394.043889385702, 0, 499.999976251275, 0, -0.964163780642803, 0, 0.265307754396616 }, { 95.6784687407954, 0, 347.705938697492, 0, 499.999976251275, 0, -0.964159771267235, 0, 0.265322293564312 }, { 72.8587715053522, 0, 264.776100766009, 0, 499.999976251275, 0, -0.964141764506437, 0, 0.265387707965767 }, { 31.7962637456365, 0, 115.549205132954, 0, 499.999976251276, 0, -0.964093261362855, 0, 0.265563767805909 }, { 21.0652955624738, 0, 76.5417461574234, 0, 299.18796229536, 0, -0.963990828518103, 0, 0.265935410335974 }, { 14.6329084435524, 0, 53.1596665234882, 0, 207.745205676708, 0, -0.963804361929129, 0, 0.266610366870023 }, { 10.7561597205122, 0, 39.0641286150338, 0, 152.617210984909, 0, -0.963493532059325, 0, 0.267731850390739 }, { 8.25220768205237, 0, 29.9563609070052, 0, 116.932370979484, 0, -0.962876467986727, 0, 0.269942470544231 }, { 6.52839314908233, 0, 23.6823454162181, 0, 92.3756879477053, 0, -0.962147091033982, 0, 0.272530637873126 }, { 5.29964828594433, 0, 19.2059488682749, 0, 74.8424722954978, 0, -0.96109971674288, 0, 0.276201568206416 }, { 4.39227212786489, 0, 15.8958557508263, 0, 61.8400574285761, 0, -0.959751344976275, 0, 0.280851196152582 }, { 3.70436363008298, 0, 13.3810591807171, 0, 51.9545069144385, 0, -0.958000499198613, 0, 0.2867665642946 }, { 3.17356360807082, 0, 11.4346415685806, 0, 44.2499676453157, 0, -0.955803173484931, 0, 0.294007121059375 }, { 2.75564600872556, 0, 9.89495802782528, 0, 38.115369416095, 0, -0.953090677696828, 0, 0.302684936114161 }, { 2.42274846608672, 0, 8.65992224316764, 0, 33.1342002174049, 0, -0.949813030509994, 0, 0.312818206708161 }, { 2.15737839750715, 0, 7.66460286678325, 0, 29.0102581630408, 0, -0.94586297364434, 0, 0.324566363431668 }, { 1.94347966879767, 0, 6.84942551086422, 0, 25.5486230973669, 0, -0.941211144343616, 0, 0.337819015949301 }, { 1.77071691639785, 0, 6.17600509459415, 0, 22.5735784512465, 0, -0.935786723799489, 0, 0.352566599736216 }, { 1.63590655771202, 0, 5.62702539754955, 0, 19.9768892451098, 0, -0.929514502595772, 0, 0.368785437266233 }, { 1.52159572745503, 0, 5.14341162683873, 0, 17.7390790059093, 0, -0.922292421188404, 0, 0.386492653561593 }, { 1.43153904197051, 0, 4.7361079890996, 0, 15.7574710265647, 0, -0.914165661924846, 0, 0.405340754864932 }, { 1.3572284677203, 0, 4.37765073255222, 0, 14.0102901472151, 0, -0.905037684874918, 0, 0.425331288687935 }, { 1.29471809545499, 0, 4.05283541779462, 0, 12.4743236048593, 0, -0.894880052684963, 0, 0.446306644102249 }, { 1.24235392304579, 0, 3.76089853456624, 0, 11.1193997328683, 0, -0.883602732844346, 0, 0.468237337516613 }, { 1.20141753791163, 0, 3.50212782715699, 0, 9.91973876727221, 0, -0.87122867617669, 0, 0.490877349547333 }, { 1.16219332546815, 0, 3.25044641905991, 0, 8.86432577223649, 0, -0.857812753556923, 0, 0.513962323219241 }, { 1.13084680986151, 0, 3.0240502217885, 0, 7.93538953175095, 0, -0.843330296581009, 0, 0.537395617207516 }, { 1.10585501083264, 0, 2.81824003449698, 0, 7.11177174388673, 0, -0.82776568660302, 0, 0.561073988024215 }, { 1.08377907882471, 0, 2.62774192237597, 0, 6.38506758376808, 0, -0.811086090760388, 0, 0.584926764234712 }, { 1.06471886655742, 0, 2.44795726845647, 0, 5.74271013482108, 0, -0.79331304765762, 0, 0.608813957770852 }, { 1.04765997601581, 0, 2.27987136305426, 0, 5.18252390775618, 0, -0.774703868994426, 0, 0.632324225860472 }, { 1.03635956250619, 0, 2.13127218583087, 0, 4.67892403965732, 0, -0.755100799192528, 0, 0.655608724485578 }, { 1.02552131821025, 0, 1.99020479728298, 0, 4.23450536954904, 0, -0.734543582628288, 0, 0.678561472709369 }, { 1.01690230514033, 0, 1.8577386778734, 0, 3.85245526501414, 0, -0.713236047287296, 0, 0.700923932817745 }, { 1.00641687335834, 0, 1.73020101491131, 0, 3.51007290740312, 0, -0.691176378328011, 0, 0.722686074116738 }, { 0.999935799648952, 0, 1.61574845517456, 0, 3.20582445265152, 0, -0.668539271824055, 0, 0.743676825868261 }, { 0.994474836876408, 0, 1.50808589884004, 0, 2.93848619972313, 0, -0.645263227840277, 0, 0.763960411281575 }, { 0.986191489279396, 0, 1.40284022336645, 0, 2.70476900430183, 0, -0.621429322873249, 0, 0.783470286950329 }, { 0.984337558766196, 0, 1.31233545007178, 0, 2.49116560815981, 0, -0.597166749905633, 0, 0.802117153427241 }, { 0.979476279332734, 0, 1.22163265399802, 0, 2.30628957526731, 0, -0.572747891843958, 0, 0.819731515929464 }, { 0.975388781527083, 0, 1.1382041338302, 0, 2.13881743717291, 0, -0.54806253681098, 0, 0.836437395636806 }, { 0.971171477186495, 0, 1.05747590461302, 0, 1.99125777519825, 0, -0.523189128109392, 0, 0.852216602453626 }, { 0.969093855079834, 0, 0.984246109427294, 0, 1.85905035402346, 0, -0.498228262861561, 0, 0.867045950244448 }, { 0.963350780970333, 0, 0.911816781986781, 0, 1.74104767818523, 0, -0.473151130824365, 0, 0.880981291190034 }, { 0.957505676438031, 0, 0.84123439188427, 0, 1.63678578795039, 0, -0.448092867494818, 0, 0.89398703875781 }, { 0.952980020980267, 0, 0.776414221828721, 0, 1.5426760299326, 0, -0.423173616172699, 0, 0.906048548824929 }, { 0.945946789213324, 0, 0.712900519058972, 0, 1.4571442201985, 0, -0.398525934131351, 0, 0.917157078435966 }, { 0.939975948754784, 0, 0.652953610316979, 0, 1.37990510423432, 0, -0.374025566215965, 0, 0.927418368498476 }, { 0.932807870230357, 0, 0.595718505955792, 0, 1.30904321120929, 0, -0.349513230337004, 0, 0.936931424937678 }, { 0.924930092813138, 0, 0.540289751943225, 0, 1.2460066435386, 0, -0.325332818854328, 0, 0.945599524413999 }, { 0.915580814235825, 0, 0.486283665618394, 0, 1.18806407400443, 0, -0.301083960738343, 0, 0.953597597521927 }, { 0.903169142765636, 0, 0.433500448443061, 0, 1.13273046357863, 0, -0.27705822590544, 0, 0.96085309753644 }, { 0.893350980860026, 0, 0.383996235431648, 0, 1.08383554516766, 0, -0.25287631890567, 0, 0.967498628661503 }, { 0.877715169034396, 0, 0.333844915892379, 0, 1.03538999709358, 0, -0.228105541448671, 0, 0.973636437036273 }, { 0.861701546328059, 0, 0.285364872533312, 0, 0.989427083692406, 0, -0.201508045838749, 0, 0.979486898634955 }, { 0.84512064891038, 0, 0.240301554737248, 0, 0.947846993927101, 0, -0.174682103554846, 0, 0.984624907245593 }, { 0.827758904048433, 0, 0.199074273040363, 0, 0.910106560538978, 0, -0.148272755132561, 0, 0.988946513252518 }, { 0.813817589535389, 0, 0.162223037196819, 0, 0.879125128898431, 0, -0.122190125113167, 0, 0.992506741982614 }, { 0.801903593523229, 0, 0.128290046587879, 0, 0.853949361196819, 0, -0.0965473291789953, 0, 0.995328362368814 }, { 0.792294591956522, 0, 0.0959115781073835, 0, 0.831817489014126, 0, -0.0713453383669315, 0, 0.997451685829203 }, { 0.785521488816708, 0, 0.0367875025886716, 0, 0.786426595833393, 0, -0.046488088837025, 0, 0.998918857406759 }, { 0.7861841354925, 0, 0.0176586526391982, 0, 0.786426595833393, 0, -0.0221627190318798, 0, 0.999754384302859 }, { 0.786381695405938, 0, -0.00108596812025016, 0, 0.786426595833393, 0, 0.00167387407863606, 0, 0.999998628655247 },    // Cos(theta) = 0.2653061
            { 107.400881471518, 0, 438.591478994989, 0, 499.999976251275, 0, -0.971303443373439, 0, 0.237843776602336 }, { 105.592574058261, 0, 431.167517257209, 0, 499.999976251276, 0, -0.971303198195597, 0, 0.237844892228664 }, { 90.8196204272004, 0, 370.889112691667, 0, 499.999976251275, 0, -0.97129913176714, 0, 0.237861340156751 }, { 68.1114997571038, 0, 278.149456380051, 0, 499.999976251275, 0, -0.971280658797683, 0, 0.237936770931484 }, { 30.1195288161842, 0, 122.996610114567, 0, 499.999976251275, 0, -0.971230930518749, 0, 0.238139378183874 }, { 18.8849051428141, 0, 77.1058034395884, 0, 333.714778699586, 0, -0.971126118805266, 0, 0.238566765889629 }, { 13.1579110271162, 0, 53.8723671949095, 0, 231.189982151099, 0, -0.970935163555432, 0, 0.23934252523603 }, { 9.65031411050101, 0, 39.3776242064164, 0, 170.336668721009, 0, -0.970562956936717, 0, 0.240847861060695 }, { 7.40155294443445, 0, 30.1837126857597, 0, 130.448350768531, 0, -0.969996847658773, 0, 0.243117699573248 }, { 5.85767592414688, 0, 23.8668428764966, 0, 103.048345989971, 0, -0.969252631137229, 0, 0.246067967687443 }, { 4.75848692948342, 0, 19.3638746329136, 0, 83.4749054244536, 0, -0.968190118889156, 0, 0.250215540999338 }, { 3.94666005189951, 0, 16.0320183423801, 0, 68.9926025455179, 0, -0.966789329455582, 0, 0.255574439693926 }, { 3.33280836250202, 0, 13.5057208658325, 0, 57.9427490247747, 0, -0.965017384346848, 0, 0.262185797437116 }, { 2.85912177513028, 0, 11.5481916290899, 0, 49.3377571608832, 0, -0.962742142846993, 0, 0.27042119192956 }, { 2.48729398023107, 0, 10.0014475723897, 0, 42.4645972505323, 0, -0.959969004522552, 0, 0.280106175426056 }, { 2.19409768615085, 0, 8.76997352744149, 0, 36.8624173968, 0, -0.956555422088888, 0, 0.291550438081669 }, { 1.96181073332951, 0, 7.77847568473482, 0, 32.2052111893681, 0, -0.95245262487257, 0, 0.304686762897869 }, { 1.77669935072549, 0, 6.96894134619961, 0, 28.2598966604809, 0, -0.947596930797114, 0, 0.319468336938826 }, { 1.63288260191614, 0, 6.31305919335699, 0, 24.8448560984592, 0, -0.941934015653795, 0, 0.335797872738955 }, { 1.5157263971708, 0, 5.75502878958922, 0, 21.8990884975536, 0, -0.93535000168204, 0, 0.353723585917134 }, { 1.41662094678966, 0, 5.25938565764382, 0, 19.3566481820382, 0, -0.92778498669262, 0, 0.37311547123791 }, { 1.34026535751048, 0, 4.84324923303266, 0, 17.1026629431575, 0, -0.919258671728223, 0, 0.39365397085511 }, { 1.27763005484506, 0, 4.47461189900468, 0, 15.1167928970042, 0, -0.909717697798595, 0, 0.415227245529721 }, { 1.22547828344021, 0, 4.13833443593256, 0, 13.393626631327, 0, -0.899083048149991, 0, 0.437778070980757 }, { 1.18290449031194, 0, 3.83790459123108, 0, 11.8721186146908, 0, -0.887337256244575, 0, 0.461121077681717 }, { 1.14385687541873, 0, 3.55271915829203, 0, 10.5564959499252, 0, -0.874484886535116, 0, 0.485052821663215 }, { 1.11465792775859, 0, 3.30044275829583, 0, 9.38371778303081, 0, -0.860531992647384, 0, 0.509396473190727 }, { 1.08911874825381, 0, 3.06566285822027, 0, 8.36276624002483, 0, -0.845564937447663, 0, 0.5338724919882 }, { 1.06687550819921, 0, 2.84726735791987, 0, 7.45854393264408, 0, -0.829540412285143, 0, 0.558446732532099 }, { 1.04815127160295, 0, 2.64848230464266, 0, 6.67526353439, 0, -0.812441730378526, 0, 0.58304235744244 }, { 1.03211121671346, 0, 2.46332786674965, 0, 5.98794642508464, 0, -0.794309358008131, 0, 0.607513472300766 }, { 1.01781045669393, 0, 2.29001608803393, 0, 5.38546801004404, 0, -0.775179690483385, 0, 0.631740813638503 }, { 1.0087942558745, 0, 2.13659616361045, 0, 4.85127078165986, 0, -0.755219759277542, 0, 0.655471735774067 }, { 0.998094317423948, 0, 1.9871973826064, 0, 4.38105391301241, 0, -0.734385249416399, 0, 0.678732924710234 }, { 0.990921061420802, 0, 1.85301898499775, 0, 3.96569720967693, 0, -0.712782905067407, 0, 0.701384709076313 }, { 0.986402455064805, 0, 1.72936873023346, 0, 3.6055576480731, 0, -0.690457961977186, 0, 0.72337254193465 }, { 0.976682258437864, 0, 1.6063665490343, 0, 3.29123906772256, 0, -0.667425624972601, 0, 0.744676395880208 }, { 0.975595897624263, 0, 1.50330510859897, 0, 3.00289518909257, 0, -0.643888596855127, 0, 0.765119259502728 }, { 0.971836403495109, 0, 1.40230826999719, 0, 2.75352852568526, 0, -0.619899373148874, 0, 0.784681296166276 }, { 0.967702562530319, 0, 1.30550438587388, 0, 2.53587887392902, 0, -0.595431927485322, 0, 0.80340576660187 }, { 0.96700969557774, 0, 1.22037531996978, 0, 2.33777625014737, 0, -0.570604417621917, 0, 0.821225095579323 }, { 0.962768043285878, 0, 1.13350185082663, 0, 2.16695618689584, 0, -0.545445545461136, 0, 0.838146244815532 }, { 0.95764983605341, 0, 1.05036704828475, 0, 2.0157489509571, 0, -0.520270811410611, 0, 0.854001321875634 }, { 0.953833990747339, 0, 0.974202807401522, 0, 1.87929174270967, 0, -0.495034459208895, 0, 0.868873310652493 }, { 0.951397965224166, 0, 0.904339604693792, 0, 1.75683212139928, 0, -0.469625318471615, 0, 0.882865779717193 }, { 0.946123782432054, 0, 0.834302183913476, 0, 1.64770556505539, 0, -0.444165293814443, 0, 0.89594490277155 }, { 0.942456175829313, 0, 0.76932220320692, 0, 1.54893005166756, 0, -0.418826316182089, 0, 0.908066406398301 }, { 0.935790344070303, 0, 0.705352492769036, 0, 1.46179064094088, 0, -0.393514113179804, 0, 0.919318515556755 }, { 0.929391883098994, 0, 0.644869546566311, 0, 1.38259994629887, 0, -0.368402140261672, 0, 0.929666470778079 }, { 0.92186016731353, 0, 0.587639278799022, 0, 1.31069256064924, 0, -0.343704273389444, 0, 0.939077968280835 }, { 0.9147751585742, 0, 0.533286196240107, 0, 1.24523720778639, 0, -0.319155579416784, 0, 0.947702393667966 }, { 0.904811953734188, 0, 0.479282061789414, 0, 1.18515248505936, 0, -0.294852433590935, 0, 0.95554279633597 }, { 0.894323864451994, 0, 0.42769399779857, 0, 1.13044219650169, 0, -0.270674107387666, 0, 0.962671034122078 }, { 0.8832097931381, 0, 0.378454413548065, 0, 1.07989885287704, 0, -0.246927672455185, 0, 0.969033931344811 }, { 0.869062389853838, 0, 0.330492420789332, 0, 1.0308629930833, 0, -0.22303784941699, 0, 0.974809740975167 }, { 0.8542785336603, 0, 0.284489200991954, 0, 0.985096454359631, 0, -0.199579636866023, 0, 0.979881636413615 }, { 0.839051444895021, 0, 0.241298493698758, 0, 0.943211314470284, 0, -0.176142956021574, 0, 0.984364625831137 }, { 0.822989641970047, 0, 0.201214214747499, 0, 0.905316671818399, 0, -0.152210022547948, 0, 0.988348157240954 }, { 0.808695617401517, 0, 0.163822410194722, 0, 0.873745194009371, 0, -0.12643414571754, 0, 0.991974996571148 }, { 0.796306291708888, 0, 0.129789599212978, 0, 0.847390306748929, 0, -0.10034813847923, 0, 0.994952392160007 }, { 0.785368089558373, 0, 0.0969355517720964, 0, 0.824603557398506, 0, -0.0746663933233784, 0, 0.997208602322425 }, { 0.779487453621912, 0, 0.0642899830431402, 0, 0.804714573497367, 0, -0.0493989758446096, 0, 0.998779072728123 }, { 0.786139682474412, 0, 0.0195390041894199, 0, 0.786426595833393, 0, -0.0245538768675716, 0, 0.999698556189303 }, { 0.786382330999697, 0, 0.000356593091592187, 0, 0.786426595833393, 0, -0.000160552688111755, 0, 0.999999974222834 },    // Cos(theta) = 0.2378433
            { 104.93931225354, 0, 488.863705539414, 0, 499.999976251275, 0, -0.977727852302554, 0, 0.209876795342142 }, { 104.93943374071, 0, 488.863702124931, 0, 499.999976251275, 0, -0.977727640944398, 0, 0.209877991137337 }, { 85.3255917346209, 0, 397.491886752248, 0, 499.999976251275, 0, -0.977723279663226, 0, 0.209898137437506 }, { 62.831870022142, 0, 292.683860962501, 0, 499.999976251276, 0, -0.977704509755091, 0, 0.209985563746924 }, { 28.1826823337399, 0, 131.28356973103, 0, 499.999976251276, 0, -0.977653705175376, 0, 0.210221921370615 }, { 16.738038228976, 0, 77.9202048465164, 0, 377.576803230786, 0, -0.977546752075222, 0, 0.210718646769718 }, { 11.5791620187742, 0, 53.9113788404686, 0, 262.598935726255, 0, -0.977350944593224, 0, 0.211624963848751 }, { 8.52335434779794, 0, 39.6642933397929, 0, 193.080980395529, 0, -0.976945599927993, 0, 0.213488302112263 }, { 6.53468843290098, 0, 30.3860993058746, 0, 147.821356830346, 0, -0.97641324998585, 0, 0.21590994470925 }, { 5.17771455032549, 0, 24.0489029454342, 0, 116.806343124793, 0, -0.975625653208065, 0, 0.21944143455206 }, { 4.20755721754465, 0, 19.5100280838904, 0, 94.6092665499688, 0, -0.974563599629328, 0, 0.224110977285165 }, { 3.4930975243425, 0, 16.1602427680998, 0, 78.1772715732026, 0, -0.973146681723813, 0, 0.230186148986451 }, { 2.95474645380527, 0, 13.6252914495708, 0, 65.6459999962801, 0, -0.971314522929013, 0, 0.23779825247897 }, { 2.54039870285833, 0, 11.6628112669986, 0, 55.8463461458767, 0, -0.968988999302898, 0, 0.24710395571326 }, { 2.21965428685983, 0, 10.1290229289669, 0, 47.9905895340023, 0, -0.96608672381531, 0, 0.258217776049793 }, { 1.96801764141007, 0, 8.90463767126871, 0, 41.5562920242854, 0, -0.96253647636505, 0, 0.271152157965182 }, { 1.77234962109424, 0, 7.92987093326249, 0, 36.1597741522364, 0, -0.95824445591481, 0, 0.285950521336871 }, { 1.61842963808129, 0, 7.1322778718431, 0, 31.5505132129428, 0, -0.953167199170928, 0, 0.302443861670215 }, { 1.49447566314085, 0, 6.45831563940208, 0, 27.6128930281706, 0, -0.947189522969695, 0, 0.3206742248452 }, { 1.4002019101615, 0, 5.9055702250139, 0, 24.1495270063669, 0, -0.940249919656841, 0, 0.340484984901752 }, { 1.31878876852126, 0, 5.40122181098601, 0, 21.2146160194942, 0, -0.932272643547064, 0, 0.361756568347709 }, { 1.25543864757902, 0, 4.96665728516876, 0, 18.6178290861078, 0, -0.923320516006181, 0, 0.384030385096185 }, { 1.20063289418922, 0, 4.56913479345196, 0, 16.3841738689053, 0, -0.913277230123197, 0, 0.407338426559302 }, { 1.16063994773907, 0, 4.2276762208243, 0, 14.4082217730463, 0, -0.902129198888834, 0, 0.431465879019972 }, { 1.12005665274001, 0, 3.89140009143599, 0, 12.7242525969019, 0, -0.88988416703319, 0, 0.456186469111609 }, { 1.08617014076066, 0, 3.58661687971759, 0, 11.2602260849014, 0, -0.876505924595766, 0, 0.48139101700976 }, { 1.0621751482918, 0, 3.32459429058919, 0, 9.96101852315433, 0, -0.862025504686725, 0, 0.506864908498921 }, { 1.04128903189542, 0, 3.07918700437239, 0, 8.83625837986598, 0, -0.846521912028299, 0, 0.532353876777973 }, { 1.02378472046212, 0, 2.85600581550234, 0, 7.85427615533576, 0, -0.830037607556739, 0, 0.557707438147509 }, { 1.01232962985423, 0, 2.65692410288056, 0, 6.98557906735018, 0, -0.812530115927463, 0, 0.582919293937599 }, { 0.998015862120151, 0, 2.46364577787915, 0, 6.24946729728357, 0, -0.794016911791406, 0, 0.607895683126191 }, { 0.987345592235923, 0, 2.28951781365381, 0, 5.59574098819348, 0, -0.774588363278066, 0, 0.632465782559848 }, { 0.979858533670984, 0, 2.13031408116974, 0, 5.02447580398591, 0, -0.754247695635383, 0, 0.65658995932259 }, { 0.97039149317527, 0, 1.9768290204108, 0, 4.53004197496056, 0, -0.73306729554814, 0, 0.680156076320686 }, { 0.966300768999106, 0, 1.84364326798266, 0, 4.09233132534557, 0, -0.711267602754591, 0, 0.702921343017095 }, { 0.965003217887128, 0, 1.72445189638892, 0, 3.70391233882666, 0, -0.688722801159233, 0, 0.725024772266851 }, { 0.961151101355046, 0, 1.60676301912431, 0, 3.36885531313643, 0, -0.665612821657495, 0, 0.746297245691681 }, { 0.956966365167644, 0, 1.49444668984474, 0, 3.07536325778652, 0, -0.641892802681859, 0, 0.766794397726441 }, { 0.954978931730833, 0, 1.39328203040011, 0, 2.81368686036626, 0, -0.617627110592087, 0, 0.786471102395818 }, { 0.954877507428201, 0, 1.30143160914949, 0, 2.58119942598507, 0, -0.593002240253267, 0, 0.805200788752809 }, { 0.950662377099139, 0, 1.20864070559345, 0, 2.37931460068891, 0, -0.568095323143367, 0, 0.822962756173367 }, { 0.947054082168439, 0, 1.12265327759544, 0, 2.20024616288919, 0, -0.542909164692602, 0, 0.839791447033639 }, { 0.947013078205919, 0, 1.04615963156085, 0, 2.03812876406182, 0, -0.51741868176894, 0, 0.855732380010367 }, { 0.942006653665667, 0, 0.967286847014244, 0, 1.89729216625406, 0, -0.491647940150961, 0, 0.870794077679305 }, { 0.937843853338625, 0, 0.894053019325313, 0, 1.77197209401905, 0, -0.466007188457779, 0, 0.884780916042031 }, { 0.936373134016508, 0, 0.828533675752923, 0, 1.65809162499486, 0, -0.440439673741408, 0, 0.897782211556693 }, { 0.930993434370037, 0, 0.761296171478516, 0, 1.5576677549719, 0, -0.414803364324255, 0, 0.909911049130482 }, { 0.92462867073522, 0, 0.697873982546667, 0, 1.46608994613971, 0, -0.389112089255823, 0, 0.921190379929366 }, { 0.91821445346359, 0, 0.637476686360958, 0, 1.38534611837806, 0, -0.363596916246274, 0, 0.931556420509377 }, { 0.909811186066699, 0, 0.579200382654625, 0, 1.30949151103793, 0, -0.338210861855506, 0, 0.941070325235093 }, { 0.903518369104883, 0, 0.524736049030747, 0, 1.24309538317601, 0, -0.313082803877565, 0, 0.949725865754273 }, { 0.892983360437275, 0, 0.471066927199342, 0, 1.18228473105626, 0, -0.288223737367711, 0, 0.957563082075671 }, { 0.8822234166721, 0, 0.419202055139925, 0, 1.12600490119423, 0, -0.263788047006912, 0, 0.964580615065917 }, { 0.871808425271656, 0, 0.371037692905427, 0, 1.07278002048907, 0, -0.239655899083527, 0, 0.970857866251351 }, { 0.859395135443987, 0, 0.324408058061508, 0, 1.02403422978982, 0, -0.215797459097575, 0, 0.976438195059212 }, { 0.844565697730349, 0, 0.279075343159788, 0, 0.977756920152478, 0, -0.192190159469576, 0, 0.981357714518936 }, { 0.827743573233182, 0, 0.236273942734712, 0, 0.934028824500252, 0, -0.168948966792677, 0, 0.985624810657913 }, { 0.81348005721885, 0, 0.197614048536232, 0, 0.897294934750995, 0, -0.145858201484169, 0, 0.98930551710542 }, { 0.800261036553171, 0, 0.16215311010761, 0, 0.865514046931738, 0, -0.123046233034673, 0, 0.992400934430446 }, { 0.788301829545509, 0, 0.129453411097142, 0, 0.839623627623941, 0, -0.100513382115263, 0, 0.994935661068071 }, { 0.777522206771844, 0, 0.0981204131761127, 0, 0.816417637020608, 0, -0.0779109712444511, 0, 0.996960298713682 }, { 0.770156613520833, 0, 0.0666529894191328, 0, 0.795664290394066, 0, -0.0545634631219187, 0, 0.998510308207964 }, { 0.764050881719064, 0, 0.0342450171569997, 0, 0.776841524905581, 0, -0.0296332820425863, 0, 0.999560842763311 }, { 0.759616038259954, 0, 0.00244925087371651, 0, 0.75953302492873, 0, -0.00466959509109701, 0, 0.999989102413032 },    // Cos(theta) = 0.2098765
            { 90.7039815879263, 0, 491.703940783727, 0, 499.999976251275, 0, -0.983408337400158, 0, 0.1814057539172 }, { 90.7028601511583, 0, 491.70413629415, 0, 499.999976251275, 0, -0.983408055046705, 0, 0.18140716142295 }, { 79.4558040643242, 0, 430.717743717093, 0, 499.999976251276, 0, -0.983403638868442, 0, 0.181431251692479 }, { 57.242697386082, 0, 310.306989671125, 0, 499.999976251275, 0, -0.983384457983306, 0, 0.181535219276097 }, { 25.9395306557064, 0, 140.543626204984, 0, 499.999976251275, 0, -0.983332935355019, 0, 0.181814030433994 }, { 13.4262459986305, 0, 72.7727762091921, 0, 499.999976251276, 0, -0.983223853977792, 0, 0.182403157996641 }, { 10.0146351407414, 0, 54.2473608472442, 0, 303.848604019492, 0, -0.983010378892954, 0, 0.18354988983849 }, { 7.37422242647957, 0, 39.9175929098574, 0, 223.38206677315, 0, -0.982614311312632, 0, 0.185658524283227 }, { 5.65793829861502, 0, 30.5951045747509, 0, 171.020412544175, 0, -0.982067965919134, 0, 0.188526954716638 }, { 4.48285351061735, 0, 24.2033313432134, 0, 135.13284124655, 0, -0.981286135631536, 0, 0.192555152959472 }, { 3.64961725562432, 0, 19.6592523752371, 0, 109.465003912044, 0, -0.980194556158897, 0, 0.198037067636982 }, { 3.03515448021752, 0, 16.2970994472256, 0, 90.4146479855416, 0, -0.978751786792473, 0, 0.205048945414243 }, { 2.57384273573637, 0, 13.7572966617744, 0, 75.870911056142, 0, -0.976857290260692, 0, 0.213891789883672 }, { 2.22409275648937, 0, 11.8123742612531, 0, 64.4369543673147, 0, -0.974442769740855, 0, 0.224636014746441 }, { 1.95578798560228, 0, 10.2955111266001, 0, 55.1721230421003, 0, -0.971425623485787, 0, 0.237344242654868 }, { 1.75092024032657, 0, 9.10340673804104, 0, 47.5089888152291, 0, -0.967684828524969, 0, 0.252162715229117 }, { 1.5873474608666, 0, 8.11646994015244, 0, 41.1042157348681, 0, -0.963166533976733, 0, 0.268905609588163 }, { 1.46168271235035, 0, 7.31278241581389, 0, 35.6246315090159, 0, -0.957782038672305, 0, 0.287495240150337 }, { 1.36816641516637, 0, 6.65855697274807, 0, 30.8723649058315, 0, -0.951438546159251, 0, 0.307838846649789 }, { 1.28647423975964, 0, 6.05692797412802, 0, 26.863344675274, 0, -0.944058552891917, 0, 0.329777711133123 }, { 1.22328338818184, 0, 5.54226401376159, 0, 23.3774993341139, 0, -0.935630969775358, 0, 0.352979716855213 }, { 1.17200889234076, 0, 5.08352519662428, 0, 20.3778128955104, 0, -0.926145303085389, 0, 0.377166892136987 }, { 1.12552765581014, 0, 4.65270198719378, 0, 17.808108428561, 0, -0.91554745299726, 0, 0.402209921264086 }, { 1.09349950691479, 0, 4.2893938215145, 0, 15.5741492742338, 0, -0.903854094859872, 0, 0.427840781655572 }, { 1.06298448727202, 0, 3.94491035384418, 0, 13.6466193845194, 0, -0.891032982779548, 0, 0.453938628155821 }, { 1.03771227339167, 0, 3.63199110930823, 0, 12.001076652179, 0, -0.877123745450186, 0, 0.480264410139302 }, { 1.01766259262991, 0, 3.35169570443437, 0, 10.5654007372484, 0, -0.8621207370617, 0, 0.506702893758933 }, { 1.00059576049135, 0, 3.09471332257401, 0, 9.33137926957043, 0, -0.846085733002743, 0, 0.533046845267883 }, { 0.986273639236537, 0, 2.86284749432192, 0, 8.25951280157658, 0, -0.829097483723237, 0, 0.55910410785861 }, { 0.976746731223927, 0, 2.65451763335334, 0, 7.32339315852252, 0, -0.81118965875395, 0, 0.584783099112991 }, { 0.9665259276187, 0, 2.46127955064425, 0, 6.51845939454154, 0, -0.792348917362643, 0, 0.610068244880494 }, { 0.955943908857528, 0, 2.27523746209354, 0, 5.82075118646418, 0, -0.772641763882629, 0, 0.63484231395424 }, { 0.952183638141101, 0, 2.11819701377641, 0, 5.20872886294825, 0, -0.752108594042118, 0, 0.65903921699001 }, { 0.947796777453851, 0, 1.96995679616268, 0, 4.67613794405373, 0, -0.730765285050989, 0, 0.682628756542555 }, { 0.947365932958079, 0, 1.84191468182795, 0, 4.20934561282513, 0, -0.708698164442576, 0, 0.705511819292956 }, { 0.944337752763375, 0, 1.71292345726725, 0, 3.81024977377735, 0, -0.685965491617065, 0, 0.727634086302212 }, { 0.939239459787884, 0, 1.5904309989998, 0, 3.45862447951471, 0, -0.662766075994074, 0, 0.748826477787372 }, { 0.935175265885328, 0, 1.47712526350609, 0, 3.15050978122662, 0, -0.6390486839694, 0, 0.769166276804323 }, { 0.937022288340805, 0, 1.38222334345111, 0, 2.87187476181376, 0, -0.614884482642437, 0, 0.788617176906862 }, { 0.933830425023459, 0, 1.28284621859298, 0, 2.63533131394845, 0, -0.590249316759686, 0, 0.807221018342438 }, { 0.931440791376095, 0, 1.19234162442051, 0, 2.42281052704163, 0, -0.565208283326451, 0, 0.824948203778764 }, { 0.933182784968703, 0, 1.11205394650967, 0, 2.23588014969097, 0, -0.539799081586346, 0, 0.841793875097091 }, { 0.931558077422808, 0, 1.03337545934178, 0, 2.06676755048608, 0, -0.514397878377546, 0, 0.85755166566009 }, { 0.924715334538956, 0, 0.95244253425039, 0, 1.92178093375297, 0, -0.48880904615662, 0, 0.872390801369203 }, { 0.926654196092529, 0, 0.886609742225285, 0, 1.78786827417996, 0, -0.462988468157768, 0, 0.886364342316534 }, { 0.921129779431745, 0, 0.815534241116746, 0, 1.67194952104129, 0, -0.437016708064, 0, 0.899453365596694 }, { 0.917517100667201, 0, 0.750730489545429, 0, 1.56571310440043, 0, -0.410961700478962, 0, 0.911652587143303 }, { 0.913046149514244, 0, 0.689784829365006, 0, 1.47201882952519, 0, -0.385174890967289, 0, 0.922843541334245 }, { 0.906482803752645, 0, 0.62886560207993, 0, 1.38656224224766, 0, -0.359507034336068, 0, 0.933142390105585 }, { 0.898137728608451, 0, 0.570478312766613, 0, 1.31048542322832, 0, -0.333904715802269, 0, 0.942606789031726 }, { 0.891651355209849, 0, 0.516686861984263, 0, 1.23976040548529, 0, -0.308403982192902, 0, 0.951255449668612 }, { 0.881920601242897, 0, 0.46390811339505, 0, 1.17716952260759, 0, -0.282966951222602, 0, 0.959129622740548 }, { 0.870992107153337, 0, 0.411820000132887, 0, 1.11832534224621, 0, -0.257897816797436, 0, 0.966172243200876 }, { 0.859675943251192, 0, 0.36354452701377, 0, 1.06471212537282, 0, -0.233119388887871, 0, 0.972448068531737 }, { 0.847244155214182, 0, 0.3169747951757, 0, 1.01373434209123, 0, -0.208594943763585, 0, 0.978002110872555 }, { 0.833400039780587, 0, 0.272335889981565, 0, 0.966268141621898, 0, -0.184502807668859, 0, 0.982832020638218 }, { 0.816011473728195, 0, 0.229702772460911, 0, 0.921784548181859, 0, -0.160785235500298, 0, 0.98698939301727 }, { 0.800859231096449, 0, 0.191617138525649, 0, 0.88368927080084, 0, -0.137427105337052, 0, 0.990511933642575 }, { 0.785934030624199, 0, 0.156410816881701, 0, 0.851815169583243, 0, -0.114465282378116, 0, 0.993427220721548 }, { 0.768914859993312, 0, 0.124144794853067, 0, 0.825354864150757, 0, -0.0917735310080326, 0, 0.995779938427805 }, { 0.760142915381404, 0, 0.0932711257018048, 0, 0.802875542239739, 0, -0.0694469877711845, 0, 0.997585692592201 }, { 0.755811662722759, 0, 0.0625630603418257, 0, 0.783004738852192, 0, -0.0474489974992139, 0, 0.998873673020977 }, { 0.752084521059533, 0, 0.0319806139258569, 0, 0.764891522690429, 0, -0.0256556614181878, 0, 0.999670815507528 }, { 0.747405642819374, 0, 0.0022558506026366, 0, 0.74772998881275, 0, -0.00452639681840429, 0, 0.99998976362612 },    // Cos(theta) = 0.1814059
            { 76.2167404291781, 0, 494.156833343404, 0, 499.999976251275, 0, -0.988314057406515, 0, 0.152431259159648 }, { 76.2167676778199, 0, 494.156841479301, 0, 499.999976251275, 0, -0.988313867199847, 0, 0.152432652403556 }, { 76.2182802414523, 0, 494.156638027991, 0, 499.999976251276, 0, -0.988309453207808, 0, 0.152461653051212 }, { 51.1196170061156, 0, 331.424830649721, 0, 499.999976251275, 0, -0.98828982458981, 0, 0.152588381054187 }, { 23.3762814761598, 0, 151.529250297055, 0, 499.999976251276, 0, -0.988237450441439, 0, 0.152927078058686 }, { 12.3428321277881, 0, 80.0046209769927, 0, 499.999976251275, 0, -0.988126284311332, 0, 0.153643719027858 }, { 8.42860425554889, 0, 54.5874322772366, 0, 361.845696193175, 0, -0.987876030628094, 0, 0.155244906900655 }, { 6.20163091894357, 0, 40.1254528830117, 0, 265.819147695578, 0, -0.987522249989463, 0, 0.157479366978537 }, { 4.76434864466003, 0, 30.7789645692684, 0, 203.572605665613, 0, -0.986958952711359, 0, 0.160972039329744 }, { 3.78136101306036, 0, 24.3728187857763, 0, 160.848463434603, 0, -0.986160228286006, 0, 0.165795278258105 }, { 3.083837687266, 0, 19.8102889229703, 0, 130.232808919605, 0, -0.985056575509427, 0, 0.172230888282397 }, { 2.57447912830328, 0, 16.4582560718691, 0, 107.477644458749, 0, -0.983560648102861, 0, 0.180577842236544 }, { 2.19680335657561, 0, 13.94587741646, 0, 89.9750186810424, 0, -0.98159988450612, 0, 0.190949428439825 }, { 1.91245261587534, 0, 12.0202390894402, 0, 76.0693665549187, 0, -0.97907518130592, 0, 0.20349883781723 }, { 1.70066234387385, 0, 10.538520509049, 0, 64.7360244364827, 0, -0.975862608870565, 0, 0.218385335786649 }, { 1.53692584293726, 0, 9.33893583994562, 0, 55.320923197548, 0, -0.971903442336355, 0, 0.235379770621775 }, { 1.41356611069817, 0, 8.37042792338501, 0, 47.3557469314569, 0, -0.967072573853418, 0, 0.254500573546754 }, { 1.32158964801376, 0, 7.57363610533675, 0, 40.5643320609389, 0, -0.96129337462012, 0, 0.27552692102072 }, { 1.24272025463421, 0, 6.85307547835559, 0, 34.8685534299613, 0, -0.954479369751313, 0, 0.298276892935085 }, { 1.18260057792361, 0, 6.23580214078474, 0, 30.0199757179922, 0, -0.946595347524075, 0, 0.322424176239471 }, { 1.13313464044328, 0, 5.68163825693067, 0, 25.89142970221, 0, -0.937595292454655, 0, 0.347728507234022 }, { 1.09047503827346, 0, 5.17665583440678, 0, 22.3725646243147, 0, -0.927501877026906, 0, 0.373818524689721 }, { 1.05417445226737, 0, 4.71915685718558, 0, 19.4281418166287, 0, -0.916296045869226, 0, 0.400501686207805 }, { 1.02909417174715, 0, 4.33075492104706, 0, 16.8426488105633, 0, -0.903974224755696, 0, 0.427586938038157 }, { 1.00755409700421, 0, 3.97472198426822, 0, 14.6595161253374, 0, -0.890568586155673, 0, 0.454848870671755 }, { 0.987887286549987, 0, 3.64845517157831, 0, 12.8167546392622, 0, -0.876091085874958, 0, 0.482145587245305 }, { 0.971871416617509, 0, 3.35369503329331, 0, 11.2275695015781, 0, -0.860578390000759, 0, 0.509317977678263 }, { 0.958158221445584, 0, 3.08748019546905, 0, 9.8588748313239, 0, -0.844080312475205, 0, 0.536216687514556 }, { 0.946813702349446, 0, 2.84741623910114, 0, 8.69088230520085, 0, -0.826648455071411, 0, 0.562718676733798 }, { 0.938505245572996, 0, 2.63146936194801, 0, 7.68031585214298, 0, -0.808297337652814, 0, 0.588774503407349 }, { 0.934264560235147, 0, 2.44189654622085, 0, 6.80309908469506, 0, -0.789169296131359, 0, 0.614175771312841 }, { 0.930203663800963, 0, 2.26471519743517, 0, 6.05285149054317, 0, -0.769254170883654, 0, 0.63894291632162 }, { 0.924080359442698, 0, 2.09810874265349, 0, 5.403792778425, 0, -0.748577596642536, 0, 0.663047196150925 }, { 0.926284601194443, 0, 1.96180028046909, 0, 4.82729892569051, 0, -0.727179873493409, 0, 0.68644701022901 }, { 0.923092696018771, 0, 1.82082999054415, 0, 4.34581658015483, 0, -0.705125002780906, 0, 0.709083049377363 }, { 0.920754357412502, 0, 1.69009448051095, 0, 3.92423177445916, 0, -0.682445384113539, 0, 0.730936626276411 }, { 0.918668784513321, 0, 1.57266388448295, 0, 3.55318792503088, 0, -0.659180748375106, 0, 0.751984522948661 }, { 0.921848896283158, 0, 1.47062042394813, 0, 3.22381179394333, 0, -0.635372537471386, 0, 0.772205719424744 }, { 0.919217364177991, 0, 1.36581344599229, 0, 2.9442132763236, 0, -0.611209338016471, 0, 0.791468984497963 }, { 0.917028233961872, 0, 1.2679748290936, 0, 2.69201245688879, 0, -0.586785219457225, 0, 0.809742577909913 }, { 0.920036887386223, 0, 1.18634083116371, 0, 2.46580417899747, 0, -0.562006506725127, 0, 0.827132782198304 }, { 0.916415860061661, 0, 1.09784850472065, 0, 2.27454668123557, 0, -0.536900429813605, 0, 0.843645583702879 }, { 0.912685842972786, 0, 1.01597907994445, 0, 2.09762343428451, 0, -0.511496744405476, 0, 0.859285171739544 }, { 0.913866438371661, 0, 0.945210175233629, 0, 1.94647103029983, 0, -0.485862899825698, 0, 0.874034987145694 }, { 0.912377150197521, 0, 0.875089946081813, 0, 1.80795079766186, 0, -0.460020350098664, 0, 0.88790842900626 }, { 0.908610586654786, 0, 0.808436463516313, 0, 1.68458046168305, 0, -0.434202500571608, 0, 0.900815263555989 }, { 0.907031814796501, 0, 0.744391313404631, 0, 1.57509547424306, 0, -0.408415036319983, 0, 0.912796282485934 }, { 0.898439811785856, 0, 0.679086022091342, 0, 1.47632723441508, 0, -0.38251411016872, 0, 0.92394963718094 }, { 0.8948912040941, 0, 0.623064647828372, 0, 1.38693434562653, 0, -0.356572667701393, 0, 0.93426760639041 }, { 0.887485681337652, 0, 0.564461593846947, 0, 1.30809652370358, 0, -0.330668260806513, 0, 0.943746990239929 }, { 0.880412385000986, 0, 0.510485830356836, 0, 1.23454677654398, 0, -0.304819326383159, 0, 0.952410161449626 }, { 0.870208904637489, 0, 0.456438778823273, 0, 1.16840541582923, 0, -0.279235295364889, 0, 0.960222693462355 }, { 0.859993340290416, 0, 0.405603575848225, 0, 1.10714297376214, 0, -0.253941184712136, 0, 0.967219675084971 }, { 0.847013774192626, 0, 0.356716107823649, 0, 1.05061557121071, 0, -0.228784234027216, 0, 0.973477191531813 }, { 0.833256609333284, 0, 0.309270093451717, 0, 0.998048339584036, 0, -0.203752388012621, 0, 0.979022464546279 }, { 0.814868771803091, 0, 0.263704855983512, 0, 0.946593957160639, 0, -0.178963333305488, 0, 0.983855701674511 }, { 0.792784467692567, 0, 0.219984646187116, 0, 0.902527119442409, 0, -0.154463687307328, 0, 0.987998445957684 }, { 0.777015638335026, 0, 0.182893849160035, 0, 0.866473759106401, 0, -0.130402485678081, 0, 0.991461121162894 }, { 0.766229705771125, 0, 0.149638381171529, 0, 0.836768370894904, 0, -0.106721832404331, 0, 0.99428891256182 }, { 0.756032296453886, 0, 0.118461772233451, 0, 0.811303862625968, 0, -0.0833297551918593, 0, 0.996522046495942 }, { 0.748853409337565, 0, 0.087679055925289, 0, 0.7895749735685, 0, -0.0604938949629783, 0, 0.998168606735251 }, { 0.743698135398923, 0, 0.0570781684713186, 0, 0.769481114368644, 0, -0.0380548029067381, 0, 0.999275622852207 }, { 0.738644170017124, 0, 0.0268404295501669, 0, 0.75074871163847, 0, -0.0160082786523438, 0, 0.999871868585577 }, { 0.733222342139584, 0, -0.00280385774482818, 0, 0.733521250518894, 0, 0.00555280013636135, 0, 0.999984603777238 },    // Cos(theta) = 0.1524313
            { 61.475731533157, 0, 496.206291662641, 0, 499.999976251275, 0, -0.992412401151291, 0, 0.12295331978049 }, { 61.4780904052671, 0, 496.206027038052, 0, 499.999976251275, 0, -0.992412211961217, 0, 0.122955292766898 }, { 61.4775713301137, 0, 496.206080905099, 0, 499.999976251276, 0, -0.992407639494278, 0, 0.122992018860455 }, { 44.5215736120268, 0, 359.246245208304, 0, 499.999976251275, 0, -0.992387947450503, 0, 0.12315095924239 }, { 20.4158847196577, 0, 164.741701277809, 0, 499.999976251275, 0, -0.992334846301379, 0, 0.123578139100209 }, { 11.0001268286728, 0, 88.7448658437124, 0, 499.999976251276, 0, -0.99220758778894, 0, 0.124595761427678 }, { 6.42694185312741, 0, 51.8341745959525, 0, 499.999976251276, 0, -0.991973533019536, 0, 0.12644549619064 }, { 4.90995868901209, 0, 39.1459437305342, 0, 333.716394453942, 0, -0.991605397965894, 0, 0.129301399235058 }, { 3.85842237891908, 0, 30.9671410151685, 0, 252.42167425917, 0, -0.991045353539853, 0, 0.133525221075709 }, { 3.07125573995279, 0, 24.558583433085, 0, 199.336120799616, 0, -0.990232871908932, 0, 0.139423047217864 }, { 2.51713736409154, 0, 20.0180227697135, 0, 161.190952030761, 0, -0.989089806361773, 0, 0.147314068514343 }, { 2.11737568983075, 0, 16.7005778905683, 0, 132.584753754928, 0, -0.987534842968984, 0, 0.157400814774329 }, { 1.82768366824071, 0, 14.2390370726358, 0, 110.317458795768, 0, -0.985460852152657, 0, 0.169902747829357 }, { 1.61629002055044, 0, 12.3703078890161, 0, 92.3892062704049, 0, -0.982748767214582, 0, 0.184945616974152 }, { 1.46189691796106, 0, 10.9084080276827, 0, 77.6135968803269, 0, -0.979301646703169, 0, 0.202406275444593 }, { 1.3457100795018, 0, 9.71893010908449, 0, 65.3808321214383, 0, -0.974995993608516, 0, 0.222222216824155 }, { 1.25446528531182, 0, 8.69911192168962, 0, 55.2459038622085, 0, -0.969734374538581, 0, 0.244162336956216 }, { 1.18169708169744, 0, 7.81291231936961, 0, 46.7911649380947, 0, -0.963431677455853, 0, 0.267954146768669 }, { 1.12697042937444, 0, 7.05481967667484, 0, 39.6882313072273, 0, -0.956041570470203, 0, 0.293231050530803 }, { 1.08001827456493, 0, 6.37083900551419, 0, 33.7854322872978, 0, -0.947515209231852, 0, 0.319710628595672 }, { 1.04372479418568, 0, 5.77139426965923, 0, 28.8306683426234, 0, -0.937845489657719, 0, 0.347052925295773 }, { 1.0088144369604, 0, 5.21758581130016, 0, 24.7396397525302, 0, -0.927066061449001, 0, 0.374898143442138 }, { 0.985067198015394, 0, 4.74593390161989, 0, 21.2414055354202, 0, -0.915178063120506, 0, 0.403049768157527 }, { 0.965709442404326, 0, 4.33278475193463, 0, 18.2887953713204, 0, -0.90220523531726, 0, 0.431306991113853 }, { 0.949043044947974, 0, 3.955802640405, 0, 15.8036970231974, 0, -0.888185941834134, 0, 0.45948423170986 }, { 0.935475111832403, 0, 3.62413077178237, 0, 13.7058678697294, 0, -0.873157270898042, 0, 0.487438530777508 }, { 0.925199468818407, 0, 3.32904304688198, 0, 11.9378176784765, 0, -0.857161847897225, 0, 0.515047113955857 }, { 0.921324076678894, 0, 3.0738072202908, 0, 10.4144687848138, 0, -0.840255050644245, 0, 0.542191306608794 }, { 0.913763742232951, 0, 2.83153164992246, 0, 9.12554254494304, 0, -0.822477421738425, 0, 0.568797781986422 }, { 0.910071861358943, 0, 2.61563555872404, 0, 8.02579718112769, 0, -0.803871249526702, 0, 0.594803315178209 }, { 0.902478916436403, 0, 2.413104226992, 0, 7.10856829386951, 0, -0.784462083806287, 0, 0.620176830965204 }, { 0.901485485128096, 0, 2.2380809979259, 0, 6.29628557804842, 0, -0.764337443200258, 0, 0.644816427122419 }, { 0.898544911195587, 0, 2.07302956519741, 0, 5.61438827594877, 0, -0.743588730321162, 0, 0.668637315559078 }, { 0.894395530236387, 0, 1.91692399132076, 0, 5.0270534294707, 0, -0.722207409923549, 0, 0.691676597770609 }, { 0.901577923079974, 0, 1.79857454205616, 0, 4.49011158907362, 0, -0.700259847330549, 0, 0.713888031795086 }, { 0.897330733186574, 0, 1.66466488679375, 0, 4.04994832080528, 0, -0.677758970316864, 0, 0.735284126428874 }, { 0.898017831174951, 0, 1.54932729708426, 0, 3.65895516534944, 0, -0.654732817115191, 0, 0.755860449866838 }, { 0.903701183192028, 0, 1.45338779140128, 0, 3.3088945891461, 0, -0.631238180597225, 0, 0.775588997841609 }, { 0.901136572457177, 0, 1.34812735745958, 0, 3.01491094014766, 0, -0.607314589524132, 0, 0.794461510864884 }, { 0.906444331153997, 0, 1.26253716008317, 0, 2.74814373702677, 0, -0.583002826705002, 0, 0.81247008426697 }, { 0.902569273326715, 0, 1.16818631618353, 0, 2.51939844381362, 0, -0.558348775620353, 0, 0.829606384249294 }, { 0.898748303066632, 0, 1.08200577970275, 0, 2.3167481008679, 0, -0.533367074547072, 0, 0.84588386967966 }, { 0.902692538730017, 0, 1.01077620802268, 0, 2.13306701794934, 0, -0.508353635246876, 0, 0.861148391038854 }, { 0.897426710801194, 0, 0.930919920324554, 0, 1.97459304750025, 0, -0.483167970596812, 0, 0.875527669873859 }, { 0.90199933073319, 0, 0.869901615206704, 0, 1.8274848996948, 0, -0.457798214232542, 0, 0.889056091114784 }, { 0.894341961330398, 0, 0.797400753484953, 0, 1.70113640901159, 0, -0.432251043147652, 0, 0.901753320951448 }, { 0.891958443382253, 0, 0.733708134796061, 0, 1.58552991645488, 0, -0.406567411892714, 0, 0.913620808537178 }, { 0.888714026077493, 0, 0.674510338935959, 0, 1.48246725542765, 0, -0.380759999534966, 0, 0.924673964787251 }, { 0.882063251189073, 0, 0.61439475941697, 0, 1.39056361694265, 0, -0.354935833929958, 0, 0.934890632828083 }, { 0.871317525943841, 0, 0.554934468314476, 0, 1.30606852754292, 0, -0.329057061473464, 0, 0.944310077329238 }, { 0.869857652709708, 0, 0.505129170380549, 0, 1.23325318474572, 0, -0.30336432457993, 0, 0.952874623080144 }, { 0.857603851312566, 0, 0.449897428645459, 0, 1.16120259417506, 0, -0.277798457696633, 0, 0.960639404817429 }, { 0.844683551233355, 0, 0.398999078726567, 0, 1.09699649883895, 0, -0.252307149299329, 0, 0.967647204495171 }, { 0.830784650243644, 0, 0.34873851546468, 0, 1.03787241714854, 0, -0.22691784573498, 0, 0.97391389832214 }, { 0.812278662699394, 0, 0.299303161169162, 0, 0.981818834491513, 0, -0.201621770019723, 0, 0.979463453985216 }, { 0.795623538388398, 0, 0.255433234311582, 0, 0.931050276055791, 0, -0.176528904354889, 0, 0.984295423794716 }, { 0.780006513201457, 0, 0.215556990497151, 0, 0.888796137147078, 0, -0.15170222088774, 0, 0.988426277434844 }, { 0.765088470431768, 0, 0.17881702898721, 0, 0.851973301796715, 0, -0.127316077397655, 0, 0.991862215356079 }, { 0.75444924612218, 0, 0.145867139003293, 0, 0.822811792889685, 0, -0.103165568010407, 0, 0.994664202700899 }, { 0.743531713782052, 0, 0.114552872252124, 0, 0.796562140593905, 0, -0.0792785560555517, 0, 0.996852486483664 }, { 0.735708278285876, 0, 0.0839274202691785, 0, 0.774268922449067, 0, -0.0556396706546749, 0, 0.998450892362057 }, { 0.729577239210111, 0, 0.0530634524638032, 0, 0.753523281326699, 0, -0.0322600626423044, 0, 0.999479544885238 }, { 0.723032282368871, 0, 0.0227759168285361, 0, 0.734240317936349, 0, -0.00922608648440371, 0, 0.999957435232492 }, { 0.717178656056056, 0, -0.00717307799102532, 0, 0.716972569375378, 0, 0.0132208377768674, 0, 0.999912582212583 },    // Cos(theta) = 0.1229529
            { 46.4845961153361, 0, 497.834460664193, 0, 499.999976251276, 0, -0.995668795226749, 0, 0.0929710535940238 }, { 46.485173670912, 0, 497.834435042982, 0, 499.999976251275, 0, -0.995668609447623, 0, 0.092973649426545 }, { 46.4898751840612, 0, 497.833961490377, 0, 499.999976251275, 0, -0.995663940721327, 0, 0.0930228848029206 }, { 37.3762995535932, 0, 400.207994404199, 0, 499.999976251275, 0, -0.995644047432122, 0, 0.093235644942574 }, { 17.0234393950567, 0, 182.229080196348, 0, 499.999976251275, 0, -0.995589967759801, 0, 0.0938115786922141 }, { 9.31070442330556, 0, 99.6129996152708, 0, 499.999976251275, 0, -0.995454148286005, 0, 0.0952414547738613 }, { 5.58178677521134, 0, 59.6738106405171, 0, 499.999976251275, 0, -0.995227223818892, 0, 0.0975844211611634 }, { 3.53791257651826, 0, 37.7818129949266, 0, 499.999976251275, 0, -0.994856861717951, 0, 0.101290632476169 }, { 2.94364529879018, 0, 31.2024569918007, 0, 333.616070995747, 0, -0.994286421619854, 0, 0.106745376524259 }, { 2.36150926056123, 0, 24.856560416564, 0, 262.938280580768, 0, -0.993443252494054, 0, 0.114326313349518 }, { 1.96321479276173, 0, 20.433873213771, 0, 211.259746295843, 0, -0.992238105489067, 0, 0.124352254097691 }, { 1.68276378617297, 0, 17.2138497719646, 0, 171.953453103707, 0, -0.990559529910825, 0, 0.137083293609111 }, { 1.48760325224283, 0, 14.8263418524262, 0, 140.722903506568, 0, -0.988288529420087, 0, 0.152597020520655 }, { 1.35127917851564, 0, 12.9912589095995, 0, 115.473751653695, 0, -0.985294903319067, 0, 0.170862455502633 }, { 1.24386294594315, 0, 11.423074919397, 0, 95.2670149407247, 0, -0.98144987056415, 0, 0.191718855308668 }, { 1.16420134861654, 0, 10.1178842984373, 0, 78.7697491045141, 0, -0.976635287674982, 0, 0.214903668072985 }, { 1.10467868870951, 0, 9.01039693249093, 0, 65.2552143685648, 0, -0.970768722227549, 0, 0.240016662403401 }, { 1.04981194758095, 0, 7.99202432762983, 0, 54.5091195255097, 0, -0.963783288078939, 0, 0.266686472751167 }, { 1.01718192513427, 0, 7.18549757581347, 0, 45.5014066629177, 0, -0.955645282761454, 0, 0.294519930171383 }, { 0.985023866861841, 0, 6.44168530253786, 0, 38.1933569316444, 0, -0.946346267451066, 0, 0.323154434718537 }, { 0.9540726345037, 0, 5.76738794749262, 0, 32.2946068717773, 0, -0.935906953601431, 0, 0.352247330179037 }, { 0.934435603994132, 0, 5.20825716417072, 0, 27.3470179615326, 0, -0.924376485868406, 0, 0.38148146790846 }, { 0.91897460786515, 0, 4.72321783120892, 0, 23.2280156189117, 0, -0.911777805642195, 0, 0.410683875396787 }, { 0.905393007785295, 0, 4.2878716949503, 0, 19.8457089748771, 0, -0.8981564680198, 0, 0.43967589990274 }, { 0.894383508148551, 0, 3.90456139514232, 0, 17.0459104010048, 0, -0.883561855109354, 0, 0.468314410389288 }, { 0.88566334133541, 0, 3.56808933355709, 0, 14.6914103661397, 0, -0.868035262940675, 0, 0.496502488037492 }, { 0.884350631916544, 0, 3.28680848990235, 0, 12.6877791287237, 0, -0.851623873640466, 0, 0.524153303316135 }, { 0.879554382271601, 0, 3.01877337043449, 0, 11.0287518441312, 0, -0.834397571958885, 0, 0.551162989977972 }, { 0.873692830174537, 0, 2.77158776279976, 0, 9.65030703824849, 0, -0.816382216674313, 0, 0.577511957277107 }, { 0.868276544140329, 0, 2.55185381637016, 0, 8.46522830953608, 0, -0.797618401132678, 0, 0.60316241695181 }, { 0.868269107791236, 0, 2.36033802111025, 0, 7.45864163552287, 0, -0.778157127855894, 0, 0.628069601487915 }, { 0.87199009663053, 0, 2.19905941104976, 0, 6.57989982809501, 0, -0.758048592842622, 0, 0.652198075254161 }, { 0.87209230667239, 0, 2.03795102427827, 0, 5.84693790235183, 0, -0.737311352269924, 0, 0.675553073386722 }, { 0.870149573901427, 0, 1.88598314168225, 0, 5.22470659835619, 0, -0.715988330285973, 0, 0.698112299975676 }, { 0.868886358872648, 0, 1.74864959805651, 0, 4.67613984888634, 0, -0.694151965899446, 0, 0.719828453604443 }, { 0.874748691505028, 0, 1.63609419474676, 0, 4.1926984332404, 0, -0.671847747541881, 0, 0.740689263167532 }, { 0.873957309033829, 0, 1.51826180087801, 0, 3.78289395040128, 0, -0.649173824635822, 0, 0.760640118088944 }, { 0.880586978662282, 0, 1.42403611548208, 0, 3.41630958338789, 0, -0.626079051288112, 0, 0.779759621233263 }, { 0.879287537796388, 0, 1.3207134860777, 0, 3.10354825435486, 0, -0.602625120923453, 0, 0.798024401822122 }, { 0.88763605092083, 0, 1.24210084226703, 0, 2.82076905809061, 0, -0.578819520790682, 0, 0.815455685648709 }, { 0.883996519857402, 0, 1.14906729864238, 0, 2.58154475295602, 0, -0.554709187727563, 0, 0.832044290872797 }, { 0.892500909945334, 0, 1.08112452212825, 0, 2.35626983579226, 0, -0.530316247773838, 0, 0.847799919797306 }, { 0.886736705067187, 0, 0.996189706184261, 0, 2.17423952583903, 0, -0.505675491958334, 0, 0.862723763129612 }, { 0.881248866132871, 0, 0.918489545394303, 0, 2.00334669618435, 0, -0.480815431750385, 0, 0.876821854512147 }, { 0.886077828811604, 0, 0.857464496489911, 0, 1.85393028255533, 0, -0.455776889052995, 0, 0.890094078543644 }, { 0.879820595668714, 0, 0.787456775091817, 0, 1.72002495278198, 0, -0.430573003882738, 0, 0.90255573747241 }, { 0.880001579097154, 0, 0.728878452877276, 0, 1.59863255023248, 0, -0.405240093394935, 0, 0.914210262874668 }, { 0.87394736941096, 0, 0.666324337153353, 0, 1.49255730396875, 0, -0.379901303913237, 0, 0.9250269613214 }, { 0.8744281081132, 0, 0.613679894580276, 0, 1.3942334834357, 0, -0.354700202625521, 0, 0.934980081029582 }, { 0.861904597636138, 0, 0.552462679801417, 0, 1.30671202448631, 0, -0.329457487645021, 0, 0.944170403963184 }, { 0.853281284655754, 0, 0.497825919455671, 0, 1.22699595209797, 0, -0.304192216638477, 0, 0.952610676011705 }, { 0.843385834254651, 0, 0.4452514783723, 0, 1.15737673227718, 0, -0.278914381335635, 0, 0.960316008676236 }, { 0.827052017682737, 0, 0.391435742070059, 0, 1.0882556516718, 0, -0.25365209320613, 0, 0.967295571632559 }, { 0.815346336646023, 0, 0.343413078261102, 0, 1.02764823960921, 0, -0.228472095377561, 0, 0.973550420797605 }, { 0.797410086380216, 0, 0.296075965874861, 0, 0.967625523635923, 0, -0.203378767983455, 0, 0.979100101831654 }, { 0.784888937331233, 0, 0.254182982868251, 0, 0.9195771105529, 0, -0.178360335748093, 0, 0.983965260379486 }, { 0.766917579286929, 0, 0.213491517639105, 0, 0.873937434397633, 0, -0.153430424274965, 0, 0.988159427434989 }, { 0.752983370636241, 0, 0.177618156483761, 0, 0.837707682086291, 0, -0.128776142894661, 0, 0.991673668942646 }, { 0.742239794830839, 0, 0.144688548526124, 0, 0.807425774655003, 0, -0.104472382966097, 0, 0.99452781961501 }, { 0.729666488861774, 0, 0.113459458506351, 0, 0.780682793654569, 0, -0.0803530321914799, 0, 0.996766486714052 }, { 0.720497220249867, 0, 0.0829483077704089, 0, 0.756921069344131, 0, -0.0564139131963807, 0, 0.998407451033621 }, { 0.712780534986084, 0, 0.0521814974630631, 0, 0.735374224413044, 0, -0.0326672485038743, 0, 0.999466325706452 }, { 0.705296635751066, 0, 0.0219472879041278, 0, 0.715707132530085, 0, -0.00917433862639707, 0, 0.999957970232789 }, { 0.698081187698685, 0, -0.00755423112836578, 0, 0.697569732178893, 0, 0.0139124260104712, 0, 0.999903173357031 },    // Cos(theta) = 0.09297049
            { 31.2415473662129, 0, 499.023009580293, 0, 499.999976251276, 0, -0.998045950029195, 0, 0.0624849590812195 }, { 31.2429414226818, 0, 499.022878882481, 0, 499.999976251276, 0, -0.998045598204484, 0, 0.0624891913547713 }, { 31.2446075109922, 0, 499.022818178321, 0, 499.999976251276, 0, -0.99804105774819, 0, 0.0625630148011451 }, { 31.2549534652203, 0, 499.022193624122, 0, 499.999976251276, 0, -0.998020929952361, 0, 0.0628829550748085 }, { 13.2232257240868, 0, 210.934827016953, 0, 499.999976251275, 0, -0.997957003891457, 0, 0.0638882747648906 }, { 7.24608409554722, 0, 115.416932582823, 0, 499.999976251276, 0, -0.997831725406261, 0, 0.0658164968898962 }, { 4.43566947294691, 0, 70.4931526102136, 0, 499.999976251275, 0, -0.997603134537991, 0, 0.0691953908656144 }, { 2.90466474397622, 0, 45.9938863924808, 0, 499.999976251275, 0, -0.997221295789833, 0, 0.07449625467786 }, { 2.02918931856711, 0, 31.6081959659042, 0, 499.999976251275, 0, -0.996618114607516, 0, 0.0821730860258398 }, { 1.431155110157, 0, 22.2006119327574, 0, 499.999976251275, 0, -0.995696393550819, 0, 0.0926753457356958 }, { 1.45492689004467, 0, 21.5083025895834, 0, 299.967737923136, 0, -0.994339232597146, 0, 0.106252319555222 }, { 1.29938611460928, 0, 18.3275245753177, 0, 236.292487467872, 0, -0.992412564792979, 0, 0.122952669502318 }, { 1.19275651358306, 0, 15.8231139227137, 0, 187.076124144147, 0, -0.98976679417767, 0, 0.142694678114588 }, { 1.11294926012259, 0, 13.7214177969176, 0, 148.864617567655, 0, -0.986258798948699, 0, 0.16520785695736 }, { 1.04981843676457, 0, 11.9188727166519, 0, 119.350815574096, 0, -0.981769031066901, 0, 0.190078133694166 }, { 0.997273309106478, 0, 10.3707712936071, 0, 96.4778702710085, 0, -0.976198454628436, 0, 0.216879223215383 }, { 0.96593800651702, 0, 9.15237678939763, 0, 78.0877966572074, 0, -0.969489164425162, 0, 0.245134057271585 }, { 0.936454186833057, 0, 8.074594904053, 0, 63.7447000269071, 0, -0.961617176398296, 0, 0.274394739123064 }, { 0.908158124694463, 0, 7.12382824334374, 0, 52.5094976480273, 0, -0.952583526955201, 0, 0.304277173814942 }, { 0.890810154894268, 0, 6.35037334436148, 0, 43.4325427738728, 0, -0.942417426766234, 0, 0.334438803772528 }, { 0.87703547294276, 0, 5.69663608988868, 0, 36.1094507722428, 0, -0.931160941869605, 0, 0.364608442716215 }, { 0.865585357909763, 0, 5.12501938790406, 0, 30.2413684677694, 0, -0.918883829354609, 0, 0.394528167155255 }, { 0.856557503763605, 0, 4.63221719548491, 0, 25.4565317446086, 0, -0.905622436421074, 0, 0.424084995753581 }, { 0.848386196396009, 0, 4.19625909902247, 0, 21.5771627274256, 0, -0.891429716853835, 0, 0.453158971874327 }, { 0.840272569507036, 0, 3.80418403946812, 0, 18.4143615297424, 0, -0.876357407657574, 0, 0.481661426222903 }, { 0.842560904535046, 0, 3.49938335964434, 0, 15.7263868098594, 0, -0.860460558993074, 0, 0.509517096844792 }, { 0.839436817739151, 0, 3.20254913002129, 0, 13.576667139233, 0, -0.84376688033344, 0, 0.536709852838408 }, { 0.833925660398121, 0, 2.92791386595471, 0, 11.7835099107404, 0, -0.826340511360346, 0, 0.563170760150687 }, { 0.834980111528541, 0, 2.70137280938619, 0, 10.2430195665705, 0, -0.808229112830727, 0, 0.588868115267688 }, { 0.832376222616923, 0, 2.48267443935515, 0, 8.97422560232804, 0, -0.789464869551471, 0, 0.613795786992972 }, { 0.834807974752275, 0, 2.30034282895021, 0, 7.87345044294485, 0, -0.770075953381634, 0, 0.637952189078298 }, { 0.83581348322104, 0, 2.12962115331579, 0, 6.95467254891168, 0, -0.750116639375718, 0, 0.661305540665057 }, { 0.834945287238245, 0, 1.9681230085036, 0, 6.16168052428837, 0, -0.729614704624035, 0, 0.683858481951484 }, { 0.843983312037334, 0, 1.84377167296469, 0, 5.46531891441337, 0, -0.708597752617135, 0, 0.705612692263342 }, { 0.84275680835811, 0, 1.70784072362737, 0, 4.88998124417601, 0, -0.687121052472038, 0, 0.72654296955884 }, { 0.854451950529583, 0, 1.60672234844882, 0, 4.36594002186149, 0, -0.665201189245522, 0, 0.746664168820844 }, { 0.850371049395498, 0, 1.48492097710236, 0, 3.92949534446862, 0, -0.642899415042778, 0, 0.765950574189684 }, { 0.850024819700671, 0, 1.37842250015538, 0, 3.54923582856656, 0, -0.620235739191941, 0, 0.784415405630653 }, { 0.859311443796784, 0, 1.29678975145024, 0, 3.20483657385103, 0, -0.597241529547182, 0, 0.802061450197799 }, { 0.856547997022117, 0, 1.20047590783057, 0, 2.91440499579061, 0, -0.573953602438338, 0, 0.81888779254 }, { 0.864812689435101, 0, 1.12997304565611, 0, 2.64653668815362, 0, -0.550398341452158, 0, 0.834902245129674 }, { 0.876243104707422, 0, 1.06611841845007, 0, 2.41510462542794, 0, -0.52659873174985, 0, 0.850113955966472 }, { 0.867345823001877, 0, 0.978432873227773, 0, 2.21888240254114, 0, -0.502690635355753, 0, 0.864466407132803 }, { 0.877627225734072, 0, 0.921667006462493, 0, 2.03680181189202, 0, -0.478622697064125, 0, 0.878020635031855 }, { 0.869769227532622, 0, 0.846786911270783, 0, 1.88178332822728, 0, -0.454402873492492, 0, 0.890796263974871 }, { 0.861973662242663, 0, 0.77622622005073, 0, 1.74105809558917, 0, -0.430056981653501, 0, 0.902801736263157 }, { 0.865340382554863, 0, 0.721261997189978, 0, 1.61637909831897, 0, -0.405601045232982, 0, 0.914050200717039 }, { 0.859603207172453, 0, 0.660865894665631, 0, 1.50188058847708, 0, -0.381063517263487, 0, 0.924548855521325 }, { 0.856671710719266, 0, 0.605541480285419, 0, 1.403442789927, 0, -0.356460156512294, 0, 0.93431048378051 }, { 0.845928348621778, 0, 0.54737957205978, 0, 1.30957874123733, 0, -0.331805419604148, 0, 0.943347819562087 }, { 0.844943158297303, 0, 0.498433492127845, 0, 1.23117839763309, 0, -0.307124249303707, 0, 0.951669463196935 }, { 0.828497643757102, 0, 0.442439750340487, 0, 1.15175255634941, 0, -0.282432784096071, 0, 0.959287071412826 }, { 0.812992096757898, 0, 0.390530864930452, 0, 1.07805078182846, 0, -0.257749070765522, 0, 0.96621193004679 }, { 0.805224131391443, 0, 0.345074105245608, 0, 1.01777212675897, 0, -0.233090860436441, 0, 0.972454955955565 }, { 0.78627474374212, 0, 0.297286186660787, 0, 0.955754932570858, 0, -0.208475451802928, 0, 0.978027553857759 }, { 0.769665655094393, 0, 0.254358363441613, 0, 0.902784393984823, 0, -0.1839695263648, 0, 0.982931985586488 }, { 0.750903018395953, 0, 0.213881996686873, 0, 0.855960405183234, 0, -0.159577432870778, 0, 0.987185473306636 }, { 0.739274303348492, 0, 0.178913558730723, 0, 0.821015649222021, 0, -0.135344722512967, 0, 0.990798546341727 }, { 0.726165464649211, 0, 0.145911203483374, 0, 0.788950995045563, 0, -0.111414730664872, 0, 0.993773997864782 }, { 0.714276094766692, 0, 0.115393875335486, 0, 0.761700665520816, 0, -0.0876277820466767, 0, 0.996153279454307 }, { 0.702489268158106, 0, 0.0854300925123689, 0, 0.736803006665866, 0, -0.0639946149510869, 0, 0.997950291884128 }, { 0.692952173219497, 0, 0.0550709539981861, 0, 0.713992459192063, 0, -0.0405279049377221, 0, 0.999178344520073 }, { 0.683384612944135, 0, 0.025761310581771, 0, 0.693131132004105, 0, -0.0172402943266243, 0, 0.999851404163524 }, { 0.674399347672444, 0, -0.0031705006228939, 0, 0.674063675575706, 0, 0.00579703512529545, 0, 0.999983202611617 },    // Cos(theta) = 0.06248426
            { 15.7468707583735, 0, 499.751940646114, 0, 499.999976251276, 0, -0.999503870026009, 0, 0.0314956071126831 }, { 15.7502782954136, 0, 499.751852136357, 0, 499.999976251275, 0, -0.999503647405324, 0, 0.031503868457591 }, { 15.7534737012991, 0, 499.751744469428, 0, 499.999976251275, 0, -0.999498949492161, 0, 0.031651794471395 }, { 15.7718173420114, 0, 499.751323220658, 0, 499.999976251276, 0, -0.999475907370159, 0, 0.0323706961331245 }, { 8.91720345599017, 0, 281.662528243049, 0, 499.999976251275, 0, -0.999415936997116, 0, 0.034172037540557 }, { 4.76959819270361, 0, 149.40899904891, 0, 499.999976251275, 0, -0.999287304970289, 0, 0.0377475804714775 }, { 2.94779284350028, 0, 91.0910106341016, 0, 499.999976251275, 0, -0.999040765161016, 0, 0.0437889549704873 }, { 2.01965124950214, 0, 60.7217252768556, 0, 499.999976251275, 0, -0.998597953371175, 0, 0.052934314233868 }, { 1.47909092405176, 0, 42.3816930772891, 0, 499.999976251276, 0, -0.997852472235276, 0, 0.0655012333237329 }, { 1.16871597003428, 0, 30.6076087094836, 0, 499.999976251276, 0, -0.996668254484462, 0, 0.0815624027217229 }, { 1.00310154473495, 0, 22.4345813113837, 0, 499.999976251276, 0, -0.99489461714427, 0, 0.100919839240469 }, { 0.768772976537994, 0, 14.9864293305809, 0, 499.999976251275, 0, -0.992378586550249, 0, 0.123226112929048 }, { 0.755612310190866, 0, 11.3133661370178, 0, 302.706197294335, 0, -0.988981147950575, 0, 0.148041376535211 }, { 0.902216165980381, 0, 13.86374414359, 0, 197.103742328452, 0, -0.984586241176182, 0, 0.174899961622813 }, { 0.870970392449133, 0, 11.7941953466967, 0, 152.510707840957, 0, -0.979110077988809, 0, 0.203330790854185 }, { 0.855993906585988, 0, 10.2451290048972, 0, 118.691073016229, 0, -0.972504931432771, 0, 0.232882191619094 }, { 0.836355298387791, 0, 8.88954625904481, 0, 94.033882901141, 0, -0.964757297744323, 0, 0.263141508622399 }, { 0.825541349092793, 0, 7.81177356279361, 0, 75.1053977050566, 0, -0.955882194737243, 0, 0.2937505024965 }, { 0.814937099078771, 0, 6.902248805042, 0, 60.5186085254705, 0, -0.94591997571566, 0, 0.324399842549277 }, { 0.805773760061243, 0, 6.13079741831526, 0, 49.4676490907582, 0, -0.934914620134332, 0, 0.354872775002035 }, { 0.79652622340423, 0, 5.46369920691999, 0, 40.8230785123406, 0, -0.922931304895449, 0, 0.384964502183285 }, { 0.78995905750846, 0, 4.90185370757945, 0, 33.89264453315, 0, -0.91003533226192, 0, 0.414530559926131 }, { 0.786610496021538, 0, 4.42228599277932, 0, 28.3770859448219, 0, -0.896266918611268, 0, 0.443514964006111 }, { 0.780209853454251, 0, 3.99421825946207, 0, 23.9303491353237, 0, -0.881679514838125, 0, 0.471848715529582 }, { 0.778006754905965, 0, 3.62739738952693, 0, 20.3046851714022, 0, -0.866314296861957, 0, 0.49949929401137 }, { 0.780431218746576, 0, 3.31759469479008, 0, 17.3061761971296, 0, -0.850214375960172, 0, 0.526436635465584 }, { 0.778612527697293, 0, 3.0329627450451, 0, 14.8481121188396, 0, -0.833431586279673, 0, 0.552622566660786 }, { 0.775669907890728, 0, 2.77163395689491, 0, 12.8413393918573, 0, -0.816000111640876, 0, 0.578051751339408 }, { 0.785525744688133, 0, 2.57782204874022, 0, 11.0896448436452, 0, -0.79796367994793, 0, 0.602705539112083 }, { 0.786054540456339, 0, 2.37343914087998, 0, 9.66782672780167, 0, -0.779348196184819, 0, 0.626591087662501 }, { 0.787613063677349, 0, 2.19062657132113, 0, 8.45818931500203, 0, -0.76018501432483, 0, 0.649706671140331 }, { 0.799020545728752, 0, 2.05153552074429, 0, 7.40414249512347, 0, -0.740520801872589, 0, 0.672033345060199 }, { 0.798994966208718, 0, 1.89720568680809, 0, 6.5295679122408, 0, -0.72038480146423, 0, 0.693574573932244 }, { 0.809963044740332, 0, 1.78038361508953, 0, 5.77548684043537, 0, -0.699805340317794, 0, 0.714333676132145 }, { 0.809776198524063, 0, 1.64681218169832, 0, 5.15150129641845, 0, -0.678829325681334, 0, 0.73429616237342 }, { 0.82300799837695, 0, 1.55491790357722, 0, 4.57229634282581, 0, -0.657476126972876, 0, 0.753475436130227 }, { 0.8335742420493, 0, 1.46260667069733, 0, 4.08971557924837, 0, -0.635781596153108, 0, 0.771869015892464 }, { 0.831928882765022, 0, 1.35528891432923, 0, 3.68140043097208, 0, -0.613778934898128, 0, 0.789477926513435 }, { 0.843890178884883, 0, 1.27894817779041, 0, 3.31528082545852, 0, -0.591498623687638, 0, 0.80630601860578 }, { 0.841605912673657, 0, 1.18632514414998, 0, 3.00706582392745, 0, -0.568967514126957, 0, 0.822360055093017 }, { 0.848392803795425, 0, 1.11383733285628, 0, 2.72840084110626, 0, -0.546215224749429, 0, 0.837644857509605 }, { 0.845827761987338, 0, 1.03309480736687, 0, 2.48908393967358, 0, -0.523264919388369, 0, 0.852170106231332 }, { 0.852492491282029, 0, 0.968992923454148, 0, 2.27403543969215, 0, -0.500147168004936, 0, 0.865940355586907 }, { 0.845997233616338, 0, 0.893089335292254, 0, 2.0859592002548, 0, -0.476884174513451, 0, 0.878966131002946 }, { 0.849727026057727, 0, 0.833992067520367, 0, 1.91963591756995, 0, -0.453495322651695, 0, 0.891258655000926 }, { 0.860896753051141, 0, 0.785286430430179, 0, 1.77027578546248, 0, -0.430005910155718, 0, 0.902826075285582 }, { 0.845030481223287, 0, 0.712256448115033, 0, 1.63736194667221, 0, -0.40643435703543, 0, 0.913680024092415 }, { 0.842463651556537, 0, 0.655843178224503, 0, 1.51687343466715, 0, -0.38280353897226, 0, 0.92382982910547 }, { 0.83844362120577, 0, 0.601649605413593, 0, 1.41181614222901, 0, -0.359129016680575, 0, 0.933287931690229 }, { 0.829362532089976, 0, 0.546335491465798, 0, 1.31258082407196, 0, -0.335432273666898, 0, 0.942064296116067 }, { 0.823832178281381, 0, 0.496082180559396, 0, 1.22747059506005, 0, -0.311728545077302, 0, 0.950171165752085 }, { 0.811387777153088, 0, 0.44340196261604, 0, 1.14490586808241, 0, -0.288038127716386, 0, 0.957618928995528 }, { 0.811047431125431, 0, 0.400439842454188, 0, 1.07897908808563, 0, -0.264372538405837, 0, 0.964420656048435 }, { 0.782464447525172, 0, 0.344939464640719, 0, 0.999394092761172, 0, -0.240749322879144, 0, 0.97058734724873 }, { 0.770691613692917, 0, 0.30160420861385, 0, 0.939928157070193, 0, -0.217183317760773, 0, 0.976130825392948 }, { 0.755235336369079, 0, 0.259416293285251, 0, 0.88657086584417, 0, -0.193690727420578, 0, 0.981062626870072 }, { 0.742985261908338, 0, 0.22050485592373, 0, 0.842754444068183, 0, -0.170283034715636, 0, 0.98539519467272 }, { 0.71998972357464, 0, 0.183323438412641, 0, 0.799885256641142, 0, -0.14700513668158, 0, 0.989135714601517 }, { 0.705358076295141, 0, 0.150410310650712, 0, 0.765466768669975, 0, -0.123946773717866, 0, 0.992288909096918 }, { 0.694562764494999, 0, 0.120166725269975, 0, 0.737959277514483, 0, -0.101021296834881, 0, 0.99488433534968 }, { 0.680046528599715, 0, 0.0915046560710007, 0, 0.711357493659865, 0, -0.078240939350271, 0, 0.996934484543934 }, { 0.667053949308715, 0, 0.062685975302505, 0, 0.686642289622062, 0, -0.0556176802409837, 0, 0.998452150864867 }, { 0.6548184698727, 0, 0.034255574064075, 0, 0.664423548803987, 0, -0.0331628987482101, 0, 0.999449951245564 }, { 0.642908110635805, 0, 0.00591879767167064, 0, 0.643524366368774, 0, -0.0108878023603495, 0, 0.999940758875687 },    // Cos(theta) = 0.03149408
            { 0.278626363349448, 0, 499.999880070941, 0, 499.999976251275, 0, -0.999999806596553, 0, 0.000559117778164956 }, { 0.449105741280243, 0, 499.9997884635, 0, 499.999976251276, 0, -0.999999337543228, 0, 0.00114808859453563 }, { 0.893981244745824, 0, 500.001418595073, 0, 499.999976251275, 0, -0.999988526127692, 0, 0.00478725726429198 }, { 1.29687490062492, 0, 500.016569714328, 0, 499.999976251276, 0, -0.999937757085972, 0, 0.0111511017987472 }, { 2.04991157768781, 0, 500.060835185637, 0, 499.999976251276, 0, -0.999795423184533, 0, 0.0202276473844156 }, { 1.78973908749894, 0, 300.125201171043, 0, 499.999976251275, 0, -0.999491265506221, 0, 0.0318926588209269 }, { 1.3843803341046, 0, 166.348527195342, 0, 499.999976251275, 0, -0.998936509442145, 0, 0.0461060291459692 }, { 1.12574252728979, 0, 96.4304022001171, 0, 499.999976251275, 0, -0.99802543237561, 0, 0.0628107609125069 }, { 0.904858509049674, 0, 56.3224695610263, 0, 499.999976251275, 0, -0.996639318893806, 0, 0.0819150513680347 }, { 0.774016442103655, 0, 36.6651193041821, 0, 499.999976251275, 0, -0.994652119256789, 0, 0.103281792572204 }, { 0.721797877510554, 0, 25.2556256502959, 0, 499.999976251275, 0, -0.991937654776252, 0, 0.126726897799749 }, { 0.707920271886206, 0, 18.0777996252996, 0, 499.999976251275, 0, -0.988377798311006, 0, 0.152017487350963 }, { 0.561448264650028, 0, 11.473571114598, 0, 499.999976251276, 0, -0.983872395043571, 0, 0.178871717649243 }, { 0.402288362677744, 0, 6.42645856602661, 0, 499.999976251275, 0, -0.978346427956297, 0, 0.206973976573811 }, { 0.608680448679322, 0, 9.55587778765854, 0, 220.433911840882, 0, -0.971755854935584, 0, 0.235988584941827 }, { 0.647065554695086, 0, 8.66629029170167, 0, 162.214835241672, 0, -0.964088202501178, 0, 0.265582263739207 }, { 0.64220598903438, 0, 7.53986195547616, 0, 126.245153594811, 0, -0.955359558169473, 0, 0.295445585037699 }, { 0.679299312792265, 0, 6.95066104164073, 0, 96.7391808714917, 0, -0.945607926436757, 0, 0.325308490096873 }, { 0.672936705810369, 0, 6.10288852387512, 0, 77.1134029878475, 0, -0.934885818589216, 0, 0.354948534934115 }, { 0.666351294420246, 0, 5.38935274325511, 0, 61.910960445689, 0, -0.923251004038876, 0, 0.384197367139604 }, { 0.660754042139529, 0, 4.79966039183682, 0, 50.199079152552, 0, -0.910761208428134, 0, 0.412933396194214 }, { 0.689822070303191, 0, 4.46644818092785, 0, 40.6271809388882, 0, -0.897470071493074, 0, 0.441075450830402 }, { 0.683533962599902, 0, 4.00034603508063, 0, 33.6358057979465, 0, -0.883424513094643, 0, 0.468573568139902 }, { 0.705677093040942, 0, 3.74523935521036, 0, 27.7240474961833, 0, -0.868667382569752, 0, 0.495395662542215 }, { 0.703240203546203, 0, 3.36908776415661, 0, 23.3965956758482, 0, -0.85323605099344, 0, 0.521525021377074 }, { 0.696941187809506, 0, 3.04760040968943, 0, 19.7571981381912, 0, -0.837164447269063, 0, 0.546951186027458 }, { 0.718743361450539, 0, 2.85995714223543, 0, 16.7410796188433, 0, -0.820485531517454, 0, 0.571667354570915 }, { 0.713932011095601, 0, 2.60246236957753, 0, 14.3167476413229, 0, -0.803231118275694, 0, 0.595667435860296 }, { 0.733897524933101, 0, 2.44582253130806, 0, 12.2579051326246, 0, -0.785431745252218, 0, 0.618948282847646 }, { 0.746753173635689, 0, 2.28894236001727, 0, 10.5540964834603, 0, -0.767120247135926, 0, 0.641503338240946 }, { 0.745561794781558, 0, 2.09984711621379, 0, 9.21958843645271, 0, -0.748327842512472, 0, 0.663329109895114 }, { 0.758797492558822, 0, 1.96903587132449, 0, 8.03421891291458, 0, -0.729087138924848, 0, 0.684420906739782 }, { 0.758372904037218, 0, 1.8185335453423, 0, 7.06524991959871, 0, -0.709429560379019, 0, 0.704776344981928 }, { 0.774191071608035, 0, 1.7196360106621, 0, 6.20269207544177, 0, -0.689387238260781, 0, 0.724393047965275 }, { 0.788783785894475, 0, 1.61151608031325, 0, 5.49548712622712, 0, -0.66899257579508, 0, 0.743269082341887 }, { 0.781156972077609, 0, 1.48586556914833, 0, 4.89642385073309, 0, -0.648275391495391, 0, 0.761405963768103 }, { 0.795431471451253, 0, 1.40632166463582, 0, 4.35679988957278, 0, -0.627266163161764, 0, 0.778804951121632 }, { 0.789406376774391, 0, 1.29582777599907, 0, 3.91239999952385, 0, -0.605995726223048, 0, 0.795467850082533 }, { 0.804535641366468, 0, 1.22914357811599, 0, 3.50487758142339, 0, -0.584492095025829, 0, 0.811399410870199 }, { 0.81152610419736, 0, 1.15503212083785, 0, 3.15686032268199, 0, -0.562782837998286, 0, 0.826604804037465 }, { 0.806457592734365, 0, 1.06860897096867, 0, 2.86238253624132, 0, -0.540893492125063, 0, 0.841091091801839 }, { 0.816390083696447, 0, 1.00750129453886, 0, 2.59438284024464, 0, -0.518850457079551, 0, 0.854865033224117 }, { 0.827287583341022, 0, 0.951075441215681, 0, 2.3655251118132, 0, -0.496677887438801, 0, 0.867934963075456 }, { 0.8309420579956, 0, 0.889039278881265, 0, 2.16281100026996, 0, -0.47439962641249, 0, 0.880309637350819 }, { 0.822453731077935, 0, 0.819106270739363, 0, 1.98068746147912, 0, -0.452036259320997, 0, 0.891999597106542 }, { 0.822957285994, 0, 0.7581015460582, 0, 1.8230592056911, 0, -0.429611152796739, 0, 0.903013954928339 }, { 0.815223896921983, 0, 0.699875014450004, 0, 1.67467692958245, 0, -0.407142286436147, 0, 0.913364712172167 }, { 0.812563120482585, 0, 0.646212220602212, 0, 1.54646303109278, 0, -0.384650075382381, 0, 0.923062417388456 }, { 0.805820561575261, 0, 0.593796591043151, 0, 1.42732141283515, 0, -0.36215162873521, 0, 0.932119206040673 }, { 0.783987559335556, 0, 0.531547855559174, 0, 1.30472416818945, 0, -0.339665321632577, 0, 0.940546411154092 }, { 0.801376705617343, 0, 0.499089716062859, 0, 1.23219070624645, 0, -0.317207265779947, 0, 0.948356267275715 }, { 0.784895953422858, 0, 0.444778424945141, 0, 1.13272408979426, 0, -0.294793308082029, 0, 0.955561042807031 }, { 0.780607997108855, 0, 0.402842803723308, 0, 1.0632493781215, 0, -0.272437673526679, 0, 0.962173397771475 }, { 0.76059069335425, 0, 0.353451778884308, 0, 0.982051543764768, 0, -0.250154549371161, 0, 0.96820590762062 }, { 0.751953985542676, 0, 0.310880243687047, 0, 0.922527131876452, 0, -0.227958704530197, 0, 0.973670757518373 }, { 0.720262474914087, 0, 0.264480856948953, 0, 0.855325253012097, 0, -0.205861957743378, 0, 0.978581008918518 }, { 0.732794083256174, 0, 0.232849534439054, 0, 0.820907049330482, 0, -0.183877564238837, 0, 0.982949173625243 }, { 0.701222806169873, 0, 0.193011900061912, 0, 0.770688053271035, 0, -0.162016529175345, 0, 0.986788054603714 }, { 0.679129480454819, 0, 0.159692223815176, 0, 0.73253818753915, 0, -0.140291270746004, 0, 0.990110212469655 }, { 0.662470781042152, 0, 0.129590253143268, 0, 0.699747735200457, 0, -0.118711121917617, 0, 0.992928804747245 }, { 0.644598091996748, 0, 0.10254019886632, 0, 0.671180186895827, 0, -0.0972876883559017, 0, 0.995256358970462 }, { 0.621655499607745, 0, 0.0751782209472622, 0, 0.64465971867758, 0, -0.0760306274285263, 0, 0.99710548626302 }, { 0.612964403655447, 0, 0.0481213627660587, 0, 0.624313643470428, 0, -0.0549492582633016, 0, 0.998489154919582 }, { 0.59882903149512, 0, 0.0210142516935895, 0, 0.602078762852583, 0, -0.0340527029651369, 0, 0.999420030239897 },    // Cos(theta) = 0
        };

        // NOTE: Formerly, we needed to also export and create a table for the BRDF's amplitude factor + fresnel coefficient
        //    but it turns out these 2 factors are actually already precomputed and available in the FGD table corresponding
        //    to the GGX BRDF, therefore they are no longer exported...
    }
}
