import json
import click
class Parser:
    def __init__(self,json_file):
        self.data_dict = json.load(open(json_file,"r"))
        self.collision_time = self.data_dict["collision_time"]
        self.start_time = self.data_dict["start_time"]
        self.is_collision = self.data_dict["is_collision"]
        del self.data_dict["collision_time"]
        del self.data_dict["start_time"]
        del self.data_dict["is_collision"]
        self.parsed_dict = {}
        print("Parser init done.")

    def get_nearest_wp_in_time_by_ID(self,ID,target_time):
        min_dis = float("inf")
        min_idx = -1
        for idx,wp in enumerate(self.data_dict[ID]):
            if min_dis > abs(target_time - wp["time"]):
                min_dis = min(min_dis, abs(target_time - wp["time"]))
                min_idx = idx
        return self.data_dict[ID][min_idx]

    def parse(self):
        if not self.is_collision:
            return None
        self.collision_time += self.start_time
        for ID in self.data_dict:
            print(ID)
            if ID not in self.parsed_dict:
                self.parsed_dict[ID] = {}
            for i in range(4):
                target_time = self.collision_time - i
                nearest_wp = self.get_nearest_wp_in_time_by_ID(ID, target_time)
                self.parsed_dict[ID][-i] = nearest_wp
                # print(f"{-i}: nearest at {nearest_wp}")

    def save(self,path):
        if self.is_collision:
            json.dump(self.parsed_dict, open(path,'w'))
        else:
            print("Not collision!")
                
@click.command()
@click.option(
    "-i",
    "--input_record",
    type=click.Path(dir_okay=False, exists=True),
    required=True,
    help="input test case to be proceeded by the tool",
)
@click.option(
    "-o",
    "--output",
    type=click.Path(dir_okay=False, exists=False),
    required=True,
    help="final output location for the converted seed",
)
def main(input_record,output):
    parser = Parser(input_record)
    parser.parse()
    parser.save(output)

if __name__ == '__main__':  
    main()
