# !/usr/bin/python3
import sys
import os
import click
import subprocess
sys.path.append(os.getenv("AUTOWARE_FUZZER"))
from run_vse import VSERunner
import subprocess
import dataparser as _Parser
import points_parser as control_gt_parser
from manager import AutowareManager
import json
import tempfile
import pickle
import time

class Runner:
    def __init__(self, seed):
        self.seed = seed
        self.scenario = _Parser.scenario_parser(seed)
        self.VSE_dict = json.load(open(seed,'r'))
        self.autoware_manager = AutowareManager()
        self.collision_data = {}
        self.duration = 0
        self.is_collision = True
        self.collision_object = []
        self.collision_time = 0 

    def run_once(self,scene,run_time=30,control_gt=True,no_ego=False):
        with tempfile.TemporaryDirectory() as tmpdirname:
            os.mkdir(tmpdirname + "/collision")
            vse_runner = VSERunner(scene, tmpdirname, 'none', autoware_manager=self.autoware_manager,end_after_collision=not control_gt, no_ego=no_ego)
            vse_runner.run(run_time)
            return vse_runner.is_collision,vse_runner.collision_time,vse_runner.collision_object,vse_runner.collision_object_detail

    def save_data(self,output):
        data={
            "is_collision": self.is_collision,
            "collision_time": self.collision_time,
            "collision_object": list(self.collision_object),
            "duration": self.duration
        }
        with open(output,"w") as o:
            json.dump(data,o)
            

    def run(self,result_output = None):
        start_time = time.time()
        # firstly, run once to get gt trajectory
        print("[+] Run once to get the ego trajectory under control_gt")
        # self.autoware_manager.default()
        self.autoware_manager.control_ground_truth()
        self.autoware_manager.set_args('map',map=self.scenario.map["name"])
        self.autoware_manager.start_all()
        self.run_once(self.scenario, control_gt=True, no_ego=False)
        # then, run with no ego to test collision
        self.autoware_manager.stop("control_GT")
        print("[+] Parsing ego trajectory. ")
        control_gt_parser.parse(points="/tmp/control_gt_traj.txt", scene = self.seed, out="/tmp/control_gt_scene_out.json")
        print("[+] Running without ego. ")
        control_gt_out_scene = _Parser.scenario_parser("/tmp/control_gt_scene_out.json")
        self.is_collision,self.collision_time,self.collision_object,self.collision_detail = self.run_once(control_gt_out_scene, control_gt = True, no_ego = True)
        end_time = time.time()
        self.duration = end_time - start_time
    
    def clean(self):
        self.autoware_manager.clean()

@click.command()
@click.option(
    "-i",
    "--input",
    type=click.Path(dir_okay=False, exists=True),
    help="input scene"
)
@click.option(
    "-o",
    "--output",
    type=click.Path(dir_okay=False, exists=False),
    help="output file"
)
def main(input,output):
    runner = Runner(input)
    runner.run()
    runner.save_data(output)
    runner.clean()

if __name__ == '__main__':
    main()