import json
import sys, os
import numpy as np
import math

sys.path.append(os.path.join(os.path.expanduser("~"), "apollo/.cache/bazel/540135163923dd7d5820f3ee4b306b32/execroot/apollo/bazel-out/k8-opt/bin"))
import modules.perception.proto.perception_obstacle_pb2 
import modules.prediction.proto.prediction_obstacle_pb2
import modules.prediction.proto.feature_pb2
import modules.common.proto.header_pb2
import modules.common.proto.error_code_pb2
import modules.common.proto.geometry_pb2
import modules.common.proto.pnc_point_pb2

from google.protobuf import text_format



class Converter:
    GT = []
    total_round = 0

    def __init__(self, text):
        self.total_round = len(text)

        for line in text:
            self.GT.append(json.loads(line))

    def Convert_Gps_To_Point(self, g):
        return modules.common.proto.geometry_pb2.Point3D(
            x = g["Easting"],
            y = g["Northing"],
            z = g["Altitude"]
        )

    def Convert_Vector_To_Point(self, v):
        return modules.common.proto.geometry_pb2.Point3D(
            x = v["x"],
            y = v["y"],
            z = v["z"]
        )
    
    def get_data_by_id(self, idx, id):
        for car in self.GT[idx]["Data"]:
            if car["Id"] == id:
                return car
        return None

    def Convert_To_Perception_Obstacle(self, d, t):        
        velocity = d["Velocity"];
        tmp_value = velocity["z"]
        velocity["z"] = velocity["y"]
        velocity["y"] = tmp_value

        acceleration = d["Acceleration"];
        tmp_value = acceleration["z"]
        acceleration["z"] = acceleration["y"]
        acceleration["y"] = tmp_value

        size = d["Scale"];
        tmp_value = size["z"]
        size["z"] = size["y"]
        size["y"] = tmp_value

        acceleration = d["Acceleration"]
        size = d["Scale"]

        type = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.Type.UNKNOWN
        subType = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.SubType.ST_UNKNOWN
        
        if d["Label"] == "Pedestrian":
            type = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.Type.PEDESTRIAN
            subType = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.SubType.ST_PEDESTRIAN
        elif d["Label"] == "BoxTruck":
            type = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.Type.VEHICLE
            subType = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.SubType.ST_TRUCK
        elif d["Label"] == "SchoolBus":
            type = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.Type.VEHICLE
            subType = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.SubType.ST_BUS
        else:
            type = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.Type.VEHICLE
            subType = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle.SubType.ST_CAR

        po = modules.perception.proto.perception_obstacle_pb2.PerceptionObstacle(
            id = int(d["Id"]),
            position = self.Convert_Gps_To_Point(d["Gps"]),
            theta = np.deg2rad(90 - d["Heading"]),
            velocity = self.Convert_Vector_To_Point(velocity),
            width = size["x"],
            length = size["y"],
            height = size["z"],
            tracking_time = d["TrackingTime"],
            type = type,
            timestamp = t,
            acceleration = self.Convert_Vector_To_Point(acceleration),
            anchor_point = self.Convert_Gps_To_Point(d["Gps"]),
            sub_type = subType,
        )

        cx = d["Gps"]["Easting"]
        cy = d["Gps"]["Northing"]
        cz = d["Gps"]["Altitude"]
        px = 0.5 * size["x"]
        py = 0.5 * size["y"]
        c = math.cos(np.deg2rad(-d["Heading"]))
        s = math.sin(np.deg2rad(-d["Heading"]))

        p1 = modules.common.proto.geometry_pb2.Point3D(x = -px * c + py * s + cx, y = -px * s - py * c + cy, z = cz)
        p2 = modules.common.proto.geometry_pb2.Point3D(x = px * c + py * s + cx, y = px * s - py * c + cy, z = cz)
        p3 = modules.common.proto.geometry_pb2.Point3D(x = px * c - py * s + cx, y = px * s + py * c + cy, z = cz)
        p4 = modules.common.proto.geometry_pb2.Point3D(x = -px * c - py * s + cx, y = -px * s + py * c + cy, z = cz)

        po.polygon_point.append(p1)
        po.polygon_point.append(p2)
        po.polygon_point.append(p3)
        po.polygon_point.append(p4)

        po.measurements.append(modules.perception.proto.perception_obstacle_pb2.SensorMeasurement(
            sensor_id = "velodyne128",
            id = int(d["Id"]),
            position = self.Convert_Gps_To_Point(d["Gps"]),
            theta = np.deg2rad(90 - d["Heading"]),
            width = size["x"],
            length = size["y"],
            height = size["z"],
            velocity = self.Convert_Vector_To_Point(velocity),
            type = type,
            sub_type = subType,
            timestamp = t,
        ))
        
        return po

    def Convert_To_Prediction_Obstacles(self, data, round):
        obstacles = modules.prediction.proto.prediction_obstacle_pb2.PredictionObstacles(
            header = modules.common.proto.header_pb2.Header(
                timestamp_sec = data["Time"],
                module_name = "prediction",
                sequence_num = data["Sequence"],
                lidar_timestamp = int(data["Time"] * 1e9),
                camera_timestamp = 0,
                radar_timestamp = 0
            ),
            perception_error_code = modules.common.proto.error_code_pb2.ErrorCode.OK,
            start_timestamp = 0,
            end_timestamp = 0
        )

        for d in data["Data"]:
            # Perception Obstacle
            po = self.Convert_To_Perception_Obstacle(d, data["Time"])

            # Trajectory
            traj = modules.prediction.proto.feature_pb2.Trajectory(
                probability = 1
            )
            
            id = d["Id"]
            relative_time = 0.0
            for i in range(80):
                idx = round + i
                if idx >= self.total_round:
                    break
                car = self.get_data_by_id(idx, id)
                if car == None:
                    break
                
                tray_point = modules.common.proto.pnc_point_pb2.TrajectoryPoint(
                    path_point = modules.common.proto.pnc_point_pb2.PathPoint(
                        x = car["Gps"]["Easting"],
                        y = car["Gps"]["Northing"],
                        z = car["Gps"]["Altitude"],
                        theta = np.deg2rad(90 - car["Heading"]),
                        lane_id = ""
                    ),
                    v = math.sqrt(car["Velocity"]["x"]**2 + car["Velocity"]["z"]**2),
                    a = 0,
                    relative_time = relative_time
                )

                traj.trajectory_point.append(tray_point)
                relative_time += 0.1

            preo = modules.prediction.proto.prediction_obstacle_pb2.PredictionObstacle(
                perception_obstacle = po,
                timestamp = data["Time"],
                predicted_period = relative_time,
                trajectory = [traj],
                priority = modules.prediction.proto.feature_pb2.ObstaclePriority(
                    priority = modules.prediction.proto.feature_pb2.ObstaclePriority.Priority.CAUTION
                ),
                is_static = False,
                interactive_tag = modules.prediction.proto.feature_pb2.ObstacleInteractiveTag(
                    interactive_tag = modules.prediction.proto.feature_pb2.ObstacleInteractiveTag.InteractiveTag.NONINTERACTION
                )
            )
            
            obstacles.prediction_obstacle.append(preo)   

        # s = text_format.MessageToString(obstacles)

        return obstacles

    def convert(self):
        v = []
        q = modules.prediction.proto.prediction_obstacle_pb2.PredictionObstaclesQueue()
        for round in range(len(self.GT)):
            detected_3d_object_data = self.GT[round]
            if type(detected_3d_object_data) is dict and detected_3d_object_data != {}:
                obstacles = self.Convert_To_Prediction_Obstacles(detected_3d_object_data, round)
                v.append(obstacles)
                q.obstacles_queue.append(obstacles)

        # with open("output", 'w') as f:
        #     for i in v:
        #         s = text_format.MessageToString(i)
        #         f.write(s)
        
        with open("output", 'wb') as f:
            s = q.SerializeToString()
            f.write(s)



def main():
    with open("foo2.txt", 'r') as f:
        data = f.readlines()

    converter = Converter(data)
    converter.convert()


if __name__ == "__main__":
    main()