import json
import sys, os
import numpy as np
import math

class Converter:
    GT = []
    total_round = 0

    def __init__(self, text):
        self.total_round = len(text)

        for line in text:
            self.GT.append(json.loads(line))
    
    def get_data_by_id(self, idx, id):
        for car in self.GT[idx]["Data"]:
            if car["Id"] == id:
                return car
        return None

    def Convert_To_DetectedPredictionObjectData(self, data, round):

        dpo_list = []

        for d in data["Data"]:
            # Perception Obstacle
            detected3dobject = d

            # Trajectory
            traj = []

            trajectory_point = []
            
            id = d["Id"]
            relative_time = 0.0
            for i in range(80):
                idx = round + i
                if idx >= self.total_round:
                    break
                car = self.get_data_by_id(idx, id)
                if car == None:
                    break
                
                traj_point = dict(
                    path_point = dict(
                        x = car["Gps"]["Easting"],
                        y = car["Gps"]["Northing"],
                        z = car["Gps"]["Altitude"],
                        theta = np.deg2rad(90 - car["Heading"]),
                        lane_id = ""
                    ),
                    v = math.sqrt(car["Velocity"]["x"]**2 + car["Velocity"]["z"]**2),
                    a = 0,
                    relative_time = relative_time
                )

                trajectory_point.append(traj_point)
                relative_time += 0.1

            traj.append(dict(
                probability = 1.0,
                trajectory_point = trajectory_point
            ))

            preo = dict(
                Data = detected3dobject,
                trajectory = traj,
                Intent = "",
                Priority = ""
            )
            
            dpo_list.append(preo)

        dpod = dict(
            Name = "prediction",
            Sequence = data["Sequence"],
            Time = 0,
            Frame = "",
            Data = dpo_list
        )

        return dpod

    def convert(self):
        v = []
        for round in range(len(self.GT)):
            detected_3d_object_data = self.GT[round]
            if type(detected_3d_object_data) is dict and detected_3d_object_data != {}:
                obstacles = self.Convert_To_DetectedPredictionObjectData(detected_3d_object_data, round)
                v.append(obstacles)

        with open("/home/apollo/Build_Local/2021.2-wise/pred.txt", 'w') as f:
            json.dump(v, f)
        os.system("gzip -f /home/apollo/Build_Local/2021.2-wise/pred.txt")

def main():
    with open(sys.argv[1], 'r') as f:
        data = f.readlines()

    converter = Converter(data)
    converter.convert()


if __name__ == "__main__":
    main()
