# import functions to read xml file and visualize commonroad objects
import matplotlib.pyplot as plt
import sys

from commonroad.common.file_reader import CommonRoadFileReader
from commonroad.visualization.mp_renderer import MPRenderer
from commonroad.visualization.draw_params import MPDrawParams
from commonroad_reach.utility.visualization import save_fig, make_gif

# generate path of the file to be opened
file_path = "./scenarios/{}.xml".format(sys.argv[1])

# read in the scenario and planning problem set
scenario, planning_problem_set = CommonRoadFileReader(file_path).open()

# print(scenario.__dict__)
# print(planning_problem_set.__dict__)
# print(type(scenario))
# print(type(planning_problem_set))

# plot the planning problem and the scenario for the fifth time step
for i in range(3):
    plt.figure(figsize=(25, 10))
    rnd = MPRenderer()
    scenario.draw(rnd, draw_params={'time_begin': i})
    planning_problem_set.draw(rnd)
    rnd.render()
    save_fig(True, "/xxxxx/commonroad-reach/output/test", i)