# add root folder to Python interpreter's path
import os
import sys
import time
import pandas as pd
import shutil
# sys.path.append("../")

import commonroad_reach.utility.logger as util_logger
from commonroad_reach.data_structure.configuration_builder import ConfigurationBuilder
from commonroad_reach.data_structure.reach.reach_interface import ReachableSetInterface
from commonroad_reach.utility import visualization as util_visual

def judge_avoidable(name_scenario):
    config = ConfigurationBuilder.build_configuration(name_scenario)
    config.update()
    # config.update(list_ids_lanelets=[25])
    # logger = util_logger.initialize_logger(config)
    # config.print_configuration_summary()
    print("1")
    reach_interface = ReachableSetInterface(config)
    print("2")
    reach_interface.compute_reachable_sets()
    print("3")
    longitudinal_driving_corridors = reach_interface.extract_driving_corridors(to_goal_region=False)
    print("Number of longitudinal driving corridors %s:" % len(longitudinal_driving_corridors))

    return len(longitudinal_driving_corridors) > 0


type_of_data = sys.argv[1]

xml_path = os.path.join("/xxxxx/avoid_xml_output_apollo/", type_of_data)

scenario = sys.argv[2]
if not os.path.isdir(os.path.join(xml_path, scenario)):
    print("scenario not exist")
    exit(0)

print("[+] scenario: {}".format(scenario))
shutil.copy("./configurations/apollo_vehicle.yaml", "./configurations/{}.yaml".format(scenario))

category = sys.argv[3]
if not os.path.isdir(os.path.join(xml_path, scenario, category)):
    print("category not exist")
    exit(0)

print("[++] category: {}".format(category))

file = sys.argv[4] + "-avoid.xml"
print("[+++] seed: {}".format(file))

seed_name = file.split("-avoid")[0]
seed_path = os.path.join(xml_path, scenario, category, file)
print(seed_path)
shutil.copy(seed_path, "./scenarios/{}.xml".format(scenario))

start_time = time.time()
avoidable = judge_avoidable(scenario)
end_time = time.time()

print(avoidable)
