# add root folder to Python interpreter's path
import os
import sys
import time
import pandas as pd
import shutil
# sys.path.append("../")

import commonroad_reach.utility.logger as util_logger
from commonroad_reach.data_structure.configuration_builder import ConfigurationBuilder
from commonroad_reach.data_structure.reach.reach_interface import ReachableSetInterface
from commonroad_reach.utility import visualization as util_visual

def judge_avoidable(name_scenario):
    config = ConfigurationBuilder.build_configuration(name_scenario)
    config.update()
    # logger = util_logger.initialize_logger(config)
    # config.print_configuration_summary()
    reach_interface = ReachableSetInterface(config)
    reach_interface.compute_reachable_sets()
    longitudinal_driving_corridors = reach_interface.extract_driving_corridors(to_goal_region=False)
    print("Number of longitudinal driving corridors %s:" % len(longitudinal_driving_corridors))

    return len(longitudinal_driving_corridors) > 0


type_of_data = sys.argv[1]

results = []
xml_path = os.path.join("/xxxxx/avoid_xml_output_apollo/", type_of_data)

try:
    for scenario in os.listdir(xml_path):
        if not os.path.isdir(os.path.join(xml_path, scenario)):
            continue

        print("[+] scenario: {}".format(scenario))
        shutil.copy("/xxxxx/commonroad-reach/configurations/apollo_vehicle.yaml", "/xxxxx/commonroad-reach/configurations/{}.yaml".format(scenario))

        for category in os.listdir(os.path.join(xml_path, scenario)):
            if not os.path.isdir(os.path.join(xml_path, scenario, category)):
                continue

            print("[++] category: {}".format(category))

            for file in os.listdir(os.path.join(xml_path, scenario, category)):
                # if file != "origin-avoid.xml":
                #     continue
                print("[+++] seed: {}".format(file))

                seed_name = file.split("-avoid")[0]
                # if seed_name == "5afd60ee87ee259707c4bc2ff6014cc4":
                #     continue
                seed_path = os.path.join(xml_path, scenario, category, file)
                shutil.copy(seed_path, "/xxxxx/commonroad-reach/scenarios/{}.xml".format(scenario))

                try:
                    start_time = time.time()
                    avoidable = judge_avoidable(scenario)
                    end_time = time.time()
                except Exception as e:
                    print(e)
                    results.append([scenario, category, seed_name, -1, -1])
                else:
                    results.append([scenario, category, seed_name, 1 if avoidable else 0, end_time-start_time])
except Exception as e:
    print(e)
    print(len(results))

df = pd.DataFrame(results, columns=["Scenario", "Category", "Seed", "Avoidable", "Time Cost"])
df.to_csv("apollo_" + type_of_data + ".csv")


